// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/discoveryengine/v1/site_search_engine_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DISCOVERYENGINE_V1_SITE_SEARCH_ENGINE_CONNECTION_IDEMPOTENCY_POLICY_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DISCOVERYENGINE_V1_SITE_SEARCH_ENGINE_CONNECTION_IDEMPOTENCY_POLICY_H

#include "google/cloud/idempotency.h"
#include "google/cloud/version.h"
#include <google/cloud/discoveryengine/v1/site_search_engine_service.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace discoveryengine_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class SiteSearchEngineServiceConnectionIdempotencyPolicy {
 public:
  virtual ~SiteSearchEngineServiceConnectionIdempotencyPolicy();

  /// Create a new copy of this object.
  virtual std::unique_ptr<SiteSearchEngineServiceConnectionIdempotencyPolicy>
  clone() const;

  virtual google::cloud::Idempotency GetSiteSearchEngine(
      google::cloud::discoveryengine::v1::GetSiteSearchEngineRequest const&
          request);

  virtual google::cloud::Idempotency CreateTargetSite(
      google::cloud::discoveryengine::v1::CreateTargetSiteRequest const&
          request);

  virtual google::cloud::Idempotency BatchCreateTargetSites(
      google::cloud::discoveryengine::v1::BatchCreateTargetSitesRequest const&
          request);

  virtual google::cloud::Idempotency GetTargetSite(
      google::cloud::discoveryengine::v1::GetTargetSiteRequest const& request);

  virtual google::cloud::Idempotency UpdateTargetSite(
      google::cloud::discoveryengine::v1::UpdateTargetSiteRequest const&
          request);

  virtual google::cloud::Idempotency DeleteTargetSite(
      google::cloud::discoveryengine::v1::DeleteTargetSiteRequest const&
          request);

  virtual google::cloud::Idempotency ListTargetSites(
      google::cloud::discoveryengine::v1::ListTargetSitesRequest request);

  virtual google::cloud::Idempotency EnableAdvancedSiteSearch(
      google::cloud::discoveryengine::v1::EnableAdvancedSiteSearchRequest const&
          request);

  virtual google::cloud::Idempotency DisableAdvancedSiteSearch(
      google::cloud::discoveryengine::v1::
          DisableAdvancedSiteSearchRequest const& request);

  virtual google::cloud::Idempotency RecrawlUris(
      google::cloud::discoveryengine::v1::RecrawlUrisRequest const& request);

  virtual google::cloud::Idempotency BatchVerifyTargetSites(
      google::cloud::discoveryengine::v1::BatchVerifyTargetSitesRequest const&
          request);

  virtual google::cloud::Idempotency FetchDomainVerificationStatus(
      google::cloud::discoveryengine::v1::FetchDomainVerificationStatusRequest
          request);
};

std::unique_ptr<SiteSearchEngineServiceConnectionIdempotencyPolicy>
MakeDefaultSiteSearchEngineServiceConnectionIdempotencyPolicy();

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace discoveryengine_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DISCOVERYENGINE_V1_SITE_SEARCH_ENGINE_CONNECTION_IDEMPOTENCY_POLICY_H
