// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/edgenetwork/v1/service.proto

#include "google/cloud/edgenetwork/v1/internal/edge_network_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace edgenetwork_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

EdgeNetworkTracingConnection::EdgeNetworkTracingConnection(
    std::shared_ptr<edgenetwork_v1::EdgeNetworkConnection> child)
    : child_(std::move(child)) {}

StatusOr<google::cloud::edgenetwork::v1::InitializeZoneResponse>
EdgeNetworkTracingConnection::InitializeZone(
    google::cloud::edgenetwork::v1::InitializeZoneRequest const& request) {
  auto span = internal::MakeSpan(
      "edgenetwork_v1::EdgeNetworkConnection::InitializeZone");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->InitializeZone(request));
}

StreamRange<google::cloud::edgenetwork::v1::Zone>
EdgeNetworkTracingConnection::ListZones(
    google::cloud::edgenetwork::v1::ListZonesRequest request) {
  auto span =
      internal::MakeSpan("edgenetwork_v1::EdgeNetworkConnection::ListZones");
  internal::OTelScope scope(span);
  auto sr = child_->ListZones(std::move(request));
  return internal::MakeTracedStreamRange<google::cloud::edgenetwork::v1::Zone>(
      std::move(span), std::move(sr));
}

StatusOr<google::cloud::edgenetwork::v1::Zone>
EdgeNetworkTracingConnection::GetZone(
    google::cloud::edgenetwork::v1::GetZoneRequest const& request) {
  auto span =
      internal::MakeSpan("edgenetwork_v1::EdgeNetworkConnection::GetZone");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetZone(request));
}

StreamRange<google::cloud::edgenetwork::v1::Network>
EdgeNetworkTracingConnection::ListNetworks(
    google::cloud::edgenetwork::v1::ListNetworksRequest request) {
  auto span =
      internal::MakeSpan("edgenetwork_v1::EdgeNetworkConnection::ListNetworks");
  internal::OTelScope scope(span);
  auto sr = child_->ListNetworks(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::edgenetwork::v1::Network>(std::move(span), std::move(sr));
}

StatusOr<google::cloud::edgenetwork::v1::Network>
EdgeNetworkTracingConnection::GetNetwork(
    google::cloud::edgenetwork::v1::GetNetworkRequest const& request) {
  auto span =
      internal::MakeSpan("edgenetwork_v1::EdgeNetworkConnection::GetNetwork");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetNetwork(request));
}

StatusOr<google::cloud::edgenetwork::v1::DiagnoseNetworkResponse>
EdgeNetworkTracingConnection::DiagnoseNetwork(
    google::cloud::edgenetwork::v1::DiagnoseNetworkRequest const& request) {
  auto span = internal::MakeSpan(
      "edgenetwork_v1::EdgeNetworkConnection::DiagnoseNetwork");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->DiagnoseNetwork(request));
}

future<StatusOr<google::cloud::edgenetwork::v1::Network>>
EdgeNetworkTracingConnection::CreateNetwork(
    google::cloud::edgenetwork::v1::CreateNetworkRequest const& request) {
  auto span = internal::MakeSpan(
      "edgenetwork_v1::EdgeNetworkConnection::CreateNetwork");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateNetwork(request));
}

StatusOr<google::longrunning::Operation>
EdgeNetworkTracingConnection::CreateNetwork(
    NoAwaitTag,
    google::cloud::edgenetwork::v1::CreateNetworkRequest const& request) {
  auto span = internal::MakeSpan(
      "edgenetwork_v1::EdgeNetworkConnection::CreateNetwork");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->CreateNetwork(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::edgenetwork::v1::Network>>
EdgeNetworkTracingConnection::CreateNetwork(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "edgenetwork_v1::EdgeNetworkConnection::CreateNetwork");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateNetwork(operation));
}

future<StatusOr<google::cloud::edgenetwork::v1::OperationMetadata>>
EdgeNetworkTracingConnection::DeleteNetwork(
    google::cloud::edgenetwork::v1::DeleteNetworkRequest const& request) {
  auto span = internal::MakeSpan(
      "edgenetwork_v1::EdgeNetworkConnection::DeleteNetwork");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteNetwork(request));
}

StatusOr<google::longrunning::Operation>
EdgeNetworkTracingConnection::DeleteNetwork(
    NoAwaitTag,
    google::cloud::edgenetwork::v1::DeleteNetworkRequest const& request) {
  auto span = internal::MakeSpan(
      "edgenetwork_v1::EdgeNetworkConnection::DeleteNetwork");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->DeleteNetwork(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::edgenetwork::v1::OperationMetadata>>
EdgeNetworkTracingConnection::DeleteNetwork(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "edgenetwork_v1::EdgeNetworkConnection::DeleteNetwork");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteNetwork(operation));
}

StreamRange<google::cloud::edgenetwork::v1::Subnet>
EdgeNetworkTracingConnection::ListSubnets(
    google::cloud::edgenetwork::v1::ListSubnetsRequest request) {
  auto span =
      internal::MakeSpan("edgenetwork_v1::EdgeNetworkConnection::ListSubnets");
  internal::OTelScope scope(span);
  auto sr = child_->ListSubnets(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::edgenetwork::v1::Subnet>(std::move(span), std::move(sr));
}

StatusOr<google::cloud::edgenetwork::v1::Subnet>
EdgeNetworkTracingConnection::GetSubnet(
    google::cloud::edgenetwork::v1::GetSubnetRequest const& request) {
  auto span =
      internal::MakeSpan("edgenetwork_v1::EdgeNetworkConnection::GetSubnet");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetSubnet(request));
}

future<StatusOr<google::cloud::edgenetwork::v1::Subnet>>
EdgeNetworkTracingConnection::CreateSubnet(
    google::cloud::edgenetwork::v1::CreateSubnetRequest const& request) {
  auto span =
      internal::MakeSpan("edgenetwork_v1::EdgeNetworkConnection::CreateSubnet");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateSubnet(request));
}

StatusOr<google::longrunning::Operation>
EdgeNetworkTracingConnection::CreateSubnet(
    NoAwaitTag,
    google::cloud::edgenetwork::v1::CreateSubnetRequest const& request) {
  auto span =
      internal::MakeSpan("edgenetwork_v1::EdgeNetworkConnection::CreateSubnet");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->CreateSubnet(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::edgenetwork::v1::Subnet>>
EdgeNetworkTracingConnection::CreateSubnet(
    google::longrunning::Operation const& operation) {
  auto span =
      internal::MakeSpan("edgenetwork_v1::EdgeNetworkConnection::CreateSubnet");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateSubnet(operation));
}

future<StatusOr<google::cloud::edgenetwork::v1::Subnet>>
EdgeNetworkTracingConnection::UpdateSubnet(
    google::cloud::edgenetwork::v1::UpdateSubnetRequest const& request) {
  auto span =
      internal::MakeSpan("edgenetwork_v1::EdgeNetworkConnection::UpdateSubnet");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateSubnet(request));
}

StatusOr<google::longrunning::Operation>
EdgeNetworkTracingConnection::UpdateSubnet(
    NoAwaitTag,
    google::cloud::edgenetwork::v1::UpdateSubnetRequest const& request) {
  auto span =
      internal::MakeSpan("edgenetwork_v1::EdgeNetworkConnection::UpdateSubnet");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->UpdateSubnet(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::edgenetwork::v1::Subnet>>
EdgeNetworkTracingConnection::UpdateSubnet(
    google::longrunning::Operation const& operation) {
  auto span =
      internal::MakeSpan("edgenetwork_v1::EdgeNetworkConnection::UpdateSubnet");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateSubnet(operation));
}

future<StatusOr<google::cloud::edgenetwork::v1::OperationMetadata>>
EdgeNetworkTracingConnection::DeleteSubnet(
    google::cloud::edgenetwork::v1::DeleteSubnetRequest const& request) {
  auto span =
      internal::MakeSpan("edgenetwork_v1::EdgeNetworkConnection::DeleteSubnet");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteSubnet(request));
}

StatusOr<google::longrunning::Operation>
EdgeNetworkTracingConnection::DeleteSubnet(
    NoAwaitTag,
    google::cloud::edgenetwork::v1::DeleteSubnetRequest const& request) {
  auto span =
      internal::MakeSpan("edgenetwork_v1::EdgeNetworkConnection::DeleteSubnet");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->DeleteSubnet(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::edgenetwork::v1::OperationMetadata>>
EdgeNetworkTracingConnection::DeleteSubnet(
    google::longrunning::Operation const& operation) {
  auto span =
      internal::MakeSpan("edgenetwork_v1::EdgeNetworkConnection::DeleteSubnet");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteSubnet(operation));
}

StreamRange<google::cloud::edgenetwork::v1::Interconnect>
EdgeNetworkTracingConnection::ListInterconnects(
    google::cloud::edgenetwork::v1::ListInterconnectsRequest request) {
  auto span = internal::MakeSpan(
      "edgenetwork_v1::EdgeNetworkConnection::ListInterconnects");
  internal::OTelScope scope(span);
  auto sr = child_->ListInterconnects(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::edgenetwork::v1::Interconnect>(std::move(span),
                                                    std::move(sr));
}

StatusOr<google::cloud::edgenetwork::v1::Interconnect>
EdgeNetworkTracingConnection::GetInterconnect(
    google::cloud::edgenetwork::v1::GetInterconnectRequest const& request) {
  auto span = internal::MakeSpan(
      "edgenetwork_v1::EdgeNetworkConnection::GetInterconnect");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetInterconnect(request));
}

StatusOr<google::cloud::edgenetwork::v1::DiagnoseInterconnectResponse>
EdgeNetworkTracingConnection::DiagnoseInterconnect(
    google::cloud::edgenetwork::v1::DiagnoseInterconnectRequest const&
        request) {
  auto span = internal::MakeSpan(
      "edgenetwork_v1::EdgeNetworkConnection::DiagnoseInterconnect");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->DiagnoseInterconnect(request));
}

StreamRange<google::cloud::edgenetwork::v1::InterconnectAttachment>
EdgeNetworkTracingConnection::ListInterconnectAttachments(
    google::cloud::edgenetwork::v1::ListInterconnectAttachmentsRequest
        request) {
  auto span = internal::MakeSpan(
      "edgenetwork_v1::EdgeNetworkConnection::ListInterconnectAttachments");
  internal::OTelScope scope(span);
  auto sr = child_->ListInterconnectAttachments(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::edgenetwork::v1::InterconnectAttachment>(std::move(span),
                                                              std::move(sr));
}

StatusOr<google::cloud::edgenetwork::v1::InterconnectAttachment>
EdgeNetworkTracingConnection::GetInterconnectAttachment(
    google::cloud::edgenetwork::v1::GetInterconnectAttachmentRequest const&
        request) {
  auto span = internal::MakeSpan(
      "edgenetwork_v1::EdgeNetworkConnection::GetInterconnectAttachment");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetInterconnectAttachment(request));
}

future<StatusOr<google::cloud::edgenetwork::v1::InterconnectAttachment>>
EdgeNetworkTracingConnection::CreateInterconnectAttachment(
    google::cloud::edgenetwork::v1::CreateInterconnectAttachmentRequest const&
        request) {
  auto span = internal::MakeSpan(
      "edgenetwork_v1::EdgeNetworkConnection::CreateInterconnectAttachment");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->CreateInterconnectAttachment(request));
}

StatusOr<google::longrunning::Operation>
EdgeNetworkTracingConnection::CreateInterconnectAttachment(
    NoAwaitTag,
    google::cloud::edgenetwork::v1::CreateInterconnectAttachmentRequest const&
        request) {
  auto span = internal::MakeSpan(
      "edgenetwork_v1::EdgeNetworkConnection::CreateInterconnectAttachment");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(
      *span, child_->CreateInterconnectAttachment(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::edgenetwork::v1::InterconnectAttachment>>
EdgeNetworkTracingConnection::CreateInterconnectAttachment(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "edgenetwork_v1::EdgeNetworkConnection::CreateInterconnectAttachment");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->CreateInterconnectAttachment(operation));
}

future<StatusOr<google::cloud::edgenetwork::v1::OperationMetadata>>
EdgeNetworkTracingConnection::DeleteInterconnectAttachment(
    google::cloud::edgenetwork::v1::DeleteInterconnectAttachmentRequest const&
        request) {
  auto span = internal::MakeSpan(
      "edgenetwork_v1::EdgeNetworkConnection::DeleteInterconnectAttachment");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->DeleteInterconnectAttachment(request));
}

StatusOr<google::longrunning::Operation>
EdgeNetworkTracingConnection::DeleteInterconnectAttachment(
    NoAwaitTag,
    google::cloud::edgenetwork::v1::DeleteInterconnectAttachmentRequest const&
        request) {
  auto span = internal::MakeSpan(
      "edgenetwork_v1::EdgeNetworkConnection::DeleteInterconnectAttachment");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(
      *span, child_->DeleteInterconnectAttachment(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::edgenetwork::v1::OperationMetadata>>
EdgeNetworkTracingConnection::DeleteInterconnectAttachment(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "edgenetwork_v1::EdgeNetworkConnection::DeleteInterconnectAttachment");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->DeleteInterconnectAttachment(operation));
}

StreamRange<google::cloud::edgenetwork::v1::Router>
EdgeNetworkTracingConnection::ListRouters(
    google::cloud::edgenetwork::v1::ListRoutersRequest request) {
  auto span =
      internal::MakeSpan("edgenetwork_v1::EdgeNetworkConnection::ListRouters");
  internal::OTelScope scope(span);
  auto sr = child_->ListRouters(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::edgenetwork::v1::Router>(std::move(span), std::move(sr));
}

StatusOr<google::cloud::edgenetwork::v1::Router>
EdgeNetworkTracingConnection::GetRouter(
    google::cloud::edgenetwork::v1::GetRouterRequest const& request) {
  auto span =
      internal::MakeSpan("edgenetwork_v1::EdgeNetworkConnection::GetRouter");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetRouter(request));
}

StatusOr<google::cloud::edgenetwork::v1::DiagnoseRouterResponse>
EdgeNetworkTracingConnection::DiagnoseRouter(
    google::cloud::edgenetwork::v1::DiagnoseRouterRequest const& request) {
  auto span = internal::MakeSpan(
      "edgenetwork_v1::EdgeNetworkConnection::DiagnoseRouter");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->DiagnoseRouter(request));
}

future<StatusOr<google::cloud::edgenetwork::v1::Router>>
EdgeNetworkTracingConnection::CreateRouter(
    google::cloud::edgenetwork::v1::CreateRouterRequest const& request) {
  auto span =
      internal::MakeSpan("edgenetwork_v1::EdgeNetworkConnection::CreateRouter");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateRouter(request));
}

StatusOr<google::longrunning::Operation>
EdgeNetworkTracingConnection::CreateRouter(
    NoAwaitTag,
    google::cloud::edgenetwork::v1::CreateRouterRequest const& request) {
  auto span =
      internal::MakeSpan("edgenetwork_v1::EdgeNetworkConnection::CreateRouter");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->CreateRouter(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::edgenetwork::v1::Router>>
EdgeNetworkTracingConnection::CreateRouter(
    google::longrunning::Operation const& operation) {
  auto span =
      internal::MakeSpan("edgenetwork_v1::EdgeNetworkConnection::CreateRouter");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateRouter(operation));
}

future<StatusOr<google::cloud::edgenetwork::v1::Router>>
EdgeNetworkTracingConnection::UpdateRouter(
    google::cloud::edgenetwork::v1::UpdateRouterRequest const& request) {
  auto span =
      internal::MakeSpan("edgenetwork_v1::EdgeNetworkConnection::UpdateRouter");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateRouter(request));
}

StatusOr<google::longrunning::Operation>
EdgeNetworkTracingConnection::UpdateRouter(
    NoAwaitTag,
    google::cloud::edgenetwork::v1::UpdateRouterRequest const& request) {
  auto span =
      internal::MakeSpan("edgenetwork_v1::EdgeNetworkConnection::UpdateRouter");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->UpdateRouter(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::edgenetwork::v1::Router>>
EdgeNetworkTracingConnection::UpdateRouter(
    google::longrunning::Operation const& operation) {
  auto span =
      internal::MakeSpan("edgenetwork_v1::EdgeNetworkConnection::UpdateRouter");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateRouter(operation));
}

future<StatusOr<google::cloud::edgenetwork::v1::OperationMetadata>>
EdgeNetworkTracingConnection::DeleteRouter(
    google::cloud::edgenetwork::v1::DeleteRouterRequest const& request) {
  auto span =
      internal::MakeSpan("edgenetwork_v1::EdgeNetworkConnection::DeleteRouter");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteRouter(request));
}

StatusOr<google::longrunning::Operation>
EdgeNetworkTracingConnection::DeleteRouter(
    NoAwaitTag,
    google::cloud::edgenetwork::v1::DeleteRouterRequest const& request) {
  auto span =
      internal::MakeSpan("edgenetwork_v1::EdgeNetworkConnection::DeleteRouter");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->DeleteRouter(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::edgenetwork::v1::OperationMetadata>>
EdgeNetworkTracingConnection::DeleteRouter(
    google::longrunning::Operation const& operation) {
  auto span =
      internal::MakeSpan("edgenetwork_v1::EdgeNetworkConnection::DeleteRouter");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteRouter(operation));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<edgenetwork_v1::EdgeNetworkConnection>
MakeEdgeNetworkTracingConnection(
    std::shared_ptr<edgenetwork_v1::EdgeNetworkConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<EdgeNetworkTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace edgenetwork_v1_internal
}  // namespace cloud
}  // namespace google
