// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/gkehub/v1/service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_GKEHUB_V1_INTERNAL_GKE_HUB_TRACING_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_GKEHUB_V1_INTERNAL_GKE_HUB_TRACING_CONNECTION_H

#include "google/cloud/gkehub/v1/gke_hub_connection.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace gkehub_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

class GkeHubTracingConnection : public gkehub_v1::GkeHubConnection {
 public:
  ~GkeHubTracingConnection() override = default;

  explicit GkeHubTracingConnection(
      std::shared_ptr<gkehub_v1::GkeHubConnection> child);

  Options options() override { return child_->options(); }

  StreamRange<google::cloud::gkehub::v1::Membership> ListMemberships(
      google::cloud::gkehub::v1::ListMembershipsRequest request) override;

  StreamRange<google::cloud::gkehub::v1::Feature> ListFeatures(
      google::cloud::gkehub::v1::ListFeaturesRequest request) override;

  StatusOr<google::cloud::gkehub::v1::Membership> GetMembership(
      google::cloud::gkehub::v1::GetMembershipRequest const& request) override;

  StatusOr<google::cloud::gkehub::v1::Feature> GetFeature(
      google::cloud::gkehub::v1::GetFeatureRequest const& request) override;

  future<StatusOr<google::cloud::gkehub::v1::Membership>> CreateMembership(
      google::cloud::gkehub::v1::CreateMembershipRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> CreateMembership(
      NoAwaitTag,
      google::cloud::gkehub::v1::CreateMembershipRequest const& request)
      override;

  future<StatusOr<google::cloud::gkehub::v1::Membership>> CreateMembership(
      google::longrunning::Operation const& operation) override;

  future<StatusOr<google::cloud::gkehub::v1::Feature>> CreateFeature(
      google::cloud::gkehub::v1::CreateFeatureRequest const& request) override;

  StatusOr<google::longrunning::Operation> CreateFeature(
      NoAwaitTag,
      google::cloud::gkehub::v1::CreateFeatureRequest const& request) override;

  future<StatusOr<google::cloud::gkehub::v1::Feature>> CreateFeature(
      google::longrunning::Operation const& operation) override;

  future<StatusOr<google::cloud::gkehub::v1::OperationMetadata>>
  DeleteMembership(google::cloud::gkehub::v1::DeleteMembershipRequest const&
                       request) override;

  StatusOr<google::longrunning::Operation> DeleteMembership(
      NoAwaitTag,
      google::cloud::gkehub::v1::DeleteMembershipRequest const& request)
      override;

  future<StatusOr<google::cloud::gkehub::v1::OperationMetadata>>
  DeleteMembership(google::longrunning::Operation const& operation) override;

  future<StatusOr<google::cloud::gkehub::v1::OperationMetadata>> DeleteFeature(
      google::cloud::gkehub::v1::DeleteFeatureRequest const& request) override;

  StatusOr<google::longrunning::Operation> DeleteFeature(
      NoAwaitTag,
      google::cloud::gkehub::v1::DeleteFeatureRequest const& request) override;

  future<StatusOr<google::cloud::gkehub::v1::OperationMetadata>> DeleteFeature(
      google::longrunning::Operation const& operation) override;

  future<StatusOr<google::cloud::gkehub::v1::Membership>> UpdateMembership(
      google::cloud::gkehub::v1::UpdateMembershipRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> UpdateMembership(
      NoAwaitTag,
      google::cloud::gkehub::v1::UpdateMembershipRequest const& request)
      override;

  future<StatusOr<google::cloud::gkehub::v1::Membership>> UpdateMembership(
      google::longrunning::Operation const& operation) override;

  future<StatusOr<google::cloud::gkehub::v1::Feature>> UpdateFeature(
      google::cloud::gkehub::v1::UpdateFeatureRequest const& request) override;

  StatusOr<google::longrunning::Operation> UpdateFeature(
      NoAwaitTag,
      google::cloud::gkehub::v1::UpdateFeatureRequest const& request) override;

  future<StatusOr<google::cloud::gkehub::v1::Feature>> UpdateFeature(
      google::longrunning::Operation const& operation) override;

  StatusOr<google::cloud::gkehub::v1::GenerateConnectManifestResponse>
  GenerateConnectManifest(
      google::cloud::gkehub::v1::GenerateConnectManifestRequest const& request)
      override;

 private:
  std::shared_ptr<gkehub_v1::GkeHubConnection> child_;
};

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

/**
 * Conditionally applies the tracing decorator to the given connection.
 *
 * The connection is only decorated if tracing is enabled (as determined by the
 * connection's options).
 */
std::shared_ptr<gkehub_v1::GkeHubConnection> MakeGkeHubTracingConnection(
    std::shared_ptr<gkehub_v1::GkeHubConnection> conn);

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace gkehub_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_GKEHUB_V1_INTERNAL_GKE_HUB_TRACING_CONNECTION_H
