// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/networkmanagement/v1/reachability.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_NETWORKMANAGEMENT_V1_INTERNAL_REACHABILITY_TRACING_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_NETWORKMANAGEMENT_V1_INTERNAL_REACHABILITY_TRACING_CONNECTION_H

#include "google/cloud/networkmanagement/v1/reachability_connection.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace networkmanagement_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

class ReachabilityServiceTracingConnection
    : public networkmanagement_v1::ReachabilityServiceConnection {
 public:
  ~ReachabilityServiceTracingConnection() override = default;

  explicit ReachabilityServiceTracingConnection(
      std::shared_ptr<networkmanagement_v1::ReachabilityServiceConnection>
          child);

  Options options() override { return child_->options(); }

  StreamRange<google::cloud::networkmanagement::v1::ConnectivityTest>
  ListConnectivityTests(
      google::cloud::networkmanagement::v1::ListConnectivityTestsRequest
          request) override;

  StatusOr<google::cloud::networkmanagement::v1::ConnectivityTest>
  GetConnectivityTest(
      google::cloud::networkmanagement::v1::GetConnectivityTestRequest const&
          request) override;

  future<StatusOr<google::cloud::networkmanagement::v1::ConnectivityTest>>
  CreateConnectivityTest(
      google::cloud::networkmanagement::v1::CreateConnectivityTestRequest const&
          request) override;

  StatusOr<google::longrunning::Operation> CreateConnectivityTest(
      NoAwaitTag,
      google::cloud::networkmanagement::v1::CreateConnectivityTestRequest const&
          request) override;

  future<StatusOr<google::cloud::networkmanagement::v1::ConnectivityTest>>
  CreateConnectivityTest(
      google::longrunning::Operation const& operation) override;

  future<StatusOr<google::cloud::networkmanagement::v1::ConnectivityTest>>
  UpdateConnectivityTest(
      google::cloud::networkmanagement::v1::UpdateConnectivityTestRequest const&
          request) override;

  StatusOr<google::longrunning::Operation> UpdateConnectivityTest(
      NoAwaitTag,
      google::cloud::networkmanagement::v1::UpdateConnectivityTestRequest const&
          request) override;

  future<StatusOr<google::cloud::networkmanagement::v1::ConnectivityTest>>
  UpdateConnectivityTest(
      google::longrunning::Operation const& operation) override;

  future<StatusOr<google::cloud::networkmanagement::v1::ConnectivityTest>>
  RerunConnectivityTest(
      google::cloud::networkmanagement::v1::RerunConnectivityTestRequest const&
          request) override;

  StatusOr<google::longrunning::Operation> RerunConnectivityTest(
      NoAwaitTag,
      google::cloud::networkmanagement::v1::RerunConnectivityTestRequest const&
          request) override;

  future<StatusOr<google::cloud::networkmanagement::v1::ConnectivityTest>>
  RerunConnectivityTest(
      google::longrunning::Operation const& operation) override;

  future<StatusOr<google::cloud::networkmanagement::v1::OperationMetadata>>
  DeleteConnectivityTest(
      google::cloud::networkmanagement::v1::DeleteConnectivityTestRequest const&
          request) override;

  StatusOr<google::longrunning::Operation> DeleteConnectivityTest(
      NoAwaitTag,
      google::cloud::networkmanagement::v1::DeleteConnectivityTestRequest const&
          request) override;

  future<StatusOr<google::cloud::networkmanagement::v1::OperationMetadata>>
  DeleteConnectivityTest(
      google::longrunning::Operation const& operation) override;

 private:
  std::shared_ptr<networkmanagement_v1::ReachabilityServiceConnection> child_;
};

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

/**
 * Conditionally applies the tracing decorator to the given connection.
 *
 * The connection is only decorated if tracing is enabled (as determined by the
 * connection's options).
 */
std::shared_ptr<networkmanagement_v1::ReachabilityServiceConnection>
MakeReachabilityServiceTracingConnection(
    std::shared_ptr<networkmanagement_v1::ReachabilityServiceConnection> conn);

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace networkmanagement_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_NETWORKMANAGEMENT_V1_INTERNAL_REACHABILITY_TRACING_CONNECTION_H
