// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/timeseriesinsights/v1/timeseries_insights.proto

#include "google/cloud/timeseriesinsights/v1/internal/timeseries_insights_controller_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace timeseriesinsights_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

TimeseriesInsightsControllerTracingConnection::
    TimeseriesInsightsControllerTracingConnection(
        std::shared_ptr<
            timeseriesinsights_v1::TimeseriesInsightsControllerConnection>
            child)
    : child_(std::move(child)) {}

StreamRange<google::cloud::timeseriesinsights::v1::DataSet>
TimeseriesInsightsControllerTracingConnection::ListDataSets(
    google::cloud::timeseriesinsights::v1::ListDataSetsRequest request) {
  auto span = internal::MakeSpan(
      "timeseriesinsights_v1::TimeseriesInsightsControllerConnection::"
      "ListDataSets");
  internal::OTelScope scope(span);
  auto sr = child_->ListDataSets(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::timeseriesinsights::v1::DataSet>(std::move(span),
                                                      std::move(sr));
}

StatusOr<google::cloud::timeseriesinsights::v1::DataSet>
TimeseriesInsightsControllerTracingConnection::CreateDataSet(
    google::cloud::timeseriesinsights::v1::CreateDataSetRequest const&
        request) {
  auto span = internal::MakeSpan(
      "timeseriesinsights_v1::TimeseriesInsightsControllerConnection::"
      "CreateDataSet");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->CreateDataSet(request));
}

Status TimeseriesInsightsControllerTracingConnection::DeleteDataSet(
    google::cloud::timeseriesinsights::v1::DeleteDataSetRequest const&
        request) {
  auto span = internal::MakeSpan(
      "timeseriesinsights_v1::TimeseriesInsightsControllerConnection::"
      "DeleteDataSet");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->DeleteDataSet(request));
}

StatusOr<google::cloud::timeseriesinsights::v1::AppendEventsResponse>
TimeseriesInsightsControllerTracingConnection::AppendEvents(
    google::cloud::timeseriesinsights::v1::AppendEventsRequest const& request) {
  auto span = internal::MakeSpan(
      "timeseriesinsights_v1::TimeseriesInsightsControllerConnection::"
      "AppendEvents");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->AppendEvents(request));
}

StatusOr<google::cloud::timeseriesinsights::v1::QueryDataSetResponse>
TimeseriesInsightsControllerTracingConnection::QueryDataSet(
    google::cloud::timeseriesinsights::v1::QueryDataSetRequest const& request) {
  auto span = internal::MakeSpan(
      "timeseriesinsights_v1::TimeseriesInsightsControllerConnection::"
      "QueryDataSet");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->QueryDataSet(request));
}

StatusOr<google::cloud::timeseriesinsights::v1::EvaluatedSlice>
TimeseriesInsightsControllerTracingConnection::EvaluateSlice(
    google::cloud::timeseriesinsights::v1::EvaluateSliceRequest const&
        request) {
  auto span = internal::MakeSpan(
      "timeseriesinsights_v1::TimeseriesInsightsControllerConnection::"
      "EvaluateSlice");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->EvaluateSlice(request));
}

StatusOr<google::cloud::timeseriesinsights::v1::EvaluatedSlice>
TimeseriesInsightsControllerTracingConnection::EvaluateTimeseries(
    google::cloud::timeseriesinsights::v1::EvaluateTimeseriesRequest const&
        request) {
  auto span = internal::MakeSpan(
      "timeseriesinsights_v1::TimeseriesInsightsControllerConnection::"
      "EvaluateTimeseries");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->EvaluateTimeseries(request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<timeseriesinsights_v1::TimeseriesInsightsControllerConnection>
MakeTimeseriesInsightsControllerTracingConnection(
    std::shared_ptr<
        timeseriesinsights_v1::TimeseriesInsightsControllerConnection>
        conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<TimeseriesInsightsControllerTracingConnection>(
        std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace timeseriesinsights_v1_internal
}  // namespace cloud
}  // namespace google
