/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class SqlClearCursorResponse
extends ActionResponse
implements ToXContentObject {
    private boolean succeeded;

    public SqlClearCursorResponse(boolean succeeded) {
        this.succeeded = succeeded;
    }

    SqlClearCursorResponse(StreamInput in) throws IOException {
        super(in);
        this.succeeded = in.readBoolean();
    }

    public boolean isSucceeded() {
        return this.succeeded;
    }

    public SqlClearCursorResponse setSucceeded(boolean succeeded) {
        this.succeeded = succeeded;
        return this;
    }

    public RestStatus status() {
        return this.succeeded ? RestStatus.NOT_FOUND : RestStatus.OK;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("succeeded", this.succeeded);
        builder.endObject();
        return builder;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeBoolean(this.succeeded);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        SqlClearCursorResponse response = (SqlClearCursorResponse)((Object)o);
        return this.succeeded == response.succeeded;
    }

    public int hashCode() {
        return Objects.hash(this.succeeded);
    }
}

