/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.aggregations.bucket.timeseries;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.PriorityQueue;
import org.elasticsearch.aggregations.bucket.timeseries.TimeSeriesAggregationBuilder;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.mapper.RoutingPathFields;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.AggregationReduceContext;
import org.elasticsearch.search.aggregations.AggregatorReducer;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.InternalMultiBucketAggregation;
import org.elasticsearch.search.aggregations.bucket.IteratorAndCurrent;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class InternalTimeSeries
extends InternalMultiBucketAggregation<InternalTimeSeries, InternalBucket> {
    private final List<InternalBucket> buckets;
    private final boolean keyed;
    private transient Map<String, InternalBucket> bucketMap;

    public InternalTimeSeries(String name, List<InternalBucket> buckets, boolean keyed, Map<String, Object> metadata) {
        super(name, metadata);
        this.buckets = buckets;
        this.keyed = keyed;
    }

    public InternalTimeSeries(StreamInput in) throws IOException {
        super(in);
        this.keyed = in.readBoolean();
        int size = in.readVInt();
        ArrayList<InternalBucket> buckets = new ArrayList<InternalBucket>(size);
        for (int i = 0; i < size; ++i) {
            buckets.add(new InternalBucket(in));
        }
        this.buckets = buckets;
        this.bucketMap = null;
    }

    public String getWriteableName() {
        return "time_series";
    }

    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.keyed) {
            builder.startObject(Aggregation.CommonFields.BUCKETS.getPreferredName());
        } else {
            builder.startArray(Aggregation.CommonFields.BUCKETS.getPreferredName());
        }
        for (InternalBucket bucket : this.buckets) {
            bucket.bucketToXContent(builder, params, this.keyed);
        }
        if (this.keyed) {
            builder.endObject();
        } else {
            builder.endArray();
        }
        return builder;
    }

    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeBoolean(this.keyed);
        out.writeCollection(this.buckets);
    }

    protected AggregatorReducer getLeaderReducer(AggregationReduceContext reduceContext, int size) {
        PriorityQueue<IteratorAndCurrent<InternalBucket>> pq = new PriorityQueue<IteratorAndCurrent<InternalBucket>>(size){

            protected boolean lessThan(IteratorAndCurrent<InternalBucket> a, IteratorAndCurrent<InternalBucket> b) {
                return ((InternalBucket)a.current()).key.compareTo(((InternalBucket)b.current()).key) < 0;
            }
        };
        return new AggregatorReducer(){
            int initialCapacity = 0;
            final /* synthetic */ PriorityQueue val$pq;
            final /* synthetic */ int val$size;
            final /* synthetic */ AggregationReduceContext val$reduceContext;
            {
                this.val$pq = priorityQueue;
                this.val$size = n;
                this.val$reduceContext = aggregationReduceContext;
            }

            public void accept(InternalAggregation aggregation) {
                InternalTimeSeries timeSeries = (InternalTimeSeries)aggregation;
                if (!timeSeries.buckets.isEmpty()) {
                    this.initialCapacity = Math.max(this.initialCapacity, timeSeries.buckets.size());
                    IteratorAndCurrent iterator = new IteratorAndCurrent(timeSeries.buckets.iterator());
                    this.val$pq.add((Object)iterator);
                }
            }

            public InternalAggregation get() {
                InternalTimeSeries reduced = new InternalTimeSeries(InternalTimeSeries.this.name, new ArrayList<InternalBucket>(this.initialCapacity), InternalTimeSeries.this.keyed, InternalTimeSeries.this.getMetadata());
                ArrayList<InternalBucket> bucketsWithSameKey = new ArrayList<InternalBucket>(this.val$size);
                Integer size = this.val$reduceContext.builder() instanceof TimeSeriesAggregationBuilder ? Integer.valueOf(((TimeSeriesAggregationBuilder)this.val$reduceContext.builder()).getSize()) : null;
                BytesRef prevTsid = null;
                while (this.val$pq.size() > 0) {
                    InternalBucket reducedBucket;
                    this.val$reduceContext.consumeBucketsAndMaybeBreak(1);
                    bucketsWithSameKey.clear();
                    while (bucketsWithSameKey.isEmpty() || ((InternalBucket)((Object)bucketsWithSameKey.get((int)0))).key.equals((Object)((InternalBucket)((IteratorAndCurrent)this.val$pq.top()).current()).key)) {
                        IteratorAndCurrent iterator = (IteratorAndCurrent)this.val$pq.top();
                        bucketsWithSameKey.add((InternalBucket)iterator.current());
                        if (iterator.hasNext()) {
                            iterator.next();
                            this.val$pq.updateTop();
                            continue;
                        }
                        this.val$pq.pop();
                        if (this.val$pq.size() != 0) continue;
                        break;
                    }
                    if (bucketsWithSameKey.size() == 1) {
                        reducedBucket = (InternalBucket)((Object)bucketsWithSameKey.get(0));
                        reducedBucket.aggregations = InternalAggregations.reduce(List.of(reducedBucket.aggregations), (AggregationReduceContext)this.val$reduceContext);
                    } else {
                        reducedBucket = InternalTimeSeries.this.reduceBucket(bucketsWithSameKey, this.val$reduceContext);
                    }
                    BytesRef tsid = reducedBucket.key;
                    assert (prevTsid == null || tsid.compareTo(prevTsid) > 0);
                    reduced.buckets.add(reducedBucket);
                    if (size != null && reduced.buckets.size() >= size) break;
                    prevTsid = tsid;
                }
                return reduced;
            }
        };
    }

    public InternalTimeSeries create(List<InternalBucket> buckets) {
        return new InternalTimeSeries(this.name, buckets, this.keyed, this.metadata);
    }

    public InternalBucket createBucket(InternalAggregations aggregations, InternalBucket prototype) {
        return new InternalBucket(prototype.key, prototype.docCount, aggregations);
    }

    private InternalBucket reduceBucket(List<InternalBucket> buckets, AggregationReduceContext context) {
        InternalBucket reduced = null;
        for (InternalBucket bucket : buckets) {
            if (reduced == null) {
                reduced = new InternalBucket(bucket.key, bucket.docCount, bucket.aggregations);
                continue;
            }
            reduced.docCount += bucket.docCount;
        }
        InternalMultiBucketAggregation.BucketAggregationList aggregations = new InternalMultiBucketAggregation.BucketAggregationList(buckets);
        reduced.aggregations = InternalAggregations.reduce((List)aggregations, (AggregationReduceContext)context);
        return reduced;
    }

    public List<InternalBucket> getBuckets() {
        return this.buckets;
    }

    public InternalBucket getBucketByKey(String key) {
        if (this.bucketMap == null) {
            this.bucketMap = new HashMap<String, InternalBucket>(this.buckets.size());
            for (InternalBucket bucket : this.buckets) {
                this.bucketMap.put(bucket.getKeyAsString(), bucket);
            }
        }
        return this.bucketMap.get(key);
    }

    public static class InternalBucket
    extends InternalMultiBucketAggregation.InternalBucketWritable {
        protected long bucketOrd;
        protected final BytesRef key;
        protected long docCount;
        protected InternalAggregations aggregations;

        public InternalBucket(BytesRef key, long docCount, InternalAggregations aggregations) {
            this.key = key;
            this.docCount = docCount;
            this.aggregations = aggregations;
        }

        public InternalBucket(StreamInput in) throws IOException {
            this.key = in.readBytesRef();
            this.docCount = in.readVLong();
            this.aggregations = InternalAggregations.readFrom((StreamInput)in);
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeBytesRef(this.key);
            out.writeVLong(this.docCount);
            this.aggregations.writeTo(out);
        }

        public Map<String, Object> getKey() {
            return RoutingPathFields.decodeAsMap((BytesRef)this.key);
        }

        public String getKeyAsString() {
            return this.getKey().toString();
        }

        public long getDocCount() {
            return this.docCount;
        }

        public InternalAggregations getAggregations() {
            return this.aggregations;
        }

        private void bucketToXContent(XContentBuilder builder, ToXContent.Params params, boolean keyed) throws IOException {
            Object key = this.getKey();
            if (keyed) {
                builder.startObject(key.toString());
            } else {
                builder.startObject();
            }
            builder.field(Aggregation.CommonFields.KEY.getPreferredName(), (Map)key);
            builder.field(Aggregation.CommonFields.DOC_COUNT.getPreferredName(), this.docCount);
            this.aggregations.toXContentInternal(builder, params);
            builder.endObject();
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || ((Object)((Object)this)).getClass() != other.getClass()) {
                return false;
            }
            InternalBucket that = (InternalBucket)((Object)other);
            return Objects.equals(this.key, that.key) && Objects.equals(this.docCount, that.docCount) && Objects.equals(this.aggregations, that.aggregations);
        }

        public int hashCode() {
            return Objects.hash(((Object)((Object)this)).getClass(), this.key, this.docCount, this.aggregations);
        }
    }
}

