/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.logsdb;

import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.cluster.settings.ClusterUpdateSettingsAction;
import org.elasticsearch.action.admin.cluster.settings.ClusterUpdateSettingsRequest;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.LocalNodeMasterListener;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.threadpool.Scheduler;
import org.elasticsearch.threadpool.ThreadPool;

final class LogsPatternUsageService
implements LocalNodeMasterListener {
    private static final Logger LOGGER = LogManager.getLogger(LogsPatternUsageService.class);
    private static final TimeValue USAGE_CHECK_MINIMUM = TimeValue.timeValueSeconds((long)30L);
    static final Setting<TimeValue> USAGE_CHECK_MAX_PERIOD = Setting.timeSetting((String)"logsdb.usage_check.max_period", (TimeValue)new TimeValue(24L, TimeUnit.HOURS), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    static final Setting<Boolean> LOGSDB_PRIOR_LOGS_USAGE = Setting.boolSetting((String)"logsdb.prior_logs_usage", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    private final Client client;
    private final Settings nodeSettings;
    private final ThreadPool threadPool;
    private final Supplier<Metadata> metadataSupplier;
    volatile TimeValue nextWaitTime = USAGE_CHECK_MINIMUM;
    volatile boolean isMaster;
    volatile boolean hasPriorLogsUsage;
    volatile Scheduler.Cancellable cancellable;

    LogsPatternUsageService(Client client, Settings nodeSettings, ThreadPool threadPool, Supplier<Metadata> metadataSupplier) {
        this.client = client;
        this.nodeSettings = nodeSettings;
        this.threadPool = threadPool;
        this.metadataSupplier = metadataSupplier;
    }

    public void onMaster() {
        if (this.cancellable == null || this.cancellable.isCancelled()) {
            this.isMaster = true;
            this.nextWaitTime = USAGE_CHECK_MINIMUM;
            this.scheduleNext();
        }
    }

    public void offMaster() {
        this.isMaster = false;
        if (this.cancellable != null && !this.cancellable.isCancelled()) {
            this.cancellable.cancel();
            this.cancellable = null;
        }
    }

    void scheduleNext() {
        TimeValue maxWaitTime = (TimeValue)USAGE_CHECK_MAX_PERIOD.get(this.nodeSettings);
        this.nextWaitTime = TimeValue.timeValueMillis((long)Math.min(this.nextWaitTime.millis() * 2L, maxWaitTime.millis()));
        this.scheduleNext(this.nextWaitTime);
    }

    void scheduleNext(TimeValue waitTime) {
        if (this.isMaster && !this.hasPriorLogsUsage) {
            try {
                this.cancellable = this.threadPool.schedule(this::check, waitTime, (Executor)this.threadPool.generic());
            }
            catch (EsRejectedExecutionException e) {
                if (e.isExecutorShutdown()) {
                    LOGGER.debug("Failed to check; Shutting down", (Throwable)e);
                }
                throw e;
            }
        } else {
            LOGGER.debug("Skipping check, because [{}]/[{}]", new Object[]{this.isMaster, this.hasPriorLogsUsage});
        }
    }

    void check() {
        LOGGER.debug("Starting logs-*-* usage check");
        if (this.isMaster) {
            Metadata metadata = this.metadataSupplier.get();
            if (LOGSDB_PRIOR_LOGS_USAGE.exists(metadata.persistentSettings())) {
                LOGGER.debug("Using persistent logs-*-* usage check");
                this.hasPriorLogsUsage = true;
                return;
            }
            if (LogsPatternUsageService.hasLogsUsage(metadata)) {
                this.updateSetting();
            } else {
                LOGGER.debug("No usage found; Skipping check");
                this.scheduleNext();
            }
        } else {
            LOGGER.debug("No longer master; Skipping check");
        }
    }

    static boolean hasLogsUsage(Metadata metadata) {
        for (DataStream dataStream : metadata.dataStreams().values()) {
            if (!Regex.simpleMatch((String)"logs-*-*", (String)dataStream.getName())) continue;
            return true;
        }
        return false;
    }

    void updateSetting() {
        Settings settingsToUpdate = Settings.builder().put(LOGSDB_PRIOR_LOGS_USAGE.getKey(), true).build();
        ClusterUpdateSettingsRequest request = new ClusterUpdateSettingsRequest(TimeValue.ONE_MINUTE, TimeValue.ONE_MINUTE);
        request.persistentSettings(settingsToUpdate);
        this.client.execute((ActionType)ClusterUpdateSettingsAction.INSTANCE, (ActionRequest)request, ActionListener.wrap(resp -> {
            if (resp.isAcknowledged() && LOGSDB_PRIOR_LOGS_USAGE.exists(resp.getPersistentSettings())) {
                this.hasPriorLogsUsage = true;
                this.cancellable = null;
            } else {
                LOGGER.debug(() -> "unexpected response [" + LOGSDB_PRIOR_LOGS_USAGE.getKey() + "]");
                this.scheduleNext(TimeValue.ONE_MINUTE);
            }
        }, e -> {
            LOGGER.debug(() -> "Failed to update [" + LOGSDB_PRIOR_LOGS_USAGE.getKey() + "]", (Throwable)e);
            this.scheduleNext(TimeValue.ONE_MINUTE);
        }));
    }
}

