/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.util.HashMap;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.Executor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.AcknowledgedTransportMasterNodeAction;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.ingest.IngestMetadata;
import org.elasticsearch.ingest.IngestService;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ml.action.DeleteTrainedModelAliasAction;
import org.elasticsearch.xpack.core.ml.inference.ModelAliasMetadata;
import org.elasticsearch.xpack.core.ml.utils.InferenceProcessorInfoExtractor;
import org.elasticsearch.xpack.ml.notifications.InferenceAuditor;

public class TransportDeleteTrainedModelAliasAction
extends AcknowledgedTransportMasterNodeAction<DeleteTrainedModelAliasAction.Request> {
    private static final Logger logger = LogManager.getLogger(TransportDeleteTrainedModelAliasAction.class);
    private final InferenceAuditor auditor;
    private final IngestService ingestService;

    @Inject
    public TransportDeleteTrainedModelAliasAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, InferenceAuditor auditor, IngestService ingestService, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("cluster:admin/xpack/ml/inference/model_aliases/delete", transportService, clusterService, threadPool, actionFilters, DeleteTrainedModelAliasAction.Request::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.auditor = auditor;
        this.ingestService = ingestService;
    }

    protected void masterOperation(Task task, final DeleteTrainedModelAliasAction.Request request, ClusterState state, ActionListener<AcknowledgedResponse> listener) throws Exception {
        this.submitUnbatchedTask("delete-model-alias", (ClusterStateUpdateTask)new AckedClusterStateUpdateTask((AcknowledgedRequest)request, listener){

            public ClusterState execute(ClusterState currentState) {
                return TransportDeleteTrainedModelAliasAction.deleteModelAlias(currentState, TransportDeleteTrainedModelAliasAction.this.ingestService, TransportDeleteTrainedModelAliasAction.this.auditor, request);
            }
        });
    }

    @SuppressForbidden(reason="legacy usage of unbatched task")
    private void submitUnbatchedTask(String source, ClusterStateUpdateTask task) {
        this.clusterService.submitUnbatchedStateUpdateTask(source, task);
    }

    static ClusterState deleteModelAlias(ClusterState currentState, IngestService ingestService, InferenceAuditor inferenceAuditor, DeleteTrainedModelAliasAction.Request request) {
        ModelAliasMetadata currentMetadata = ModelAliasMetadata.fromState((ClusterState)currentState);
        String referencedModel = currentMetadata.getModelId(request.getModelAlias());
        if (referencedModel == null) {
            throw new ElasticsearchStatusException("model_alias [{}] could not be found", RestStatus.NOT_FOUND, new Object[]{request.getModelAlias()});
        }
        if (!referencedModel.equals(request.getModelId())) {
            throw new ElasticsearchStatusException("model_alias [{}] does not refer to provided model_id [{}]", RestStatus.CONFLICT, new Object[]{request.getModelAlias(), request.getModelId()});
        }
        IngestMetadata currentIngestMetadata = (IngestMetadata)currentState.metadata().custom("ingest");
        Set referencedModels = InferenceProcessorInfoExtractor.getModelIdsFromInferenceProcessors((IngestMetadata)currentIngestMetadata);
        if (referencedModels.contains(request.getModelAlias())) {
            throw new ElasticsearchStatusException("Cannot delete model_alias [{}] as it is still referenced by ingest processors", RestStatus.CONFLICT, new Object[]{request.getModelAlias()});
        }
        ClusterState.Builder builder = ClusterState.builder((ClusterState)currentState);
        HashMap newMetadata = new HashMap(currentMetadata.modelAliases());
        logger.info("deleting model_alias [{}] that refers to model [{}]", (Object)request.getModelAlias(), (Object)request.getModelId());
        inferenceAuditor.info(referencedModel, String.format(Locale.ROOT, "deleting model_alias [%s]", request.getModelAlias()));
        newMetadata.remove(request.getModelAlias());
        ModelAliasMetadata modelAliasMetadata = new ModelAliasMetadata(newMetadata);
        builder.metadata(Metadata.builder((Metadata)currentState.getMetadata()).putCustom("trained_model_alias", (Metadata.Custom)modelAliasMetadata).build());
        return builder.build();
    }

    protected ClusterBlockException checkBlock(DeleteTrainedModelAliasAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }
}

