/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.cluster.node.tasks.list.ListTasksRequestBuilder;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.OriginSettingClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.core.Predicates;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.persistent.PersistentTasksClusterService;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.persistent.PersistentTasksService;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.action.AbstractTransportSetUpgradeModeAction;
import org.elasticsearch.xpack.core.action.SetUpgradeModeActionRequest;
import org.elasticsearch.xpack.core.ml.MlMetadata;
import org.elasticsearch.xpack.core.ml.MlTasks;
import org.elasticsearch.xpack.core.ml.action.IsolateDatafeedAction;
import org.elasticsearch.xpack.ml.utils.TypedChainTaskExecutor;

public class TransportSetUpgradeModeAction
extends AbstractTransportSetUpgradeModeAction {
    private static final Set<String> ML_TASK_NAMES = Set.of("xpack/ml/job", "xpack/ml/datafeed", "xpack/ml/data_frame/analytics");
    private static final Logger logger = LogManager.getLogger(TransportSetUpgradeModeAction.class);
    private final PersistentTasksClusterService persistentTasksClusterService;
    private final PersistentTasksService persistentTasksService;
    private final OriginSettingClient client;

    @Inject
    public TransportSetUpgradeModeAction(TransportService transportService, ThreadPool threadPool, ClusterService clusterService, PersistentTasksClusterService persistentTasksClusterService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Client client, PersistentTasksService persistentTasksService) {
        super("cluster:admin/xpack/ml/upgrade_mode", "ml", transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver);
        this.persistentTasksClusterService = persistentTasksClusterService;
        this.client = new OriginSettingClient(client, "ml");
        this.persistentTasksService = persistentTasksService;
    }

    protected String featureName() {
        return "ml-set-upgrade-mode";
    }

    protected boolean upgradeMode(ClusterState state) {
        return MlMetadata.getMlMetadata((ClusterState)state).isUpgradeMode();
    }

    protected ClusterState createUpdatedState(SetUpgradeModeActionRequest request, ClusterState currentState) {
        logger.trace("Executing cluster state update");
        MlMetadata.Builder builder = new MlMetadata.Builder((MlMetadata)currentState.metadata().custom("ml"));
        builder.isUpgradeMode(request.enabled());
        ClusterState.Builder newState = ClusterState.builder((ClusterState)currentState);
        newState.metadata(Metadata.builder((Metadata)currentState.getMetadata()).putCustom("ml", (Metadata.Custom)builder.build()).build());
        return newState.build();
    }

    protected void upgradeModeSuccessfullyChanged(Task task, SetUpgradeModeActionRequest request, ClusterState state, ActionListener<AcknowledgedResponse> wrappedListener) {
        PersistentTasksCustomMetadata tasksCustomMetadata = (PersistentTasksCustomMetadata)state.metadata().custom("persistent_tasks");
        ActionListener unassignPersistentTasksListener = ActionListener.wrap(unassignedPersistentTasks -> ((ListTasksRequestBuilder)((ListTasksRequestBuilder)this.client.admin().cluster().prepareListTasks(new String[0]).setActions((String[])ML_TASK_NAMES.stream().map(taskName -> taskName + "[c]").toArray(String[]::new))).setWaitForCompletion(true).setTimeout(request.ackTimeout())).execute(ActionListener.wrap(r -> {
            try {
                logger.info("Waited for tasks to be unassigned");
                if (!r.getNodeFailures().isEmpty()) {
                    logger.info("There were node failures waiting for tasks", (Throwable)r.getNodeFailures().get(0));
                }
                ExceptionsHelper.rethrowAndSuppress((List)r.getNodeFailures());
                wrappedListener.onResponse((Object)AcknowledgedResponse.TRUE);
            }
            catch (ElasticsearchException ex) {
                logger.info("Caught node failures waiting for tasks to be unassigned", (Throwable)ex);
                wrappedListener.onFailure((Exception)((Object)ex));
            }
        }, arg_0 -> ((ActionListener)wrappedListener).onFailure(arg_0))), arg_0 -> wrappedListener.onFailure(arg_0));
        ActionListener isolateDatafeedListener = ActionListener.wrap(isolatedDatafeeds -> {
            logger.info("Isolated the datafeeds");
            this.unassignPersistentTasks(tasksCustomMetadata, unassignPersistentTasksListener);
        }, arg_0 -> wrappedListener.onFailure(arg_0));
        if (tasksCustomMetadata == null || tasksCustomMetadata.tasks().isEmpty()) {
            logger.info("No tasks to worry about after state update");
            wrappedListener.onResponse((Object)AcknowledgedResponse.TRUE);
            return;
        }
        if (request.enabled()) {
            logger.info("Enabling upgrade mode, must isolate datafeeds");
            this.isolateDatafeeds(tasksCustomMetadata, (ActionListener<List<IsolateDatafeedAction.Response>>)isolateDatafeedListener);
        } else {
            logger.info("Disabling upgrade mode, must wait for tasks to not have AWAITING_UPGRADE assignment");
            this.persistentTasksService.waitForPersistentTasksCondition(persistentTasksCustomMetadata -> persistentTasksCustomMetadata.tasks().stream().noneMatch(t -> ML_TASK_NAMES.contains(t.getTaskName()) && t.getAssignment().equals((Object)MlTasks.AWAITING_UPGRADE)), request.ackTimeout(), ActionListener.wrap(r -> {
                logger.info("Done waiting for tasks to be out of AWAITING_UPGRADE");
                wrappedListener.onResponse((Object)AcknowledgedResponse.TRUE);
            }, arg_0 -> wrappedListener.onFailure(arg_0)));
        }
    }

    private void unassignPersistentTasks(PersistentTasksCustomMetadata tasksCustomMetadata, ActionListener<List<PersistentTasksCustomMetadata.PersistentTask<?>>> listener) {
        List<PersistentTasksCustomMetadata.PersistentTask> mlTasks = tasksCustomMetadata.tasks().stream().filter(persistentTask -> ML_TASK_NAMES.contains(persistentTask.getTaskName())).sorted(Comparator.comparing(PersistentTasksCustomMetadata.PersistentTask::getTaskName)).toList();
        logger.info("Un-assigning persistent tasks : " + mlTasks.stream().map(PersistentTasksCustomMetadata.PersistentTask::getId).collect(Collectors.joining(", ", "[ ", " ]")));
        TypedChainTaskExecutor<Object> chainTaskExecutor = new TypedChainTaskExecutor<Object>(this.executor, Predicates.always(), ex -> !(org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper.unwrapCause((Throwable)ex) instanceof ResourceNotFoundException));
        for (PersistentTasksCustomMetadata.PersistentTask task : mlTasks) {
            chainTaskExecutor.add(chainedTask -> this.persistentTasksClusterService.unassignPersistentTask(task.getId(), task.getAllocationId(), MlTasks.AWAITING_UPGRADE.getExplanation(), chainedTask));
        }
        chainTaskExecutor.execute(listener);
    }

    private void isolateDatafeeds(PersistentTasksCustomMetadata tasksCustomMetadata, ActionListener<List<IsolateDatafeedAction.Response>> listener) {
        Set datafeedsToIsolate = MlTasks.startedDatafeedIds((PersistentTasksCustomMetadata)tasksCustomMetadata);
        logger.info("Isolating datafeeds: " + datafeedsToIsolate.toString());
        TypedChainTaskExecutor<IsolateDatafeedAction.Response> isolateDatafeedsExecutor = new TypedChainTaskExecutor<IsolateDatafeedAction.Response>(this.executor, Predicates.always(), Predicates.always());
        datafeedsToIsolate.forEach(datafeedId -> {
            IsolateDatafeedAction.Request isolationRequest = new IsolateDatafeedAction.Request(datafeedId);
            isolateDatafeedsExecutor.add(isolateListener -> this.client.execute((ActionType)IsolateDatafeedAction.INSTANCE, (ActionRequest)isolationRequest, isolateListener));
        });
        isolateDatafeedsExecutor.execute(listener);
    }
}

