/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.util.Map;
import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.ml.MachineLearningField;
import org.elasticsearch.xpack.core.ml.MlConfigIndex;
import org.elasticsearch.xpack.core.ml.action.PutDataFrameAnalyticsAction;
import org.elasticsearch.xpack.core.ml.action.UpdateDataFrameAnalyticsAction;
import org.elasticsearch.xpack.core.ml.dataframe.DataFrameAnalyticsConfig;
import org.elasticsearch.xpack.core.ml.job.persistence.ElasticsearchMappings;
import org.elasticsearch.xpack.core.security.SecurityContext;
import org.elasticsearch.xpack.ml.dataframe.persistence.DataFrameAnalyticsConfigProvider;
import org.elasticsearch.xpack.ml.utils.SecondaryAuthorizationUtils;

public class TransportUpdateDataFrameAnalyticsAction
extends TransportMasterNodeAction<UpdateDataFrameAnalyticsAction.Request, PutDataFrameAnalyticsAction.Response> {
    private final XPackLicenseState licenseState;
    private final DataFrameAnalyticsConfigProvider configProvider;
    private final SecurityContext securityContext;
    private final Client client;

    @Inject
    public TransportUpdateDataFrameAnalyticsAction(Settings settings, TransportService transportService, ActionFilters actionFilters, XPackLicenseState licenseState, ThreadPool threadPool, Client client, ClusterService clusterService, IndexNameExpressionResolver indexNameExpressionResolver, DataFrameAnalyticsConfigProvider configProvider) {
        super("cluster:admin/xpack/ml/data_frame/analytics/update", transportService, clusterService, threadPool, actionFilters, UpdateDataFrameAnalyticsAction.Request::new, PutDataFrameAnalyticsAction.Response::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.licenseState = licenseState;
        this.configProvider = configProvider;
        this.securityContext = (Boolean)XPackSettings.SECURITY_ENABLED.get(settings) != false ? new SecurityContext(settings, threadPool.getThreadContext()) : null;
        this.client = client;
    }

    protected ClusterBlockException checkBlock(UpdateDataFrameAnalyticsAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    protected void masterOperation(Task task, UpdateDataFrameAnalyticsAction.Request request, ClusterState state, ActionListener<PutDataFrameAnalyticsAction.Response> listener) {
        Runnable doUpdate = () -> SecondaryAuthorizationUtils.useSecondaryAuthIfAvailable(this.securityContext, () -> {
            Map headers = this.threadPool.getThreadContext().getHeaders();
            this.configProvider.update(request.getUpdate(), headers, state, (ActionListener<DataFrameAnalyticsConfig>)ActionListener.wrap(updatedConfig -> listener.onResponse((Object)new PutDataFrameAnalyticsAction.Response(updatedConfig)), arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
        });
        ElasticsearchMappings.addDocMappingIfMissing((String)MlConfigIndex.indexName(), MlConfigIndex::mapping, (Client)this.client, (ClusterState)state, (TimeValue)request.masterNodeTimeout(), (ActionListener)ActionListener.wrap(bool -> doUpdate.run(), arg_0 -> listener.onFailure(arg_0)), (int)1);
    }

    protected void doExecute(Task task, UpdateDataFrameAnalyticsAction.Request request, ActionListener<PutDataFrameAnalyticsAction.Response> listener) {
        if (MachineLearningField.ML_API_FEATURE.checkWithoutTracking(this.licenseState)) {
            super.doExecute(task, (MasterNodeRequest)request, listener);
        } else {
            listener.onFailure((Exception)LicenseUtils.newComplianceException((String)"ml"));
        }
    }
}

