/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.date;

import java.io.IOException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.IsoFields;
import java.time.temporal.Temporal;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.time.DateUtils;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.core.InvalidArgumentException;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.type.DataTypeConverter;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.EsqlScalarFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.date.DateDiffConstantMillisEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.date.DateDiffConstantMillisNanosEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.date.DateDiffConstantNanosEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.date.DateDiffConstantNanosMillisEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.date.DateDiffMillisEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.date.DateDiffMillisNanosEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.date.DateDiffNanosEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.date.DateDiffNanosMillisEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.date.DateTimeField;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;

public class DateDiff
extends EsqlScalarFunction {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "DateDiff", DateDiff::new);
    public static final ZoneId UTC = ZoneId.of("Z");
    private final Expression unit;
    private final Expression startTimestamp;
    private final Expression endTimestamp;

    @FunctionInfo(returnType={"integer"}, description="Subtracts the `startTimestamp` from the `endTimestamp` and returns the difference in multiples of `unit`.\nIf `startTimestamp` is later than the `endTimestamp`, negative values are returned.", detailedDescription="[cols=\"^,^\",role=\"styled\"]\n|===\n2+h|Datetime difference units\n\ns|unit\ns|abbreviations\n\n| year        | years, yy, yyyy\n| quarter     | quarters, qq, q\n| month       | months, mm, m\n| dayofyear   | dy, y\n| day         | days, dd, d\n| week        | weeks, wk, ww\n| weekday     | weekdays, dw\n| hour        | hours, hh\n| minute      | minutes, mi, n\n| second      | seconds, ss, s\n| millisecond | milliseconds, ms\n| microsecond | microseconds, mcs\n| nanosecond  | nanoseconds, ns\n|===\n\nNote that while there is an overlap between the function's supported units and\n{esql}'s supported time span literals, these sets are distinct and not\ninterchangeable. Similarly, the supported abbreviations are conveniently shared\nwith implementations of this function in other established products and not\nnecessarily common with the date-time nomenclature used by {es}.", examples={@Example(file="date", tag="docsDateDiff"), @Example(description="When subtracting in calendar units - like year, month a.s.o. - only the fully elapsed units are counted.\nTo avoid this and obtain also remainders, simply switch to the next smaller unit and do the date math accordingly.\n", file="date", tag="evalDateDiffYearForDocs")})
    public DateDiff(Source source, @Param(name="unit", type={"keyword", "text"}, description="Time difference unit") Expression unit, @Param(name="startTimestamp", type={"date", "date_nanos"}, description="A string representing a start timestamp") Expression startTimestamp, @Param(name="endTimestamp", type={"date", "date_nanos"}, description="A string representing an end timestamp") Expression endTimestamp) {
        super(source, List.of(unit, startTimestamp, endTimestamp));
        this.unit = unit;
        this.startTimestamp = startTimestamp;
        this.endTimestamp = endTimestamp;
    }

    private DateDiff(StreamInput in) throws IOException {
        this(Source.readFrom((StreamInput)((PlanStreamInput)in)), (Expression)in.readNamedWriteable(Expression.class), (Expression)in.readNamedWriteable(Expression.class), (Expression)in.readNamedWriteable(Expression.class));
    }

    public void writeTo(StreamOutput out) throws IOException {
        Source.EMPTY.writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.unit);
        out.writeNamedWriteable((NamedWriteable)this.startTimestamp);
        out.writeNamedWriteable((NamedWriteable)this.endTimestamp);
    }

    public String getWriteableName() {
        return DateDiff.ENTRY.name;
    }

    Expression unit() {
        return this.unit;
    }

    Expression startTimestamp() {
        return this.startTimestamp;
    }

    Expression endTimestamp() {
        return this.endTimestamp;
    }

    static int processMillis(Part datePartFieldUnit, long startTimestamp, long endTimestamp) throws IllegalArgumentException {
        ZonedDateTime zdtStart = ZonedDateTime.ofInstant(Instant.ofEpochMilli(startTimestamp), UTC);
        ZonedDateTime zdtEnd = ZonedDateTime.ofInstant(Instant.ofEpochMilli(endTimestamp), UTC);
        return datePartFieldUnit.diff(zdtStart, zdtEnd);
    }

    static int processMillis(BytesRef unit, long startTimestamp, long endTimestamp) throws IllegalArgumentException {
        return DateDiff.processMillis(Part.resolve(unit.utf8ToString()), startTimestamp, endTimestamp);
    }

    static int processNanos(Part datePartFieldUnit, long startTimestamp, long endTimestamp) throws IllegalArgumentException {
        ZonedDateTime zdtStart = ZonedDateTime.ofInstant(DateUtils.toInstant((long)startTimestamp), UTC);
        ZonedDateTime zdtEnd = ZonedDateTime.ofInstant(DateUtils.toInstant((long)endTimestamp), UTC);
        return datePartFieldUnit.diff(zdtStart, zdtEnd);
    }

    static int processNanos(BytesRef unit, long startTimestamp, long endTimestamp) throws IllegalArgumentException {
        return DateDiff.processNanos(Part.resolve(unit.utf8ToString()), startTimestamp, endTimestamp);
    }

    static int processNanosMillis(Part datePartFieldUnit, long startTimestampNanos, long endTimestampMillis) throws IllegalArgumentException {
        ZonedDateTime zdtStart = ZonedDateTime.ofInstant(DateUtils.toInstant((long)startTimestampNanos), UTC);
        ZonedDateTime zdtEnd = ZonedDateTime.ofInstant(Instant.ofEpochMilli(endTimestampMillis), UTC);
        return datePartFieldUnit.diff(zdtStart, zdtEnd);
    }

    static int processNanosMillis(BytesRef unit, long startTimestampNanos, long endTimestampMillis) throws IllegalArgumentException {
        return DateDiff.processNanosMillis(Part.resolve(unit.utf8ToString()), startTimestampNanos, endTimestampMillis);
    }

    static int processMillisNanos(Part datePartFieldUnit, long startTimestampMillis, long endTimestampNanos) throws IllegalArgumentException {
        ZonedDateTime zdtStart = ZonedDateTime.ofInstant(Instant.ofEpochMilli(startTimestampMillis), UTC);
        ZonedDateTime zdtEnd = ZonedDateTime.ofInstant(DateUtils.toInstant((long)endTimestampNanos), UTC);
        return datePartFieldUnit.diff(zdtStart, zdtEnd);
    }

    static int processMillisNanos(BytesRef unit, long startTimestampMillis, long endTimestampNanos) throws IllegalArgumentException {
        return DateDiff.processMillisNanos(Part.resolve(unit.utf8ToString()), startTimestampMillis, endTimestampNanos);
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(EvaluatorMapper.ToEvaluator toEvaluator) {
        if (this.startTimestamp.dataType() == DataType.DATETIME && this.endTimestamp.dataType() == DataType.DATETIME) {
            return this.toEvaluator(toEvaluator, DateDiffConstantMillisEvaluator.Factory::new, DateDiffMillisEvaluator.Factory::new);
        }
        if (this.startTimestamp.dataType() == DataType.DATE_NANOS && this.endTimestamp.dataType() == DataType.DATE_NANOS) {
            return this.toEvaluator(toEvaluator, DateDiffConstantNanosEvaluator.Factory::new, DateDiffNanosEvaluator.Factory::new);
        }
        if (this.startTimestamp.dataType() == DataType.DATE_NANOS && this.endTimestamp.dataType() == DataType.DATETIME) {
            return this.toEvaluator(toEvaluator, DateDiffConstantNanosMillisEvaluator.Factory::new, DateDiffNanosMillisEvaluator.Factory::new);
        }
        if (this.startTimestamp.dataType() == DataType.DATETIME && this.endTimestamp.dataType() == DataType.DATE_NANOS) {
            return this.toEvaluator(toEvaluator, DateDiffConstantMillisNanosEvaluator.Factory::new, DateDiffMillisNanosEvaluator.Factory::new);
        }
        throw new UnsupportedOperationException("Invalid types [" + String.valueOf(this.startTimestamp.dataType()) + ", " + String.valueOf(this.endTimestamp.dataType()) + "] If you see this error, there is a bug in DateDiff.resolveType()");
    }

    private EvalOperator.ExpressionEvaluator.Factory toEvaluator(EvaluatorMapper.ToEvaluator toEvaluator, DateDiffConstantFactory constantFactory, DateDiffFactory dateDiffFactory) {
        EvalOperator.ExpressionEvaluator.Factory startTimestampEvaluator = toEvaluator.apply(this.startTimestamp);
        EvalOperator.ExpressionEvaluator.Factory endTimestampEvaluator = toEvaluator.apply(this.endTimestamp);
        if (this.unit.foldable()) {
            try {
                Part datePartField = Part.resolve(((BytesRef)this.unit.fold(toEvaluator.foldCtx())).utf8ToString());
                return constantFactory.build(this.source(), datePartField, startTimestampEvaluator, endTimestampEvaluator);
            }
            catch (IllegalArgumentException e) {
                throw new InvalidArgumentException("invalid unit format for [{}]: {}", new Object[]{this.sourceText(), e.getMessage()});
            }
        }
        EvalOperator.ExpressionEvaluator.Factory unitEvaluator = toEvaluator.apply(this.unit);
        return dateDiffFactory.build(this.source(), unitEvaluator, startTimestampEvaluator, endTimestampEvaluator);
    }

    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        String operationName = this.sourceText();
        Expression.TypeResolution resolution = TypeResolutions.isString((Expression)this.unit, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.FIRST).and(TypeResolutions.isType((Expression)this.startTimestamp, DataType::isDate, (String)operationName, (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.SECOND, (String[])new String[]{"datetime or date_nanos"})).and(TypeResolutions.isType((Expression)this.endTimestamp, DataType::isDate, (String)operationName, (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.THIRD, (String[])new String[]{"datetime or date_nanos"}));
        if (resolution.unresolved()) {
            return resolution;
        }
        return Expression.TypeResolution.TYPE_RESOLVED;
    }

    public boolean foldable() {
        return this.unit.foldable() && this.startTimestamp.foldable() && this.endTimestamp.foldable();
    }

    public DataType dataType() {
        return DataType.INTEGER;
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new DateDiff(this.source(), newChildren.get(0), newChildren.get(1), newChildren.get(2));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, DateDiff::new, (Object)((Expression)this.children().get(0)), (Object)((Expression)this.children().get(1)), (Object)((Expression)this.children().get(2)));
    }

    public static enum Part implements DateTimeField
    {
        YEAR((start, end) -> DataTypeConverter.safeToInt((long)ChronoUnit.YEARS.between((Temporal)start, (Temporal)end)), "years", "yyyy", "yy"),
        QUARTER((start, end) -> DataTypeConverter.safeToInt((long)IsoFields.QUARTER_YEARS.between((Temporal)start, (Temporal)end)), "quarters", "qq", "q"),
        MONTH((start, end) -> DataTypeConverter.safeToInt((long)ChronoUnit.MONTHS.between((Temporal)start, (Temporal)end)), "months", "mm", "m"),
        DAYOFYEAR((start, end) -> DataTypeConverter.safeToInt((long)ChronoUnit.DAYS.between((Temporal)start, (Temporal)end)), "dy", "y"),
        DAY(DAYOFYEAR::diff, "days", "dd", "d"),
        WEEK((start, end) -> DataTypeConverter.safeToInt((long)ChronoUnit.WEEKS.between((Temporal)start, (Temporal)end)), "weeks", "wk", "ww"),
        WEEKDAY(DAYOFYEAR::diff, "weekdays", "dw"),
        HOUR((start, end) -> DataTypeConverter.safeToInt((long)ChronoUnit.HOURS.between((Temporal)start, (Temporal)end)), "hours", "hh"),
        MINUTE((start, end) -> DataTypeConverter.safeToInt((long)ChronoUnit.MINUTES.between((Temporal)start, (Temporal)end)), "minutes", "mi", "n"),
        SECOND((start, end) -> DataTypeConverter.safeToInt((long)ChronoUnit.SECONDS.between((Temporal)start, (Temporal)end)), "seconds", "ss", "s"),
        MILLISECOND((start, end) -> DataTypeConverter.safeToInt((long)ChronoUnit.MILLIS.between((Temporal)start, (Temporal)end)), "milliseconds", "ms"),
        MICROSECOND((start, end) -> DataTypeConverter.safeToInt((long)ChronoUnit.MICROS.between((Temporal)start, (Temporal)end)), "microseconds", "mcs"),
        NANOSECOND((start, end) -> DataTypeConverter.safeToInt((long)ChronoUnit.NANOS.between((Temporal)start, (Temporal)end)), "nanoseconds", "ns");

        private static final Map<String, Part> NAME_TO_PART;
        private final BiFunction<ZonedDateTime, ZonedDateTime, Integer> diffFunction;
        private final Set<String> aliases;

        private Part(BiFunction<ZonedDateTime, ZonedDateTime, Integer> diffFunction, String ... aliases) {
            this.diffFunction = diffFunction;
            this.aliases = Set.of(aliases);
        }

        public Integer diff(ZonedDateTime startTimestamp, ZonedDateTime endTimestamp) {
            return this.diffFunction.apply(startTimestamp, endTimestamp);
        }

        @Override
        public Iterable<String> aliases() {
            return this.aliases;
        }

        public static Part resolve(String dateTimeUnit) {
            Part datePartField = DateTimeField.resolveMatch(NAME_TO_PART, dateTimeUnit);
            if (datePartField == null) {
                List<String> similar = DateTimeField.findSimilar(NAME_TO_PART.keySet(), dateTimeUnit);
                String errorMessage = !similar.isEmpty() ? String.format(Locale.ROOT, "Received value [%s] is not valid date part to add; did you mean %s?", dateTimeUnit, similar) : String.format(Locale.ROOT, "A value of %s or their aliases is required; received [%s]", Arrays.asList(Part.values()), dateTimeUnit);
                throw new IllegalArgumentException(errorMessage);
            }
            return datePartField;
        }

        static {
            NAME_TO_PART = DateTimeField.initializeResolutionMap((DateTimeField[])Part.values());
        }
    }

    @FunctionalInterface
    public static interface DateDiffConstantFactory {
        public EvalOperator.ExpressionEvaluator.Factory build(Source var1, Part var2, EvalOperator.ExpressionEvaluator.Factory var3, EvalOperator.ExpressionEvaluator.Factory var4);
    }

    @FunctionalInterface
    public static interface DateDiffFactory {
        public EvalOperator.ExpressionEvaluator.Factory build(Source var1, EvalOperator.ExpressionEvaluator.Factory var2, EvalOperator.ExpressionEvaluator.Factory var3, EvalOperator.ExpressionEvaluator.Factory var4);
    }
}

