/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.nulls;

import java.util.List;
import java.util.stream.IntStream;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
abstract class CoalesceBooleanEvaluator
implements EvalOperator.ExpressionEvaluator {
    protected final DriverContext driverContext;
    protected final List<EvalOperator.ExpressionEvaluator> evaluators;

    static EvalOperator.ExpressionEvaluator.Factory toEvaluator(EvaluatorMapper.ToEvaluator toEvaluator, List<Expression> children) {
        final List<EvalOperator.ExpressionEvaluator.Factory> childEvaluators = children.stream().map(toEvaluator::apply).toList();
        if (childEvaluators.stream().allMatch(EvalOperator.ExpressionEvaluator.Factory::eagerEvalSafeInLazy)) {
            return new EvalOperator.ExpressionEvaluator.Factory(){

                public EvalOperator.ExpressionEvaluator get(DriverContext context) {
                    return new CoalesceBooleanEagerEvaluator(context, childEvaluators.stream().map(x -> x.get(context)).toList());
                }

                public String toString() {
                    return "CoalesceBooleanEagerEvaluator[values=" + String.valueOf(childEvaluators) + "]";
                }
            };
        }
        return new EvalOperator.ExpressionEvaluator.Factory(){

            public EvalOperator.ExpressionEvaluator get(DriverContext context) {
                return new CoalesceBooleanLazyEvaluator(context, childEvaluators.stream().map(x -> x.get(context)).toList());
            }

            public String toString() {
                return "CoalesceBooleanLazyEvaluator[values=" + String.valueOf(childEvaluators) + "]";
            }
        };
    }

    protected CoalesceBooleanEvaluator(DriverContext driverContext, List<EvalOperator.ExpressionEvaluator> evaluators) {
        this.driverContext = driverContext;
        this.evaluators = evaluators;
    }

    public final BooleanBlock eval(Page page) {
        return this.entireBlock(page);
    }

    private BooleanBlock entireBlock(Page page) {
        BooleanBlock lastFullBlock;
        int lastFullBlockIdx = 0;
        while (true) {
            lastFullBlock = (BooleanBlock)this.evaluators.get(lastFullBlockIdx++).eval(page);
            if (lastFullBlockIdx == this.evaluators.size() || lastFullBlock.asVector() != null) {
                return lastFullBlock;
            }
            if (!lastFullBlock.areAllValuesNull()) break;
            lastFullBlock.close();
        }
        return this.perPosition(page, lastFullBlock, lastFullBlockIdx);
    }

    protected abstract BooleanBlock perPosition(Page var1, BooleanBlock var2, int var3);

    public final String toString() {
        return this.getClass().getSimpleName() + "[values=" + String.valueOf(this.evaluators) + "]";
    }

    public final void close() {
        Releasables.closeExpectNoException(() -> Releasables.close(this.evaluators));
    }

    static final class CoalesceBooleanLazyEvaluator
    extends CoalesceBooleanEvaluator {
        CoalesceBooleanLazyEvaluator(DriverContext driverContext, List<EvalOperator.ExpressionEvaluator> evaluators) {
            super(driverContext, evaluators);
        }

        @Override
        protected BooleanBlock perPosition(Page page, BooleanBlock lastFullBlock, int firstToEvaluate) {
            int positionCount = page.getPositionCount();
            try {
                BooleanBlock booleanBlock;
                block25: {
                    BooleanBlock.Builder result = this.driverContext.blockFactory().newBooleanBlockBuilder(positionCount);
                    try {
                        block19: for (int p = 0; p < positionCount; ++p) {
                            if (!lastFullBlock.isNull(p)) {
                                result.copyFrom(lastFullBlock, p, p + 1);
                                continue;
                            }
                            int[] positions = new int[]{p};
                            Page limited = new Page(1, (Block[])IntStream.range(0, page.getBlockCount()).mapToObj(b -> page.getBlock(b).filter(positions)).toArray(Block[]::new));
                            try (Releasable ignored = () -> ((Page)limited).releaseBlocks();){
                                for (int e = firstToEvaluate; e < this.evaluators.size(); ++e) {
                                    try (BooleanBlock block = (BooleanBlock)((EvalOperator.ExpressionEvaluator)this.evaluators.get(e)).eval(limited);){
                                        if (block.isNull(0)) continue;
                                        result.copyFrom(block, 0);
                                        continue block19;
                                    }
                                }
                                result.appendNull();
                                continue;
                            }
                        }
                        booleanBlock = result.build();
                        if (result == null) break block25;
                    }
                    catch (Throwable throwable) {
                        if (result != null) {
                            try {
                                result.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    result.close();
                }
                return booleanBlock;
            }
            finally {
                lastFullBlock.close();
            }
        }
    }

    static final class CoalesceBooleanEagerEvaluator
    extends CoalesceBooleanEvaluator {
        CoalesceBooleanEagerEvaluator(DriverContext driverContext, List<EvalOperator.ExpressionEvaluator> evaluators) {
            super(driverContext, evaluators);
        }

        @Override
        protected BooleanBlock perPosition(Page page, BooleanBlock lastFullBlock, int firstToEvaluate) {
            int positionCount = page.getPositionCount();
            BooleanBlock[] flatten = new BooleanBlock[this.evaluators.size() - firstToEvaluate + 1];
            try {
                BooleanBlock booleanBlock;
                block12: {
                    flatten[0] = lastFullBlock;
                    for (int f = 1; f < flatten.length; ++f) {
                        flatten[f] = (BooleanBlock)((EvalOperator.ExpressionEvaluator)this.evaluators.get(firstToEvaluate + f - 1)).eval(page);
                    }
                    BooleanBlock.Builder result = this.driverContext.blockFactory().newBooleanBlockBuilder(positionCount);
                    try {
                        block9: for (int p = 0; p < positionCount; ++p) {
                            for (BooleanBlock f : flatten) {
                                if (f.isNull(p)) continue;
                                result.copyFrom(f, p);
                                continue block9;
                            }
                            result.appendNull();
                        }
                        booleanBlock = result.build();
                        if (result == null) break block12;
                    }
                    catch (Throwable throwable) {
                        if (result != null) {
                            try {
                                result.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    result.close();
                }
                return booleanBlock;
            }
            finally {
                Releasables.close((Releasable[])flatten);
            }
        }
    }
}

