/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.spatial;

import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.geometry.Point;
import org.elasticsearch.geometry.utils.SpatialEnvelopeVisitor;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.util.SpatialCoordinateTypes;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.EsqlTypeResolutions;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.UnaryScalarFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.StEnvelopeFromWKBEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.StEnvelopeFromWKBGeoEvaluator;

public class StEnvelope
extends UnaryScalarFunction {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "StEnvelope", StEnvelope::new);
    private DataType dataType;

    @FunctionInfo(returnType={"geo_shape", "cartesian_shape"}, description="Determines the minimum bounding box of the supplied geometry.", examples={@Example(file="spatial_shapes", tag="st_envelope")})
    public StEnvelope(Source source, @Param(name="geometry", type={"geo_point", "geo_shape", "cartesian_point", "cartesian_shape"}, description="Expression of type `geo_point`, `geo_shape`, `cartesian_point` or `cartesian_shape`. If `null`, the function returns `null`.") Expression field) {
        super(source, field);
    }

    private StEnvelope(StreamInput in) throws IOException {
        super(in);
    }

    public String getWriteableName() {
        return StEnvelope.ENTRY.name;
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        Expression.TypeResolution resolution = EsqlTypeResolutions.isSpatial(this.field(), this.sourceText(), TypeResolutions.ParamOrdinal.DEFAULT);
        if (resolution.resolved()) {
            this.dataType = switch (this.field().dataType()) {
                case DataType.GEO_POINT, DataType.GEO_SHAPE -> DataType.GEO_SHAPE;
                case DataType.CARTESIAN_POINT, DataType.CARTESIAN_SHAPE -> DataType.CARTESIAN_SHAPE;
                default -> DataType.NULL;
            };
        }
        return resolution;
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(EvaluatorMapper.ToEvaluator toEvaluator) {
        if (this.field().dataType() == DataType.GEO_POINT || this.field().dataType() == DataType.GEO_SHAPE) {
            return new StEnvelopeFromWKBGeoEvaluator.Factory(toEvaluator.apply(this.field()), this.source());
        }
        return new StEnvelopeFromWKBEvaluator.Factory(toEvaluator.apply(this.field()), this.source());
    }

    @Override
    public DataType dataType() {
        return this.dataType;
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new StEnvelope(this.source(), newChildren.get(0));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, StEnvelope::new, (Object)this.field());
    }

    static BytesRef fromWellKnownBinary(BytesRef wkb) {
        Geometry geometry = SpatialCoordinateTypes.UNSPECIFIED.wkbToGeometry(wkb);
        if (geometry instanceof Point) {
            return wkb;
        }
        Optional envelope = SpatialEnvelopeVisitor.visitCartesian((Geometry)geometry);
        if (envelope.isPresent()) {
            return SpatialCoordinateTypes.UNSPECIFIED.asWkb((Geometry)envelope.get());
        }
        throw new IllegalArgumentException("Cannot determine envelope of geometry");
    }

    static BytesRef fromWellKnownBinaryGeo(BytesRef wkb) {
        Geometry geometry = SpatialCoordinateTypes.UNSPECIFIED.wkbToGeometry(wkb);
        if (geometry instanceof Point) {
            return wkb;
        }
        Optional envelope = SpatialEnvelopeVisitor.visitGeo((Geometry)geometry, (SpatialEnvelopeVisitor.WrapLongitude)SpatialEnvelopeVisitor.WrapLongitude.WRAP);
        if (envelope.isPresent()) {
            return SpatialCoordinateTypes.UNSPECIFIED.asWkb((Geometry)envelope.get());
        }
        throw new IllegalArgumentException("Cannot determine envelope of geometry");
    }
}

