/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.spatial;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.util.SpatialCoordinateTypes;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.EsqlTypeResolutions;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.UnaryScalarFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.StYFromWKBEvaluator;

public class StY
extends UnaryScalarFunction {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "StY", StY::new);

    @FunctionInfo(returnType={"double"}, description="Extracts the `y` coordinate from the supplied point.\nIf the points is of type `geo_point` this is equivalent to extracting the `latitude` value.", examples={@Example(file="spatial", tag="st_x_y")})
    public StY(Source source, @Param(name="point", type={"geo_point", "cartesian_point"}, description="Expression of type `geo_point` or `cartesian_point`. If `null`, the function returns `null`.") Expression field) {
        super(source, field);
    }

    private StY(StreamInput in) throws IOException {
        super(in);
    }

    public String getWriteableName() {
        return StY.ENTRY.name;
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        return EsqlTypeResolutions.isSpatialPoint(this.field(), this.sourceText(), TypeResolutions.ParamOrdinal.DEFAULT);
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(EvaluatorMapper.ToEvaluator toEvaluator) {
        return new StYFromWKBEvaluator.Factory(toEvaluator.apply(this.field()), this.source());
    }

    @Override
    public DataType dataType() {
        return DataType.DOUBLE;
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new StY(this.source(), newChildren.get(0));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, StY::new, (Object)this.field());
    }

    static double fromWellKnownBinary(BytesRef in) {
        return SpatialCoordinateTypes.UNSPECIFIED.wkbAsPoint(in).getY();
    }
}

