/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.string;

import org.apache.lucene.util.BytesRef;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.Substring;

public final class SubstringNoLengthEvaluator
implements EvalOperator.ExpressionEvaluator {
    private final Source source;
    private final EvalOperator.ExpressionEvaluator str;
    private final EvalOperator.ExpressionEvaluator start;
    private final DriverContext driverContext;
    private Warnings warnings;

    public SubstringNoLengthEvaluator(Source source, EvalOperator.ExpressionEvaluator str, EvalOperator.ExpressionEvaluator start, DriverContext driverContext) {
        this.source = source;
        this.str = str;
        this.start = start;
        this.driverContext = driverContext;
    }

    public Block eval(Page page) {
        try (BytesRefBlock strBlock = (BytesRefBlock)this.str.eval(page);){
            BytesRefBlock bytesRefBlock;
            block20: {
                IntVector startVector;
                BytesRefVector strVector;
                IntBlock startBlock;
                block18: {
                    BytesRefBlock bytesRefBlock2;
                    block19: {
                        block16: {
                            BytesRefBlock bytesRefBlock3;
                            block17: {
                                startBlock = (IntBlock)this.start.eval(page);
                                try {
                                    strVector = strBlock.asVector();
                                    if (strVector != null) break block16;
                                    bytesRefBlock3 = this.eval(page.getPositionCount(), strBlock, startBlock);
                                    if (startBlock == null) break block17;
                                }
                                catch (Throwable throwable) {
                                    if (startBlock != null) {
                                        try {
                                            startBlock.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                                startBlock.close();
                            }
                            return bytesRefBlock3;
                        }
                        startVector = startBlock.asVector();
                        if (startVector != null) break block18;
                        bytesRefBlock2 = this.eval(page.getPositionCount(), strBlock, startBlock);
                        if (startBlock == null) break block19;
                        startBlock.close();
                    }
                    return bytesRefBlock2;
                }
                bytesRefBlock = this.eval(page.getPositionCount(), strVector, startVector).asBlock();
                if (startBlock == null) break block20;
                startBlock.close();
            }
            return bytesRefBlock;
        }
    }

    public BytesRefBlock eval(int positionCount, BytesRefBlock strBlock, IntBlock startBlock) {
        try (BytesRefBlock.Builder result = this.driverContext.blockFactory().newBytesRefBlockBuilder(positionCount);){
            BytesRef strScratch = new BytesRef();
            for (int p = 0; p < positionCount; ++p) {
                if (strBlock.isNull(p)) {
                    result.appendNull();
                    continue;
                }
                if (strBlock.getValueCount(p) != 1) {
                    if (strBlock.getValueCount(p) > 1) {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue;
                }
                if (startBlock.isNull(p)) {
                    result.appendNull();
                    continue;
                }
                if (startBlock.getValueCount(p) != 1) {
                    if (startBlock.getValueCount(p) > 1) {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue;
                }
                result.appendBytesRef(Substring.process(strBlock.getBytesRef(strBlock.getFirstValueIndex(p), strScratch), startBlock.getInt(startBlock.getFirstValueIndex(p))));
            }
            BytesRefBlock bytesRefBlock = result.build();
            return bytesRefBlock;
        }
    }

    public BytesRefVector eval(int positionCount, BytesRefVector strVector, IntVector startVector) {
        try (BytesRefVector.Builder result = this.driverContext.blockFactory().newBytesRefVectorBuilder(positionCount);){
            BytesRef strScratch = new BytesRef();
            for (int p = 0; p < positionCount; ++p) {
                result.appendBytesRef(Substring.process(strVector.getBytesRef(p, strScratch), startVector.getInt(p)));
            }
            BytesRefVector bytesRefVector = result.build();
            return bytesRefVector;
        }
    }

    public String toString() {
        return "SubstringNoLengthEvaluator[str=" + String.valueOf(this.str) + ", start=" + String.valueOf(this.start) + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.str, this.start});
    }

    private Warnings warnings() {
        if (this.warnings == null) {
            this.warnings = Warnings.createWarnings((DriverContext.WarningsMode)this.driverContext.warningsMode(), (int)this.source.source().getLineNumber(), (int)this.source.source().getColumnNumber(), (String)this.source.text());
        }
        return this.warnings;
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory str;
        private final EvalOperator.ExpressionEvaluator.Factory start;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory str, EvalOperator.ExpressionEvaluator.Factory start) {
            this.source = source;
            this.str = str;
            this.start = start;
        }

        public SubstringNoLengthEvaluator get(DriverContext context) {
            return new SubstringNoLengthEvaluator(this.source, this.str.get(context), this.start.get(context), context);
        }

        public String toString() {
            return "SubstringNoLengthEvaluator[str=" + String.valueOf(this.str) + ", start=" + String.valueOf(this.start) + "]";
        }
    }
}

