/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.rest.action.role;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.search.searchafter.SearchAfterBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.security.action.ActionTypes;
import org.elasticsearch.xpack.core.security.action.role.QueryRoleRequest;
import org.elasticsearch.xpack.security.rest.action.role.NativeRoleBaseRestHandler;

@ServerlessScope(value=Scope.INTERNAL)
public final class RestQueryRoleAction
extends NativeRoleBaseRestHandler {
    private static final ConstructingObjectParser<Payload, Void> PARSER = new ConstructingObjectParser("query_role_request_payload", a -> new Payload((QueryBuilder)a[0], (Integer)a[1], (Integer)a[2], (List)a[3], (SearchAfterBuilder)a[4]));

    public RestQueryRoleAction(Settings settings, XPackLicenseState licenseState) {
        super(settings, licenseState);
    }

    public String getName() {
        return "xpack_security_query_role";
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, "/_security/_query/role"), new RestHandler.Route(RestRequest.Method.POST, "/_security/_query/role"));
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer innerPrepareRequest(RestRequest request, NodeClient client) throws IOException {
        QueryRoleRequest queryRoleRequest;
        if (request.hasContentOrSourceParam()) {
            Payload payload = (Payload)PARSER.parse(request.contentOrSourceParamParser(), null);
            queryRoleRequest = new QueryRoleRequest(payload.queryBuilder, payload.from, payload.size, payload.fieldSortBuilders, payload.searchAfterBuilder);
        } else {
            queryRoleRequest = new QueryRoleRequest(null, null, null, null, null);
        }
        return channel -> client.execute(ActionTypes.QUERY_ROLE_ACTION, (ActionRequest)queryRoleRequest, (ActionListener)new RestToXContentListener(channel));
    }

    static {
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> AbstractQueryBuilder.parseTopLevelQuery((XContentParser)p), new ParseField("query", new String[0]));
        PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), new ParseField("from", new String[0]));
        PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), new ParseField("size", new String[0]));
        PARSER.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> {
            if (p.currentToken() == XContentParser.Token.VALUE_STRING) {
                return new FieldSortBuilder(p.text());
            }
            if (p.currentToken() == XContentParser.Token.START_OBJECT) {
                XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.FIELD_NAME, (XContentParser.Token)p.nextToken(), (XContentParser)p);
                FieldSortBuilder fieldSortBuilder = FieldSortBuilder.fromXContent((XContentParser)p, (String)p.currentName());
                XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.END_OBJECT, (XContentParser.Token)p.nextToken(), (XContentParser)p);
                return fieldSortBuilder;
            }
            throw new IllegalArgumentException("malformed sort object");
        }, new ParseField("sort", new String[0]));
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> SearchAfterBuilder.fromXContent((XContentParser)p), new ParseField("search_after", new String[0]), ObjectParser.ValueType.VALUE_ARRAY);
    }

    private record Payload(@Nullable QueryBuilder queryBuilder, @Nullable Integer from, @Nullable Integer size, @Nullable List<FieldSortBuilder> fieldSortBuilders, @Nullable SearchAfterBuilder searchAfterBuilder) {
    }
}

