/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.geoip.direct;

import java.util.HashMap;
import java.util.concurrent.Executor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskListener;
import org.elasticsearch.cluster.SimpleBatchedExecutor;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.cluster.service.MasterServiceTaskQueue;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.ingest.geoip.IngestGeoIpMetadata;
import org.elasticsearch.ingest.geoip.direct.DatabaseConfigurationMetadata;
import org.elasticsearch.ingest.geoip.direct.DeleteDatabaseConfigurationAction;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportDeleteDatabaseConfigurationAction
extends TransportMasterNodeAction<DeleteDatabaseConfigurationAction.Request, AcknowledgedResponse> {
    private static final Logger logger = LogManager.getLogger(TransportDeleteDatabaseConfigurationAction.class);
    private static final SimpleBatchedExecutor<DeleteDatabaseConfigurationTask, Void> DELETE_TASK_EXECUTOR = new SimpleBatchedExecutor<DeleteDatabaseConfigurationTask, Void>(){

        public Tuple<ClusterState, Void> executeTask(DeleteDatabaseConfigurationTask task, ClusterState clusterState) throws Exception {
            return Tuple.tuple((Object)task.execute(clusterState), null);
        }

        public void taskSucceeded(DeleteDatabaseConfigurationTask task, Void unused) {
            logger.trace("Updated cluster state for deletion of database configuration [{}]", (Object)task.databaseId);
            task.listener.onResponse((Object)AcknowledgedResponse.TRUE);
        }
    };
    private final MasterServiceTaskQueue<DeleteDatabaseConfigurationTask> deleteDatabaseConfigurationTaskQueue;

    @Inject
    public TransportDeleteDatabaseConfigurationAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("cluster:admin/ingest/geoip/database/delete", transportService, clusterService, threadPool, actionFilters, DeleteDatabaseConfigurationAction.Request::new, AcknowledgedResponse::readFrom, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.deleteDatabaseConfigurationTaskQueue = clusterService.createTaskQueue("delete-geoip-database-configuration-state-update", Priority.NORMAL, DELETE_TASK_EXECUTOR);
    }

    protected void masterOperation(Task task, DeleteDatabaseConfigurationAction.Request request, ClusterState state, ActionListener<AcknowledgedResponse> listener) throws Exception {
        String id = request.getDatabaseId();
        IngestGeoIpMetadata geoIpMeta = (IngestGeoIpMetadata)state.metadata().custom("ingest_geoip", (Metadata.Custom)IngestGeoIpMetadata.EMPTY);
        if (!geoIpMeta.getDatabases().containsKey(id)) {
            throw new ResourceNotFoundException("Database configuration not found: {}", new Object[]{id});
        }
        if (geoIpMeta.getDatabases().get(id).database().isReadOnly()) {
            throw new IllegalArgumentException("Database " + id + " is read only");
        }
        this.deleteDatabaseConfigurationTaskQueue.submitTask(Strings.format((String)"delete-geoip-database-configuration-[%s]", (Object[])new Object[]{id}), (ClusterStateTaskListener)new DeleteDatabaseConfigurationTask(listener, id), null);
    }

    protected ClusterBlockException checkBlock(DeleteDatabaseConfigurationAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    private record DeleteDatabaseConfigurationTask(ActionListener<AcknowledgedResponse> listener, String databaseId) implements ClusterStateTaskListener
    {
        ClusterState execute(ClusterState currentState) throws Exception {
            IngestGeoIpMetadata geoIpMeta = (IngestGeoIpMetadata)currentState.metadata().custom("ingest_geoip", (Metadata.Custom)IngestGeoIpMetadata.EMPTY);
            logger.debug("deleting database configuration [{}]", (Object)this.databaseId);
            HashMap<String, DatabaseConfigurationMetadata> databases = new HashMap<String, DatabaseConfigurationMetadata>(geoIpMeta.getDatabases());
            databases.remove(this.databaseId);
            Metadata currentMeta = currentState.metadata();
            return ClusterState.builder((ClusterState)currentState).metadata(Metadata.builder((Metadata)currentMeta).putCustom("ingest_geoip", (Metadata.Custom)new IngestGeoIpMetadata(databases))).build();
        }

        public void onFailure(Exception e) {
            this.listener.onFailure(e);
        }
    }
}

