/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.snapshots.delete;

import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.cluster.snapshots.delete.DeleteSnapshotRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.AcknowledgedTransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.snapshots.SnapshotsService;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportDeleteSnapshotAction
extends AcknowledgedTransportMasterNodeAction<DeleteSnapshotRequest> {
    public static final ActionType<AcknowledgedResponse> TYPE = new ActionType("cluster:admin/snapshot/delete");
    private final SnapshotsService snapshotsService;

    @Inject
    public TransportDeleteSnapshotAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, SnapshotsService snapshotsService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(TYPE.name(), transportService, clusterService, threadPool, actionFilters, DeleteSnapshotRequest::new, EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.snapshotsService = snapshotsService;
    }

    @Override
    protected ClusterBlockException checkBlock(DeleteSnapshotRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }

    @Override
    protected void doExecute(Task task, DeleteSnapshotRequest request, ActionListener<AcknowledgedResponse> listener) {
        if (this.clusterService.state().getMinTransportVersion().before(TransportVersions.V_8_15_0) && !request.waitForCompletion()) {
            throw new UnsupportedOperationException("wait_for_completion parameter is not supported by all nodes in this cluster");
        }
        super.doExecute(task, request, listener);
    }

    @Override
    protected void masterOperation(Task task, DeleteSnapshotRequest request, ClusterState state, ActionListener<AcknowledgedResponse> listener) {
        this.snapshotsService.deleteSnapshots(request, listener.map(v -> AcknowledgedResponse.TRUE));
    }
}

