/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.refresh;

import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.admin.indices.refresh.UnpromotableShardRefreshRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.broadcast.unpromotable.TransportBroadcastUnpromotableAction;
import org.elasticsearch.cluster.action.shard.ShardStateAction;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;

public class TransportUnpromotableShardRefreshAction
extends TransportBroadcastUnpromotableAction<UnpromotableShardRefreshRequest, ActionResponse.Empty> {
    public static final String NAME = "indices:admin/refresh/unpromotable";
    private final IndicesService indicesService;
    static final /* synthetic */ boolean $assertionsDisabled;

    @Inject
    public TransportUnpromotableShardRefreshAction(ClusterService clusterService, TransportService transportService, ShardStateAction shardStateAction, ActionFilters actionFilters, IndicesService indicesService) {
        super(NAME, clusterService, transportService, shardStateAction, actionFilters, UnpromotableShardRefreshRequest::new, transportService.getThreadPool().executor("refresh"));
        this.indicesService = indicesService;
    }

    @Override
    protected void unpromotableShardOperation(Task task, UnpromotableShardRefreshRequest request, ActionListener<ActionResponse.Empty> responseListener) {
        IndexShard shard;
        IndexService indexService = this.indicesService.indexService(request.shardId().getIndex());
        IndexShard indexShard = shard = indexService == null ? null : indexService.getShardOrNull(request.shardId().id());
        if (shard == null) {
            responseListener.onResponse(ActionResponse.Empty.INSTANCE);
            return;
        }
        ActionListener.run(responseListener, listener -> shard.waitForPrimaryTermAndGeneration(request.getPrimaryTerm(), request.getSegmentGeneration(), listener.map(l -> ActionResponse.Empty.INSTANCE)));
    }

    @Override
    protected ActionResponse.Empty combineUnpromotableShardResponses(List<ActionResponse.Empty> empties) {
        return ActionResponse.Empty.INSTANCE;
    }

    @Override
    protected ActionResponse.Empty readResponse(StreamInput in) {
        return ActionResponse.Empty.INSTANCE;
    }

    @Override
    protected ActionResponse.Empty emptyResponse() {
        return ActionResponse.Empty.INSTANCE;
    }

    static {
        boolean bl = $assertionsDisabled = !TransportUnpromotableShardRefreshAction.class.desiredAssertionStatus();
        if (!$assertionsDisabled && !NAME.equals(NAME)) {
            throw new AssertionError();
        }
    }
}

