/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.resolve;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Stream;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.OriginalIndices;
import org.elasticsearch.action.RemoteClusterActionType;
import org.elasticsearch.action.search.TransportSearchHelper;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.action.support.IndexComponentSelector;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.internal.RemoteClusterClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.util.concurrent.CountDown;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.Index;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.search.SearchService;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.RemoteClusterAware;
import org.elasticsearch.transport.RemoteClusterService;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class ResolveIndexAction
extends ActionType<Response> {
    public static final ResolveIndexAction INSTANCE = new ResolveIndexAction();
    public static final String NAME = "indices:admin/resolve/index";
    public static final RemoteClusterActionType<Response> REMOTE_TYPE = new RemoteClusterActionType<Response>("indices:admin/resolve/index", Response::new);

    private ResolveIndexAction() {
        super(NAME);
    }

    public static class TransportAction
    extends HandledTransportAction<Request, Response> {
        private final ClusterService clusterService;
        private final RemoteClusterService remoteClusterService;
        private final IndexNameExpressionResolver indexNameExpressionResolver;
        private final boolean ccsCheckCompatibility;

        @Inject
        public TransportAction(TransportService transportService, ClusterService clusterService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
            super(ResolveIndexAction.NAME, transportService, actionFilters, Request::new, EsExecutors.DIRECT_EXECUTOR_SERVICE);
            this.clusterService = clusterService;
            this.remoteClusterService = transportService.getRemoteClusterService();
            this.indexNameExpressionResolver = indexNameExpressionResolver;
            this.ccsCheckCompatibility = SearchService.CCS_VERSION_CHECK_SETTING.get(clusterService.getSettings());
        }

        @Override
        protected void doExecute(Task task, Request request, ActionListener<Response> listener) {
            if (this.ccsCheckCompatibility) {
                TransportSearchHelper.checkCCSVersionCompatibility(request);
            }
            ClusterState clusterState = this.clusterService.state();
            Map<String, OriginalIndices> remoteClusterIndices = this.remoteClusterService.groupIndices(request.indicesOptions(), request.indices());
            OriginalIndices localIndices = remoteClusterIndices.remove("");
            ArrayList<ResolvedIndex> indices = new ArrayList<ResolvedIndex>();
            ArrayList<ResolvedAlias> aliases = new ArrayList<ResolvedAlias>();
            ArrayList<ResolvedDataStream> dataStreams = new ArrayList<ResolvedDataStream>();
            TransportAction.resolveIndices(localIndices, clusterState, this.indexNameExpressionResolver, indices, aliases, dataStreams);
            if (remoteClusterIndices.size() > 0) {
                int remoteRequests = remoteClusterIndices.size();
                CountDown completionCounter = new CountDown(remoteRequests);
                SortedMap remoteResponses = Collections.synchronizedSortedMap(new TreeMap());
                Runnable terminalHandler = () -> {
                    if (completionCounter.countDown()) {
                        TransportAction.mergeResults(remoteResponses, indices, aliases, dataStreams);
                        listener.onResponse(new Response(indices, aliases, dataStreams));
                    }
                };
                for (Map.Entry<String, OriginalIndices> remoteIndices : remoteClusterIndices.entrySet()) {
                    String clusterAlias = remoteIndices.getKey();
                    OriginalIndices originalIndices = remoteIndices.getValue();
                    RemoteClusterClient remoteClusterClient = this.remoteClusterService.getRemoteClusterClient(clusterAlias, EsExecutors.DIRECT_EXECUTOR_SERVICE, RemoteClusterService.DisconnectedStrategy.RECONNECT_UNLESS_SKIP_UNAVAILABLE);
                    Request remoteRequest = new Request(originalIndices.indices(), originalIndices.indicesOptions());
                    remoteClusterClient.execute(REMOTE_TYPE, remoteRequest, ActionListener.wrap(response -> {
                        remoteResponses.put(clusterAlias, response);
                        terminalHandler.run();
                    }, failure -> terminalHandler.run()));
                }
            } else {
                listener.onResponse(new Response(indices, aliases, dataStreams));
            }
        }

        static void resolveIndices(@Nullable OriginalIndices localIndices, ClusterState clusterState, IndexNameExpressionResolver resolver, List<ResolvedIndex> indices, List<ResolvedAlias> aliases, List<ResolvedDataStream> dataStreams) {
            if (localIndices == null) {
                return;
            }
            TransportAction.resolveIndices(localIndices.indices(), localIndices.indicesOptions(), clusterState, resolver, indices, aliases, dataStreams);
        }

        static void resolveIndices(String[] names, IndicesOptions indicesOptions, ClusterState clusterState, IndexNameExpressionResolver resolver, List<ResolvedIndex> indices, List<ResolvedAlias> aliases, List<ResolvedDataStream> dataStreams) {
            if (names.length == 0) {
                return;
            }
            if (names.length == 1 && ("_all".equals(names[0]) || Regex.isMatchAllPattern(names[0]))) {
                names = new String[]{"**"};
            }
            Set<IndexNameExpressionResolver.ResolvedExpression> resolvedIndexAbstractions = resolver.resolveExpressions(clusterState, indicesOptions, true, names);
            for (IndexNameExpressionResolver.ResolvedExpression s : resolvedIndexAbstractions) {
                TransportAction.enrichIndexAbstraction(clusterState, s, indices, aliases, dataStreams);
            }
            indices.sort(Comparator.comparing(ResolvedIndexAbstraction::getName));
            aliases.sort(Comparator.comparing(ResolvedIndexAbstraction::getName));
            dataStreams.sort(Comparator.comparing(ResolvedIndexAbstraction::getName));
        }

        private static void mergeResults(Map<String, Response> remoteResponses, List<ResolvedIndex> indices, List<ResolvedAlias> aliases, List<ResolvedDataStream> dataStreams) {
            for (Map.Entry<String, Response> responseEntry : remoteResponses.entrySet()) {
                String clusterAlias = responseEntry.getKey();
                Response response = responseEntry.getValue();
                for (ResolvedIndex index : response.indices) {
                    indices.add(index.copy(RemoteClusterAware.buildRemoteIndexName(clusterAlias, index.getName())));
                }
                for (ResolvedAlias alias : response.aliases) {
                    aliases.add(alias.copy(RemoteClusterAware.buildRemoteIndexName(clusterAlias, alias.getName())));
                }
                for (ResolvedDataStream dataStream : response.dataStreams) {
                    dataStreams.add(dataStream.copy(RemoteClusterAware.buildRemoteIndexName(clusterAlias, dataStream.getName())));
                }
            }
        }

        private static void enrichIndexAbstraction(ClusterState clusterState, IndexNameExpressionResolver.ResolvedExpression resolvedExpression, List<ResolvedIndex> indices, List<ResolvedAlias> aliases, List<ResolvedDataStream> dataStreams) {
            SortedMap<String, IndexAbstraction> indicesLookup = clusterState.metadata().getIndicesLookup();
            IndexAbstraction ia = (IndexAbstraction)indicesLookup.get(resolvedExpression.resource());
            if (ia != null) {
                switch (ia.getType()) {
                    case CONCRETE_INDEX: {
                        boolean isFrozen;
                        IndexMetadata writeIndex = clusterState.metadata().index(ia.getWriteIndex());
                        String[] aliasNames = (String[])writeIndex.getAliases().keySet().stream().sorted().toArray(String[]::new);
                        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
                        attributes.add(writeIndex.getState() == IndexMetadata.State.OPEN ? Attribute.OPEN : Attribute.CLOSED);
                        if (ia.isHidden()) {
                            attributes.add(Attribute.HIDDEN);
                        }
                        if (ia.isSystem()) {
                            attributes.add(Attribute.SYSTEM);
                        }
                        if (isFrozen = Boolean.parseBoolean(writeIndex.getSettings().get("index.frozen"))) {
                            attributes.add(Attribute.FROZEN);
                        }
                        attributes.sort(Comparator.comparing(e -> e.name().toLowerCase(Locale.ROOT)));
                        indices.add(new ResolvedIndex(ia.getName(), aliasNames, (String[])attributes.stream().map(Enum::name).map(e -> e.toLowerCase(Locale.ROOT)).toArray(String[]::new), ia.getParentDataStream() == null ? null : ia.getParentDataStream().getName()));
                        break;
                    }
                    case ALIAS: {
                        Object[] indexNames = (String[])TransportAction.getAliasIndexStream(resolvedExpression, ia, clusterState.metadata()).map(Index::getName).toArray(String[]::new);
                        Arrays.sort(indexNames);
                        aliases.add(new ResolvedAlias(ia.getName(), (String[])indexNames));
                        break;
                    }
                    case DATA_STREAM: {
                        Stream stream;
                        DataStream dataStream = (DataStream)ia;
                        if (resolvedExpression.selector() == null) {
                            stream = dataStream.getIndices().stream();
                        } else {
                            switch (resolvedExpression.selector()) {
                                default: {
                                    throw new IncompatibleClassChangeError();
                                }
                                case DATA: {
                                    stream = dataStream.getDataComponent().getIndices().stream();
                                    break;
                                }
                                case FAILURES: {
                                    stream = dataStream.getFailureIndices().stream();
                                }
                            }
                        }
                        Stream dataStreamIndices = stream;
                        String[] backingIndices = (String[])dataStreamIndices.map(Index::getName).toArray(String[]::new);
                        dataStreams.add(new ResolvedDataStream(dataStream.getName(), backingIndices, "@timestamp"));
                        break;
                    }
                    default: {
                        throw new IllegalStateException("unknown index abstraction type: " + String.valueOf((Object)ia.getType()));
                    }
                }
            }
        }

        private static Stream<Index> getAliasIndexStream(IndexNameExpressionResolver.ResolvedExpression resolvedExpression, IndexAbstraction ia, Metadata metadata) {
            Stream<Index> aliasIndices;
            if (resolvedExpression.selector() == null) {
                aliasIndices = ia.getIndices().stream();
            } else {
                aliasIndices = switch (resolvedExpression.selector()) {
                    default -> throw new IncompatibleClassChangeError();
                    case IndexComponentSelector.DATA -> ia.getIndices().stream();
                    case IndexComponentSelector.FAILURES -> {
                        if (!$assertionsDisabled && !ia.isDataStreamRelated()) {
                            throw new AssertionError((Object)"Illegal selector [failures] used on non data stream alias");
                        }
                        yield ia.getFailureIndices(metadata).stream();
                    }
                };
            }
            return aliasIndices;
        }

        static enum Attribute {
            OPEN,
            CLOSED,
            HIDDEN,
            SYSTEM,
            FROZEN;

        }
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        static final ParseField INDICES_FIELD = new ParseField("indices", new String[0]);
        static final ParseField ALIASES_FIELD = new ParseField("aliases", new String[0]);
        static final ParseField DATA_STREAMS_FIELD = new ParseField("data_streams", new String[0]);
        private final List<ResolvedIndex> indices;
        private final List<ResolvedAlias> aliases;
        private final List<ResolvedDataStream> dataStreams;

        public Response(List<ResolvedIndex> indices, List<ResolvedAlias> aliases, List<ResolvedDataStream> dataStreams) {
            this.indices = indices;
            this.aliases = aliases;
            this.dataStreams = dataStreams;
        }

        public Response(StreamInput in) throws IOException {
            this.indices = in.readCollectionAsList(ResolvedIndex::new);
            this.aliases = in.readCollectionAsList(ResolvedAlias::new);
            this.dataStreams = in.readCollectionAsList(ResolvedDataStream::new);
        }

        public List<ResolvedIndex> getIndices() {
            return this.indices;
        }

        public List<ResolvedAlias> getAliases() {
            return this.aliases;
        }

        public List<ResolvedDataStream> getDataStreams() {
            return this.dataStreams;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeCollection(this.indices);
            out.writeCollection(this.aliases);
            out.writeCollection(this.dataStreams);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.xContentList(INDICES_FIELD.getPreferredName(), this.indices);
            builder.xContentList(ALIASES_FIELD.getPreferredName(), this.aliases);
            builder.xContentList(DATA_STREAMS_FIELD.getPreferredName(), this.dataStreams);
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Response response = (Response)o;
            return this.indices.equals(response.indices) && this.aliases.equals(response.aliases) && this.dataStreams.equals(response.dataStreams);
        }

        public int hashCode() {
            return Objects.hash(this.indices, this.aliases, this.dataStreams);
        }
    }

    public static class ResolvedDataStream
    extends ResolvedIndexAbstraction
    implements Writeable,
    ToXContentObject {
        static final ParseField BACKING_INDICES_FIELD = new ParseField("backing_indices", new String[0]);
        static final ParseField TIMESTAMP_FIELD = new ParseField("timestamp_field", new String[0]);
        private final String[] backingIndices;
        private final String timestampField;

        ResolvedDataStream(StreamInput in) throws IOException {
            this.setName(in.readString());
            this.backingIndices = in.readStringArray();
            this.timestampField = in.readString();
        }

        ResolvedDataStream(String name, String[] backingIndices, String timestampField) {
            super(name);
            this.backingIndices = backingIndices;
            this.timestampField = timestampField;
        }

        public ResolvedDataStream copy(String newName) {
            return new ResolvedDataStream(newName, this.backingIndices, this.timestampField);
        }

        public String[] getBackingIndices() {
            return this.backingIndices;
        }

        public String getTimestampField() {
            return this.timestampField;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.getName());
            out.writeStringArray(this.backingIndices);
            out.writeString(this.timestampField);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(NAME_FIELD.getPreferredName(), this.getName());
            builder.array(BACKING_INDICES_FIELD.getPreferredName(), this.backingIndices);
            builder.field(TIMESTAMP_FIELD.getPreferredName(), this.timestampField);
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ResolvedDataStream dataStream = (ResolvedDataStream)o;
            return this.getName().equals(dataStream.getName()) && this.timestampField.equals(dataStream.timestampField) && Arrays.equals(this.backingIndices, dataStream.backingIndices);
        }

        public int hashCode() {
            int result = Objects.hash(this.getName(), this.timestampField);
            result = 31 * result + Arrays.hashCode(this.backingIndices);
            return result;
        }
    }

    public static class ResolvedAlias
    extends ResolvedIndexAbstraction
    implements Writeable,
    ToXContentObject {
        static final ParseField INDICES_FIELD = new ParseField("indices", new String[0]);
        private final String[] indices;

        ResolvedAlias(StreamInput in) throws IOException {
            this.setName(in.readString());
            this.indices = in.readStringArray();
        }

        ResolvedAlias(String name, String[] indices) {
            super(name);
            this.indices = indices;
        }

        public ResolvedAlias copy(String newName) {
            return new ResolvedAlias(newName, this.indices);
        }

        public String[] getIndices() {
            return this.indices;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.getName());
            out.writeStringArray(this.indices);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(NAME_FIELD.getPreferredName(), this.getName());
            if (this.indices.length > 0) {
                builder.array(INDICES_FIELD.getPreferredName(), this.indices);
            }
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ResolvedAlias alias = (ResolvedAlias)o;
            return this.getName().equals(alias.getName()) && Arrays.equals(this.indices, alias.indices);
        }

        public int hashCode() {
            int result = Objects.hash(this.getName());
            result = 31 * result + Arrays.hashCode(this.indices);
            return result;
        }
    }

    public static class ResolvedIndex
    extends ResolvedIndexAbstraction
    implements Writeable,
    ToXContentObject {
        static final ParseField ALIASES_FIELD = new ParseField("aliases", new String[0]);
        static final ParseField ATTRIBUTES_FIELD = new ParseField("attributes", new String[0]);
        static final ParseField DATA_STREAM_FIELD = new ParseField("data_stream", new String[0]);
        private final String[] aliases;
        private final String[] attributes;
        private final String dataStream;

        ResolvedIndex(StreamInput in) throws IOException {
            this.setName(in.readString());
            this.aliases = in.readStringArray();
            this.attributes = in.readStringArray();
            this.dataStream = in.readOptionalString();
        }

        ResolvedIndex(String name, String[] aliases, String[] attributes, @Nullable String dataStream) {
            super(name);
            this.aliases = aliases;
            this.attributes = attributes;
            this.dataStream = dataStream;
        }

        public ResolvedIndex copy(String newName) {
            return new ResolvedIndex(newName, this.aliases, this.attributes, this.dataStream);
        }

        public String[] getAliases() {
            return this.aliases;
        }

        public String[] getAttributes() {
            return this.attributes;
        }

        public String getDataStream() {
            return this.dataStream;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.getName());
            out.writeStringArray(this.aliases);
            out.writeStringArray(this.attributes);
            out.writeOptionalString(this.dataStream);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(NAME_FIELD.getPreferredName(), this.getName());
            if (this.aliases.length > 0) {
                builder.array(ALIASES_FIELD.getPreferredName(), this.aliases);
            }
            builder.array(ATTRIBUTES_FIELD.getPreferredName(), this.attributes);
            if (!Strings.isNullOrEmpty(this.dataStream)) {
                builder.field(DATA_STREAM_FIELD.getPreferredName(), this.dataStream);
            }
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ResolvedIndex index = (ResolvedIndex)o;
            return this.getName().equals(index.getName()) && Objects.equals(this.dataStream, index.dataStream) && Arrays.equals(this.aliases, index.aliases) && Arrays.equals(this.attributes, index.attributes);
        }

        public int hashCode() {
            int result = Objects.hash(this.getName(), this.dataStream);
            result = 31 * result + Arrays.hashCode(this.aliases);
            result = 31 * result + Arrays.hashCode(this.attributes);
            return result;
        }
    }

    public static class ResolvedIndexAbstraction {
        static final ParseField NAME_FIELD = new ParseField("name", new String[0]);
        private String name;

        ResolvedIndexAbstraction() {
        }

        ResolvedIndexAbstraction(String name) {
            this.name = name;
        }

        protected void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    public static class Request
    extends ActionRequest
    implements IndicesRequest.Replaceable {
        public static final IndicesOptions DEFAULT_INDICES_OPTIONS = IndicesOptions.strictExpandOpen();
        private String[] names;
        private IndicesOptions indicesOptions = DEFAULT_INDICES_OPTIONS;

        public Request(String[] names) {
            this.names = names;
        }

        public Request(String[] names, IndicesOptions indicesOptions) {
            this.names = names;
            this.indicesOptions = indicesOptions;
        }

        @Override
        public ActionRequestValidationException validate() {
            return null;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.names = in.readStringArray();
            this.indicesOptions = IndicesOptions.readIndicesOptions(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeStringArray(this.names);
            this.indicesOptions.writeIndicesOptions(out);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)o;
            return Arrays.equals(this.names, request.names);
        }

        public int hashCode() {
            return Arrays.hashCode(this.names);
        }

        @Override
        public String[] indices() {
            return this.names;
        }

        @Override
        public IndicesOptions indicesOptions() {
            return this.indicesOptions;
        }

        @Override
        public IndicesRequest indices(String ... indices) {
            this.names = indices;
            return this;
        }

        @Override
        public boolean allowsRemoteIndices() {
            return true;
        }

        @Override
        public boolean includeDataStreams() {
            return true;
        }
    }
}

