/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.inference;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentParseException;
import org.elasticsearch.xcontent.XContentParser;

public record UnifiedCompletionRequest(List<Message> messages, @Nullable String model, @Nullable Long maxCompletionTokens, @Nullable List<String> stop, @Nullable Float temperature, @Nullable ToolChoice toolChoice, @Nullable List<Tool> tools, @Nullable Float topP) implements Writeable
{
    public static final ConstructingObjectParser<UnifiedCompletionRequest, Void> PARSER = new ConstructingObjectParser(UnifiedCompletionRequest.class.getSimpleName(), args -> new UnifiedCompletionRequest((List)args[0], (String)args[1], (Long)args[2], (List)args[3], (Float)args[4], (ToolChoice)args[5], (List)args[6], (Float)args[7]));

    public UnifiedCompletionRequest(StreamInput in) throws IOException {
        this(in.readCollectionAsImmutableList(Message::new), in.readOptionalString(), in.readOptionalVLong(), in.readOptionalStringCollectionAsList(), in.readOptionalFloat(), in.readOptionalNamedWriteable(ToolChoice.class), in.readOptionalCollectionAsList(Tool::new), in.readOptionalFloat());
    }

    public static List<NamedWriteableRegistry.Entry> getNamedWriteables() {
        return List.of(new NamedWriteableRegistry.Entry(Content.class, "content_objects", ContentObjects::new), new NamedWriteableRegistry.Entry(Content.class, "content_string", ContentString::new), new NamedWriteableRegistry.Entry(ToolChoice.class, "tool_choice_object", ToolChoiceObject::new), new NamedWriteableRegistry.Entry(ToolChoice.class, "tool_choice_string", ToolChoiceString::new));
    }

    public static UnifiedCompletionRequest of(List<Message> messages) {
        return new UnifiedCompletionRequest(messages, null, null, null, null, null, null, null);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeCollection(this.messages);
        out.writeOptionalString(this.model);
        out.writeOptionalVLong(this.maxCompletionTokens);
        out.writeOptionalStringCollection(this.stop);
        out.writeOptionalFloat(this.temperature);
        out.writeOptionalNamedWriteable(this.toolChoice);
        out.writeOptionalCollection(this.tools);
        out.writeOptionalFloat(this.topP);
    }

    private static ToolChoice parseToolChoice(XContentParser parser) throws IOException {
        XContentParser.Token token = parser.currentToken();
        if (token == XContentParser.Token.START_OBJECT) {
            return (ToolChoice)ToolChoiceObject.PARSER.apply(parser, null);
        }
        if (token == XContentParser.Token.VALUE_STRING) {
            return ToolChoiceString.of(parser);
        }
        throw new XContentParseException("Unsupported token [" + String.valueOf(token) + "]");
    }

    static {
        PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), (arg_0, arg_1) -> Message.PARSER.apply(arg_0, arg_1), new ParseField("messages", new String[0]));
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField("model", new String[0]));
        PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), new ParseField("max_completion_tokens", new String[0]));
        PARSER.declareStringArray(ConstructingObjectParser.optionalConstructorArg(), new ParseField("stop", new String[0]));
        PARSER.declareFloat(ConstructingObjectParser.optionalConstructorArg(), new ParseField("temperature", new String[0]));
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> UnifiedCompletionRequest.parseToolChoice(p), new ParseField("tool_choice", new String[0]), ObjectParser.ValueType.OBJECT_OR_STRING);
        PARSER.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), (arg_0, arg_1) -> Tool.PARSER.apply(arg_0, arg_1), new ParseField("tools", new String[0]));
        PARSER.declareFloat(ConstructingObjectParser.optionalConstructorArg(), new ParseField("top_p", new String[0]));
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface ToolChoice
    extends NamedWriteable {
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface Content
    extends NamedWriteable {
    }

    public record ContentObjects(List<ContentObject> contentObjects) implements Content,
    NamedWriteable
    {
        public static final String NAME = "content_objects";

        public ContentObjects(StreamInput in) throws IOException {
            this(in.readCollectionAsImmutableList(ContentObject::new));
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeCollection(this.contentObjects);
        }

        @Override
        public String getWriteableName() {
            return NAME;
        }
    }

    public record ContentString(String content) implements Content,
    NamedWriteable
    {
        public static final String NAME = "content_string";

        public ContentString(StreamInput in) throws IOException {
            this(in.readString());
        }

        public static ContentString of(XContentParser parser) throws IOException {
            String content = parser.text();
            return new ContentString(content);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.content);
        }

        @Override
        public String getWriteableName() {
            return NAME;
        }

        @Override
        public String toString() {
            return this.content;
        }
    }

    public record ToolChoiceObject(String type, FunctionField function) implements ToolChoice,
    NamedWriteable
    {
        public static final String NAME = "tool_choice_object";
        static final ConstructingObjectParser<ToolChoiceObject, Void> PARSER = new ConstructingObjectParser(ToolChoiceObject.class.getSimpleName(), args -> new ToolChoiceObject((String)args[0], (FunctionField)args[1]));

        public ToolChoiceObject(StreamInput in) throws IOException {
            this(in.readString(), new FunctionField(in));
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.type);
            this.function.writeTo(out);
        }

        @Override
        public String getWriteableName() {
            return NAME;
        }

        static {
            PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("type", new String[0]));
            PARSER.declareObject(ConstructingObjectParser.constructorArg(), (arg_0, arg_1) -> FunctionField.PARSER.apply(arg_0, arg_1), new ParseField("function", new String[0]));
        }

        public record FunctionField(String name) implements Writeable
        {
            static final ConstructingObjectParser<FunctionField, Void> PARSER = new ConstructingObjectParser("tool_choice_function_field", args -> new FunctionField((String)args[0]));

            public FunctionField(StreamInput in) throws IOException {
                this(in.readString());
            }

            @Override
            public void writeTo(StreamOutput out) throws IOException {
                out.writeString(this.name);
            }

            static {
                PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("name", new String[0]));
            }
        }
    }

    public record ToolChoiceString(String value) implements ToolChoice,
    NamedWriteable
    {
        public static final String NAME = "tool_choice_string";

        public ToolChoiceString(StreamInput in) throws IOException {
            this(in.readString());
        }

        public static ToolChoiceString of(XContentParser parser) throws IOException {
            String content = parser.text();
            return new ToolChoiceString(content);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.value);
        }

        @Override
        public String getWriteableName() {
            return NAME;
        }
    }

    public record Message(Content content, String role, @Nullable String toolCallId, @Nullable List<ToolCall> toolCalls) implements Writeable
    {
        static final ConstructingObjectParser<Message, Void> PARSER = new ConstructingObjectParser(Message.class.getSimpleName(), args -> new Message((Content)args[0], (String)args[1], (String)args[2], (List)args[3]));

        public Message(StreamInput in) throws IOException {
            this(in.readOptionalNamedWriteable(Content.class), in.readString(), in.readOptionalString(), in.readOptionalCollectionAsList(ToolCall::new));
        }

        private static Content parseContent(XContentParser parser) throws IOException {
            XContentParser.Token token = parser.currentToken();
            if (token == XContentParser.Token.START_ARRAY) {
                List<ContentObject> parsedContentObjects = XContentParserUtils.parseList(parser, p -> (ContentObject)ContentObject.PARSER.apply(p, null));
                return new ContentObjects(parsedContentObjects);
            }
            if (token == XContentParser.Token.VALUE_STRING) {
                return ContentString.of(parser);
            }
            throw new XContentParseException("Expected an array start token or a value string token but found token [" + String.valueOf(token) + "]");
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeOptionalNamedWriteable(this.content);
            out.writeString(this.role);
            out.writeOptionalString(this.toolCallId);
            out.writeOptionalCollection(this.toolCalls);
        }

        static {
            PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> Message.parseContent(p), new ParseField("content", new String[0]), ObjectParser.ValueType.VALUE_ARRAY);
            PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("role", new String[0]));
            PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField("tool_call_id", new String[0]));
            PARSER.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), (arg_0, arg_1) -> ToolCall.PARSER.apply(arg_0, arg_1), new ParseField("tool_calls", new String[0]));
        }
    }

    public record Tool(String type, FunctionField function) implements Writeable
    {
        static final ConstructingObjectParser<Tool, Void> PARSER = new ConstructingObjectParser(Tool.class.getSimpleName(), args -> new Tool((String)args[0], (FunctionField)args[1]));

        public Tool(StreamInput in) throws IOException {
            this(in.readString(), new FunctionField(in));
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.type);
            this.function.writeTo(out);
        }

        static {
            PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("type", new String[0]));
            PARSER.declareObject(ConstructingObjectParser.constructorArg(), (arg_0, arg_1) -> FunctionField.PARSER.apply(arg_0, arg_1), new ParseField("function", new String[0]));
        }

        public record FunctionField(@Nullable String description, String name, @Nullable Map<String, Object> parameters, @Nullable Boolean strict) implements Writeable
        {
            static final ConstructingObjectParser<FunctionField, Void> PARSER = new ConstructingObjectParser("tool_function_field", args -> new FunctionField((String)args[0], (String)args[1], (Map)args[2], (Boolean)args[3]));

            public FunctionField(StreamInput in) throws IOException {
                this(in.readOptionalString(), in.readString(), in.readGenericMap(), in.readOptionalBoolean());
            }

            @Override
            public void writeTo(StreamOutput out) throws IOException {
                out.writeOptionalString(this.description);
                out.writeString(this.name);
                out.writeGenericMap(this.parameters);
                out.writeOptionalBoolean(this.strict);
            }

            static {
                PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField("description", new String[0]));
                PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("name", new String[0]));
                PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.mapOrdered(), new ParseField("parameters", new String[0]));
                PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), new ParseField("strict", new String[0]));
            }
        }
    }

    public record ToolCall(String id, FunctionField function, String type) implements Writeable
    {
        static final ConstructingObjectParser<ToolCall, Void> PARSER = new ConstructingObjectParser(ToolCall.class.getSimpleName(), args -> new ToolCall((String)args[0], (FunctionField)args[1], (String)args[2]));

        public ToolCall(StreamInput in) throws IOException {
            this(in.readString(), new FunctionField(in), in.readString());
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.id);
            this.function.writeTo(out);
            out.writeString(this.type);
        }

        static {
            PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("id", new String[0]));
            PARSER.declareObject(ConstructingObjectParser.constructorArg(), (arg_0, arg_1) -> FunctionField.PARSER.apply(arg_0, arg_1), new ParseField("function", new String[0]));
            PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("type", new String[0]));
        }

        public record FunctionField(String arguments, String name) implements Writeable
        {
            static final ConstructingObjectParser<FunctionField, Void> PARSER = new ConstructingObjectParser("tool_call_function_field", args -> new FunctionField((String)args[0], (String)args[1]));

            public FunctionField(StreamInput in) throws IOException {
                this(in.readString(), in.readString());
            }

            @Override
            public void writeTo(StreamOutput out) throws IOException {
                out.writeString(this.arguments);
                out.writeString(this.name);
            }

            static {
                PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("arguments", new String[0]));
                PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("name", new String[0]));
            }
        }
    }

    public record ContentObject(String text, String type) implements Writeable
    {
        static final ConstructingObjectParser<ContentObject, Void> PARSER = new ConstructingObjectParser(ContentObject.class.getSimpleName(), args -> new ContentObject((String)args[0], (String)args[1]));

        public ContentObject(StreamInput in) throws IOException {
            this(in.readString(), in.readString());
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.text);
            out.writeString(this.type);
        }

        @Override
        public String toString() {
            return this.text + ":" + this.type;
        }

        static {
            PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("text", new String[0]));
            PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("type", new String[0]));
        }
    }
}

