/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.mapper.OnScriptError;
import org.elasticsearch.script.CompositeFieldScript;
import org.elasticsearch.script.DocBasedScript;
import org.elasticsearch.script.DocReader;
import org.elasticsearch.script.DocValuesDocReader;
import org.elasticsearch.script.DynamicMap;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.search.lookup.SearchLookup;
import org.elasticsearch.search.lookup.Source;

public abstract class AbstractFieldScript
extends DocBasedScript {
    public static final int MAX_VALUES = 100;
    private static final Map<String, Function<Object, Object>> PARAMS_FUNCTIONS = Map.of("_source", value -> ((Source)((Supplier)value).get()).source());
    protected final String fieldName;
    protected final Supplier<Source> source;
    private final Map<String, Object> params;
    private final OnScriptError onScriptError;

    protected static <F> ScriptContext<F> newContext(String name, Class<F> factoryClass) {
        return new ScriptContext<F>(name, factoryClass, 100, TimeValue.timeValueMillis((long)0L), false, false);
    }

    public AbstractFieldScript(String fieldName, Map<String, Object> params, SearchLookup searchLookup, LeafReaderContext ctx, OnScriptError onScriptError) {
        this(fieldName, params, new DocValuesDocReader(searchLookup, ctx), onScriptError);
    }

    private AbstractFieldScript(String fieldName, Map<String, Object> params, DocReader docReader, OnScriptError onScriptError) {
        super(docReader);
        this.fieldName = fieldName;
        this.source = docReader.source();
        params = new HashMap<String, Object>(params);
        params.put("_source", this.source);
        params.put("_fields", docReader.docAsMap().get("_fields"));
        this.params = new DynamicMap(params, PARAMS_FUNCTIONS);
        this.onScriptError = onScriptError;
    }

    public final Map<String, Object> getParams() {
        return this.params;
    }

    protected List<Object> extractFromSource(String path) {
        return XContentMapValues.extractRawValues(path, this.source.get().source());
    }

    protected final void emitFromCompositeScript(CompositeFieldScript compositeFieldScript) {
        List<Object> values = compositeFieldScript.getValues(this.fieldName);
        if (values == null) {
            return;
        }
        for (Object value : values) {
            this.emitValueFromCompositeScript(value);
        }
    }

    protected void emitValueFromCompositeScript(Object value) {
        this.emitFromObject(value);
    }

    protected abstract void emitFromObject(Object var1);

    protected final void emitFromSource() {
        for (Object v : this.extractFromSource(this.fieldName)) {
            this.emitFromObject(v);
        }
    }

    protected final void checkMaxSize(int currentSize) {
        if (currentSize >= 100) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Runtime field [%s] is emitting [%s] values while the maximum number of values allowed is [%s]", this.fieldName, currentSize + 1, 100));
        }
    }

    protected abstract void prepareExecute();

    public final void runForDoc(int docId) {
        block2: {
            this.prepareExecute();
            this.setDocument(docId);
            try {
                this.execute();
            }
            catch (Exception e) {
                if (this.onScriptError == OnScriptError.CONTINUE) break block2;
                throw e;
            }
        }
    }

    public abstract void execute();
}

