/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;

public class ScriptException
extends ElasticsearchException {
    private final List<String> scriptStack;
    private final String script;
    private final String lang;
    private final Position pos;

    public ScriptException(String message, Throwable cause, List<String> scriptStack, String script, String lang, Position pos) {
        super(Objects.requireNonNull(message), Objects.requireNonNull(cause), new Object[0]);
        this.scriptStack = Collections.unmodifiableList(Objects.requireNonNull(scriptStack));
        this.script = Objects.requireNonNull(script);
        this.lang = Objects.requireNonNull(lang);
        this.pos = pos;
    }

    public ScriptException(String message, Throwable cause, List<String> scriptStack, String script, String lang) {
        this(message, cause, scriptStack, script, lang, null);
    }

    public ScriptException(StreamInput in) throws IOException {
        super(in);
        this.scriptStack = Arrays.asList(in.readStringArray());
        this.script = in.readString();
        this.lang = in.readString();
        this.pos = in.getTransportVersion().onOrAfter(TransportVersions.V_7_7_0) && in.readBoolean() ? new Position(in) : null;
    }

    @Override
    protected void writeTo(StreamOutput out, Writeable.Writer<Throwable> nestedExceptionsWriter) throws IOException {
        super.writeTo(out, nestedExceptionsWriter);
        out.writeStringCollection(this.scriptStack);
        out.writeString(this.script);
        out.writeString(this.lang);
        if (out.getTransportVersion().onOrAfter(TransportVersions.V_7_7_0)) {
            if (this.pos == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                this.pos.writeTo(out);
            }
        }
    }

    @Override
    protected void metadataToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("script_stack", this.scriptStack);
        builder.field("script", this.script);
        builder.field("lang", this.lang);
        if (this.pos != null) {
            this.pos.toXContent(builder, params);
        }
    }

    public List<String> getScriptStack() {
        return this.scriptStack;
    }

    public String getScript() {
        return this.script;
    }

    public String getLang() {
        return this.lang;
    }

    public Position getPos() {
        return this.pos;
    }

    public String toJsonString() {
        try {
            XContentBuilder json = XContentFactory.jsonBuilder().prettyPrint();
            json.startObject();
            this.toXContent(json, ToXContent.EMPTY_PARAMS);
            json.endObject();
            return Strings.toString(json);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public RestStatus status() {
        return RestStatus.BAD_REQUEST;
    }

    public static class Position {
        public final int offset;
        public final int start;
        public final int end;

        public Position(int offset, int start, int end) {
            this.offset = offset;
            this.start = start;
            this.end = end;
        }

        Position(StreamInput in) throws IOException {
            this.offset = in.readInt();
            this.start = in.readInt();
            this.end = in.readInt();
        }

        void writeTo(StreamOutput out) throws IOException {
            out.writeInt(this.offset);
            out.writeInt(this.start);
            out.writeInt(this.end);
        }

        void toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject("position");
            builder.field("offset", this.offset);
            builder.field("start", this.start);
            builder.field("end", this.end);
            builder.endObject();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Position position = (Position)o;
            return this.offset == position.offset && this.start == position.start && this.end == position.end;
        }

        public int hashCode() {
            return Objects.hash(this.offset, this.start, this.end);
        }
    }
}

