/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.searchbusinessrules;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public final class SpecifiedDocument
implements ToXContentObject,
Writeable {
    public static final TransportVersion OPTIONAL_INDEX_IN_DOCS_VERSION = TransportVersions.V_8_11_X;
    public static final String NAME = "specified_document";
    public static final ParseField INDEX_FIELD = new ParseField("_index", new String[0]);
    public static final ParseField ID_FIELD = new ParseField("_id", new String[0]);
    private final String index;
    private final String id;
    static final ConstructingObjectParser<SpecifiedDocument, Void> PARSER = new ConstructingObjectParser("specified_document", a -> new SpecifiedDocument((String)a[0], (String)a[1]));

    public SpecifiedDocument(String index, String id) {
        if (index != null && Regex.isSimpleMatchPattern((String)index)) {
            throw new IllegalArgumentException("Specified document index cannot contain wildcard expressions");
        }
        if (id == null) {
            throw new IllegalArgumentException("Specified document requires id to be non-null");
        }
        this.index = index;
        this.id = id;
    }

    public SpecifiedDocument(StreamInput in) throws IOException {
        this.index = in.getTransportVersion().onOrAfter((VersionId)OPTIONAL_INDEX_IN_DOCS_VERSION) ? in.readOptionalString() : in.readString();
        this.id = in.readString();
    }

    public void writeTo(StreamOutput out) throws IOException {
        if (out.getTransportVersion().onOrAfter((VersionId)OPTIONAL_INDEX_IN_DOCS_VERSION)) {
            out.writeOptionalString(this.index);
        } else {
            if (this.index == null) {
                throw new IllegalArgumentException("[_index] needs to be specified for docs elements when cluster nodes are not in the same version");
            }
            out.writeString(this.index);
        }
        out.writeString(this.id);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.index != null) {
            builder.field(INDEX_FIELD.getPreferredName(), this.index);
        }
        builder.field(ID_FIELD.getPreferredName(), this.id);
        return builder.endObject();
    }

    public String toString() {
        return Strings.toString((ToXContent)this, (boolean)true, (boolean)true);
    }

    public int hashCode() {
        return Objects.hash(this.index, this.id);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SpecifiedDocument)) {
            return false;
        }
        SpecifiedDocument other = (SpecifiedDocument)o;
        return Objects.equals(this.index, other.index) && Objects.equals(this.id, other.id);
    }

    public String id() {
        return this.id;
    }

    public String index() {
        return this.index;
    }

    static {
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), INDEX_FIELD);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), ID_FIELD);
    }
}

