/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.transform.transforms;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.internal.ParentTaskAssigningClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.core.Predicates;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.persistent.AllocatedPersistentTask;
import org.elasticsearch.persistent.PersistentTaskState;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.persistent.PersistentTasksService;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.tasks.TaskManager;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.core.indexing.IndexerState;
import org.elasticsearch.xpack.core.transform.TransformMessages;
import org.elasticsearch.xpack.core.transform.action.StartTransformAction;
import org.elasticsearch.xpack.core.transform.transforms.AuthorizationState;
import org.elasticsearch.xpack.core.transform.transforms.SettingsConfig;
import org.elasticsearch.xpack.core.transform.transforms.TransformCheckpointingInfo;
import org.elasticsearch.xpack.core.transform.transforms.TransformConfig;
import org.elasticsearch.xpack.core.transform.transforms.TransformIndexerPosition;
import org.elasticsearch.xpack.core.transform.transforms.TransformIndexerStats;
import org.elasticsearch.xpack.core.transform.transforms.TransformState;
import org.elasticsearch.xpack.core.transform.transforms.TransformTaskParams;
import org.elasticsearch.xpack.core.transform.transforms.TransformTaskState;
import org.elasticsearch.xpack.transform.TransformNode;
import org.elasticsearch.xpack.transform.checkpoint.TransformCheckpointService;
import org.elasticsearch.xpack.transform.notifications.TransformAuditor;
import org.elasticsearch.xpack.transform.transforms.CannotStartFailedTransformException;
import org.elasticsearch.xpack.transform.transforms.ClientTransformIndexer;
import org.elasticsearch.xpack.transform.transforms.ClientTransformIndexerBuilder;
import org.elasticsearch.xpack.transform.transforms.TransformContext;
import org.elasticsearch.xpack.transform.transforms.scheduling.TransformScheduler;

public class TransformTask
extends AllocatedPersistentTask
implements TransformScheduler.Listener,
TransformContext.Listener {
    private static final Logger logger = LogManager.getLogger(TransformTask.class);
    private static final IndexerState[] RUNNING_STATES = new IndexerState[]{IndexerState.STARTED, IndexerState.INDEXING};
    private final TransformTaskParams transform;
    private final TransformScheduler transformScheduler;
    private final ThreadPool threadPool;
    private final TransformAuditor auditor;
    private final TransformIndexerPosition initialPosition;
    private final IndexerState initialIndexerState;
    private final TransformContext context;
    private final TransformNode transformNode;
    private final SetOnce<ClientTransformIndexer> indexer = new SetOnce();

    TransformTask(long id, String type, String action, TaskId parentTask, TransformTaskParams transform, TransformState state, TransformScheduler transformScheduler, TransformAuditor auditor, ThreadPool threadPool, Map<String, String> headers, TransformNode transformNode) {
        super(id, type, action, "data_frame_" + transform.getId(), parentTask, headers);
        this.transform = transform;
        this.transformScheduler = transformScheduler;
        this.threadPool = threadPool;
        this.auditor = auditor;
        IndexerState initialState = IndexerState.STOPPED;
        TransformTaskState initialTaskState = TransformTaskState.STOPPED;
        String initialReason = null;
        long initialCheckpoint = 0L;
        TransformIndexerPosition initialPosition = null;
        if (state != null) {
            initialTaskState = state.getTaskState();
            initialReason = state.getReason();
            IndexerState existingState = state.getIndexerState();
            initialState = existingState.equals((Object)IndexerState.INDEXING) ? IndexerState.STARTED : (existingState.equals((Object)IndexerState.ABORTING) || existingState.equals((Object)IndexerState.STOPPING) ? IndexerState.STOPPED : existingState);
            initialPosition = state.getPosition();
            initialCheckpoint = state.getCheckpoint();
        }
        this.initialIndexerState = initialState;
        this.initialPosition = initialPosition;
        this.context = new TransformContext(initialTaskState, initialReason, initialCheckpoint, transform.from(), this);
        if (state != null) {
            this.context.setAuthState(state.getAuthState());
        }
        this.transformNode = transformNode;
    }

    public String getTransformId() {
        return this.transform.getId();
    }

    public Task.Status getStatus() {
        return this.getState();
    }

    private ClientTransformIndexer getIndexer() {
        return (ClientTransformIndexer)((Object)this.indexer.get());
    }

    public TransformState getState() {
        if (this.getIndexer() == null) {
            return new TransformState(this.context.getTaskState(), this.initialIndexerState, this.initialPosition, this.context.getCheckpoint(), this.context.getStateReason(), null, null, false, this.context.getAuthState());
        }
        return new TransformState(this.context.getTaskState(), ((ClientTransformIndexer)((Object)this.indexer.get())).getState(), (TransformIndexerPosition)((ClientTransformIndexer)((Object)this.indexer.get())).getPosition(), this.context.getCheckpoint(), this.context.getStateReason(), this.getIndexer().getProgress(), null, this.context.shouldStopAtCheckpoint(), this.context.getAuthState());
    }

    public TransformIndexerStats getStats() {
        if (this.getIndexer() == null) {
            return new TransformIndexerStats();
        }
        return (TransformIndexerStats)this.getIndexer().getStats();
    }

    public void getCheckpointingInfo(TransformCheckpointService transformsCheckpointService, ParentTaskAssigningClient parentTaskClient, ActionListener<TransformCheckpointingInfo> listener, TimeValue timeout) {
        ActionListener checkPointInfoListener = ActionListener.wrap(infoBuilder -> {
            if (this.context.getChangesLastDetectedAt() != null) {
                infoBuilder.setChangesLastDetectedAt(this.context.getChangesLastDetectedAt());
            }
            if (this.context.getLastSearchTime() != null) {
                infoBuilder.setLastSearchTime(this.context.getLastSearchTime());
            }
            listener.onResponse((Object)infoBuilder.build());
        }, arg_0 -> listener.onFailure(arg_0));
        ClientTransformIndexer transformIndexer = this.getIndexer();
        if (transformIndexer == null) {
            transformsCheckpointService.getCheckpointingInfo(parentTaskClient, timeout, this.transform.getId(), this.context.getCheckpoint(), this.initialPosition, null, (ActionListener<TransformCheckpointingInfo.TransformCheckpointingInfoBuilder>)checkPointInfoListener);
            return;
        }
        transformsCheckpointService.getCheckpointProvider(parentTaskClient, transformIndexer.getConfig()).getCheckpointingInfo(transformIndexer.getLastCheckpoint(), transformIndexer.getNextCheckpoint(), (TransformIndexerPosition)transformIndexer.getPosition(), transformIndexer.getProgress(), timeout, (ActionListener<TransformCheckpointingInfo.TransformCheckpointingInfoBuilder>)checkPointInfoListener);
    }

    public TransformCheckpointingInfo deriveBasicCheckpointingInfo() {
        ClientTransformIndexer transformIndexer = this.getIndexer();
        if (transformIndexer == null) {
            return TransformCheckpointingInfo.EMPTY;
        }
        return new TransformCheckpointingInfo.TransformCheckpointingInfoBuilder().setLastCheckpoint(transformIndexer.getLastCheckpoint()).setNextCheckpoint(transformIndexer.getNextCheckpoint()).setNextCheckpointPosition((TransformIndexerPosition)transformIndexer.getPosition()).setNextCheckpointProgress(transformIndexer.getProgress()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void start(Long startingCheckpoint, ActionListener<StartTransformAction.Response> listener) {
        logger.debug("[{}] start called with state [{}].", (Object)this.getTransformId(), (Object)this.getState());
        if (this.context.getTaskState() == TransformTaskState.FAILED) {
            listener.onFailure((Exception)((Object)new CannotStartFailedTransformException(TransformMessages.getMessage((String)"Unable to start transform [{0}] as it is in a failed state. Use force stop and then restart the transform once error is resolved. More details: [{1}]", (Object[])new Object[]{this.getTransformId(), this.context.getStateReason()}))));
            return;
        }
        TransformContext transformContext = this.context;
        synchronized (transformContext) {
            if (this.getIndexer() == null) {
                String msg = this.context.getTaskState() == TransformTaskState.FAILED ? "It failed during the initialization process; force stop to allow reinitialization." : "Try again later.";
                listener.onFailure((Exception)new ElasticsearchStatusException("Task for transform [{}] not fully initialized. {}", RestStatus.CONFLICT, new Object[]{this.getTransformId(), msg}));
                return;
            }
            IndexerState newState = this.getIndexer().start();
            if (Arrays.stream(RUNNING_STATES).noneMatch(arg_0 -> newState.equals(arg_0))) {
                listener.onFailure((Exception)new ElasticsearchException("Cannot start task for transform [{}], because state was [{}]", new Object[]{this.transform.getId(), newState}));
                return;
            }
            this.context.resetTaskState();
            if (startingCheckpoint != null) {
                this.context.setCheckpoint(startingCheckpoint);
            }
            TransformState state = new TransformState(TransformTaskState.STARTED, IndexerState.STOPPED, (TransformIndexerPosition)this.getIndexer().getPosition(), this.context.getCheckpoint(), null, this.getIndexer().getProgress(), null, this.context.shouldStopAtCheckpoint(), this.context.getAuthState());
            logger.info("[{}] updating state for transform to [{}].", (Object)this.transform.getId(), (Object)state.toString());
            this.persistStateToClusterState(state, ActionListener.wrap(task -> {
                this.auditor.info(this.transform.getId(), "Updated transform state to [" + String.valueOf(state.getTaskState()) + "].");
                this.transformScheduler.registerTransform(this.transform, this);
                listener.onResponse((Object)new StartTransformAction.Response(true));
            }, exc -> {
                this.auditor.warning(this.transform.getId(), "Failed to persist to cluster state while marking task as started. Failure: " + exc.getMessage());
                logger.error(() -> Strings.format((String)"[%s] failed updating state to [%s].", (Object[])new Object[]{this.getTransformId(), state}), (Throwable)exc);
                this.getIndexer().stop();
                listener.onFailure((Exception)new ElasticsearchException("Error while updating state for transform [" + this.transform.getId() + "] to [" + String.valueOf(state.getIndexerState()) + "].", (Throwable)exc, new Object[0]));
            }));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setShouldStopAtCheckpoint(boolean shouldStopAtCheckpoint, ActionListener<Void> shouldStopAtCheckpointListener) {
        assert (ThreadPool.assertCurrentThreadPool((String[])new String[]{"generic"}));
        logger.debug("[{}] attempted to set task to stop at checkpoint [{}] with state [{}]", (Object)this.getTransformId(), (Object)shouldStopAtCheckpoint, (Object)this.getState());
        TransformContext transformContext = this.context;
        synchronized (transformContext) {
            if (this.context.getTaskState() != TransformTaskState.STARTED || this.getIndexer() == null) {
                shouldStopAtCheckpointListener.onResponse(null);
                return;
            }
            if (this.context.shouldStopAtCheckpoint() == shouldStopAtCheckpoint) {
                shouldStopAtCheckpointListener.onResponse(null);
                return;
            }
            this.getIndexer().setStopAtCheckpoint(shouldStopAtCheckpoint, shouldStopAtCheckpointListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(boolean force, boolean shouldStopAtCheckpoint) {
        logger.debug("[{}] stop called with force [{}], shouldStopAtCheckpoint [{}], state [{}], indexerstate[{}]", (Object)this.getTransformId(), (Object)force, (Object)shouldStopAtCheckpoint, (Object)this.getState(), this.getIndexer() != null ? this.getIndexer().getState() : null);
        TransformContext transformContext = this.context;
        synchronized (transformContext) {
            if (this.context.getTaskState() == TransformTaskState.FAILED && !force) {
                throw new ElasticsearchStatusException(TransformMessages.getMessage((String)"Unable to stop transform [{0}] as it is in a failed state. Use force stop to stop the transform. More details: [{1}]", (Object[])new Object[]{this.getTransformId(), this.context.getStateReason()}), RestStatus.CONFLICT, new Object[0]);
            }
            boolean wasFailed = this.context.setTaskState(TransformTaskState.FAILED, TransformTaskState.STARTED);
            this.context.resetReasonAndFailureCounter();
            if (this.getIndexer() == null) {
                this.shutdown();
                return;
            }
            if (wasFailed) {
                this.getIndexer().stopAndMaybeSaveState();
                return;
            }
            IndexerState indexerState = this.getIndexer().getState();
            if (indexerState == IndexerState.STOPPED || indexerState == IndexerState.STOPPING) {
                return;
            }
            if (!shouldStopAtCheckpoint || indexerState == IndexerState.STARTED && this.getIndexer().initialRun()) {
                this.getIndexer().stopAndMaybeSaveState();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyNewSettings(SettingsConfig newSettings) {
        TransformContext transformContext = this.context;
        synchronized (transformContext) {
            this.getIndexer().applyNewSettings(newSettings);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyNewAuthState(AuthorizationState authState) {
        TransformContext transformContext = this.context;
        synchronized (transformContext) {
            this.context.setAuthState(authState);
        }
    }

    public void checkAndResetDestinationIndexBlock(TransformConfig config) {
        if (this.context.isWaitingForIndexToUnblock()) {
            String currentIndex = this.getIndexer() == null ? null : this.getIndexer().getConfig().getDestination().getIndex();
            String updatedIndex = config.getDestination().getIndex();
            if (!updatedIndex.equals(currentIndex)) {
                this.context.setIsWaitingForIndexToUnblock(false);
            }
        }
    }

    protected void init(PersistentTasksService persistentTasksService, TaskManager taskManager, String persistentTaskId, long allocationId) {
        super.init(persistentTasksService, taskManager, persistentTaskId, allocationId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void triggered(TransformScheduler.Event event) {
        logger.trace(() -> Strings.format((String)"[%s] triggered(event=%s) ", (Object[])new Object[]{this.getTransformId(), event}));
        if (!event.transformId().equals(this.getTransformId())) {
            return;
        }
        TransformContext transformContext = this.context;
        synchronized (transformContext) {
            if (this.getIndexer() == null) {
                logger.warn("[{}] transform task triggered with an unintialized indexer.", (Object)this.getTransformId());
                return;
            }
            if (this.context.getTaskState() == TransformTaskState.FAILED || this.context.getTaskState() == TransformTaskState.STOPPED) {
                logger.debug("[{}] schedule was triggered for transform but task is [{}]. Ignoring trigger.", (Object)this.getTransformId(), (Object)this.context.getTaskState());
                return;
            }
            IndexerState indexerState = this.getIndexer().getState();
            if (IndexerState.INDEXING.equals((Object)indexerState) || IndexerState.STOPPING.equals((Object)indexerState) || IndexerState.STOPPED.equals((Object)indexerState) || IndexerState.ABORTING.equals((Object)indexerState)) {
                logger.debug("[{}] indexer for transform has state [{}]. Ignoring trigger.", (Object)this.getTransformId(), (Object)indexerState);
                return;
            }
            logger.debug("[{}] transform indexer schedule has triggered, state: [{}].", (Object)this.getTransformId(), (Object)indexerState);
            if (this.context.getCheckpoint() == 0L) {
                logger.debug("[{}] trigger initial run.", (Object)this.getTransformId());
                this.getIndexer().maybeTriggerAsyncJob(System.currentTimeMillis());
            } else if (this.getIndexer().isContinuous()) {
                this.getIndexer().maybeTriggerAsyncJob(System.currentTimeMillis());
            }
        }
    }

    public boolean shouldCancelChildrenOnCancellation() {
        return false;
    }

    @Override
    public void shutdown() {
        logger.debug("[{}] shutdown of transform requested", (Object)this.transform.getId());
        this.transformScheduler.deregisterTransform(this.getTransformId());
        this.markAsCompleted();
    }

    void persistStateToClusterState(TransformState state, ActionListener<PersistentTasksCustomMetadata.PersistentTask<?>> listener) {
        this.updatePersistentTaskState((PersistentTaskState)state, ActionListener.wrap(success -> {
            logger.debug("[{}] successfully updated state for transform to [{}].", (Object)this.transform.getId(), (Object)state.toString());
            listener.onResponse(success);
        }, failure -> {
            logger.error(() -> "[" + this.transform.getId() + "] failed to update cluster state for transform.", (Throwable)failure);
            listener.onFailure(failure);
        }));
    }

    @Override
    public void failureCountChanged() {
        this.transformScheduler.handleTransformFailureCountChanged(this.transform.getId(), this.context.getFailureCount());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fail(Throwable exception, String reason, ActionListener<Void> listener) {
        TransformContext transformContext = this.context;
        synchronized (transformContext) {
            if (this.context.getTaskState() == TransformTaskState.FAILED) {
                logger.warn("[{}] is already failed but encountered new failure; reason [{}].", (Object)this.getTransformId(), (Object)reason);
                listener.onResponse(null);
                return;
            }
            if (this.getIndexer() != null && this.getIndexer().getState() == IndexerState.STOPPING) {
                logger.info("[{}] attempt to fail transform with reason [{}] while it was stopping.", (Object)this.getTransformId(), (Object)reason);
                listener.onResponse(null);
                return;
            }
            if (this.getIndexer() != null && this.getIndexer().getState() == IndexerState.STOPPED) {
                logger.info("[{}] encountered a failure but indexer is STOPPED; reason [{}].", (Object)this.getTransformId(), (Object)reason);
                listener.onResponse(null);
                return;
            }
            this.transformScheduler.deregisterTransform(this.getTransformId());
            if (this.transformNode.isShuttingDown().orElse(false).booleanValue()) {
                logger.atDebug().withThrowable(exception).log("Aborting transform [{}]. Transform has failed while node [{}] is shutting down. Reason: [{}]", (Object)this.transform.getId(), (Object)this.transformNode.nodeId(), (Object)reason);
                this.markAsLocallyAborted("Node is shutting down.");
                listener.onResponse(null);
                return;
            }
            logger.atError().withThrowable(exception).log("[{}] transform has failed; experienced: [{}].", (Object)this.transform.getId(), (Object)reason);
            this.auditor.error(this.transform.getId(), reason);
            this.context.setShouldStopAtCheckpoint(false);
            this.context.setTaskStateToFailed(reason);
            TransformState newState = this.getState();
            this.persistStateToClusterState(newState, ActionListener.wrap(r -> listener.onResponse(null), e -> {
                String msg = "Failed to persist to cluster state while marking task as failed with reason [" + reason + "].";
                this.auditor.warning(this.transform.getId(), msg + " Failure: " + e.getMessage());
                logger.error(() -> Strings.format((String)"[%s] %s", (Object[])new Object[]{this.getTransformId(), msg}), (Throwable)e);
                listener.onFailure(e);
            }));
        }
    }

    public void onCancelled() {
        logger.info("[{}] received cancellation request for transform, state: [{}].", (Object)this.getTransformId(), (Object)this.context.getTaskState());
        ClientTransformIndexer theIndexer = this.getIndexer();
        if (theIndexer != null && theIndexer.abort()) {
            this.shutdown();
        }
    }

    TransformTask setNumFailureRetries(int numFailureRetries) {
        this.context.setNumFailureRetries(numFailureRetries);
        return this;
    }

    TransformTask setAuthState(AuthorizationState authState) {
        this.context.setAuthState(authState);
        return this;
    }

    void initializeIndexer(ClientTransformIndexerBuilder indexerBuilder) {
        this.initializeIndexer(indexerBuilder.build(this.getThreadPool(), this.context));
    }

    void initializeIndexer(ClientTransformIndexer indexer) {
        this.indexer.set((Object)indexer);
    }

    ThreadPool getThreadPool() {
        return this.threadPool;
    }

    public static PersistentTasksCustomMetadata.PersistentTask<?> getTransformTask(String transformId, ClusterState clusterState) {
        Collection<PersistentTasksCustomMetadata.PersistentTask<?>> transformTasks = TransformTask.findTransformTasks((PersistentTasksCustomMetadata.PersistentTask<?> t) -> t.getId().equals(transformId), clusterState);
        if (transformTasks.isEmpty()) {
            return null;
        }
        assert (transformTasks.size() == 1) : "There were 2 or more transform tasks with the same id";
        PersistentTasksCustomMetadata.PersistentTask<?> pTask = transformTasks.iterator().next();
        if (pTask.getParams() instanceof TransformTaskParams) {
            return pTask;
        }
        throw new ElasticsearchStatusException("Found transform persistent task [{}] with incorrect params", RestStatus.INTERNAL_SERVER_ERROR, new Object[]{transformId});
    }

    public static Collection<PersistentTasksCustomMetadata.PersistentTask<?>> findAllTransformTasks(ClusterState clusterState) {
        return TransformTask.findTransformTasks(Predicates.always(), clusterState);
    }

    public static Collection<PersistentTasksCustomMetadata.PersistentTask<?>> findTransformTasks(Set<String> transformIds, ClusterState clusterState) {
        return TransformTask.findTransformTasks((PersistentTasksCustomMetadata.PersistentTask<?> task) -> transformIds.contains(task.getId()), clusterState);
    }

    public static Collection<PersistentTasksCustomMetadata.PersistentTask<?>> findTransformTasks(String transformIdPattern, ClusterState clusterState) {
        Predicate<PersistentTasksCustomMetadata.PersistentTask<?>> taskMatcher = transformIdPattern == null || org.elasticsearch.common.Strings.isAllOrWildcard((String)transformIdPattern) ? Predicates.always() : t -> {
            TransformTaskParams transformParams = (TransformTaskParams)t.getParams();
            return Regex.simpleMatch((String)transformIdPattern, (String)transformParams.getId());
        };
        return TransformTask.findTransformTasks(taskMatcher, clusterState);
    }

    public TransformContext getContext() {
        return this.context;
    }

    private static Collection<PersistentTasksCustomMetadata.PersistentTask<?>> findTransformTasks(Predicate<PersistentTasksCustomMetadata.PersistentTask<?>> predicate, ClusterState clusterState) {
        PersistentTasksCustomMetadata pTasksMeta = PersistentTasksCustomMetadata.getPersistentTasksCustomMetadata((ClusterState)clusterState);
        if (pTasksMeta == null) {
            return Collections.emptyList();
        }
        return pTasksMeta.findTasks("data_frame/transforms", predicate);
    }
}

