/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.monitoring.exporter.http;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.ResponseListener;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.Strings;
import org.elasticsearch.xcontent.XContent;
import org.elasticsearch.xcontent.json.JsonXContent;
import org.elasticsearch.xpack.monitoring.exporter.http.HttpResource;

public class VersionHttpResource
extends HttpResource {
    private static final Logger logger = LogManager.getLogger(VersionHttpResource.class);
    private final Version minimumVersion;

    public VersionHttpResource(String resourceOwnerName, Version minimumVersion) {
        super(resourceOwnerName);
        this.minimumVersion = Objects.requireNonNull(minimumVersion);
    }

    @Override
    protected void doCheckAndPublish(RestClient client, final ActionListener<HttpResource.ResourcePublishResult> listener) {
        logger.trace("checking [{}] to ensure that it supports the minimum version [{}]", (Object)this.resourceOwnerName, (Object)this.minimumVersion);
        Request request = new Request("GET", "/");
        request.addParameter("filter_path", "version.number");
        client.performRequestAsync(request, new ResponseListener(){

            public void onSuccess(Response response) {
                try {
                    listener.onResponse((Object)VersionHttpResource.this.validateVersion(response));
                }
                catch (Exception e) {
                    this.onFailure(e);
                }
            }

            public void onFailure(Exception exception) {
                logger.error(() -> Strings.format((String)"failed to verify minimum version [%s] on the [%s] monitoring cluster", (Object[])new Object[]{VersionHttpResource.this.minimumVersion, VersionHttpResource.this.resourceOwnerName}), (Throwable)exception);
                listener.onFailure(exception);
            }
        });
    }

    private HttpResource.ResourcePublishResult validateVersion(Response response) throws IOException {
        Map map = XContentHelper.convertToMap((XContent)JsonXContent.jsonXContent, (InputStream)response.getEntity().getContent(), (boolean)false);
        String versionNumber = (String)((Map)map.get("version")).get("number");
        Version version = Version.fromString((String)versionNumber.replace("-SNAPSHOT", "").replaceFirst("-(alpha\\d+|beta\\d+|rc\\d+)", ""));
        if (version.onOrAfter((VersionId)this.minimumVersion)) {
            logger.debug("version [{}] >= [{}] and supported for [{}]", (Object)version, (Object)this.minimumVersion, (Object)this.resourceOwnerName);
            return HttpResource.ResourcePublishResult.ready();
        }
        logger.error("version [{}] < [{}] and NOT supported for [{}]", (Object)version, (Object)this.minimumVersion, (Object)this.resourceOwnerName);
        return HttpResource.ResourcePublishResult.notReady("version [" + String.valueOf(version) + "] < [" + String.valueOf(this.minimumVersion) + "] and NOT supported for [" + this.resourceOwnerName + "]");
    }
}

