/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ilm;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.rollover.RolloverConditions;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.protocol.xpack.XPackUsageRequest;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.XPackFeatureUsage;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureAction;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureResponse;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureTransportAction;
import org.elasticsearch.xpack.core.ilm.AllocateAction;
import org.elasticsearch.xpack.core.ilm.ForceMergeAction;
import org.elasticsearch.xpack.core.ilm.IndexLifecycleFeatureSetUsage;
import org.elasticsearch.xpack.core.ilm.IndexLifecycleMetadata;
import org.elasticsearch.xpack.core.ilm.LifecycleAction;
import org.elasticsearch.xpack.core.ilm.Phase;
import org.elasticsearch.xpack.core.ilm.RolloverAction;
import org.elasticsearch.xpack.core.ilm.SetPriorityAction;
import org.elasticsearch.xpack.core.ilm.ShrinkAction;
import org.elasticsearch.xpack.core.ilm.TimeseriesLifecycleType;

public class IndexLifecycleUsageTransportAction
extends XPackUsageFeatureTransportAction {
    @Inject
    public IndexLifecycleUsageTransportAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(XPackUsageFeatureAction.INDEX_LIFECYCLE.name(), transportService, clusterService, threadPool, actionFilters);
    }

    protected void masterOperation(Task task, XPackUsageRequest request, ClusterState state, ActionListener<XPackUsageFeatureResponse> listener) {
        IndexLifecycleFeatureSetUsage usage;
        Metadata metadata = state.metadata();
        IndexLifecycleMetadata lifecycleMetadata = (IndexLifecycleMetadata)metadata.custom("index_lifecycle");
        if (lifecycleMetadata != null) {
            HashMap policyUsage = new HashMap();
            metadata.indices().values().forEach(value -> {
                String policyName = value.getLifecyclePolicyName();
                Integer indicesManaged = (Integer)policyUsage.get(policyName);
                indicesManaged = indicesManaged == null ? Integer.valueOf(1) : Integer.valueOf(indicesManaged + 1);
                policyUsage.put(policyName, indicesManaged);
            });
            List<IndexLifecycleFeatureSetUsage.PolicyStats> policyStats = lifecycleMetadata.getPolicies().values().stream().map(policy -> {
                Map<String, IndexLifecycleFeatureSetUsage.PhaseStats> phaseStats = policy.getPhases().values().stream().map(phase -> {
                    IndexLifecycleFeatureSetUsage.ActionConfigStats.Builder configurations = IndexLifecycleFeatureSetUsage.ActionConfigStats.builder();
                    Stream<Object> actionStream = phase.getActions().keySet().stream();
                    if (policy.getType() instanceof TimeseriesLifecycleType && TimeseriesLifecycleType.shouldInjectMigrateStepForPhase((Phase)phase)) {
                        actionStream = Stream.concat(actionStream, Stream.of("migrate"));
                    }
                    String[] actionNames = (String[])actionStream.toArray(String[]::new);
                    phase.getActions().forEach((k, v) -> IndexLifecycleUsageTransportAction.collectActionConfigurations(k, v, configurations));
                    return new Tuple((Object)phase.getName(), (Object)new IndexLifecycleFeatureSetUsage.PhaseStats(phase.getMinimumAge(), actionNames, configurations.build()));
                }).collect(Collectors.toMap(Tuple::v1, Tuple::v2));
                return new IndexLifecycleFeatureSetUsage.PolicyStats(phaseStats, policyUsage.getOrDefault(policy.getName(), 0).intValue());
            }).toList();
            usage = new IndexLifecycleFeatureSetUsage(policyStats);
        } else {
            usage = new IndexLifecycleFeatureSetUsage();
        }
        listener.onResponse((Object)new XPackUsageFeatureResponse((XPackFeatureUsage)usage));
    }

    private static void collectActionConfigurations(String actionName, LifecycleAction action, IndexLifecycleFeatureSetUsage.ActionConfigStats.Builder consumer) {
        switch (actionName) {
            case "allocate": {
                AllocateAction allocateAction = (AllocateAction)action;
                consumer.setAllocateNumberOfReplicas(allocateAction.getNumberOfReplicas());
                break;
            }
            case "forcemerge": {
                ForceMergeAction forceMergeAction = (ForceMergeAction)action;
                consumer.setForceMergeMaxNumberOfSegments(Integer.valueOf(forceMergeAction.getMaxNumSegments()));
                break;
            }
            case "rollover": {
                RolloverConditions rolloverConditions = ((RolloverAction)action).getConditions();
                consumer.setRolloverMaxAge(rolloverConditions.getMaxAge());
                consumer.setRolloverMaxDocs(rolloverConditions.getMaxDocs());
                consumer.setRolloverMaxPrimaryShardDocs(rolloverConditions.getMaxPrimaryShardDocs());
                consumer.setRolloverMaxPrimaryShardSize(rolloverConditions.getMaxPrimaryShardSize());
                consumer.setRolloverMaxSize(rolloverConditions.getMaxSize());
                consumer.setRolloverMinAge(rolloverConditions.getMinAge());
                consumer.setRolloverMinDocs(rolloverConditions.getMinDocs());
                consumer.setRolloverMinPrimaryShardDocs(rolloverConditions.getMinPrimaryShardDocs());
                consumer.setRolloverMinPrimaryShardSize(rolloverConditions.getMinPrimaryShardSize());
                consumer.setRolloverMinSize(rolloverConditions.getMinSize());
                break;
            }
            case "set_priority": {
                SetPriorityAction setPriorityAction = (SetPriorityAction)action;
                consumer.setPriority(setPriorityAction.getRecoveryPriority());
                break;
            }
            case "shrink": {
                ShrinkAction shrinkAction = (ShrinkAction)action;
                consumer.setShrinkMaxPrimaryShardSize(shrinkAction.getMaxPrimaryShardSize());
                consumer.setShrinkNumberOfShards(shrinkAction.getNumberOfShards());
            }
        }
    }
}

