/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator.topn;

import org.apache.lucene.util.BytesRef;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.operator.topn.ResultBuilder;
import org.elasticsearch.compute.operator.topn.TopNEncoder;

class ResultBuilderForBytesRef
implements ResultBuilder {
    private final BytesRefBlock.Builder builder;
    private final boolean inKey;
    private final TopNEncoder encoder;
    private final BytesRef scratch = new BytesRef();
    private BytesRef key;

    ResultBuilderForBytesRef(BlockFactory blockFactory, TopNEncoder encoder, boolean inKey, int initialSize) {
        this.encoder = encoder;
        this.inKey = inKey;
        this.builder = blockFactory.newBytesRefBlockBuilder(initialSize);
    }

    @Override
    public void decodeKey(BytesRef keys) {
        assert (this.inKey);
        this.key = this.encoder.toSortable().decodeBytesRef(keys, this.scratch);
    }

    @Override
    public void decodeValue(BytesRef values) {
        int count = TopNEncoder.DEFAULT_UNSORTABLE.decodeVInt(values);
        switch (count) {
            case 0: {
                this.builder.appendNull();
                break;
            }
            case 1: {
                this.builder.appendBytesRef(this.inKey ? this.key : this.readValueFromValues(values));
                break;
            }
            default: {
                this.builder.beginPositionEntry();
                for (int i = 0; i < count; ++i) {
                    this.builder.appendBytesRef(this.readValueFromValues(values));
                }
                this.builder.endPositionEntry();
            }
        }
    }

    private BytesRef readValueFromValues(BytesRef values) {
        return this.encoder.toUnsortable().decodeBytesRef(values, this.scratch);
    }

    @Override
    public BytesRefBlock build() {
        return this.builder.build();
    }

    public String toString() {
        return "ResultBuilderForBytesRef[inKey=" + this.inKey + "]";
    }

    public void close() {
        this.builder.close();
    }
}

