/*
 * Decompiled with CFR 0.152.
 */
package org.reactivestreams.tck.flow.support;

import java.util.Iterator;
import java.util.concurrent.Executor;
import org.reactivestreams.example.unicast.AsyncIterablePublisher;
import org.reactivestreams.tck.flow.support.Function;

public class InfiniteHelperPublisher<T>
extends AsyncIterablePublisher<T> {
    public InfiniteHelperPublisher(final Function<Integer, T> create, Executor executor) {
        super(new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new Iterator<T>(){
                    private int at = 0;

                    @Override
                    public boolean hasNext() {
                        return true;
                    }

                    @Override
                    public T next() {
                        try {
                            return create.apply(this.at++);
                        }
                        catch (Throwable t) {
                            throw new IllegalStateException(String.format("Failed to create element in %s for id %s!", this.getClass().getSimpleName(), this.at - 1), t);
                        }
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        }, executor);
    }
}

