/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.core.expression.predicate.regex;

import java.util.Objects;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.MinimizationOperations;
import org.elasticsearch.xpack.esql.core.expression.predicate.regex.AbstractStringPattern;
import org.elasticsearch.xpack.esql.core.util.StringUtils;

public class WildcardPattern
extends AbstractStringPattern {
    private final String wildcard;
    private final String regex;

    public WildcardPattern(String pattern) {
        this.wildcard = pattern;
        this.regex = StringUtils.wildcardToJavaPattern(pattern, '\\');
    }

    @Override
    public String pattern() {
        return this.wildcard;
    }

    @Override
    public Automaton createAutomaton() {
        Automaton automaton = WildcardQuery.toAutomaton((Term)new Term(null, this.wildcard));
        return MinimizationOperations.minimize((Automaton)automaton, (int)10000);
    }

    @Override
    public String asJavaRegex() {
        return this.regex;
    }

    public String asLuceneWildcard() {
        return this.wildcard;
    }

    public String asIndexNameWildcard() {
        return this.wildcard;
    }

    public int hashCode() {
        return Objects.hash(this.wildcard);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        WildcardPattern other = (WildcardPattern)obj;
        return Objects.equals(this.wildcard, other.wildcard);
    }
}

