/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.request.jinaai;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.elasticsearch.common.CheckedSupplier;
import org.elasticsearch.common.Strings;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xpack.inference.external.jinaai.JinaAIAccount;
import org.elasticsearch.xpack.inference.external.request.HttpRequest;
import org.elasticsearch.xpack.inference.external.request.Request;
import org.elasticsearch.xpack.inference.external.request.jinaai.JinaAIRequest;
import org.elasticsearch.xpack.inference.external.request.jinaai.JinaAIRerankRequestEntity;
import org.elasticsearch.xpack.inference.services.jinaai.rerank.JinaAIRerankModel;
import org.elasticsearch.xpack.inference.services.jinaai.rerank.JinaAIRerankTaskSettings;

public class JinaAIRerankRequest
extends JinaAIRequest {
    private final JinaAIAccount account;
    private final String query;
    private final List<String> input;
    private final JinaAIRerankTaskSettings taskSettings;
    private final String model;
    private final String inferenceEntityId;

    public JinaAIRerankRequest(String query, List<String> input, JinaAIRerankModel model) {
        Objects.requireNonNull(model);
        this.account = JinaAIAccount.of(model, (CheckedSupplier<URI, URISyntaxException>)((CheckedSupplier)JinaAIRerankRequest::buildDefaultUri));
        this.input = Objects.requireNonNull(input);
        this.query = Objects.requireNonNull(query);
        this.taskSettings = model.getTaskSettings();
        this.model = model.getServiceSettings().modelId();
        this.inferenceEntityId = model.getInferenceEntityId();
    }

    @Override
    public HttpRequest createHttpRequest() {
        HttpPost httpPost = new HttpPost(this.account.uri());
        ByteArrayEntity byteEntity = new ByteArrayEntity(Strings.toString((ToXContent)new JinaAIRerankRequestEntity(this.query, this.input, this.taskSettings, this.model)).getBytes(StandardCharsets.UTF_8));
        httpPost.setEntity((HttpEntity)byteEntity);
        JinaAIRerankRequest.decorateWithAuthHeader(httpPost, this.account);
        return new HttpRequest((HttpRequestBase)httpPost, this.getInferenceEntityId());
    }

    @Override
    public String getInferenceEntityId() {
        return this.inferenceEntityId;
    }

    @Override
    public URI getURI() {
        return this.account.uri();
    }

    @Override
    public Request truncate() {
        return this;
    }

    @Override
    public boolean[] getTruncationInfo() {
        return null;
    }

    public static URI buildDefaultUri() throws URISyntaxException {
        return new URIBuilder().setScheme("https").setHost("api.jina.ai").setPathSegments(new String[]{"v1", "rerank"}).build();
    }
}

