/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.unified;

import java.io.IOException;
import java.util.Collection;
import java.util.Objects;
import org.elasticsearch.inference.UnifiedCompletionRequest;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.external.http.sender.UnifiedChatInput;

public class UnifiedChatCompletionRequestEntity
implements ToXContentFragment {
    public static final String NAME_FIELD = "name";
    public static final String TOOL_CALL_ID_FIELD = "tool_call_id";
    public static final String TOOL_CALLS_FIELD = "tool_calls";
    public static final String ID_FIELD = "id";
    public static final String FUNCTION_FIELD = "function";
    public static final String ARGUMENTS_FIELD = "arguments";
    public static final String DESCRIPTION_FIELD = "description";
    public static final String PARAMETERS_FIELD = "parameters";
    public static final String STRICT_FIELD = "strict";
    public static final String TOP_P_FIELD = "top_p";
    public static final String STREAM_FIELD = "stream";
    private static final String NUMBER_OF_RETURNED_CHOICES_FIELD = "n";
    public static final String MESSAGES_FIELD = "messages";
    private static final String ROLE_FIELD = "role";
    private static final String CONTENT_FIELD = "content";
    private static final String MAX_COMPLETION_TOKENS_FIELD = "max_completion_tokens";
    private static final String STOP_FIELD = "stop";
    private static final String TEMPERATURE_FIELD = "temperature";
    private static final String TOOL_CHOICE_FIELD = "tool_choice";
    private static final String TOOL_FIELD = "tools";
    private static final String TEXT_FIELD = "text";
    private static final String TYPE_FIELD = "type";
    private static final String STREAM_OPTIONS_FIELD = "stream_options";
    private static final String INCLUDE_USAGE_FIELD = "include_usage";
    private final UnifiedCompletionRequest unifiedRequest;
    private final boolean stream;

    public UnifiedChatCompletionRequestEntity(UnifiedChatInput unifiedChatInput) {
        Objects.requireNonNull(unifiedChatInput);
        this.unifiedRequest = unifiedChatInput.getRequest();
        this.stream = unifiedChatInput.stream();
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        boolean usesTools;
        builder.startArray(MESSAGES_FIELD);
        for (UnifiedCompletionRequest.Message message : this.unifiedRequest.messages()) {
            builder.startObject();
            if (message.content() != null) {
                Object object = message.content();
                if (object instanceof UnifiedCompletionRequest.ContentString) {
                    UnifiedCompletionRequest.ContentString contentString = (UnifiedCompletionRequest.ContentString)object;
                    builder.field(CONTENT_FIELD, contentString.content());
                } else {
                    object = message.content();
                    if (object instanceof UnifiedCompletionRequest.ContentObjects) {
                        UnifiedCompletionRequest.ContentObjects contentObjects = (UnifiedCompletionRequest.ContentObjects)object;
                        builder.startArray(CONTENT_FIELD);
                        for (UnifiedCompletionRequest.ContentObject contentObject : contentObjects.contentObjects()) {
                            builder.startObject();
                            builder.field(TEXT_FIELD, contentObject.text());
                            builder.field(TYPE_FIELD, contentObject.type());
                            builder.endObject();
                        }
                        builder.endArray();
                    }
                }
            }
            builder.field(ROLE_FIELD, message.role());
            if (message.toolCallId() != null) {
                builder.field(TOOL_CALL_ID_FIELD, message.toolCallId());
            }
            if (message.toolCalls() != null) {
                builder.startArray(TOOL_CALLS_FIELD);
                for (UnifiedCompletionRequest.ToolCall toolCall : message.toolCalls()) {
                    builder.startObject();
                    builder.field(ID_FIELD, toolCall.id());
                    builder.startObject(FUNCTION_FIELD);
                    builder.field(ARGUMENTS_FIELD, toolCall.function().arguments());
                    builder.field(NAME_FIELD, toolCall.function().name());
                    builder.endObject();
                    builder.field(TYPE_FIELD, toolCall.type());
                    builder.endObject();
                }
                builder.endArray();
            }
            builder.endObject();
        }
        builder.endArray();
        if (this.unifiedRequest.maxCompletionTokens() != null) {
            builder.field(MAX_COMPLETION_TOKENS_FIELD, this.unifiedRequest.maxCompletionTokens());
        }
        builder.field(NUMBER_OF_RETURNED_CHOICES_FIELD, 1);
        if (this.unifiedRequest.stop() != null && !this.unifiedRequest.stop().isEmpty()) {
            builder.field(STOP_FIELD, (Collection)this.unifiedRequest.stop());
        }
        if (this.unifiedRequest.temperature() != null) {
            builder.field(TEMPERATURE_FIELD, this.unifiedRequest.temperature());
        }
        if (this.unifiedRequest.toolChoice() != null) {
            if (this.unifiedRequest.toolChoice() instanceof UnifiedCompletionRequest.ToolChoiceString) {
                builder.field(TOOL_CHOICE_FIELD, ((UnifiedCompletionRequest.ToolChoiceString)this.unifiedRequest.toolChoice()).value());
            } else if (this.unifiedRequest.toolChoice() instanceof UnifiedCompletionRequest.ToolChoiceObject) {
                builder.startObject(TOOL_CHOICE_FIELD);
                builder.field(TYPE_FIELD, ((UnifiedCompletionRequest.ToolChoiceObject)this.unifiedRequest.toolChoice()).type());
                builder.startObject(FUNCTION_FIELD);
                builder.field(NAME_FIELD, ((UnifiedCompletionRequest.ToolChoiceObject)this.unifiedRequest.toolChoice()).function().name());
                builder.endObject();
                builder.endObject();
            }
        }
        boolean bl = usesTools = this.unifiedRequest.tools() != null && !this.unifiedRequest.tools().isEmpty();
        if (usesTools) {
            builder.startArray(TOOL_FIELD);
            for (UnifiedCompletionRequest.Tool tool : this.unifiedRequest.tools()) {
                builder.startObject();
                builder.field(TYPE_FIELD, tool.type());
                builder.startObject(FUNCTION_FIELD);
                builder.field(DESCRIPTION_FIELD, tool.function().description());
                builder.field(NAME_FIELD, tool.function().name());
                builder.field(PARAMETERS_FIELD, tool.function().parameters());
                if (tool.function().strict() != null) {
                    builder.field(STRICT_FIELD, tool.function().strict());
                }
                builder.endObject();
                builder.endObject();
            }
            builder.endArray();
        }
        if (this.unifiedRequest.topP() != null) {
            builder.field(TOP_P_FIELD, this.unifiedRequest.topP());
        }
        builder.field(STREAM_FIELD, this.stream);
        if (this.stream) {
            builder.startObject(STREAM_OPTIONS_FIELD);
            builder.field(INCLUDE_USAGE_FIELD, true);
            builder.endObject();
        }
        return builder;
    }
}

