/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.files;

import com.install4j.api.Util;
import com.install4j.api.context.Context;
import com.install4j.api.context.ProgressInterface;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.unix.UnixFileSystem;
import com.install4j.runtime.beans.actions.files.AbstractFileAction;
import com.install4j.runtime.installer.frontend.ProgressAdapter;
import java.io.File;
import java.io.IOException;

public abstract class AbstractRecursiveFileAction
extends AbstractFileAction {
    private boolean recursive;
    private boolean showProgress = false;
    private boolean showFileNames = true;
    private transient long maxProgress;
    private transient long currentProgress;

    public boolean isRecursive() {
        return this.recursive;
    }

    public void setRecursive(boolean bl) {
        this.recursive = bl;
    }

    public boolean isShowProgress() {
        return this.showProgress;
    }

    public void setShowProgress(boolean bl) {
        this.showProgress = bl;
    }

    public boolean isShowFileNames() {
        return this.showFileNames;
    }

    public void setShowFileNames(boolean bl) {
        this.showFileNames = bl;
    }

    protected abstract boolean executeForSingleRecursiveFile(Context var1, File var2, File var3, ProgressAdapter var4) throws UserCanceledException, IOException;

    protected boolean postProcessDirectory(Context context, File file) throws UserCanceledException {
        return true;
    }

    protected boolean postProcessTopLevelFile(Context context, File file) throws UserCanceledException {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean executeForMultipleFilesAction(Context context, File[] fileArray) throws UserCanceledException {
        int n;
        ProgressInterface progressInterface = context.getProgressInterface();
        if (this.showProgress) {
            this.currentProgress = 0L;
            progressInterface.setPercentCompleted(0);
            progressInterface.setDetailMessage("");
            this.maxProgress = 0L;
            for (n = 0; n < fileArray.length; ++n) {
                File file = fileArray[n];
                File file2 = context.getDestinationFile(file);
                if (!file2.exists()) continue;
                this.maxProgress += this.getMaxProgressForSingleFile(file2, context);
            }
        }
        try {
            n = super.executeForMultipleFilesAction(context, fileArray);
            return n != 0;
        }
        finally {
            if (this.showProgress) {
                progressInterface.setPercentCompleted(100);
                progressInterface.setDetailMessage("");
            }
        }
    }

    protected final boolean executeForSingleFile(Context context, File file) throws UserCanceledException, IOException {
        File file2 = !file.isDirectory() || this.isAddTopLevelDirectoriesToRelativePath() ? new File(file.getName()) : new File(".");
        return this.executeForSingleFile(context, file, file2) && this.postProcessTopLevelFile(context, file);
    }

    protected boolean isAddTopLevelDirectoriesToRelativePath() {
        return true;
    }

    private boolean executeForSingleFile(Context context, File file, File file2) throws UserCanceledException, IOException {
        if (this.passesFileOrDirectoryFilter(file, context)) {
            ProgressInterface progressInterface = context.getProgressInterface();
            ProgressAdapter progressAdapter = null;
            long l = 153600L + (file.isFile() ? file.length() : 0L);
            if (this.showProgress) {
                if (this.showFileNames) {
                    progressInterface.setDetailMessage(file.getName());
                }
                if (file.isFile()) {
                    progressAdapter = new ProgressAdapter(progressInterface, (int)(this.currentProgress * 100L / this.maxProgress), (int)((this.currentProgress + l) * 100L / this.maxProgress));
                }
            }
            if (!this.executeForSingleRecursiveFile(context, file, file2, progressAdapter)) {
                return false;
            }
            this.currentProgress += l;
            if (this.showProgress) {
                progressInterface.setPercentCompleted((int)(this.currentProgress * 100L / this.maxProgress));
            }
            if (file.isDirectory()) {
                if (this.isRecursive() && !this.recurse(context, file, file2)) {
                    return false;
                }
                if (!this.postProcessDirectory(context, file)) {
                    return false;
                }
            }
        }
        return true;
    }

    private boolean recurse(Context context, File file, File file2) throws IOException, UserCanceledException {
        boolean bl = true;
        if (file.isDirectory() && this.followDir(file)) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                File file3 = fileArray[i];
                File file4 = new File(file2, file3.getName());
                if (this.executeForSingleFile(context, file3, file4)) continue;
                bl = false;
            }
        }
        return bl;
    }

    private boolean followDir(File file) {
        if (Util.isWindows()) {
            return true;
        }
        UnixFileSystem.FileInformation fileInformation = UnixFileSystem.getFileInformation(file);
        if (fileInformation == null) {
            return true;
        }
        return !fileInformation.isLink();
    }

    private long getMaxProgressForSingleFile(File file, Context context) {
        if (!this.passesFileOrDirectoryFilter(file, context) || !file.exists()) {
            return 0L;
        }
        long l = 153600L;
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            if (fileArray != null) {
                for (int i = 0; i < fileArray.length; ++i) {
                    File file2 = fileArray[i];
                    l += this.getMaxProgressForSingleFile(file2, context);
                }
            }
        } else {
            l += file.length();
        }
        return l;
    }
}

