/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.registry;

import com.install4j.api.context.Context;
import com.install4j.runtime.beans.actions.registry.PreferenceWriteType;
import com.install4j.runtime.beans.actions.registry.PreferencesAction;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.PreferencesUtil;
import com.install4j.runtime.installer.helper.comm.ExecutionContext;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import com.install4j.runtime.installer.helper.comm.actions.FetchObjectAction;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public abstract class PreferencesWriteAction
extends PreferencesAction {
    private PreferenceWriteType preferenceWriteType = PreferenceWriteType.USER;

    public PreferenceWriteType getPreferenceWriteType() {
        return this.preferenceWriteType;
    }

    public void setPreferenceWriteType(PreferenceWriteType preferenceWriteType) {
        this.preferenceWriteType = preferenceWriteType;
    }

    protected static void writeValue(PreferencesAction.PackageNodeProvider packageNodeProvider, String string, String string2, List list) {
        Preferences preferences = packageNodeProvider.getPackageNode();
        String string3 = preferences.get(string, null);
        preferences.put(string, string2);
        list.add(new PerformedAction(packageNodeProvider, string, string3));
    }

    protected boolean executePreferencesWriter(PreferencesWriter preferencesWriter, Context context) {
        ArrayList arrayList = new ArrayList();
        try {
            boolean bl = this.preferenceWriteType == PreferenceWriteType.USER;
            return this.handleRollbackActions(PreferencesWriteAction.executePreferencesWriter(preferencesWriter, this.getPackageName(), bl, context, arrayList));
        }
        catch (BackingStoreException backingStoreException) {
            Logger.getInstance().log(backingStoreException);
            if (this.preferenceWriteType == PreferenceWriteType.SYSTEM_FALLBACK) {
                try {
                    return this.handleRollbackActions(PreferencesWriteAction.executePreferencesWriter(preferencesWriter, this.getPackageName(), true, context, arrayList));
                }
                catch (BackingStoreException backingStoreException2) {
                    Logger.getInstance().log(backingStoreException2);
                    return false;
                }
            }
            return false;
        }
    }

    private static List executePreferencesWriter(final PreferencesWriter preferencesWriter, final String string, final boolean bl, Context context, final List list) throws BackingStoreException {
        if (HelperCommunication.getInstance().isElevatedHelper() && bl) {
            return (List)HelperCommunication.getInstance().fetchObject(ExecutionContext.UNELEVATED, new FetchObjectAction(){

                protected Object fetchValue(Context context) throws Exception {
                    return PreferencesWriteAction.executePreferencesWriter(preferencesWriter, string, bl, context, list);
                }
            });
        }
        PreferencesAction.PackageNodeProvider packageNodeProvider = new PreferencesAction.PackageNodeProvider(string, bl, true);
        Preferences preferences = packageNodeProvider.getPackageNode();
        boolean bl2 = preferencesWriter.writeToPreferences(packageNodeProvider, context, list);
        preferences.flush();
        return bl2 ? list : null;
    }

    private static class PerformedAction
    extends PreferencesAction.PreferencesRollbackAction {
        private PreferencesAction.PackageNodeProvider packageNodeProvider;
        private String key;
        private String oldValue;

        public PerformedAction(PreferencesAction.PackageNodeProvider packageNodeProvider, String string, String string2) {
            this.packageNodeProvider = packageNodeProvider;
            this.key = string;
            this.oldValue = string2;
        }

        protected void rollbackDirectly(Context context) {
            Preferences preferences = this.packageNodeProvider.getPackageNode();
            Preferences preferences2 = PreferencesUtil.getPackageNode(preferences.absolutePath(), preferences.isUserNode());
            if (this.oldValue == null) {
                preferences2.remove(this.key);
            } else {
                preferences2.put(this.key, this.oldValue);
                Logger.getInstance().info(this, "put '" + this.oldValue + "' in '" + this.key + "'.");
            }
            try {
                preferences2.flush();
                Logger.getInstance().info(this, "flushed " + preferences2.absolutePath());
            }
            catch (BackingStoreException backingStoreException) {
                Logger.getInstance().log(backingStoreException);
            }
        }
    }

    protected static interface PreferencesWriter
    extends Serializable {
        public boolean writeToPreferences(PreferencesAction.PackageNodeProvider var1, Context var2, List var3) throws BackingStoreException;
    }
}

