/*
 * Copyright (c) 2002, 2017 Jens Keiner, Stefan Kunis, Daniel Potts
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

/* Standard headers. */
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <CUnit/CUnit.h>

#include "nfft3.h"
#include "infft.h"
#include "bspline.h"

static const R b0[] =
{
  K(0.0008250948397625377458951191119189437666910427251818114476030015452),
  K(1.),
  K(0.002875401200013393462558808376339972424448043928787959456778629686),
  K(1.),
  K(0.00854032556917483184124508831112406765614669758644960065999413266),
  K(1.),
  K(0.009309802061612218506566563281715632520718187789234823409284203026),
  K(1.),
  K(0.0210582777474848294075134570800448832209549365963341040836232191),
  K(1.),
  K(0.02276867710840214805304770328090830488899392638760101044521964483),
  K(1.),
  K(0.02463686634073891745158311174386526235207539660979901639116109422),
  K(1.),
  K(0.02581746777142220518364910067733661937778218409941152924791113401),
  K(1.),
  K(0.02796369473237848530330096342856382437659665011212760976154888709),
  K(1.),
  K(0.03239940441749663032253454505372400514450696620496037027767422257),
  K(1.),
  K(0.04595951263894304561085983115982241802800469129970672539932031781),
  K(1.),
  K(0.04979854079028528227969757448194312467586837056783296529822149046),
  K(1.),
  K(0.0529102726248490237563802902094119784762314969199547369368748406),
  K(1.),
  K(0.06835502600439342622693539842944869596401049801988815501897745432),
  K(1.),
  K(0.0683833212345753109478394303230855542185616731474366178242173588),
  K(1.),
  K(0.07004091238476331929548236141542954881542440621612230151129970605),
  K(1.),
  K(0.0747659164749257974328623264465154325390904103129191524726346529),
  K(1.),
  K(0.07543565006521546676359806125309967939543248436284682615369064238),
  K(1.),
  K(0.09024249039893532947399396305884854900647837592680701827202290176),
  K(1.),
  K(0.1009637204126715314333599942879437925058621253782702401905179542),
  K(1.),
  K(0.1116387880223483349499215863575160811868221992498935047251274701),
  K(1.),
  K(0.1148246560777743055120197568749437794196467577678177603995586398),
  K(1.),
  K(0.115546529514882533539814964194896407446562859774731647058627901),
  K(1.),
  K(0.116036256927267647701729818519787674777527488302322096430135943),
  K(1.),
  K(0.1197140557016469312087382375942685513179146063527182433687458981),
  K(1.),
  K(0.1336467041369520879844093996765848008734533274464298574779971476),
  K(1.),
  K(0.1350401499937891107285825683809045738516176576255420562568151107),
  K(1.),
  K(0.1366510529272564092235993045254950925423113325223772992025503359),
  K(1.),
  K(0.1514551131358460167670227553455693568210121889196895364987983565),
  K(1.),
  K(0.1524569548322822735072244415697635303009925794725512911474746262),
  K(1.),
  K(0.1587117159034750687169157576676997190576647125311096613960081706),
  K(1.),
  K(0.1618852844557494537985622247955980178453867328042766759313749456),
  K(1.),
  K(0.164552407369248607055962495194132585632050115916909877653793852),
  K(1.),
  K(0.1710555467288749669355201958259068007391611452919253665299793017),
  K(1.),
  K(0.1727413234869711710810316510804759473875999275619575587396111962),
  K(1.),
  K(0.1737787272096926213612200424058889147738195020404376061186059043),
  K(1.),
  K(0.1754823954709382067046182600478345272295293748030627671305924544),
  K(1.),
  K(0.1872641575979125915420448672340798901296890395536145618845117951),
  K(1.),
  K(0.1903046432981408894110767495968501126728947173561374426169707975),
  K(1.),
  K(0.1914002394886157475154296231499814903302226150948561621144025167),
  K(1.),
  K(0.1931721295495270778135900552322012410411815889130032245214131496),
  K(1.),
  K(0.2174912144141265609503790179493026587981168646691854198483919484),
  K(1.),
  K(0.220571888927631850935118180192925071139955383018507049284017714),
  K(1.),
  K(0.2226218775821491434859562763819189901857642515326873603978439335),
  K(1.),
  K(0.2298752070613094891800940929017360260788746824413094928122485213),
  K(1.),
  K(0.2304328794515744260852043499800301263671269644433219193535805958),
  K(1.),
  K(0.2323153299455059180950899185467439969093360723270998964465802987),
  K(1.),
  K(0.2461264025354412425192366642434710484817449034502045276110343858),
  K(1.),
  K(0.2462853450763921549761584132959702788122762040824092710346323364),
  K(1.),
  K(0.2465383650131295742811604647329782266863287134482915395861725423),
  K(1.),
  K(0.2558919089000394014865395552303507631001094905930535476646490937),
  K(1.),
  K(0.2571590125115003415230643991062315734389485650246900874520448916),
  K(1.),
  K(0.2653258984524489094622320731382915186996798477182700012802427356),
  K(1.),
  K(0.2705081115343359633242394299212156014832628780835268877311904585),
  K(1.),
  K(0.2728704186986786229887382346868648090101610410119812414885155884),
  K(1.),
  K(0.2775554289436820867628791754091499047800371960810334249865394974),
  K(1.),
  K(0.2820372611522362262358792810188547808519467389637671859807506992),
  K(1.),
  K(0.2832886264569062816532473447385440278675355153460279308382892387),
  K(1.),
  K(0.2973968295406870263376667463294281711607595702825391614800779961),
  K(1.),
  K(0.2984367588395308867267043999136426113812245708654301170763573124),
  K(1.),
  K(0.3012564643059879221126698136885373563863402737579627533436407486),
  K(1.),
  K(0.3073034350991991101087273014867911056603958307621360476449910431),
  K(1.),
  K(0.3175070605295256163938737685472405942087076653765016205552138464),
  K(1.),
  K(0.3178695548343098477375497096932957024330509333626602604823398438),
  K(1.),
  K(0.3204281106825133104153147501348584304594350842643504706640372019),
  K(1.),
  K(0.3249649623025207117428818168187695412506342247326490638904513313),
  K(1.),
  K(0.327011413729494430157423759268468167574981852925743317900221601),
  K(1.),
  K(0.3281038191683508699390507097283401149345231833201473979031642441),
  K(1.),
  K(0.3384388169425068699031950792515891597181845484635880630651782571),
  K(1.),
  K(0.3434737649579987480938535663144112903856024630250217839457891129),
  K(1.),
  K(0.3489923575660302605190081597285246661002074974844040811802724309),
  K(1.),
  K(0.3507037248834092880124220212261840769723545038552693892977207996),
  K(1.),
  K(0.3570976539226239126681338714168682999604305412194682772399666721),
  K(1.),
  K(0.3582095100753309120007980044102754090101365334575101435110353498),
  K(1.),
  K(0.3646649157805303534106570806053233984323582168869468280924862058),
  K(1.),
  K(0.3702706062736018284188458319271761996046583222613827949975307558),
  K(1.),
  K(0.3723153844208860018691231493923671402558724631923999829274519925),
  K(1.),
  K(0.3759442159740040001422295361876700988689604484428756016075473571),
  K(1.),
  K(0.3871839785013742652617198623350402896796357376978170256177682549),
  K(1.),
  K(0.3957057597624174568372771222763786085347049522974445594458298808),
  K(1.),
  K(0.4068025195318734217629049951020301176662893935461726167939191216),
  K(1.),
  K(0.412065375337947090854491599968209668755607489315534871009854258),
  K(1.),
  K(0.4123328646752905420921789013629587395421486107958878303550499173),
  K(1.),
  K(0.4204137187935870288042485105342795862382320585716264787913240043),
  K(1.),
  K(0.4222112023135468793478207014894146245667641493713161862274787915),
  K(1.),
  K(0.4226176047707144475426750021734594474311378843896991906715554887),
  K(1.),
  K(0.4245684055907979886215041083144542682610661832998356496923432933),
  K(1.),
  K(0.4263748899844806508184409416906987929691313171408892129707768483),
  K(1.),
  K(0.4288253194230112960759710736730749100706122941683192299080545358),
  K(1.),
  K(0.4322799691782639798430867799830674218037121082878455405133577341),
  K(1.),
  K(0.4486318441277095633783578159161345296946130320606555241774547006),
  K(1.),
  K(0.4715718334959245357731846854870234563634288748952249588421334627),
  K(1.),
  K(0.4723828406638149540601895345124641104433640627639862360700360196),
  K(1.),
  K(0.4772948660932934023242486706196740568995668384374707319446010622),
  K(1.),
  K(0.484586935602668748749704434003331795906236062106470038656246971),
  K(1.),
  K(0.4850034014610213464747169096435334356939065525369803021201229628),
  K(1.),
  K(0.4865083869130210532300592461470896109714723807725496391075896072),
  K(1.),
  K(0.4934430349857068655662618678054612007162795088297773830495394557),
  K(1.),
  K(0.4953841177172795261509613239088800712592415015837699657250900467),
  K(1.),
  K(0.4971909378001138865649698820237857332451029185660202161722095665),
  K(1.),
};
static const R b1[] =
{
  K(0.007315724269401951140591625108939050997240609693417506132916164814),
  K(0.007315724269401951140591625108939050997240609693417506132916164814),
  K(0.01455695279186339304268227298024433847936480547896112908614530158),
  K(0.01455695279186339304268227298024433847936480547896112908614530158),
  K(0.02793776013188493684720318021946353421598598289893628731618802256),
  K(0.02793776013188493684720318021946353421598598289893628731618802256),
  K(0.02826251427972610382899647521436799221302947704723409881207299275),
  K(0.02826251427972610382899647521436799221302947704723409881207299275),
  K(0.03049867966512798577162881492744256299690817947250709614223872648),
  K(0.03049867966512798577162881492744256299690817947250709614223872648),
  K(0.03378140328477206978087827246061506883816129766053693080782295275),
  K(0.03378140328477206978087827246061506883816129766053693080782295275),
  K(0.03950512654839071100209976966386183641340452740644756434376832056),
  K(0.03950512654839071100209976966386183641340452740644756434376832056),
  K(0.05814953020138947148662050071946713613758360594563878495392109182),
  K(0.05814953020138947148662050071946713613758360594563878495392109182),
  K(0.08167898053571856571145913031375783935249549524972439705736572962),
  K(0.08167898053571856571145913031375783935249549524972439705736572962),
  K(0.0940764660545629909697374004307701913973327052362801250411364789),
  K(0.0940764660545629909697374004307701913973327052362801250411364789),
  K(0.09941049715634981624651329510134105174055194951472626750335183701),
  K(0.09941049715634981624651329510134105174055194951472626750335183701),
  K(0.1279540722710473169016156895945149798183662195216423353514408256),
  K(0.1279540722710473169016156895945149798183662195216423353514408256),
  K(0.1299745720234447359956516128346038581712462309362850676206730491),
  K(0.1299745720234447359956516128346038581712462309362850676206730491),
  K(0.1320599049070818592091079804469757027459448661848700942933146358),
  K(0.1320599049070818592091079804469757027459448661848700942933146358),
  K(0.1504116972291071820335749916925875100252026225619232885041053327),
  K(0.1504116972291071820335749916925875100252026225619232885041053327),
  K(0.1516533618767299380843973417659870996420866662261081262400325187),
  K(0.1516533618767299380843973417659870996420866662261081262400325187),
  K(0.1529216728082163963423306706849554451445141833534388336171212637),
  K(0.1529216728082163963423306706849554451445141833534388336171212637),
  K(0.1614285559623316670357187982327222149698644333507156969971279343),
  K(0.1614285559623316670357187982327222149698644333507156969971279343),
  K(0.1660135662610498832980453930048682461725693088103369300496740983),
  K(0.1660135662610498832980453930048682461725693088103369300496740983),
  K(0.1781301315769795529971643984263673981570123051065286128669786779),
  K(0.1781301315769795529971643984263673981570123051065286128669786779),
  K(0.2106558417521765211124834085528089868670781059946019236903586272),
  K(0.2106558417521765211124834085528089868670781059946019236903586272),
  K(0.2120072391061675373642227172550932354363185167465765069386776953),
  K(0.2120072391061675373642227172550932354363185167465765069386776953),
  K(0.2305865457025780084173053091461123075088137665617022592978418067),
  K(0.2305865457025780084173053091461123075088137665617022592978418067),
  K(0.2446092811054668929928872679876088144477933141521055595514923614),
  K(0.2446092811054668929928872679876088144477933141521055595514923614),
  K(0.2469609682129279343941438642229811290626208149016319164509530693),
  K(0.2469609682129279343941438642229811290626208149016319164509530693),
  K(0.2484270451276993698846812218175039836243392605075441331284051981),
  K(0.2484270451276993698846812218175039836243392605075441331284051981),
  K(0.2544561793152044518234490958391655071678923685873483244677003871),
  K(0.2544561793152044518234490958391655071678923685873483244677003871),
  K(0.2625076722488421084197371873853510615424715669335155102372047785),
  K(0.2625076722488421084197371873853510615424715669335155102372047785),
  K(0.2663735312473389413159493196838586396477775601173513998763969374),
  K(0.2663735312473389413159493196838586396477775601173513998763969374),
  K(0.2761632553183435093704979646462498140526441280089001529399312445),
  K(0.2761632553183435093704979646462498140526441280089001529399312445),
  K(0.28393456172928259069821268358005990214896515717779008970578847),
  K(0.28393456172928259069821268358005990214896515717779008970578847),
  K(0.2944050827414107890496559217817893279133755636434188033577236821),
  K(0.2944050827414107890496559217817893279133755636434188033577236821),
  K(0.2990341069852227421842642965562158613473546849370285194622858191),
  K(0.2990341069852227421842642965562158613473546849370285194622858191),
  K(0.3009361626117378157674642777921468811736977942942391538593645211),
  K(0.3009361626117378157674642777921468811736977942942391538593645211),
  K(0.3067526405218276866911994721641256056836344229774657386737508202),
  K(0.3067526405218276866911994721641256056836344229774657386737508202),
  K(0.3193264448487545520901321731667849311805552883975904184166832058),
  K(0.3193264448487545520901321731667849311805552883975904184166832058),
  K(0.3287907889455133143074902225408719222064023091371427866406968147),
  K(0.3287907889455133143074902225408719222064023091371427866406968147),
  K(0.3565700222482982863774018340488805278690553837134388192818583792),
  K(0.3565700222482982863774018340488805278690553837134388192818583792),
  K(0.3645099448546234719007580868977822521483491995931396740378990981),
  K(0.3645099448546234719007580868977822521483491995931396740378990981),
  K(0.3676233298118654216976552836513536227069092646196463342582118641),
  K(0.3676233298118654216976552836513536227069092646196463342582118641),
  K(0.3719369203713411010251539657006506941340860557794218137046921894),
  K(0.3719369203713411010251539657006506941340860557794218137046921894),
  K(0.3833844157487681357206464586570966710686597653594510552351254773),
  K(0.3833844157487681357206464586570966710686597653594510552351254773),
  K(0.3953370578512464015858700672894345679119284855211978220513911322),
  K(0.3953370578512464015858700672894345679119284855211978220513911322),
  K(0.4025625352985120430760792247992404321617722941178978826354085593),
  K(0.4025625352985120430760792247992404321617722941178978826354085593),
  K(0.403510439960302665125678630594810929181539220040654841013970376),
  K(0.403510439960302665125678630594810929181539220040654841013970376),
  K(0.4086752989660339213035114254540397097055021198504417729332378648),
  K(0.4086752989660339213035114254540397097055021198504417729332378648),
  K(0.4122464126905164986311302074366919659184504843580679494908354269),
  K(0.4122464126905164986311302074366919659184504843580679494908354269),
  K(0.4227579224329609310758740483872132247357599260593620393646895017),
  K(0.4227579224329609310758740483872132247357599260593620393646895017),
  K(0.4561528256730453340823209118293038151861190032580679037282548038),
  K(0.4561528256730453340823209118293038151861190032580679037282548038),
  K(0.4688829099044130410638194015840932538713729514404105012000960352),
  K(0.4688829099044130410638194015840932538713729514404105012000960352),
  K(0.482432478743984893885450802330224323194809649973883507018021415),
  K(0.482432478743984893885450802330224323194809649973883507018021415),
  K(0.4830971561376426576667362143528870947274319995866430163017177178),
  K(0.4830971561376426576667362143528870947274319995866430163017177178),
  K(0.4832077977320699080149283703404652677297951660930728479337081208),
  K(0.4832077977320699080149283703404652677297951660930728479337081208),
  K(0.4836324344228254459744843828344147540848978196190065316191302047),
  K(0.4836324344228254459744843828344147540848978196190065316191302047),
  K(0.4963536859707388320060566201159264779323252882888474143375870749),
  K(0.4963536859707388320060566201159264779323252882888474143375870749),
  K(0.4983324848174298765350322382397576560929798822632813922845384254),
  K(0.4983324848174298765350322382397576560929798822632813922845384254),
  K(0.5269686056101403336038157028750086898948140412447265431046102351),
  K(0.5269686056101403336038157028750086898948140412447265431046102351),
  K(0.5344707029504037286385633769410629379019256512182257316303935198),
  K(0.5344707029504037286385633769410629379019256512182257316303935198),
  K(0.5429038303129199032953977266526600658143903453850466534714088808),
  K(0.5429038303129199032953977266526600658143903453850466534714088808),
  K(0.5853862017037120685331904485908056143173618387338274491066973273),
  K(0.5853862017037120685331904485908056143173618387338274491066973273),
  K(0.5892410347363079135664215451555906097556931499731079081916419337),
  K(0.5892410347363079135664215451555906097556931499731079081916419337),
  K(0.6039929845317165463231444043308685237683587921229737775204545575),
  K(0.6039929845317165463231444043308685237683587921229737775204545575),
  K(0.6166089713853574234193219480394200036542711748825330327543176281),
  K(0.6166089713853574234193219480394200036542711748825330327543176281),
  K(0.6207037331741952847594008802617523471622774763910331591680361551),
  K(0.6207037331741952847594008802617523471622774763910331591680361551),
  K(0.6409838418784062114929821503091369940112895128106989532756003273),
  K(0.6409838418784062114929821503091369940112895128106989532756003273),
  K(0.654813886515797085541797067378150758854944596816007292262005442),
  K(0.654813886515797085541797067378150758854944596816007292262005442),
  K(0.6665176577041307786409806753556362840593716583547153704272384741),
  K(0.6665176577041307786409806753556362840593716583547153704272384741),
  K(0.6691469856239938443297281050043874378845048524975398039330960932),
  K(0.6691469856239938443297281050043874378845048524975398039330960932),
  K(0.6965742373752946189625060521769743777352171101632461378495450229),
  K(0.6965742373752946189625060521769743777352171101632461378495450229),
  K(0.7031272077837981290131319056012141958870114437945191780995435876),
  K(0.7031272077837981290131319056012141958870114437945191780995435876),
  K(0.7247111770486850599376413703077999571678624592317214670458066127),
  K(0.7247111770486850599376413703077999571678624592317214670458066127),
  K(0.7439984513483767255853528691204885279406733489149018409092991779),
  K(0.7439984513483767255853528691204885279406733489149018409092991779),
  K(0.7528294884317840999905226690637039932482419517611517630783657896),
  K(0.7528294884317840999905226690637039932482419517611517630783657896),
  K(0.7629500306088767091599556207210294040574221512355398168986815113),
  K(0.7629500306088767091599556207210294040574221512355398168986815113),
  K(0.7666182230940689829725280647858106673331472134887091567896361207),
  K(0.7666182230940689829725280647858106673331472134887091567896361207),
  K(0.77058624407570840664513074151509796371994710331002366511346233),
  K(0.77058624407570840664513074151509796371994710331002366511346233),
  K(0.7709659881055362332656251086098231170460407103110864927209967055),
  K(0.7709659881055362332656251086098231170460407103110864927209967055),
  K(0.779097555234408173140027477327350200787441078592356965167108773),
  K(0.779097555234408173140027477327350200787441078592356965167108773),
  K(0.7877314835892230775130641110889378133199691947722298608041490835),
  K(0.7877314835892230775130641110889378133199691947722298608041490835),
  K(0.7990774963520234945763959319724575004916364613104679235753992397),
  K(0.7990774963520234945763959319724575004916364613104679235753992397),
  K(0.8185361992040150530875702480110325923629310240795468184809582992),
  K(0.8185361992040150530875702480110325923629310240795468184809582992),
  K(0.8207565563363459086864000812931935211670888258492386641650001296),
  K(0.8207565563363459086864000812931935211670888258492386641650001296),
  K(0.8582489422173031995169878094091770356131318092747857451508483275),
  K(0.8582489422173031995169878094091770356131318092747857451508483275),
  K(0.8810758578033507125787578852527591887200897444337561806963375145),
  K(0.8810758578033507125787578852527591887200897444337561806963375145),
  K(0.8950060389815060606755100073204707723517206531025970222189489447),
  K(0.8950060389815060606755100073204707723517206531025970222189489447),
  K(0.8957020504687054001120700066596106666284273101363206634704737195),
  K(0.8957020504687054001120700066596106666284273101363206634704737195),
  K(0.8973085804311459739865915460229426607776724896183259815862082853),
  K(0.8973085804311459739865915460229426607776724896183259815862082853),
  K(0.8977285608880782318930269082720218168629170279687977406667869898),
  K(0.8977285608880782318930269082720218168629170279687977406667869898),
  K(0.9091673412554886237229371416995121223864432513102437706234700756),
  K(0.9091673412554886237229371416995121223864432513102437706234700756),
  K(0.9096359217133417428359712450007925845808994732565742797245829124),
  K(0.9096359217133417428359712450007925845808994732565742797245829124),
  K(0.9175517499189858462253269359107622934398789207025092884981700696),
  K(0.9175517499189858462253269359107622934398789207025092884981700696),
  K(0.9307782019930857952444799494853953863749611772413709400097705643),
  K(0.9307782019930857952444799494853953863749611772413709400097705643),
  K(0.9467140306374971173993703229731723641980215693123204388573476796),
  K(0.9467140306374971173993703229731723641980215693123204388573476796),
  K(0.9669741607956457575747363234938106706149720081370566148495949657),
  K(0.9669741607956457575747363234938106706149720081370566148495949657),
  K(0.9691157247311471222660524482415213476161980187131055021404840612),
  K(0.9691157247311471222660524482415213476161980187131055021404840612),
  K(0.9779770713964010197642520446287443920165499560113818015776049131),
  K(0.9779770713964010197642520446287443920165499560113818015776049131),
  K(0.9825536023093744438558545188376506575034815406178335686482342742),
  K(0.9825536023093744438558545188376506575034815406178335686482342742),
  K(0.9867997693926106066653326081678404662118670209910245793078384104),
  K(0.9867997693926106066653326081678404662118670209910245793078384104),
  K(0.9894680805875316567123856613731861083257596197694246098014911094),
  K(0.9894680805875316567123856613731861083257596197694246098014911094),
  K(0.9957092593961457151116606739995048548488645897265127362324014921),
  K(0.9957092593961457151116606739995048548488645897265127362324014921),
};
static const R b2[] =
{
  K(0.0171822076256982762920144102800006835843088337238148901626315885),
  K(0.0001476141294463019985417505218129008274764092360829906406870572778),
  K(0.02914632377205685715526739449884377283508004997684781788579161232),
  K(0.0004247540947127833310481799716662048330002641537850224961259344771),
  K(0.0327484485742226167289678676495964910923015297172735876467627339),
  K(0.000536230442009251669238341088925257116908844338508483875105378504),
  K(0.04936225124074036284858546719617489645064649136641667836606169191),
  K(0.001218315923776986745740911978924146399290738374214755151163623237),
  K(0.05331927506580238382939319901613986568124187919086163419519378266),
  K(0.001421472546771347901219945920286684719922996008333058339685512436),
  K(0.05734958934073827430153002735969260823958736907152250024520759651),
  K(0.001644487698775660545813294927229485376052964347726792041819202242),
  K(0.07188433718601521194320611593892153122022311567599541490416954333),
  K(0.002583678966336364699752682835752452384478379977109270237838516161),
  K(0.07900892838113470645918506544557276114174403756395070612307310843),
  K(0.003121205381967636653566720008329129227423847941813784706185103777),
  K(0.08187055243545796569580479434461061054621951941882124099057085802),
  K(0.00335139367804353611912442254120410143509581467033083749932567988),
  K(0.08560788900370538045892470013476721628621852830848154961422323233),
  K(0.00366435532983537029903725971066812740336089194595147898141515019),
  K(0.09548158225095875912403812768167074190596751991299807997367919988),
  K(0.004558366274573301369410244049902409939663839036627689319577315963),
  K(0.09794647923928660480672419292363532057331423211283121238050699423),
  K(0.004796756397686000941312149840951496344931879314625633719837997324),
  K(0.1156030373656601022518901631601965817322442144089454906433758904),
  K(0.00668203112408310289690269704117562715094460357605224241292350461),
  K(0.1217711476223729526162286249961191636938808353042410737458240668),
  K(0.00741410619663487299552885655413148174728915778055119939830455676),
  K(0.1253249008728766826471915312650595611335623269852838059832025033),
  K(0.00785316538939818334604786549122342163168047659844432098692443016),
  K(0.1490511469334531778603096148606407860977856643555925819975901414),
  K(0.01110812220108892433308839363855254752759369208415992776441716571),
  K(0.1500176682310151008977717832862075196633889706372835218952626929),
  K(0.01125265039073545873615241774620206736000440456016409697738901412),
  K(0.1722865694690976475093554141180767620529058340677816704256649188),
  K(0.01484133100971510482538454114938333709194640082171716973870380039),
  K(0.1770234486801288391549282135462377519000479978844984146946740621),
  K(0.01566865069130310442273041747955042078866317864507462738944306432),
  K(0.1784754130916832873770268576528546116689809613715989743531130002),
  K(0.0159267365391234970840154677238146836145454377966468509256374612),
  K(0.1861861040956511855971934014867663445229508849272072902051048923),
  K(0.01733263267915832959389692741040320244975990590935461020024135547),
  K(0.2151000475849518480037790647046760473810033374023121613097191015),
  K(0.02313401523552427466943406523710998179414701360426873024464618838),
  K(0.2355365407779000483291435556892873485161506841792555675777533592),
  K(0.02773873102080968615184349686559399695902330789261444320596428934),
  K(0.2363462381299951481935150586823610028698476275245976233203866111),
  K(0.02792977213910018624223914939285223069856193292457697909312838514),
  K(0.2373086667431700214150870490193936138969675425533823251237997394),
  K(0.02815770165571046466935658024171937816552783954753089226094844061),
  K(0.2498905877387098099164249956949241227253936728851148280008834131),
  K(0.03122265292019891279551995474905743640084927205853629591377449737),
  K(0.2540013052199765217518031190953937039491635957073756518318296933),
  K(0.03225833152672583611851371341431117569002854602898814700056320063),
  K(0.2665936737258442887131501709317251469141836386859127818928954823),
  K(0.03553609343532095971753611319801588945362475105737779955488143007),
  K(0.2681542732185691378040115858789368526976004887302498173143652528),
  K(0.03595335712268951277195777729513788103481107738529701860143964534),
  K(0.2953091412093672240862200308034038076246262736586075856732233425),
  K(0.043603744440906995620373464494331454811977727129422321052848831),
  K(0.3104480574989795782489438601807888343288818827642914570147733956),
  K(0.04818899820244486517455439344995250667438381850806953716458171234),
  K(0.3219025907785603178919213828287209521320675667138687712301713026),
  K(0.0518106389749746331037109175069316403305477895502253962466567062),
  K(0.3259850547961680708539377673734035920554665405336081631993087731),
  K(0.0531331279752303498873385277334988426343917937022461485809262236),
  K(0.3315999574492793669097272693281238237338783662107734510167909694),
  K(0.0549792658901819433491787601563359480512822154549777249992927809),
  K(0.3352451592678631175121733941145350805063883241371584318668885561),
  K(0.0561946584062674539564795788071671836985915687307937701367706029),
  K(0.3631148130766143845348345604272868441978826763613230709806453709),
  K(0.0659261837378323024164114253543172110603456648961306741070670567),
  K(0.3644238147058940876821154773468954391796944750736108757740332729),
  K(0.0664023583623979139623101733554693038480659925033591790478342229),
  K(0.3839601853737984949362497862611885298829945216642174355165422936),
  K(0.0737127119761408518383066885473591848042885991495773860722099507),
  K(0.3857528491226438762380119988891734115870088681263389849945109739),
  K(0.0744026303031186251787372908570258808813390597087845768904029378),
  K(0.3891510807645750068187153314121785222365126051403610527890865324),
  K(0.075719281830118389936797905957526494843048674780714469625980064),
  K(0.390429504939912453392779537623077059022848579263854903770234664),
  K(0.0762175991638125614232837420769442983807195260109820498428638948),
  K(0.3941593904340332397323902899010175019957669220584359744381856882),
  K(0.0776808125336643271068351465056055094720606567382905790953484591),
  K(0.4183694666631126047974854995573208979606791169630018702717195502),
  K(0.0875165053179886445868522099131926750521372800735816881489408846),
  K(0.4192007595578657149287169384678357981985960832163758206266574848),
  K(0.0878646384069457717738028494483373001057331703140865750962708243),
  K(0.4275424555520675553272794495026755617016132589530770373890628491),
  K(0.0913962756497458305828626771339418167606556925335977392810646704),
  K(0.4782437902202249343692275591850175523603866736389120477815507393),
  K(0.1143585614421032572894901581360573983780208481548369083716148703),
  K(0.5098685202102494717086454383480092494511753152401468681487614251),
  K(0.1299829539506947869929713410321329702543028074879648676690778544),
  K(0.5623067879666079996459687519700861713064991076805074774049520234),
  K(0.1580944618966619235365873389124896385674592216232348537311593909),
  K(0.5781971809927350975729818538893619961905232065386693069975928832),
  K(0.1671559900539728343964844390866200391607809717447739296429866887),
  K(0.6087522724784269712742930422607699387529855578868538650488548972),
  K(0.1852896646238244978637508080913823265979942955885904687437350408),
  K(0.616900319955581205915752681359321163956527435226931657372939787),
  K(0.1902830023806492317164002368053726433228557194677202307920624739),
  K(0.61690565553189487385261595547686563240379977114829820556473152),
  K(0.1902862939136184681866464978922517505246734060614390298239335847),
  K(0.6385506050769211447899718227655482253202554660204766934890010227),
  K(0.2038734376220510560458875366177934970818444002424975205124901452),
  K(0.6399384476985620158028866180009691842114924576530286954183111581),
  K(0.2047606084214225962700831654019186707487651688608959126016165999),
  K(0.6738046193789873489607376625126006794844754359837135213235960705),
  K(0.2270063325482310068441255919843974548400560637437722325741114086),
  K(0.7086124638723865965734883705073669337420859248422879183874068387),
  K(0.2510658119776471997666561416676190181206904017639398962686762023),
  K(0.7324718442150902649030783866727426158564773690554111937364866623),
  K(0.2682575012839277309831382181907670253836871949426276926219363636),
  K(0.7361125316667021744782818165867312977471162341703691696019978184),
  K(0.2709308296383808058006575272659712216189640928869346689548273576),
  K(0.7441401520483755683390297334260981431752323906429472196439621543),
  K(0.2768722829452897547780620711702782210101818575816988964864604638),
  K(0.7709059631416098179594018828364711401747188959837653931282338912),
  K(0.2971480020036465375942740736633104258562537642436677321144508845),
  K(0.7879007067849558990696130019523151705519020144526835645307647721),
  K(0.3103937618761165253638907091271007382443453016824046738764001606),
  K(0.8675890119833286674838905821872522354917692046961296033732692803),
  K(0.3763553468571042070937641227798743095709628758262220948743771782),
  K(0.8901967567276638877631604652632145041733721329703593000474487791),
  K(0.3962251328442258006098609092620629330966504264429711971656981085),
  K(0.9405310945715489940041640344015158143476057935313434887175002005),
  K(0.4422993699279780187686699661046972717998309986274859759177467919),
  K(0.9461083506213359994123691423573855747616684546052545089329314528),
  K(0.447560505557712427392666750949544970059987320740640565817046298),
  K(0.9656745715283009937683687679200994826380961558312744287783732551),
  K(0.4662636890481838561556941533393636380514358366331333910642340479),
  K(0.9675155332064997651757099904773828831967612392008631026386665477),
  K(0.4680431534979287748896729665989617089383599977910981952121914838),
  K(0.9792128100712170559269383557805119254428567279915457025469227994),
  K(0.4794288637037847034566803965880651585462478744749664036213740759),
  K(0.9994944681623737647422029275577816123208540277566743980931081896),
  K(0.4994945959435931916213478919656856031416231624985111650995803686),
  K(1.010331849738592872250751416746096065272296025627081677082351395),
  K(0.510225102619572010648089878257767791332508764512019887246831804),
  K(1.015401953396469617477009878058623726333653866019924542438445565),
  K(0.515164733228042595491203951031467882032525339275773990667021105),
  K(1.015991714272568419195459291374311528367644741555213804773399622),
  K(0.515735979347192950710753958058998593454811022848270847069245506),
  K(1.025520324737541562191265379754049869687497433907873512819478777),
  K(0.524869037762831986386123338871904905797099328459990948082375861),
  K(1.048153763311978467842546015669023502690225643968251233275976917),
  K(0.545834978390872424342029286961400095909632015783631792160537833),
  K(1.053786954410552747160588718490330698815252088661760620343152779),
  K(0.550893917945789867539834728260507677278705792298823078379193683),
  K(1.054288076738993803100958908381214714748757809169889996647790343),
  K(0.551340881462974923062299281577443047622642466665257073925212981),
  K(1.115948441166571971994449205635746935018485391314708893417829847),
  K(0.602504400157613970032598891687320822573451444070233860539757018),
  K(1.119209033722123668129389421013899563517697651882026290261509688),
  K(0.604998240001161250239691965422261319842915535095262545440525615),
  K(1.119345715348006144471277616325707359805197673338230506386836572),
  K(0.605102315576078835077533491568169176087626194890359894043939153),
  K(1.128228304688334368087514518952639790283685135692878071903136845),
  K(0.61178580656509005440416289598085615082586243307240498559285718),
  K(1.138460057750203971952028661333302962499767532885281181217928966),
  K(0.6192888701580141529530140823730171077453195366783301207951187),
  K(1.14869693702576502141853922507372666385852025849168896680389877),
  K(0.626586157944920692884523033179395370654667459900899130673305549),
  K(1.155789371684805149514121750459427649129308595425478183237246825),
  K(0.631519043354858781044431691415382615054241714204122956092523373),
  K(1.163203424800978012517466800450553781595243616423537837749044857),
  K(0.636568066934209527492770140634412339420717301663595730660434007),
  K(1.174250832982728534472382022849783279822473302312812992863680967),
  K(0.643887480187553779982720153376712042935574906754267506367053879),
  K(1.175674809247560252991696134334648984438351233496177650880549785),
  K(0.644813170643393571609794261502780784761764250364976044784813992),
  K(1.199342867848072524242192611310264740696237314092050085370627125),
  K(0.659605288886178417710234249926130766422686677010860584592641064),
  K(1.215222861104599183751013671409614178156022856127384434196877966),
  K(0.668901981162549591569756934146453723031643231768309506457950181),
  K(1.254636155493930998181525514619562648453576364072233656346042305),
  K(0.689796583809201592513046385500721046055945750373472902152796368),
  K(1.292904890891990702691041551834605868277126791101625627340700204),
  K(0.707111615783541724589909678696258725853216787536628377997968093),
  K(1.294509254397651540937383394498906311038538083826972896666028864),
  K(0.707773553471790907432418158037309606414311577107350835642920141),
  K(1.302759752735643859032662861361216665571872047474179583008522762),
  K(0.711096284859095649849387038418083637641696504831039058774609325),
  K(1.332423968856607694114999041511334417371376850985639627953936926),
  K(0.721918273786228811987145840503529645840560726326474607295906236),
  K(1.333472275412728012540417395736759370591335941458983916057730822),
  K(0.722268516943785688773909946589371534636663255775827664483907014),
  K(1.34560552798749018743211353683454467808351431857192080883236878),
  K(0.726162347011978324187367915316760503760643753250983539337524371),
  K(1.348825263761381609020464997927373611057444599007563169316785544),
  K(0.727146199123184159420909292804160274404029371891795519626865195),
  K(1.385744349111254293320610379607806491768764090009637902729183696),
  K(0.736945646239989062407405063496625699471885292581597432326857462),
  K(1.413894831808879013890946443993788069884517490264444899865666958),
  K(0.742585900010778766728981323146878383114284667701448560669052777),
  K(1.466286021030627665510645764196403665096162025663579227604802975),
  K(0.748863367622052719942751817246481010021438091217234760403684099),
  K(1.482907949541841779424755241269223660029361147348756055632034042),
  K(0.749707861811135773362124820562396638737059257671730031683152795),
};
static const R b3[] =
{
  K(0.02941795770612599707291449634943287793001937034399292231530086115),
  K(4.24312970284307471651086750622756043591261129815652849003467804e-6),
  K(0.03549665850599206563409341941461526898892676270198642059399466301),
  K(7.45437380593778287651514572967185143423018453898456835069029257e-6),
  K(0.0384842234911493493970842836295697424688286605558223170203952341),
  K(9.49941659218122737032392916567244571653051244021773840376718757e-6),
  K(0.0774439994791263240151868186580447677135811863934552734736639897),
  K(0.0000774126740954083606709334272052641665340203901504661083990593922),
  K(0.1035586825304253175963551474229555547705822533624240770718605945),
  K(0.0001851008017102923155043782769622785628863352057670817687000064276),
  K(0.1113200430007542952786572161636319829716241849310216393289353942),
  K(0.0002299158150971715195496312855567982582599119611537062633561186802),
  K(0.1495135179458370392039582984436627417558451168169542418989860528),
  K(0.000557044807560981268461157252774928428834636026819427336887609813),
  K(0.1645954480105041370661578071345020506296532838671479901033452094),
  K(0.000743194027148758815320142846728214348257766052759389149164087522),
  K(0.169557751761374267470162840615415725334212792937220128584010148),
  K(0.000812459456467003007911687428212965970869895381322169659722031362),
  K(0.1785373184722933416018212665673091498424803370108036401212485378),
  K(0.000948496587051228711486144353719500983935157966821732124259681713),
  K(0.1869595150144304225726302242744239127597836952837365087903477389),
  K(0.00108915946017510030097456523150709739135028950429275631135617564),
  K(0.1908888628744596557167784139731740953923279530717766536860115672),
  K(0.00115928581593062468438318781650539857201714819385486735744890998),
  K(0.2177218953838579838272670200090175548526173794865928602078659158),
  K(0.001720105438157046938561934339081156011807733815980249392262497961),
  K(0.235532933759590830814331725801323433417402572514269433622066415),
  K(0.002177728197491606514409537407295770975835892118041974840580418372),
  K(0.2497147616206881952169373002510822213845720993025254130700544666),
  K(0.002595263133561925040746283092443466575139719492307402554886508241),
  K(0.2560207561786829059982926661143927834242694545869043554036296446),
  K(0.002796882860276064539755586922363074156820513531673338153164960635),
  K(0.3118509851387869046480633444460666841851158872880379830985397368),
  K(0.00505463861217044893420579615329107839253981955119677750480468221),
  K(0.3129161359898050373435933579027016219043100836657090452294327668),
  K(0.00510660923065241675015495660105430439366272695036969876030959718),
  K(0.3239072621460155930747230748717990994792232229642259232603995467),
  K(0.00566383776863728639182322569187804983986436237848725301758820652),
  K(0.330768391746004552283119785858112926790757573320714164890371564),
  K(0.00603143642645243851758846965852611269999165484631851811822755613),
  K(0.3585891811258144726535684517911686093004422274419415852013532544),
  K(0.00768493674271603957247542707789612938107532821596873267462028452),
  K(0.3745159429796304148066751292780159955618464163882499622349169503),
  K(0.0087550711552017401084182181792998481540348758954081226936783805),
  K(0.386829421908278230382025323233381537602998400907936616390478169),
  K(0.0096473324743105660937046438592545823149782555577031670841397762),
  K(0.4088852034058278248829637087405251072911638743944349008441241214),
  K(0.01139338921683344018766543801048212331375489161942559877889110051),
  K(0.4152342174926195948174412995608438718894271812551290971057583521),
  K(0.01193240960564183924405835667493554272968178824472613844930344664),
  K(0.427801164439192971785546981824017993241395004638253475669460392),
  K(0.0130489220459518877962440254558275577790425126333454905508911372),
  K(0.4304441830131245008686508640117260457340604904385757279441870094),
  K(0.0132922738200242043437851555988847381825884900610862952239966982),
  K(0.4792507943193999001634114858862716207547269547027591045334411623),
  K(0.01834582614970197673994947915046829496522868897421450050741384311),
  K(0.5342148758243091632514685316444054471350306746003709297867761582),
  K(0.02540953289475438532685377029867846607528161414277810073051992826),
  K(0.5849552615017801993994353399843876813269658284451557062591458559),
  K(0.033359282769156907821354335656977772429427870373929630350187301),
  K(0.6298637274914248809482570623234342989912841194112387133335085764),
  K(0.0416474625698634266522037370392393060156142583554307642611405383),
  K(0.6870102098925284155606342128893475565099320155641828957345716158),
  K(0.0540428599121906437842339588256960860481526793858653026133137977),
  K(0.745688833248231797032593697251060562681832308447101279984255606),
  K(0.0691069408059291587836476374795725619009395455436597681291387545),
  K(0.7539610613964844917829316084049602263442639939909322032194164494),
  K(0.0714324426287117115396651946014603971889023261453951053857898886),
  K(0.7568448515431583703359872103440608475955634139067656892229708546),
  K(0.0722552374429119417065754013344982579379432205147850893264888236),
  K(0.7618665417785952083093398479164710550125396122165060269271084059),
  K(0.0737030489278770490441537009744580373027617725114543438607941231),
  K(0.8050516435809915377107903067083602495063642215851086352035274727),
  K(0.0869600884059670750585821870106026223492637962919398044158005843),
  K(0.811734641812410673662114254388820017501128465043531148268286175),
  K(0.0891437687542770815062778040495926040495133437364867511997342371),
  K(0.8205900530491239443037153095880720115332451332026906070394837905),
  K(0.0920931852826875240953184459450473627914588103081083229535995496),
  K(0.8283748397296549164158863723068078414955058997805232419845040434),
  K(0.0947391422383823585120657097492153964112538539226164703605026187),
  K(0.8388235352999285767783970236315254231808777164080698525651480249),
  K(0.0983695242914900603117603271487216188002826787268491007071297629),
  K(0.8645193574935188454139979165450528810256110359859845190551040539),
  K(0.1076893896934018531357870997304848121081318400711057678286663199),
  K(0.8902313440031267517566431548252766602827712474378150947596533909),
  K(0.1175864809442565370230007193710817000762403120269105910252320758),
  K(0.8941330041455070836648088384250746159759567918102657760021895988),
  K(0.1191393227584873093577697436147787400283536664081273728208069204),
  K(0.9115591739348964336589225823456962712884472002625030001550137935),
  K(0.1262418493817703746652457100622838732665777701644175478684321769),
  K(0.9380550989770800058865401414347049487271519585766687348870615523),
  K(0.1375731860093920249203699114855542641103945925344455127479136179),
  K(0.9514961160361080471796299962237512308705867985665931332283179388),
  K(0.1435720194752858466976615646056689960658096387300472772604817743),
  K(0.9696979680147267863498976462924665623271977770580052053283191157),
  K(0.1519701199579130853429188239048671742652923623488818659670148965),
  K(0.9968180782795446885907356625871543576582136326175154432743271617),
  K(0.1650807627500620875724112744087098192509560913009188626532869204),
  K(1.028118329372583237534665983622004776264106966892326933966009958),
  K(0.1811100358320629542036471938173760857477000486667193574402934388),
  K(1.028326976255511144974167306857707814681649919556473390301194106),
  K(0.1812199985543910107766933318160563524416777615394267552571262807),
  K(1.060007826125726701713749801066365917931058813398135599626703637),
  K(0.198363007061106235763842089491361203150149506881073765466964592),
  K(1.081889002889178832290862193635639529773507285544599753783262512),
  K(0.210689506510487447676256889819213201605091268674603693066213185),
  K(1.085659000779449445482004650177280851266071761162220272495295545),
  K(0.212850639328656386486316459891288028117646972290558873102737291),
  K(1.10555259775825216166168502601375162894090240065956472652820422),
  K(0.224425641727877051059468499519184693341908410675416991707525168),
  K(1.180418640815324870968235145769621316509009910859571701162672234),
  K(0.270215036750607686715964055184442450644156636628288349519885737),
  K(1.193893466281555870279819414810370866176701325310982950948404009),
  K(0.27876605689324356579518203100229823798399697048197052016121247),
  K(1.224933473034473982041246822260237284485397482206998354782978991),
  K(0.298740674727450689984048625061825948972176523266990757167914509),
  K(1.245482880627180388471906346524747712659904591494531083460917448),
  K(0.31214240370866403463819449898338753604128737456386877373920218),
  K(1.247205482098494000126509823683740920286378974089962432597731129),
  K(0.313271251371747747565909634049679131311623563646561067280684268),
  K(1.294839377394785961786053657831988300602201135126301931359515531),
  K(0.344736252954399860074089133311248009876262002412839914982795447),
  K(1.302557331389642230314825485804621256303320643518864687064807482),
  K(0.349867610675568742574346680253406278449051119712814551566085281),
  K(1.307487918597160472037826457318065328760672802613391794071730496),
  K(0.353148726060251458628204562360296964056150813153007633974822399),
  K(1.322554492004967552274067942696446888066471187301811856771000781),
  K(0.363185102312786492327158626784225007857984572194530665732100668),
  K(1.323484684905456927180503874227206178933942501133257132954043612),
  K(0.363805082390926229015208994854744925381934568533698377561024073),
  K(1.354676839375411310943358277426768125644351770883372066404097188),
  K(0.3845945129320226527892225126095985738562558840116410046466119),
  K(1.386740586228918703384872667146301033870182323202581269861876004),
  K(0.405899037954779736511321514679131258795621497359137721282229225),
  K(1.41205777458290678989623115520595863344752538913504778723756472),
  K(0.422609382359107354129153104427331433171634753252619244440867889),
  K(1.440688840819045017284050725281966854929351455747527223326095113),
  K(0.441322061579022411804540051451493970293207796593894884995043443),
  K(1.447140533740519214205171670612635973815137524685960630668587258),
  K(0.445504817390982160893542356911259266855688955764822946964008983),
  K(1.448894032239520250614083218654720375018450566472646594100408767),
  K(0.446639221624026719933999914089219280440102709032396059914916027),
  K(1.456023001731557237218868507805868389035582110669829372251737577),
  K(0.451240073892599015604155619516480851801838162804154374865972821),
  K(1.47359745929767804436099977435106636258853246011728116710642051),
  K(0.462500007717238470835528909862103640608469267675341332729885837),
  K(1.491331021964140536316094137579395306385999973374218575922832544),
  K(0.473730093341173150015217228058749226168450716660358540942058334),
  K(1.506509901499070066302576950752404839841383326535854825594060257),
  K(0.483224622458239683578905230156175256741201536405015145950630821),
  K(1.511821200214077435650779918843726151623526841826913767015702721),
  K(0.486519155655003012762610322633004783895138976883824119780608054),
  K(1.528615623742920070215309027428016511204717704334005803372432196),
  K(0.496835002017573624992269589626152283216928428992799823521682285),
  K(1.559303549404296581438769468223224456298420916323913762646754235),
  K(0.515247874649577357831367036610048292565203301643319648304577761),
  K(1.564042189274811101260706551074505994070510771850173065854214602),
  K(0.518036353079830184682635538582618305426607840019153766704905163),
  K(1.610620290065936250159335887446804753261666376413312029215391947),
  K(0.544568313944919407870489800867881926105346175618516729467342799),
  K(1.610807961130150194188747262174353968119253626474310288533326277),
  K(0.544671768840128107651724316298790755774628038999889129296759194),
  K(1.654693038615142719076161048984958377387706378459708072774331592),
  K(0.568016434480122572287292847164570003123155516659574482563329578),
  K(1.667585722294932237709061135987179720541905505872697719959583416),
  K(0.574533179168436680322259970245039661057795251368337310622957897),
  K(1.669090698165938031495782688692905888286562038932817326072772068),
  K(0.575283144737636886996513903249901549276965961674351522117354863),
  K(1.69881773295636932347741934924323348145766296391068257192251746),
  K(0.5896161445521891017571041313273811440443685271203586814972784),
  K(1.74118882333450522536825714888673885385334275490169494473313907),
  K(0.608351445160846392309193783268499380214126315399849496612640376),
  K(1.752916935582790697879394169564152437133840766531163588316962736),
  K(0.613158841517036597281616280060245686996467510863875861045884232),
  K(1.75893454191856845637459167137113695033077594257812990777422626),
  K(0.615558576441978805795524376032444070150293414792867495670756591),
  K(1.781143813792896030243928171312730035190537853665710466109086552),
  K(0.624010026538249971727276841682155508661798466162785052289998344),
  K(1.809473841399319890138574996332415574384862685978667809918537249),
  K(0.633824520016812437418932376210808844369868482188800912184944491),
  K(1.813684504105783301485876872939099709680227105909918710882289989),
  K(0.635187030787002065646106263195416650906803701152675897771520873),
  K(1.834893059980594072868376429828406323484302112040887607065300055),
  K(0.641656797518200459981650857699206640986260063373649061586274397),
  K(1.873107614366252892135604869392279806146979339407906186114781689),
  K(0.651586579272202277370974630501986881979769737482802737275988427),
  K(1.903638907316661952035458882678039429709851574129080481236312029),
  K(0.657828585028196667669829731802240242937553476461113423355332622),
  K(1.904373496538659781611272758742286657108588804930866602135333623),
  K(0.657959463348174872460842050375019320533721218835894528042231993),
  K(1.925957204671193984840897609345075103106999057968782183439354689),
  K(0.661387294850723068564025875189948514491703782743991117271053421),
  K(1.936924560718247615106417225444786839741990052255097237734630805),
  K(0.662813628791866767728282652982444601098354971089786378198688443),
  K(1.950476169622502401036420013379759878073246311164207989223393094),
  K(0.664274788206653576115591062428620312296609527962620359173025614),
  K(1.968604096276966327817005031745298854906769310041541795613507088),
  K(0.665696437410723089863923426904101580621025844129640620024203564),
  K(1.986447700668080050658980733461487754379610521691827074348136428),
  K(0.666484246389774304885303113272333005126001483689717936362325827),
};
static const R b4[] =
{
  K(0.01639225155374272101528823969927321058455305169150191216923454351),
  K(3.00845277529060070563322412559120119923977633128926651124493136e-9),
  K(0.02274922170154523419253923877371876755735932158817746318658535894),
  K(1.115976195169707410468372141572095950140493670899813930750338516e-8),
  K(0.02782491443681683665380614353125312581717010984663703865640733617),
  K(2.497607031593859748413810888107552422594733557372570349403729241e-8),
  K(0.1627046133913302945509519444986652556677588371167856673835554993),
  K(0.0000292003614548063675493769584343103803825469924788635688550678777),
  K(0.1740625892763363560112293228143025124734161927251621799985273817),
  K(0.0000382481572930246775003075251915162613630426542194299867899027732),
  K(0.1842734141272993884358708504693300938889348397837771523880531227),
  K(0.0000480440364223771188970172659417178422542929215272738476098563773),
  K(0.2187882023081370943484871541419324989219747706361182251713964929),
  K(0.0000954738328279516956805469171291999199278031917102732706018660564),
  K(0.2201693316788672160108100175092962849781720668050178151862776836),
  K(0.0000979075210767557203380612110598621307843616770910765997910800002),
  K(0.2229860455618969122039750007158142173347245896999350083644929166),
  K(0.0001030147710164036594876912743959103815880981506572253579792523358),
  K(0.2274969825681897099198017627570389298073869569313661751668257066),
  K(0.0001116069708883631974917975485720191392705226780629478030225109653),
  K(0.2714426156156849342327295513360380992568161205894745429013723019),
  K(0.0002262043145836559034874632792294694485703145992231681671530172552),
  K(0.2730964025220332770559420567058271166476603856298538999173182124),
  K(0.0002317675742257716759953104514009586535613957206098992659120383845),
  K(0.332319518102750243757690641413185194348786650098029154840251539),
  K(0.000508173666220004898055859680227036393281130349977388526854822689),
  K(0.3353178303816565980132860666754231508189490245511275058726147436),
  K(0.000526763104033206409263385421304405333665049300929667745560929211),
  K(0.4116673901451947422920234778530481786822547941806867194534870393),
  K(0.001196670603938797875173138747956507225791221262171494275617928551),
  K(0.4630746708057080687852099409242934679145404549579498925813002778),
  K(0.001915988353898722032053844797998916136621316294789180028048979092),
  K(0.4735423066085367736818556055920117489453129194254578981979529246),
  K(0.002095192347978309670144690669970161867890522266532109719447760281),
  K(0.4769898037668132447564054417728322462359264988955455884988765757),
  K(0.002156875814158685258675756244149680253209723422334695290852888119),
  K(0.4965113231426758810790093368715317606879312973805289786519310268),
  K(0.00253224304576464890716159142343990762880928564086920764171318926),
  K(0.5144296487160311847831296883384971502469586725993787048921769812),
  K(0.00291804994942721226388746447825318534948437052219562507678650137),
  K(0.5300255088685840216252877046140489316469851328396475322640980302),
  K(0.00328833340966840451769819790257377043909023641459194593260525407),
  K(0.5379513308221398170258961211102529517976507944639332870666075979),
  K(0.00348947991758770705231548454930208802382560851900625191795805171),
  K(0.5724425553329915827335391402178611857528721053847189995349259069),
  K(0.00447421042206654556205196589665213778973720003039781728120948021),
  K(0.6560546076363576558948626264929056504620949534477350346042417312),
  K(0.007718780984576064964882988433541437098395198043715206885763651),
  K(0.6570014650924013894113725318189361459082467979065180995902247187),
  K(0.00776343838202749495328780778275294531758144516452114551147646913),
  K(0.6666386682165262012565475779159321243601720157719006354546837391),
  K(0.00822907012248303906566609431311205753051103226202617590672151591),
  K(0.6750863635467703176439572060305048743212803467711896125211303353),
  K(0.00865418351552290029225662353569500078336259973860047292043760724),
  K(0.713374976620127723956833982702569031202493683000739313665627568),
  K(0.01079096399758385657636435441715144266398655766877351646285226899),
  K(0.7206643544548909349676142111679347188613140257800514921684047899),
  K(0.01123882539826754410281820713542460666856481460365301163654520185),
  K(0.7215552854252799796432702957617419598343940565102512416405810122),
  K(0.01129450513852451445039998135553150532776870535000010044992347822),
  K(0.7729698294266316587526553299450409463838286243250151596222125765),
  K(0.01487438196541051360171784742884763571217650158693503447829113252),
  K(0.7918874599450554555780031149045252005996358736978185486419747457),
  K(0.0163848557030246298040145179307842076458547410109114726508419821),
  K(0.8619947372237195766785807621895444382498762916773544544881794228),
  K(0.02300420428099833422953945253063546744141197535470251237814193855),
  K(0.8627101334396421303588142187135023856776616953823963063484280909),
  K(0.02308066701903082911044231593018311670488562519131519998013128895),
  K(0.8913754032846674233810525467511932823798638275391471407942439006),
  K(0.0263045781931260725020389164698553494290789656925828196207146014),
  K(0.9010506368177718480991329560205346411845896073357468556478318943),
  K(0.0274653760745088101831129604544105765426020153834416587521284354),
  K(0.9094043962875891382993090711500841050814085973805962250757745559),
  K(0.0284981688779307487223515023730752067179850775773176505752004516),
  K(0.986889986486057138785482456630699832853611325433924938897769916),
  K(0.0395242582170661514846110365210248374358931621766023779448910225),
  K(1.035504040555890818112330785019116799714236234236163017775794698),
  K(0.0479063351832311913726519147497410843079730161987677025507492897),
  K(1.036100009755411422681848306166363885060461611483957728577783249),
  K(0.0480166955621537955889661855852683854344044579255631247449473831),
  K(1.037774981435127784524513304511975676165260465945187760746523248),
  K(0.0483278786775111210907465651000031433251575866750705726192146971),
  K(1.075343770216225059654181547857724655459872628249996297966177671),
  K(0.0557090456328227314433917839436784689076984026645046511183893475),
  K(1.099753343155343340133600512580095619823219634635496697057054058),
  K(0.0609288398126466588751398762050140693324394564223996132629695291),
  K(1.100356272847601367731356234425833475378522902344956831170971938),
  K(0.0610621064469718958366169398397548914644711101461320867784500315),
  K(1.110400066447195221630635351786734791013406996592662657353773503),
  K(0.063313225357716235157215220659594118494904004209085779482624872),
  K(1.111448797578389563561680720225950242825786402401296069917909129),
  K(0.0635516765399290033146465853426095701970442799564269219190267019),
  K(1.121756684305178480731941239579836530407758453047727211529537779),
  K(0.0659298255412090976364766458509436210596041594606717943983677425),
  K(1.129579851025825128669545484694730387821851106898184383589306362),
  K(0.0677766815565603543191475895711863253864969418633336245090388909),
  K(1.140204219850314995269799389752281661747434664240399012638493252),
  K(0.0703432789952922377906899407590265310336450039973806344412324112),
  K(1.169403716889072945604411224174207115077951986083248441883663292),
  K(0.0777480126423593095020246376853947529632245512236967250441055865),
  K(1.175314554224974357035514677198039327353570873540466113327918643),
  K(0.0793101696953230704791341811423892459618034256535152785277739374),
  K(1.201894013906429016293248365058010970361907157666213089671336879),
  K(0.086600628196166512724264534252300724302086462310920737447244716),
  K(1.230133330509727161390162990365529187926690369294036623172257765),
  K(0.0948264370789218648249608109606571091788040591922665147758550813),
  K(1.338403414371051143497179063073149480835755193246523742358917754),
  K(0.1309695845080592718931517006252387211804049218700373818005130805),
  K(1.339464650945851665130532819638009185307378423706739270447398562),
  K(0.1313597107990653951030946160695617116845790397082630881569928398),
  K(1.392772143857396471957404731674801891358608654757710753151074984),
  K(0.1518284669088303232333790070945337304119157911316349017382051181),
  K(1.394642886238585113804909857702046729409722556882356765963310868),
  K(0.1525773972243329401936698022565773060883136886346868663327315528),
  K(1.446992823926932153411196611235251559923381606736874963297699646),
  K(0.174347658266267385645794414319238840397438457546329972972663296),
  K(1.47986246464313731154625215087794716703203440693716914492212719),
  K(0.188789676666208502943663293863836909042033182399556439140137286),
  K(1.492206357864283759831805333876445075393636216625567880562434394),
  K(0.194359844186074366162095897935283857047777526594619572560634778),
  K(1.536349404446726464945744081632044661799735759976600222931702662),
  K(0.21489883459050858638456814437074927970759662729154409769983297),
  K(1.575725184149552696063261242584082365914830738363484092241187742),
  K(0.233979766376099248644230769336308400018348329382917799565987442),
  K(1.596333945263412788479618656269233585084726420518521991356361502),
  K(0.244226428210907588555760648581324629538323159873082512927101183),
  K(1.62552150123278576477750548294903866016138659779951753664126789),
  K(0.259015281063060981866357561745924003907502744983364646651067638),
  K(1.640611428494054759648486659146825423460846232517732356217824168),
  K(0.266777960787177931677556772695545268789335524261892919544174466),
  K(1.644457462912356767264741385756706867737373815862805078653764809),
  K(0.268768326140934647452277319709786776971381224060706155297199389),
  K(1.650291046770375183268354466810306215306525429443493676078938251),
  K(0.271796100390895027201116091833323599598836160968915404585098482),
  K(1.677119214657421573196120545920671247819227159758187213125815331),
  K(0.285849011037822661016774245609309665432629912028943848241960498),
  K(1.692480050938230098254166545128290926069909118108767571056393974),
  K(0.293981547985271102368648916417126039297634903233829006019403405),
  K(1.720688713422452320195216484881961710125567283638001640570397453),
  K(0.309054812995804533483619838688316611728673409023172686419936351),
  K(1.760347309408961169166026972928824253850105257737258697183282348),
  K(0.330480904743910144842199142921608773260716500570496802234070621),
  K(1.768181011176894295735279067546450990334511721457967202192140472),
  K(0.334736477260620036510050312577073503690404941196921839244256504),
  K(1.785806843979181056238794549126386933684748940747792847210114513),
  K(0.344329721631674428718879018052978425049012752117797856673780913),
  K(1.823193379820876498231648540189283870040487247938528120721915846),
  K(0.364715546185882858966337499293840868463288464730190951795491572),
  K(1.825509210723860675783621112549750018632565232951644469922824751),
  K(0.365978039778932506093936725606368279917072862759094812770181968),
  K(1.840553915707708052874204850435012606551450155041525689499280905),
  K(0.374173608983371359412596647100648175342424839944308742435786706),
  K(1.843814626399239222743717544580751155684634699555712595976776544),
  K(0.37594798490025455203778657929887033412482133703072761550670531),
  K(1.846009711840594858339407392162950751089768034730397745196250852),
  K(0.377142005776447100081849881873207709672854945603793215237625355),
  K(1.863366141200338021322064955163811569634409751322942346407504251),
  K(0.3865665095395926396890891089249708742717641596274241612596904),
  K(1.892437320127491422526101223329631839039888186106028058041037847),
  K(0.402259486683522129214220842814575227975147813468801049005043977),
  K(2.013696713169687188310824568590109221248106834652599378367441695),
  K(0.465133513977335004906848834789193554428174573540235981193560151),
  K(2.015089480283787626032548994258376782453982520536260004666409488),
  K(0.465819445452272204474900199791846741253561013901442461643876953),
  K(2.048816189510324804942417008486444150255590471522947879881178272),
  K(0.482088927708716715562866608427609900720458554080271834899372128),
  K(2.050276191116295271119177910757805652862168500613734690417472207),
  K(0.482777560905855358284060930000809595252194800252671682177219796),
  K(2.062097491579622670346609395432902991220512029263036322306393919),
  K(0.488302044861018605977452093846421887489845670089273312895155431),
  K(2.075885764043442150395991775563116533728349408688223177060084037),
  K(0.494626343822437244512588979485115896438275815554282549924664067),
  K(2.076381791800669395301515119127914956755142284675654613061974315),
  K(0.494851381623383403635639145841414394228783778610424592276124324),
  K(2.084152745339081035565413120137152768558046687242034702755452684),
  K(0.498353850831683349409252702403267838832456916621335888883624471),
  K(2.194131022930308456741699217846510845333387372711932690797895807),
  K(0.542674112259573604037228875362222275699638683917166793501586474),
  K(2.197763213471764391360650786876076636378677584670999665860319149),
  K(0.543952483410255143587321350230406615387688071957413574347804648),
  K(2.200624878418291546356843287885535520621886249459121746660832752),
  K(0.544950599617949009711836012307717989905521074643202598868079019),
  K(2.222359295986161504523728470110646341645397469737814116347634686),
  K(0.55226610766441951371525574684663583880874463805659950167151609),
  K(2.238240378533534996630612755700139092864386560328514663473352303),
  K(0.557308203676800419787974961833497465651106505885524097615820077),
  K(2.268825749455613019912294866202148924023834290707294495099650383),
  K(0.566271373903743693467929497320069795764657631255772446239254958),
  K(2.299713196432407360589438786604703454546064381098649086910299047),
  K(0.574288880399894078514391867714572274697305892277282196420129177),
  K(2.336624152516292580187448329846209564670433819454911403491418965),
  K(0.582454152399226145996495828760507173739544930892385516892951928),
  K(2.337021160544606680491982305950456794574978467717609433218365124),
  K(0.582533405831570069139382157026196410297540160007276357505665781),
  K(2.34939488611173102286958827120178126056840123122903196395634003),
  K(0.584910762778158847621988913772183560320814914785251876494382074),
  K(2.384875319615378818832872187763184558161508989666389804679654491),
  K(0.590718690900425878699659685425548445744046367816067700543952439),
  K(2.49949803398682906964645100980909495616748202365484065310792509),
  K(0.598958175852175218839095147052760734378415512894656675668848993),
};
static const R b5[] =
{
  K(0.05968243279640637084779479777949735302975477455096525039607547806),
  K(6.31031940828346902701464104821330358699098233023499634126760046e-9),
  K(0.09532105276228941507727837697104628968439015959309104571896664308),
  K(6.55787153799800729982202028671553160393509316711399366061305869e-8),
  K(0.1385424744325702448988499632881149037357765887995499956535341937),
  K(4.25337284739091006374850118153490825629071966752876659237999293e-7),
  K(0.175140217910001766415286891222592644127910284697309178895336478),
  K(1.373245493715950168882088665605175272375507638690766557758312551e-6),
  K(0.209702659888422207753507105330030507634066081071000192163329657),
  K(3.37939105049155350944814574895697795021668795836356412495332456e-6),
  K(0.2321203409114012375044610016354527280851860326777141357545002215),
  K(5.61545243066858311077042793336013864440806056555523147003677426e-6),
  K(0.2668309989209277608509634841721310416503287487900033344536552769),
  K(0.00001127197882482191779496988791706139204896893126275393181093817574),
  K(0.317748808599294477778084890196132119568741348200243746516157444),
  K(0.0000269922077670376077264080112318437053210140965001778882956826815),
  K(0.3487322170599719098027380727839665995160338560747043286062500944),
  K(0.0000429812565683050373644909799267894504014693653999182404906177919),
  K(0.485986280692857371579624835506697989675033063161280690532567185),
  K(0.000225911740141152545261169226261209441486335072955030889504106342),
  K(0.5488000600659446488425237961929931002588582725140066050218048396),
  K(0.000414848481845775803633638429113225351133055966578863754648101005),
  K(0.561894702610115513258436715045943767895478430295346375822261519),
  K(0.000466759797198133635997014802725594975610799511729510101573629696),
  K(0.6104838332185908349004147619804833593992744431368229527101289713),
  K(0.000706625964688337738203467522026321243934351074513090363558954529),
  K(0.6177072119099088842262151662616329661504772002962659228534004944),
  K(0.000749431793373264750760444006248813362997079382069203922073276851),
  K(0.6624339944843334673366184576867593894594924486920549373923838901),
  K(0.001062996440634212672667456794067768746122356879297578910721692254),
  K(0.6680359227360529897568373123515530514092522021106690261571897049),
  K(0.001108709675336523309686129806375491898812770732812600071011076382),
  K(0.6741548421136211658717924915844400118727701742292454017168393385),
  K(0.001160424915247770530987230528580417809815201513617947314388423726),
  K(0.6807174169196911323860643849400779400941342673868021845639039657),
  K(0.001218016207453896783352847962484826557768164316690656472015928932),
  K(0.7289542614311556977315228283932428834237217567955014901957703362),
  K(0.001715221254875431253825048430022094341312057062908218970337448853),
  K(0.7498466051424553836832518122524622857191541117936881952328019473),
  K(0.001975517594071561327321904591392989434663226267549012231141184573),
  K(0.7951094291115771637454765811751910089165371126350085953066354588),
  K(0.00264821519192356507827646931381520509011381984129236091115539996),
  K(0.8140312332422182160555524933764689109639192795728490956910731561),
  K(0.00297868169379472454257788541074993243792834358197124919724497003),
  K(0.8231516993938755963953683902798096364897272844009665270323412893),
  K(0.00314932985025513191543287016172791373332624194178864559238373026),
  K(0.8363629355234016006353002571212259453943246088623378770340442851),
  K(0.00341030047304410532561473250223369630427882837835523825498498983),
  K(0.8530911736226558508749959495765504459389647154632468551024119801),
  K(0.00376526889891108818824515521489797768459398016269057060627862804),
  K(0.8653227676256583141110761092561423648110314070656021519611096806),
  K(0.00404305274576125136460134611689209704277317962087764095586745516),
  K(0.9106098835776644809121135306733625700045406606133157392394237942),
  K(0.00521771739228570035213117439127987108427543277552105146135556899),
  K(0.934792706051670586036900948934631648314087402798497939326577857),
  K(0.0059483337661953783081544341272113144132334071247164044139969493),
  K(0.9381461647437542828685978435090883876462539378242599460129415339),
  K(0.00605579675951765541967096919396401287574030903923862315761829131),
  K(0.9386888340366318291536796411533829385480372545530326336984422134),
  K(0.00607333186851189321685073993242829382552637307537928809693515458),
  K(0.9387283896761321074514165078546587059514214123234045855908620098),
  K(0.00607461160448350327820251870384996655794409785409594855441946562),
  K(1.006482342678513013212210015139508382422263992022528574491550312),
  K(0.00860695544800135292456855212749667307375737513824186843638975893),
  K(1.015026907149405641409255593966489791175981438878064120295916456),
  K(0.00897855665163434447322883839420380800500979634201791770005339776),
  K(1.092117028199705099084034034832409352245869153092072196127213105),
  K(0.01294653418152039268864144374480274700321047481980118244402147704),
  K(1.118342114626183320400664265431493344281926492830673646105948241),
  K(0.0145766450096221232536109528965803418014006361282423680433865384),
  K(1.12459503347936742352068393729137390328771058810164014169699972),
  K(0.0149884271336591834803618899408577486859160673497650067616727218),
  K(1.135791077836712011630552512598455138666244345710437846546563357),
  K(0.0157487962016541259525462515017974652227500861051520611004874155),
  K(1.175370744911578586910862194330975441150477013473127356701898298),
  K(0.0186853144577551274788737030612691942131703306158181274582591385),
  K(1.246673028823322217722810707992149913378747681049122790130729568),
  K(0.0250490103974445484901679642052669834261009177110179667871809205),
  K(1.352987333628342824047373662717772978995809185036827647668324885),
  K(0.0375082049074947378547613059901039161786909640290247820159450039),
  K(1.39886162450021004664210886861718257106369150944275996487650703),
  K(0.0441319910352872081131560055547294245289307848838788189133824495),
  K(1.421494333485490249176121023315481175608539607838215944971918547),
  K(0.0477013089571030155948148680543160391823409507994853238671637954),
  K(1.486709466030520322615996779319389454449235731362624087265012775),
  K(0.0591614335518552963816608695985922705399900833797902757664861254),
  K(1.488036306662697773131557340784249954853331190507726787852451413),
  K(0.0594132925305720395339633168656991330773585251974364208025597691),
  K(1.505128762082788730748919434590127880111432422948200619923946693),
  K(0.0627262237765112929335342206680229501788830017344237571832185279),
  K(1.520977449368985001183962500319344400150000770784250627072604758),
  K(0.0659127344348495581792872425060642251877318763293963151428147387),
  K(1.531730868257918449281226325533813099334144850497446303953278407),
  K(0.0681383652675707724693720831188761042991943883696240950501385078),
  K(1.554014302865430225463226405956479524261026926639133372065698276),
  K(0.0729159296390165320573848367562390736563639368487257199132462309),
  K(1.556720732305307619353355152486732625886316519291889466653807646),
  K(0.0735115234914234636162568898199267123518781757142765684465212679),
  K(1.55734313563935348926418249559352450714907952619087065722868767),
  K(0.0736489658730526165735151457077165348627105352595504421800048495),
  K(1.561846204911846890802882050323753709028716926122541337598101336),
  K(0.0746486282133639281137365545653198040569901259780901104981571498),
  K(1.572668193966218034234727899147630891216316503897731050146895736),
  K(0.0770890586703172237338552795414915173028982879382149166313188202),
  K(1.610747096882859485644507388105194374249508610952745561481031294),
  K(0.0861067915964965182972654585543600903337290923668210936816492356),
  K(1.626286751059936798679806782535953175626348150687150050134276498),
  K(0.0899814750073953499102632857145222316480745474190153948565959152),
  K(1.64567509443971686848956324723140466317337020350448000476448276),
  K(0.0949753946812816923630646440252799991580750498612272265235704995),
  K(1.655764033065633790643839633592484540617848553835531776546266341),
  K(0.0976444089098529944017828526611160225639281189253389249886239228),
  K(1.679212406098876831811695833385395817120468056854272542585506508),
  K(0.1040343503529895678381408467340471812925021971137201738728394756),
  K(1.68173530286526189208324748639633066697949743166094592689428752),
  K(0.1047374470868916419894957299410559117677197816625625685717703157),
  K(1.683837270386039585425502274579927539198828867947779591083003537),
  K(0.1053255496731106595255679519944306171640251032939214884551913589),
  K(1.69561060192356182114136353824829247665726507621558432755464472),
  K(0.1086584456767344618919899304107312602152085019286810503272308005),
  K(1.779787763883586837062284441698333258410540851225531254028582055),
  K(0.134403255981215028523332149755316418972119948849702938405000482),
  K(1.780528443098175807874574158196633500415671504082302975666551816),
  K(0.134644582261250344675273959242818577838656956162133326786984753),
  K(1.835562071229586882549796858424069673372330407685891646111006334),
  K(0.153281714882405688304842575199266500400049425932700393952716842),
  K(1.860153197808504511563075250308332791312934623566639350669923898),
  K(0.162051002560551183177761139978725080609507191597788394845178048),
  K(1.914580471548614383962132934126998226912434486314530202668884494),
  K(0.182386472667384949004411926332630680995694004407312022329810336),
  K(1.962824908232815340319047511976182905288120709468812843410348826),
  K(0.201415623566817514216338433108457583278955853709999487422521496),
  K(1.978100904350587980090598779836567755268435009334791203856307213),
  K(0.207623684115991798393852393607560921377700273619633784841209424),
  K(2.020124924805101814149512410827837058127559315893478485180203999),
  K(0.225118168563078434571682842539699289298093183918315930047331563),
  K(2.039552120168934332475419658469253052798490736132010994943054304),
  K(0.233396732936092724397877904267043469958000812728485807105379582),
  K(2.042574084483268727526902666778955239026365421139075624524803486),
  K(0.234694563449236509005128481042046063310423456835561816303267461),
  K(2.074055227869877591833940946297670701328164989977566906979011359),
  K(0.248364525323941327926569214180193631003387534613922019066416263),
  K(2.078259116333625005932664041233326405187452964354687848873481833),
  K(0.250209490226598114765620366468705571438954543798207932846198402),
  K(2.10559233392491544115027465177885761868239630400369248357012282),
  K(0.262305915890897338566316618274108223096108750912255680360063875),
  K(2.145059995980735751735817309968997764310564309924616252772577963),
  K(0.280038218983573822942845372377063883697829163571922264757904048),
  K(2.165820025309699929915679799805080311892266618493487175347722728),
  K(0.289465591395297525063661581835739962982415139572911524162724912),
  K(2.174689218484669636350742928583368641348579378032832438226549287),
  K(0.293509764997301672142629678035148264676862063966430680163848389),
  K(2.224020344815884254309754556550008651986732175481260011924765355),
  K(0.316126174529381924890728160137321216621706385417734225002083947),
  K(2.241440214756835104724788788458998150776118795134305239672769129),
  K(0.324138608662034127729755931564277029251767357677038558023973808),
  K(2.253676471482349012913378923334946655739362087654613388131521202),
  K(0.329767085560038954201762985494431549436421860167162943773262686),
  K(2.260843929575959682048190169703463304459571365534436176988259891),
  K(0.333062677724081960111273755875841039924882760363911615181095937),
  K(2.284759131276060054545077954411142277105322743890218772725002875),
  K(0.344042677094488756282867938343508377805685905883222869421615964),
  K(2.293431200827346222231239770699381975549602568696813195583465387),
  K(0.348014840921865084852850807149745836334851492108092199179549027),
  K(2.419403743206665506565069681545492314272092255751872537797847883),
  K(0.404363937335317416333631964862620819665426993939872563114889483),
  K(2.46133446833776722444927174177006846583043386732648130149771206),
  K(0.422188680531093069969790493023138456361905394849864700497266422),
  K(2.46580411494587822222985543416998544737897800673610327819619877),
  K(0.424050596622466594527902834373206703266585989778744790027319157),
  K(2.492278106999004135242374700017798912040575481145781701111800209),
  K(0.434910502269164143504155233319639030685888575541271299381958099),
  K(2.520662214655435652822550355376643724294638633222109608575980701),
  K(0.446206839912919146510556877727329064059075537954081363020926184),
  K(2.531773418148868300708488089491651516835561601718253885693344641),
  K(0.450522632086809532338405259974362241270942374536717134889478212),
  K(2.581128351252913537174229474609556253374056317163248110146079244),
  K(0.468894707460184858849757188480915604349249434088422793065945219),
  K(2.612795809988173656839475454089428986768048845505706135778108948),
  K(0.479930688104315084750676461292494603223096368439524244938626876),
  K(2.666007433028722349671272542366043731261249556684499791391217718),
  K(0.496989050857311843613847428173688366861876191847289771952686429),
  K(2.666702353377894458928983141613303388577979192850428733881385314),
  K(0.497198685619559808850310279099138938436864950218739609782362227),
  K(2.716750350990656875998113007337265646699295748261576735650757752),
  K(0.511342108243678100959594956490592549348534031274070859522830068),
  K(2.739599680129263086374420113994767881716277139651759441582801152),
  K(0.517145552941080171405938126446643666254543514561588932785344694),
  K(2.761306782781379649194968442873055373556572003815794373033010577),
  K(0.52225972780140713119096861391809911248410554446547037991209628),
  K(2.78806798948905548614042777895387270334405752632937423654923141),
  K(0.528011125914756376344868833665798769531120520111739011412442227),
  K(2.886873582131218049819509368287257116580161688922755727304687736),
  K(0.54364060737436983553739108662207734780344555773508499550319561),
  K(2.892988068014076751294384222084811187015971410690719196024668239),
  K(0.544305838281273521487504034824941382550863519171596385860299227),
  K(2.893806511447446876665613604537377065517585438713691399594644686),
  K(0.544392139094901427487491453545736884706887946305292351691691166),
  K(2.922582756838272173261524080075805711880899345142306907726077191),
  K(0.547012033786686974950883495143504811763875339168027595964353603),
};
static const R b6[] =
{
  K(0.07652833539135338904687432012492472191274554622594071071518041361),
  K(2.78998009440851890567843107576500981043943706794203089329139298e-10),
  K(0.1119387523235915326261157295406032920534970477987516871373698475),
  K(2.73243774000735646717478490050650328101730106219615609171950764e-9),
  K(0.1423513914616968453189610549979507833327488966947438551781443881),
  K(1.155680548236247217775579993359802100885982868717753537783178563e-8),
  K(0.1423643549344105292957322679675139174850380713611794320928805601),
  K(1.156312156160828180705222643013523803351751137585345045196122307e-8),
  K(0.1493754506690082526607812967552807094078183509619235841051749923),
  K(1.542918104272712501022153366830037754044213139591012513608951624e-8),
  K(0.1699528650149238484137427548965343352375724078953515346976644559),
  K(3.34686692506742398184965130073249893668269485407914048868947415e-8),
  K(0.2187170612991721216580904613628569350244601327049594168670944344),
  K(1.520419657094823428455010613709883712880808406054280914688354836e-7),
  K(0.3176654673673278322716477016122347992299256949576085460689617714),
  K(1.427208887284642452950807955537370462610422275102376276690565007e-6),
  K(0.3323873538435806464021881627910883742192149990866939681208915509),
  K(1.872985675675393082626578738598890529546801694263123773113219e-6),
  K(0.3328550215266351491753327363534062128415152537207728595274262215),
  K(1.88885309793878543708491172395027581685106246385491527735824497e-6),
  K(0.3696373618260848186977274461772604287121467983415355949525257447),
  K(3.54260454277489103780817816538258236195576463960835993770764103e-6),
  K(0.3896950160929080400041615712361802714155395680283346091009279157),
  K(4.86425812208345520910507996988714784681818760478248389282438655e-6),
  K(0.4482485720451445543236435172712260746432513992426335099114582652),
  K(0.00001126629171139213772783765082215633521270658639201790201890314911),
  K(0.4690423688775952674056605307127985917009339721342229873084030732),
  K(0.00001478903888952776799286861985835210369212196556055746337712816786),
  K(0.547885068273898189606452928370153072339461498772439089969774247),
  K(0.0000375668076482791819235876320947499683442444692869196591005140584),
  K(0.6750916105505151345724770088131637888915095390910379549794257043),
  K(0.0001314751786183076126341534538510924508832916465538656359195421743),
  K(0.6848637031498015370055449257829899339926777836119900075223250525),
  K(0.0001433152489329229324241805725178618506523622093298124807227489198),
  K(0.7379838800801073462095589490684547367443369990076776960731962184),
  K(0.00022436171800590533882102287282930219902747160452759377189443026),
  K(0.7462841689875106283804949381868770723547464663839234920314483225),
  K(0.000239934598400477881374179676096206569441751930575502180680003185),
  K(0.7710219872029191760544438343349991845922444766156008179884004422),
  K(0.000291788439565412076926800777398540918341903330830708274533731818),
  K(0.8953902384491726566044752528954137122213792499465838942352468757),
  K(0.000715717499416273216992422208419292517118739510192363744273145616),
  K(0.9612678105482109263296124985864723217750260361366163557219754038),
  K(0.001095806572648317152113708899642074020541332215129387625604310983),
  K(0.9890897207171857313014465058515908191945721794401048090938473549),
  K(0.001300413992914957621241083373846684267460422482042841100552149065),
  K(1.006173860557851775892378660927599936418609912537220325199035688),
  K(0.00144113838893374984526424303439760043665121603560531502646327116),
  K(1.015944331577321671421141725410896987299264229488703139748113081),
  K(0.00152716855350636808684824866336320818932377425187674068266170509),
  K(1.01658706584421080030924973253855767729475046489118186894968198),
  K(0.00153297468259172400576919811909154022832120288112987575178745854),
  K(1.021102066952657510731178158817431161592693941074159359149933261),
  K(0.00157428165683420821839480480758707875311709508239549790999606266),
  K(1.032554043580463277126652308391187308856655258520830839342134858),
  K(0.00168323305524248061848689308597663620316491330990073148934564418),
  K(1.076623618756012855139091246534446031431072350363166916382051137),
  K(0.00216297015392521984934437523327530671993355872677264390070871777),
  K(1.147420187092644869228313535751359461264227887414343367496736715),
  K(0.00316948534255255720113980942754190410555864457763454996026970911),
  K(1.159284604549844737572798347448342572305072725242804230994286996),
  K(0.00337122282960680910543805440917231797004046051471913911006799371),
  K(1.189271027203833705610182953202461476121822628359930206107171676),
  K(0.00392919096243773637715515895312045882650140610103789504792129131),
  K(1.272316441206382492017588228280848512068068442575517591814288007),
  K(0.00588770430816040833986111729364993459400150351004994957452399777),
  K(1.283653863401551395451324322094687812725196770962679597798033966),
  K(0.00620870485086266667352642690136374518602002336238393976403823287),
  K(1.32168979007740846392695767370133048953169980393124642951223247),
  K(0.00739285582941368807269377785828498859415556872678264437692621964),
  K(1.398853822262281199844424731135326131426298011554517458995047945),
  K(0.01036728129995983505026235076783210470367388365854097117009346788),
  K(1.424514263107270933436805241839692071272563714799191594013986957),
  K(0.0115487182608210095066693568968720188261091665228279601335891907),
  K(1.426366820953673604006992635444718006221008838256389278243634809),
  K(0.0116380644929756381562413866509254784783989299777493957444606873),
  K(1.444696436595871030359147857159395290463379115818112503333945696),
  K(0.0125525952718391206457036658192408463617979529712320105624806628),
  K(1.462701000437718886938299257796956546624937507277165509437151934),
  K(0.0135065356315563584354186664325287860464985128876618628394054445),
  K(1.538281507107995767084424040947973579758700803188368892485846048),
  K(0.0181662417532966151677188547041812864302083626514011468450003987),
  K(1.55674153847139330491064660267095250182072878214616914584217495),
  K(0.0194786496162359293110479667641096315457522306700647962286618735),
  K(1.689653286021752251499636980169596022850625292179097187298018563),
  K(0.0312725956769472195724982206026436868837311929607007481276959629),
  K(1.698062734971378148641343157245264340704025535640759755197414163),
  K(0.0321708859438228416549560480433542838195410239370001128989727224),
  K(1.724211298660688881265105046779200828588730209693401236341122832),
  K(0.0350903961184521900392092243146601508174713174268782993102797238),
  K(1.731348173645615075981970628997581433066683394732034198020451494),
  K(0.0359211339042053991645212569122063890847876436979346124401643731),
  K(1.751923792432923441486835201105962600680199115016387970252331467),
  K(0.0383996208457843739190212662764123431871400961801387737818064755),
  K(1.840513481721586142998070048120673375935813203661942709678930146),
  K(0.0505605889115934750731923287063758775493902647725523435456114225),
  K(1.851401685535528784088075129428300574942950442821118205745841987),
  K(0.0522302665543680609022280071790879948008492306654669013355003358),
  K(1.88058735237263744957019795997947237136329043632408986796035541),
  K(0.0569036463420731909409996043936926161160463300996234831792849568),
  K(1.902901710161651599071951311728418171819471647433005898542743215),
  K(0.0606749888124482601258619980940045075077860058068730908348026057),
  K(1.948130530751577321760646947830786289687328232584045811836955406),
  K(0.0688606717231928169950711539013481356465170825401686701614595438),
  K(1.994954373236274876621571939141403950838119594170492225731742244),
  K(0.078120264256223824419728778653287609673897461084478206570256626),
  K(2.001139158184234870067213702285794053399418787302074431123596432),
  K(0.0794042346445964678039387880307495996500410179362622405651243617),
  K(2.061489398151655793420973410725185784970217663251122166518865719),
  K(0.092691414369900074242191888521013230862132370268040356916135743),
  K(2.082930580449569612343504300719186865266000766085545607523418203),
  K(0.097746128901464199952205612290141375926851338291080036776759051),
  K(2.092455071507998590801378064663400642637586092649750789966172728),
  K(0.100047996313667869119867999998808340820441526523499686821797225),
  K(2.123506541932300135549848463618464936121833348130525329377968616),
  K(0.107793962117088136509345811083786636980845984587082845584978433),
  K(2.130421315619734240328998773651234260349735206785866017582713502),
  K(0.109569166645614947821810412658364181979875791576467800519735576),
  K(2.143048662840139604634508806920953505933925798825499334234177531),
  K(0.112858091867692086218240160611518801702365680090788527971457447),
  K(2.152793274735759625912099939036513922998228591226898181672560543),
  K(0.11543775021557388219912885792629425868846968633727198904512539),
  K(2.275866070824802216161663140676020448046966622528924040860599816),
  K(0.151071714166072287569866608016475629716931104914266068021174262),
  K(2.312512420379826151121893743958020116304315677560615018690310259),
  K(0.162732299859795864167489150691927078490461307478918295446967855),
  K(2.402114422734815123096197980362995307541687438662480628833375204),
  K(0.193080538203930378224927355358814056467403696364791747584898989),
  K(2.412041131403426121788648822336148402143292671484273922258885183),
  K(0.196590681441866699611045192662408012271639106910505176417640464),
  K(2.460553091200396887943204575253365379465334400610620785777674443),
  K(0.214122800744373570196696098196256580337091045700129209493102657),
  K(2.5202685950787464950389910442851846975346928407899795784934871),
  K(0.236465857933736467307825644658004833078439356640331316643132689),
  K(2.521587902907966754593225072251833673109667708245632590890483984),
  K(0.23696773339319316912299258121843922895321431450351597325333874),
  K(2.530956083139836428436253117433735633387757007096251838618054252),
  K(0.240540644829744636550565067684021505843896539390420932909807005),
  K(2.548840364004369910204859419709094191573901341508887151465583026),
  K(0.247403952758575041262058177422862576409333689856540142055764),
  K(2.588518229169483312787466620423454669310211579390845643050941502),
  K(0.262804461697588629543248766408848527487541238905888014637222413),
  K(2.630803986312213158169611756748257926905622564752847014358691822),
  K(0.279420370272377703036518383585850885380443457198594623195448326),
  K(2.655653871008055827066896721884178276776211012525939929979858997),
  K(0.289249999520067690501348979004184165709949499093640903781120133),
  K(2.665460808605741946873577337797464415093595912359267177545337657),
  K(0.293137455992369415614767482009453648849417144047893597342128171),
  K(2.679385794231754417397206727094395484751683451047504666982585104),
  K(0.298662109684350301919577876587066690660142349791813892445126864),
  K(2.688551533729278523738942341006581256088061052719235411585197519),
  K(0.302300234605063728258211168063254908456986019941052710214654517),
  K(2.872134426127929532424924359146014988958703633022657479529458339),
  K(0.373889366451688914490836145237087744689685134746719642822553217),
  K(2.928344179843652997532502289504810887396163024414985826988326561),
  K(0.394572175847198703254084551679643309341396557577433765990638275),
  K(3.022525256308001693389804273541930984481631226065156238622627872),
  K(0.426844628975779132097552502032340307437500974138640942770551913),
  K(3.054278643440479061172249377806908151538735391192761244862755201),
  K(0.436888403670010666755747692497006217805207703024362121192375782),
  K(3.070070701495313385379180395711249796597127499590911409864160526),
  K(0.441703136971168226709085164742725615320295310930109700031168211),
  K(3.082059252488744966802369373110557386450484638306246435505391636),
  K(0.445274068937170839557802283160834455925107989934659099012583574),
  K(3.104198606968258322802684005344095236994264826710493589992668734),
  K(0.451669860772667192375588625240271232836290616224861542287746087),
  K(3.109499514105753000802239719313713863679945533467177545008798672),
  K(0.45316183113487817975116193233849923189073623225911107363177338),
  K(3.22800790687478908299191650202194082731079554400273786182896204),
  K(0.482142262143919682336142372019631788722761777664655969773511904),
  K(3.235686532364526252586297858311704951185642037882885633437479059),
  K(0.483709178643729372253444330681677350314543767712667623916927202),
  K(3.246140157404694612406666986688616668604069435260268759907664991),
  K(0.485777478484082918035654860164709725922494875422945008971411802),
  K(3.251729986801049540815643174184050934240847632955420591977183976),
  K(0.486852450854906796595429147240963480650040383674490158843019483),
  K(3.301086694981822751593963106982158490974194641595614973734274027),
  K(0.49538307195303112385047463767365657546669047341316531208459419),
  K(3.34796352495161010996742396513773317663984724524635737030469123),
  K(0.501831768193187689840625913797336581003518596529256712793741262),
  K(3.365333801001863395307303649763781173835963938388586898540093292),
  K(0.503799216542259467324466287447971369906024670942663519051515228),
  K(3.366685687963791279175961665855638291751136048229555678917109716),
  K(0.50394261830220874341663736814168404537411007267726854347067589),
  K(3.370109239974820764859485761533848403365494031389287227393507234),
  K(0.504299465377439824643819569889372011276544784185910266873069721),
  K(3.373126013743588518498001470292489022534910199883280095523378956),
  K(0.504606406034714273971115853139100228265941060365097978385385177),
  K(3.379419573301985306073213758929604875299327702535492312398821697),
  K(0.505224048325131806328655642222893439053293738178636699078360879),
  K(3.391719067342188664129222387349693433935413168004459034543379334),
  K(0.506342191049489868863035838461158218797992635323021497541099968),
  K(3.407357460240761794842275371832390369824442115809920520525417896),
  K(0.507593034007764407724859277071250444437810860737393281692324932),
  K(3.420166668261271914780858526564848715380516156174846226481193698),
  K(0.508474238814588807976324881944947328294052015776073300375349237),
  K(3.439495853698644931532368355634979337063870205227925106515515345),
  K(0.509558144549469759554115192212379566123313495387833730983524607),
  K(3.499758308627393637796244970133475621802838132996412465209874249),
  K(0.51102428212881954999864600914654367427978793135142601888580889),
};
static const R b7[] =
{
  K(0.02736437190556539302013150463715824776802249756354324909278611344),
  K(2.27964831664562814811654296639776132101942444088455738889096133e-15),
  K(0.04159060364971471409455925325896380651133215899006977720249077939),
  K(4.27106351775759362036937629043547433784167615584482007474355278e-14),
  K(0.04899229365135646846601525174172933181566298254585315980154302737),
  K(1.344199929662819294118284021385746683216358187237780461892443693e-13),
  K(0.08565516314392485828517908755243706055699015770305523436448884292),
  K(6.71188164653389750642822785094920719717326586601914105745144408e-12),
  K(0.1397303764076429215109136310818013917841614827954818072873903305),
  K(2.06350376828339157709020654235075951389923846623748382164231183e-10),
  K(0.2147891317749490985475639387023016336564375879861704839072273465),
  K(4.18461570863828944287128471058522268225692628287071088648520468e-9),
  K(0.2242757445140653319065256030195994615808596774018069137033193987),
  K(5.66298762913081278407293405774270688772426849434675630723372978e-9),
  K(0.3219607311347996401532764622610481879399184297271030778279355837),
  K(7.11524400770386560208900656264191129460754704463415070484545775e-8),
  K(0.3916582997607762896903731283517655362814179856464144592783547543),
  K(2.80492209396482389152550653416518943395619711140470181361164627e-7),
  K(0.4099259019519058696270810151089885889451722176972371634596248056),
  K(3.85928623030362376956908147734309685247625959322718166115432269e-7),
  K(0.4385995601112860448449776894100000828381147245385042224064611782),
  K(6.19507838739283680595886552111483547459987060333270104676999739e-7),
  K(0.4619112984033408775739872618498548124719817744672391607603356782),
  K(8.90183541580118693370092311539753055562538822320373837153387041e-7),
  K(0.5074422562403373913610767066381791070702026919385143296243785761),
  K(1.71899997089660247831332471076854985448862856749610345662445234e-6),
  K(0.5154358223829724681623418029550502616388417513593305356946651811),
  K(1.91774850238684565742750712131342944671955972742692645857698358e-6),
  K(0.5384905102486288272296547197555283896509569093701130334377412002),
  K(2.60504867735499775613052711922365059287754770690559947688713012e-6),
  K(0.5998985123542863898233140257881452926245266812525642891574679977),
  K(5.54771265101934785274989192636416497846835661183914741698217975e-6),
  K(0.6026154164304094411977156658715176259865514452515907231529658396),
  K(5.72599716140499893898297065289340372844009045620340434331695488e-6),
  K(0.6333135628208673193780398241802125789205726409845297213709608185),
  K(8.10776188157394445403978061799815827556935511911738375004895391e-6),
  K(0.6445663484695050315150135381640755367648254002331377784899154859),
  K(9.17155258353080150323956747644823066518027323398949506629582693e-6),
  K(0.6596852329149999547520555593108984077135832127508022984007514724),
  K(0.00001078764884307185401887649428399425725770856875807449133558346166),
  K(0.6599566399360363154370891164180812217025945122330682938328117221),
  K(0.00001081875491876211580301090292044719699685609992139280223914768705),
  K(0.7461087986697003335797261040399812263424682099835026011525525721),
  K(0.0000255378654420389359713660716009747075329584532111103896486977766),
  K(0.8264911661208226461879618205102838854824069238169827999120033614),
  K(0.0000522681315708088224385204263685643572942557523670721505897494387),
  K(0.8704877795145745199505242045379010116202904463299935942134018695),
  K(0.000075146405836146872728012480525329844929127959831941418261920119),
  K(0.9803374573238836099736566045951080616305782140305626143674129512),
  K(0.00017266274486951550473123865461216096596252885131940702438710184),
  K(1.043064807953309369996495181598463284959921365157545992577278491),
  K(0.000266531481633929434483810692264644115932019141271707027573053923),
  K(1.05271925903355706024862083419507111871389582070367974030459583),
  K(0.000284287286651491043590075443552386703483354507811361102900141579),
  K(1.083254380462779783727706378847615019969822620587881590924129559),
  K(0.000347282249446487507346066270191718950529177413695306265899568571),
  K(1.142383227707496535089269743447899064256074097149535468978320811),
  K(0.000503791189227129610653200124824023912398193532144950615519114394),
  K(1.182991686482475188850973021785519252584447297841152237748985117),
  K(0.000643330215272440302602468947281058510818803139366159836330214551),
  K(1.189819855373584009463301800709203932286205912534378774425608811),
  K(0.00066977480824747221591193161316887642168092649266912145370132328),
  K(1.230714616074006970732740641014160324901020574685679548781066389),
  K(0.000848482135519257328372341304410276429608392195013571887255607015),
  K(1.250152962873478708035838737132185691008704181911215857065504578),
  K(0.000946818899766711410181041871670811493164583349965960492344656915),
  K(1.263415022922415676249780316056216723197535566011946360354897427),
  K(0.001019370857607994048345526487467175294523276767408125339716018989),
  K(1.374004368287264987184862568932295680600607666586096528477361445),
  K(0.00183274233569980957405568661239004375395046414240138900853278471),
  K(1.56549339383179377030949593644660674438851143777391298442675038),
  K(0.00454287775388651307598805290090853034350258220748526079351936455),
  K(1.578840657349113167920838459100648886863896328168912633056901445),
  K(0.00481762758384455774290383176649528933445940207263195789858188505),
  K(1.659427956713171600535912804974285464084671323768887334914912598),
  K(0.00678902244150007896880682446657407039063242718022651769907226164),
  K(1.669797431935617469365877982917523986809166422395224588409297771),
  K(0.00708551520834157935075222484672804191915851883679873952008555858),
  K(1.695827521823423054736112959169272807121499343341434528731356333),
  K(0.00787742289163536192924036116307762200571734422331040775484306185),
  K(1.696750043061854843437084975231509502420171108207204109738259106),
  K(0.00790677890905143409433555378149237429030088839337144491557186707),
  K(1.773511063671093540068900657542005685883058748053956713422308206),
  K(0.0106868334306950646932040513668782793192196566273322839496345443),
  K(1.787691040155705879602531040545904662384350437764344672524586925),
  K(0.0112789092037391945084111488503112602421842386771993398985326902),
  K(1.893579368889357872526607213060461217838141367096778057793771787),
  K(0.0165981559049304173630336157563228052442770881034407131287726925),
  K(1.899492779415021743676715452436913849570980618308688060816192297),
  K(0.0169462229527656880797910611308380057456158696813100114872291651),
  K(1.972436820880413346627244845097449555631572934033262931232372631),
  K(0.0217405307714893306901544882098234258350088695003011513790543701),
  K(2.003412273822375734923217874955530543489358463399695371299052842),
  K(0.0240760894531422306847325400524317073088368713262893757628083008),
  K(2.023951258620709653477776026484581507780104206827460410777104164),
  K(0.0257305289563764660969409318981603495629031652880468482663627602),
  K(2.024424952799472259650867311192675013983654390820407215484826652),
  K(0.0257697095679603648549285369273088695630336557465285011005292377),
  K(2.048861946135727661963780677053860888262111081924862197528572781),
  K(0.0278551225897677625517214132132513364985591640808343078838206532),
  K(2.116778325937321604064372678626610349805973205789978369331692243),
  K(0.0343440920826668418396987084601363400313173391311573242560599767),
  K(2.120898697751095877354650050181029419184597035474012379065338872),
  K(0.0347721235034240738662786032228370421178485910706659565276456384),
  K(2.198928411667798452438380635940688365171683137422186921622772115),
  K(0.0436706666045415778899931965472893917651643024167717933393772572),
  K(2.221467522841929144097553808759638533241630518069433706589464713),
  K(0.0465332805527697110577944176943015877323246017348910673021337314),
  K(2.268507768100265107521057744971441430810938558691975268416505476),
  K(0.0529526079849122230659171163076602792327537511601420448802747771),
  K(2.270464619022140140842213853032048599011494983666421131610432304),
  K(0.0532329845243214873471550349442829760185566247762700237593173661),
  K(2.275107672114967405767104695303151579615275571539815510026971806),
  K(0.0539025700497283818857058356177595676295390542423046698913256297),
  K(2.305880947685658856421392719003384477293568019285956186859885392),
  K(0.0584961244480923331974037130153057340501270639693312891548093309),
  K(2.334539977490038138758156541064634032564324784797008691064643338),
  K(0.0630214736568912038022675421622225933839085658240858897151306881),
  K(2.371331302563645441554336831958553197879342799697919421242544059),
  K(0.0691886237189365364584615869276261230231321079557836818441956181),
  K(2.402118832295042233747508836152829286170458970233460919521022323),
  K(0.074664362319035378535407371715164423165633563569426355041818614),
  K(2.439569764888991665732545435165839562395444837990966450488795411),
  K(0.081718594754206024338254573153874977212522460809742490826853906),
  K(2.44502463656894991737537798714959205084987397556228659674173536),
  K(0.082782429274631012086638951182992651261085169112959510296575484),
  K(2.475364957610979814315286987940667166385042254747931909556242963),
  K(0.088869401845431355456954155643064276609831526165179474632571305),
  K(2.485080853356424954511974536597983423988331921921986833828835934),
  K(0.090879688885181007520350566515846920231565936612591886126583427),
  K(2.493065941980367896392467699910892348924043057731694303412101176),
  K(0.092554084525181198917224718458093974192168880831737050225471253),
  K(2.507099385134008524980605870181218590987363426218038357396062725),
  K(0.095545389729062180337703642119496143450663879185519579953056713),
  K(2.519320684642182888935563727669403385362728983357361341740951127),
  K(0.09820094414061160209421318029772604456077650817104517169356374),
  K(2.58914692999008171726177631712843141324833290066908127281602962),
  K(0.114273228575179829727000451618083006032198863655088927540046021),
  K(2.655386817940854792664783603528941108076472525156532879562556683),
  K(0.130917382914531434719495733778250694340175269907052147802636797),
  K(2.672988253127344280282968782229604487041813941819021402481109312),
  K(0.135563461486817622707579331417054596666235006020225975825603422),
  K(2.85040767625023162436544977915810480761440061347098168731443292),
  K(0.187214256040889898261436347724474412867861231341935048021346766),
  K(2.857234933593646461160135326628568665410363103837270290507200955),
  K(0.1893605171376411408470544545452439769326384527415313726467318),
  K(2.871716163847185753721983564251761306879301333011106204490939162),
  K(0.193946924090901703941719509464540281367976460969998759283777697),
  K(2.927379870947901223665493954113340952283161457253720566054517373),
  K(0.211976867067424883311554159800877496831166529927341793016535161),
  K(3.013884527785211942850471421586030156448190410111115062767725401),
  K(0.24104581334437145459061250210971503726148213623927726616305747),
  K(3.159731294688319330250574152720728642274043851526777794636892134),
  K(0.291681246387740522234672720704532536137321800114435133590171003),
  K(3.170647688925811279140640158597986820073495304237210948484252905),
  K(0.295491998492990194282266269040019906414534378671691881619647978),
  K(3.27766761283411806243888752016510557359139850843974091561234083),
  K(0.332459216135451498037173304298582214597243036991399181725979581),
  K(3.333172929904965489834871081365623423068606261216036936720413081),
  K(0.351079588606766191593249442715672585098176027897293271445746647),
  K(3.355321835067331984932749023671240261520979123513361804839826341),
  K(0.358348092140795584622283436535231761149841558377537227403442293),
  K(3.355656513201591963522117114987151839470651459019114187514434625),
  K(0.358457108695767632617127216562163865764174029450750019862021472),
  K(3.392760408141697303840495915644535868651971746904855423117469933),
  K(0.370378177723411059186451747265206163675574829352025017441559943),
  K(3.445704713186035548259034926734609172151402217682992612188488898),
  K(0.386745366339717983751291079891096006005379639253095648529264805),
  K(3.4884427213435631320750506016937393961589493940517196769690241),
  K(0.399309773631054619329604125318747089579996700019208198682826582),
  K(3.509590136751549403373807931272935789499914004125476830473733799),
  K(0.405285555281718662069629481589673317635243288495106826171513971),
  K(3.5181350282957164839780014196274363581699496390964316323480367),
  K(0.407651726217743203980655906250275174824687178440304494247272227),
  K(3.550212262308907264679482646626279949265859537875767614676085078),
  K(0.416272258084810779740547716643333473542163195604949401360289724),
  K(3.613768063190983810826448172752318614975471797692076867409787552),
  K(0.432029314234751111870864922511911546280102115162678757737748627),
  K(3.642424356359782711456490495616837987779168110777885428215316094),
  K(0.438508566606928229699919649569449437064191332172881422059324903),
  K(3.71143628972969272928358001944302103677612571313371338336863779),
  K(0.452364274465083051655046881486957959908093559737936545338003818),
  K(3.714490187776748961894060721115400576473020480438558719779677094),
  K(0.45291747118458013501323497718594353825138972039227332692891647),
  K(3.721208783539675776204287137935848110407817206400447394637912426),
  K(0.454115998626608689340852752948628506969988281077580190180862392),
  K(3.764888164670742860912838854774768121853090195048283858362535754),
  K(0.461274317175151466847608763699681289901845305601600212057721035),
  K(3.793532926242000053741589501870747545858905435670974392611437535),
  K(0.465355399118699514941944233438897148833917029222645657437318194),
  K(3.851786630523151411571908032988123987567487101679922141353385501),
  K(0.472096012410743181901479928277811135677680587912503366369023695),
  K(3.861990963613382134575510463703544606357956276674477720086967588),
  K(0.473056370342230929882798842240413887242504858716881083556813911),
  K(3.861995569297785412871305900169012939700653151863599673075385983),
  K(0.473056788742377711462613579857452029824888662493986100200132417),
  K(3.862308328465681041998124074285326307528287902544785563412990836),
  K(0.473085169285998978824725766776757913218750947819650406139262228),
  K(3.91569919648712088953200466135607679932655917558233852493889446),
  K(0.477001806017238302196234225650778787261261874431517380188648111),
};
static const R b8[] =
{
  K(0.01013693451601745312281015496849097110820157028083683178081660727),
  K(2.76523856108674027250862356102411280235950210615161792151367617e-21),
  K(0.01118505646789429515639498141422562610730456813531819065667527455),
  K(6.07554055800176353581703910065912093641843004112912263111100483e-21),
  K(0.05004668982127415726756782433736912322452800800454528561551017827),
  K(9.76073087542247396134043729035328094979647130907518909985427842e-16),
  K(0.06199850143967443165003328082443706217891167033629365718952578159),
  K(5.41413418504032853876262317307000091098601681343893328703965536e-15),
  K(0.1091247412042790203193901010668829671380627284343389672113626396),
  K(4.98729767587172272029110145609842950681213326361931322502336134e-13),
  K(0.1447629772687006452639928216583650504243733862689780087493131195),
  K(4.78343115874419845141953239994913212297037577222578514288107014e-12),
  K(0.1716835533345024303412075212292491699295517390969323758871446977),
  K(1.87201370131044043078080685204423029803483165950621690912537912e-11),
  K(0.2982061296341357821671847216395163655750855250891301607959879713),
  K(1.55100074242727806352008982976148235721913510070844206123598707e-9),
  K(0.3152488120326571613253243355878251498415084231622508166875460369),
  K(2.41939704550463419572128829351999698808376749289862247393048495e-9),
  K(0.4351209221729261305452570154333987335729452328671916155582468051),
  K(3.18683227145458791786675427653761076811409864301788021708337417e-8),
  K(0.4497103297853625517572583744040478609435682355018050705239120449),
  K(4.14898995627677664212007513437506028188085034219374534385617511e-8),
  K(0.4506074193185091524692162940218647480649013448931769518698919363),
  K(4.21566587153121332989086348384124201388112314325698147192473176e-8),
  K(0.5394714652528408477449425159898025237356778943717704913419005914),
  K(1.77921037080240777860014565818409861640360699934417837913245649e-7),
  K(0.5748251173173936305576870650266816504221927305921660078103679893),
  K(2.95641481263776538279668367678121526457457898925174308369463992e-7),
  K(0.6188513225927204852872044060674206469801320754048383655208300464),
  K(5.3354378341945316711825591865738425830596128661145566448867476e-7),
  K(0.6300096592651776240191418777049004134119777700578477722116407521),
  K(6.15541220306989651500840285489307029734907479081249298939185609e-7),
  K(0.6608259929991801143949085406101291852117539139616188261761077382),
  K(9.01937438517629228319277721853822272483049226579935638957664625e-7),
  K(0.6745397894416153812736737088678259570717019912307778099820575535),
  K(1.063016629073923556067401912218351211126657207821899489611163291e-6),
  K(0.6804943394932734259860568536325937089993179978333743658389572823),
  K(1.140448327178294318546436523022433915100914039643324710446717403e-6),
  K(0.7987363994151629741189358013112450453523998873313789067307949413),
  K(4.10872700359515676044212083379928843977813100909119626815073384e-6),
  K(0.8532096733209348491395013219196233437980107182772957901785301562),
  K(6.96507250567520711433110153335579726545309810127415079990573348e-6),
  K(0.8634436823463853155952598560856588419632282204252555022433933836),
  K(7.66216687298079501896358123372825775751061687470064032510429111e-6),
  K(0.8799305061173707927842345389400954008410982997908597689219071241),
  K(8.91387361017844432463471481863327613636634304964703335976697637e-6),
  K(0.9056787878127420086787828322704082866975719145335466217289433619),
  K(0.00001122724100827153919483131872585036890670575383897939419196502642),
  K(0.9244232011099953479703731205411227728195893008470787683432307039),
  K(0.0000132265376118692143182035302280031231206938758261199824159549732),
  K(0.9978422116736872439506312723185166653124866298603001406785531749),
  K(0.0000243766741492588250865015513844323601887898278496840459825979657),
  K(1.008837400612776148783756574675443801360813991246584488323534037),
  K(0.0000266102449447799981239263946106995290667965521370922139457583953),
  K(1.022415765019397201871815177657510979488806629997042162243367115),
  K(0.0000296141843734680830143062629106365254209803491743299581736713359),
  K(1.0617071420836923187949680004342389366454989025470047758040748),
  K(0.0000400421498824978660186865192421636822424436356201504436963310749),
  K(1.068182937330975288766765352795579631609101024606181503548109746),
  K(0.000042038244058365933088689671238440571343128974537809413767837358),
  K(1.079443239563823461765925930999909465815636307551942602915150747),
  K(0.0000457170247695785422456499936079864902437961087137499061840109815),
  K(1.216082515234118264694723871969242466437836286927424269734427429),
  K(0.000118626016421236906956070860969472507495623401951925909668525764),
  K(1.244739058239950547173694973779781032155928468570532781475053582),
  K(0.000142921407642697791079359483993272458215735327381967505717168363),
  K(1.257412011121399229011514130058187543858121077974993554532637305),
  K(0.000154984496121296441340681508231074707057280348819837460366897812),
  K(1.273025308898553260349757399826705989471022165035070505718737577),
  K(0.000171063866047282114156446701837871575675374452529751095556330012),
  K(1.368719609866335545070370452226751369232333296491920489078791882),
  K(0.000305412611275074401125027598923265222803154519574371385572930405),
  K(1.374991452275724571535036241851839792670160159920924004686155842),
  K(0.000316781512885907242390831807387501551424964071316983045442171699),
  K(1.403828634014198769674140165276776756970785529164734783558629641),
  K(0.000373946041407169087655278189449803903449030052671452882789295059),
  K(1.406347360106560992391139536062083229444376820344466138721423178),
  K(0.000379341519410413379224730639815049039402968941453693779756822359),
  K(1.602899172821402557484464948987524534425387007714884353743439423),
  K(0.00107686308902996929844431377283555453466683646612011364465071382),
  K(1.712662917869520450896374034067721570998237748521145054173150361),
  K(0.00182107136818758405076574615692677891209918159142226328962771949),
  K(1.78901541786355700584284052306532646087668016084235423873745371),
  K(0.00256898055588859771092379002804252530767675079712901962120324722),
  K(1.794919987430181703733943965960446845410301974275774286359944349),
  K(0.00263643473913094464970004326163947923192712583743968871150122169),
  K(1.831125624553408388036930177393477137626355905657337228122240452),
  K(0.00308408411583274009097668693452651534516675521235289226852531843),
  K(1.89009213899441846725344285398767396331156233877292717622429322),
  K(0.00395170267493421786864856617222740966980813060978528943198099644),
  K(1.973833259880454748093319246587163978782213845599578622875238803),
  K(0.00553375131219615492930993983491643924004732500947751268854383769),
  K(1.998852368274861047493921290291639643725502284127280087616037862),
  K(0.00609894545937291651267736384062584888208270266609321454696882516),
  K(2.006526506335532698206434073133477034226991953452091907648495104),
  K(0.0062817259355293574856572179033783282423730438361520455438715924),
  K(2.108228798228613978468403510538862892229331925032339313005448594),
  K(0.0091709219155101516048032419040138561628300859073397477366791147),
  K(2.118151419304565909716014383565746284012319179450948127699951414),
  K(0.0095038780307271087919846804911554852977402564356257640460921445),
  K(2.137426655721916268086202985600781658617657331196943890692144888),
  K(0.0101792839480813898813286860197329734393019268725399975417487502),
  K(2.174991649692350467938751905709803678030442161361243001199766802),
  K(0.0116095721589682846290802696143043470998165263542155693484623365),
  K(2.196489550709614549927149819066758851732523723505725431143254927),
  K(0.012499772942223263759224783779674186629250155021463039136065774),
  K(2.316018028502095550906591384231109659585751198693802770474436665),
  K(0.0185230735298330337605493730553391245829401266106809071371389468),
  K(2.316684568555337938083785856669889325065524577032945584001957137),
  K(0.0185622415141660645807225507215731711015575872504932070974251616),
  K(2.345074264888075021529588585659454837808739244176848137596084391),
  K(0.0202932203710502046283823747165220017362847620211417947821181989),
  K(2.345748383610139146585526772338692320153159957734931700567800133),
  K(0.0203358376443576558439697105026815560499849168712690052816618745),
  K(2.385945665969158095163383824539025729093040209057848747639823274),
  K(0.0230090825437287664656361698096731233368568787871807572439391096),
  K(2.449270766402295438062859887372440428243166304718169248510661992),
  K(0.0277770742643077223320166158117145196519378348260679844725058841),
  K(2.477109794678065563676094510679098028161009721287973198600223306),
  K(0.0301032747120331018223489333159323161166305606172337341387154037),
  K(2.536585527481579733180523047861288802902789191077712894771948592),
  K(0.0355775473499806554338942968144431121818222194266163320726363781),
  K(2.789791855404227023927912351015741487783559882863991926803480867),
  K(0.067633767130567997343477737305378835007560706822150118021750415),
  K(2.82457375474056789182034743778869660160636127220899489970318551),
  K(0.073259600506135562249555161886030728122569677416535546419122535),
  K(2.833580217763255300486971031046493178951935624682620146093084535),
  K(0.074767423222217110276775857083864748338839787653457734765645376),
  K(2.847233840549001014998593451845492465533182288199974937572537701),
  K(0.077093598598746867399618000654858464805748036510321456011955218),
  K(2.859225152952734473397135105019031654117503252890986142567235118),
  K(0.07917681218497898150531560732692256168925166945001878667082601),
  K(3.027253834393131626326232097588417965619510393198868380360498189),
  K(0.112361863763336106823893961088122096863959515808779003074962067),
  K(3.029536962898594225451459996167049597250131457319025835285787768),
  K(0.112863967557342639546297228844683538566026411632332573653396871),
  K(3.136026554912238001729664295436629606257891297160843835326955625),
  K(0.137759356004774479144423997070968475388513981075470457050198003),
  K(3.151369815717810381588714916958340626232332844030454907950684161),
  K(0.141577733802811126836432286947594010130033310457633658340450306),
  K(3.172388295055734630799889785627612051168540800653042419527630041),
  K(0.146899022368699628586989915926503368629088475221094269828473439),
  K(3.202332924301785969568378875067014090427672618434064487971936944),
  K(0.15465629606957620185655353200986272988712910330241453581223943),
  K(3.209308376131154547649888166954365863996907715859862472917263761),
  K(0.156492287951142700099852503186718651873256776743422415360157478),
  K(3.218588663654172562403142477939120060068127285178873220927921473),
  K(0.158951526339468307813640387725701911337422127753388756683388833),
  K(3.29756857579867776063150302519147559427316864520934490312407631),
  K(0.180607401046309874271990613449214978938748828916548092157517925),
  K(3.329294647166491345887539300917792430487453592220112204730847041),
  K(0.189644042262601653927145666182115796022420144727142060203845679),
  K(3.369351073324055940660794370720857061510336874351778723625416242),
  K(0.201296639139506118975365118802042213030331870882740415876394864),
  K(3.535439735457289997495352019390017101482733215173234910096300332),
  K(0.251751595370776475556333488640604972759579583258734361071756445),
  K(3.539024602803668097641120432056919399516912288614632729921603929),
  K(0.252865258264510378363912758727607757134142497210999320683871222),
  K(3.54646304485159015398172728563634426849935267450099427293404398),
  K(0.255177717372503011052761830021541937504045368236042570553107797),
  K(3.562397552917082952810744575678749597965957760741987443939834602),
  K(0.260137727497047388364128746972836656422228442233264311475335006),
  K(3.602410923177404710231735292222462980748327754947692151410738932),
  K(0.272612995129879332996616474297048065928269277343172037830365237),
  K(3.635662731790834184474591902293150747815103819049601876472337073),
  K(0.282974156222591760321408553114019157841720652047894584977822266),
  K(3.644378567058983543616113256522108149533654118390367042582701585),
  K(0.2856851392390440374466575398665902236046088800455817714134048),
  K(3.648667623960134572333080208352348511146914318388420705952303375),
  K(0.287018127715599137718703022376053287046395318059536014267529514),
  K(3.654992382861897702428705942526503307121122310452412467148530147),
  K(0.28898230749603239349071228004534849883001591444418622737358422),
  K(3.684436758525520854051552268179458658486043143532920899527726095),
  K(0.29809737962274971002904177637450668429641296438277750997515408),
  K(3.787974717309825781392998164945420062919138775940425918878093945),
  K(0.32950275350863318721810031585591926454624424225964431017481096),
  K(3.912836633474839174600020944622188817420303217609800607511343237),
  K(0.364986933701514209957141627327509358166010512574442564302155877),
  K(3.915082406668500327321949741645746700310378666960716635751306419),
  K(0.365591783870870031357599785268131968224231591610669635668855167),
  K(3.926068972510176526264321956321577950374456286705155782324736846),
  K(0.368530926479637632108040250940470808605460636787130876349781325),
  K(3.934770898487290401967346913912710505844811362698944247184952561),
  K(0.370834959217068933914417396462766196620616759557318762185343475),
  K(3.999312969343859389812451580140996433923927976454872004246395547),
  K(0.387208925181027282783232469024831587661375150221541959218842884),
  K(4.074157766417651020581237498760415817800468655130627371227337224),
  K(0.40441205680046099196766231425566605014056285541284068502001274),
  K(4.143579320393272081494099122987688161688561639030402668939084461),
  K(0.418391883853586772846548545055603152450339616307807857266261306),
  K(4.173230614088150861282086156682530818060278143737660170198375534),
  K(0.423724073579886129329075289250016271257396570716055001341195518),
  K(4.290711277259944225857102533613052470087662858376699421987607819),
  K(0.44071877066590002226727580428241907609872194960302388242445138),
  K(4.365485434471580580528274276802978801230120877511146178931625446),
  K(0.44784171727801910648448840007645954618247414494366950924282618),
  K(4.396006256183381154250171217191172690055288719174583178986967537),
  K(0.44987857581880833402052372558885659274920551845180936824147169),
  K(4.471007895260711197087881896759165200424190089641861016544142386),
  K(0.45268380420055578600451538114336510460780946302812368837536393),
};
static const R b9[] =
{
  K(0.0006771624680886616434302975429633283358215148880447915784050205645),
  K(8.25035963710581085307940306045163224197291143993149736090812528e-35),
  K(0.03479607296113315781894929288253251014342809874379900931613474164),
  K(2.06067291284512596020497083953118956545434440766877309035070776e-19),
  K(0.06013481642525312934259472081476647577626849437832071910552196533),
  K(2.83381094205043366585123537548239918709024035605411919250490379e-17),
  K(0.1279595043289574998356206351139775975494450220825140703543165183),
  K(2.53448607287259467323713755743039834388347983514743542985161811e-14),
  K(0.2139817911511823931221917723270567365666743609517050800406059552),
  K(2.59196022975983563174504264201417703974984958906252294056991914e-12),
  K(0.2490131452836061497090786051915161613736668905782340984215847626),
  K(1.014465850581284831707784268678941485185880688042549877681933864e-11),
  K(0.2710462929340737564421721772652506483497607546125594737329461154),
  K(2.17584630008964856982166468944349553322065595499791868128803007e-11),
  K(0.3048333525051540534795364424438695983773962119317643323619752434),
  K(6.26324367909955125853450380791711894224148336699770154935494053e-11),
  K(0.3102035174440482868601080734217805671009235662957454408267143154),
  K(7.32921445463045423089842688085654280917233476740151354715496346e-11),
  K(0.4132882107016095768538812220346531103062121618505030947767457784),
  K(9.69424786348802228341812483103076816912099635209139512328196053e-10),
  K(0.4326879157992892401183590702254527385131645099632349307945782064),
  K(1.46490635758234475708416575106543801815831391932884736030658229e-9),
  K(0.5464709344322114724567053031389505322411503151830370441276355),
  K(1.19767939189475964348963679024735766127293727923327923722765248e-8),
  K(0.5571732773571021005427566964687737165753116536839005420470275619),
  K(1.42609835268269079851069350785996279419837640463825121897218807e-8),
  K(0.6788873778782021910610169882897221677736447861470678683720410919),
  K(8.44144071671143335144721361036975140178765910093436649683191347e-8),
  K(0.7538108214775173491328552706869773397453208005147465398010258675),
  K(2.16569990227842487257057122122316672327710411044693581297762443e-7),
  K(0.8253874753356087856446750318063677814187219188488210940615201086),
  K(4.89956854098458233009792090341428992546792756212707766697821575e-7),
  K(0.9463098438460659280657026063348441626853386827475962772025707037),
  K(1.67701592732579993487993773644445128099377245508903489330349669e-6),
  K(0.9611418530954410212362970550959526648376204874348385403032823256),
  K(1.92896509455992849682323447304141987786428917779367415189700905e-6),
  K(1.004174088105565303465386340776932397215001163380169957097453186),
  K(2.86100134669569221943889605403967365086652091685999362587376548e-6),
  K(1.076634537522766862074855967755324198098800584887480091962854108),
  K(5.35613770926759226364819956864525378715499211814035808119178257e-6),
  K(1.098647374640089501364296410095338817441965480880849597072452271),
  K(6.42631287033112642993054783765224395794605898097807126835603185e-6),
  K(1.150500211945227862966710651763098645391254546885207393176669609),
  K(9.732339392073387654887248000342160595024409098697180070979347e-6),
  K(1.153737052937965044306873912752663454823850110558050301487508533),
  K(9.9815611992765498285836638407461392994936886926421595242521041e-6),
  K(1.18840989082359896053072657778919553998397021649408492964134773),
  K(0.0000130296578418414100690009365687781705940786636332024123326741891),
  K(1.275051482259720998806209961126921970529146260925948952542883008),
  K(0.000024546075080292688726079720959428183417982096994647777480542255),
  K(1.317789644695788587143814545571236058759999977899764421712628935),
  K(0.0000330247700474215720361920219632270233069117067024869318805003671),
  K(1.359656431049813890179795935530751458749244642495774995718611098),
  K(0.0000437594707072254164944895550965968546170462095105309900754861737),
  K(1.447196786146134057085929769439260809842181920570863986482473685),
  K(0.0000767138348691233867391307324714753792496514769645059295979137094),
  K(1.45764765086311544199630809979531022660203213680880477024767078),
  K(0.000081842941106416098701333694574518107808217185402364223566935839),
  K(1.476718138506414732047293570436733329332110029288000770105812228),
  K(0.000091991997283492283460310587232968618034033501022498052932165943),
  K(1.597245705127236716965395204689714861542578479076490185636157299),
  K(0.000186192197790744543913563799933027897876388711398862979408811913),
  K(1.796610194609899328183821821759353474224248027868650339336309785),
  K(0.000533869753343336922122088504991236885280045456892570397603847604),
  K(1.823663019643130538149066438754550966098158969534759368506666939),
  K(0.000609998068227479885940744873957354821412302319171154398979136681),
  K(1.868001492682259476373992635332123191166541224635148676676731871),
  K(0.000755481074288923659306075820942624521139679025014019780317433516),
  K(2.027277367605994231181584674427556497262475262840444380785166917),
  K(0.00155876996410606274169907888943086936744828650926326261335650221),
  K(2.029321837407181679888204648379991728333165868621452784278878747),
  K(0.00157266112683735500199116688544291924097046602715910879192578598),
  K(2.051450464116188255058715447701185155304685008436162490174336481),
  K(0.00173003170662319003866622871088572996361451955659062781853878335),
  K(2.059661357178814276699540268805880590143138166274470569219300783),
  K(0.00179180409319517091095808792936221138955824057747475024661347996),
  K(2.069269062970455865681146458858638010255603773227596815282330048),
  K(0.00186650433598126441268769856811321030896566365514057025865858868),
  K(2.091918441280870091517186690839186973733706319449913624055680893),
  K(0.00205336268600764046896320699580140481553554337291373941880207164),
  K(2.098087608159220415515496257788361303799359619498140268085717036),
  K(0.00210697952548826341946175835141102086912064728035598743862642311),
  K(2.130226109265032836075303179893893295466251456518263585233503788),
  K(0.00240631620431480246068758642955729583722496914194960060537667884),
  K(2.141194897443297296279879397136006382739379213467234303510988263),
  K(0.0025165465004836034212368082935394575156273570807483614365323972),
  K(2.182354613897786728215229216226894800678293026021259436388194179),
  K(0.00296987548594843308108195073385278480749856752622649147559681327),
  K(2.282566310708098515010066266779434637479196167766406990296395995),
  K(0.00437618381881137193025186043201297696951005512204353611896726115),
  K(2.284064619125488881476962980347040641054828694624359413496570312),
  K(0.00440090437679091471787911803353109588991180924992459955431529867),
  K(2.294778571203896188791492503797073721166919080764930588580226776),
  K(0.00458116348289019555734047202434922308561594253324194371011388318),
  K(2.327325017137841123994930611146920871713800552576825177141239816),
  K(0.00516775086308881805778237870253210624931643077002499494680747399),
  K(2.34312783506122710862980272657478604324349610712658470462056161),
  K(0.00547479550732277529436822159888419534496353908334301409329101162),
  K(2.517058137704938609536106924221191129247429160560867685773548636),
  K(0.0100031757609048690562303568500987144177978217898214183846913753),
  K(2.528439053660481336026361774883125426313913772941489986618514748),
  K(0.0103847314423841928241158449580865154565864034932048477229945332),
  K(2.586332596026435063707071728982710858561213478205752323921882501),
  K(0.0125170940362975758144353517091861845299472375583144478288481197),
  K(2.596559530211245384686156714012128223555240755605515733759301053),
  K(0.0129288036444220254969114653056489784686070006016685649878868493),
  K(2.680995815767743118367157306286183099135481985344529727921258427),
  K(0.0167701940830737531464565592702182843042452773130044790479139612),
  K(2.819739992032475113060389654764674430964956085372193940657428818),
  K(0.0250447464330253246830801062292733023709161099524737352121633953),
  K(2.876066615241571657517534941209995260822764708167594737994822639),
  K(0.0292086501588990751611551184820375995571956720669237814206085024),
  K(2.882703944302318210797962969173170746894806144560451301987118281),
  K(0.0297328955681645308933023819690817574280833445137724655807813363),
  K(2.928198977832930710958683632672531655883081408983244857315030427),
  K(0.0335258415085381774323578920678246945305709047302541351785990039),
  K(2.956360564960821118591854792888299947404967053253929220464349603),
  K(0.0360538795678924085064948898442576999339829084486777379559330183),
  K(2.977429418271856113062226356258750395447354808226912708717072673),
  K(0.0380385902144162975111717427747578653508902467658992128095508599),
  K(2.97749792321450768015966928795740356070333622791980596094854769),
  K(0.0380451761504873929266704454723935598163992415244212362854627931),
  K(3.028931206268634403060136366543463471177372155853464071189106235),
  K(0.0432386926098734182726806582228668216744894387034481901552991189),
  K(3.059087242135648292956889348503912522900591481453487518097966184),
  K(0.0465209614753821515900906394237723167339079759589624660755103401),
  K(3.097205286654824139333663647379456118646049347847369287650632897),
  K(0.0509297994640273907219362381127766370007918927563679042319716662),
  K(3.219841696397766264110246596341057683157206213856593863252073935),
  K(0.067178156307920990601556114960874958596898489966822518859543505),
  K(3.282141670159834085040578957396301649026606232604849857093522557),
  K(0.076690449267332750696095699498278399792184913651576373043182145),
  K(3.286487031887577349072751602661103387476872737175631989438314635),
  K(0.077386364559882416427135983497528067233766183945162749512489351),
  K(3.424051107101277555310053322170293782743463280654924886914450208),
  K(0.101628391362820321644351127575909166707301262703713066754364652),
  K(3.675293646016700005777998540062992681139544649829557453755311115),
  K(0.156608490516756738348436805201563876157835435461021361111219485),
  K(3.691063295044440884673084100667495610908660395527979691511541456),
  K(0.160478561204859601863722092945645510397062197225283631213003173),
  K(3.70168562066927245717102058743189190617996071675036993349802959),
  K(0.16311007566261974151399668611200273421653112601205978427093841),
  K(3.705371307142237796311928245777445909789400476902158275799218735),
  K(0.164027700713699272693321066427385232697418461893837554052104991),
  K(3.723901241731414550545969656118303273992851963173345915785260692),
  K(0.168675894151593901115115728008767966206214422595327871326926812),
  K(3.728674962591145768946854880048093139492454092268684039295003595),
  K(0.169882603205914862321985620730635456790106911133508891215882155),
  K(3.730707162888102970649555981073219680926074448541799252501972496),
  K(0.170397433422599315933889621231897603356266696236210197572654674),
  K(3.754445723275358341177311901949944441095036975256792322491273495),
  K(0.176460002169296142150508193196126904121000820800432995482476014),
  K(3.826152062123343195407729781102614945460768073717303549337040695),
  K(0.195274888865441825389582235879858927979985514938286436921424478),
  K(3.833552972858513981296196356180458015751625485524864912316609303),
  K(0.197255564186055839387061617670028689476253643510855525423512751),
  K(3.873283940155717412998601543987456052520782985394202951227587345),
  K(0.207995893780417729944208318342905706773074497223684758410470609),
  K(3.894782491438127163936554440095571825065978599807811778566656429),
  K(0.213875663833959379358692904769353446742414102270603664165212048),
  K(3.926531330663457834180923835219308699794740085872437398946653907),
  K(0.222633097618661776933880655835862346966607982579625229676166772),
  K(3.934248799902119998847641396347078362120318168051280089664450937),
  K(0.224773585086610946591407685282653488762887361720078161263748986),
  K(3.989913340454074232841352546339561657656682719070930103044575873),
  K(0.24031753691451345383316613708572282779212983140621338846631962),
  K(4.111614045282037703100482544342740847380534840401079033869983782),
  K(0.27454823987613839259367597784892966677259779817917554235828875),
  K(4.112522598181063647823060898612902141641414037093476346438084545),
  K(0.274802986407257472024870210097806246640435731954011263498600405),
  K(4.190809216402502829257555161314446220273176193533228149785160276),
  K(0.296571229711978146259560612733539282940629776456219678865730915),
  K(4.195642873128271647800533281055436351132918430159697967396981315),
  K(0.297899592050281609550831515082680361867636570525867022980710177),
  K(4.204117231270028630404275647923744451837142252948504081729464211),
  K(0.300222879483803753141616938300420179810872844073205942379534747),
  K(4.241940641771264182273327604537581767333278149874110534495884298),
  K(0.310494995983075493166972723694690595356088113149324936791930466),
  K(4.325152817316072168869370025565837438561152621642430431952980854),
  K(0.332380122038717429287338313740926858584312756002330846741255172),
  K(4.336054953288619380091605298677006336494954258703523882042114507),
  K(0.335158716735277765938866334653180717691404594522086710473036149),
  K(4.451296453517074373170996194433584133004358485885824250382385617),
  K(0.362916654090890875420014442827057467511233143846612522942825778),
  K(4.56160632048516861961325354668623367759525606830207137344916786),
  K(0.386061949921738031814609848613160334389706695708386385667138087),
  K(4.566391973155778835273712518247290020527924406377003860489422101),
  K(0.38697662788275249031416006164008876814380604889024246534679189),
  K(4.579894832929234974387873068695304272703043175688638165445380082),
  K(0.389514123450072803639856796220456418845680022404838909839842447),
  K(4.606435843574977179882297771625370688876325149299923227386387214),
  K(0.39431092626643622926946524311113967785648662800756191583169601),
  K(4.655841135355971486597564108124479834045343697462656579812878327),
  K(0.40253560415242912401323296105955854764571973921160405226618783),
  K(4.708996707157176755782573466114983672306780453044194300491205235),
  K(0.41030127082177204110759248027089339667991062556249717824771193),
  K(4.876951298241036768702215636964193855994623345612702159468070933),
  K(0.42675275292842633841971608610014198177413230450031114187432834),
  K(4.96097681952867298288783011536814089049807147163187828287652065),
  K(0.43004779481089470966011122170930898831213172699764953007838506),
};
static const R b10[] =
{
  K(0.03992413284789715237267329883555912543520129911264871479511078645),
  K(2.83525344950893006811940984228149901198649233473829544376144921e-21),
  K(0.0527646289144559493198110812892720256899951379809745887365151268),
  K(4.60962767910471026114335999792893169975494945473426021923041436e-20),
  K(0.1000563161898704491509990459812583932775854389985275927290613606),
  K(2.7712905430188324656136112613835315081828672956839521297894868e-17),
  K(0.2067079749107250473521546065857742415310423970550038476151644317),
  K(3.92472552558611840921136063190248139226485621837782117051516264e-14),
  K(0.309715240806931115353570328364763546290560644759861451192540632),
  K(2.23801368764713212986987549984252856659218056785871803355906232e-12),
  K(0.3803286344488152158945228366982330730350619207023354617857587484),
  K(1.74512768471244324522461939378008295130000681868898251443443405e-11),
  K(0.4086463605984760262073090372107677470133230951914059681416916752),
  K(3.5786013514674234921502725376443820548852354430577700440861458e-11),
  K(0.5224362816444891159664331201086924341924554259144579498519527423),
  K(4.17417127257091873138523876710238305053609076270063225111208923e-10),
  K(0.603995663427496691377838259554627568561731169505902997362619992),
  K(1.78063609210303508254171994488594782818577475066979716625375899e-9),
  K(0.6115204747047387287517234444504880703687144122529450699664518885),
  K(2.01533381616334247654202299835831861329444332034473679382439543e-9),
  K(0.6121830357399372404919076667658137310758720502435358226926871142),
  K(2.03727602169520822890068845620149641427019452445927754658161478e-9),
  K(0.6897682167179186745891751296215150736644570560354767978543622149),
  K(6.71844485677937287138753992828684426610565799726910682999484977e-9),
  K(0.776444334542325101293219542204836256492074717382576303119629743),
  K(2.19452342560663249975572765341236430462934269353570113430789861e-8),
  K(0.8091413800154303986539185175748610200523070923721530932220170542),
  K(3.31498132044000656133173659889471021707580780926577746306812732e-8),
  K(0.8630552254278748184592809557626055046254813878150337185389251801),
  K(6.31862862729491995612687018808200657059797063720412504975491842e-8),
  K(0.9010691401052513289895035496198918128525325949681823151200624139),
  K(9.72339948376223250800491068318267848154329682169590804194006261e-8),
  K(0.9442748173490913696985213636635545399482163386644686930276285829),
  K(1.55317733540609972586104531188723225074125556054700929289868837e-7),
  K(1.00475470438371572334585688453280887420391768612999402721778164),
  K(2.88959814614805876703387545387806917635831469047774439820516253e-7),
  K(1.010257926651753590148915629133601205983344361975225955093658535),
  K(3.05182505276582230415631448338803871139366413745295339089082776e-7),
  K(1.040452039918917758571921592751012129165136993793664443050025583),
  K(4.0969213555083065374592194110669400614317976507869979739034046e-7),
  K(1.078680255888745545940874144556504346054433741995924417627117809),
  K(5.8771159917115822580494806115813704187713406040852232765807209e-7),
  K(1.083969605083998912349594767750412525962022403569570553975037571),
  K(6.17174555612388905168160146178662808407693870500181732393753521e-7),
  K(1.134019592559310003987335716567022797777508972968369849720993777),
  K(9.6926503020689571658783013835120023736494474313534743145018949e-7),
  K(1.158563114029483253824831785232150493742010771508130685641535377),
  K(1.20069839642534860236887022173493222283979888981766898873326274e-6),
  K(1.163251303231862987346194114246906254181376098970219800019576326),
  K(1.250179665113969905737714620642318034797908344022817889206281e-6),
  K(1.164392494682712328413956715192543428864919158598642526778637103),
  K(1.26249866209758931974049863241877024729035000769740908415951332e-6),
  K(1.19135201005984818683513512643446158870475062641495290735856),
  K(1.58722293954469987427004227635229766524055710854784272029968801e-6),
  K(1.2354848261144105572806715889927365723836700764718136743800218),
  K(2.28355156919959637369004075555018188579261751215596413331439805e-6),
  K(1.251547504720657450401855976568882592591275346867838841480897095),
  K(2.5984229296700090801354120385179381714102218167631821866458064e-6),
  K(1.316339170818142886558957325670179788854598856977747690939553421),
  K(4.30439330747796131342896235095833862352274211116018062267475195e-6),
  K(1.317125551308283007737513645006275217079378425785579143422016419),
  K(4.33017639153953746176728604601789625405311876282018647384513133e-6),
  K(1.319233486829731830444330065951971436387592489714956766771433361),
  K(4.39997638273550653278537121198159872934046472442279877238498309e-6),
  K(1.324904712724540230664180930834845955114415577783041237532327366),
  K(4.59282247012530432081318303990427702903018689377855705550299726e-6),
  K(1.474335696745954883418691011745033125419001059115175508533816732),
  K(0.0000133703879275781143084179967540450231574749455322102744558024625),
  K(1.598888840329757659391380553910536312747804755622835750002070615),
  K(0.0000300718337516685009629424159278378981882952856348993438146026881),
  K(1.631455182560427514751647069643297963142954928413748106009494977),
  K(0.0000367813648983279062574791992200353694790466504246277356033738024),
  K(1.642036411085846102996520375239561014969793917366144378541659444),
  K(0.0000392342757002132687106829965887133265430191546796994899109523273),
  K(1.777343601001188104282047100066256333462725747675381738563068532),
  K(0.000086442181793321634078927065157927549438623734199312954814409898),
  K(1.836471341126608799758462150973685189872495579891384677571806256),
  K(0.00011973985889572496243243525939271968568541434399835575256317041),
  K(1.966028713822068914567293348839625780582146587940253682984826462),
  K(0.000235612707446876223330966454441313767405702035545755295897048996),
  K(2.07694254662448855998772527490025462837957840330855704876801279),
  K(0.000405244661754433267520217401487540725308249374368206837765653381),
  K(2.12226849019074235286834363475188072233130923262656550798836928),
  K(0.000501180249717830772089974450677690116899026943552918938821075267),
  K(2.167770786536623370700729609255957448556038714294197683676176805),
  K(0.00061720022715953510247213466868889772418315629779629887327689742),
  K(2.369247185595288291557623359934993092615629782575843665991576528),
  K(0.00146560410395998244999169300645698871431716820390397933755137811),
  K(2.382822841487121629269533749327952851346083555632806331090676337),
  K(0.00154862939694264602626808383519738063911770964127283497268447217),
  K(2.540626577648673117366602445013515119887255950430137599045635517),
  K(0.00285945381299391701228352700595976897812821524520226461733264686),
  K(2.553561740231371123401983575472761509489761351865054718813289465),
  K(0.00300040890720417812911873373602886083295319322109840407749275746),
  K(2.61029675407113704639934953497507969690485108048011306572574203),
  K(0.0036917562366804272448598951393587202198322026272661008010765697),
  K(2.630408158490647379425084492393793605330703363847376188415381479),
  K(0.00396767917841114268692884402416658204619215755555453824155718209),
  K(2.67873417036876986411655152007636064025002363912417452469181158),
  K(0.00470392404600838279938407975246900405888338694547863603076742597),
  K(2.687923142562063129678569601189689488560461660026597905418323584),
  K(0.00485637308922172993096146444492678700979038064305593643904342291),
  K(2.742275913676514858524604656214523839531701668328519766778468715),
  K(0.0058469839776879063762335720885572554141050166030187266118852122),
  K(2.820119138524728829612131899699844569934283000868291208098531852),
  K(0.0075607469271441750496301932933938162403799059377253969242809462),
  K(2.826677127770440330696638148684880423191745860943306200401861173),
  K(0.0077226711068161533212330653176561248259428269702269280412050472),
  K(2.847991374672363549394298912533390316996919718928546245488994842),
  K(0.0082692202093483392179728980242688699759088190561910427695921007),
  K(2.972985309642764856925614288286643384374601384962666146696891113),
  K(0.0121671457546073219953159936021562214253470753998610228998354925),
  K(3.148425603953155406206794261313061641935509988921498100634487727),
  K(0.020083333644709969809058319588987536493721960704479396582495895),
  K(3.175409217091938388953518822737491320733080161928343102710428058),
  K(0.0216044296795779614744526950253279707772072097154938689544267995),
  K(3.2101891040492902348196501427776386265661448184523006439762921),
  K(0.0236992349591353870275855715746691492877778809244385869529493698),
  K(3.294893815753304790569736661660624779238469841760157145025662384),
  K(0.0294769340554174991395189645783776097335176524723484834951424351),
  K(3.463821686098907464142628755616145220015824543037073201574554874),
  K(0.0442132105503071238259313718201126595918643192400256796196238339),
  K(3.575951952328030527360501527202355578684863660392428217207085656),
  K(0.056659557083963966423238730498163597978196911253095949958977856),
  K(3.845594949169826372703979656459438089414450554119618066648087574),
  K(0.096342081080610272221653597462701260543018352145788420062665366),
  K(3.900763736040209871941728683776076535908744125632743473653198721),
  K(0.106216000002840175362324760374962086091818374246748871801932871),
  K(3.919441258615954493622177164437741796503945008332413374439418693),
  K(0.109692168471893007969049634509067648884803697872415656853749508),
  K(3.946421210164512677671956154051702437078176469780590877499903674),
  K(0.11483087225623850798740295410234791020199698059074432105252129),
  K(4.095475145087009975837228116819563508132005360412022625552541334),
  K(0.145607204244878370890908575276690426358045782628890321659599812),
  K(4.165607588458568043350560316213227862140582528331459814736843463),
  K(0.161370417701169067854524793362891001741961642009065553773319439),
  K(4.251198084476761889151488951724507705572104613936607984282947667),
  K(0.18155007853803680285623459872249847664103231644521345390851153),
  K(4.265214897570517201778268963294157754948673559412445903573821703),
  K(0.184941037050797961773767291438151817663527556684746766448843802),
  K(4.267315451649196529872308868197175369105615572404135224088986239),
  K(0.185451094571026560665285566973752444537462810934168653768649201),
  K(4.303756128547509944923316211059752395739158441484485900509179269),
  K(0.194373397890880387778696819855336758970595910584529540839766966),
  K(4.316407139186990875704855865118897992967747264623721116080961661),
  K(0.197501484144604948857610219548901423370598156909588108177986203),
  K(4.387449940596222389886524026425401598954172623950440731402161719),
  K(0.215310988025269913398543592972424536703950481206665178457160762),
  K(4.453859792228014363353106268989015782140464400016412655411662718),
  K(0.232231258957680113800323442275624172121443224975918119093722856),
  K(4.458591805156791729334031446872129641019789815043257704348476149),
  K(0.233443190627716771567544007233955014022802169461682673266524959),
  K(4.504186536167730384888216357692108458638035366202529483010182314),
  K(0.245141131393213230589802115189983338299183465077412409240003569),
  K(4.544927040772741644073823293738711090397274094827951611993825763),
  K(0.255597279253411717252891965357488224315224961142545475278807895),
  K(4.644810507767218365562399611724627790295344007363344807581150253),
  K(0.281010067861982444207788064049869776361424541426986712059254304),
  K(4.69039034868740603065133207226736048261700369517471233101974126),
  K(0.292385217181106286856103134127088726309948367746947114395890506),
  K(4.774411599952880479289704469125982993863793274404894366414173213),
  K(0.312747394578326127145937938263243503212996757988596407825386706),
  K(4.826050054740361842593550788330725325418262024674332961665645068),
  K(0.324746352809450834792398895701992170695401511661947596834388275),
  K(4.894088232346843042529952998535553164086938268761705793593621713),
  K(0.339794214513593902259205104812974508813125939195874521272216391),
  K(4.907987967377664532302824343473537872443533817577119227223399547),
  K(0.342747138524954675233933642233389166912337767861076674825381041),
  K(4.929410059265302800821456388257165851812535471789027599998855696),
  K(0.347210179220402567919310264372092246703752502110394355244543734),
  K(4.963032915688571148298634482050476790249080199769107151897575159),
  K(0.35398812336326639245463785457308966440268189737791325707824656),
  K(5.024095581625525444281739725190636735689618592258897127801152977),
  K(0.36552803689774285000615087133063209579090097746019476435409739),
  K(5.085746704463378598338096196985090623237922525946281973694039441),
  K(0.3760705810679792519811985636665065040897145478905014491991314),
  K(5.108440064443610318341526782026167685806827442305068538932649111),
  K(0.37964819128722390519630365462447733480598350976604133793248376),
  K(5.115316911250938743042576832552796599514626011634289546651010773),
  K(0.38069871599534075640840509184119411607419998351569836292674916),
  K(5.199358487586263705330641414569275341088571458507764614597029597),
  K(0.39221315575657893291199062281432157930531010827118552725414328),
  K(5.226327078039388702152090773470902999898177713822022455033768276),
  K(0.39536642202286530998133140382171588460685701982909474691318229),
  K(5.290866193391072376058857980527818121507898010380880106162056114),
  K(0.4017844349401113219957020220592448968946129998472968592847424),
  K(5.304459736337814257340302889083238834437550841515131939714604858),
  K(0.40292785098695481699636710063170165343278975542295956356412314),
  K(5.33488274448322743655766817197595651994147058482858786953257321),
  K(0.40521790355302726517397289562008643026013488049450429540055289),
  K(5.406036465284717666153285336048620662714477680395702100191008158),
  K(0.40909370867220208175541430923896196657838351488136171387801936),
  K(5.410167212373896639645602788558403338552065515770655154154030599),
  K(0.40925409527062172885370711785442392293400013607080696101072011),
  K(5.422147320903651890097841723204839182927610122063731137845947873),
  K(0.40967877161640278890293981620454935815931588818234307863993816),
  K(5.47941923102406225877756306879328638162098533986726017967633934),
  K(0.41087279517865070295398882260185896195278682778279686016785921),
  K(5.496737184085643733217107097930171280152329372981814349118481718),
  K(0.41096038435986108691959160437734756496166145059843068871300359),
};
static const R b11[] =
{
  K(0.01013525073413832111380536834417704860116083474565586938918748163),
  K(2.9041814693855154540559293029496920160918383181265922766576903e-30),
  K(0.1710888669097320798813828951567902116338247629466673260101779857),
  K(9.2105069084934722119800494508644730320767777049126677364689272e-17),
  K(0.1870371158455558245051402136000016036406723970209421376490852538),
  K(2.45499181448626667459253618230615278124171372316778304847743041e-16),
  K(0.215793385976229512542011432256814089537942723370890018272077832),
  K(1.18376012485125654426159352046967389894302144204315121837759949e-15),
  K(0.2389244455287165432370135425762494940706977701595785116242154517),
  K(3.62836306129854529447160650624881699540549331129292430651925152e-15),
  K(0.3137790836571213969958057631436235493217243255108027232469186775),
  K(7.27290937740017465086005131024346945858478490692174252097171875e-14),
  K(0.3377147764786405111621947530124123129531946543148641570882134157),
  K(1.63265708895377664534953874402028053870431374542877294794901332e-13),
  K(0.4261130710216707504863839730137432699490280088219894960320471518),
  K(2.10677279811575330877524763458374032163124466923506536128243375e-12),
  K(0.4317194041887351070239255386837256948986714501367750682064590499),
  K(2.43254868632177775880037974644759465398096439868556607687782666e-12),
  K(0.4451390469709138162882644256644181918884141343028853785934365394),
  K(3.40640977358903763055804591687723876118403869731666505497534686e-12),
  K(0.4513235396571493763739875673579339468171843805099616067830548863),
  K(3.96471636469959762547868248813634821578933075566181239401809982e-12),
  K(0.5178114694553986146162446977396952250284597639775549681193037315),
  K(1.79776369349329638309729385074721430214208209853370353043190395e-11),
  K(0.5385338120189720463973844319154793052485762819407289581909521214),
  K(2.76813340224139927030294498387102460997880811861263517607708604e-11),
  K(0.5765251810400698218939915251418311300675668334823183502119307123),
  K(5.85929509505417268179173890204729701589836518556487528653491177e-11),
  K(0.6053217576359548137324798954932728917564013110370810838388732109),
  K(1.00159791265123419841772084470898504705539281765626039735811561e-10),
  K(0.676459158752930214533313697034259416684165354947968005708851364),
  K(3.40017817145233506214154030573385084880994374041700188433842332e-10),
  K(0.9387898032575916632592551869073829597915859236616758120848320961),
  K(1.25053624618286096969648322349795370611269260906521649182167664e-8),
  K(0.9645869077439359400538485110239138048564097888466674510948806434),
  K(1.68499755406077643434832096993819025849553885894705570212563859e-8),
  K(0.9827170484743728975477320523606384703303508254193037012953555669),
  K(2.06803400788473689822380186839620147691831611695029297548458113e-8),
  K(0.9942518610599523498944754707948456799592745730592138629547742085),
  K(2.35128254773415997350563275195828842213114660632486498311407059e-8),
  K(1.05273596704900753664535003751420241898411192359470143468205438),
  K(4.40918532096336878488010632844122137407933205175964875112948279e-8),
  K(1.341732846343803883750092303244192480949863581320365475789987301),
  K(6.35578687144767188498980336565700369531916302209439927467108891e-7),
  K(1.346849232559545413292388304891844647569334491953441848666351819),
  K(6.62752500187783326039021480508735815926403689806615563246034715e-7),
  K(1.370934793758688205603825444764049831393569330504941058422736748),
  K(8.0542685011613742210039157820848380038656779620652359097905557e-7),
  K(1.448707649602827534540141543281384887703870673319175351635348182),
  K(1.47781289972872334568361533905253379402006075869645545851501929e-6),
  K(1.515007864346763795915616339122327593574911440648147093807720386),
  K(2.41752812358595828713452015057386451670076028644020698997333373e-6),
  K(1.647237513288324849165517548068765775159962370821608721072516586),
  K(6.06712709840809117201081418386184654249733480716454305057610371e-6),
  K(1.799772821583298987549093987817477542906865549105656798475303295),
  K(0.000016052510231320011217791460964642802630266852369229560298605109),
  K(1.847764375424110343595251198322572360662979709707079501642555172),
  K(0.0000214272957093787067647657963786210832437742700196017935103394579),
  K(1.862022287239380424326166770712789232763945079259114778950302256),
  K(0.0000233123205732148788812329654024073869686356660137108395925355465),
  K(1.914615466389038260534158585157105719657523318748541095026903372),
  K(0.0000316372062423178173352267209101640650603279003178066376677241608),
  K(2.081227101153996367857613481803202453996036755713667802713923932),
  K(0.000078788656516779090405619117698698995311625663677548100929511595),
  K(2.164026609361783791013447678301017592714326674327827025727715168),
  K(0.000120506680586052976793798087268927735032021340539464631724770311),
  K(2.194016049191729786305575701489258448373844191201358332538431108),
  K(0.000139949202865745293968951507022877521994996952950640909996124797),
  K(2.202995429322007670004663049012697427573467594736701344832178044),
  K(0.000146295681544799390809604250431073488663102638835583475698698908),
  K(2.226029965945237631228587694696348937230393956444583354619328233),
  K(0.000163775594239747359290468340797075736085564657367156914584378002),
  K(2.339683774372041698920314131890471546411744533519617684872420965),
  K(0.000280619974353260930696880898841644961216310449386716455607809667),
  K(2.529848010911905490039220820191166616699382205489448899165042803),
  K(0.00064829094309928437215840620669583555265110956500017866978227247),
  K(2.57531580611655980098951773639488851893365779608562895047105905),
  K(0.00078333450672941348231206558579915550694131743623927380120179782),
  K(2.594570993905000335260122556453915075352820520608959318433747062),
  K(0.00084765763053390460001193701676619310719038334900986847845216123),
  K(2.648908553502015918535157831952017794994694903464989004704211316),
  K(0.00105506783492522104014117247043884456941309353624489267305761991),
  K(2.765390860455011694578599167302616174306893261370947963366582204),
  K(0.0016560659593634791957453536937341274286562057971542106538928067),
  K(2.82808304295783832878308241878525646412802951179403346473454194),
  K(0.00208990287015118578778234988588372449613134902455812932945066332),
  K(2.831047186989603894879646598433729642075906826487318076834782744),
  K(0.00211266627434220815496788983311656710319160071903979783026713197),
  K(3.142876880266330403950697562131345894110651809341653470550783122),
  K(0.0060956154211440154066954607181802954656885203322990986918263128),
  K(3.19574663478216618063942479741056490600863182960455862401197024),
  K(0.0071870829991034060835492754906058567655057870458613562789860457),
  K(3.208596077327790768623994502493091085198057282963384303363559434),
  K(0.0074759810553249871981764700249152068896618009016304345077146536),
  K(3.240577580723759986663310907520613273912520038034031389951362852),
  K(0.0082378564472182751801187355134257109748261572216765637248179881),
  K(3.285817369751482079820700565865937044710470765530112329160494365),
  K(0.009426254074001944959032887727435811213121025608219275172044078),
  K(3.309529950035609895211063018579584278714538987864415142384351322),
  K(0.0101043772090293495850018391357000798064857730094739860482546602),
  K(3.311420965679391597171902796168949411723147386736456498654283485),
  K(0.0101601638324796231364886238430522081509275185424700136581490133),
  K(3.342386101411978366017303111266643633964190806856489439627564914),
  K(0.011110807037631793132817959198694038330017344071555901567978341),
  K(3.354536154918169281269005211859289203552356643585559738777851977),
  K(0.0115034648860752612753389776339368413395542706215915041536490415),
  K(3.364030583715126470713491403858917906078369642057404191250266071),
  K(0.011818248080150475211168662230345129725129417778807047783377785),
  K(3.416216520271007243994488279624614924236320204323119091473513587),
  K(0.0136783514917957565415258604289954091060271993224144729148925265),
  K(3.497910726955762473693768396317779364890571237875330277630934306),
  K(0.0170682386218390482609592531989633005548378595322024982095544475),
  K(3.537555496922326286912073992647617738501890166879656977002612387),
  K(0.0189434862080694691809521039179584061380806121408383413356469365),
  K(3.58820022381420040784762716873442275736123304012888743629955617),
  K(0.0215770709417790100447577553348091252818037038578690487115600889),
  K(3.729778083318874451011475063550899760453626455601141650436695448),
  K(0.0305115157112662446815902275932871744561817897024513877862313713),
  K(3.749178266658275363560528273065529318945748266292454757190422273),
  K(0.0319323647039987809816902814915953062459972453510402552229232962),
  K(3.777126740405645840920134899503800400740315169798534677267468163),
  K(0.0340685454557375471255602729343407751933331101952087834992943866),
  K(3.901381050793648356188912906757358308519981183997951914378989529),
  K(0.044914127989553556476208532984578168992782437826188036177482484),
  K(3.965185535137129952651510280798007040329067339793959812048988741),
  K(0.051392686560326045834751632045856462382558802278704215566261099),
  K(4.08317571413332113626595962004725546978262844093688046719359673),
  K(0.065113901638297075058375887020450652417767086923586386864019024),
  K(4.103068803478635765157223164213890496673967222907194596240692854),
  K(0.067657392357105973309658378821798861461999589104559604083061215),
  K(4.105356915176122226575668156371175083726544760619244118271198948),
  K(0.067954278501846628767738962439762904552099221640212301921523808),
  K(4.212936075694668829866925188891483095114647927893004202921999323),
  K(0.082931610614058400550062039381052378731715900914418530179233004),
  K(4.298883349904163704511591588457555542077586351205495573501359683),
  K(0.096338104564572531262975932499467816056817416683670964628373),
  K(4.393347996660243258873365746273597582651533310896865492097981297),
  K(0.112529703062720121665241398747240286463873676951835777855066291),
  K(4.397277002555159096200812232619531408380442465564807218493521548),
  K(0.113235421078634806729962235499547229095674085133453163240253492),
  K(4.454360520171467852156230002202916009211025398892499382785759734),
  K(0.123770256013286557013440507839754035295996486800054346780351701),
  K(4.624189291508853518360768990512933345566363220960757619213013113),
  K(0.158002494530225221720531191565572655458417543824014099530069193),
  K(4.673215468490295874849949813374162467830787091125468638877165197),
  K(0.168591464436309549508366010301759013410211616650216941213017527),
  K(4.701583037036382811313509985271823385744676916159473205696980532),
  K(0.174840600474606299068958980205893870515456147034398783861620488),
  K(4.811298477483025857770336394541007337589814191018503504806131678),
  K(0.199708006040755854283113988966554331188155337430897024792699731),
  K(4.816295947952248951228776928045149454016897397958557704032327066),
  K(0.200862516161450673627108610903769993818537406607098601568554576),
  K(4.822304133180874881128847116104390510710940927703016895012258834),
  K(0.202252559528650255028685831153585514552957459690157449682760531),
  K(4.944775931000435826328913828847852784609507906893500861818375599),
  K(0.230935181045988605204894476903375008600567798394418899622842002),
  K(4.946250472955682825533498605015351369032601474679077860444213595),
  K(0.231282931429070036633736697273338750701839067997140808102860256),
  K(4.956013482734831266200240026902512123205137105509640319525872151),
  K(0.233585808908264350279774115938349241120328035772663017002185742),
  K(4.963728460603896396178591931456588130189673731659932551441041088),
  K(0.23540591173110563888194654373254730325463015542813588380579719),
  K(4.975553966135724292754269256346263577216811410304044209303190329),
  K(0.238195791184652049415740043009675556290160671357229687027103688),
  K(5.23753530341882767312167795904977062382969683836443084124057766),
  K(0.298428080897079871872779498762709798903696152552696603466319208),
  K(5.276635849222749013212396905860734967301384621973716951852194727),
  K(0.306859062977865697746979749766894068741594188332086409586838082),
  K(5.346018971907786326138057677231278205385170539570774643212081773),
  K(0.32123070941108122049182027518763999817895774098806232509133822),
  K(5.389579843673514944474808727710336392284837147996830117535968822),
  K(0.32980718730729772552370663824702181276704606399738327634658095),
  K(5.410515063439161196013149005419951020841017114592728303781236263),
  K(0.33379189402613350012136702982015115837558935916077407360304227),
  K(5.423125756862692459878616527992802508424872249281821811371301009),
  K(0.33614661476843330495650342680126210080660527693353559886181254),
  K(5.488204855808120313346084620080161477893142909666257637623134188),
  K(0.34771591999323622236354724585447724122438214348317271699576531),
  K(5.492470661450293403092050017756748594223510097403522121537294484),
  K(0.34843836414835026530640146419336622617884403697687889447984071),
  K(5.516315351753076848128303285633706249605233555519589484900861614),
  K(0.3523907246326796862983671000447405360480317616710117861937372),
  K(5.649573656839785962429441444931620686311025936050632126453245946),
  K(0.37156683098915620116568938324728498591950353691073369407508598),
  K(5.699693537333756532118546932879779870077150501118769758341136386),
  K(0.37738248309422405524825003078514218457324896701184387116283104),
  K(5.76698225763172876231809871502860055402573837664118979497819909),
  K(0.38388331556991341549335183963282887820487341263307947036427371),
  K(5.820450025202809094591570005158983176757457029999691794818049574),
  K(0.38793290082232636577193037780906067507499434434750332982409419),
  K(5.830539991771267922409360144409975495133823417062267619726355305),
  K(0.3885831872360005988412742016216707635048072679613591851351826),
  K(5.836904592877076271331163829185673508229254135086669512722947346),
  K(0.38897454638614273240456651126233990012950921479359985734044491),
  K(5.919762871518640813464002119710548072099738842154236440332635384),
  K(0.39272171390959365834795362998024907683725664448158584199663588),
  K(5.937078054302929739709835137041047942184088328141746995448356688),
  K(0.3931848115420604853377752730641938549265076700063060143493797),
  K(5.95361589640258983673406986022833030743878021102293158015956702),
  K(0.39352285899027251533952411123918465966700119179913908959431398),
};
static const R b12[] =
{
  K(0.213322639174658684470164744364725789047251912651062630127344349),
  K(1.85398583740650010691585321985650642024854078125308248740683128e-17),
  K(0.2286820571470323018949285385171654171062561179183133383062113668),
  K(4.27019905247372229284920476795317175506469912197166876015889608e-17),
  K(0.3454775610144623690933417263779126642293442039881475044294247545),
  K(6.03533213417753844443928705933762877585757559013746731358097033e-15),
  K(0.3630685835325484347118322898998126603586375542914710856200793756),
  K(1.09528486455234937463851253221563210009719613672455133393593777e-14),
  K(0.475882882814837404326255802889453628465924967039794159392748295),
  K(2.81620354949653938393471223455421035164852584249620195564630157e-13),
  K(0.482284468849542530816227259743006621449711515579941591489003327),
  K(3.3059962233000455016824881680555085945084190315256371784661498e-13),
  K(0.4981379099896375851304269642450573119421628901407551701143985758),
  K(4.8736929808112465926610517652274904647144013406849772396081688e-13),
  K(0.5647571753096982681536589161279931488342260002234525602086727003),
  K(2.1978807466311586781344573342830822412633346076495690130435807e-12),
  K(0.5729472661588198623292569366043794344888454620434033894485927048),
  K(2.61239506140026759535598309492514626281575710982261420615354393e-12),
  K(0.5853955037135279087465625265277074071584970955398671431497004799),
  K(3.38108138502560459765127606411647110151071297841504489457253564e-12),
  K(0.6393496557921008513177831815256484571508252913647008208466536662),
  K(9.7392219750528314875000751155853230493988939558430798480599093e-12),
  K(0.649874830582859964334852631376617999605058840682849738750412643),
  K(1.18473070030118534668348086531607860034445079130079412970343051e-11),
  K(0.6572359963230713108281282924255958889084684350149591829772097457),
  K(1.35618561240028071479593880446336044873372726892659581908698854e-11),
  K(0.7186768699270722463496714614077870699367396491049181441678771769),
  K(3.96339217505017775289169162218868974439473665028545948161388644e-11),
  K(0.751965733492679566783868050567812893419517401962864833651705235),
  K(6.82400981475618348883505163806958630397137610030094193497983928e-11),
  K(0.8041649311190484372766383315244757982624381270398114137684155455),
  K(1.52687890826805203314764054293415164310326886700807438421070015e-10),
  K(0.8226940991774325555283396744704149677052774385359731990434481495),
  K(2.00689025295375476717925340468649030711314472560467073516581557e-10),
  K(0.8446423949124692939538868811553177978579951723651789177408663144),
  K(2.75256478035665249781882768023655443770494892757090365119472179e-10),
  K(0.9133067292035863389827105882804131836805502569211343762091753739),
  K(7.03174197447122335757350034236015711881670909572778869584495662e-10),
  K(0.9876335163052340660957354230314939300431152162281143199106391876),
  K(1.79809599004835695399685700145717163369679465971332203918977435e-9),
  K(1.035105532333215089351633589196120850411744554584618651216441185),
  K(3.15848335931073990418194644609449034438357422793355147087919386e-9),
  K(1.070101828622631516856609488792835536693767151108249410108039021),
  K(4.70721798366919721411381552715215811641008882372275800903026193e-9),
  K(1.081224964497754375576584501989415622443385876561244254310965967),
  K(5.32912382213567493215518719017102132990385379214401700457270344e-9),
  K(1.215461810456481014661176701289127755278537812046134473963157888),
  K(2.17049528103330199609644813812812296685880534246190903423934037e-8),
  K(1.264615384878703545005942259775769319348895512647591954358190715),
  K(3.49272608750662768700843514984627068344470939752726667520895429e-8),
  K(1.373092409421855843306886037585531770331707540246295118620385826),
  K(9.3769007136816330841989275029681069522827680777969165880530285e-8),
  K(1.462802287456618762666643953651963733384015058674227616094081024),
  K(2.00394098089023752829360588821170532704127786333781083140908783e-7),
  K(1.494583595048008378878982047194007445392031155416066687277179096),
  K(2.59355721040296897821063022128517218557748898200417847258440996e-7),
  K(1.549784335539053412878826554635240014003164533066872677843513234),
  K(4.00770559765885996435952162036773361202808053658551968971193988e-7),
  K(1.622060291749689389501198643956023909773965446884212661735532536),
  K(6.9248410581874250115354005708277990289491264590829978528476458e-7),
  K(1.677746488940007977352287908064246392927557947338995066115319078),
  K(1.03817955318146658584550301285315010689436158888922278759492221e-6),
  K(1.791446074259724843192559771125762103094902907976782156978975216),
  K(2.27926943812948883670696841296939698359396734751373103320916397e-6),
  K(1.803765024067086798714419370287277523240707127579308914587578016),
  K(2.4744370104502433747824674809245416461004009172438695765465792e-6),
  K(1.857647163397852920247658083709234958389962025962810551594549765),
  K(3.52121018561285718928447613430138073708496708073895931515022749e-6),
  K(1.924615092574569415666102650099945277799195165365663902365004002),
  K(5.38189823200982184839820936534151779247800350596880171420350846e-6),
  K(2.031492192344027304627451387297136659808683168049208840291998513),
  K(0.0000102750497921187351897384501327913444943364107443398733103339396),
  K(2.091114003757293959728076899956731514187433985976454461738711021),
  K(0.0000145174364688042836204938397378715801603330897964205064096746968),
  K(2.109031062919512776592024293748065905876432678227839813753442874),
  K(0.0000160741338653468016282826113198109037233759281028520165735642474),
  K(2.310811825340042586019439145167994927362703472461455617768854995),
  K(0.0000477008029719895824515556609155780569093787757811473891892446448),
  K(2.317628512351214742924792593269170893436767592075233260727684605),
  K(0.0000493973038677395253552890043520901726676343237473419808498443385),
  K(2.31933684187633298934206611591280443949551774961886484115645083),
  K(0.0000498309646508834569403858727289791467468180047937607122452844737),
  K(2.323126313869899195359882085258439296314283772843666565233678904),
  K(0.0000508052949000671452311933936049103041301980207357700265037864585),
  K(2.468560761690264469431456726866218087474402812934895500073315508),
  K(0.000104171849505896953474822282244380357037955968626617755609095036),
  K(2.488815646523638955386729419055504927868176216806437307218448933),
  K(0.0001146980294016658752622187487784431737914587319427048734547219),
  K(2.521963789292129556210205367654960324312523545755262013162728151),
  K(0.000134014441107736612775029988399167922971281134063888818272273415),
  K(2.532032280286462668737234936729031766553817032302866008985956757),
  K(0.000140437793137083778907902116852137184119614295782690399175589764),
  K(2.583737727756698589761177447603251835160975534785904911477970282),
  K(0.000178017854579165730206902856951760281238769792310113686940114944),
  K(2.590810144272480145489478398950201491389752843952251165460569328),
  K(0.000183808330779281242292309163503721739345898199977898353263535009),
  K(2.929418287494774051909915099282403338860960660687845651882133592),
  K(0.00076159413659255286814124147381763165315635716198519519971036523),
  K(2.978672196919101983676397075789427201327530643334241527420931497),
  K(0.00092082145868570923626795516958161333931247251804735326380716889),
  K(3.039361909906739171387571705664859963519193580950655155353630646),
  K(0.00115713822732844295180096004357083550666732408449326148817874761),
  K(3.101565642694834519105980276581189960708524718191351662845930831),
  K(0.00145346895716882268828485219522124855721668755384834395634789198),
  K(3.11273014596671426940284570267411236383510134904009878507558909),
  K(0.00151320668170665261187724005025646346212971946264260964016169564),
  K(3.119890899253903514201075095385103493368979541137458519396545616),
  K(0.00155264917787054812716473924641228444162101880318120381072710491),
  K(3.159357589996923428217445656668238499096547570383119784998517176),
  K(0.00178668590224281118167841890858501413927578863928827502302834423),
  K(3.188645901889286928038487370307937605186042552972699619952775035),
  K(0.00197983811086697799157157605230059245580855196368899182302374254),
  K(3.251778719978125837363737352756137851183373393702706421018561727),
  K(0.00245938183879663823203955448994042112839387753323124951731748056),
  K(3.298447528842656468166307015515363739324330158828481002030685748),
  K(0.00287618726333062665197477914597928829446603185370120732146686659),
  K(3.319384318966452345166605623847229534385156140982884993719154865),
  K(0.00308229460972869886480410035707911462259249714878304184169614875),
  K(3.34702870238147282827030170012241758917407692915653976130502919),
  K(0.00337398262576198918214575214799979587248439941662004674972634892),
  K(3.367332040776146256205672434419529624045265240025004213066761812),
  K(0.00360315836227299996348028040320149432257321218681738376885098583),
  K(3.463447286030253816334966897372800577791168270191976719795597205),
  K(0.0048797832377853040445240055910814921547288470250015966390294291),
  K(3.492559667844890354131701087302112261478536306533428262153930529),
  K(0.0053359246440663940450554393776700525361800649016202101607585186),
  K(3.619560092844791797057986041153690455680653923674483260738350683),
  K(0.0077761802522820504080129725219159419583921463487698540149341951),
  K(3.711319071574803295946721916200097934523794079256964579505601177),
  K(0.0100756324051636679345393616955738904644520045990020489980276253),
  K(3.876001312278932119692691258707310376361311051253171085409823954),
  K(0.0156214394765926414448915732244132341976657828961892552256850633),
  K(4.273122492663918816533358301715202392602149926479618518139765341),
  K(0.03942949070742825089538969715894951504785461928568378630009698),
  K(4.374744525941662807832040606682813324174409932981586049805540393),
  K(0.048574526285753546812166216056217794458748136491622922727117895),
  K(4.389140747666039234825454436836679627351660851656882207447124597),
  K(0.04998628703851349296362291901986539006560164332600252398665611),
  K(4.43149179486078781676133156284051731276549800803263729104413855),
  K(0.054312221187133453697817155965179574770795418559951127817234725),
  K(4.459464388257497182634153143742865669099899039361237986368616476),
  K(0.057313022872119552421117127822375459876438083446294887575015604),
  K(4.619280843805536011058921151521705425665910891200262900175337251),
  K(0.076715149535319574788400877874735781616115047181678885438639504),
  K(4.711492951625743909762581812968517695203841034454910533742812978),
  K(0.08969243287061747199677318329999319971466972788936772583533256),
  K(4.755118284651899109629614484870275009847671625011668494912299629),
  K(0.096286630378063692240248533370261943048591991153553239391755012),
  K(4.800813057432436614210127299212460945666346230607364980725386905),
  K(0.103502319653294432029373005644125804556402021483776102101819121),
  K(4.879322235311920548146621962276030416041112620377406805971809427),
  K(0.116618913893479088579823149848399432944313706935034891755868049),
  K(4.978191073378217272728055825064317664671358557152081431608689385),
  K(0.134364504148025817577018141126485649958216987943272815535652342),
  K(4.998451178159982669645442248011073083655946700566600477452630061),
  K(0.138159261749123400439904225221042895110588897242152134027021494),
  K(5.063452138859173987986397525418026074807369497712975953775187343),
  K(0.150668987109010495381677414309031097230261235349149642697565167),
  K(5.106623674165047760382861739738761527752527857109103986919183638),
  K(0.159239792368892269583676468562813894688038940570893903655323178),
  K(5.107084748453505370086929566895163270642783325622133777917451999),
  K(0.159332379620040265419576453160004572298903878587279211076812104),
  K(5.204550130796286491113050210075399597757580255744982513675871414),
  K(0.1793475921477123774872122079726296424198547059213639895228335),
  K(5.207403646927992149488130449082119018265895232205202716886330533),
  K(0.179945611196241229300024361106796509771841214462177161888554378),
  K(5.501843993556705743460116165611265184703668437445702212717688334),
  K(0.243531274691731718679388464522275448837515723079832604630101592),
  K(5.526984563366304436880348011685914641670821374246372941868931312),
  K(0.248978413087053618668584258465759917175243790258377477638652284),
  K(5.542715586342257970579207702764893721367755367032064024906081219),
  K(0.252374289388670536945195462635307200521843525104517942228282658),
  K(5.662108028523409364910645609767050450477446483484043041613105346),
  K(0.277653209877009644620525645182539234144916803840656503473712832),
  K(5.683208636491872238187039359985001928754321465479006657346618436),
  K(0.281997155287215159630034698600711663042180889482340839041419205),
  K(5.696923656508928893091414005038030023525987934698999557995364),
  K(0.284795454168144842064954521154342799315135966456805931621528954),
  K(5.78861604422468495086854276519542665395560368707636265929864224),
  K(0.3029060399153473950119000299780917116715387405717577656292464),
  K(5.928681241594255853670900311079147826984708392786839890594828808),
  K(0.32800046231939524698706359792191654768603757546065228847161443),
  K(5.935914660255678016992986656379756124254552259579209540441546),
  K(0.32919451094072491454580375821251076725463201221574685601445959),
  K(6.188101536348892909879944141499980668255846029195607521054523851),
  K(0.36294115551201817280334474029575638366463905801811043771178923),
  K(6.212723370873732760989131136909663484688926697213780232302519558),
  K(0.36531052491144061950108649568090290822846840593220642479044846),
  K(6.232691949842441758504746426879313196689212764465058058088324503),
  K(0.36709895396863549195440168969190494392750386361611477708389166),
  K(6.234398775219373790890717038872903687520079230911281902873699079),
  K(0.36724622298633682512247163351152919028711940764184955954118977),
  K(6.355678098063634285751399514915665309222286617831966959968281804),
  K(0.37538325033165150787710204296977118070126074307226918691517816),
  K(6.46436473562389665570078207904371577111325731592923444339187182),
  K(0.37863220483366259676765807338492568531625039231784749538129069),
  K(6.487537567572441675727266982402514461082383272851556309450212739),
  K(0.3788181643404295768901300524168371883991257324454905965716347),
  K(6.49085345956880238787267202696214534107661995935770370772675659),
  K(0.37883012236735928033308533947080149192757774339572202420367902),
};
static const R b13[] =
{
  K(0.03500675406427657693212016862095068528344380436031145034876052671),
  K(1.90411708123484052059864470497951343155384076176352871978252046e-29),
  K(0.08942512842893320777467759527089750080817845790972757200349160836),
  K(3.75572795383257805672988424678157991781857172329136359037712863e-24),
  K(0.1271961630557841557846217098070225130476764769485083717115500895),
  K(3.6633787646959559166687596230638307398945420331153348941904202e-22),
  K(0.1814598184112747244730437648470080159832534872684091160473276707),
  K(3.7142045596425111446351475894904023258057625161340104430657172e-20),
  K(0.2374741015741288259163431574528954015836441828682170240518105812),
  K(1.22667913004962868100782242411172504272060665898951601978071907e-18),
  K(0.4836773367864439194867350337710857964353483038291048146265586535),
  K(1.27333971448339377883486957592247958504469675923651441300798459e-14),
  K(0.5839424985591752424065987265808246878284773012002270657075402095),
  K(1.4741129881774310868301967747791413200379746906796341398743427e-13),
  K(0.5927987071047963261115040046173196742883445662750153185056024301),
  K(1.79272594866199587753466088062180258581014649410293899901983672e-13),
  K(0.6713599525763494512511826968610825851452823097951569104563718842),
  K(9.0394143292448763113727047008487242079074970925723557880339017e-13),
  K(0.6977406963072609331657875788291261248006535393361430625872218726),
  K(1.49190919141400245878761109441455494078177137296700884852915697e-12),
  K(0.7120069964260264104748102549902338237552678970683646807942407129),
  K(1.94095326771147382610693643603088512724607427688609302718054266e-12),
  K(0.8001536333806011374730749056120327115371442513426070972016891711),
  K(8.8506189857413373120361474591261844783827200106435466294920407e-12),
  K(0.9120440203889596502833518626267966904386990771721268064011769225),
  K(4.85204799330611242278074810720611029684446426402093283779047216e-11),
  K(0.9589868144564260623698113575275911131682454411590668741584154683),
  K(9.3171685125786768584995428214428800758315462197703634448583619e-11),
  K(0.9836461297509232540917765431439269893507570738461311707939833628),
  K(1.29606034041097843930706052880638234950243755107309436828054143e-10),
  K(1.007506844326021366236083638623148331990995586564480472035177055),
  K(1.76987970907962005655215711002088302831938851576012122065432575e-10),
  K(1.030510570400747050681313824442956041466252356900762240270780353),
  K(2.37356727246017791507958812212778621096041079679710707765331121e-10),
  K(1.068411843086093816681302440441776507461780032537528950607730279),
  K(3.79596935885735494901734541522200997264038537028965304921966161e-10),
  K(1.101733897196742024771906541666662509930023827559959910756161797),
  K(5.65870344962304684546840049876651715543274957136778393748234989e-10),
  K(1.237887297553914166724817582010957526413992251698298665016076725),
  K(2.57379566505476845993413884633903119050985828346283088617920173e-9),
  K(1.472802661587985768964069228647322367691178223440052226985792826),
  K(2.46374995763886623147137799680116025759864692942680843506328923e-8),
  K(1.744601591707074921480188254227339477740372718167832363413595585),
  K(2.22677479127854678830265924020136773369172472758486508870209865e-7),
  K(1.745594107710033488599749654105308600316381562153867124629788632),
  K(2.24329499880178263582615328598662496963181169726783739961542826e-7),
  K(1.769163428158906048868400618239190870626960616793475092702065776),
  K(2.67043804396051906629694621008599815092755084542372976595525632e-7),
  K(1.841853901978616788371559460535780115269483225193633183285267275),
  K(4.50615275778054477943403492202102722492811594591077712154405782e-7),
  K(1.941797559140528124589246948420932938997513940083241597008160542),
  K(8.950989690285369121183436854280375810471378310811247553755753e-7),
  K(2.029556773513017692748441461158384175973629121114526215386770271),
  K(1.58868846368187673857566323420858386652708434245926369104496396e-6),
  K(2.055585290524304277674290158101428975323812351070759649036113712),
  K(1.8742606610945642548181652810768993107130957671433779817240022e-6),
  K(2.121801873716769510899364342504921071311231297322095009005072012),
  K(2.82713356603808673847184658948895816294824811172267108735419648e-6),
  K(2.128464418590607968242030267640876062705121028098223855992076481),
  K(2.94435326024225675162486768519809406154497483656292985250447671e-6),
  K(2.170931603194649848366790289392538745944259399767594038351237017),
  K(3.80300523949507986425501334872520454042250263457887067643463183e-6),
  K(2.176452988811393439160317467092502851641417207328006666285931002),
  K(3.93016589106678567471707947648187506951249210703535197069330595e-6),
  K(2.269784347703652132754339151822125209672329382634967552860014077),
  K(6.7656832024916233385488653174903888520666433039910134069994406e-6),
  K(2.29770966759896720293389805742833123551465775158868570908730977),
  K(7.9236304912905898830054011130325573530860076870241577349470656e-6),
  K(2.366624760161156499313123223417498342350744881808473897639797715),
  K(0.0000116024039798560872448520320108299400148012810049172429708208845),
  K(2.390349844150021864730576144481227973282144287894094567965221464),
  K(0.0000131941999808326241350358128764299988137713124121597051628221929),
  K(2.467820439049224878641188561674023108971698173822623200288626259),
  K(0.0000198906262608860974609363413000555431927419841419653982582600019),
  K(2.479743400254625610021448377841614293998178585716086286036073921),
  K(0.0000211615160490141642348145017424551320004139721759310316871464713),
  K(2.512704402802728819558592396981691876679446672633739868496140052),
  K(0.0000250715690501988922423483362146746072641979015821838552010531001),
  K(2.5289887026766415294556072800479431631045116315231113592574725),
  K(0.0000272378267941588490943565710083821119215595615398300993913791769),
  K(2.539953025607159167933733336746811992815094086531822841963802474),
  K(0.0000287913914177365524072674883387261672408326593259096948067272358),
  K(2.816356513602859247644938049380503413406675226505074396347888685),
  K(0.000107366516062738467331146049792436730932431911957162748631230217),
  K(2.838928451477557505801216789570047452182624986987390183285488293),
  K(0.000118766093096483772958982970271310654837653100693164592113253557),
  K(2.872830818829551231330414485808270037004474099570221339325709319),
  K(0.000137959854137327189583671560208013206548114135059564396886673868),
  K(2.875603024613993639051825428950932502066715582623460642577567268),
  K(0.000139647350921243751530215607889185580157686383861843955877859822),
  K(3.100696231335479490246041275473286019584053864282366027007800099),
  K(0.000358440245662382075460657930017363609592247858673053383031458125),
  K(3.107543874657214147734517876688976963324827195106026996708411938),
  K(0.00036837856952186492888691666796154920176169747187200432369177588),
  K(3.256896990590595169237343025664989306807447768140506138212899839),
  K(0.00065669889556818849411509236125843449732290809996677477339583577),
  K(3.263900791056432203394371929185120863123919807694503988341936519),
  K(0.00067417679042488877969327197692621910183308893132156482879616927),
  K(3.320893918447249779930842306452882741309324905631307665484155753),
  K(0.00083256407155019198178168305904215384698747684978983932724862981),
  K(3.340580002993246700438044614743931767765455217706980322341443407),
  K(0.00089451552025725469911872437193578645094751207997408676411138463),
  K(3.359115628191751061888556347611963052462977369244347446323023005),
  K(0.00095655931262692917361168523227687259524801245262862681576883497),
  K(3.465393012724128634012170308691297777213438201161866394098650798),
  K(0.00139178471370573157872325060499546790769878935384086777496564644),
  K(3.46812647213081841412762671814560105964364235922671293641534807),
  K(0.00140497822188944651128479758546591691862970735311630409184331495),
  K(3.468931692731432448138364440281347168518486023286553333432950767),
  K(0.00140888575942140857331937287807683024429397160778534014218232862),
  K(3.472797338700413649013456745276141894305564013069152378850951696),
  K(0.00142777872968029813130816010649790780055422072774037937641450198),
  K(3.615422657536832421708730897409178405135050765018918580583057545),
  K(0.00230097281518946987650089580708126242451551793780313281889671716),
  K(3.658626012246637976484101536549520833041696631296048861124411042),
  K(0.00264461402016897214032507804373495190089967489246253921920218393),
  K(3.775109504773181143950826536616558318238777178279570425769036726),
  K(0.00380305418420003246980914807439444520779684787907161227666146955),
  K(3.810506045662715333536922261955840101584148411917928854148969865),
  K(0.0042325185294358142645894449683598950141707197405119125075816723),
  K(3.838545847132428617763903175728457304843800889788451727013714174),
  K(0.0046018066464934205824868558724674593271221745232457551115670208),
  K(3.993363359019782767944889231773593938447931032724660881880458472),
  K(0.0071787554380607716410709938398002935167786214742739172712363836),
  K(4.130547068075411635287722165395260034028728142913114139583618231),
  K(0.0103973192728687871140612486288353525924857256355096875917587065),
  K(4.139469154876559746535306106345855432325269565268768747316773057),
  K(0.0106428872776633307128770099381855174241845644087984689078192408),
  K(4.243500313791349531869180997262119931874829055285715614617603257),
  K(0.0138804836102776549937363314937650532147174716544737956170159714),
  K(4.429127590120894719650280226620942455046689478078799308155476961),
  K(0.0216482683750410933005023954620503881032732540491774836864072588),
  K(4.458927439120123876567665381866290781451313474946041849580289984),
  K(0.0231696202656285232265325364483689131483361018522391130927777703),
  K(4.473852927521309922497900098936277610185554310168163099862644787),
  K(0.0239629180321457356412979398569917194382545722592561522443495382),
  K(4.551850987140960213900767448746086309281551910073009524697652494),
  K(0.0284645990151215078600862805391700881249212739743086577757258262),
  K(4.655703816623965701073093725089757528666883633742589423720551266),
  K(0.035451634738293574748431133610565026268006336961692256293637709),
  K(4.657393865768037645705025404685482251123483587405478639741252825),
  K(0.035575276882392403003421973419782103402153547703609393222126649),
  K(4.694250436043980053685433952983754574445740515861287203690768309),
  K(0.038354110341096975596452260946387320896942017984849261483398402),
  K(4.710506390705670895640920237231151142197088160102320260459454763),
  K(0.039630581728444260404147496622578810297913702594634306850815355),
  K(4.747740594100250718501806980549066826238773417560981448951366517),
  K(0.042674310210530600106711342266444740984967558753587322488811787),
  K(5.025375446530831061039761994645136835677954850561570478954112769),
  K(0.070992825880585030982955015850185507193396909741120229307478464),
  K(5.137677416610086188577659427446956995241223818934816906442582663),
  K(0.085416087026578919763323408101005730959268502991983140380701435),
  K(5.169187760358133464916670342800309605563186943531462605611851992),
  K(0.089775443458768903363925859501709473351438353049485190736561833),
  K(5.218981010053925978444026499946398344716343196680023765647747149),
  K(0.09694021889242025603064582993677724784070611931024884006908548),
  K(5.268797848906844336716394487861541400101432417811412631391903429),
  K(0.10444165653484520161055171684698972079478505360277362363099335),
  K(5.31234054582234037329551243222864901755660445961215777631871164),
  K(0.111265065471147856284493479274862994740921879483673167421157703),
  K(5.432427528632922249014172431214778165978949396008719045432803899),
  K(0.131307737862743146440235665258515450934219212189766615648249409),
  K(5.774261101542943539802906554750082851035325325026214394269293761),
  K(0.196131144849628153432653390143514685140165907641031741524674138),
  K(5.891700274026588812339697315891838960230213129421373123476507233),
  K(0.21988687424527522479543589481717186898772811055324840232504813),
  K(5.924660927351843519921167790313140983440309769188127431549538716),
  K(0.226573949588132300801145987220638789187226040475852418791554947),
  K(6.071294035675327244106129557539292111049562279187025931715889257),
  K(0.2559853394613029083057501058791176358122372468925040985531031),
  K(6.095405120026415743783122944469784795638955679203129886820359123),
  K(0.2607187472923819109261781115182622743994514389318813143414542),
  K(6.095891092937880889526296268156994330902465283549093779035599827),
  K(0.26081372875909611561789482323570129324695330914301079633225114),
  K(6.118024256990987349942378078565171804339807898504749663096724106),
  K(0.26512039861591874801819600891435987884687947367960153370289157),
  K(6.156192427174203615872425928239653590641532084723228425582660095),
  K(0.27245034332014642116343737996863234109109652845108600147068874),
  K(6.197208207100389776350477010851165760429496729217399458937534919),
  K(0.28017004854727381677251678307526508312475682439787684830014288),
  K(6.403196916717738600374805520015452522065358322604783180392703952),
  K(0.31558248877017704071950356142825920719851736730445156713657439),
  K(6.444285083882396694498212383077374685141657263731019359921980611),
  K(0.32180055068496383700144441985468831254517136637739799516236645),
  K(6.521416579849217420925877952084841271777099277096259059529274732),
  K(0.33254609832145151533664606693712159317376094955524574387082889),
  K(6.573812206566595899968940054033773704738249200335510977018401542),
  K(0.33909575555133911288808677982181874184496105781924032805355795),
  K(6.593630040531192243699468345929548782928277679956227455180436327),
  K(0.34140461104845734462120835196417981571237458191605931390193337),
  K(6.722091635463511586578171733197830364994440539404596668282357548),
  K(0.35396523187249447614172928828040588233955294993034748095386953),
  K(6.88096570701827902272155346871342352521470516295087333811785261),
  K(0.36325198080556643860648196372200653170061990317580096508590531),
  K(6.902559924141177307218260696667605136229844975657342136960357218),
  K(0.36394970682654247955205258574948581360472542682016842427089879),
  K(6.974983045142005783294259354320747030973508021586509985939658585),
  K(0.36527702572584567345147305296957093282931596392615255697640788),
  K(6.979721418476500039485680284909304696730959898395890172939212108),
  K(0.36530920569114224425038085252800437626366375911887638504078543),
};
static const R b14[] =
{
  K(0.08038496209512310146201648239619527456720313184271529825487175314),
  K(5.39559081001297550973135186201384536103930306431304017287800586e-27),
  K(0.1043365937660071170848947501535046444686014106295860097412461424),
  K(2.07828359404834800483788117036539621331379477102529037877586982e-25),
  K(0.2569303728239246652468861356230073984374436583771566529347887018),
  K(6.2662527342482012282390530852667273502735869473898166984270194e-20),
  K(0.2663725300001598592304074035690829599402622699856642520966501348),
  K(1.03858906801599147933165264218146504912176193159861744289732756e-19),
  K(0.2970953292501889634169387297942366150344937365509580916726830669),
  K(4.78776897314928474141937675071103368063193917479165398945433698e-19),
  K(0.4898199365751466394509974177298008453510368102920914844716519114),
  K(5.24930800894523332469690552022469810508094796820378470455991269e-16),
  K(0.512812649550097559852094712353242373610698817048681743024857041),
  K(9.9773190321206346303473544938388589109979915225448264667805406e-16),
  K(0.6163462735279271921712901591366690720580142406569693897520949517),
  K(1.30959947302897984953986843713986954923397007115309069413939674e-14),
  K(0.8072602782337097411504811116419707045870796283863373216739705129),
  K(5.72508334780370077153236373611792619971845304272538493793386752e-13),
  K(0.8189177560585791900182217775918668372311649723065532051573690523),
  K(6.99770574376504953694648477577938698483948705863342929197003962e-13),
  K(0.8264454613039065192650492890961426187899016547976964578334272523),
  K(7.9540887620336298337079340315697025903927845835206040701397514e-13),
  K(1.000171306135305399948195554621849966677252220284631147150441432),
  K(1.14982863783418467941796453891292202393543636999483220496212818e-11),
  K(1.271277226311808022109538873352590535936947612251241221373470677),
  K(3.30335603726442814123029146389097812420535005766343743410044739e-10),
  K(1.293942217573291410231053907253896468094561095688267166527382296),
  K(4.23058087402436262496558614862707913627952616766051295510953723e-10),
  K(1.330433068789932441613989047745497163742928700709663932956644805),
  K(6.2444480959358204902674099259350673186434848996558227239668076e-10),
  K(1.33285054175719479070954616350047589200112721243701747779277031),
  K(6.4051892166716902442861170920144438173198763848834872649658217e-10),
  K(1.365540665458165794324067115337462555329730461501831902941284035),
  K(8.9920044803993231055795633472483640706256729575307826122513499e-10),
  K(1.45975793572575551960638617206299745657618864910512949989346021),
  K(2.28835216495924921245346570564406483156951257297361696316130802e-9),
  K(1.6399890682774234273743567888215744238480554464422905840442448),
  K(1.167757372628353399012551378441796114641408845181971999558336e-8),
  K(1.648586230120145594664702546563393312627788921067424035307639363),
  K(1.25643821595046263563509894327721741852179161254292260953484496e-8),
  K(1.731677077342886973240768040331953331316535351390806450333910084),
  K(2.50086763379065800196483503835008702376678293883032511690340172e-8),
  K(1.7401238546999789220002623702043508332463950807984369099245069),
  K(2.6771492815783248546606329231918577383534653198433819596220945e-8),
  K(1.829640164124196188169012531136404055248681548723278640732442129),
  K(5.40268967565830121805716869712797785307313511407326644507498293e-8),
  K(2.074827884274680186120772900395201819754944838719160502518480287),
  K(3.13824816179810230340991892006257286843064640139817952469257865e-7),
  K(2.097039073478831225096960572589633246060192089128136809242833211),
  K(3.64194428465660065003038370347008650319996538181470432601387066e-7),
  K(2.176281669137844434293246802628402326235742821988522614313170701),
  K(6.1153087143143984641399965156022679013134315050175490599983895e-7),
  K(2.253493644276846947001036866641589102602018715959341105415912259),
  K(9.9496612941207030502052733989798649961582658466172831475894906e-7),
  K(2.311297858545933680795121608617355691481433641436643177664389958),
  K(1.41656429947897632889413691193061782830954377937780247076374784e-6),
  K(2.54577168320664305339058817834193325606628803717296351592376714),
  K(5.4323786551206915315078924495317156811096310907479047636842257e-6),
  K(2.674987836677328051364482727219811267824663153625223154183498714),
  K(0.0000107824373414018209624092328998800890917808998341158145379615511),
  K(2.805017509975914613320628467078524328000295603865430818000452041),
  K(0.0000207431224898341834475862109750628569595095885792900150518600413),
  K(2.828845035069383222700695734779736523336170380821777519432141269),
  K(0.0000233001182156348489736786726655266161475802538564472083399175324),
  K(2.944391747782572063153691086154784727103905856712042364973790815),
  K(0.000040322106939285747657056083371599341821518949415918936586989059),
  K(3.05154944790394744470282143541237402250467984704900234565370342),
  K(0.00006561982378569266263566143766500508791902997791083448317674221),
  K(3.125816654387491135181493061772418593854352602244761479350590351),
  K(0.000090900563494498607863455203207024771441768009363388104473189695),
  K(3.186419987413647885753816666933012125432553439604525580032470229),
  K(0.00011779183571394267609640115110732822417649129013192494148533623),
  K(3.203412278520524364185431415420988049461409435618118520105752057),
  K(0.00012653435314976217887362340352027524103234221937326213455514676),
  K(3.21922047191428872917192900553192334678486032302572825739601577),
  K(0.000135193310682529258226192670849741770245678153666434405497232512),
  K(3.389283288497269604554098388536402681136400192429670707610169314),
  K(0.000268886344193956035765032135885660605270316138602502068361730317),
  K(3.474908393917779726258485924317450673277672075067443199315211182),
  K(0.00037395917862023383506190678955878542385094866943901385402933739),
  K(3.520735835770742557386751111311058058198973329803937367269558146),
  K(0.00044424479749865004104440562726867474057151949195675919638460765),
  K(3.623633013334049116771876731229608341314340643282296598929728442),
  K(0.00064706653146839493010808454868514600369296438496477265992976551),
  K(3.634089555757923288339314134924734086213284452449849218627618117),
  K(0.00067173137563560269235370666937884234798333321147218108702223453),
  K(3.71708288576554376241371699922745935764515309958133551281431761),
  K(0.00089929813593442950272991735489541779931844459731729771015298168),
  K(3.880988614291631405874650816863649996100038238322340370073113823),
  K(0.00155878159655103308461118161311311306763230423491828071322537653),
  K(3.993589494670780255067670211336636839441703049793089427791273635),
  K(0.00223096207858335628517203496262437102193325113274916647503958254),
  K(4.26667866617675269912650038166772475623261485969879672204364227),
  K(0.0050030634376208614190206534998426042030134895249902859395140951),
  K(4.317075693292136640349176556970619263352549213433065547916922075),
  K(0.0057539818735088319943065351824229096015523463126801974686745588),
  K(4.355296364188094937825899895648024744844660590284571871115173507),
  K(0.0063859220081681483710982053398059353913664422974491544959114144),
  K(4.440129376456232922588772065094549886989529417262418009548310628),
  K(0.0080025412973213831525519581728553008362933260355623684701300722),
  K(4.489402419665817159529188170381633305272874488169725355408472763),
  K(0.0090913164015001288732654583664878211395984799678685121575646638),
  K(4.550112843567626982961856265967115538554762510386852000873889096),
  K(0.0106015157242130320000008292060998110412082706702599721918739601),
  K(4.621087344545622699041521753586552428824660434979860884436133122),
  K(0.012626949319900149305675246097057595417370684056009827218925445),
  K(4.763214218874334671936740574480660069104215013067623430393522867),
  K(0.0176480459857377160552400907347798236559242953085810569336633629),
  K(4.813823104118767527514050138650496089122830252283432567548856503),
  K(0.0197864061579578757979087849348633310190616476887294930111954061),
  K(4.836802338591058243370719336332479895843210114800541406521152356),
  K(0.0208238293994598952897054972734257723060470753067684101468389813),
  K(4.916987590979422770572182048500588701174346520573625650672752591),
  K(0.0247892863334140951280373919781197646353067798081380483013792416),
  K(5.030991695380471413549318557885211812598523819601647686645729775),
  K(0.031426825626727311538543199074547025937488455810118748588210316),
  K(5.045927248029277849438117301543092610895120482765662526829099165),
  K(0.032389519340427039375495222224999407974105557534203066835073506),
  K(5.063324857378289083304074441347962884992889772782219669097385867),
  K(0.033539325030321076577102826560088415073344474346579788679081379),
  K(5.170084492221797232534028607539403713589402181034061634633719857),
  K(0.041290321845857236490754437027392917487932175134988947125226955),
  K(5.205909160701356132127335552903376226748782361388470646436420191),
  K(0.044169957620847445577506090450796245570198334703558079407538185),
  K(5.235223493894515089636397513607996725332832110114907030287096692),
  K(0.046634457754709925542731124891810677084539342911086857229881072),
  K(5.489290775609781985613227406107575942517674226342008754315655099),
  K(0.072285460195394189277431469557558009201628006988862495582619647),
  K(5.57246893443664422273278565420245974317207478307315899429383611),
  K(0.082413588436280640963920409426031530460828304398167472642263437),
  K(5.609067012515871137713784582850558831446292970428263788878660519),
  K(0.087142685706138120301051742073484900916600502935774366255923035),
  K(5.705843848737587968475395530992422807899384096447159600689869725),
  K(0.10043889146985609562838253937142733680121949329909167122891255),
  K(5.739298812743981710497296898298036966186224362314501127071179787),
  K(0.105296584270244600258932197672641800540115267839466742299984886),
  K(5.832466584127809884746606458273860685456714237265272215571745857),
  K(0.119501400440123880831937304311053577292190130899201521543403176),
  K(5.857375452326899780368397416024363287701002438864448086519527278),
  K(0.123460951089288423340443189241177452782611223639719338193222508),
  K(5.903114018313009000531197805454956261769051632602455304308789964),
  K(0.130899557299561779644645087626464216183137906236969623461298938),
  K(5.915329089115460012067760139739681366782656153837683045812094324),
  K(0.132921666279804565046041042072276773121528694047238074748995395),
  K(5.941036386707917512099622328479095561775205060578191142925475291),
  K(0.137224350940786516866008472574155661575385735703979432731986601),
  K(5.959278301232222207770013542930117470081425469789014382757438204),
  K(0.140315107836777535016299613202284939572087261590219251453259352),
  K(5.994369969971818294858278458265124748929839860342937260966667462),
  K(0.146344556779473473045760629788272211981996051103207329575764185),
  K(6.024701140776425616100594995220977106272994058106140439142260902),
  K(0.151640258895661899710510887018354279812993093390461307069065091),
  K(6.033995822605934243018524130300999531045177820409630989783960855),
  K(0.153277888519234045640631105646672205022122703886050855864941424),
  K(6.274625488425471316403423993086579387614446579490353379851591689),
  K(0.197513027262131908459593655762241735885844672631903353670315989),
  K(6.297439747638865115968111370137207685741196905104721473058665168),
  K(0.201826988527475686215067470341567769745395060212407297870898559),
  K(6.324416103922548686982824532552259888419351148985631544231132975),
  K(0.20693801467734662302917148447566062778197954344804123792789596),
  K(6.361557307685173920722991905732567936330318930714794225667789143),
  K(0.213982994736602825692521717241954335040987663899904588843997769),
  K(6.400231676139147066369090247893362187888636583900516644081714335),
  K(0.221314180150527423118120832282304699598773359775180628004794492),
  K(6.477659444910842683319501764940638929713684036393702674792842496),
  K(0.235908496775468940537064175704897296440239291823512735875705657),
  K(6.499554585706486277987602835751046970297190731432013290411403879),
  K(0.23999997187431714543056745964965468319080226428859001898474463),
  K(6.532242182840607264282454204004566617129581074256489612045108038),
  K(0.24606666006830802775926848832792882902791624412045663784158518),
  K(6.618952982020205396932005589350119412388477198949403956174570014),
  K(0.26184025146393272478333477490860922860781300408886157563857511),
  K(6.691807215516038751535952715351243915524511255389235046012243405),
  K(0.27461299318463016436919549036659378779215093475490738576842396),
  K(6.808945900598713418154913914141337104831566661040953061805020634),
  K(0.29389564166694889256870035936357073079972140773471949550253492),
  K(6.843352610464939912304384464200672922523160894977731943680143564),
  K(0.29920303860830003629548309143845764636373131521616469780513729),
  K(6.854447285123366066199195595266835427307289934549434615952187561),
  K(0.30087564520217822745138792980485919974014510342047675863511105),
  K(7.078443167497006503553678944877024669906189980847160232466502113),
  K(0.32990616387825757792160100246204979970343950482046235580456),
  K(7.1159722476134273284411700298258802212943856096085601609201528),
  K(0.33376687264383901677754840322632551613360324472794576035445984),
  K(7.18722323242323355577239728306519232508296848714657677683895345),
  K(0.34020250896887217956728096289546557279478252217143448679203606),
  K(7.258446356560687483954647120878448459711131911124289055226092527),
  K(0.3454063532774527617254755864387960082761263843317676185588251),
  K(7.362085534456436240471005429348655737590605086641492807601752588),
  K(0.35066700010941306475341722538596660288125755688433043213774027),
  K(7.365395242017816591463315522978442924376428638714288399760355331),
  K(0.35078856038074734217735483371371033847853742816746191589967012),
  K(7.3828282733042345473624397572057437392228744591062331324630214),
  K(0.35138069833107800508299641404455165795967084959733160032743661),
  K(7.392075119755281261423294659447355595593505468995523402161392739),
  K(0.35166183860839158268348149320091125297001656077466202665607527),
  K(7.396918859251535613008451734557749831524158306248765723009963441),
  K(0.35179996867479099968161086673513985251303244965607424228882169),
  K(7.406611698200595736672857455793583352138915946462725236822571842),
  K(0.35205748000893691256375020618606338695672254780012671950177256),
};
static const R b15[] =
{
  K(0.06524688563852112599431353760224833659450548254061720478535133346),
  K(1.26443698509707049162742881034435644450539643945119395900721263e-30),
  K(0.1561457228141394554921678527679231333215926480755585180833720974),
  K(6.11577888441560230082993518157413498425965425261481154899685775e-25),
  K(0.1662745982036782037047486809326878606328999814712910754748865731),
  K(1.56996147202646341193472100052960724846611886021190536039711229e-24),
  K(0.2713224194677110198962685552592686126294460234137098253342405259),
  K(2.43100362333604579895905427404751863260784136958207497402379748e-21),
  K(0.4574086518746628298616871940525912215591377825871618241183291808),
  K(6.13855306060791801974695838529373631087655270391690948774334978e-18),
  K(0.5141076649858381995168323920821401876976964484826635809252313617),
  K(3.54251398172491429412859670678962415430369194596344224424162766e-17),
  K(0.6646948649531410690427815919385694283807438543172036073717303418),
  K(1.6704567820295195339601906763508543917429707646782114379635608e-15),
  K(0.880705303629708190668988510956605170002826460291455705565180924),
  K(1.13752136965209164241031220275564569961670324810295191018272493e-13),
  K(0.9346295363708226770128555074486615218534714232276830386440077747),
  K(2.77391348939871739736509526970602596372595505491707699205098277e-13),
  K(1.100393100334711040594513449572776313400330952243198791212305227),
  K(3.21157647622275961442157146573922346377920139172644089948652958e-12),
  K(1.111710905536044333295927846843535549553218006662560201650712473),
  K(3.74436673662341115214137735228625586366180886588687395645275882e-12),
  K(1.383654623331600106708428630378404907082012510849929692041677706),
  K(9.9750673557411744471633309653182729694374772708843240060841431e-11),
  K(1.418024130874928817829953786583122856838192704732142599021292722),
  K(1.44130081872529033533041192828492017501062881843059507232409437e-10),
  K(1.533142856003891216791859580149398359488481490070435715401211591),
  K(4.6477079478173166936308349331901752679856039176905378943737639e-10),
  K(1.621556050580319785399573583271265491300590022324038313191581836),
  K(1.07764552061722145736310432068561693967617603015422159434164844e-9),
  K(1.805176467393163420100435053740353936019209967321356695967487695),
  K(5.3858853101905739244411318077966719830560493094571627383940412e-9),
  K(2.000882368568527972066949634813315152675028342784846039986521053),
  K(2.52121702506386736862126762207900064268902612712443740320049904e-8),
  K(2.096267575450620228489527492486308639566974642916905821429656862),
  K(5.0673987190161496599377255005971919766116530895328194597557151e-8),
  K(2.109684231351790974431397846429678435847321224593877995369565536),
  K(5.5758161431152932322460197724472096112795343008619832721059793e-8),
  K(2.1991302597721936516312081168406339035048806080338599888946391),
  K(1.03868946777807746203656417581014834782559711821322842457041174e-7),
  K(2.202816187951594449412694154965913151971741159244138821852680594),
  K(1.06507164168584682987400411060608009704702060923464681006048626e-7),
  K(2.340875735172542170263339388007084857314574790934610055978206426),
  K(2.64571593546644590716745182294340551567191688726908484000102387e-7),
  K(2.409937767387179179100363252801598917915892137169692792440306546),
  K(4.08643172961513350108900828600744102311031240971157567365050556e-7),
  K(2.420584097931664394011401811227466862279735087292094569269098363),
  K(4.36467462458130859058807245382333200429459465476465281966392167e-7),
  K(2.514515221325615766413947923125582013489195808691733041950418741),
  K(7.706188258065553055693538289938662084724168707293797187350234e-7),
  K(2.559789163764258128971319798369245492938287932764744688926994205),
  K(1.00559780710611685742996612013472161851051025988766220866732883e-6),
  K(2.620759047849132326142646675077330966393340106872728806127388724),
  K(1.42801387085432876603171750296879909692423407290243752231515897e-6),
  K(2.640671548031339164578993487818719489934828836629041339149590169),
  K(1.59832948844181006285104581352564160570149797937840921878506397e-6),
  K(2.687381187640514963353886725013770603790806664975574850720103644),
  K(2.07458898190296821786129166875650998801835132108917142031100465e-6),
  K(3.010348852709226686196184885611960946094012569296725876127105038),
  K(0.0000111214471316702739871372275678291079977227378820950797659542969),
  K(3.051422379234583055356492515944742335069452871125632823854796354),
  K(0.0000135725417641309928053550594912293812605400163894703878296857446),
  K(3.060432397628151688359528808207504625000048880202120478648209575),
  K(0.0000141729499606565567877163103838850282959054077396273902041824957),
  K(3.080024410335416967408873868451431098610451536973020448031972841),
  K(0.0000155640464584639302676205921851384366558696070320569900940606811),
  K(3.084417309946797356682894635065290153038563425069270468348181753),
  K(0.0000158927638259397438603357893573936832034408409848124655770140821),
  K(3.206213340781758729929925380238995155011442531510441171529506932),
  K(0.0000279974946556787005906792901588042028345837273576028272716717684),
  K(3.267566651549473466295034225213481245323671284800639405402761991),
  K(0.0000368913303574725744590930076845736580754939738118184745273081599),
  K(3.327644298365925032472987574662293609525780556980175133792198731),
  K(0.000048049908099784530979411738606319191523061967158421052733471192),
  K(3.363500237934227498546539474694548814255066957062383801351369902),
  K(0.000056107002754014284676739505727741091217006615417192832113830509),
  K(3.402907090999440408401821603797108440458609910035847753987828768),
  K(0.000066377074643357537265700211665094676470240301357913889250150482),
  K(3.420395751999375737603418785789155842429916796941306681655236222),
  K(0.000071464077877670833898002812887153968391214564201672189947806413),
  K(3.499541264591156420454703186042830214816892123762459760462403664),
  K(0.000099253764758753652046975279122481344636109023835998169135645448),
  K(3.544614108625092527741226941338602030428962154879116450514228419),
  K(0.000119183156580697261192109472033684768877395303020163231253091318),
  K(3.565004191988400394552164647894199988566265581299385029760139821),
  K(0.000129344961691892576855191509117657299009002962297893718075857361),
  K(3.593773741957557219013648774292462060791184599191613826991783688),
  K(0.000145028380423752618166633970218092088831992561661709319630769381),
  K(3.632372418228044918655697333382845748391584916854053550766223215),
  K(0.000168790523421622995918995421604564320616376220579245276949293333),
  K(3.703370835636570254126379620524965821350316472102263999518185319),
  K(0.000221939071295987980276122020270818512794443124359515068854730645),
  K(3.747364542443106084541440448514403403612055042505118856549138609),
  K(0.000262071407995107511929011273867540630698679859911344674016250852),
  K(3.754096244964762053200021613088402938945810407405043416778115958),
  K(0.00026876127491733442621291272928342959842225311821318990124331199),
  K(3.755483877247501717969283944146536609986566466911255481511509439),
  K(0.000270159362043984313272609706233018316022072836859947986162906856),
  K(3.757735197174929726171524336725596932281278636321730638816516133),
  K(0.000272441661331677921847074139081090947828809058871857106631550024),
  K(3.767453785993293022114041655749377850714242665013317987249686345),
  K(0.000282495699364563336683675703858389419588302127335164295501570901),
  K(3.770280057510110550098524220547032810588131350702378987422307502),
  K(0.000285481914626324500475960985458374707917699300034963046210709506),
  K(3.77092114009744760178058591432733004128463611332662883165559695),
  K(0.000286163240332307110879655927899380238719115857419857797643535944),
  K(3.774285611168231598922489021104053324692168769850775841231817493),
  K(0.00028976310229811737545598492857314257065505416557009378137767998),
  K(3.781529358046520574368360900074388454213816661882577921604037129),
  K(0.000297653131350494490794765319205876086231146106844897398344803112),
  K(3.792729984847503934186257326358443861932296540816935887774628741),
  K(0.000310236244766356883098155645691587652715051439802044958912973667),
  K(3.925780370309236382946923716080098155930257430475667261242128212),
  K(0.00050113129379477725195851605658770826484305414617790627401929262),
  K(4.039798354352898875759748999984045034429880941344749361652313859),
  K(0.00074266762266925467580975377988954272256384657469415612117335735),
  K(4.243245754270537099161173656874677733340901458251896759146405498),
  K(0.0014420083598267339967203073825318709498289527863919188880889229),
  K(4.268785192365833444042552532660528414909124766197922354773403714),
  K(0.00156201356065537319363046025743096970566037095321029028971720774),
  K(4.304816601078027172554911838745269366122814753944011210335951192),
  K(0.00174632372424027656831347243240733574414564551480686948000325243),
  K(4.32782214944903564168113419224336166663088290094746713214026975),
  K(0.00187380923344556642406832851044350879028584424268577115822734078),
  K(4.368588585791091464454527118069633633904204575425776776175943157),
  K(0.00211996676154587043125264816447804553891096057729944872428447201),
  K(4.559138115679865827356442578596285932729033727354088085305301068),
  K(0.0036861957671579662088961036983036014157816212436949738798917436),
  K(4.644939953811752427915979691976602265782684262250983793357061064),
  K(0.0046704945338447186010598302510044431130357596117059494202932705),
  K(4.653106956924452894303158664326909532807019461217029375358917419),
  K(0.0047750255477596916541163696002688990878187245717400390951249306),
  K(4.718471451556829108466917471050179835736337223603165497673454027),
  K(0.0056866471828368067018168464936997933083944702235932397405564798),
  K(4.719242779078639701342146593966973358662979879261427701629344733),
  K(0.0056982377544211837590056275177689747193772765625007810520928107),
  K(4.81584244045651607539098933706587848728126131705343942441122467),
  K(0.007319092877223926639720077649068066113610810421435842627124874),
  K(4.859018663914719685488668704408298629525952692546460721129462247),
  K(0.0081613254603966974770767892778799410168499665930630231678317706),
  K(4.889950703469766010390225156745994747636422049642568602481750705),
  K(0.0088138575063709198804408591067603209109516704786169126586328372),
  K(5.076892702386292289213824658351800204881150046035708924111360368),
  K(0.0137599577548990399277295368021830357929193024795985682155367694),
  K(5.176013876755567669504636531889589254111237754393179042092447823),
  K(0.0171963383636222335210578799682264600774330920920193468055969262),
  K(5.222927015731440168849973265745018898136708946052596900601758843),
  K(0.0190501425671554203567017104803804623553534952354866690895548221),
  K(5.268225348979709385173510536780405745313136866219431452426841805),
  K(0.0209898618670017269201831726321852472577705549390469468301135798),
  K(5.336413634652114531769338637378597696634832253720949147146817975),
  K(0.0242044139840480066178281579924331080558669731404596946088986499),
  K(5.386579104416318161236679664535664702608534525171598992219572792),
  K(0.026808842369989131537261200078469978951464041837979466021920932),
  K(5.55102792259851938384140219670602581169290518688539090738381302),
  K(0.036903879413270393767733670342084703142560357255384019026680339),
  K(5.631488444837607767066373877523896500784088854590782877517936001),
  K(0.042785424036504597209201425203738690005885698198733519259616781),
  K(5.679690380698138175664958053020753206789230916276758544916090093),
  K(0.046625978783363084499878081201547662471392044064003453340601726),
  K(5.80369987964183933049861968052952555228142766445907922639007066),
  K(0.057647937323376525688700879006881211848861302724461875235592134),
  K(5.9067843636476693255711178831213810958626932027801026625337175),
  K(0.068104967698403422048554755495284399559908192289294805466384582),
  K(5.956517922224213854949712678376546582842745724348513170175773011),
  K(0.073579217685937427168220886969584544496320806164766667811231096),
  K(5.969597269358227963027760673422289440018011525721083034481079284),
  K(0.075065490167694224153360354154737664601677033690862920382946215),
  K(5.971772217657911781025810246618075458300128786875467293124459261),
  K(0.075314522531281021313614446081835448554093166550494087118455046),
  K(5.986987010324478184060642637704877270764629854811081189310478614),
  K(0.07707162229898424023535531353686664695925765866015626785633564),
  K(6.152368038105326122427165602690141806363319593739009109532720754),
  K(0.097847007623417921232516139674396119165275725506141396213848796),
  K(6.265166368840777021554815869606725911224132651637977769910113524),
  K(0.113716435875896082458591918107801740025578455014107882699852709),
  K(6.305697711196964103164022377824073257019088582916041349060510854),
  K(0.119733786992983675280871145941909179371065428085409207146628296),
  K(6.370875590808855395627492998930090598933258547706718035567584596),
  K(0.129735449865900480121680132530461531517673856125453218463023147),
  K(6.481276977291409070003511307845968168124846766323163198088657787),
  K(0.147505965824365182786218174024938093336887283214487552178356191),
  K(6.499185765063949332617821803748497557276077035756305346164971633),
  K(0.150476368234085608687648433014637536223898808899337388036723544),
  K(6.611797785455402081259239741982275516883720129448975716404396337),
  K(0.169617077711527488499484827164132657008398438572811349208905271),
  K(6.998868708577432519109977072470512943263533701419169602309841944),
  K(0.23792685159566542081611823129086389673036131259215151397850485),
  K(7.004299131547358235870858052875484197767778775764971614665986026),
  K(0.23886874855261984698816319669284050197237563448559425131028338),
  K(7.170994814720527023671579198212698635744665443844217312131885279),
  K(0.266822164771783758701399353273402356141277743172643267205888),
  K(7.227750735609515172136932681913235558107780495665872148256395494),
  K(0.27577599267244767132668078731947635086533547562758152556275742),
  K(7.26770017434665565549975834666142715325652795502420285632654731),
  K(0.28185806228857972851969168268373261520569380706243975219442194),
  K(7.602618423350583473405510776351588719160549060348871762296186837),
  K(0.32325805977820229057203809810841292151527806776127515216289059),
  K(7.700932818890707186919848892238098147807562101193224016957588024),
  K(0.33135921723357620548242511899637723442617823323888287151867706),
};
static const R b16[] =
{
  K(0.01632344581322613437978564083659119855236034016553572240140638576),
  K(1.21442270043245808863798453307965940423442328989672151824706661e-42),
  K(0.1476800193307583057413600530180556878311648671515897202190915723),
  K(2.44640443108088353910703803669217177200568175024519479805270012e-27),
  K(0.3953210101745247270937085229674529520748384166711059639525448298),
  K(1.70050827471416046510667618493267508860700598835892219905400469e-20),
  K(0.4235982539083013033608150069690701097351766798314434766023346218),
  K(5.13625984054342706482857440565334530685748695601965423893470305e-20),
  K(0.4791329870476096664744951823486874901494575837780969649706436853),
  K(3.68703751895214451172455779287184896098950430977788130394422709e-19),
  K(0.5215890179805354235272956092271122958600287653852879006980757017),
  K(1.43428490159051468108617940179024930911287925780203040143559364e-18),
  K(0.5823036536598409508864036027327427288165233421862433601802428265),
  K(8.3516569623420634735323383508884404446109050853536666691395765e-18),
  K(0.682623391983218947343543953289475077910819776154266140109262249),
  K(1.06237800396747995146515126718225065506346202835859810926153048e-16),
  K(0.7898409882346258089206560654266197321195566903534345876746629039),
  K(1.09651628096554739152162546659558313751627981769309864706230476e-15),
  K(0.8694416764595674107507580538755148522838638675567572153153595629),
  K(5.09597950353462408115290682872606254818127689252255994779848737e-15),
  K(0.8815676069762188013979634941802468769155696730555810339637944555),
  K(6.3601943402283580545578921500708061442348745822181093633486284e-15),
  K(0.901826624206455047667714771064803698320469650698230092966572798),
  K(9.1484864326846252879950146669936538801410475077731196805666811e-15),
  K(0.9770555725485392394049891797356064805347585118030225568528334891),
  K(3.29677010078067102242328883737580548434045745449672137709641953e-14),
  K(1.001810670131509909350444711120831967131569368949362430027462665),
  K(4.91983858159458997792600548635033162489155524134156239754275259e-14),
  K(1.066979702422463273419493598825498401635615361991495918487300423),
  K(1.34858687979674436609932860780696703061125708636422295404801558e-13),
  K(1.350590340627289997191267045388405408194038307666961406053590314),
  K(5.8581249744345771517740188411900936886408136142102887709556556e-12),
  K(1.463886851764897360840687205015847215319246760513746550811548428),
  K(2.12569274988730025382484150357155113421539873937691828302752136e-11),
  K(1.682295256032921445891940318844615155951876240918704939678831831),
  K(1.96703448232759166319340193687179515558666114285136887747288675e-10),
  K(1.685171742969279898895370714404215306284786296122215641914325376),
  K(2.02154298265463142848576785118323476062100971803901347062296428e-10),
  K(1.701235086968214174988930484369561227154572347578238134523200001),
  K(2.35290600920851160960429529915116694101777638103464704641462398e-10),
  K(1.792098493145952480730032870862471122355656994642653018664968465),
  K(5.4094702451794066125213466518787688231191523770587490042343256e-10),
  K(1.870057366670781227174306032141368860406596091701886164463984442),
  K(1.06911318318035771641897527723622790962624579489173342438584548e-9),
  K(1.966891804433135612188039862572035956981087862255092279865286131),
  K(2.39762947698165354470661484628221391800850263429855436348760726e-9),
  K(2.169597099557483697086632331105582296630791384071825639560701552),
  K(1.1509861284968003886225498910342420212646302216014449671457353e-8),
  K(2.191901380697962601201729036277649380792336052444559977275859341),
  K(1.3554543436043579637066670092767551358896991633482680883995056e-8),
  K(2.210186159580648368776817636703172261104344944651545247111778916),
  K(1.54796046078129684880417784026497882930507157714319469224162009e-8),
  K(2.240828131783428936266902357554789281296181930995568505578429773),
  K(1.92903414811980982316476055248476560390312015066481340200405711e-8),
  K(2.265063983017358015016023645100184165217264864163117570150298625),
  K(2.29089752408461445318729915546994333474521950256920081396240215e-8),
  K(2.311608243165090912009031532690320141723360483620670213855909144),
  K(3.1707007700667424779002769476893385640731743646394515571888221e-8),
  K(2.337276424606743002493678998462364684666101459662282407637069),
  K(3.78239517483441868470297441388769921872943301540710874716659328e-8),
  K(2.37069879388110540072478496393218742731056229434610303849849084),
  K(4.7451438702811408835560519451334992177226057699119238243549042e-8),
  K(2.480568113111442554888641111010002554478852554769631315829599072),
  K(9.7786574980709553703458055389061054141302599679949973459455147e-8),
  K(2.527443396016793933469150236702968724574673495680735219286126263),
  K(1.31807308127166096045299159050682925899473094445837980258628814e-7),
  K(2.566179653777539072515760767230268391804708575600554849926535422),
  K(1.67968845488745103672671124275332235884352738539279491174890345e-7),
  K(2.570468286200444784609927677738823047120034528432660621389660597),
  K(1.72498178323068680344089355127733934404026121169359321228615326e-7),
  K(2.614086999096059624444659307520422719270357665405361636882256571),
  K(2.25524001333267308128416211539580033791604698048509069967342267e-7),
  K(2.742212448197947047911950044210894293763778164728094926386096348),
  K(4.827962100675325706184732105668842299373482363970118966549066e-7),
  K(2.872485145479600200211607658205964841312342448828301872132385912),
  K(1.00828848323221253213835813709010296271146017668062238020891736e-6),
  K(2.936041864292267967390641426651775801942170681117542639754068937),
  K(1.4257373374212304123453519338030224177289656661112544944062595e-6),
  K(3.015458430941050198408858031249135729783424475725305001127921482),
  K(2.1735253782522677101497318279469299705687204890312589242404056e-6),
  K(3.046656450482240346774788019342366632064293735191274482170168873),
  K(2.55664173447120365132547056627710160673958253053083568407932733e-6),
  K(3.057946147571368811144956081969705654654248488597186097934493755),
  K(2.71012195444680687921627730093265456630297435435989611750396825e-6),
  K(3.359176217991053946300296205628373018586992807798491548846810769),
  K(0.0000118160567442744548205301495878337658204717243761670970307450095),
  K(3.521116612127975999163784526728281634490007280700239592197835673),
  K(0.0000245260291186756013750006599517218592373589634658650765861326719),
  K(3.621330946190001403828688306751438342302384997524386407253277874),
  K(0.000037785902976231209222581339101568620495913388425025453146409779),
  K(3.821042964003751246137828097430137754231230286987074031773012121),
  K(0.000085715877934158742148915729070135219665451435617755441193526998),
  K(3.956131306548604076875766682269180154789733004353814237299417776),
  K(0.000144739479983268927599118325724746424927743272032439389997852523),
  K(3.989238401790630387418850867711838575268719891898958630112112915),
  K(0.000163985763571414583849343892124724675234709196841733846401666005),
  K(4.005582376784301921482350333861688477444207294311786155411877624),
  K(0.00017432246839029932704861402486224257809482798826914069520076944),
  K(4.103994484961021186207530286568805197716657606849281686506133815),
  K(0.00025014410673220988928605815646929357760356968512584122659018869),
  K(4.204429291035428291236639996227075741541134435928806969573345603),
  K(0.00035731104716616857052705815208994607267004097449341181538803816),
  K(4.487782443319602645060846017084948157921594600254315861477219096),
  K(0.00091823946719452821715548844760060611701691976037439326641047691),
  K(4.616853952760356866489060889777303948230101654175757891567293359),
  K(0.00137119588185416071316965767807168393609604226164385044434952135),
  K(4.707261329638205772749854540620572208023547583832186901531389479),
  K(0.00179719856010530539700669064503084756696328075787467520955231543),
  K(4.840418430267218711161290694631377328744118537939608437601997745),
  K(0.00263707582811592767515795795071726701984212951015284783522425746),
  K(4.884231901617830307474335784228811953094391339755324358182241773),
  K(0.0029802388774222265977155021293020170264853934971442369819592547),
  K(4.961232410049714990609801356773801730608789492289746476825630452),
  K(0.003678437934859192993357750122681718535986933297277930213466339),
  K(4.99736281594241166950096577543970663629192290848799929921122757),
  K(0.0040523360517893973525029583062561700190525607826811423102547558),
  K(5.051939085950659978841029926373037668827881014637032464753090049),
  K(0.0046794357057973114161474149957326429971017453895988481626507839),
  K(5.073873914236307733780979756656542897421747515159214571585599156),
  K(0.0049541116130940624208304525559723426036106195938270097060369385),
  K(5.125615106472640162689596602842330873038060771729550069675714802),
  K(0.005657563607892785524808334228339740943705084522072945089895088),
  K(5.233079343236757147633918063050240443373941752389898041030472523),
  K(0.0073956674856246301231719416033740165340537922981239412289580623),
  K(5.318992125759906881652212379638397545287940231224101303553009076),
  K(0.0090934184513150781831005936630132910479521032451224945349645061),
  K(5.429944896802724274705166314540895809601155777479117836675152377),
  K(0.0117604565171216881786367321303740088352196448145350266222400694),
  K(5.430410855977565031774070293098283052758948347396407592169115572),
  K(0.0117728978537779861431265959844437386931111308631957167547974305),
  K(5.448516529248034985743417563536237645216119288402729371147266615),
  K(0.0122648622148094164434321402975147699509436619565207659290478663),
  K(5.514091332083679087686631634279526872544961823841871018567871728),
  K(0.0141913353516867417840245640688167203656313365924608583791446536),
  K(5.523404471366974343052855740075505718397720891651148668747480329),
  K(0.0144840977055206388861812646064167724548337372723714813537646857),
  K(5.623595104790982748583100304563600089984585966227961586238465067),
  K(0.0179581960069983809294801795346479825348577975778868312951152943),
  K(5.678822345996499144704229480685474776349302969357939198759540144),
  K(0.0201444351895195073104859904714204627188497426718948231234290949),
  K(5.719850562771540373120394374087494567453722183228467339664314698),
  K(0.0219029484969758373436762073561467597688329239068662218024716062),
  K(5.826790658100093490830048535312120588469253084290799682788441275),
  K(0.027064343309987382162720979835110898590214542717116634601684139),
  K(6.010819410724913310169220950920197007864987282232224926017496638),
  K(0.038112255623437624675362131418022511949358347020581847849646277),
  K(6.143143513713596338580609557898452478349521924643651989617560292),
  K(0.047940507423521363312411140286173220937836696235285438796798185),
  K(6.220074870214220178804114629314321086361681380904790783051264379),
  K(0.054436040875098605996089806779893310216741873466328725346703014),
  K(6.276518621561486943797831092411684302783111676336671208953852695),
  K(0.059580630901179433192721634028791776572797544876093317574969842),
  K(6.449313721764528598285477710964530631435177016986508107523235247),
  K(0.077369151603082308302375534550320832479884282830514937422441176),
  K(6.70747100428765290178463527882317487810181396354168271027280059),
  K(0.109614455084030153825089724077669969250064629083117073174712426),
  K(6.878866164245266228427959659576392819701760701703586516378780875),
  K(0.134431334469065827420441272591986249713955386455204762138655869),
  K(6.879387132586535844607444781306551193007474956187862175229057425),
  K(0.134510356084598777570385138535493407047744499137696468602708068),
  K(7.002416659974181929381871493604280237050439190666268213362075202),
  K(0.153686618514977071136375838490973760843614056260403238591852935),
  K(7.019161599931038086453547552473400532081006699133377252535264019),
  K(0.156367775707497797487106358107206312042769005834561110178027768),
  K(7.231911079053228147021532009329311387064852267313308024000377598),
  K(0.191424170495519946534071035385227595237761927463521096138533349),
  K(7.270102063162650236850514273753684461301472618428573822620983196),
  K(0.197827813458003531909782319414754598081725199311520510871551186),
  K(7.301127014599690422339126624263611446728398609025726294641395102),
  K(0.20303315844860162679527129530644709064714530284854777709291526),
  K(7.415353590422024108316410221406745366483399480831886682713986585),
  K(0.22210533518783921767613099933462090202890846635402377409304549),
  K(7.437358326049699297930503741753818577586719935247120445578435496),
  K(0.22574259897061237599088961561007973501100283365573004385995625),
  K(7.508189324343508826700321396153362293575972516135552308921616866),
  K(0.23731362152251312944841716822060051907449438677108404219564523),
  K(7.558764083681955749423359504086686019590509130605026554540249059),
  K(0.24541049122627433864054033115658291158608809189962587979208868),
  K(7.623358608754245243677140075281489085321996410033970171454155299),
  K(0.25549284842354245691769511608643113309193288451367498937360352),
  K(7.670620327052598254549197263745863304498529974292777119245375371),
  K(0.2626489381188439475842735465608355484758687372327353516159057),
  K(7.753734140106639250391841603542093519521176690597492765029145628),
  K(0.27469098900236710456568722483692579475053563785710134722022586),
  K(8.077823078197245212734517310512086778923871937619408276732071427),
  K(0.31262663566515627113448484386098135338743274411114011751876665),
  K(8.204514402238097534146923437364778501260664484250259286390410001),
  K(0.32247055393295019844182142457442672645116510635941835391503439),
  K(8.215361946819854001871989680164510209478795497133874162751683271),
  K(0.32316296767893946802733302395537621928265278173370176277393458),
  K(8.239137277434160764239705155389435864057216340170327348578606996),
  K(0.32459458939287088403983737909144220674653981047831126217127979),
  K(8.267580499307706648155599410981172558286705043832294853490616883),
  K(0.32615031223106987826735056577448842010973778775994207703721972),
  K(8.374530444097204264549717894526701160602483633730664057211031258),
  K(0.33043155276782232212950925957663458014173175266990151375880517),
  K(8.432700121864605496674472937082050387735627540673619606684061055),
  K(0.33169613985826852702621905395708675968009352670967118653450102),
  K(8.448515479512247048505640433269777792978701906642086113179475858),
  K(0.3319084633005224293622045425191469203482811671974823939003375),
};
static const R b17[] =
{
  K(0.1642889099136421200255127162317202727587518813539791972595192991),
  K(1.30098323725337944250830810103669948846277118561854377763412108e-28),
  K(0.2853199502942405879974839486895556196381377909000950158004447859),
  K(1.54731187850940637782491958996405065223252824905216069144751858e-24),
  K(0.3817682720133198566705218850645535579595100326917823316709905166),
  K(2.1853883956202471649378168523269003126546865913403449765205564e-22),
  K(0.5988345192309950797035056006625775178167997786895929412837830754),
  K(4.60412961873737111909247019361416287577999900980815486176744125e-19),
  K(0.7387830873334704615250903050340967489990545814847254737031742547),
  K(1.63575985552134929170260007110647473159372939227409537360069581e-17),
  K(0.7516698664854059421048550081571631619171403200434039741376551331),
  K(2.19478947745671521177084143241703871813776395344903177132401422e-17),
  K(0.8106670636860050077225069463303216711475704283513208855790911065),
  K(7.9296582495350092528366223372730069304575576704268991148608946e-17),
  K(0.9629055737830677017287907265138337867744377431563862140311509364),
  K(1.4786125755180866351413557642903475972009998295313647245113049e-15),
  K(1.110278562310270098718792054260674965561618058124810727843587277),
  K(1.66446516011597147604441332870023631209955217232716802663644563e-14),
  K(1.246731952665172221151535976941076034366184024435743460262785129),
  K(1.19419161773993500220908521148837011340460640716458987781977449e-13),
  K(1.269363809710071088140180854576895146047738224752045390132483915),
  K(1.62141949979808956078353496833740661834019052467891100495467961e-13),
  K(1.277602599612182151503224847876557990286836010587230346290626929),
  K(1.80992200688151685312753010324539071387943121621126633027947937e-13),
  K(1.285946272935692544077000781087878826957121610594204699701071582),
  K(2.02171295444051448149453245808970650712728162671659298643296461e-13),
  K(1.304884232424774030446291437518592913632454301668576581460191316),
  K(2.59212059011534286214966206510883280389621414805666979690876132e-13),
  K(1.410232738792772068812954008722537883143376438983285012820793939),
  K(9.7023057033323459095883416112556770838843107463098456611513985e-13),
  K(1.471983926780383582181911907791939865606735530947381766901245318),
  K(2.01040523201406221564643370920232580174328524925741560904209742e-12),
  K(1.610422090270110354622131272980599738648343276419650368666908899),
  K(9.2662960772402360687694002347678597801927578242697100759007674e-12),
  K(1.62615663140240356808036794909792255916013924890711545898502455),
  K(1.09317866875068132268102017751984653828966828990214202975767251e-11),
  K(1.663635463015446418757166024762062593352683755631032226054613301),
  K(1.61034557329139899105915443765021384910937157835712632461122611e-11),
  K(1.835685888578005641507024849962552573823843996836870160652997056),
  K(8.5800862242816444701505944068133646349891140991165109636771252e-11),
  K(1.964577270495315980170766212646656403455777409600126546742218065),
  K(2.719334707918950726377564066993103056193399215466849589440403e-10),
  K(2.042331341737823360905750714467668338455607189018564938425144537),
  K(5.2600804029807712756300031459381751302145962676771409795427486e-10),
  K(2.231424163138403472512478096094025033329276493887908390659086762),
  K(2.3686908547104095272890944583302723162691044194180258955830296e-9),
  K(2.350994296995689214428222374775962559428419218315800989219041763),
  K(5.7487395846106245563603192224790412555994664502524048649644924e-9),
  K(2.501091201792659296724353920329946343088609967419322593008435898),
  K(1.64362093114067441097265677210876218619937415817862095106426544e-8),
  K(2.578663347522965747525027843039437133339023325346506694132001386),
  K(2.75913682732543990509361645908466130390685612493653321934804363e-8),
  K(2.638411530312005672988357260789133360021456449192810540309168431),
  K(4.0679386938659507535796610826899961624714310759305786213479473e-8),
  K(2.71736564647833327329271213903887036829482643633030912326412813),
  K(6.7024965387312077207073893575663939886093093847912017017880771e-8),
  K(2.769283828220949465884895070828780020521039031632073906459518437),
  K(9.2323478258690446492345381169410070551260744508273067181033282e-8),
  K(2.824055022397918570326041456725213223764896473908229537146142911),
  K(1.28563389422326064023337213032667878163758927382125919892947139e-7),
  K(3.139859299696773834365906741701419176712820404480721846951953549),
  K(7.6685426784597123275968562862299838997124285506364452244560659e-7),
  K(3.149953407809830778320559170732817312788490182078304562961773608),
  K(8.0929077044814033949188706427073437442577848583962313601682426e-7),
  K(3.169002828460302125984479869762036362145024043921038129520553064),
  K(8.9542185116361684813673234150691836298964937377985150374570348e-7),
  K(3.232827236258258806506956426009065399906762840395897950824493941),
  K(1.25058993985881242758039057476713824575129338738336702036860399e-6),
  K(3.321339750668402183222025959755498799938692251206964206568509784),
  K(1.96419357551847461199244402696425126822314575379028143438662036e-6),
  K(3.342449512530122454595550596977913813137506066805580719777843746),
  K(2.18317627818231495515209329625015253287805599953582247376081767e-6),
  K(3.406058448171489510180931528947958520575129182312785464736225267),
  K(2.98861403070109599590200680597667091722017903237407955295790392e-6),
  K(3.591860618421327170974074918088265040845249480653896505181048002),
  K(7.2082466234740483192505391430537094645042535749215779381497013e-6),
  K(3.801827517971409973844244651203578208500548946839664999137102602),
  K(0.0000183256554033167396551153919065723608697714732201998920102824139),
  K(3.818813586854916038183194887853413324149364460467910343000874474),
  K(0.0000197090391560749948412858488399246804615904688709877573407657681),
  K(3.839140980282353085186002596199946687451717276573898810458110655),
  K(0.0000214913894830150084709074724519878661364469382881379510476520846),
  K(4.034317523247387312100829506881292876707222668356683383195441391),
  K(0.000047995816561043771304929397024701840726332293683846104012727667),
  K(4.053953552056622324757079530049639395001481298478215726837812409),
  K(0.000051895781408051711888441089520391395618771880364155646397038878),
  K(4.48716434696392604483275788798575556402300176303985907095945065),
  K(0.000258678022718833244107070116226477772999684441128146447282675316),
  K(4.504634907876062520498432489809107461842517385160620530181342124),
  K(0.000274756772754585860059183927048288684620496142343225809605690925),
  K(4.666534564561059712781177151220891631992468765702845049337728445),
  K(0.00047302729379989189886254088162246152972169138464180341707466109),
  K(4.690752646271391863855866397159921441312248429154936826129143341),
  K(0.00051185895983354849933866667864626579332052165611573969847358137),
  K(4.735679744111274063909389038358069687272150368080392701835995014),
  K(0.00059158754938354007091583116328594327540298865917026542726420138),
  K(4.757477689391211951161867255980498779639197549462396998465989327),
  K(0.00063416051639418177228973562885339781804601407198632894081244395),
  K(4.895183293055117757176332790727696031460428293625905614133135309),
  K(0.00097289795020044424947240165502013389143704557185035079016540414),
  K(5.014554376080647189815105496413336269606608914996627164558513405),
  K(0.00138881610623332835442052580165702403498158148958973783845636913),
  K(5.056655264012678251069892585811523974023541419793798399871531602),
  K(0.00156944757842987937641341020866818775285855600565415118386719101),
  K(5.066390594167754480418031272073246543288159840692034716367766872),
  K(0.00161406979779928861200255773127608641589820800443431859575642308),
  K(5.069438373558363305305151843151694733032965510508893209630637853),
  K(0.00162826858270837897133318051949652829008417143584682170807547188),
  K(5.113939124213774873569797338683980280906660518216839110465737584),
  K(0.00184855847722461997511957975022133716958139259477498263048968214),
  K(5.146584059509147777185392638172049465410068411431539036808558151),
  K(0.00202650868533589814211098551008428814188836753529779976719305838),
  K(5.264005790109548733411252591557053860041708349052392997701100325),
  K(0.0027976931225111640547597084472614699674006137648747728891436124),
  K(5.29633990906121952070631824806905109840402763814423302513526838),
  K(0.003050777024493692521391982907935469761015428804821744453613164),
  K(5.357455704984613937565420974488853714212741249965467613144662569),
  K(0.0035841699541418746226495677580525666614213985045628703948925493),
  K(5.36807106497972532118328316509717981099744863137595677029568943),
  K(0.0036846500180039722950355471679915154398777365188321930351325925),
  K(5.415388688671595276110586071278363292045575219697660612978040586),
  K(0.0041628883051912705264813905382976239819949480837964818222902943),
  K(5.457963560235020746181381013067791600734883811995826627388836688),
  K(0.0046382337324687349801283212928022974916038819312385353014188223),
  K(5.471439509601954852635372257011969001542786367779082070929954896),
  K(0.0047981417587591272252821435002902216535901654258502422448147012),
  K(5.662991246293564684224069172687837230860711633253482943363064196),
  K(0.0076383776853834517489407635086057866165445570974354085989912473),
  K(5.696493375667652215350191482927935086215127493508488652724013085),
  K(0.0082591248033987032566903772162003291717072049347482997980973541),
  K(5.847345478759946585343856611802995710638949548075393500121245164),
  K(0.0116072801304315798868308511900066990522818096636829016953642485),
  K(5.877442453774294268009883815654590252527910826894535922871272637),
  K(0.0123951300628433700656933280386598491833054598884788833842359003),
  K(5.883901651127942666506428132396408635323855485747762308338058638),
  K(0.0125698613863369179437390991751706615338176678427603114399246801),
  K(5.939917532508276173872981715058165851136067941347056593894886084),
  K(0.0141723118839615096939930944178288631581377248999574427706999876),
  K(5.978834385246107928726757109386990581800516520047436274090484719),
  K(0.0153815971730797638819442318153769754250810960652065793993900557),
  K(6.114566618559931712471819485433478105255268782704429233445385284),
  K(0.0202746000675682468899171763956653130132839033972799014602664438),
  K(6.13950057122036508825963266740749555652990250350061618462050248),
  K(0.0212963460546270429138422663735412877063767773344040718139472923),
  K(6.153739925988922118173480869658848450670583241685926759108986113),
  K(0.021898034072085854965155122320198299855563930164831406504516784),
  K(6.340471572922843799180526379454268240348791547432688859696428616),
  K(0.031103601808359902319837164003370978783244260465539135907569846),
  K(6.449867523347227754893737651508512869022432489579262351791581995),
  K(0.037736065281066498239380684899351601054222749353814316160696363),
  K(6.552663858920453301696559225425744926932519532353092692918887787),
  K(0.044885118703524145586372240608491610949265266531605522587608257),
  K(6.600313257141492497603663969716484512693502844378427517689416709),
  K(0.048515158902619194110301889084170070388081844299228262288773643),
  K(6.691487134424373164956875589348695977948319855187570122450064392),
  K(0.056039178804673996617274596574859107142813060408664831240682113),
  K(6.714321075517005916271434511469800561898686135058651738300664388),
  K(0.058044593033457937177960014058919734032400711016169991480966094),
  K(6.731394314768302405809258939332643778210399761702705525590100996),
  K(0.059576117785465036156999174508073540581703113812056525073451671),
  K(6.847093587816829592616629837200858481671879574884547886322287286),
  K(0.070683172543584052053402812105573887220543348331100949976472322),
  K(6.866141718416509837612467258890268129955293022497229335968592596),
  K(0.072633962862487099653765138044709379047001897697484042906087642),
  K(6.890105427946553848767669852872900746530283642740278134535210739),
  K(0.075137221588546004362786718216383310121503884355013870137562717),
  K(6.910617656403231646566558908559840967242197164304994174879233387),
  K(0.077323258160513501973739399467080442832929912884237250971471859),
  K(7.33455418408631232989312941335811379652061355672351292593019527),
  K(0.130926735281260104744994117420995232344649690950088156182566894),
  K(7.428557305560307242492692303445700196982391640607615477624381775),
  K(0.14469041389582275704448410521604850958500129357919235856229963),
  K(7.609575837358602083330462052839807097741813552501661242688657898),
  K(0.172463240988596714715683929678352224728598279408520040835173258),
  K(7.646382886458591943704008459525449238141384593326392300402780339),
  K(0.178249463469450095918046158489526984014988174056930475275426525),
  K(7.806806931326495104017842488724620321994284205229143316061335457),
  K(0.20365535752213849132276405408049773759223476982174636681581072),
  K(7.859270948228173099046760368768636411118024317201353350548904557),
  K(0.21193620353550506862127152318101204575596895153255422611574341),
  K(7.893013482165999879827724249623099681283499845192088851830313201),
  K(0.21722952055713121317306322760667645265039400359222707231379302),
  K(8.016497440179713505314793674445589372838267860955814056694825175),
  K(0.2362327463251482014099808284658668732295116902105030360181247),
  K(8.236028372954055031177344931339008621705613157876629892021577357),
  K(0.26751055932269319058943094556301889551295400050840689792264206),
  K(8.295305566802218209494756543378509514492440298882229584519906671),
  K(0.27515349224558158833062079859351907793768148473017122654287552),
  K(8.329888272181330596825278282243601260622629907345354717387860978),
  K(0.27941719479439560772151788450929332385093033380397157701598133),
  K(8.433274093748773725063763752814640952481041064412082038925299315),
  K(0.29120760063793905898079118404024620940439509262129008202345012),
  K(8.481294743280987893367425015338424708329397392078510363691855921),
  K(0.29615197933696912743527105723356378667422681807769339784146612),
  K(8.700744303631986162536334833429154342145979804909571548002854823),
  K(0.31381571007245214206303575422879697348985650559660134602927829),
  K(8.792583484560840993864274930033499070463987914683843817170706551),
  K(0.31856035110128404985062135925732620579127329714527475055381004),
  K(8.920161751642248347606032264820980833415233016832049431654880524),
  K(0.32234640312912522983486924635091616385359254405169574061382132),
};
static const R b18[] =
{
  K(0.01822854904992806107508007085382411274964463614347931937082080905),
  K(7.712528845736800034003007090326272835919295213143605305516915e-48),
  K(0.1986199348471353430544984823815748687669302160497450329792944214),
  K(3.61468129236590904144135038012623549380071411721165292159678472e-29),
  K(0.3730605528251583526466634233451185345838541885424810522196500198),
  K(3.05975680960365247394238776791219115177644133563080455464735951e-24),
  K(0.636709687766267416556463046944698215367429516958788005835077239),
  K(4.61960902607830352824024107403137387832002180204947818122268017e-20),
  K(0.8593687692693989857158124297516503855656225460866674383724615924),
  K(1.02068370382894428089834711175907153545777073504158848839852022e-17),
  K(0.8785574604147783291520136643327561565980358358928715305290642783),
  K(1.51887508234158682741038832669128225140293353650146938514406872e-17),
  K(1.057436149883870204498192437430129458809689075077035284699777335),
  K(4.26809166918635823431160888673644023790423824644460142629075054e-16),
  K(1.102639613551711717681623978042818739308922813349274284829874285),
  K(9.0670000174155789835664158411332590788476085965487748351920923e-16),
  K(1.147080448639762024642757216041367465684803950911641577694720753),
  K(1.84649771679790425078378270947472220110950744321738385905103149e-15),
  K(1.163336456241510758029162753117728808251919240992163471693910184),
  K(2.37878430916285251948844713876575884928384737631628729006087407e-15),
  K(1.172936711858617214627040499091936011221322469939886403747416399),
  K(2.75804540219793716811728937687180212321758028077839633079309211e-15),
  K(1.293965683591837663249957629352388838136727162567799157013785061),
  K(1.61535745004983830800381827311108745939821767710612392164174451e-14),
  K(1.47897994190319704291397418428428796062097759811507893966951959),
  K(1.79052372775830824061991585857794779328162126086679489234984008e-13),
  K(1.521145368920382509046922205552384167489217868508520726550488178),
  K(2.96983210105264691651352390528484472661247108637318131267351177e-13),
  K(1.618915287938325588240019768683455428223465709021300955696987454),
  K(9.1136629998366238955390834108458676598110335846337953540370221e-13),
  K(1.898312528883218242203944004371570550103809025903624617408395432),
  K(1.6005385862894258235873038622855124128578594633164617123139752e-11),
  K(1.908769978185407087582327705398991740282953396032069496481612258),
  K(1.76689468801117148827415317841926374795461048012252817851907523e-11),
  K(1.963792185687467134153787170962135034619884269209738297931896675),
  K(2.94683593797314940654159392433511707416514431833649852246085222e-11),
  K(1.989842908155873331953658721877885692537316509049333317561473349),
  K(3.73567013032322959674563073713275814925185323727102938355225092e-11),
  K(2.187382247946109590135399813190138259494887484140743028611797336),
  K(2.05194185650586532451294849934375653913354111945406408311765218e-10),
  K(2.296592333713209345670040890424666582796484908594135862872749619),
  K(4.9304784988962574648056285916452228582369992268004497716081696e-10),
  K(2.38132550449623880597799252255991177597139479173812855757689421),
  K(9.4610711540276397612348618006114896062472889739430711844085246e-10),
  K(2.399651505687655866381197341193433319658770509150644025403200666),
  K(1.08598060881848765285614285837060590880283502572527347476062316e-9),
  K(2.410710392821923855062255234982013200007065053600575497895211014),
  K(1.17960076332460637665640440647163809787698018501744154861878445e-9),
  K(2.416458780654849294318007280283851340719353877035352461901972908),
  K(1.23122349459213359415632779720565317160641367064724939402038697e-9),
  K(2.454283492683247719409613420228055350326266517964261609348421382),
  K(1.62792467839698164943364362340594897329153912406841192716205865e-9),
  K(2.587979742716112782572552634380562382717368922367078488270235221),
  K(4.2237521599887488545050543860967263862097486024238916487601342e-9),
  K(2.621548500342875293032360167376774413554075408073432030799413113),
  K(5.3241360401724632044476168973121194637878170736326178861222836e-9),
  K(2.643627915474421884517799965040695470355147143597467506238048903),
  K(6.1897341303184123854329948597459558131834595842276354088667088e-9),
  K(2.791240398410666171584848623230646184934558675584506068198023315),
  K(1.6413023214482624607628487616730891994946806285021752048407274e-8),
  K(2.961351913375256720424840805355868569065165963702416956490314047),
  K(4.7368343783314936581914198672032149649815157096250197114002751e-8),
  K(3.156165818394540077702964219201009045251986998294152321195313514),
  K(1.47836122772507418465475662552489005269456726223494967284728315e-7),
  K(3.27394417540131763455745279813409736286252661750240483343076739),
  K(2.83863319836587864960274129391720054108478821131424869137267346e-7),
  K(3.411336204358156941080941960501178856917558900237320521365764667),
  K(5.8883283094791827401661557898140231067609634129431400928174784e-7),
  K(3.559289308122195298975670844877986195622507852040485074984310793),
  K(1.2470273364755706324579206967494918760866939052248593202252039e-6),
  K(3.661691799122227908962959161653406482623943388632165455573625462),
  K(2.05423438129544469531451478322138493904218655227719647442887424e-6),
  K(3.768233831105595705344850359429790206528303974082218635612691414),
  K(3.3958866819933942040927360951057833181972768361625681455289025e-6),
  K(3.867727781439285080179394767316493631934985641610016291027622001),
  K(5.3509885478721486861244243062639178097478109859166370547226866e-6),
  K(3.902090002246664654300418173525278692617236821798763337963398572),
  K(6.2409648909032269755096773805177847433629710215381905307795441e-6),
  K(3.915129747293069569668259598874282780914073396293005146054901759),
  K(6.6134020180881092009104440159408669154689860384436875135942818e-6),
  K(4.092969434680152959657394691119033432712412763545318582663343925),
  K(0.0000142556432122928862697059529855822158359228016697789468699785801),
  K(4.193233746532521356761782785458140754013084091271306396330168655),
  K(0.0000215927969297916138090109807871274785412494844609969126959207355),
  K(4.246638879035810331986226616300288624599746073167506831356300965),
  K(0.0000268019343154032347061993462405866043963913452975203469734731698),
  K(4.46413001240756987618397599328544395123750046012590969485160192),
  K(0.000062417088771163625248499950241165186090639946050211807855062359),
  K(4.49329998865838141757645520189135552846626751816330311461794415),
  K(0.000069623918246168048232332678930565333386113110929711507318120599),
  K(4.508808669176668460100844447079821943191711068423782095319709246),
  K(0.00007376005954393426477642319324124051092936136827952565065746749),
  K(4.519480354973785721889469815727472208827333222774165955227801994),
  K(0.00007673616916177178617556705485891069311683826015056310854591746),
  K(4.561150421672593653366531270531894715659076646184386404747707286),
  K(0.000089445491210776092966977149269588200420602443616609033869061909),
  K(4.785820512257780537431300443065902607778519435790237443507752821),
  K(0.000197929004932687675840073233608213628943896701776669442627185824),
  K(4.826992864912825961941240734606130075021239448648674210326192935),
  K(0.000227641608931702252736385023697192023547010280391291163744272341),
  K(4.845648565163010412812756307088555437218284001167592669107713737),
  K(0.000242397949467222657849659329585741814403273529612140221299721756),
  K(4.863538606330031012608118906939663806566220502736077904362311444),
  K(0.000257361602065368115660863169880058571083911372260994185564396054),
  K(4.982559374697335848667838546743779997775736514982881465964473241),
  K(0.00038027784755254155540367969731566700711419701801960157965503153),
  K(5.267419481579821284209417568331891127206042871810193176420259655),
  K(0.00091605016454139886762509459295278652873764792893802458496875954),
  K(5.30227879865071936929877363253730736819827403087192019940580152),
  K(0.00101484006803479742755186402822976323279546128410725779114776602),
  K(5.364741006713333003431086987755411052636269169118654338312761282),
  K(0.00121591959605199092504718626540784116240107863079176846152849706),
  K(5.496024483282081334452009527689232813177089669472926897191371108),
  K(0.00175796107107060854676783407475653670426327019018631593895983261),
  K(5.746170400550550440407232730261649652106086972197118505600976793),
  K(0.0034057950900356833712186339037332195155939051242565157175282905),
  K(5.762724497907441033004009943730221015572125777879693167342233978),
  K(0.0035515687137938664976260843444182675970052297995946518727260747),
  K(6.122955727077486784457338680865576419857421309170950075144430372),
  K(0.0083686853973808678396396619620720317472676723285203773765516887),
  K(6.133665199460564100994001406978076014967164347542019084965625624),
  K(0.0085711795502866256446014534514306650646098569711946923263201248),
  K(6.19197166312584667903004132769913427987601658643883703707160899),
  K(0.0097475470905914435195004775462854846964842890953962118786077577),
  K(6.376783519131066269079708885379585046976284662998782768446523645),
  K(0.0144039336242837536439197794794148453449921229746789300954465202),
  K(6.520348035988546295821672982149257774017408945945960639339977503),
  K(0.0191663504862431275389315782258292248035125264829832524567280194),
  K(6.626468549999393807500720056375000279206727998918431661541488465),
  K(0.023442843694835734413106786775337136320103644498010650939011723),
  K(6.801433219060034397060519324248628547285049602119515019552007107),
  K(0.032100689469769283323926805902420677121221474788825105916316704),
  K(6.828306870781503381218041367346814249940145390302080303710462296),
  K(0.033623322530402960484933507132873502399735833431826891161664005),
  K(7.006804525504070255347648695500378910817369220105824850522707765),
  K(0.045157128437714575505667546771781628329375075377504153407906287),
  K(7.161663708341986633180193553118002502918125637706945956874646101),
  K(0.057289079814600324963334455998334121160907815650114205670786189),
  K(7.235824511178583472537083593325755601537588556839298973344522582),
  K(0.063832183424924169417614622381642337999247941415536802063159977),
  K(7.425403334282467613238176397554406648501411454968143456584695835),
  K(0.082751112058041521298436449733523084061270244572553163437370632),
  K(7.459130528237104906363327550125849463948415157293534429406963944),
  K(0.086444118973041112003649298989898143735486603702603706397489018),
  K(7.45926930666463479485530523764230857436469264027054017110668667),
  K(0.086459515156486792266213855896669625037925135936599528726317146),
  K(7.587039832137393092382804675739578048740662026986288286995408096),
  K(0.101314601002565686851247809539277149907953745914782251803318171),
  K(7.650749341653282826838165907451575913664952609679743484852611364),
  K(0.109209956527473061027040235454103606028056988248272690905662465),
  K(7.759002202430042545944126717843549706926938028598444468387813321),
  K(0.123309386294891503887360535779056085450143515980664727769977702),
  K(7.759844845429201143945887089647264904301026230018911979994494275),
  K(0.123422297121353114026239171172253270670735642656350627645365877),
  K(8.016933882442312442857485139426348485124303001572557739479347913),
  K(0.159724677907859447572033174991984891047446019088184516828880022),
  K(8.168213418946505820800010943379429770353544919178891021873185479),
  K(0.18225436039081265110354021550600432703961265345898701547459151),
  K(8.250011533276213538440048368028076600145247278965853496904935305),
  K(0.1945533787098119204829457153953287633215507653217397456184538),
  K(8.279375857410734505072816809353241398617285252829016931103998459),
  K(0.19896309350015471178490391649797527341311084373673014197702644),
  K(8.303734999561593352733410137503847089568821737493591561354876586),
  K(0.2026134073211415542864185925299876138966135912720492782022966),
  K(8.37413447380124748001318317519648751026349115781006907928048906),
  K(0.21309664657525316032595075395397355667486265296369868725687391),
  K(8.394321923410490356648256501029467178518068682163924702032243421),
  K(0.21607763493079817577588141888096074857498090411415673603382787),
  K(8.431400912900343709991822270136254686228892217407954790093479487),
  K(0.22151464015260007701369730059717739884124213411869814859453574),
  K(8.587823848479459195976537652337932256113348692570034726665260372),
  K(0.24368466737850806643638209826340333888764785194140128604687208),
  K(8.599039069818895793875369044653570992173526754446502765890685975),
  K(0.24521333306159227947997048696693726967180782282103787033498358),
  K(8.802862243907525912211049632952764007649136976196857769782368592),
  K(0.27101888771583165368632451954484715908969303570003741727954671),
  K(8.830693068394608108128684225096478822829338866236022926956926149),
  K(0.27419977943692402088655970751349151901788245619198674976642926),
  K(8.858340650524684030087745274367751152433192975270776936102671473),
  K(0.27726543784457695994396755759131467531528880308448612661755065),
  K(8.88150742559096051735974792204961908360150980806381020489713129),
  K(0.27975905707421784875889857043224703955330175225405398223896924),
  K(8.932070737326408180568517256466102665224232540673767398719446469),
  K(0.28495225606009008996346016343276173689262759057665880385144274),
  K(9.084337442961581677908237714314861739231096488503246553000335022),
  K(0.29833296020356448997016584069838637860039093393399559438533549),
  K(9.08775766361491440246142815382695715185600696096115690633500642),
  K(0.29859177935672863416763820185562171033476221217520868272484492),
  K(9.170388125456497785138974789037624013960591133059046233272454956),
  K(0.30424898382618611771884638228182213130077626663651164472582523),
  K(9.241032910295869186608721741645816937116977948396612500550010379),
  K(0.30814590000229823940448582351041753811573473296943754066363998),
  K(9.25630438830332763613543686245663067866706250689728534079843452),
  K(0.30887066394601722385296863355463068223170314478171745829679922),
  K(9.278610429218879076016349948372608492006281896518961121863262853),
  K(0.30985279267394230107283151470939300080764805874361412859359761),
  K(9.319294636782885860553577537703106669138048111692489685849757132),
  K(0.31140771051463851809692987306057672391401824565579538138922628),
  K(9.363655317431829899546006284343977020626105920496764233016374792),
  K(0.31275065522246853657791104646629167434433261635529824156988574),
};
static const R b19[] =
{
  K(0.2313779538819298683220146243950376903703174469557451637523605371),
  K(6.8710471184068369954747227408895035634757458976627251328424128e-30),
  K(0.2726813056233610253636167944056378820759659185795841435343651272),
  K(1.55724630651371886366517713142948515057128529043439688845253758e-28),
  K(0.3958325893068538440168135523006182682176139788324498370718043898),
  K(1.85193089397513888178678820453875990148254663813888801860208451e-25),
  K(0.4512848510433976576575675938165577076433523328834046601823505426),
  K(2.23598932913942577558396237277303080470573924472044654545380692e-24),
  K(0.7432786120612359486002812472909512651295553842289678844779550093),
  K(2.92945252873299111834805248044212196373865800740187403277413842e-20),
  K(0.8220497944201900564019750855824562701870498243964099282002704322),
  K(1.98595660742325319034206594625784477513592047928454867612127542e-19),
  K(0.8935444080566740110755446410695428277707207204508681936442934421),
  K(9.6852773787383231837256016052470601827773722594844292289005574e-19),
  K(0.8971863085672144855204933639524068884554546651243336854715896725),
  K(1.04634641414996577199800553615744128102475083864154852070217004e-18),
  K(0.9840007066563417050318706915563032817150263306223515954402431871),
  K(6.0508749099837788086605252803134543546141657115287871890116501e-18),
  K(1.110586818712873138379700456087833471209904174099120338126416898),
  K(6.0311920351189662940040019608275832040864380486183757781135948e-17),
  K(1.122941754640177431734146632133876216550515480693957362175128478),
  K(7.4420530338482112106703534579630820024976355075913496410594001e-17),
  K(1.223169849320621150974594676134595079712413672281635096780227483),
  K(3.77706064729834350181059567552206589805721876520069315853872494e-16),
  K(1.28434806755509329265565941800290285374989336063844505698922901),
  K(9.5472297622828779998595409983003186271958967600618897812460572e-16),
  K(1.397261820183003119725393244938920198470260855455703575649490743),
  K(4.7335114375045010874222621276559565502576696921036029052410257e-15),
  K(1.468143714488600090382131928811079893390130503901665681682665024),
  K(1.21201559512465671346394399975542590511698225731879033840469379e-14),
  K(1.497766780918131339990737174862454828192005736943328749704986588),
  K(1.77151592091659521813059516979667064252647324945297805710650777e-14),
  K(1.506394247512690335071413124790740709900236922019610432384420611),
  K(1.97578503995004860364474458975993820871036949707705642260726552e-14),
  K(1.546215964815288564213752664662603943410608589579528546326996273),
  K(3.24368195587008849160833887624480835954681523405567080380825692e-14),
  K(1.589806267341319220527012989886256897362722968692964106749371124),
  K(5.5010451761768328276111452614384022134417289636625444287598776e-14),
  K(1.665723435728445237039514236735756476038853972807256118047061801),
  K(1.33462780571002181298511143423581604126841122472727933097435036e-13),
  K(1.837822041186436116409586158750305448940484748662356206191451043),
  K(8.6430728681198903315591935715072381344331376771424581197401186e-13),
  K(1.873491802538075136085627682552402588461025609046952584686725756),
  K(1.24533196697900549788512572603279603541839476427146586173275284e-12),
  K(1.890658852123744642404797898996200116690132654983231927341661058),
  K(1.48098381710763020399891590393205757392256025756661579386177032e-12),
  K(1.935842994411178060487684299240727940364621138209335788202465407),
  K(2.31968566277059123137117010785670750894039454501473416739543932e-12),
  K(1.962662112623721537495402532417878422634949777253405155111708289),
  K(3.01272239845821427567500905633124995973884756052568670134786677e-12),
  K(2.097123917069122326045338242362568479019071992042913895875824769),
  K(1.06102102958417121185070481685962858842230121948379809359749392e-11),
  K(2.109424095238649813491616096624108773991782267875905313935272641),
  K(1.18570381586640975185251848519617823261285001004675086142030787e-11),
  K(2.174925416742229674292735322121574700475322861084572431495447294),
  K(2.11970945445786275998097394335494103294496013013061963225237683e-11),
  K(2.413416827355411840510320487902982468693358793881786185763531458),
  K(1.52962685115132810436966729301781650810489874131617684213399157e-10),
  K(2.471526846909653317823838685938308940990950319445130318929791145),
  K(2.40319655088614865663314797986569525021694858064527643218092221e-10),
  K(2.490835940764306035242567193187667347109828033483200448565635101),
  K(2.78584711498406629096766503420646775810893814358717773834085429e-10),
  K(2.49465518168965770123624703639906550435247840558680150609153205),
  K(2.8680712749390459025875777430505933048536539520232914236333944e-10),
  K(2.531310890950104401732737929886437511520761914510843754375322825),
  K(3.7831236892876714630024517469987224757550593172688055842506424e-10),
  K(2.553318872289019760427681678971910308884690950446982823939035178),
  K(4.4587445821407938216561746923592032770053597380408658731016465e-10),
  K(2.85149752207484858697743793092413741411379170937278974528133904),
  K(3.62169999699655594176784156781856596196290002563910496260368513e-9),
  K(2.936819525990639207703270223813120811128449911930646569813358758),
  K(6.3295260258861236822344318920332144421642945937501276794184885e-9),
  K(3.028212530173204540192283274253173061648006562714927567070827213),
  K(1.13017340982776304670253760852762568439002354693754834032013425e-8),
  K(3.245859133395083065489837698831545622848184402519945467511272075),
  K(4.1894468714939488084869815066832034023518826860162496031316823e-8),
  K(3.385988659753590312372746040069673368655874492901235788349387337),
  K(9.2801036910863540563103903236864373487928124585087803951242683e-8),
  K(3.532249468922099481641000436591775993372514408844628309938557941),
  K(2.05130373816363653853757540834830926333087808446007237863343721e-7),
  K(3.566537120161706988576622691307940870459428840350292933030994789),
  K(2.45774846775560950347960058961153677099637241843316675764653402e-7),
  K(3.769695050645580802887186093579026817722912356643054873736686983),
  K(6.9054521347815322834333706118691705861503988757685974983177223e-7),
  K(3.776632325764919872325964833604330160050812765866360012078211862),
  K(7.1454777996935964030708443042914151214273718848047548025032967e-7),
  K(3.835005208799221671566052022873606596664713735496166059135034597),
  K(9.4991036496125224875286654371588593894174268723947424932156842e-7),
  K(3.896454054236128837470534417773704438580836317564454456573215526),
  K(1.27512101784332851787825110059610387193563374012636461736293658e-6),
  K(4.018359938640513022942075360056879165494340999403785434264184341),
  K(2.25148897387425259380024344197833103959390651538568774645030331e-6),
  K(4.058721077789524358075301740733505318725047443645218299858551143),
  K(2.70581531718400492991430792722604491601480568890783515546027086e-6),
  K(4.139745799342993562634466028464937594949041226485205935596384561),
  K(3.8882408721861140715061190106189514610967536820307761842057567e-6),
  K(4.170264258210862908237856031243007573433972727729228640756759889),
  K(4.4474221468870165581429413330123056677082424030442388370811024e-6),
  K(4.295332415628712450925886169688577289091281622537547808694914231),
  K(7.6202293173259795970256771801523663564828508565956278139300912e-6),
  K(4.334942525023329436616060603941154387378770881726291126665102429),
  K(9.0012061348540278810083838166332705298056870346680853062775658e-6),
  K(4.571359683710156403909863664359463241582120038438416852877339105),
  K(0.0000234122409774049358366974889628265775865415599304384803597811567),
  K(4.618382260471092434028474043497423563488435951461114758981571982),
  K(0.000028102200793569747005637839589628629624216911810639996356456297),
  K(4.696576667166574455169492695938754747045993957875004890738587992),
  K(0.000037869318968809036229772262606893326486501428701008945318228738),
  K(4.713100749976708167048672200536414425250358642135758699238687223),
  K(0.000040299360014905755609214615744209569890498766868764533196186611),
  K(4.869108335340667863766488255519078105882387943146401799728979841),
  K(0.000071478765195529848989553608550806514595534059612278915614303068),
  K(4.896560521450473433994143691063216340442095083337059291044509572),
  K(0.000078857801582386999485002366647415366300309097461297865714046833),
  K(5.193218587178450508964551539006567099755805420481456505146028689),
  K(0.000217421980439709119359699577826921332934175827032913981290626133),
  K(5.208772494185006103451082332229690007381317781339615562835332697),
  K(0.000228762420125824012557367758965034608011242210895715652763727535),
  K(5.314002120775640786499217758161269152362751604577745254292715576),
  K(0.00032078466611597072446785060733743361430473549321168058019891422),
  K(5.325612972584288566400796102345176238477344655412336950261835203),
  K(0.00033276976363241219318410993804286629418142960950035174496849423),
  K(5.370964618244204307893574371883532502865677015507537479789127102),
  K(0.0003835818416652820382923772247183713998062972661161913610258034),
  K(5.424788640410623056072937275162353881103611406897007858543738232),
  K(0.00045295846658123912939240251321453883905298341978705854747712548),
  K(5.500074301550225432550819711945357328910908404040890863408380539),
  K(0.00056907905419525133924856001625788185631061649067475164085409468),
  K(5.59062753617014423957721686820580807224718130801589761483625011),
  K(0.00074393477072584567393613485620596323579265989157591317832410394),
  K(6.065679578228151478630373052429489493084238604467470377899514735),
  K(0.0027107464613900828162622604185471301930093068859044367226548593),
  K(6.075335646027678310334017357819712192991626835438269127261144311),
  K(0.0027776779781771230777547774855862759527620098644280818461151343),
  K(6.079851564924515412090370188881168694667516994658834961244744431),
  K(0.002809474459441857925431309135180307361567028008053680929249225),
  K(6.282082480360008599181554008378385487841349148997861280035767496),
  K(0.0046020418460472393895077629318918540877570070085295527326954411),
  K(6.348330019099925872585592066893067264251058187385554116024611234),
  K(0.0053729094488168734732954439002133278709698009540725659285122442),
  K(6.395545440866846369390429294891099371828491049076139623467524711),
  K(0.0059878616016260481735336859026640954120311023101968356132205799),
  K(6.430908355510536418300462501977645972944751308125807174571565239),
  K(0.0064870476759325465803908760755984569517077223384717873431534468),
  K(6.485049813843482892270121436450887451657753991625485077168545965),
  K(0.0073199755000009486804577217625294577569455696159097947672046819),
  K(6.490742843621810773371458088545963525676339948620664469197788181),
  K(0.0074126175051139602565010281839982409123216109945667370752151513),
  K(6.873680509423212631926382280551166707548389713580287282588095681),
  K(0.0163694076538200324879909988876253620699623691036646437947948966),
  K(7.065443751107605895420480252804277561181830343362992240355841396),
  K(0.023414463721755240219641869946294984461571919283540663041880993),
  K(7.235223100007512588376337473113848917920004279126683811087269736),
  K(0.031478497753961305264422762047393993665777632794722172786896942),
  K(7.329438484230852128654618840738757573149710720007528727553604706),
  K(0.0367886210350045696152057852588912020475874596461869090946995),
  K(7.431862809993552620594543823210458273489348790195925490916878923),
  K(0.043292583408839677171340965531056567110114659693805114875444246),
  K(7.765739710876831116071903109050600880528949874562133621672784368),
  K(0.07018953414304527194444123196648243417580737984672970074770252),
  K(7.943514631747740586737083011322220069561465727707094863340574686),
  K(0.088182031375577881411720970568665691966725536281585557953809041),
  K(7.945508951357952395009054191683232781973811150088474586524496676),
  K(0.088398077634149680178926262681236617257717709643544207577410014),
  K(7.948421230297634817706272664977463865761163135466451227996105101),
  K(0.088714120557657319965161051687374841872856960526696429989148574),
  K(7.948590698296375882196744643319731102244647118552298381609767117),
  K(0.088732531574463919096004203757376994408265284585908512582322049),
  K(8.034261921219539118495809109016763093986481346390003955316664675),
  K(0.098319953506971769896169355959077184808915562359241438557115457),
  K(8.381033026960014655186353702850513468969357098409938559569737324),
  K(0.142172896647630600281432786697762800845712529999717406865438856),
  K(8.391698946237925602085614809346864395756582455641193255053093886),
  K(0.143626715481732339981903108666467390147372275136817107652391033),
  K(8.509223237742272805228459527442073303412764595410485676938298179),
  K(0.159930406928366312251464915197947146509454476244544261454010815),
  K(8.787468216818310881469801243967501592574025942229381797443150803),
  K(0.19954870885275463581972466553135882489787580690637387913929841),
  K(8.838387717464151459427999105915975981173960115617651116924184205),
  K(0.2067555664796886164862526093040892782635843705188139256184753),
  K(9.020446213482600980379799637245541533017495989117160292208924285),
  K(0.23177564424180110865012401054867953979825437264069646736932163),
  K(9.238075029764871147293809438135951419766095613666817397085888179),
  K(0.2589363320577390960426819549880415370165409241482848338462744),
  K(9.394107862065780607944455574212679594365085065415081967695392342),
  K(0.2755796381776194217037353898435668368665177049590795130832136),
  K(9.403826021587968591253730621197646260581189211162999416964048599),
  K(0.27652027359613713125485350397663895367063303018148115948063762),
  K(9.482631429611136329386843868152715132200726315690007534480835563),
  K(0.28368756257666842735397650339277325496549956381905687284441628),
  K(9.57384158600676677298307118178557408811207189369239114981258231),
  K(0.29089322563189475711791413189136847511424505388941864026559796),
  K(9.579496713710438370446410142219181900623447298038708716104741285),
  K(0.2912993442390167865014050173389224726817132591409128284290247),
  K(9.898805381352259083424177465946904379150016286662794850386098489),
  K(0.30578025274067965452362363116732089155956609578823372128238929),
  K(9.960928553383381510479665714011963995914436139323305122378680959),
  K(0.30655684976209397316743715792954180257778695782916013519574044),
  K(9.964891506501849562152341355131103093453453524062857913475285611),
  K(0.30658308305873430711164369084632671531810192069465780512366751),
};
static const R b20[] =
{
  K(0.06693387991463429117635769350767557549474040989668372479857769013),
  K(1.33904566345431018596817715662430463161069037572173563051788864e-42),
  K(0.09191165494044280942507519445999807292932193250502492228205548979),
  K(7.6082907851079381323380645373470824429960065458069620022631329e-40),
  K(0.1541140568469985649805675406691426707513940207616777877078255059),
  K(2.3481208209275345707340463893459502552586503220764485070845191e-35),
  K(0.3316876470315720622230231462828630647405065089120926763987908541),
  K(1.06772972375507781384819612073456705334833528175744369428025694e-28),
  K(0.3768286377087641167589986421488913518169115719800941594298176973),
  K(1.37010354183006980673033718073706450410370530402590516817587421e-27),
  K(0.4637716962358066047497169690475490097530412736978685023720386922),
  K(8.7088375525696066421739310573431557229106235304269602157773297e-26),
  K(0.6572029687449870312809746787292143848653492981756738322797280836),
  K(9.2867919176545260485960464963326057290495420298818135971840877e-23),
  K(0.794557373865493113703697860992150736264132665064722379505369508),
  K(4.13409671458884050910087156049208375658710955034095335330384227e-21),
  K(0.8302037889830763267975402973946162383596586559051132075882397008),
  K(9.9441943995718117991229334257785368764081153927996835077264221e-21),
  K(0.8560415428432238372524628872087803943460387388017401682079839855),
  K(1.83557529740841527446844605209017116897093841436662067765789282e-20),
  K(0.9864600625663830815638886719168102897552297759459177960797975226),
  K(3.12943206751661501173017659022057337234746071022538624427400709e-19),
  K(1.110885514735136673565464117847780406837863571443848831601669169),
  K(3.36714222189982446470995267699085071830640313567303017565996191e-18),
  K(1.251807001539310156674752299670646099332129298783660812869950874),
  K(3.66963533565169687000970714500256120006246875858293354891478457e-17),
  K(1.28275456613850496013770138853585426962447470186309894067611492),
  K(5.980627704588196306781198761461955802183351187329542573602792e-17),
  K(1.391538424886067422433958606252873025108821460272773848246662981),
  K(3.04634752151142961858540666346085269333990947077742463046680886e-16),
  K(1.536429783617342953094689030949554270101607138668046512453797708),
  K(2.2086643615287764327452966279662388522117176723663527214488029e-15),
  K(1.549660013560116437373301577087544863913072912524274156295828524),
  K(2.6218262814049174498715745304909935205803990693022565647808231e-15),
  K(1.576104424355645610772290692971784298497974192293839873376969055),
  K(3.6776900933742591448770185379970616659131859451394989442496041e-15),
  K(1.598332121298042701874012934333374409591522471539253586210440733),
  K(4.8664907879004350811588441184909988919625742787849800632057723e-15),
  K(1.680955194181074458501410984840262260319369909431615657122468607),
  K(1.33351530222436365873869417435457038321406537547059164420134631e-14),
  K(1.817508119912079717025454674251844333340813988671465523360954438),
  K(6.3591860470816449331006039923860858721254161981648634793385357e-14),
  K(1.82670708438203343228991190889679112495339386103769177894289664),
  K(7.034811415820125498939075969758474392897947610003867434498171e-14),
  K(1.858840092508442215407054806061697562263996334778535027787122582),
  K(9.9704374009217904200433980207109695054544469548584596840272069e-14),
  K(1.896414134099798754733737380182452727610695107444417064594909135),
  K(1.48777146417846208488673637031014606770815137087847126500291724e-13),
  K(1.957543932201093578211890540069919454356359879760086837565403068),
  K(2.80608048361463031712022554486048755165977402500583344655201067e-13),
  K(2.165397272924951289882918037885554249946767706078401923122045288),
  K(2.11149075066595268717803812107424192577447373631791717184888418e-12),
  K(2.192329740699013232711029708089259279837432483839902751006309291),
  K(2.70362302345598491244546425270839505821442740427954612776183642e-12),
  K(2.59585766964892993038088989375077405805362862268891751466907959),
  K(7.9241052870341682012835804928205869447741732035913969260183777e-11),
  K(2.609061155227761152663646481798264412532834856122507073786552315),
  K(8.7696525470053811478696445652559428936690531795432287139362394e-11),
  K(2.645745682408728768567418011631018615169234111269496812789803118),
  K(1.15917980543331693070333507780513819633042001732659014703951108e-10),
  K(2.673963151340306052612905279693712634424258049298908075982804683),
  K(1.43285931479978531279740252338446646929013554573931020828905194e-10),
  K(2.688521253383080746107585855960448873251292211128743691996663751),
  K(1.59702811564170840967231719206670572098532779827810972884018712e-10),
  K(3.200730132010149866337823983608207688451529103888979654992698677),
  K(5.1729827571166412530059064814053496057499911020146738493189384e-9),
  K(3.240940205026831309780269308104288536028774497142197711125124218),
  K(6.6308248873339238252206276877300139579275927733505708504695151e-9),
  K(3.263017564673583925094443369631950236967574300092895869058618369),
  K(7.588867906162644999690939782590291510226798592465942923720658e-9),
  K(3.549039381760414927143120538050957184542264785231723204175178677),
  K(4.0156244976079178802546843882233265184778507587882386926636947e-8),
  K(3.561744768826738449610201386077018523720233584897190699684338688),
  K(4.3096092541684402236630904484699269124979734541187380894206405e-8),
  K(3.686555297017824603510412016693164329631943757159364305187463083),
  K(8.5058668504399743167764607915905614251117158010126717970422028e-8),
  K(3.779265621856937827388227012999936897350389823054084129642003301),
  K(1.38701089455281981743638450430500276730046928202141612739613759e-7),
  K(3.834024440206186267349258888477352291347199752493200156998521061),
  K(1.8400414036823185322131426006836139076075251148708705670419141e-7),
  K(4.014384739700590977546321030600325034332095055974845767528834953),
  K(4.5255993360743631901591687761724152178574937715914089283655852e-7),
  K(4.099673291456794198898093995132867491528377134735437426685404353),
  K(6.8174227643366867038881356854589186942190881975876498428461335e-7),
  K(4.256567168709192005408835046246274143791293910633592631899756463),
  K(1.41265361956891574102108161773286692246357163683995943762485659e-6),
  K(4.410065430352607890045920733165384070149128120916548002534381694),
  K(2.7960728535880801507908702856583355193143117186902506127563626e-6),
  K(4.854733347540158416037283411639765952369921668466443221948095891),
  K(0.0000173187926316630848446063633867704043742724953601450091517342661),
  K(4.905958629243534049962661297441781847911465355094596903611411846),
  K(0.0000210752071689192096707602075801749655068756757535303102965658208),
  K(4.936704922402715740435759903068492641120767015522503497810968977),
  K(0.0000236798826373592625737650146713487146471585783596339409714561315),
  K(5.034239372286265034496483300150077622501519759740319026892922414),
  K(0.000034053977861753944829316485115995866907237408883066330186573451),
  K(5.281117384501575369018524865531718852246999773682694917847984685),
  K(0.000081934822425828837232077933875150711166167001025179983470424672),
  K(5.326186311053359057271262292218340865596889667005105268090950624),
  K(0.000095580334129979665939072113504181289982953757830233765731080873),
  K(5.375276846150436707776648425563559009337470367610047512611394486),
  K(0.000112800985314707867540133533515070464713550241043498045966379532),
  K(5.46496634893956295645954202263046827979842654387593694451002427),
  K(0.000151810096834162713840393748218847011015201384909093655398183433),
  K(5.717025580807455442119771738570960307896000615241637528082987648),
  K(0.00033674016293936158083354199215058253872293081779672418040453186),
  K(5.772877039849762678596308368206717736345334555992520989217758124),
  K(0.00039880313423708825345007125561099205785456700856783065864751423),
  K(5.798716172879271834301965172656000778569476557075857607174419129),
  K(0.00043088546441842339173580369316372172701286140569190418447229874),
  K(5.834196870388405239218107995290085518382130063088335943085843469),
  K(0.00047875259673310055325603828974311283026571765426644438781079958),
  K(5.924328997008085451836017366972615049775510739678431351179716325),
  K(0.00062273864351657969430076587846073692360162927116510348325703681),
  K(6.134491724819840411450893778311254332232737318114879146908309348),
  K(0.00112082604193193748407691738014782369789396760630660289684758001),
  K(6.166295060732082851712055905165823337603123147350133955856985352),
  K(0.00122135915479645757177658130980815799483033063775631171013448111),
  K(6.211508714819721421904790915372057787340986888044932200516637834),
  K(0.00137813703666137020318427225631592302162061737612694684485864733),
  K(6.335947887606084622612079302033376133443777497180296901280248605),
  K(0.0019060348972865908762965660190378637383885857694693962253189768),
  K(6.361752502561324619012043844894096814636560043300635272483047372),
  K(0.00203562537489666053161473749203455197361358071008585444799883594),
  K(6.38892695618233476433893314930494484653857740231169320950833601),
  K(0.0021804525730700147644342175233240796370930373572973700223342933),
  K(6.404963777297438472691361759428638918178605914354302739109898197),
  K(0.0022701218051866818128406191234869298722517723971366069990979436),
  K(6.456934621890375649178785796304955542253786168736410714041795637),
  K(0.0025834425538616533694662659649327475202553492360420850368037227),
  K(6.538328902067238954953780622584219185319519909269571353042259525),
  K(0.0031506309109376603204374247106813415443346513772991591089533237),
  K(6.8666781120250436932864675319597898682130116864930082801705974),
  K(0.006684318478555422500364198951935845504121476930019118904930472),
  K(7.078267593595536504911953565069382946599855318512237401426702634),
  K(0.0104276457131759883669582766420086471864672639222430370894559109),
  K(7.156417874314012101111820578278668666775501483662038254180738231),
  K(0.0121946439260658509508134399418631661939488255833894933252670183),
  K(7.188530495551626969760762550030477551944395330965347921608325709),
  K(0.0129893426039536131730523478172169577319729006962834111668150208),
  K(7.493058536856920576368034420090084217114728169427678694307689901),
  K(0.022849588688123767649541249600440431771672515538962033258584633),
  K(7.495639311220153657347260782641653192522805011793943566164969343),
  K(0.022953283130885043396480950117561443065242358977832734626129112),
  K(7.574519464677664168448604485032685032353313534528605257414883564),
  K(0.026305688455450444437695841202544914165887296536807904609346295),
  K(7.587027730540835907563005729004100796728991967564570047604621187),
  K(0.026870684232283346041111662291482076315989591361076930399103344),
  K(7.703581459468365087097330235953274831803807379564043765098647132),
  K(0.032598344021760340454610506800724663647729421298598480497554738),
  K(7.817076073201509935673648073788819568397150876652876850522368047),
  K(0.039023565652032293486514924036622462283787621114184917207200028),
  K(7.996779259339933344875120408239423035435849436234208407157528136),
  K(0.051038680602777861816943112137679990290350546048419645737251086),
  K(8.03520466325961067252902989582595723002979757928586920927773374),
  K(0.053913992607933519800270021288172208732251925606983815758506363),
  K(8.248451290840668903082329066010968033292881525459082755970859096),
  K(0.071892184062785359082061025472027822562760661636250266885561929),
  K(8.266805447363000350440099042656228165076742408337737208034456939),
  K(0.073600273144828355953437549140312587820637571730928409016661628),
  K(8.645244134196102759576646482916776212331196311616100429818674619),
  K(0.11420347636996690840772488109300976076331346091415866213009415),
  K(8.69189537240802829187600443903002413263147805367453797917212676),
  K(0.119854617528754692517842099337684994926876502983105017419046081),
  K(8.791070207862536115994916984521686661958918245060668812825053253),
  K(0.132254424777304869184097513530318488035600637487145969288388575),
  K(8.902441390350750634183530699398926740171744033920695666355842091),
  K(0.146710641032119703373063179240325788296209074084306594102259016),
  K(8.946066368149110141255374789003126993558334325091828157861335385),
  K(0.152495980437245607773179805549103742009002596085560376825061123),
  K(8.94882318294187351099339040233958814697755348852280760454510935),
  K(0.152863503856562001911356591924986357273307214548792901749699905),
  K(9.045501250426490281351414546256922241736107400096955808602255945),
  K(0.16586798905414171628350597163902128373325069028237153059559702),
  K(9.085415454661193674210502232564917455035986212721683872369682426),
  K(0.17128584564266298912969834325664146773674387393569909325326193),
  K(9.140186268778399412875569958126137713519575856592505891497985645),
  K(0.17874367752833303302483739386630751791739304585568237365579463),
  K(9.173215567475144013552166732861032402888493475489829446009003782),
  K(0.18324510584198044475928049280103838555826240069513755971745507),
  K(9.297992068484677157752446669733307449912354458329340628377895651),
  K(0.20017053305983903463808610370032245674176458235909487343201987),
  K(9.298737045785000099191124099470686535468146865885119803044070288),
  K(0.20027081504635354938178807399012377534401869828010448929167785),
  K(9.31377982960375102737942251595239144224438724501793795611792047),
  K(0.20229287524469512399129809515470767359837137929118974439934096),
  K(9.328337185305740915697863408230054991243396440821745219448002071),
  K(0.20424413375681668868346425235570881505650892560999481048436523),
  K(9.637528766868643554839499739581619615996403025250462853610987455),
  K(0.2434472083801837366819208296175380430135995579798766585656389),
  K(9.661320969459944193063096179769127285518925722436677603881452533),
  K(0.24620868225000058825484863489380756570193711799089170849455201),
  K(9.788457462535254403988457761750976997334520782904728859578414864),
  K(0.26010104017370757772067019166981554896421048622291567308438225),
  K(9.863217802684911629052008049870213144410894225992478470256855534),
  K(0.26750061651240669706473122981094623515248409954537971886042914),
  K(9.89135836398199294968293418159919943542352091271281998274780508),
  K(0.27012140215946449289506499131218500101024138401481622522563371),
  K(10.40973527707881747144219832914017592699437176923548667079740538),
  K(0.29873378141936225482820809192644127360822691237797370493404394),
};
static const R b21[] =
{
  K(0.04116874656991056838771429831202905582818993720221644339811403214),
  K(1.57607407380566072854597901087783946157880018855578175294431793e-49),
  K(0.138472041319277892473847236745835318113210290319204716956414282),
  K(1.82079089531426383939338955807226676483718002649162880836833945e-38),
  K(0.6160271608319140588672259923513693411302779885286212333353963954),
  K(7.4688401473136373132110380138495745599235972413401139707666811e-25),
  K(0.7047955844985323714066186579853364881520764235075794044669281857),
  K(1.26177742982691783011920614094214553308767583471131482678456483e-23),
  K(0.7264158662070871832227182866002245761904634244166069272441105379),
  K(2.37984042456859225207060137610751693440093126322337005139750162e-23),
  K(0.7723485413535384460556675048202006020309808945040946522874681793),
  K(8.6245418258263024535477270365726211662694245517276677979383049e-23),
  K(0.8741107598502274037156135630439337456614483371986158068626623731),
  K(1.16025080597005673058717776870477952807933327415234063806194474e-21),
  K(0.904122689568272384273473734870035940782584346885289912891986751),
  K(2.35738666502622651944413047368009171506382364964804892141256679e-21),
  K(0.9473605062218089615534071973853364631201920804108844233772659775),
  K(6.2874838169197577455036323215929797617400267634838264907330029e-21),
  K(1.040837412559414410236354251933046345017474340236049649830477471),
  K(4.5362488481420053070726984809976409069291416165444099338840097e-20),
  K(1.149912437839703856454747883775759272637901661768294404509167298),
  K(3.67803865613686971661326298304679619323412401382791136209846444e-19),
  K(1.538383976782891742291453907131684670247378303059056533463941083),
  K(1.65964724690025377859631582903236122642967143330721525612437192e-16),
  K(1.829808658602233677300929314840887574319033571006245274336364379),
  K(6.3412481253082856927939286193769810235101773678508864849923906e-15),
  K(1.86027883998567797619635994979651507066956937525502965513588589),
  K(8.9700357396696253381988773046051527065537486809610214006736697e-15),
  K(1.958171915532874453358741481073096805108892107969120476977830413),
  K(2.63342140798373406628915844072252077033226155275985046580443974e-14),
  K(1.985853258856111134450203577823563208511547159588693517616887342),
  K(3.53624543482052003520698033124015943389004966889232377810235604e-14),
  K(2.190260916376792743024768602266999524362122772533267261131572939),
  K(2.76721442955208944463090514884915569707889611675125068868119242e-13),
  K(2.299601312390157554415116360304546143521086258836517583742668833),
  K(7.6966183449994762977126523520411188909333806200433217191536892e-13),
  K(2.350559688876424787731559810839197744106816916390927422550496415),
  K(1.21946300950984230537509199069022255339086174678991469069121488e-12),
  K(2.436783725584461514702223384735072610994191159219828523949560294),
  K(2.59816936836451733171692697027335091766566244953968456553481337e-12),
  K(2.449844890534501172238473209253011482221906147530132933230830381),
  K(2.90676124088425764915659882391193008169885330338627671728331777e-12),
  K(2.595491757404046757926689852183353595043331438439918861182466305),
  K(9.7705731446289718489260826658569725823024430567631919149185271e-12),
  K(2.647784335130816612686510588106542104946892402013141307355151971),
  K(1.48504362605179659383271237148778185729612941271371495096147717e-11),
  K(2.795904780230947042977849727024838668249100641941491873785466563),
  K(4.6531572842225427206097196596900164963668666066193990131287503e-11),
  K(2.860784956711875664457027845431582647810731224391991892074185849),
  K(7.5283905789932860406087541430764429528264288839646954758637913e-11),
  K(3.010211200395874829893643271258907150406100001525534178508080212),
  K(2.18878412099159999877834404085204119792204872477902822214494512e-10),
  K(3.076844057110073127710963823721854997393443554046209148018419324),
  K(3.4624086899120420031893741131002388103206306643969779334934418e-10),
  K(3.249089016825550203665732918686708981172289176553037206212675243),
  K(1.08245303415716079837395658936923448395217342228969521740592634e-9),
  K(3.558054857815948359966186444923215997587625405728420940929853096),
  K(7.2056242475748446004572814924181109764823953218337501339968474e-9),
  K(3.576457384204855185847694933341651172656472600897324901574877413),
  K(8.0224805825352628349565290815824599345125032754089345054561649e-9),
  K(3.607697279035907008598905675949951561105100184620330053011016533),
  K(9.6138706294834384895591978697577336567496606849345365695769757e-9),
  K(3.631335808283560435012087208303361450892779699276184453023191689),
  K(1.10124777104343431363081404358679995579845997857831224163887822e-8),
  K(3.847245268448686892615733341625347942030792177853559294239150848),
  K(3.6500378254860810154900002085016250268615093563248032002599776e-8),
  K(3.994531860301152693263848632505861684240447283928042590680141131),
  K(7.9318936235433507048951434067653669274896365047108731282102771e-8),
  K(4.04743072944916307301596874970290237813735380236851390290880376),
  K(1.04015379946182282036678884611884339052498497099196597212772572e-7),
  K(4.094780199031097613130418420302657353595434831039189118860300409),
  K(1.32135580152196423401254273792744162549529613870867746109539416e-7),
  K(4.168012297812090596290433745411065104891296693216678795686961867),
  K(1.90157933656640847608226174658665541888621088835923652221616623e-7),
  K(4.236046417756868219918967689885360192976116344767639476168191015),
  K(2.6496527881474154717253371776732772301381171336984227172508702e-7),
  K(4.301598504344330602038598735049849159263608751760726323910084014),
  K(3.6267924831721999785953274929096265506982568757060376831613414e-7),
  K(4.41937205147867143554421427207848175632943486087733116163617767),
  K(6.2881587505800061882118261997094501376275115532439413699473934e-7),
  K(4.674735527858019611356744795105623716517796001394006559047658694),
  K(1.95798237133941527522266096108478051614584376730233346383797171e-6),
  K(4.687283492214188614709348194423445481006360955239189276492510576),
  K(2.06635571539529360188798805341033196472939159317990637736863703e-6),
  K(4.713946040078945165739269081301435326206219069772155225660189755),
  K(2.31560712150457337627494838353070231198328198919528667775515062e-6),
  K(4.718382062078471977259372185654309572031186659274022331309699773),
  K(2.35972001818203343254781456756789752950210344964981745685818138e-6),
  K(4.799842268364887640530481205939775061581104482472475052896141431),
  K(3.3241996189488366879238159822154890493384546688473605342568913e-6),
  K(4.952640296516245638363213725508772014359040457684112363077509369),
  K(6.2014736722074374348306007658600316897938482860142569590641093e-6),
  K(4.987705600029692547561973511869969138629393547594546554547625195),
  K(7.1309093404418237784263814193251780454518800433610510893968287e-6),
  K(5.125626056316215687254909206229417954550362955666629863057879993),
  K(0.0000122021965824941616750660761501654136641156189492385837447759129),
  K(5.157554170085638958749854662539609644848392541414633859394088744),
  K(0.0000137807069059512452614501248867928640940194415890961214038993309),
  K(5.250725615068883330520669483856725717464706168079639205208933265),
  K(0.0000195427254854060638616165632215948732086479759048906369173883928),
  K(5.276899928390265647808291097524570978085058324203484114587764689),
  K(0.0000215255350703004507691650909023349248232238956316624612783541449),
  K(5.323946094760213996870674918538820352773470015838198802300294242),
  K(0.000025567077005199804378823393139103833943099084445921491966651344),
  K(5.340437783452108893389526576875605717111043309054675013146190875),
  K(0.000027143275753782340304913886885979972743675381400484840490662693),
  K(5.482087490170912415562381119750272248716573296110135394941824973),
  K(0.00004490790740261714257106003909383641576859556106816665936549089),
  K(5.505443084901600940945899239622147128129222054228689348084009873),
  K(0.000048709526267744186252501016265708564295051248668497435489554554),
  K(5.507507458934473815060246235553815579541566342400814160378722004),
  K(0.000049059486836771506328407737468696202590051295824726264094899635),
  K(5.595195557233422472085093804756545358045147315257598221715728844),
  K(0.000066262025946443969848911898214435432203034613227215617058088692),
  K(5.779878264180336044744853751986205351849703487865001854855945946),
  K(0.000122086632975600740860385839981434703149667078912064749835286514),
  K(5.87690144299072563554375901185706176685664927879719718792648048),
  K(0.00016636236529353505528921999567115988093217432487735323785413511),
  K(5.899706444100606758453536146399261772526131615839196681321626222),
  K(0.000178710014505234443376253866773446744713977579240542775485918032),
  K(5.958864083639736843418960174622663338731547817915683517381612671),
  K(0.00021475502712584536368305014904591135131776924027998315918713976),
  K(6.120942082772595034747790159036759911046657609129078318313212896),
  K(0.00035016114950631481367102031095813404386658129486019581418651575),
  K(6.196356419205536855970445924952029368633298371189753829967990695),
  K(0.00043649381774025620907914763721043830070950054392562234353442031),
  K(6.306230394842916749903901360566128408977677874427380081297267913),
  K(0.00059702395607234771631495036877378645813518978288713686471280425),
  K(6.374381105873107042147587007054831512257748844637850134152223518),
  K(0.00072167687744527328295098013406376287562808938841688288102381984),
  K(6.570414344993508954997208895112451484239810002297026440595164689),
  K(0.00122127524121984655741546291834209559779514220027076372943881207),
  K(6.583675684959070983855158293770156159241433379607465649055897088),
  K(0.00126422834741460377303903309571390228278867693115314715740275824),
  K(7.066439521565767858978404030094023144220122236562122973528220883),
  K(0.004086946171167768556186613313475596720947530508014061843325137),
  K(7.478299440376066887312833049882938708611163086881446149625431477),
  K(0.009811206590076562069899811185819878992627246341428382169666501),
  K(7.580728851225521005830974648834764355015688487098776997721055679),
  K(0.0119912060620632496337024476935311319641528678653886598605998307),
  K(7.659887543973371922922510726665546884079541209373120865071209523),
  K(0.0139386777042815789011111005293516503828730946910726050602780325),
  K(7.785693337380918664306269091637650459415238226473915930992291596),
  K(0.017562061684749531595528329424089707871424654867873786617741662),
  K(8.233488437139746682125788112202373274858410677853713644554422452),
  K(0.036939505033331109554511227218902876240459835556935078952443244),
  K(8.233524777879634180431980792062402293286840367541879039058041106),
  K(0.036941552701820765527249300969405448495663438159302550250552242),
  K(8.236391347988304665944931401789697685840176178761807128491200021),
  K(0.037103339733214711199355790859137390422465427174626906330915998),
  K(8.25565322251165685798118902986852586135650419438043621369890325),
  K(0.038204152592634322542246727823964953871085891989974455719494538),
  K(8.493305072770336477588071761974499231639754078499786762973231509),
  K(0.053819914558696159384313892854949234328044437257508168765246158),
  K(8.660975887860664746596985358948007682045266340508703255132992258),
  K(0.067194313641489406500121257905028409868846808889321247787702999),
  K(8.787618400942453080880131356345054496763576022642870562475945188),
  K(0.078609162119017200846676970848256813380053420421254041590988975),
  K(8.899187837522032192322080516771815898410458935584094019414741849),
  K(0.089579811493387283941121557844019350221347229030647346447440831),
  K(8.955164788651586743817253102534410634340925385033402600101651326),
  K(0.095394127078443554559744387173341024151465439464838215213161027),
  K(9.044692243092814446083990873876510697412861036362230224669463217),
  K(0.105101114924198347252812109565061903847160091048717795010525874),
  K(9.073876277795643771263413737275765705742704820796058714660698337),
  K(0.10836862609121721085916079251803428955039289985935148273359116),
  K(9.186559686155895652123894675632327412741204801860370394829047724),
  K(0.121422719774591132219073964929572142523342859575641081623909928),
  K(9.321261307251496259774556321305238660301771480003860801811171597),
  K(0.137822575425165485778306158339314878792002910998456169452386083),
  K(9.370590367218116945219066342115905014368559954606984205008658193),
  K(0.144005051487827683258897645745595338889227054419342486232626306),
  K(9.449331072721875740587523024037126709389874622805106503159678357),
  K(0.15402468363149105585946214994084454304939183025765374640343167),
  K(9.517737646242414674682146287739912057915247347010283148756835909),
  K(0.16284239429108672515027058277471300473746274320132259805449616),
  K(9.538755162565811571110496151539325225314919671776011837195018536),
  K(0.16556631817077659517695885790424823256564864449918747371344432),
  K(9.61157620891258555824408538650765058367992883245657863515397478),
  K(0.17503396232975022342284135064903111461844705128024559159568763),
  K(9.742877269183538555554866869360219220585962944852873907797840095),
  K(0.19208484939012956207081740129494265107408385212651979178709914),
  K(9.783069585608342966103116989577860978634341499135884884521137887),
  K(0.19725920964246982822510130249744723979299495202605867680567629),
  K(9.820214796138897528771542868556515594221584171976889261882250621),
  K(0.20200774712768809405837117471941830553221982765348985507519849),
  K(9.942470355093105916373476119887728704553922663229807495246032733),
  K(0.21731022772513102670075763177548802904321378174839649830377236),
  K(10.11999150153575028453210327970041869965467805574309783846721945),
  K(0.23817617267024745222916141737688272414736578634060392438551491),
  K(10.29568745930759326875493819100092564380119757913217792854057112),
  K(0.25649234733751574262191586233878715836349439138751922447459564),
  K(10.48474697881923370259549349408521011508089827036479177076125873),
  K(0.27270552731901558699455337684756562845042073162247991985417982),
  K(10.71573253809275333133261391284692490154076607712284334560233557),
  K(0.28641375662542880107626898546706990763304832182908575541858194),
  K(10.87396817407724856702515337238896816076663631200696550654269931),
  K(0.29139188224877535371160627739869230153174135089665194669042399),
  K(10.91359098529204806905517272290734009439119370529568359119075016),
  K(0.29204349471749501354988757606246050618655339688943940146889447),
};
static const R b22[] =
{
  K(0.04540014061400229853673920055338588219570387496005275012908343267),
  K(2.53800084728826965200833242079030933272585966117858854342103337e-51),
  K(0.08258657273543742346706342040976759627290352217086243164233072052),
  K(1.32202956783166686260575239950858496319851295644705329014702032e-45),
  K(0.2637819608595011097065584156438641520274869557577872966530122055),
  K(1.64674153111890881065309132637480501073170231896420617595040775e-34),
  K(0.4167509350436602611389301098822388381844519893974447745302566584),
  K(3.85938612801635511459520382497352385525037158449722551048499236e-30),
  K(0.4239259046372471134493365366528322682938852782694898579324047639),
  K(5.618397094984373504893719355856439949203871494089186898247903e-30),
  K(0.489937499408398779536701589228355158974158859120967973924527614),
  K(1.35621453777574696441934405095879023407780324451592747987164301e-28),
  K(0.6929618684847564202568322236703314802851272149023470374201713022),
  K(2.78508741307790173970635076990649443322033191252845963947627658e-25),
  K(1.216731699682166193221161247581198236038000192257370850945118385),
  K(6.6606944604397293686445203124839184405158599971170816066181642e-20),
  K(1.269467075207349460899030222746235578178473845388150949414944218),
  K(1.69396768492884770605823442671198343753140653489038240350299574e-19),
  K(1.380254895869496235083297263211717782757472835550587796116468025),
  K(1.06742636612100797081269955347577955857070613081960714132662871e-18),
  K(1.585033859755975670692749166548559526733380785151327495131365526),
  K(2.23914065494003545300332876594195633642045538796083434989131462e-17),
  K(1.826085055096031708529233362886499844167506721923244113944986505),
  K(5.0430722698911228677045369055473468060365985124856897616576196e-16),
  K(1.954866039264707467777690988877801898348656539169308241232337832),
  K(2.25842683547161453439998160046018597579229226965022451563497288e-15),
  K(2.144828796432530392185442699975457162976601302395630420621523169),
  K(1.73724584292450303183984721330319875894528902671302996370045038e-14),
  K(2.395924952888142295560959255578905640652328000428606200116967674),
  K(1.98415300713903293062369244928125444741982316158581195438163835e-13),
  K(2.630914339645071055506665627218418823687634757106574954976736812),
  K(1.55350031087677572930499774227705711199517414592120435205661573e-12),
  K(2.641818078767832983666489842161516331082011168168919165314556714),
  K(1.70142306985321777600879556818653956653188108175853083399877798e-12),
  K(2.695217906058710053374677220945727619748056739779789688366297446),
  K(2.64196859992502469371848967419914837997464930926069112264322583e-12),
  K(2.71918731314389573636947118591363248664992817769615533532663468),
  K(3.20980087417782300504353801136821349593772261536123444102733583e-12),
  K(2.759045390887709424409908388867820181316763193257954058469535939),
  K(4.4200561322299464849349148945365153818509678662686810461775577e-12),
  K(2.782009904822012655174847094293506664996342619749479766924868467),
  K(5.3035865932666224904775299198754304529091707939569912516775464e-12),
  K(2.889669932165302700547622275305652429710445458092608392840458957),
  K(1.22185628664432467226828102155629136204405875052919597614889535e-11),
  K(3.039142904102219373262094532134345135682546980546500095115930568),
  K(3.7001368485798502360352106504263512518542641787854693062029179e-11),
  K(3.192780286736553560160951102960049785890939368042302398045523466),
  K(1.09238573415072902602922394973230479769945595700838166170594507e-10),
  K(3.590891480332253226340026448605428666633726039111602668540124888),
  K(1.43224007056504640765176728685511785053971645682158961126858145e-9),
  K(3.637242103069072755495884034780581039037117855645565151785600031),
  K(1.89527473770533227056032019952872746504615442258290870364724946e-9),
  K(3.688831203465202202284849297648172129645690158959489215564305679),
  K(2.57733498472237319770794745144826753070722802474109469186284336e-9),
  K(3.714101362618293912935788561945765081946831558079800829675029697),
  K(2.9911931793471740072991376287495163641193194243372235906855082e-9),
  K(3.846318137772616069014456515557566247110799558309317038095691275),
  K(6.408636407987723487276782598093280411175552757364067395834165e-9),
  K(3.918440147308837741542730668132186254914847246114587526796568722),
  K(9.5979426367146811640472065620810854005950234852933156343444556e-9),
  K(4.406116511206288931866130168478362903443277023625617145350630059),
  K(1.20928193745210896027784944039033635513670927402125143085797189e-7),
  K(4.536779729437864673858740794861713231558775565917470675512984006),
  K(2.26021340011040089938356244004521948426929931825262090129103244e-7),
  K(4.620471901137742440823376191431958979544043072668194141292396432),
  K(3.3373636757498760634416399687094398034092800188717378795139009e-7),
  K(4.675215883891736333185797086196643622408202891328182713397291036),
  K(4.2872466082225856414331646489739007020619955339430270577236132e-7),
  K(5.045135995972097943899537727028005548930794105488335538010299354),
  K(2.1338818656735772398929389461625007032470643103744458489280514e-6),
  K(5.130109171512449553744915708234386830408090312843175890394163823),
  K(3.0226387277258764036387801707994538956950296261083483357253843e-6),
  K(5.166810720061194982873033124143864239280716854470932324422407511),
  K(3.5052608113681875139270450190795701132889729293762425616726666e-6),
  K(5.287509836683053612295731378379708968471188111059451014169094844),
  K(5.6522320127702961739141061016533190283439118408711167347654594e-6),
  K(5.388531016869270831979831409426251126335711532893552488210115406),
  K(8.3405774699039290432031965975371016890341677456847069982607618e-6),
  K(5.45792557813170025757209143599124628820233493870325084143886337),
  K(0.0000108356269723118952799396539341034212833607522906637435089944527),
  K(5.506825164550843324128342108223179592416297731524185054117725388),
  K(0.0000129952171566245577036796051147802616372519010098917280922929596),
  K(5.77801959026655805419144145978532125299511101581857002453096304),
  K(0.000034248202514810956255274592883589165407938002267259169680813074),
  K(5.855520161743421019699007500100758821461720432331668341934474553),
  K(0.000044648821663124647392918191839219654315926374525460981268361901),
  K(6.22400200014338712301662961871035621930343183075872405996215718),
  K(0.000147222839316914836659295613969070514732009528743369854168127804),
  K(6.3924942011544174538969237903665238083940909890465572332843786),
  K(0.00024511271885867056122119823650905821864585167866592542523923097),
  K(6.406743206656657612999234531003805471033278673078652708113273896),
  K(0.00025565632714418141932532168108750405864482461535718631008743797),
  K(6.504490779116859052829217179218997614011039933892075543028051914),
  K(0.00033989530211226751095066626927240445657797221013032866434443893),
  K(6.505296604188492523795474000578074558119810701433364896016591723),
  K(0.00034068419172813456574688666373320047297831224190289977499965216),
  K(6.58380130960530718739044214624918354722906937302133221052544854),
  K(0.00042602978897407999293412125612856167756632394804406395366825377),
  K(6.612810385190839519211926085833772445363121161427216201527248078),
  K(0.00046218849582026895759133886216621096391768553280676982924980696),
  K(7.209783580357177100355537611687095983446337301608437710259180483),
  K(0.002165557688640728626751342102099302991121382320206942532018997),
  K(7.214806007725568108730182722061481787919495004373189492048358306),
  K(0.0021916132373958800885865443769091945399839172098509732383944448),
  K(7.301920709756504139349245859607994310631033373705322608262860366),
  K(0.002689704343035560144223306619706197143112475377142544079075244),
  K(7.343365295744736416704996653619952125729690041072999465464628782),
  K(0.0029597648353289352575837925254735274652497255008454975932128097),
  K(7.358947718178262772180539944058920650374507662284839440866749594),
  K(0.0030672856605584948627429533017442247106550447365529152423378102),
  K(7.460427159543084966379444168753395116532400484527739977092807615),
  K(0.003854820706623035497859535273974020298350199103513409058964433),
  K(7.525448666715548130677446440466455545941203780151485014168882806),
  K(0.0044471738753376549118569299237945944755077891692991730478308881),
  K(7.573730992790303615725105138632176303610140856736679664382882761),
  K(0.004936560349653807274015810827440190589553987100745561713103688),
  K(7.612804337952498112135952543471343444586513766869271656023172886),
  K(0.0053659565535419418584114207881521135433355012365895243263970409),
  K(7.657363606069725798492955848517082228623488311254804785674191738),
  K(0.0058944781428254462951693355334300896022801132578360421233684819),
  K(7.969778706790433352268615859962851932781840592422533753334957871),
  K(0.0110016041904434558827399805872681351942990684000660826035169139),
  K(7.982077013140320700599901810248164596033309770163832090194359756),
  K(0.0112614285086095736282694777255219047354917074238029138325834678),
  K(8.222843540933716276644846211119413017577467695824412398695448418),
  K(0.017462944666859216355260817972396601046167846666058224876188283),
  K(8.330864485646630331490494305132345690537153821637430114397438714),
  K(0.021025503035998016883447233903643079644716743972590885219165682),
  K(8.336905915676524035341564575331372626960522882338074605184729457),
  K(0.021240666129794674520624779794541210211164182191986343807454893),
  K(8.351139018022728099370116099169557109358518904043190018424432873),
  K(0.021754484432462732013441511180731112639680426949549410580854678),
  K(8.568820923283737906631797119086538952405594421765238876155745756),
  K(0.030899930355594588035659643196187216813117310929174867676425121),
  K(8.747777772825528279036843121176948304475778143925826798411058516),
  K(0.04040406345161797630648123565721196429171632962066544231651335),
  K(9.072363834095442846940985779304056456411778803550056452884499611),
  K(0.06276712216851514169413128178364394423908819894982321703861204),
  K(9.184131769146321844170962017813015395248994661007632976100646278),
  K(0.072068734774924164756106656542143060090026146282787307946555717),
  K(9.233693833347750520275877945255441271302184919010724331808142641),
  K(0.076455634668430226561107857626786331529332294087833378356852282),
  K(9.273670308628532849943068297216207511366962153256966076903594663),
  K(0.080109734096721493870732859791826738712357350245541748773231032),
  K(9.363475032941537554990869341005104651311564553951919342266761306),
  K(0.088686952334120983562578658784310099397571464389669858452610927),
  K(9.423286045827504335719177494933523385504806330067019588125002261),
  K(0.094673745860999861333517388806475323074317615584694506771598848),
  K(9.576876724020045425034903103119864871584872265994371416579610987),
  K(0.110982539200408673390785134461535174508476281620713089713529432),
  K(9.60388348630463105403633595081081958181877792396216681647851318),
  K(0.113978993674782290619101104690375988441493035224633112105949216),
  K(9.659016130339577349440983290138763728590902296581798017969447471),
  K(0.120204405992348387411769784350637536582173468991517613068210161),
  K(9.739086608091055207591635083531242820219228107950325392537097619),
  K(0.129483051293125028039314117990210844221687513234623867982902783),
  K(9.995616316872913490771108127390735756592669886981167504456747247),
  K(0.16060737044393002417584383245777506909392166463972576859938618),
  K(10.04605980118755591747028435305038682089582141998457556830988398),
  K(0.16687647210122515119665581492335291152873493079748791108843038),
  K(10.10890413132495531015721249762931661099050102875481653372825443),
  K(0.17470483148283821582317683772085004724908397441462825177759508),
  K(10.3423705705462547530187827349111069890838870109992932273956258),
  K(0.20344733824679126905463353486355751417151210610565702461235743),
  K(10.35147120381116561350419561695689466731428419428889967026713403),
  K(0.20454170162781678723756568074263915404273494500410146257249401),
  K(10.51456202133606008119339567110543964845571279166728067418873883),
  K(0.22355562284831141516588494942031693140821045854099074198183337),
  K(10.57501439470202133529098528745243312080146471354390703571266091),
  K(0.23024098112679785373520045947581944116962370987916629454213114),
  K(10.59618955066559517045783587642638853879527002907299032798956568),
  K(0.2325263418254359538587436883761832284124309533987708080299331),
  K(10.60861969799871742890472531757101927717515256387089348989436268),
  K(0.23385334034120976815767957648739859231011820441150436612415896),
  K(10.67779016987082185516330423693580202866579495008548361685062564),
  K(0.2410278058972605340222425320449087817932413883032530460236391),
  K(10.70766556333420593315790074843059839007953579053012434252367299),
  K(0.2440089491581267476566568071676259570192830727906718758753565),
  K(10.72346592430876869631659727624469993837176560650546696927994513),
  K(0.24555506381371713830728374161589597461212995606176477318971731),
  K(10.74456297763757260769290503214086795063570170338917197818125664),
  K(0.24758539059240400868870199660493680122425013263224228815232667),
  K(10.88683124749924589146186967507468600216971585697927125195265127),
  K(0.26017060513267788271211044807934466283051369197276160027673569),
  K(11.04506895892639913628178126964357909054530271112764413998980674),
  K(0.27160313092354664720334068445643698269850428629007647131748044),
  K(11.08044668761013738716599275675356674834260520928146924900371271),
  K(0.27374861827487199406013048888961951965731022754204634005276104),
  K(11.18119371337978336452853761300731213309340758926694187311245863),
  K(0.27897576715309927834444614732255325506957458507241983535877601),
  K(11.2530711080215144267334112773182429040825553141774024482596267),
  K(0.28187449813444171942970945901675004100254787409898268112093025),
  K(11.26672227068664408277654353325030517584018033648175471002053569),
  K(0.28234456514769060952484886118755455478181872129042898767902481),
  K(11.27078771442588332828830120949490955289305339309462379088916898),
  K(0.28247953283988908623092097179500859955167321758156061886830672),
  K(11.33289419559083833772355641058488640997700072021795377811925003),
  K(0.28425224417214807808717714066329301871429061770081838977879454),
  K(11.35528917501526824776021092831362468419989034348829523063653818),
  K(0.28475716143806481922092164219451469862764315895047153860786075),
};
static const R b23[] =
{
  K(0.204394056114945914007649949176725896122521178077979285078134578),
  K(5.3490369844667728962504025949161324169200335284068337594328093e-39),
  K(0.5367532984371432112358850149716089151139719773752694903565865409),
  K(2.35680784912918744415763797398352055412099879973504354389850548e-29),
  K(0.6385127948655304992554370535841569286655909402298054368307145748),
  K(1.27763402999756901923122225785553446716061234851054921598039352e-27),
  K(0.6454324827338114635906272939557705673182201017864779304287567974),
  K(1.63709693182271534269606492265157649458920361824851209721684566e-27),
  K(0.8984476326910921320177473632822277714553656578162669857042158459),
  K(3.294877341858585599738349009109689685221828948893652029060455e-24),
  K(0.9408174647015740496595958007229712335292233741868735246619801432),
  K(9.5088741371807624523209302904372649309517708682141062108920519e-24),
  K(1.116465312347434143981835426177860209276193461806323254963150378),
  K(4.8746783418319279408070652689714945482638512603650814176261765e-22),
  K(1.138829190204849527327414133456872004359102241770181452839830136),
  K(7.6922457347314611476163188670713430710715190365798818983470023e-22),
  K(1.140344281829036254411310262454020286503386609903710942314560389),
  K(7.9310981118856583223200586583826644316510719635790022605836711e-22),
  K(1.410484853048248990540117940520247312599144914897133292148715062),
  K(1.05433684991679349396638413517007521767714723117701604951153072e-19),
  K(1.454072464797843686757791788137286468326522748273601888538914075),
  K(2.12316981879438503907894313247160609189294172377614640535472282e-19),
  K(1.698771933322143341381768267491431126126245370436660349615016796),
  K(7.5964788027740482184631986541428298569952538220364089585701955e-18),
  K(1.894640687894475845334161324839933121181151476205019861060367919),
  K(9.345940468378640305728777256254462232146527911571225957763682e-17),
  K(1.996515729692573947739163395363087875788207003931306730966905952),
  K(3.11729074188800854798664608505390585210495261076170560382303321e-16),
  K(2.378741577206570236237767022199360997140460270012853402752451103),
  K(1.7516828081780622940002288237604601442869170882341863147595184e-14),
  K(2.527804924364943634842252572346260658299470884044052837812387011),
  K(7.0877756362426576859233866688192887789081459921976871647532001e-14),
  K(2.688962600245124493008951044963405974424509049723779436746249202),
  K(2.9357501157340708503750686452721243800433593643118445747854024e-13),
  K(2.745647638400653611969226172645595937931785745847389606163484138),
  K(4.742680674968294769291749806896833617832311732651683690521839e-13),
  K(2.745800419806434628792428405806423732606488660206318456522812057),
  K(4.7487517304174297736258827926417244895847050369832561507471677e-13),
  K(2.782548853912217886998521112440960637099583330263481876472055651),
  K(6.4464175910432270533940804873784826738189574558473627358195757e-13),
  K(3.03288312918860608114480532672433361937084148832260799239997651),
  K(4.6680243075068327002591324662351241380570209152558805479158882e-12),
  K(3.125791838561255758018165515814917684158130709257354562151369301),
  K(9.3350306608646755551797102304585478592959827612972027148008977e-12),
  K(3.153302729218745621602950914403364621769721221201207775929658338),
  K(1.14156143121050780366773827883849645475790453978259188500735923e-11),
  K(3.248795736788149156715691053074508397135583875457041710863539236),
  K(2.26418156121366880106104127193325611267080095351369766097950803e-11),
  K(3.282000771652696079584096997355516905539853828288279977255409545),
  K(2.8591998539373089320385517261047152380365940807839931032506413e-11),
  K(3.305369892032578736776207775545377596914311137927318116892978619),
  K(3.3646135307290514070793356747557535534075545429425728381445872e-11),
  K(3.332646952686521896924533002581731132344220244561971417977198708),
  K(4.0625947798516945097426696496619187109805305268385121680613859e-11),
  K(3.592872469501941764329869922636888599751254416638525049520834133),
  K(2.27445705908979716918316845596058170956895304980429056176557887e-10),
  K(3.756760990092865111465765136419524966205889245220539951841244156),
  K(6.3051470972859141267566552444017841916855513350603121989934202e-10),
  K(3.797765098563858606465098490552832886771660222057370803313166541),
  K(8.0782976057459248451449152529855816142693294207681578761506898e-10),
  K(3.841105268043535534692823993271597255159681131207185660052770999),
  K(1.04652951952220643907526581804455626895943843951983095145701975e-9),
  K(3.876773779851326764778310753056401025842603030319215766344545415),
  K(1.29204921548711945556977564898064697978885809245303878867509827e-9),
  K(3.926245805820257060735417619930193085154555338739190578584005831),
  K(1.72487503712254946740418868209071672938502163198485351440831489e-9),
  K(3.949539311243807415753525908596217396835856385767320255408468918),
  K(1.9735869772916941262897322514879988985145040313931295351500563e-9),
  K(4.153020599068744367072756933743230710479727320880908074772618533),
  K(6.1808085365651704563773033098399234510439888396093452776499701e-9),
  K(4.463944170949725919750636673624817390705885330855683029364565089),
  K(3.1589305656577665127492158340805330395076103947312011516833452e-8),
  K(4.552450212345243889162898980867676012326060950159917055924174606),
  K(4.9111362441091229010348891641288132663686268759335876954857391e-8),
  K(4.558674629788502966328246746970490808910988556272593967060691705),
  K(5.0640788393557680655682455295581841372951734679627697751882193e-8),
  K(4.627000398328078107761843546755841663722876204634255902644147523),
  K(7.0688437549353855191223124974036531386190044784051937724552785e-8),
  K(4.796243308565904196680015391193509599099984190681962767709816207),
  K(1.57678059983799805513278224893896390993548922837424055430741431e-7),
  K(4.871871052696031619743544973923487307123875669631124808297387422),
  K(2.23282463703934858706566821030997516786229175823715581284704735e-7),
  K(4.874014932343914466303244847951582258101478476842708504757331316),
  K(2.25474303383075197646607355597107760088141217191250101150768396e-7),
  K(5.054755676442435644487922935424568718903216890245085364214250859),
  K(5.0460380238877768270490844140583235209254843529967173431538902e-7),
  K(5.17973794677049512485433797091915583414436108071164020588128019),
  K(8.6322005734873323170355676236718805604334635051019367484021917e-7),
  K(5.259017256218069882491890612237664425256537081129258094918824978),
  K(1.20352116076256736025463133150713432673688536986989424366097713e-6),
  K(5.424865972921043475136195661469259002946137042408727179396478937),
  K(2.3643866782475848984708070154742272963665431788930546102235113e-6),
  K(5.486049639122468911738974985932796452063066338272234330065903637),
  K(3.0131740516638862938677301502835213007598442498969700959521287e-6),
  K(5.501019365709870187633838031862638857173984090548423185476600937),
  K(3.1956375471827626356205956447187496428068008217562551451023557e-6),
  K(5.513296125861897852914151854933421425823674462908729548698598902),
  K(3.3529728674019089986820660263306795111278199576347813784179277e-6),
  K(5.56172133462010166179223415367304612398386767183542379896662125),
  K(4.0473581495112883888961358337638143682754952145648782998587164e-6),
  K(5.605195053278392948611981987346239310135254642914310341064990742),
  K(4.7836690095140145023253749707065604091515834456124529638861678e-6),
  K(5.60618651763511279751485421648015407628035074496605803838805514),
  K(4.8018424637378983214363001281640005072071917299696870325201574e-6),
  K(5.752641518241597033228062569233095379349893500941737705429594937),
  K(8.3266473260759863541107760518970171310891263023000867922394518e-6),
  K(5.776405850775297668117573167131185044701018544005126604231040579),
  K(9.0883749700488788012209433967926527082243954748911989998700774e-6),
  K(5.779095783027342238235329574931896751706839896286247598498952619),
  K(9.1785885141491255844010849630394106347801028324810859364088993e-6),
  K(5.873468559723375278681878713186978303784894643864080897619943204),
  K(0.0000129287815522066112599319829155738051112212413638273428758254803),
  K(5.895153185261382811366242613054431990965992496858215406006813352),
  K(0.0000139725918982169267889992401479226025440256639302227540980833688),
  K(6.10264763001000674795109457537971831891831238081768685158965526),
  K(0.000028794511157785588866958653975687616936097803176512076769919072),
  K(6.236701337291698223991842121786437452120864574372507192469793274),
  K(0.000045092654618983551223615830898629728632728032893592013386088928),
  K(6.59894255645669302012684303591562419749513514365460052237148527),
  K(0.000141315974666394633579698660807401759696871815313763463752434283),
  K(6.852235259802422172056656432184434293031449962955369674460749799),
  K(0.00029648082006601313553742692915565633028480394723707515255451428),
  K(6.90118361661060730421749691689180076346484597834096181611194553),
  K(0.00034032709055955952820453795470970101040147316199584694644424512),
  K(6.907424811211996706865850160246216399051748328254645661265100145),
  K(0.00034632331396967776836369675542872996874373782071454325410075195),
  K(6.954714049641515260630429996599181716759348872087247140349243199),
  K(0.00039497691045359167269359678205769159092729718662986028490478701),
  K(7.055016028692127932075860822089716813011196457116541528677815439),
  K(0.00051932715161983895810476102119698099625657797791503706599558048),
  K(7.218248020332660037097373562175027019670974789000733878090953965),
  K(0.00079898829162152647024080329284246304905358694069729039147845875),
  K(7.367859279656719511936760466427514750956267755104636061902841177),
  K(0.00116750859809037923642047107080510662242034920484914871568631391),
  K(7.409832368237253672132139460049159434516748573693362432561549226),
  K(0.0012951761439996993350614932785414191237170707339700644067792214),
  K(7.677788062733489723991234431488881989929454147341368067649941888),
  K(0.0024461816845667487650135359020972343298590383482256670229663181),
  K(7.745747859234628059921917177192666627367032091906940158379337347),
  K(0.0028536732014614819328028936292110936447954813991968319124962582),
  K(8.296434123911692978587721233581876961188933375714484898638254139),
  K(0.0089669100923001665945096004924213446593261683555972883151047118),
  K(8.307585897925311924415961556686113942825219658472665758702052062),
  K(0.0091601877769914288093949579485837040246595810005581517719491894),
  K(8.580429606463087549886934004055016126870236684097707275338800547),
  K(0.0150938136702605917673331659486327490571162976090017291314094203),
  K(8.593881540672007082635992375745113790102102867814926855400059712),
  K(0.01545307403482126775807722202594269424272769726832421755345979),
  K(8.72498164534889887226749389608336924285203911495455422311790297),
  K(0.019331146841776833494262058567104903487491963059983804556489355),
  K(8.762445359386816050057552296835506144785712912385911045922851876),
  K(0.02057203992405822264033982247064119254384677351014374224525771),
  K(9.243663268635119506787473521069334559097332926315512892378596078),
  K(0.042708009301143791426391786455686956567683509506955051384124202),
  K(9.30201047937129009774751852383655118347330605914581573237876189),
  K(0.046266555960478977022355773805730056371979308853332508624767296),
  K(9.492786162782088329425594263302559666716293740161986851560714498),
  K(0.059349553241435188010180556577186283363810490866242719249255523),
  K(9.645703461396637562089330314617785127380167159456510436948041561),
  K(0.071463129173472306578731187765458867897998685259228170658231614),
  K(9.724835367814852500028523844102503162713276600102873008718746204),
  K(0.078295798264389233154554439430853525616782960308627355319948255),
  K(9.795689270097070335790549091497342625659544887066994241285487486),
  K(0.084731793845696649251288990335635190217897742467910047787768853),
  K(9.898273310177720781679799474296006355885795138410574619755253553),
  K(0.094562464962361932443146345320726813374127698877729476933748987),
  K(9.902437208514277194963763348833647016244475054164680538239782698),
  K(0.094973845199022411962335227213641530777955781980731693774944615),
  K(10.02483807746929039494831985300363216428848855408457803324518149),
  K(0.107471575141617529981149772055403662443688679719832171826527273),
  K(10.10084314877906027062507308053147187219963441725618878091445063),
  K(0.115599412950087699259605111118636302299377296438415605228122121),
  K(10.23599008768354757165608794107818978490706836557779794992683522),
  K(0.13064688639511570661598025655625991540565975297077291275260231),
  K(10.59594886805022327556253279120408386535369282715509611052545557),
  K(0.17302146420068631960633594580135861263148896027569243324728362),
  K(10.6224628421650115725887780629465692445054016915783779399594419),
  K(0.17618559926095532832572054223967468522246065723762060330176911),
  K(10.81444326083019368285145365298793600646978876986512149844731726),
  K(0.19880201374929945929141536566473658937799806715080530095178496),
  K(10.9290368590676527636011705904441120070664850113079638923739686),
  K(0.21180759613411321663773921794071845050139575816155017653817082),
  K(10.94914587743157292873895387809961757762996975746645076193401058),
  K(0.21403255091693202777999168355873920324083167284979732889737959),
  K(11.0009638673514292149789839011393342289424320104938298763989246),
  K(0.21967189479361634176514408240511692839069015270877334558358078),
  K(11.43269342918094073051109052696704487042674344149952361466579225),
  K(0.25915858962286671160285364221393486929874482171660484564399408),
  K(11.4917469720069376356047642128135282536077482661708101449129711),
  K(0.26320764264689476392710101434580572537236682873551461522496792),
  K(11.52411729145048598448306698327318494369575234240621391679454311),
  K(0.26526184206300489725660067238470945167161364725136069109423842),
  K(11.53153877367559093945342373040802689123206723834894665157723703),
  K(0.26571587337620703682259461855909052302065290411525648072281538),
  K(11.65009107471899127567766024904231471659613501218188144394446704),
  K(0.2720802319598936723282775050778027018274536670349412690908822),
  K(11.76819982047189390412381046080240587182670483583594856263641785),
  K(0.27667761463307933605310047189117574717095907755750893864017231),
  K(11.91269129301412647376537293556358046222990510405485821052288379),
  K(0.27980571171176117545970352630179090922938396672918392723356558),
};
static const R b24[] =
{
  K(0.07349580226577594214975439735370679223684749587002609016664423055),
  K(9.9447797314567565467032693663482300103931618199183276941526834e-52),
  K(0.2274095008394659754011127372963256755077015821753236688567044287),
  K(5.8979467616688755158178609479402500909244983475027528794143852e-40),
  K(0.3626867592217289479575878497918734192464025152022883587807041546),
  K(4.3256875921956770221462719097330593381171473536099603649741351e-35),
  K(0.5085275404521157925673159710476544284922169741605004324743200692),
  K(1.44159014256843913623526871845641668553011906040918351595137321e-31),
  K(0.5370136410935730665643532374099725300146823684815337865344492683),
  K(5.3326361727319705491961694907403719411349435097973279500914005e-31),
  K(0.5729208851717318051855222391371368554557583205399813348886607761),
  K(2.52096044636504559237751194855174776536755149411390881312962734e-30),
  K(0.6700615157536754099030482977432216739784835385528729921561462646),
  K(1.08154984663103181967953158353572935257238866130451317105600706e-28),
  K(0.7484822269780349745346634954052539928156048519003115497594277607),
  K(1.54045900400730507849963500240160696182514014439668941197343177e-27),
  K(0.9848862764815517313808341558262414354241288682217430474968777891),
  K(1.11830532637691604114038394904754482704318734635746118871266346e-24),
  K(0.9888683293795167815018461586920274910934847103201823147243718656),
  K(1.23201943708362225957773402141505688865886444449542364593829775e-24),
  K(1.164380340514153916544511884003109654944731490679070459981395532),
  K(6.2168597486160679563539012732348700648995420516386704429622816e-23),
  K(1.186084324140515395227475841861231840792498107772470893800765267),
  K(9.6842929021475473959941943097753384492453156718837239397938518e-23),
  K(1.289917139164400831506628085374681789033891023378672468719306773),
  K(7.2573463266163195048482349694432513306920629137549395442476478e-22),
  K(1.550087633356140134913232572866908777863163687419241769181713037),
  K(5.9682136942682837837367721021513479545829031469726561065459374e-20),
  K(1.555411865641269524019810670205659558200831915244256837526651548),
  K(6.4801359073460291649113906621161165261733405834406799674788438e-20),
  K(1.563761950871626494186532079259359667626197709290403008203372316),
  K(7.3686805941596885012793970919773048471066591495541824589831804e-20),
  K(1.563993974196599006656787432878670567930244325927179600811203501),
  K(7.3949653044167908352937867379846911395774769697795632355531561e-20),
  K(1.72456902971892097805486607449470685160893841807655861040563601),
  K(7.7201955967341943515436302185723308109669211641011126738802839e-19),
  K(1.817228450814943280941083963224552706614124046634597856546666615),
  K(2.71095894659654250812719657618153987734566576356123967820570525e-18),
  K(1.931930126601847528021756978460323561702288443692978106661618962),
  K(1.17784465359659890206559410487401919901264096885171963227344535e-17),
  K(2.051061115268637099531879248413381166627279895051225298291759447),
  K(4.9519880820152588756073279705967124345680071391382484475855185e-17),
  K(2.278631236132158614184105560530385033623275387302534811185280503),
  K(6.1867295573477071471978528391999128984015027669889246251981355e-16),
  K(2.342375998545393426421822987973180168237106334048877422443108948),
  K(1.19959833915965088311580929152347864296637516683894205408964971e-15),
  K(2.409928805250153740513709210829559869565844431710476679098110262),
  K(2.37338042967913716293521064196503795733480617825219284762127945e-15),
  K(2.58791136407939484277263518669506633837268918112784845579080512),
  K(1.31217514458320484588230610724222671266367967571950389743737805e-14),
  K(2.648406012651783581005974348834386122125452165127669708665463485),
  K(2.28454551826453502148164460882996636101958941839494797905482535e-14),
  K(2.866254735810288936650876000247973827985709771001423037023172734),
  K(1.52223965371093875785379792477835616219814854575686202860720683e-13),
  K(2.916402209458744817736111827586208881216762530574820474670580693),
  K(2.30768235764816021924097544352472489986323082447166758561826977e-13),
  K(3.102986994927687254325998969638225126014198592831823441289054494),
  K(1.02106837830386409791574106434198125480444257797778945209945169e-12),
  K(3.178163116445933040814489883470549504742164173356236419306251644),
  K(1.81246132499999152650279753175322597851421639175389522645217918e-12),
  K(3.275633341160403290821960439335136193439042341244989475839096072),
  K(3.7380361343397800227798286275844095235357602495297446529897256e-12),
  K(3.284744950993290297290236745267749145041386982691258385729197833),
  K(3.9952571391661825025711973405758793475759494029322332272176469e-12),
  K(3.405438551510307434902341947591725906288949662449477736552888717),
  K(9.4810448112740614915880388043084058983520957173575905533023563e-12),
  K(3.461717375759941107792373673488138573675063356824922808358661683),
  K(1.40360661261296783920581602378267996551865923584623544257135984e-11),
  K(3.669576034617258352025338253204344305564215571926090856727747961),
  K(5.6598104686840411278059467698308509798171885967381835615682944e-11),
  K(3.876553258402943459261333682442549650196976505035870867352496777),
  K(2.09643061741400645524443740856543592743330470446226387771648021e-10),
  K(3.901958039781177240619119283081898158109163912676421422231171201),
  K(2.44954566601833863461210321346666863226021338076623519853845668e-10),
  K(4.024795537302541637244401730270025267505271002272781226325243891),
  K(5.1233951961362466542006657808115259273445776310180650283087972e-10),
  K(4.159326499741636095388322060336750257814831190055270860369022322),
  K(1.119018723346797242940688916081085359194638417904186967866225e-9),
  K(4.429004691144618704960655971888794520075306908616340621509229968),
  K(4.951182877327073110213279734300163284944255369136009419164969e-9),
  K(4.697150121430550126050140640860046965287707006433869430538878267),
  K(1.97412324132430396132395823260182234782911227647017618950529443e-8),
  K(4.761705460806015656555802521175341378736654100157568102913191928),
  K(2.7179150768633328518240170394650076793689671530206241806169484e-8),
  K(4.859707663218050031991741996550266685018755935091823173246536322),
  K(4.3750776656681369919194769377315198018188732785035156011654819e-8),
  K(4.902098482830237126348640894924522670410756224786974314633514031),
  K(5.3571427576105361897945930143022287097714547798720732720607953e-8),
  K(4.923092204170545948811011407155919703354646670291165342572298503),
  K(5.9178345170968919026336384574579735298423465457323384438597046e-8),
  K(5.037878222232966691544449191192888020218293470758882251625328004),
  K(1.01107257764551483712536710961351874899779348512169360142217156e-7),
  K(5.15916392479717296562898739416631345269308881046338013433623982),
  K(1.75336965819832737758027436945555069915028588504725889226508263e-7),
  K(5.693213656385194254877059761116255418520386150977566100213800494),
  K(1.66160775034107670835109078269051939643758196161307379983378437e-6),
  K(5.728945635376453848018946954789107910066809018500273621345488259),
  K(1.9129925127054387239240323735970991587518937348381145999307101e-6),
  K(5.735346636106721836365232629983789376175603050510581446915760881),
  K(1.96164948418192066193235687193750254000965116232849305024889299e-6),
  K(5.849488500418714202638038058188430619607993220963215400105170347),
  K(3.0513442407113590212542108662317312641763568097950764540989557e-6),
  K(5.951054222105575607759677053807874326660555887182864581306745771),
  K(4.4780144545268346967504649169778562895612529737195159006624151e-6),
  K(6.253881781695712618327076664949791198052395627792538949141998819),
  K(0.000013352804100945998661273921393045264815696604374851687629315171),
  K(6.404373434537874715348824273731403425582523552264932742499095699),
  K(0.000022359966807649925008517359610220384144853743229047350625635835),
  K(6.422056855988009401284303982927041294369864975499498701155517448),
  K(0.000023728925566545461503646322106305364589879070843747569362739906),
  K(6.428473659675513009244960653039006986667546255112734959582438839),
  K(0.000024244701962779744278111838662213006530268290669467397325325868),
  K(6.449721743598688142839384816601431332130896330631231837334344287),
  K(0.00002602811365020575783255651941544069101584005643869928730586413),
  K(6.469874460265268443390701310656230323369004391924180351709726732),
  K(0.000027831781894421489420081019761687602965902868520493168393241556),
  K(6.487386697005694991695726372979115350445759073768606785150725217),
  K(0.000029492918977042889493046134651572543063160226811546463982275648),
  K(6.73903131245971726945051016043016578674676243509237062710394563),
  K(0.00006614647912243608780539393074187354928411888307621474582701594),
  K(6.76874820108929125969319370590393906359335414506299714657240276),
  K(0.00007254366660313995558135692746676610244580097828140039986303681),
  K(6.819805642916524089462233317194632361811743063180882822163363288),
  K(0.000084886765349427524553970037747305946189887230228836822639574211),
  K(6.94657836955651312443439127020791486622193663354968080088846219),
  K(0.000124393758751579093944454375184190419543096890947618311876062458),
  K(6.955082727231547768549408744991464962339586223801621145929476005),
  K(0.000127572196544918834186586777230467178780207916941547065147130946),
  K(7.157146856036625799955827589266394649468357533829320239154869418),
  K(0.00022894427542713155191339020879038313890633540725041902545743206),
  K(7.190547418444319478613187125554284862610494539063733176626230059),
  K(0.00025150563213509974172872848252645111048458486508795704146172266),
  K(7.21389680472342033787710795519503475741405769495245080047274849),
  K(0.00026846585928785332489233765285708567409369496938505479578438728),
  K(7.284537089984382598046754648732757035428550436158465818064136059),
  K(0.00032633945228626683830082364439316559687041077449878020041569889),
  K(7.334362646759381941909926680947553127901884162741965667616889975),
  K(0.00037377070389809804682779231864448557091393842000416569303659239),
  K(7.465559420264402812028915397567829239831219484401979967352186817),
  K(0.00053017057563315549497323181074046036705390344875731622868825072),
  K(7.526364847045554695203376883117397043096133002177296322768500607),
  K(0.00062106253428047249634755813824070243651076609606119510350675211),
  K(7.610916989894110967809379522313730328455208258484276763898975831),
  K(0.00077088427238152792213176351061345488009701065126077995887740811),
  K(7.678353496046464609274833637383819189382358841873884674571841036),
  K(0.00091293072453343179088988094845293619405589242867667744407393578),
  K(8.195925434598458883106585183927514776888324974077340058496702533),
  K(0.0030464287331113925536204491097377481560685365874312743782413578),
  K(8.59075745153193006800023228971183538721253587915481778012728551),
  K(0.0068685419941190240078794943879888780649372291816931009248460734),
  K(8.687023873042440891816935300676519933655969132033280798523210812),
  K(0.0082625384821627573559770456640872386912365438668997901741183956),
  K(8.946188263980223625828203882633909993271006853193918658036160785),
  K(0.0132454331939018970326261646688329419354138485092423047392402218),
  K(9.069811361008471283472018570083564167268676131957652130925877193),
  K(0.016376328276237562579597655551454911867000047276943960490349231),
  K(9.322027592091815708719962674244309308803169934270721741722101632),
  K(0.024614046417858430462696821488084203865712355094969299441608605),
  K(9.337159803737355608928090629755310841016799450186193718317636285),
  K(0.025196160826812744084740862870272042016039062579565650325048039),
  K(9.362420968225307219276780935554480769121267288956391526358771089),
  K(0.026191720211386510521881796511640973923296373051656386524275405),
  K(9.577280745526732342509622562319812075857291656326712919224314732),
  K(0.035929294198346047866809194624678337490351675360666306199068533),
  K(9.598990867530131151757154707006651273120173060508258643682394266),
  K(0.037045945789890524006300267704771667605466647780407827007765747),
  K(9.685687268275614173848483202731242586775443927464823664731087762),
  K(0.041760701940194137427106088669554959410003602916515490360235118),
  K(9.866601346398295522932862839830633534760846895144269223804008482),
  K(0.052960006395884761130660046793976201426077487129292120455734292),
  K(9.874737011612574926200848537603861949456026502574373310534158922),
  K(0.053507898695766130372748017616032132479744275642135322199944516),
  K(10.00094622730083811895928012131749562207503861858202173651549942),
  K(0.062502324458346798039744355869766834236478544400068311703170834),
  K(10.03642340678139839396815517826126523650662067813938848665115337),
  K(0.065198264021662614747592269478177053289415168656434029619072176),
  K(10.34144228186817748242061419238545733154697990363005415795342717),
  K(0.091336153763075119262560858937048859154219533197739060766001525),
  K(10.55556250558538009286195143022519053897437287186541842900135075),
  K(0.112582696742709926442954125242269990340727349618068527625345436),
  K(10.65719842097811416442421868628725612466888476943337212414496449),
  K(0.123358955257884529357639521593765528510110929960182239370098236),
  K(10.86681679641469917125996135052468179803359265050806836609339054),
  K(0.1466083805775715267765926439394927435001561341739744980257053),
  K(10.91724585028337303902757844508329905705063680242696898636956191),
  K(0.15234252325933163533243015440999906546447604650006325601544137),
  K(11.12266647396321787515207320015998949175214419758196135007919232),
  K(0.1758747465041952151554622540106312192946246352701195794517262),
  K(11.12512828283076744560975637449730012242951238810165254570363591),
  K(0.17615613658779871968577050604970705207731695892780495654656677),
  K(11.14943833330452641176869461007014547611641065825642387962790269),
  K(0.17893125074048389811277371694276075858627427539221249578930036),
  K(11.22964629380562037349180515037265740019829108300714501864812374),
  K(0.1880241223255465572886834951151836048522070253766148285315838),
  K(11.2299889023499694805017266492578738804701131850604014119123509),
  K(0.18806269818479279044341607649911267451221132318190275082972856),
  K(11.31692839252323373679361684388741725649526607726295015245779915),
  K(0.19775387950355816948161496661692354421375591317108138549665036),
  K(11.50991623684351122363832648050598722697045533761056398513375705),
  K(0.21826663799312855317652953581412780051173980747197140667594498),
};
static const R b25[] =
{
  K(0.08553030160997890504891982830617760493759754146541604395612134041),
  K(1.29525240945837890580403170221215833888472711227541948096694198e-52),
  K(0.3177996334865021204815590223579790827690693944507696535545163205),
  K(2.30775192192455332488562900003367865915723244156215324515774113e-38),
  K(0.3443330239487544020158250568293529766237750875877199573116604638),
  K(1.71325195389719584120549572469191519821763589469001358211668177e-37),
  K(0.3888552228868858877031008113429607015995645193626838989458463894),
  K(3.58139921815557376902804590676258216002183442118684998300823415e-36),
  K(0.4561328396258611814486953630408968656534404006777891059724955662),
  K(1.93480784327379057421113637195692876889055216548754500901907965e-34),
  K(0.6225244896985212994626602949968490204611077983935453889420716587),
  K(4.6053786696548946877850458622501639835339495588111272161711451e-31),
  K(1.137926083483340650162367048737174132196774802450451573780439938),
  K(1.63006766085342586467510572380286925782948384961058718124648631e-24),
  K(1.245844817860114662437005163010893710796676839246179486343829132),
  K(1.5701931303697256078234233631692804501281103434078767597462689e-23),
  K(1.574628535034305952393731087384401469477457036806426803402309278),
  K(5.4803368706296074113794060322751156099481172338249230953106181e-21),
  K(1.670791603224390539162513552063348882695140609749473285247926122),
  K(2.41218948327038489018480585667720675194608518148966943804163232e-20),
  K(1.697867215943362071038396196561530257287790839185207884199376964),
  K(3.6053496098335465738015022630010545188815246816654937538009119e-20),
  K(1.722501165011157124504352290846111405062094030614088742915281737),
  K(5.1682370470663441908633942954861916148298898472944945014562581e-20),
  K(1.824564474112214528843344761359261657573538757714703294008853996),
  K(2.17938851081045585304991878662047611018640442145084413018839432e-19),
  K(1.921347614264102190460318421119127977520415289016401462754108619),
  K(7.9341944322019505832507852826598622865781151397977371783224798e-19),
  K(1.924118433155665048228337344400277650075093543895760913715610641),
  K(8.2252518118695144074004074135904118736557621792560370766628972e-19),
  K(2.185085550985334160059803834841640626279313652163576023698170178),
  K(1.97725591308201146294308047811602785870735127582455882963616757e-17),
  K(2.221890152940757923944316772012492752261384347546571560443667007),
  K(3.00203182675345635059555639962550467897752975354933139039119853e-17),
  K(2.484187263677524383090817034176192383761312696184459997958641419),
  K(4.8857779659795898186648064160420122582644740033916767775255064e-16),
  K(2.785148829438629856609144776015123658296120117951823639692200695),
  K(8.5191685089098442264403033112667869574337370007953144182602412e-15),
  K(2.853452359082790850948980623004142509055507431777317404896561884),
  K(1.56094121596449326814147737054979917522364668164031594320770315e-14),
  K(2.898215944311501192285281054929454680191575977414493479158557324),
  K(2.30322091960867636632460383665781508455863112288808943398798793e-14),
  K(2.908941316154546953615294606270082756673533216275303652184898995),
  K(2.52596180709263886699718621979001688780255639236439808888896601e-14),
  K(2.965583282022577060154108094335076870993509171309895067522320641),
  K(4.0899748971038553100075741705549366537162398105431809121500403e-14),
  K(3.2736171861451149680489220000491058547676255556263750227367329),
  K(4.8284234038703909430767777741863665395159532097389334598683605e-13),
  K(3.307907150772405079921037553475293124314721657509289015147085747),
  K(6.2631162908213257734466158980199025553215541362476146656130126e-13),
  K(3.340155665109281407996028903204512857595137068208134861119014603),
  K(7.9794227750036196190144018958940103085016872236515357949346291e-13),
  K(3.443840146101039827801283178691392798042421417004448533186277016),
  K(1.7111699145301953795482797596851868031039858094153219639814185e-12),
  K(3.453294616068205123144700215838817467576894848334042440102085608),
  K(1.83230823840343438123013216093513397316198876001735709314621975e-12),
  K(3.540222845970572391182538370512750396046023147996152481959614633),
  K(3.406432584259888678570890949890548758463633941549047227707145e-12),
  K(3.554005459226740763227094020637946394570426035193947892793422572),
  K(3.7529872534428043179655454136618379182033748305225882711719059e-12),
  K(3.74300869009677361429389806481287177828894999013051737933262882),
  K(1.36485406390546231887853787062293603392013187832002895177429977e-11),
  K(3.776900976805904210090429175968056184782556242524920734548545979),
  K(1.70822690337691085260747552034300643683630385456048883735290062e-11),
  K(3.788229468883504198397493849777583524197242891808333780286668153),
  K(1.84043269813575035812249940183198741099301532248159496916678937e-11),
  K(4.133539943123787394719252399678033829623564912603964356958913492),
  K(1.60755616050159524238460201819471084646425314099562284469805602e-10),
  K(4.231225426801237697958548145571136064596845789474330985457034243),
  K(2.8672896079644755680080363951736412987338787890732609443531703e-10),
  K(4.329749168491688924620289372395725057421368271853706886014289328),
  K(5.0669743434878870517804745268555511907596838495579029516792368e-10),
  K(4.374732409135831489672233125497253988163919976917290185187288803),
  K(6.5410828223862763910918747995676508283378587346213228041576611e-10),
  K(4.391858684245273657492124004848945327259856449560791498132266947),
  K(7.2036071215949675034067012128460752855535416740260809565625558e-10),
  K(4.623758760105604462304735228054877413148329618025201525175931498),
  K(2.5588211801743451450062638445400756552519690814162204624156725e-9),
  K(4.705300828014744652829996487250064408172960420893272524118711587),
  K(3.9304271075799112729958791931321072163298668986090978720837763e-9),
  K(4.755192366244650594863450315864535235695121421266634341751264485),
  K(5.0901242693285381264264204457716439299347328870281972818941783e-9),
  K(4.772797286537067312998825941351445890106731330077554176503244817),
  K(5.5723385494893051060179939732561696821946556695757994212539359e-9),
  K(4.86062644467513981610011490707599916374933029519582256392220887),
  K(8.7045476709879259916505858591725828017339824865178810539825429e-9),
  K(5.037997862734078758629973527932515994876090725845862012988014735),
  K(2.08507347776554117395883132368887129419342169656522020422473411e-8),
  K(5.198351466990546363059692893469268114962464211243732813536473184),
  K(4.4574864746559230495884344735212773121152172377567370378508638e-8),
  K(5.34224876108285795876389169797981642186336237332030923530186824),
  K(8.6135557265126861402689651555409193574091304255870664660175477e-8),
  K(5.454476517817193552566143198107423321564571230879206253697851839),
  K(1.41904584276240495163702925469884809830566810693144011961343556e-7),
  K(5.537779894032613218348009361815157189448707088440696529517628835),
  K(2.0392220380091804928639149883878607450517501888959473516780494e-7),
  K(5.840012544105402778833264047079272656388377982878765729128314247),
  K(7.1951464696766918336174202687376810580804270098843110843816474e-7),
  K(5.897003858203440220108405669503286637357838155000453718382031286),
  K(9.0422846938130202898193394256387954250927195935283242879890745e-7),
  K(6.270395611147176588747432838819859699627954981762410449424533951),
  K(3.773294220310844138721030690028623663864368445664441383352815e-6),
  K(6.301906678173223412727816663982584394114922047909217477220157478),
  K(4.2344790882766049067314465133190328615206473270790776103030488e-6),
  K(6.303983418674984303176569025178050579249845095633558299948681593),
  K(4.2666633048712896257563271906623539284101923471316537825377052e-6),
  K(6.307422077527786141458103636574128936601894113555787976284800294),
  K(4.3204598914742053466467685244769356970178444409000362024922445e-6),
  K(6.330380848486293415433384985137670067504479321576331189375088987),
  K(4.6963134056169899102323371655520582984505929875300823041225246e-6),
  K(6.337192549029099393928237359613042792582364815817348936765697553),
  K(4.8136049288105160690675839172551161097789615738193044391281178e-6),
  K(6.342829727840532148439940764040413471659355190586565141953362798),
  K(4.9127478736735316183611942458204648759243408462127940392059779e-6),
  K(6.345985972542699844811248593429979364313117562405901178502596289),
  K(4.9690923203375396138224413922677053752564491198143269470303797e-6),
  K(6.521506347506494228347864961781782588547242416396520123505561836),
  K(9.2549801119437249776298746793629944825408699083644065137421908e-6),
  K(6.758401830700631696929837273007136086126217667634451415609274297),
  K(0.000020644499879681237573336293432974282261025566283635812187869577),
  K(6.763477559198375647816604794103705026651806006211507334686386311),
  K(0.000020992908212318930114941981027300722475118286522310159812040074),
  K(6.851247888033835982934093487669276212808375979002623692065711765),
  K(0.000027955953351533028990156914254959537761085254914236156679406844),
  K(6.906772301257499142720326935599543940008669083193814253095051999),
  K(0.00003341424643176547139184134335436128037484988811677630565604826),
  K(6.968700511546421349194986559111045458759313446825930186765349034),
  K(0.000040663259557869990731829822589769825670874481761626169793399418),
  K(6.989070584255401373311262665980555481891921666038339012061172792),
  K(0.000043350502744749224494150084854989722887279338334937226936737565),
  K(7.021165617729787707049330738124187859150078956623569101233267352),
  K(0.000047921179747059286503914067290744349833636034274029782713205177),
  K(7.501355464504383544431265269151519298606945775386914541275527586),
  K(0.00019751289773221533301323331301606769989312449619519220773973177),
  K(7.78754413272279743820966544255344996167575840349823480253471814),
  K(0.00042772018979258599470418092606641658802615375673131274702255842),
  K(7.912070238177157932594711789867419776655010482800776971144122442),
  K(0.000589180140400419503923897783308948893695996108470191417010487),
  K(8.138186667659206981911845186126925314161888205686322872269130994),
  K(0.00102891475012687402613883982658875475119337954981241810023534833),
  K(8.169021999891122685025848079148623081567777753605497031354495114),
  K(0.00110757596429717035891656482381394590941524140137713739980402516),
  K(8.232401546960928047356661349773972343814648525393891925716366994),
  K(0.00128638951736723047625588621801203922179382158678146184237909081),
  K(8.371959046996579121669896508324844722077838278743996136374930088),
  K(0.0017738362816980120753480419014889037433731235049492374571489484),
  K(8.607372503765149821403619501205920836661402160872422584135446964),
  K(0.0029738633489137329161747949459734392990218856609357894003516514),
  K(8.696119887823458984460305861460895298820853067963309033836532265),
  K(0.0035842856061467359495692969590895741246126279576941628829457466),
  K(8.833049294105611168333121336835394152878420438002806350364041872),
  K(0.0047401081249989067135766905388920774832605962254844655205156029),
  K(9.222113024855221532278071063062548692124710552530247843658526447),
  K(0.0099214028995906118964569915098296956112561573516653425538687657),
  K(9.404401315293630141224621779374500479941259723397273056408907922),
  K(0.013641630320810666522190390487240453452024218427269875962366766),
  K(9.405716074663240890337269759852063707158593420200190426918293963),
  K(0.013672135784262587284144451460425726097731182567303446335951299),
  K(9.534182341722883740583695248089311441523965225838594461056189694),
  K(0.016933673255243707983833502276824081492489141122926637502145421),
  K(9.922487596638519948603491612409198990021169599134319767383740467),
  K(0.030715297353333773424301259896264001249854041580443035791731731),
  K(9.961316269667633201004088504936510067672501816387955406541176174),
  K(0.032463898512477887270856608436557563963732368796990816859397722),
  K(10.22884463835364437147296305063551357466742188120088129424363915),
  K(0.046586342121266128576707830600024201731978728431959089455038128),
  K(10.52646573906323553565902877124178320983937120090061932828791984),
  K(0.06681762655234952605314961366017605507845476078729635414671932),
  K(10.60461335767654260022714530873940064242702536196624415087427614),
  K(0.072935314464730708640980470388872438128171814753356881985906883),
  K(10.81926644226887057379835225533459162600674413069386006269101456),
  K(0.09139417619637672442089769350318507106647961752143580634513657),
  K(11.10067074174281875145596482050790989021300878774948823899622446),
  K(0.11885277546289165818813298280955184764842741329206944437019426),
  K(11.12209533138600129509566490313569550195708078048609694472949498),
  K(0.12106910472997670517674560290107161517944930796248539832184207),
  K(11.23793949582516416496440578946087600513183869820805724272836263),
  K(0.13329252468364053203776187780787180163587317008752864220348575),
  K(11.44524174015865629149634628947587294209226417862649760105913436),
  K(0.15587913126651846011390902358320396919642606058579813943062062),
  K(11.89829548988894055464257077521395200387957372994117744530143944),
  K(0.20482721004528777865438036755807678852811564542105367369082397),
  K(12.4686383859092801668416870365670269409276257142485913858371174),
  K(0.25283189242291494716944515814197327844223139679169732571065732),
  K(12.54328741562241920463448239077886232940512952288051908244070929),
  K(0.25707556159790987289036452874224744244273268285824512206452261),
  K(12.59278857018941549263889195008838840053589872693022386909281969),
  K(0.2595680761852044475294513852453923173870513468070511777435028),
  K(12.63741341825584216495230286443804122870092067441368486359087707),
  K(0.26158746551628225639162426845801168842924336228676749130145179),
  K(12.72677964519049847729822461096122831265944903804307206153908762),
  K(0.26496161754038704844326176102335187154028055080148986085290795),
  K(12.74728620898340633867676124840270751952696676970661873191121445),
  K(0.2656068971499960963434653298106982135054996753080104717978818),
  K(12.76625864569589928605351468744656457218354732761850379903489998),
  K(0.26616031702376091085791847426956978963998860128971537411909249),
  K(12.83549895902016321510743209568070951077107224309587260390375444),
  K(0.26782055637252219711418916975375424181154713416555639799287119),
  K(12.87850975772973822058691981420767216617809626404028508713497356),
  K(0.26856446004215031038508581075345700664220340458643505711556123),
};
static const R b26[] =
{
  K(0.2290893825859197135808195577060716098217656197590551832909068863),
  K(5.6821144785358829990749548989121157666200506142600923087979555e-44),
  K(0.5636890289809691837595059732310218398212495181397598313244418455),
  K(8.3446881710240479461703255817154083487078783986588585203590301e-34),
  K(0.6226132482221750034538280019780946297514424395498142117190418128),
  K(1.106772269666827465860065235162116011570388127678733166522787e-32),
  K(0.637798012781228350137752628042343516398821962523138344902720951),
  K(2.0708239486156568764030094844901556018415536014053768865592804e-32),
  K(0.7979959271400136001210533017137993446294876055688722333239866208),
  K(7.0209926343168309297645670643125097285881578285710595468528393e-30),
  K(0.8918792126034195987052236363601794517200496879340122816783666966),
  K(1.26572121368484155819498354692146612296845344282681522278684155e-28),
  K(0.9256308467530635076362329161050302700181751158298780929945897287),
  K(3.32479038345795365859621325421611595286697850925128400189535483e-28),
  K(1.101482003002047207767741595852858352629068907512293729107071713),
  K(3.06050800787363742052978117925204339090157089863793155570793355e-26),
  K(1.136087333475479388544684201592390223832761884762374549637920067),
  K(6.8404651747843530560978887289165564420617951704286888959568468e-26),
  K(1.195606534941608739233675932496946751893234189962408211961166232),
  K(2.58033597173073803997197966653527853246215257255005474003661786e-25),
  K(1.293272744581301721072119509127918522921046314288996993658444799),
  K(1.98757819499086828120434232055233112159259086139707875447938805e-24),
  K(1.338265966855683019570114712355552987897238962125256059179983279),
  K(4.83597723997278893899111158350763334444824837519472176847488e-24),
  K(1.354924524190713332943666719119640620951204537474167716226976132),
  K(6.6707346669429076555327480544603566289389742869572174537487898e-24),
  K(1.409685205021093763841435133201296897135008974703944689927448931),
  K(1.86877346354300142990947188055007765753162461995312675026383832e-23),
  K(1.541655797443561778151569799351050965759334305738572461725475412),
  K(1.91449353659815114697438465097489138257847377200504287356898248e-22),
  K(1.714251438751949693802465661843262490602444871513051515132080682),
  K(3.02216770379758330562289949096400336556231529108786496470154378e-21),
  K(1.846972568677012398210153092208015189698880260051480900957852315),
  K(2.1006443641046529844184081206310149459954571526833065582632124e-20),
  K(1.897586677524422379388519875247007979830711442291136086903392993),
  K(4.2425123976457563894566743069431268131922370708596658299067895e-20),
  K(2.507484085259741025062908804220726570935795547622534906556999012),
  K(5.9504899584039437812267499830764740293913710508785430457906537e-17),
  K(2.519814698475639533210278907100216690931650938267681105959662029),
  K(6.7599235635048625073097153183767427146815312584893305600090446e-17),
  K(2.536569606742494751074403869657640943612132898613743270839850921),
  K(8.0310386715187403644353415130650863348263972038671326434858924e-17),
  K(2.715696629150730855333904764190375058414497407587039141236166581),
  K(4.7338778278220414996673306166219694796397433266534356422863337e-16),
  K(2.722715222676169568225538737261174203695026001258007364661932014),
  K(5.062431065894447077075172808249347966250286593645533092799566e-16),
  K(2.782236035657796950342072205482000079158919961798202071251355874),
  K(8.8820776519708177744528350511182047503309311397397576970141411e-16),
  K(2.78295915692593713146033000514623386886811505133403941876213855),
  K(8.9422857368314439188339963981865933587776918197098733016311905e-16),
  K(3.186714992777995448356474450294448150576661581645881067674843322),
  K(3.0244639886040545991673521734334244658392909436115626940260767e-14),
  K(3.272273116989669889474106411722170609198659505811074560239044512),
  K(6.0196998541510500418542933859647913772849413133202926607683751e-14),
  K(3.303067192524865888534620920490325830200420122509764018061983706),
  K(7.6778342157345021733382466197127738735049018088353585636742607e-14),
  K(3.333975264613646728207811192715789051721705253429847881491125038),
  K(9.7790833883718832245825306872361235137295196436229482657565633e-14),
  K(3.6485255569800167007198366977632232057549535090085974912961847),
  K(1.01529289167741654233875933088455715619408317131034378888163594e-12),
  K(3.734102707128976688783701181452172195239529494699460448978907506),
  K(1.85210468646383215634159911289120781406348269628715790449694846e-12),
  K(4.172340576330813434365685935829480890495818855914758937629623352),
  K(3.2712452821233568066292928470047327444332904926750453192979966e-11),
  K(4.192928201165480093448374330662223770741556484590958890029930618),
  K(3.7144728963644628376906256348382574687062464189592956145374522e-11),
  K(4.422974810665575703901965323284138431434573285378075694565069831),
  K(1.47147795415174048316304511257751414671372156185625548122250444e-10),
  K(4.474992457054916236086007742693896951325536785583534531516700237),
  K(1.98771623140358476947184344790955130985408904390019970962681472e-10),
  K(4.671802725328781774558796001871678821150982488738545973270554467),
  K(5.9993416143489042450002210263580962973473692232003382438313802e-10),
  K(5.046591005524268340825754634122989122206732018119816903292227897),
  K(4.2983913360865196315145920801879032908088861141012923620049223e-9),
  K(5.149605555688000074228949755433754420187429889840667230352595066),
  K(7.177055419352057600757321487135730426177502167196509717807012e-9),
  K(5.254762265508881677307347934589615723851717148242234673316978287),
  K(1.19681784048091387236824049827582345287687428623564000539875209e-8),
  K(5.282896356867827461413868433824028963403480681537248783299620185),
  K(1.36954758652023069204883133592618529989905589381177212975782166e-8),
  K(5.300690110911525584389684099590770125329040592197669439472908116),
  K(1.49080539673287267587144309490663846956394352881878574484581778e-8),
  K(5.371729195217721611913704553480967171773414728182871999192073007),
  K(2.0849368992272411054346561481813803223818064375979036467843903e-8),
  K(5.510572094363265223256314511851296629713020091881184265235623536),
  K(3.9571111722832946038376244831830596837567325469773463790124207e-8),
  K(5.779790750521983018507671816701299219317127306392487035496862272),
  K(1.29958102337853905691474110832263349637042717959663276984680439e-7),
  K(6.156960768280499243240871338179514813123319384632621456829407227),
  K(6.1552265865388055803069358806212684163052001470675023109828309e-7),
  K(6.389683137862588940888474415799463463302233779454853161252842516),
  K(1.51334230738748296177374633158609770733999369659236392966027375e-6),
  K(6.412732276155610769894560411797371438014557626875802850604435617),
  K(1.65044033652598113109799809950921597641089368638162211918012065e-6),
  K(6.535323368367422162903058023765986075633571144958214812076003557),
  K(2.5993990679082605235594281524578016490093170351357668945157241e-6),
  K(6.576241396780931092251044871674772710828326259373780895638487457),
  K(3.017119500070707791929969029998153030816480034267676408446683e-6),
  K(6.642858353688399352380428514004171343953485287677839992185476181),
  K(3.835069387155835339167848066471702023983726346018824728294646e-6),
  K(6.713416317804704377389554054030653097911318694309226060518071145),
  K(4.926436620806756035671046302518442231065281793877102963119586e-6),
  K(6.8260457482737942435417682795899237658507660058726555382812476),
  K(7.291545810779900987221249279591105134482869861667353136310391e-6),
  K(6.878174584201252535439126769886907585679755637289427580781407174),
  K(8.7150839538358674126007919729785597732690866687442794745664299e-6),
  K(7.007657487047567538598190756642870610996571425433557403706266643),
  K(0.0000134583275446984639464198199304454596024533895799518055636252887),
  K(7.028153524114122651226533995206301380616831705086736636855764116),
  K(0.0000144009358443523706555619829702958170300778749645801824267937921),
  K(7.197340736574148137441374500276616187723327061098269842442586952),
  K(0.000024901595743991679899605232585604165025472525048630366140124784),
  K(7.342775529138532088822412724062706232465712500450780951741359557),
  K(0.000039254926481336801789542997140563815147160127596548484155163417),
  K(7.469098866805160580552607164541784720678361402443205204187113667),
  K(0.000057626535343601762758012586126719270537296852129723902905584422),
  K(7.716458392608816067892498008591374765750332311183449594548738299),
  K(0.000118603495630815772014245304511335243501388686729783324303819836),
  K(7.810020013472836995265995181477091243136166890801027455498693511),
  K(0.00015427102151422688278149495944566991946130074062913365937916849),
  K(7.834265968528249527722470133452734395290917809615898019473906867),
  K(0.00016500220532475683128870006187891899560890183041873318399973512),
  K(8.139896379584872636869266059030994902348223590598260266897016885),
  K(0.00037350409112178971530052767868309042736254237763808319926119289),
  K(8.165220899890457405804906319693593654829956450121161122046398575),
  K(0.00039866048070926323129860883005170691299541498601823832172228734),
  K(8.175801043641172377851514190877886504212958731610348911133457803),
  K(0.0004096198345818889269908833576688624975021265434461854684060366),
  K(8.284255612233656215397614004199880021498173289810582522816050429),
  K(0.0005388484810500347725664133016974145053218080686290266162156164),
  K(8.323353034787614655948514869705904281787996152332597741533540768),
  K(0.00059383534738779142988534396273319646619598868930073057457284011),
  K(8.756623131888017526713676241857892573091728176360448116546631509),
  K(0.0016443501839189525252432818703472512085242393268582603495532772),
  K(8.8940170804199528193513796886239426529520158437406624679711714),
  K(0.0022222143720708933678707058868800140857046522860381403035457585),
  K(8.907927088994694713021187990956126316596312663383182589824927996),
  K(0.0022897001860594639070578876295289916749965915679599959516956123),
  K(8.996272168789903138163917784488234286740177491166724454783961658),
  K(0.0027620910776067770856073745864047663534500556702991017057130343),
  K(9.004609953615776861821421947477510116860237763696081039539032002),
  K(0.00281081160795204678018846615596632095205350602447361848710957),
  K(9.050503951510114797796120286210132690529758473033472941798153513),
  K(0.0030927219764611650366354039664766048241530845268188219408917773),
  K(9.059049391670842593891053518298125271569206119690697617409922146),
  K(0.0031478634411161481845697921267710806025002320280219636024181885),
  K(9.15064256854883742241300200860139373662750639746060790454814217),
  K(0.0037950743710060769696413139183200458994047287571023650922077564),
  K(9.58856494535693274349842474034031416368992564107713917920687355),
  K(0.0087326730196405219404150747564571618236445994827114181517221135),
  K(9.684460527034473878632130558095460492709922263734528157781944979),
  K(0.010344242399194568983263468119866271882605965505821056265367252),
  K(9.893982172650604039642318372033812983988079213420259588012095936),
  K(0.014737393451079045578690964551015545821891154562933188994460887),
  K(10.43315425290999962121800937564108152389251605373790285477240797),
  K(0.033182008963396159599650022736411304884202164061532599553894277),
  K(10.50235500817729802157132825957034099854070109666964263801673769),
  K(0.036453020974283088352240966638634806590956964688694114934096112),
  K(10.60512695905045312695546261076625228410469794481320047956603624),
  K(0.041739767423705453709070612298790629644745880779072022383676211),
  K(10.7427687405537937359298467017878669399979514464784281316927043),
  K(0.049651380022201045836076716292599045058387687325273474969831063),
  K(10.82828412947602000315113707810586172580050257961829894130491665),
  K(0.055058129382611673516417978638827632755756745459632340574206833),
  K(10.97489561885871885502449468886370573777423719829667505169558798),
  K(0.065213972839471589213565996312567696090795894680390716236936404),
  K(11.19252791709306656420402212631148754395819920145030373400324947),
  K(0.082322228154232569549580809815039117004551617893227009568221059),
  K(11.21010858192479698211814872035732973565942165046864558835816685),
  K(0.083806526156629570290185931074469048923293597215230128144886408),
  K(11.63199291131015624900181594474700527849044289568017377385033684),
  K(0.12336727265437410508929137655969688263579456147943389973118405),
  K(11.65306522448903167825974197048423178447187489629602510118767462),
  K(0.12550794791692413461400130686672425209206134176880587657064736),
  K(12.02644943614053742409932497274350649417710573543727532245989418),
  K(0.16471937036851887111104122941238038002037149241948572703883706),
  K(12.05526951128413189460605204916677981801869603734425078107907867),
  K(0.16777881686963768630255814750448903317546353627150728813008982),
  K(12.11223011163623753325825389603456479396958251273194962928602898),
  K(0.17380535365030987499515387535640799635777176043193210306280461),
  K(12.36763495599134101675041402736470873829844415691203928308246657),
  K(0.20004386709984483941151047460327846084150167143436385294469145),
  K(12.46204491350106866803231700378630644813340085821618903873448274),
  K(0.20918811069517024208906264334891644332384386145794329248231713),
  K(12.4699069458895642797107629335951199527185172636990743014800721),
  K(0.20993110695225136669857656262008157459206762792093549544291328),
  K(12.61482661171428606257768711354056905583081291310069603975516546),
  K(0.22302337417106005853750915065045471678101222546234797600638665),
  K(12.64946095099566034741313842819969648119346618915814979792706867),
  K(0.22596321867493137902431245153298120267080081171161397865082109),
  K(12.78597449108490326564814040815578857431281124076529941860447894),
  K(0.23672035079584166414068489734968191315736528169966831281388288),
  K(12.88540735172442183431896940034339374489134159267281944012950703),
  K(0.24362488039893217607143682714494073882228680654493605952090335),
  K(12.98304141981645158118847416870423712219962592992197962481870498),
  K(0.24955096605637477944948679646714543992105941781855898244705577),
  K(13.27009028525120421847861713650410558595978290065262860096025551),
  K(0.26145888516206068927314841525609457294366783452640434732463013),
  K(13.49304530194604162587390886788730158804121191630746376920465234),
  K(0.26447706249323006393954674624653902134946597202066653081597604),
};
static const R b27[] =
{
  K(0.4879754450119812325577635234960756748716443009356335335327277305),
  K(3.54619298672917945887738222591717921733667722371196758882580682e-37),
  K(0.7956024605423168633631417444339971771528565741133176972722403721),
  K(1.91342914115601851284070485032320650188824369584181792002704318e-31),
  K(0.8113633297962628729008428800804231420996725519827357207299435628),
  K(3.24961827464277590177162247729945574621356629515231573797276608e-31),
  K(0.8729785123178196687967415597507785442263125134978694699801942955),
  K(2.34483974911240932677007332970991564929677796850169518947880756e-30),
  K(0.9049347700687930664128995096102927410158220099497186864379329111),
  K(6.1899001376331676982953087273240931781986211898544501309051266e-30),
  K(1.06713020233155607557356009219335431863050456289712159400920738),
  K(5.3074672569375546445708868903734538236286821855608130730088363e-28),
  K(1.319818818804666208734873416275670509428387544394908953840296118),
  K(1.64779717854325443254001511265031282888013726563205886598174263e-25),
  K(1.587745048614767251639521629063170516576184359258627853250568696),
  K(2.42157497431446474983293249995274690521146677824448318842398267e-23),
  K(1.729021186536062876325813870653866336570818541396425946484827727),
  K(2.41894342559746520562765951126335867441253145842585949248735929e-22),
  K(1.840183066643807704872166754557984970978137355224352633180387441),
  K(1.30096319853791050257591485126029551378791374805572470338023506e-21),
  K(1.859374742024453355775711472126161918925919262632248585658269741),
  K(1.72156819745545963193958038711619783123594334582150476605832616e-21),
  K(2.033519656561028612104756008274793887298405517138114527751140897),
  K(1.93073730068891902853668134156253948025442611014168181419848954e-20),
  K(2.197503319821045624452564039297018172911570302138934807757121025),
  K(1.56716188090287738742618289142111930423042464722740387915624375e-19),
  K(2.277074212758964179397050787988497493698007644578207888541529986),
  K(4.0944841451244701159978227984887671112163683978240931960649593e-19),
  K(2.340368405348101564154522077106081003474448529924476377607086937),
  K(8.5839619449105156550500593287452831261685588866146010243321322e-19),
  K(2.346201255604331975515993470406979544956214233809203207056657233),
  K(9.180695479804193004693620541234386284326452433063966924320282e-19),
  K(2.487553048158471293525314625894540128294049414835513524741216032),
  K(4.4551190589933380872942079760902962195424415339112319236436442e-18),
  K(2.536871328398471199645807447627136709387821802071084457069056953),
  K(7.5693562291869906160599005195517113044707715322909159691724684e-18),
  K(2.642688710814212453033235259578547034447634498223688499734637123),
  K(2.28153495528561716513531762546403059862567900939710721234479257e-17),
  K(2.854850969911988528420744191401373077906876578113790565890994841),
  K(1.83511522416440376809565655616434185923916495730774532328908635e-16),
  K(3.15893350299122905240583965359603791879754994794033342117118516),
  K(2.819625716662466163650537459504677896992103950523771913035343e-15),
  K(3.168278182849891159842464014357974839646955852401758814309331168),
  K(3.0535985870169954616594813658288620523232309434159606681445954e-15),
  K(3.259236079464829180247448721924230037239289049088261853033303439),
  K(6.5543623586132153364760971639101467541824907233139189198832743e-15),
  K(3.334978262686280023114631038784389498114399284534137101163304978),
  K(1.21821521525617925858144420890334789448253423596928920864107942e-14),
  K(3.359492200428807366701514564821612213057672196275120810402128007),
  K(1.48432925140020591290899011696469107983478793054007604798750665e-14),
  K(3.694217200669152203513512242960635365774051373266233168975777846),
  K(1.92175374443596716111882740199730629803941679118873875626127027e-13),
  K(3.740738482816203547281102093720814059678525767373097593844424775),
  K(2.6922696614595366220754056907637739487469315379235617769250203e-13),
  K(3.792713278248528675411818692193812428406079568837918758969937008),
  K(3.9041198219019341926335509313838757779581316064975289282508537e-13),
  K(3.888388569081602387205078580570024180528789864621639475424562136),
  K(7.6350098609033760876380621186053367947778901625239831334197145e-13),
  K(4.329381839803500102495777306279336627998387459927465260694673133),
  K(1.36862242419518813207449083393534942918638501616729571740334238e-11),
  K(4.556049030812977439052031972974058302465271102525489567445566107),
  K(5.3648286993106780284244580002630937189620358660978511317496861e-11),
  K(4.682394568492304528453313749295239535177358992670049312056450541),
  K(1.11370211778946149634958150779383832812471247930310336463546396e-10),
  K(4.682939187475848363278833789449866161605532829458393656510410667),
  K(1.11716274724382016121254544009503213129919565858956512365944505e-10),
  K(4.876910514348365933454009203626983382035775459979311562167965384),
  K(3.2924651404628437414268850201207839817684596397550917722476348e-10),
  K(5.006361040129323101566688280458694196633505812593568977899166351),
  K(6.6006120198689196078516864088239295482875485388299063061979129e-10),
  K(5.030740385867485283068650835593576667941778968071859448898972261),
  K(7.5077038274725709037206578312991323141414035981125113450864074e-10),
  K(5.03513760633230877066283707793014417214102556789673508851742307),
  K(7.6835476167072024564423823258248876357506125177818665522326494e-10),
  K(5.466300227438653069675575295009293852943171603335044879000077899),
  K(6.7023810475614672642658859574238306555629574489886445054889055e-9),
  K(5.677527078915781539691922227759694661052673502960624721200101163),
  K(1.80480463684131170648378059003903789273619289802377762512658286e-8),
  K(5.765661511733902265762191060108744576534592630729327454530554248),
  K(2.6938779203310793425744282084030791515053110383661627058065258e-8),
  K(5.940397336719550579608628123689406843698357277449280509734722468),
  K(5.8341479326495440737609365390132424135717550758366333527466867e-8),
  K(5.965307215827391547945875723041873857653007737073297111921185544),
  K(6.4989075996491286059031979552231902472881760024674485141097968e-8),
  K(6.00869486940634718510866860930781245392290532683577701702404881),
  K(7.832380054891760758026187267868923195206211583650647678704302e-8),
  K(6.444596800180567364390605888895598626588104663347713974044970898),
  K(4.6716686777258582409466269140065179883710326202383596605538359e-7),
  K(6.63925294055162618353703130722024248168362165788848773713582845),
  K(9.8669629127353271818130288648628584716801204354092786587370066e-7),
  K(6.858437637816507059775799115822843194198301762658322283484826867),
  K(2.2119107700322770950440515826260617091816492694675602989751655e-6),
  K(6.866773735003001885337487777488229947922598552622076145581016266),
  K(2.2792677677224061789455679413289528666897104054225325516956673e-6),
  K(6.996862013230294193071327641135354783201167886379032922646383349),
  K(3.6162782830344378201833716355111746765829965314457004553070547e-6),
  K(7.033605131682410647151238027415182413629595896723744270128399753),
  K(4.110815098708956682588199525069280353231419593897401686022594e-6),
  K(7.046244947305024488107555343527737084440573421663476794493495913),
  K(4.295178052985080240068525624985598785055410708186629762282982e-6),
  K(7.223107104434225172284541488790679062614779570191054546426154126),
  K(7.8431051939482013516086826108877827670615047411916371368488002e-6),
  K(7.394657062838783767481586371528856800137208228210925665595158664),
  K(0.0000137798698808373652443367441952070599834547452388682604614240316),
  K(7.534186512090329474776846815715968336608604145333815579778799374),
  K(0.000021480009448452235516548843818289122129454152192010335007463868),
  K(7.54056049830038968295305390866249671864931817623587410845828464),
  K(0.000021913371103367219066821766492422753996094978341617779609395933),
  K(7.60692749544848085078118001299184611602065321642424989000140453),
  K(0.000026937232090362995649817840792357726633304125592628307431956623),
  K(7.859200113280388640416868860432228760837261976686497292924172996),
  K(0.000057542536126616352791972451609746245954639138803129881077886916),
  K(7.907173439717618177886790862740071238573748467306761339825517465),
  K(0.00006617881280081956829039150666502178228801111472313116346376223),
  K(8.140011562482704214624637553819541837000154516628818610561433431),
  K(0.000127886195741582855011084869631889448798124869751838328838596403),
  K(8.270927769561987149870094979350026962418597419647516489936984869),
  K(0.00018260415273306091088195059547736358305701869006089893160890952),
  K(8.273628490464296929597911510638592255121672693402585460322344785),
  K(0.00018393132361640821530588803310714290927166788585471061515921482),
  K(8.384424681310153863534464903758301205170152175884195467494495936),
  K(0.00024665648044729675026714397478127812913162817296238312147671384),
  K(8.397127325754937519155593774659511166002387633898726642804714841),
  K(0.00025497993894910845047113495421520659787595962593114770180161134),
  K(8.601809118966106033423265732642165034289059201433519495106882946),
  K(0.00042977826683345269332523186262902641760467986705559094221472393),
  K(8.603984790036778881904005881545297629073153010308907355058384259),
  K(0.00043211499337620609833993078537545911816324699766818571588702382),
  K(8.612860970689149318419071457355648296736308219630973241448660692),
  K(0.00044176848387818159162103563368931998091346859942652034309341343),
  K(8.631201203964239517275600223647839727979488269264375214728078646),
  K(0.00046233882537644492105897298799700125455026069159814899074042831),
  K(8.672534764519827602023232102248553996864757986119583584151270193),
  K(0.00051192630365810941623156727084325584727328393628867147079539635),
  K(8.847512970719619044117946499168553977722067553128022336208997632),
  K(0.00077978373424977915478938211974006904031294448965471404613293482),
  K(9.018772232190951703897272333438989487950944899988823402194374881),
  K(0.00115834912928883163160949046881202136611092122550882839013797357),
  K(9.023332349342364270842774259831026223760282230617906533572922041),
  K(0.00117036702521671322602353408416484189959873120186650982118984853),
  K(9.215589704111767275513579749414015566855081567779015486634955063),
  K(0.0017903943959990781458195496845892151696314267487169067324613215),
  K(9.731115515631175576199419619019836077474170879055012442271944632),
  K(0.0050925092332132361476691264229546863944786410011776500646312537),
  K(9.783750998713763561399108839287486230162429957477903335831226605),
  K(0.0056233734766088051772680899608699836863177544212079917062420962),
  K(10.01909424736649271436965215765863366348650463597513745710225473),
  K(0.0086153853108796828171265598559602185913422227652282186913791202),
  K(10.21714303366100393592672957833786920746155907886122878729399668),
  K(0.0120809232487773642048598290350346569675621536151261723833287336),
  K(10.81472567336533331221789210517821901947462207105373105676283521),
  K(0.029925662415322976868945945616090297272773589481046847976981985),
  K(10.89836161601598684666587831552879221544423963242618678838546384),
  K(0.033528553863925079021647937607121828453855844837394348082553051),
  K(10.98614733138286495420133706355235148678999212286241085089175789),
  K(0.037647621895321123935114940266124234903477406759732034295723205),
  K(11.12565050406963200801833790190678201473634760131194119879094014),
  K(0.044933443005176724816248324474550084822692666442671046721019507),
  K(11.28870729582746745141744816764851248215236164442576545838405521),
  K(0.054642150587192023697743727939168013073965286670255348438559561),
  K(11.64269568740387658019155534881179621797435630376374197062962586),
  K(0.080202843249437746451160478782986706656612006365311942851183167),
  K(11.96735363173200136454544810374906676858579966590921521434591643),
  K(0.10862239537570417411008573457389678004585268761699102823572609),
  K(12.05776734020914619650288184702901902468981878273175602114412089),
  K(0.11723174038546278629022373419443142012635531389985864715435771),
  K(12.15414702998303334877510308315617894583477413688315229612654001),
  K(0.12666605866156841308405964457441284238671891299718510338505375),
  K(12.37971035636335249242032641618633656462724248139438399469871707),
  K(0.14945828286046529648332959715064087977232306021329769333111834),
  K(12.69091840667329917394738100115403024642339810787568374476699466),
  K(0.18117409046752021377089639249516720959449408038996139767127822),
  K(12.75124588964562690024028090281055913449680720003487756185967826),
  K(0.18716288032037579965603511439090806811684980201180642743236655),
  K(12.86239170805370326052620109935230007002035314479225600811339589),
  K(0.19791605089396679763912384366917835304735732876509649117451593),
  K(12.86731328407708378670403999342079973951996927186735973566913035),
  K(0.19838217140888183659880423784316071571803667514194403378142773),
  K(13.00852341288932406855894498524664490879572314925707650105428756),
  K(0.21130780944138899750462618623391319860698578922513334781937216),
  K(13.09427618123850752158967329475759847831865217561536224681939487),
  K(0.21866213675098387773311669159948462338565023486181004031913776),
  K(13.39200128729998180660741900385154929229472029759685810061759366),
  K(0.24037791434384793854759966907850036158069861955071847938195057),
  K(13.4036650972855430747974838304180482306025711891477250853888768),
  K(0.24108788135452703465510999858062935508936464405435452303893773),
  K(13.41244069443552304637915523479973337165529423676418732049465527),
  K(0.24161430893269324984913527672524989108456713118774948733397288),
  K(13.44193818725000226804701162741210009352459837080327183786865408),
  K(0.24333443969882103323566931640090048191116155429825533629641448),
  K(13.52921666158605434846182368201983944057194818148195802558522424),
  K(0.24796412053243020440530053758679310511515621719098140417424021),
  K(13.63089372455798258756892184539206451601493291229377523153341844),
  K(0.25244753405397358766492479699255838706769557001521345175526974),
  K(13.70814799400817696346849720513275615508163983726490594530596415),
  K(0.25516638486192987294079944705440213336950044720985676076250834),
  K(13.88590539060396775864632102517667854779348618668051421081969931),
  K(0.25905791733391926611621569756875088139230251240049071365355311),
  K(13.92774873579236121987169337731766735115090151110216572851187982),
  K(0.25948190793173819685540646380755513857151498417422122285610899),
};
static const R b28[] =
{
  K(0.211883164585198969344089468675699272364797539158272609836353194),
  K(4.4315922889202922877497278460838854178298980795820156509200425e-49),
  K(0.460723800383833985896136318137651243047742308564111522367852614),
  K(1.23650910674410785710079075760062948671181983098302399917619957e-39),
  K(0.5948739849006803984178554242384864011869324618254550226822577792),
  K(1.58401221365256792108286156232231710609962207717502556214947861e-36),
  K(0.7769758995525812122279364793007212945331576135686600967617377398),
  K(2.80072533642008443550759069565749289825525225974501553958575155e-33),
  K(0.7858749251558667620117117610466477332502485672046313742291625985),
  K(3.8526120052561645137394270560256969058896528002857235891478015e-33),
  K(0.9190663931504951204650530533547839369562976243622698753148929456),
  K(3.08725129625319419289347921388816824485800379602960801391248041e-31),
  K(0.9396169034619349141699732278734728158308157892946254855985132512),
  K(5.7343231879073784278333185824669299865678953981981737188494551e-31),
  K(1.24285714725753469260609153153099583309623040659916501364471294),
  K(1.44428590747654492437016702918613201721942820617300241589963136e-27),
  K(1.262650902513495277477903553769081893379258878242481039465183936),
  K(2.24797457780382929955704483657709682431137193287180607460511279e-27),
  K(1.76522462343582341686694001504808561151777360517536992613528271),
  K(2.66844667919397263106177753562455730587115341846404327622378925e-23),
  K(1.799659452964674507151421961920806816438299468852597965255776097),
  K(4.583407492379102054786286497884209002839621578692687277291012e-23),
  K(1.890048688182301602178045456760251305944771101457872199259903124),
  K(1.80760253259073770804074099383292557916289221431870835565784979e-22),
  K(1.9095155640359381764952349361324600330862538441342555706154526),
  K(2.4082903050788128552319635814237328777369063245241070249763828e-22),
  K(1.943072830254857132400024504884632083463815001246171863586492029),
  K(3.922413481586683200107439129265950447241868564481270810433339e-22),
  K(1.99181305161882536608425021416951788808512739454138674924902818),
  K(7.8490880821105877697133978482332282776146524924106522208281958e-22),
  K(2.089052891325226935495742121243817316375904650902426289330851588),
  K(2.9815577601331884649123065272877514753943335662297532333596339e-21),
  K(2.091465942928213957501153684713565383410135028809336270908661277),
  K(3.0795080101957656957806639036707549732862556635057853573806442e-21),
  K(2.095915904635678350915605052315363590623444688371926735840132982),
  K(3.2683375608989813451933328009594501990203729585619979453877356e-21),
  K(2.347251068139198634784557631234291628764900111181736027123283941),
  K(7.789762447504212192675859772976824883468017064434658481005455e-20),
  K(2.73214573930948585207356756628053686932652975474628595246886506),
  K(5.4692922878890239841049147232256185494525682493613422431099485e-18),
  K(3.203687153657536329750862337392972250769319881409862602089406148),
  K(4.7174452415830290457068836875462924585317115969463280561679756e-16),
  K(3.213521048238650922493436258535089407719600188789635984922324759),
  K(5.1399887258396582340611896476738476520497258966675208946294395e-16),
  K(3.292588332919414334012692251589991021994736382124871475486972471),
  K(1.01486408129747075331397905192728149100363209385666032452194878e-15),
  K(3.324242629117351468609822232284128343347907732337611972621170336),
  K(1.32646013799879695362256118522431932964973501216478611133235833e-15),
  K(3.334655665417553706346325519324156528553407487398888872855141488),
  K(1.44778665658332352697410415396324734597037291725178130396358504e-15),
  K(3.444512218640863319701398665245892521128635466132599298758303251),
  K(3.5857801894976960300199076565093896831172255375927035920912497e-15),
  K(3.67848707003181684515951725348830668579356232627732504565944781),
  K(2.25344528062554492617524030101513388548951795172070115621721848e-14),
  K(3.728440779741742543473229940482528121504081744921771180867760983),
  K(3.2855521469987459824301158034531197083451281214193607097975999e-14),
  K(4.104498542236478922705190107646103881936743449662203894047312805),
  K(4.8089223214538123527623521842757727999079199681372148325514453e-13),
  K(4.106585903667437325262132234625477135211548534098364870709115015),
  K(4.8776070026034701389109646484213005546323052753348773436710514e-13),
  K(4.123711405589267898350041947105404381474760602388293115353411918),
  K(5.4779302962337907197051584684013470951705526461255355365789096e-13),
  K(4.26330349450779953109712747797004493318582381900090381781900273),
  K(1.38555890324274417636504780893964213271163889930809616603440908e-12),
  K(4.602360814552795021826699219648338092485471034817918358401610446),
  K(1.16389992705605201114456368149086378474590740118504322274979225e-11),
  K(4.707901025445943690425956005089205190489284492310536928650126045),
  K(2.1829379273919294680953270288264683144386939748045762163933275e-11),
  K(4.863291876604389087020290918185170324550391354728057214755171409),
  K(5.364192975071064191438907833143381803732275391309676540401498e-11),
  K(5.077107803040078861103175093201651112962251762990610249896753111),
  K(1.75914183664924610119246070795952478729933095222931462949121637e-10),
  K(5.373741738127217420174192117555187076742779622767202763152735855),
  K(8.3684899608586983720509269318907842899313990094080849308961662e-10),
  K(5.472998778040288834832439687182361019934722110517129956542875267),
  K(1.38036670422007295345138434791994853206053596468828303421706523e-9),
  K(5.671538544186854808994655666649368773031100541977338873338235913),
  K(3.6438357757483807655126323735887235597483247918206252147698336e-9),
  K(5.697638562812883576536196218449274281882522908041285389868601602),
  K(4.1277148225537843150552710901722420848689717796570256471381841e-9),
  K(5.911401691454011195863181519180596368941079251788708865851228675),
  K(1.11830777495639894779431126743060277020014391810211801359690927e-8),
  K(6.142710098739221807906324779497815996278481247735195116540135017),
  K(3.1362435731963352794725506184457435017703181317872710451148193e-8),
  K(6.298152121910668337527986404514062210899082753260145115006521875),
  K(6.1089531327852963829463440575601530417469405832885395048463941e-8),
  K(6.402129618732815311800647185247112766386843960642419627069048413),
  K(9.4348632105137836583328844682852328808701171098461751984209537e-8),
  K(6.436117525985899892211682771078582008006206612424587308525183887),
  K(1.08543441967919969775823230313545212943494199622392816162540529e-7),
  K(6.618065866577524571588986501045411389118230087700882846318315759),
  K(2.2625926588456160075749033535582292142224521737886924670017757e-7),
  K(6.949846266604092170446861298576109735744404899874373705310084162),
  K(8.0861236774694985752185808684172869961860999897516697398167884e-7),
  K(6.954996804413425007328091291003120066915315326040159306560447315),
  K(8.2422642355857387598442723945425674274433101645103792059847773e-7),
  K(7.038637025192272963489392864830945485495483797725094662951635113),
  K(1.12140604777424771804574957020794046845204839185631588233810381e-6),
  K(7.13488377996404125453216895794675263766970783070544758959217475),
  K(1.5883325263306917519378532980043124591828033750702730622726039e-6),
  K(7.497637417144208642351175391204957428987755589129970753974036922),
  K(5.5678104857678548611731573607024130215790109750801683790315444e-6),
  K(7.66411661864319914067133977499521984371869076589104504951240699),
  K(9.6140044359552431090436472572537414712026496984292632391376606e-6),
  K(7.705524005632591353467040957495222311886391926876403240935652837),
  K(0.0000109824014810653427424378242491176493392207604907644605394537472),
  K(8.059324543679829771052538883493395090210626991023010981636821489),
  K(0.000032766460242378985103496940037174184328907261348277600631016729),
  K(8.079601349199066786361774460756877715427860872445463847460295893),
  K(0.000034803583201262704083000318046907198751415540865450849760490836),
  K(8.104613817373072705637526268749436929734052243908645715798075234),
  K(0.000037478980125203502318832367799083027805183402932398801092407221),
  K(8.153622211689888844665739984230131986366655557246335534583715695),
  K(0.000043284782238780382566043021154917725116074152692833802866831137),
  K(8.374625943406027046603802196951995775994093969513848200452607705),
  K(0.000081417914543926964168254264062421183914206257521676710741586767),
  K(8.424429993432841295287251825874032816418526598414879915315298519),
  K(0.000093507074717246919730129089586806454203138864159317681102485162),
  K(8.641579425500858788390741931835516076872240155209518708899712832),
  K(0.00016819090418848348614087946369264253112014077521672821396885332),
  K(8.726463201301971985428868639756949252334052095938862825682073482),
  K(0.00021005514353618543766166291002679870187675824097376147810497949),
  K(9.326918668094409351140340255322435302495427971177985198017751604),
  K(0.00090506083095734193447540421853590579539876428285650722856505521),
  K(9.382637910518873963225201954104804429709894153500429926240074515),
  K(0.0010264813119045433514331776865507033884087041930451159139637758),
  K(9.436101251201940480133034275932421686757513449187711480351630776),
  K(0.00115653422300691211576503704666472340643635176994182806337348683),
  K(9.481024698661641843156102126525691524848314020573112920301974683),
  K(0.00127702445030472245931348710119649522694863188684620075486107412),
  K(9.53685322546909558294815392290054748147529209294392108470814949),
  K(0.0014423342697254043512056175117138811971764116664728671812888271),
  K(9.822324953826822173534423543027874265212058962411381615735359632),
  K(0.0026227156467109116888143999976757490494968348790761099737627205),
  K(9.826424158177642926722205763566251995706265157016986181047717261),
  K(0.0026445506608267718808633133573012685600815013612944318588166745),
  K(9.858775364751088876770966365731638751469250223041516486406637968),
  K(0.0028225561764221817625704358950417799097116553041600775686012662),
  K(9.888438150982112664873036583830803684606410709150454952267639929),
  K(0.0029949247811571934748055282847027794821484157205696679319423221),
  K(9.948885490115626943170659161208956075366016401115989018212171074),
  K(0.0033749449751181671606590325602398460158469527192414811976620325),
  K(10.22829697925464456898110125803448917559061181938575400736363741),
  K(0.0057290898504826830167311931348447091484463863973009267657995588),
  K(10.34217443244273435465578957071404550407251612565857250331420119),
  K(0.0070322852668790789277749431053417481332667868252796806234703067),
  K(10.65060768936664532506002796784611891737776833469268268994629423),
  K(0.011882020718718477761700937701191380173113757253834448925151308),
  K(10.70040028988623707938366657587129192810479697740228798367139274),
  K(0.012878526652930086296944656216734557462513244824912054807575616),
  K(10.84142507904803512018676938796935871600407550162624393393314697),
  K(0.016078482060483615152751991950209242115468967057614125154781517),
  K(10.90980753920873021135225944659249440773199755849214446824185856),
  K(0.01784680057155851869446051052558187510920412965213801790601362),
  K(11.0594449437685955803093507076702961589841982419187644960982929),
  K(0.02225948209916355320880742938228709480576986496676355384153938),
  K(11.12739923287138522357874948311858093601190393424087124679528703),
  K(0.024527100867267281357593561214756089909892313840722957096015427),
  K(11.17317421868043977989649497127376293100112791304576031859691653),
  K(0.02615294429119215406054830573489864683757678313265422176773517),
  K(11.19103583177773881227590788561218787951029848545598196021794481),
  K(0.026809404013574226023970573250569900501072928349051859726309295),
  K(11.22172457187572472885657444536931180784442868259407894853156921),
  K(0.027966719446535591278153380802030326711316174884326402998278273),
  K(11.37988809249603126048762586806212198253864923259098578464857656),
  K(0.034542907252653661233063342904515073228248484337362963493256712),
  K(11.46021350637512235024015996951026541104483259180333898351308614),
  K(0.038291535216129920866485139509222513015843463899321663623295786),
  K(11.60907299193116950639665213558788325431272078026520396461715836),
  K(0.046001895174037409101080094364708823638833269069802055244979679),
  K(11.71484737074811920101143420837309467408147722842184297405363215),
  K(0.05210031129065271707628257994047283720011639070750783419540331),
  K(11.89978267013363284212118226957417220158175538013113044848256281),
  K(0.064020183777222042761557968792540437519628302742617752902161146),
  K(11.93687011863742159867791678577858128050759097211213450007128289),
  K(0.06660263397035756043349573820505283274653115572029500687224749),
  K(12.02398552280029779521671267256813306696755356229014749951802483),
  K(0.072916631255593191335709132389598061269708924022063317239855685),
  K(12.39449415800510369216510650162337569010134768104829941164886847),
  K(0.10338621021119927234693747362533711272518805910207931305715165),
  K(12.5766350484861927299330458577052922311812583611381948874089185),
  K(0.12016744425748201971007297542994969596091395160080851940150515),
  K(12.86811858625103544456501829608899115091391781915938469304129075),
  K(0.14852697367870520246912873760952605773688370918688933235309476),
  K(12.91994939687992009730716371119247158142996684607509666895919187),
  K(0.15366063451181068156713995263085710274021054800877786142542499),
  K(13.06093892435105843941229967260263313150154220775310561729377514),
  K(0.16759608454500329139362259027943757898740175844344758075488746),
  K(13.0793799722644774183173356332278401073293849884063042278716405),
  K(0.1694070732946275635137415021967266437855850337400852560272109),
  K(13.71259006438299284450981118589429970234689036634672171388457354),
  K(0.2251289395957687776144920632070510696511068511810110692388519),
  K(14.0460895347242055786449858281402883992191336253738644013054049),
  K(0.2448533668807013693971339781220916066532184855622736760695771),
  K(14.27571774395293139790494525506514511383160001491233551028296232),
  K(0.25270648707379947106205944848880215079057773111643723216936165),
  K(14.28227006006514277406289984874344725585459516188963916023369173),
  K(0.2528548624313559111185162522534630710772336491687814083231871),
  K(14.30329062318580677298062486976380834979665718761431155242887092),
  K(0.25330169196800849362481174954057509002386207754355961667117064),
};
static const R b29[] =
{
  K(0.03775998304299144469484236386806100599212493732694665014735571645),
  K(6.1289080676768494338299932544757944901070020627513194759359579e-73),
  K(0.1015511572801342861577960252214150571640673622256197277288417249),
  K(1.76735019791104447760018716349556594416606564443327683254380193e-60),
  K(0.2593277648393924408839551353438185259997733188197595884425524031),
  K(1.13522688685455094058106638706519972209428243502752933513559248e-48),
  K(0.3182750981701491280766746230844842480721256644602722037957355682),
  K(4.3125916937341556025084921759170267033681539335124357313147595e-46),
  K(0.3872052050071549457756063938971066843919395401445330028178580908),
  K(1.26985926957636866921688039842201295555689677149184739771064303e-43),
  K(0.3950947147110780888889597164700126678461269374808525806640230597),
  K(2.27927412931828718274382162782452474347591101561612881229492491e-43),
  K(0.5363161417406287274106050011582636510134112869531411387515390795),
  K(1.60940875972719324974667216364034634697540739173806593035182037e-39),
  K(0.6488714533741344761275375058457121500635896071635254424172631388),
  K(4.0370353751003754043297813187037238691426183934986973737167745e-37),
  K(1.498225089138058060559820632739913706751561741430301407364433734),
  K(1.39699894413362238745433882791061664344470711527214553829157972e-26),
  K(1.577859058887629980228861049517424768238557417521627622264862868),
  K(6.272478758124321443854724302250708867350241311249791177473806e-26),
  K(1.66480416088126310969916515522520141370629342245128652999566788),
  K(2.97161544210268569157900529677729619683774548098537972003531673e-25),
  K(1.87723437950624345620087653814563873472130418137997621520421005),
  K(9.671585032215698846430397539193158717606378491829792484379654e-24),
  K(1.946915533531168694918871480655387051096679794075168949013339327),
  K(2.78309072328386551842850345019908800586074375250925729714180965e-23),
  K(2.069662038824899775603346345866771659740519017137272321024449225),
  K(1.63887074651982914158815845079185195737810809809777401933313142e-22),
  K(2.090725536785564487470939121114124025134681674765079727936950527),
  K(2.19823839555623304794781001878151385277184339687167801778128034e-22),
  K(2.161832467215956839788530439452273253831304029201543589869111357),
  K(5.7982908526932166851574490276295182365087384826774217094102716e-22),
  K(2.506731526382276182386578667383479909870579522808022698180440473),
  K(4.2421204143908084877972185799038656030357016271258333135824811e-20),
  K(2.700278850109228057785826250698136325268918631131250737960070511),
  K(3.6668365323474321031759066093913740636492859095665063754667718e-19),
  K(2.741702223040676353547767917995279854262672718875016349986560325),
  K(5.7019613486380015976476852645254978668490700558529169366932229e-19),
  K(2.809361479619557472682194090127564919199835707501341333370802097),
  K(1.15623150482332621524892355735304961403192812541122560928099279e-18),
  K(2.821085414551172770020459432880955091494829721634984112184880003),
  K(1.30464386675041660225848835048192983722783098893865732438506243e-18),
  K(2.948045262349508411997681972935143649607299374132833432243771106),
  K(4.6759794235686956361184767886844615788046428045690358462922926e-18),
  K(3.016802160479909277570670911177550850702834269039181108335761791),
  K(9.1244935386552013487567407757057076191307963384583955858912957e-18),
  K(3.07323989678427818994617301088221091077608852705714913615520564),
  K(1.56176208092509619121950499889020688395333768583048659104648751e-17),
  K(3.119073816107549756553192377673807922640156515302491518516088332),
  K(2.3989915547198370109631394937263764876449161854189298411581131e-17),
  K(3.125559852821611137958046442373646730430695053169764143076647523),
  K(2.5479240610688970013769515004403568146834700352415295576081125e-17),
  K(3.256936584002261806728230941335874402400521269593863100525743844),
  K(8.4065514045505662866625795680416879046885859012177123651356825e-17),
  K(3.347324455625350911376389210706958619553318923656591488042196531),
  K(1.85889814812623563011989149834411500654465292262803164717264419e-16),
  K(3.457026389234672932485887127821539769425917450849505821118772863),
  K(4.7335458964936961954661929080938126499487734981580822875721288e-16),
  K(3.672567623500755451401012882941378887175271537386557550043841411),
  K(2.7308017170817223710240855606719123013582016790669742098841766e-15),
  K(3.788132609246460383022165957421130669060730622767414753720721737),
  K(6.6986929442073158761092801443286605009694355519556247837030183e-15),
  K(3.883977358093260363048973562716371025479190300349539065099637014),
  K(1.38088737497351759441484073726098991499669421242390591027325439e-14),
  K(3.920887522587959309380994305494137848177426136242795284993692731),
  K(1.81572519180217689538315187760057173799210266706062361196651977e-14),
  K(3.957935482621607048725481402756182702631445995205459434028545434),
  K(2.3836698494134843591620216985583417877268953137905040090612708e-14),
  K(4.012630010829107645839861470728686473827682392047866367489575573),
  K(3.5456514989782009791484986139838188952287133386464995730347134e-14),
  K(4.359894261281177523749673648599586811633980377145743422484110934),
  K(3.9029876900529433395140888353929914714979458380544520737511732e-13),
  K(4.658620065378444852192949383225356495169868778810834098314277025),
  K(2.636226565487254098628100146958981314800418824275100843877678e-12),
  K(5.158652990175937216586293482700363829263780046087722841956491484),
  K(4.9114821479259740642687090454526082675377908206778074983246304e-11),
  K(5.601299015203258018402380478198072811016947775422915034597208915),
  K(5.1123406470147202252574383349155846850402657822230206089709984e-10),
  K(5.667386398780461324548728391713348712842629817547816018904745669),
  K(7.1248859233700458647930971405709449464036230856622833157804172e-10),
  K(5.779937885767770249641522565352830930902990754322809465208607499),
  K(1.24146226191705804824013057726422184938379130405550453637204977e-9),
  K(6.173353721448590724635745262175037386302327040127966990929715335),
  K(7.8688622049758953497130655010413021693212645425816495665533288e-9),
  K(6.440525896996119550100693901783967136359844583550618909730218423),
  K(2.5499754259500937411201628204605122690608838961215279821048715e-8),
  K(6.454569713488818782954266199868778533415679138192865331880695887),
  K(2.7080490649247314735585273465625989428957071077684130255817471e-8),
  K(6.476933249046285767952535367613422652442802444854958807114863331),
  K(2.9792443971928968686223004740402761819631391209967502201451896e-8),
  K(6.613364949888335712028909899322131905101451260703194235748395773),
  K(5.2864623264949879831551696339531850488623679275809850931157194e-8),
  K(6.822051226074663320912666507400880873654388733023991530280322447),
  K(1.23536510012840714370388973393406730433763824468817630457671595e-7),
  K(6.870864611207687309560604680313558296431508507128004010633711754),
  K(1.49943703011139299594836673068905450209159365041476827130076212e-7),
  K(7.109644595293488148472970723842666214552869107854222394121189151),
  K(3.7707455262720772921729815725422765828943962074416584089623189e-7),
  K(7.29439332702088956106920302802365870379883039196196288849325638),
  K(7.4832044424501906093144106073988799600176944544486645971984848e-7),
  K(7.434221475611506138115223938789483075622049410767740447554986467),
  K(1.23747204500222593018600141673618828512386645654250693406013165e-6),
  K(7.572517094564079964187502043928464279828478148299309452354922973),
  K(2.0088714243022317100753432842445523875181027990037786300110295e-6),
  K(7.603262068248110153286075715742406478874633109449278203114499336),
  K(2.2334822462307428947870263278016411435296165520056580057109096e-6),
  K(7.690903583758021733086299311319557188882293006845731102666184626),
  K(3.0110954378991797165044135612143236224409219327851049104289977e-6),
  K(7.834415965937398105276548730568591801274239304991212568028093023),
  K(4.8588919441921060911851075325645600201954563280287813018536232e-6),
  K(7.932041465699773106999937021875284771164975024714912419811461549),
  K(6.6783537169458487296511912180162840124390437114437107493052258e-6),
  K(8.05782103991356208473885868273674049604517338112274749971482166),
  K(9.9735642327373798216884555101054121005530773614309432141167572e-6),
  K(8.10431962511796392820851107021525494600562005382245083964672029),
  K(0.0000115392437999359732972390118642134492738718451637123079875429169),
  K(8.414135816374521132200762878527920981663871750291466450600425128),
  K(0.000029497775090537300035509369548667014885445902329824140546170557),
  K(8.480452112929628549921439384402099853150249050285285338125672178),
  K(0.000035798527886933042513471094840391579210353354001583430511695617),
  K(8.515524281239079685554847740343339163788511557308649050340167358),
  K(0.000039617388105725316244978189179870268871806686699116641362708697),
  K(8.701977608244809593428208651052359455665755827189167031504421163),
  K(0.000067115291122034474980407219333920123251945710203972228478925783),
  K(8.775616075604415979411077186012610526689533727827064712169933546),
  K(0.000082206796537096498640826668523072476110724993093966859589137765),
  K(8.80130008479412988623094437303866341322659164872116420223570908),
  K(0.000088170700360622841642917866493485991025760719634101553897102251),
  K(9.093256222003289316426812492823022495957668416200844930563038931),
  K(0.0001905932659479307433238006318391857197753528434562506939605384),
  K(9.614668365468098811223330188883975109488256531818313015406718692),
  K(0.00067521815245109871333835412461682453557221692408531041119780706),
  K(9.748973779779403597932756889104369028501093603188515154071450395),
  K(0.00091453795341365518241221503627887821823648484780275665164586499),
  K(9.8106021010013053805314399356245279714552461815147893730745183),
  K(0.00104799180712465998101087267883556786413596339638125895056241005),
  K(9.920687362982892944831852393604741371922565630768020543202198067),
  K(0.0013304770071677755879626648708413540252100430544213720360641378),
  K(10.33351586178221902689637885095593873155219893344652340004018434),
  K(0.0030906271557716308143411195159875601090934551110982829718772603),
  K(10.45263669885243368564689528188131742194132451144271466596355378),
  K(0.0038827658208611422909685612513986333330287307227419101556402281),
  K(10.64318701701148780604797585610669344605587465290087044597011623),
  K(0.0055169794398831590464879636603403530031146864304352864590833646),
  K(10.98247547110718383435538347267163961547192712561858158164875401),
  K(0.0098970012139687546693635800156444849829212449627085727087154431),
  K(11.18285443028747183407365045976298512420277992484943794545478927),
  K(0.01364116881401731503715244854495600637502725325257672681013092),
  K(11.19238099686747376620668391828363428098949726191393641794975676),
  K(0.013844715591846575329828306927916880603535079588911504362477672),
  K(11.29064536980281378023315270013943980598141668721626374879737088),
  K(0.016092384545404490538376320883174483187911710901728733363489531),
  K(11.36418113514132467221037423840889924020146461866801800737502857),
  K(0.017960196104770552210893506349948414650718710246311871595030036),
  K(11.5164141167128693960631931749041620571059873483396447128675176),
  K(0.022376255150908769952491077904752417598603234107803937814857195),
  K(11.66087637789067255076613397317091524311857718443759840108037491),
  K(0.027312655264573170590805894208704205453226033571540076643937136),
  K(11.84388562392006742001647136917033854151284061754524123775132381),
  K(0.034710684367321907267575668551749177940135459120139029147664348),
  K(11.96103859011078923027702116675424196781166578297923812754866087),
  K(0.040165666643407108703228328984254930746034928473992347510909121),
  K(12.02989996407172971873708482572363762935277533148322494565020215),
  K(0.043645631594714261960272568438614768703938264404357643074488125),
  K(12.25343965192999769639025567064589426594139384100425386382770316),
  K(0.056380151342589387328256982618013343553096739604350327314462394),
  K(12.34521104590164333343699689391814272947139941952768980425358639),
  K(0.062251591521775250845419425797351272266771366988299515672136145),
  K(12.34880072661571348266605954362958288707658591414809857951620877),
  K(0.062488846345538475837886995690508845858561390516619671937609028),
  K(12.36382129463453895656385704270313877853577371365865381136709155),
  K(0.063487778320227951953779835994427447598248501790816352077923844),
  K(12.42240576119794147543459349299484398936704998098127713739941203),
  K(0.067478599421926139381099550801161077133211574688184778668316231),
  K(12.48961816335741146302260334288056418883582264846129854704643767),
  K(0.072240776187562887323941367054623843862849708694673335815238083),
  K(12.63541404180032541739684068799817271814407369218610947747551142),
  K(0.083224055867166718868655161109051726308499810415569685643449648),
  K(12.76905610054923887769386459684424726072666677086364638577548504),
  K(0.094030209113861041397520119419772181560708074820638509456621706),
  K(12.96019823177930598664700031767541039336965886450546547358338351),
  K(0.11056140583626998681016000252084865320252135554329009443330361),
  K(12.98579109495053801283472088937231387421540699019631171339827038),
  K(0.11285798188276930305982387742126753051331657564115170373729495),
  K(13.08079804252441297688551868434741062444789171673062027772292704),
  K(0.12152663236843447739812054107853925634768837329468275180718154),
  K(13.80511924935555887259893401158848861154254719073042643791803361),
  K(0.18966398705143978276275369400231926435263040155217093406315102),
  K(13.85062848045299157585991018417089185943470101418763703200246745),
  K(0.1936867105705341051798246807010932420560663342677518524409449),
  K(13.9793653286889744561365513241728097062482987498674034247291982),
  K(0.2046235733838439536637247369445690082810766006482626681648351),
  K(14.15995892080041915567230866040255402364426067068467955303613866),
  K(0.2185885653464975091363234134539889036700274481586135946383175),
  K(14.45575795111474872474909823812313648498267705156900588324601358),
  K(0.23688190843022201909196817775725537695425293785864791925763857),
  K(14.87652410100398528916115320208946456414637966402362828445778478),
  K(0.2502993277424188205112945367045750646971645996913754672427736),
  K(14.92664741378414156099749980886870522712206733295427894041083629),
  K(0.25078386548394807293491625982208509187281570046302874134368113),
};
static const R b30[] =
{
  K(0.04863444069345366670739960223702094085942163887595673806645189288),
  K(1.52988116497881427727402876307113358241091924030981833854671824e-72),
  K(0.3625909573443363622158332600856230059060557569326308174843506293),
  K(2.28480423885331475181855898355482242559914883947586745705024512e-46),
  K(0.4585070473824530446178885278467011061804908647423413550054210485),
  K(2.61048008057685879072498453621838191992195318559493492572072799e-43),
  K(0.5943404915553289821918158671478817556052010730437077494754512429),
  K(6.2719053919521175479535011637420024895549623612455288698746008e-40),
  K(0.598966163212995611760343623370206504668010454807949959652607312),
  K(7.9142286412269362711402232693918734218008593102814043183320345e-40),
  K(0.6773380892144162089671939643277751339853859405972039356533257008),
  K(3.16595598824654734560047035692860826667386051433353130378764037e-38),
  K(0.6954721285651956872209255940414092743198551113473782000354262208),
  K(6.9940998403596928909002101154151941378072507724632904027035363e-38),
  K(0.8258305112506100794271127097497832203103488003434373412307602326),
  K(1.21078673769708158388158496587031713687333989937449073283284152e-35),
  K(0.8751924110978951592897087196280064085178981159209303635833329169),
  K(6.9094936271563667512785664582012246675296021815673266860391992e-35),
  K(0.9680330508743083302687795827135943837542431669881047824327988735),
  K(1.42247776402049267907078402120534905684279038589459369265061693e-33),
  K(1.132808417737367585527063841291519880724661619482284124961008412),
  K(1.58867093897011684903983088237851733967271207766421408347503187e-31),
  K(1.181215411871876894525241342046428549765870247095284690687296634),
  K(5.5745917571512272590991382111361996489245520306287115521308949e-31),
  K(1.264525975642090637165463025581242497909056055281024405446961585),
  K(4.3069772123362772143160890110096797927845804492353739699019518e-30),
  K(1.45435957229714313435914622786707109831897544048823797969361773),
  K(2.86084109822270100010848981177716962763794953799820195889771665e-28),
  K(1.584417325520729055645055658334799140035670016831195890031261537),
  K(3.7361766976831642076203292713871031569930460248310367019542439e-27),
  K(2.399926083745360219199162862590332147381542532537319445804232975),
  K(9.6000749781969695729015970200924971161908656811643711508191821e-22),
  K(2.451508482427656798208409343007732055048822109925345650858195159),
  K(1.81693727573342619956355075510673982656128916607736282560996279e-21),
  K(2.492950859854383585035301281919941927159693142014368094275950572),
  K(3.0043370283949224302245279499795984443097669770985139908553612e-21),
  K(2.916484385316361310952150554858262904302372261058393184634294766),
  K(3.3272393028473616863669177687864560940784037098249806833855019e-19),
  K(2.938634361602823693452752363186141596479979056795925466537065211),
  K(4.1749881965186496310292607102144767349223260678357338106104122e-19),
  K(2.997881534825712878250887160606845192701023817110341529387243951),
  K(7.5980905109794319356676403023797307241555928224635721693497667e-19),
  K(3.037151992348938796276666163460697131068493734396165902926569516),
  K(1.12266815938785430794255264605448445529147871675198016037440234e-18),
  K(3.063531459624309096514200157277142384250246398298474687533702443),
  K(1.45517281261078038447900866715304920614470137341437145412455212e-18),
  K(3.093574373784798147240885615064064568723638144130163039010395965),
  K(1.95005386415673812556768156639895404261940147184820676394293333e-18),
  K(3.248390296127582446009085348710615502638362257415372327357726336),
  K(8.4366417558732645700789865627762705396680441216915659570956727e-18),
  K(3.253535185409385302015016761969674763649491375054247127409245771),
  K(8.8467568851819636595431868068394575409018972964567560289408911e-18),
  K(3.365822210925306195967627573277643834980950446768008359949836596),
  K(2.4475495404282517093947815432234069560125468865953579822669072e-17),
  K(3.627048733411073244079691753185448769424934599682910436758838376),
  K(2.30195250061158368895560756853596106248203651477647834457725944e-16),
  K(3.683044934943782713134078734347926056927943846150754037311817391),
  K(3.6437217679121069450684663889333883283719178651838824494021446e-16),
  K(3.724789617208458313555073713743213279412269587280102636488037794),
  K(5.1080253964680279429363602280136740051816075746114650037754583e-16),
  K(4.058533323434710433149399279383868181913266012903605940344492842),
  K(6.6777241152451080358303007968753982526345150161658525451910892e-15),
  K(4.81075769601353857738714777661093195373063379205616072770540741),
  K(1.07199968002557711814108209873387642018089959941043896019349264e-12),
  K(4.867095452251034700970125960721057548443556553784704884369934527),
  K(1.51591661799417173660711560302134214975304638673749620470836163e-12),
  K(5.082777927158479361621712573816007497860703747689280531354911277),
  K(5.4978268925128930803955035694546338595078140132512678284955143e-12),
  K(5.106321321793997106376925324759281371243643099040768532080236325),
  K(6.3056382210661200274710658566078090764642675229845983160391389e-12),
  K(5.108951035946263235930333197702300776259567152594198157167458496),
  K(6.4026677100542680302807328710270079366584089187730933790424363e-12),
  K(5.137872158190385723943867844330923359728716801267168785785166592),
  K(7.5693193425287785338154789296817961189040968155526358275520621e-12),
  K(5.344042260542788033502555521425132279652075172249371242496453867),
  K(2.4256452541360361178113326770967386184641413214198152340307015e-11),
  K(5.543208664107554352001451722118332480412879259243038146570927536),
  K(7.1384999766662492298202565426366666471617757156153189855054677e-11),
  K(5.919110503910169156356294909732026869731568810818938208067799547),
  K(4.8903519596330426245422578340841372300695715881150539390395099e-10),
  K(6.839933838952560468346180095262468777166721144910762592457093649),
  K(3.1581356197256590746297818896493376311890456320862021596176111e-8),
  K(6.867636696901592375135833293108350049215847977837474081674712565),
  K(3.5416435212720840615273780251646550485821828632818480477284037e-8),
  K(7.003603884526196499751070719309224739228517533969534181416009526),
  K(6.1637116683404365036363163201552486515337911207141749644097387e-8),
  K(7.038050638049835956633194125353745385132824050066702076125467281),
  K(7.0770999658411170970205382061828869070409751674113370284051303e-8),
  K(7.277181546633139795829787977633483330771648080795875833372406),
  K(1.8036339549647683639509635218036125235178663328494902504854783e-7),
  K(7.329767643124433155948507768384300549462099671928444841749959828),
  K(2.2035599332216578305835896555166032210102487283542179228373168e-7),
  K(7.503109302469727803028231827546930801193021185397306756374172681),
  K(4.2068173788494407516383200573162927050444541394555196170115159e-7),
  K(7.576691474490803332400877311478036675728796572781459689102532893),
  K(5.5015679751946144271710796876515966908505411385382753563854058e-7),
  K(7.653731900156144681856834361266861466765442859941490002902109371),
  K(7.2580356002898018571366462524415924964493553910574674293155032e-7),
  K(7.680791134078970882786329790240366875513499415249894276409309727),
  K(7.9924712496750401967992522660330598135730936750026731992783906e-7),
  K(7.707512911185169823862675713524448643038010674475894506644558354),
  K(8.7865212730458321887408277550237939856234093389267030756297874e-7),
  K(7.775792086317270189407329309523228108269858373402975615171619528),
  K(1.11689473273224961001616635870764406402979301723296587380309343e-6),
  K(7.795949992093029453206710012586240448901380473901041211867061201),
  K(1.1981848369205437476186375921271491908533441118956066787712364e-6),
  K(7.847884764331556533729819121998266384068690508060016477820797861),
  K(1.43421172379142595582248466447607570005946727336664229855462254e-6),
  K(8.327310339157066301112964490178923521165379607827614138523700265),
  K(6.9676626456264066994868568389891786393038959440882760972969014e-6),
  K(8.569111182731737097726914694287744001240191634576450491699122293),
  K(0.000014678262796916303409337392666611369153173108897435521275680847),
  K(8.951304364976505137734273605763629836190701712285834627544469187),
  K(0.000044541178412239953501012887598883241662892664085939971504977764),
  K(9.037631695667362727047248798975615475164670717302377730476599245),
  K(0.000056600953023458837404374740571712569981251312499262061143629759),
  K(9.471237899624761386475885682515013955302760009531540487637183045),
  K(0.00017765327701449233608794899434257550859012764553994613766601925),
  K(9.561328003327206921860051815882553978792028079453724054001576763),
  K(0.00022257775300868013091344333869051498749282654679792290072990859),
  K(9.61510803146121550898655040128605895467354773082505009689577184),
  K(0.00025414306382959461494443259828541590948732161470095497166479636),
  K(9.745303914401534429045156270557193262144963919904714130140426272),
  K(0.00034826122918627144847695730039075822820855784059615731313208797),
  K(10.17229451707635202134690906809470370937006973810983236583111517),
  K(0.00092313943246795472301085281782007216523403383138714478946282457),
  K(10.5149331170130411213970504469436077228500483501105700482693984),
  K(0.0018952533188307718411071188972355377119016296416031516849205117),
  K(10.60561882649686687412707768204435848639302115576970877681361333),
  K(0.002271862360587999834283615636619491694924105118472351559358952),
  K(10.78118825264234898022008999629517535023060719220605833790806609),
  K(0.0031925355526717678269888155352724160286112300916610691667522076),
  K(10.78617814816121791984559189191457452578241304509956663388676909),
  K(0.0032228961496338996383380273515234679735100064674600312917229928),
  K(10.8096673979816390787186459848154261172621337218404650274504757),
  K(0.0033692303079733421244839137211751316090116100456431620876568708),
  K(10.87486318615447014313179826207000017908771356560536357199942464),
  K(0.0038061896203947124389418912389735367256311145583042890309422775),
  K(10.98170867565177164629017051828951562160106944386744614489589956),
  K(0.0046290830395556903637010575206412799709878206746116165070934718),
  K(11.24088140606170986667257382353597362367595071452997585750864885),
  K(0.0072871850169947716156154385028288783184627665563924336620795303),
  K(11.82812311152688838126778231516538262785214049321761797118146451),
  K(0.01829298487137343503594930224532142602409118611127498463610001),
  K(11.85760159726611454538420142759544467592930479822238015473434816),
  K(0.019084056217436655038046652735600444508300329757283248564796737),
  K(12.06020678490528370421374447630576575120408872131450122368724358),
  K(0.025279287338726008805515318074709881270005462771265029168518767),
  K(12.36110936767852598583227309999275993831018618248525679820039799),
  K(0.037192757708899673163301704411323916475358110053071674213411199),
  K(12.42696264974084804094002460885785967247691705012310790689939337),
  K(0.040272255512227265024216255069391662581107408555896977765348053),
  K(12.50048993130091550639884459771966265383029711359512242731795256),
  K(0.043921035906371332800645621217060473721646157252686971824279704),
  K(12.76785338659063480337864446741569079768342258673844988046667998),
  K(0.059104822788457618219679617433860516271582705536350429827148078),
  K(12.78224770036495545378991678515257296968574962067166162090721712),
  K(0.06000819406754068090280369550296204785629763709867072533491248),
  K(12.83896153196517490410990068602368149880084838326625774958575983),
  K(0.063652410347441647242255858281508748175742812395738410508137458),
  K(12.95996350632159583693464738359288731001952235368644844923236516),
  K(0.071874637874226656442835628148219972362877531257223631263859277),
  K(13.19484997545570161788623678146981620653487314346760977047774375),
  K(0.089489802117758201526126809874463688180098332459227459465801975),
  K(13.85184864255674249868559706560228752402650510251971011998411398),
  K(0.14723915792516092034091581121037634976415335115681949136879101),
  K(14.02668385422158990643403416549099229903110274232231129651470496),
  K(0.16341217288900145231637291079313428026813340696933952989251944),
  K(14.02771339126193334997730039964659946789233747759310633676308322),
  K(0.16350677157284519374395039785357919985927928703971263156157893),
  K(14.1648384514967696343039559713768476015373828227451180751259897),
  K(0.17596506664932476817739459873536929376424322176530785803429087),
  K(14.16542670069152426591765629028324747759215974132306111526738805),
  K(0.17601776120103504198145141924318471478998378370297819676749559),
  K(14.38603529771007628451526880793922460897772326247174998084002688),
  K(0.19509788575393317830989104525974502286523399407243483659409339),
  K(14.41734093723551659089835003614701269994267695884872283317346405),
  K(0.19766892084896759298771445010526993119361038751333112601227889),
  K(14.4514175694780156188289627566734759298596529034243245210868481),
  K(0.20042054430970276047930172865295896388112624535199855143085229),
  K(14.57733406397546435801804748077471448128118101920965181674097288),
  K(0.21011330438582511721177327421235709661657334372205630750405979),
  K(14.69179499512638317680816104901350396317750590196293863077566809),
  K(0.21818064807188167088117905356260851709728241833911872426393943),
  K(14.71985119176432698413364946100402823592695041881810902103644983),
  K(0.22003696632978313800818059548056788054787816374196649730868422),
  K(14.85360819914592592187710888567316221464135719039680744109786518),
  K(0.22816320128876067720806260009666608763032575628786512716547537),
  K(14.96442151928193479149641632250822185813308142673420928656148499),
  K(0.23391207125767642386584572438688975518528224084727000823610053),
  K(15.09198805599875400518643565726688476470367019728800472825838386),
  K(0.23932132342609152786262701422200965407928935108398228689423077),
  K(15.16917405251099092176676667071808641853587958116779639833339883),
  K(0.24192699203746064453916872974085076964366007483611183834935937),
  K(15.22189598318078945679052280117796763696914221630837307362345766),
  K(0.24340615698602401858985265552378964143504360111849992441699181),
  K(15.38267497789712439192725521738075552267986404685942850480190865),
  K(0.24636179792154708599756969484986104605022723440964665902382041),
  K(15.44071413336911022494417191952253082031513933837340567448079451),
  K(0.24684163539601499376496292031270154746415289827073608174217318),
};

#define ERR(x,y) IF(ABS(y) == K(0.0), ABS(x - y), ABS(x - y) / ABS(y))

#if defined(NFFT_LDOUBLE)
static const R bound_multiplier = K(17.0);
#elif defined(NFFT_SINGLE)
static const R bound_multiplier = K(20.0);
#else
static const R bound_multiplier = K(16.0);
#endif

static int check_bspline(const unsigned n, const unsigned int m, const R *r)
{
  unsigned int j;
  R bound = bound_multiplier * Y(float_property)(NFFT_EPSILON);
  R err = K(0.0);
  int ok;

  for (j = 0; j < m; j++)
  {
    const R x = r[2*j], yr = r[2*j+1];
    R y = X(bsplines)((INT)(n + 1), x);
    /*printf("x = " __FE__ ", err = " __FE__ "\n", x, ERR(y,yr));*/
    err = FMAX(err, ERR(y, yr));
  }
  ok = IF(err < bound, 1, 0);
  fprintf(stderr, "b%02d: err_rel = " __FE__ " %-2s " __FE__ " -> %-4s\n", n, err, IF(ok == 0, ">=", "<"), bound , IF(ok == 0, "FAIL", "OK"));
  return ok;
}

void X(check_bspline)(void)
{
  const R *b[] = {
    b0, b1, b2, b3, b4, b5, b6, b7, b8, b9,
    b10, b11, b12, b13, b14, b15, b16, b17, b18, b19,
    b20, b21, b22, b23, b24, b25, b26, b27, b28, b29,
    b30,
  };
  unsigned int j;
  int ok = 1;
  printf("B-SPLINE\n--------\n");
  for (j = 0; j < sizeof(b)/sizeof(b[0]); j++)
  {
    ok = MIN(ok, check_bspline(j, 100, b[j]));
  }
  CU_ASSERT(ok == 1);
}
