// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by aliasgen. DO NOT EDIT.

// Package datastore aliases all exported identifiers in package
// "cloud.google.com/go/datastore/apiv1/datastorepb".
//
// Deprecated: Please use types in: cloud.google.com/go/datastore/apiv1/datastorepb.
// Please read https://github.com/googleapis/google-cloud-go/blob/main/migration.md
// for more details.
package datastore

import (
	src "cloud.google.com/go/datastore/apiv1/datastorepb"
	grpc "google.golang.org/grpc"
)

// Deprecated: Please use consts in: cloud.google.com/go/datastore/apiv1/datastorepb
const (
	CommitRequest_MODE_UNSPECIFIED                 = src.CommitRequest_MODE_UNSPECIFIED
	CommitRequest_NON_TRANSACTIONAL                = src.CommitRequest_NON_TRANSACTIONAL
	CommitRequest_TRANSACTIONAL                    = src.CommitRequest_TRANSACTIONAL
	CompositeFilter_AND                            = src.CompositeFilter_AND
	CompositeFilter_OPERATOR_UNSPECIFIED           = src.CompositeFilter_OPERATOR_UNSPECIFIED
	CompositeFilter_OR                             = src.CompositeFilter_OR
	EntityResult_FULL                              = src.EntityResult_FULL
	EntityResult_KEY_ONLY                          = src.EntityResult_KEY_ONLY
	EntityResult_PROJECTION                        = src.EntityResult_PROJECTION
	EntityResult_RESULT_TYPE_UNSPECIFIED           = src.EntityResult_RESULT_TYPE_UNSPECIFIED
	PropertyFilter_EQUAL                           = src.PropertyFilter_EQUAL
	PropertyFilter_GREATER_THAN                    = src.PropertyFilter_GREATER_THAN
	PropertyFilter_GREATER_THAN_OR_EQUAL           = src.PropertyFilter_GREATER_THAN_OR_EQUAL
	PropertyFilter_HAS_ANCESTOR                    = src.PropertyFilter_HAS_ANCESTOR
	PropertyFilter_IN                              = src.PropertyFilter_IN
	PropertyFilter_LESS_THAN                       = src.PropertyFilter_LESS_THAN
	PropertyFilter_LESS_THAN_OR_EQUAL              = src.PropertyFilter_LESS_THAN_OR_EQUAL
	PropertyFilter_NOT_EQUAL                       = src.PropertyFilter_NOT_EQUAL
	PropertyFilter_NOT_IN                          = src.PropertyFilter_NOT_IN
	PropertyFilter_OPERATOR_UNSPECIFIED            = src.PropertyFilter_OPERATOR_UNSPECIFIED
	PropertyOrder_ASCENDING                        = src.PropertyOrder_ASCENDING
	PropertyOrder_DESCENDING                       = src.PropertyOrder_DESCENDING
	PropertyOrder_DIRECTION_UNSPECIFIED            = src.PropertyOrder_DIRECTION_UNSPECIFIED
	QueryResultBatch_MORE_RESULTS_AFTER_CURSOR     = src.QueryResultBatch_MORE_RESULTS_AFTER_CURSOR
	QueryResultBatch_MORE_RESULTS_AFTER_LIMIT      = src.QueryResultBatch_MORE_RESULTS_AFTER_LIMIT
	QueryResultBatch_MORE_RESULTS_TYPE_UNSPECIFIED = src.QueryResultBatch_MORE_RESULTS_TYPE_UNSPECIFIED
	QueryResultBatch_NOT_FINISHED                  = src.QueryResultBatch_NOT_FINISHED
	QueryResultBatch_NO_MORE_RESULTS               = src.QueryResultBatch_NO_MORE_RESULTS
	ReadOptions_EVENTUAL                           = src.ReadOptions_EVENTUAL
	ReadOptions_READ_CONSISTENCY_UNSPECIFIED       = src.ReadOptions_READ_CONSISTENCY_UNSPECIFIED
	ReadOptions_STRONG                             = src.ReadOptions_STRONG
)

// Deprecated: Please use vars in: cloud.google.com/go/datastore/apiv1/datastorepb
var (
	CommitRequest_Mode_name                           = src.CommitRequest_Mode_name
	CommitRequest_Mode_value                          = src.CommitRequest_Mode_value
	CompositeFilter_Operator_name                     = src.CompositeFilter_Operator_name
	CompositeFilter_Operator_value                    = src.CompositeFilter_Operator_value
	EntityResult_ResultType_name                      = src.EntityResult_ResultType_name
	EntityResult_ResultType_value                     = src.EntityResult_ResultType_value
	File_google_datastore_v1_aggregation_result_proto = src.File_google_datastore_v1_aggregation_result_proto
	File_google_datastore_v1_datastore_proto          = src.File_google_datastore_v1_datastore_proto
	File_google_datastore_v1_entity_proto             = src.File_google_datastore_v1_entity_proto
	File_google_datastore_v1_query_profile_proto      = src.File_google_datastore_v1_query_profile_proto
	File_google_datastore_v1_query_proto              = src.File_google_datastore_v1_query_proto
	PropertyFilter_Operator_name                      = src.PropertyFilter_Operator_name
	PropertyFilter_Operator_value                     = src.PropertyFilter_Operator_value
	PropertyOrder_Direction_name                      = src.PropertyOrder_Direction_name
	PropertyOrder_Direction_value                     = src.PropertyOrder_Direction_value
	QueryResultBatch_MoreResultsType_name             = src.QueryResultBatch_MoreResultsType_name
	QueryResultBatch_MoreResultsType_value            = src.QueryResultBatch_MoreResultsType_value
	ReadOptions_ReadConsistency_name                  = src.ReadOptions_ReadConsistency_name
	ReadOptions_ReadConsistency_value                 = src.ReadOptions_ReadConsistency_value
)

// Datastore query for running an aggregation over a
// [Query][google.datastore.v1.Query].
//
// Deprecated: Please use types in: cloud.google.com/go/datastore/apiv1/datastorepb
type AggregationQuery = src.AggregationQuery

// Defines an aggregation that produces a single result.
//
// Deprecated: Please use types in: cloud.google.com/go/datastore/apiv1/datastorepb
type AggregationQuery_Aggregation = src.AggregationQuery_Aggregation

// Average of the values of the requested property. * Only numeric values will
// be aggregated. All non-numeric values including `NULL` are skipped. * If the
// aggregated values contain `NaN`, returns `NaN`. Infinity math follows
// IEEE-754 standards. * If the aggregated value set is empty, returns `NULL`.
// * Always returns the result as a double.
//
// Deprecated: Please use types in: cloud.google.com/go/datastore/apiv1/datastorepb
type AggregationQuery_Aggregation_Avg = src.AggregationQuery_Aggregation_Avg
type AggregationQuery_Aggregation_Avg_ = src.AggregationQuery_Aggregation_Avg_

// Count of entities that match the query. The `COUNT(*)` aggregation function
// operates on the entire entity so it does not require a field reference.
//
// Deprecated: Please use types in: cloud.google.com/go/datastore/apiv1/datastorepb
type AggregationQuery_Aggregation_Count = src.AggregationQuery_Aggregation_Count
type AggregationQuery_Aggregation_Count_ = src.AggregationQuery_Aggregation_Count_

// Sum of the values of the requested property. * Only numeric values will be
// aggregated. All non-numeric values including `NULL` are skipped. * If the
// aggregated values contain `NaN`, returns `NaN`. Infinity math follows
// IEEE-754 standards. * If the aggregated value set is empty, returns 0. *
// Returns a 64-bit integer if all aggregated numbers are integers and the sum
// result does not overflow. Otherwise, the result is returned as a double.
// Note that even if all the aggregated values are integers, the result is
// returned as a double if it cannot fit within a 64-bit signed integer. When
// this occurs, the returned value will lose precision. * When underflow
// occurs, floating-point aggregation is non-deterministic. This means that
// running the same query repeatedly without any changes to the underlying
// values could produce slightly different results each time. In those cases,
// values should be stored as integers over floating-point numbers.
//
// Deprecated: Please use types in: cloud.google.com/go/datastore/apiv1/datastorepb
type AggregationQuery_Aggregation_Sum = src.AggregationQuery_Aggregation_Sum
type AggregationQuery_Aggregation_Sum_ = src.AggregationQuery_Aggregation_Sum_
type AggregationQuery_NestedQuery = src.AggregationQuery_NestedQuery

// The result of a single bucket from a Datastore aggregation query. The keys
// of `aggregate_properties` are the same for all results in an aggregation
// query, unlike entity queries which can have different fields present for
// each result.
//
// Deprecated: Please use types in: cloud.google.com/go/datastore/apiv1/datastorepb
type AggregationResult = src.AggregationResult

// A batch of aggregation results produced by an aggregation query.
//
// Deprecated: Please use types in: cloud.google.com/go/datastore/apiv1/datastorepb
type AggregationResultBatch = src.AggregationResultBatch

// The request for
// [Datastore.AllocateIds][google.datastore.v1.Datastore.AllocateIds].
//
// Deprecated: Please use types in: cloud.google.com/go/datastore/apiv1/datastorepb
type AllocateIdsRequest = src.AllocateIdsRequest

// The response for
// [Datastore.AllocateIds][google.datastore.v1.Datastore.AllocateIds].
//
// Deprecated: Please use types in: cloud.google.com/go/datastore/apiv1/datastorepb
type AllocateIdsResponse = src.AllocateIdsResponse

// An array value.
//
// Deprecated: Please use types in: cloud.google.com/go/datastore/apiv1/datastorepb
type ArrayValue = src.ArrayValue

// The request for
// [Datastore.BeginTransaction][google.datastore.v1.Datastore.BeginTransaction].
//
// Deprecated: Please use types in: cloud.google.com/go/datastore/apiv1/datastorepb
type BeginTransactionRequest = src.BeginTransactionRequest

// The response for
// [Datastore.BeginTransaction][google.datastore.v1.Datastore.BeginTransaction].
//
// Deprecated: Please use types in: cloud.google.com/go/datastore/apiv1/datastorepb
type BeginTransactionResponse = src.BeginTransactionResponse

// The request for [Datastore.Commit][google.datastore.v1.Datastore.Commit].
//
// Deprecated: Please use types in: cloud.google.com/go/datastore/apiv1/datastorepb
type CommitRequest = src.CommitRequest

// The modes available for commits.
//
// Deprecated: Please use types in: cloud.google.com/go/datastore/apiv1/datastorepb
type CommitRequest_Mode = src.CommitRequest_Mode
type CommitRequest_SingleUseTransaction = src.CommitRequest_SingleUseTransaction
type CommitRequest_Transaction = src.CommitRequest_Transaction

// The response for [Datastore.Commit][google.datastore.v1.Datastore.Commit].
//
// Deprecated: Please use types in: cloud.google.com/go/datastore/apiv1/datastorepb
type CommitResponse = src.CommitResponse

// A filter that merges multiple other filters using the given operator.
//
// Deprecated: Please use types in: cloud.google.com/go/datastore/apiv1/datastorepb
type CompositeFilter = src.CompositeFilter

// A composite filter operator.
//
// Deprecated: Please use types in: cloud.google.com/go/datastore/apiv1/datastorepb
type CompositeFilter_Operator = src.CompositeFilter_Operator

// DatastoreClient is the client API for Datastore service. For semantics
// around ctx use and closing/ending streaming RPCs, please refer to
// https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
//
// Deprecated: Please use types in: cloud.google.com/go/datastore/apiv1/datastorepb
type DatastoreClient = src.DatastoreClient

// DatastoreServer is the server API for Datastore service.
//
// Deprecated: Please use types in: cloud.google.com/go/datastore/apiv1/datastorepb
type DatastoreServer = src.DatastoreServer

// A Datastore data object. Must not exceed 1 MiB - 4 bytes.
//
// Deprecated: Please use types in: cloud.google.com/go/datastore/apiv1/datastorepb
type Entity = src.Entity

// The result of fetching an entity from Datastore.
//
// Deprecated: Please use types in: cloud.google.com/go/datastore/apiv1/datastorepb
type EntityResult = src.EntityResult

// Specifies what data the 'entity' field contains. A `ResultType` is either
// implied (for example, in `LookupResponse.missing` from `datastore.proto`, it
// is always `KEY_ONLY`) or specified by context (for example, in message
// `QueryResultBatch`, field `entity_result_type` specifies a `ResultType` for
// all the values in field `entity_results`).
//
// Deprecated: Please use types in: cloud.google.com/go/datastore/apiv1/datastorepb
type EntityResult_ResultType = src.EntityResult_ResultType

// Execution statistics for the query.
//
// Deprecated: Please use types in: cloud.google.com/go/datastore/apiv1/datastorepb
type ExecutionStats = src.ExecutionStats

// Explain metrics for the query.
//
// Deprecated: Please use types in: cloud.google.com/go/datastore/apiv1/datastorepb
type ExplainMetrics = src.ExplainMetrics

// Explain options for the query.
//
// Deprecated: Please use types in: cloud.google.com/go/datastore/apiv1/datastorepb
type ExplainOptions = src.ExplainOptions

// A holder for any type of filter.
//
// Deprecated: Please use types in: cloud.google.com/go/datastore/apiv1/datastorepb
type Filter = src.Filter
type Filter_CompositeFilter = src.Filter_CompositeFilter
type Filter_PropertyFilter = src.Filter_PropertyFilter

// A [GQL
// query](https://cloud.google.com/datastore/docs/apis/gql/gql_reference).
//
// Deprecated: Please use types in: cloud.google.com/go/datastore/apiv1/datastorepb
type GqlQuery = src.GqlQuery

// A binding parameter for a GQL query.
//
// Deprecated: Please use types in: cloud.google.com/go/datastore/apiv1/datastorepb
type GqlQueryParameter = src.GqlQueryParameter
type GqlQueryParameter_Cursor = src.GqlQueryParameter_Cursor
type GqlQueryParameter_Value = src.GqlQueryParameter_Value

// A unique identifier for an entity. If a key's partition ID or any of its
// path kinds or names are reserved/read-only, the key is reserved/read-only. A
// reserved/read-only key is forbidden in certain documented contexts.
//
// Deprecated: Please use types in: cloud.google.com/go/datastore/apiv1/datastorepb
type Key = src.Key

// A (kind, ID/name) pair used to construct a key path. If either name or ID
// is set, the element is complete. If neither is set, the element is
// incomplete.
//
// Deprecated: Please use types in: cloud.google.com/go/datastore/apiv1/datastorepb
type Key_PathElement = src.Key_PathElement
type Key_PathElement_Id = src.Key_PathElement_Id
type Key_PathElement_Name = src.Key_PathElement_Name

// A representation of a kind.
//
// Deprecated: Please use types in: cloud.google.com/go/datastore/apiv1/datastorepb
type KindExpression = src.KindExpression

// The request for [Datastore.Lookup][google.datastore.v1.Datastore.Lookup].
//
// Deprecated: Please use types in: cloud.google.com/go/datastore/apiv1/datastorepb
type LookupRequest = src.LookupRequest

// The response for [Datastore.Lookup][google.datastore.v1.Datastore.Lookup].
//
// Deprecated: Please use types in: cloud.google.com/go/datastore/apiv1/datastorepb
type LookupResponse = src.LookupResponse

// A mutation to apply to an entity.
//
// Deprecated: Please use types in: cloud.google.com/go/datastore/apiv1/datastorepb
type Mutation = src.Mutation

// The result of applying a mutation.
//
// Deprecated: Please use types in: cloud.google.com/go/datastore/apiv1/datastorepb
type MutationResult = src.MutationResult
type Mutation_BaseVersion = src.Mutation_BaseVersion
type Mutation_Delete = src.Mutation_Delete
type Mutation_Insert = src.Mutation_Insert
type Mutation_Update = src.Mutation_Update
type Mutation_UpdateTime = src.Mutation_UpdateTime
type Mutation_Upsert = src.Mutation_Upsert

// A partition ID identifies a grouping of entities. The grouping is always by
// project and namespace, however the namespace ID may be empty. A partition ID
// contains several dimensions: project ID and namespace ID. Partition
// dimensions: - May be `""`. - Must be valid UTF-8 bytes. - Must have values
// that match regex `[A-Za-z\d\.\-_]{1,100}` If the value of any dimension
// matches regex `__.*__`, the partition is reserved/read-only. A
// reserved/read-only partition ID is forbidden in certain documented contexts.
// Foreign partition IDs (in which the project ID does not match the context
// project ID ) are discouraged. Reads and writes of foreign partition IDs may
// fail if the project is not in an active state.
//
// Deprecated: Please use types in: cloud.google.com/go/datastore/apiv1/datastorepb
type PartitionId = src.PartitionId

// Planning phase information for the query.
//
// Deprecated: Please use types in: cloud.google.com/go/datastore/apiv1/datastorepb
type PlanSummary = src.PlanSummary

// A representation of a property in a projection.
//
// Deprecated: Please use types in: cloud.google.com/go/datastore/apiv1/datastorepb
type Projection = src.Projection

// A filter on a specific property.
//
// Deprecated: Please use types in: cloud.google.com/go/datastore/apiv1/datastorepb
type PropertyFilter = src.PropertyFilter

// A property filter operator.
//
// Deprecated: Please use types in: cloud.google.com/go/datastore/apiv1/datastorepb
type PropertyFilter_Operator = src.PropertyFilter_Operator

// The set of arbitrarily nested property paths used to restrict an operation
// to only a subset of properties in an entity.
//
// Deprecated: Please use types in: cloud.google.com/go/datastore/apiv1/datastorepb
type PropertyMask = src.PropertyMask

// The desired order for a specific property.
//
// Deprecated: Please use types in: cloud.google.com/go/datastore/apiv1/datastorepb
type PropertyOrder = src.PropertyOrder

// The sort direction.
//
// Deprecated: Please use types in: cloud.google.com/go/datastore/apiv1/datastorepb
type PropertyOrder_Direction = src.PropertyOrder_Direction

// A reference to a property relative to the kind expressions.
//
// Deprecated: Please use types in: cloud.google.com/go/datastore/apiv1/datastorepb
type PropertyReference = src.PropertyReference

// A query for entities.
//
// Deprecated: Please use types in: cloud.google.com/go/datastore/apiv1/datastorepb
type Query = src.Query

// A batch of results produced by a query.
//
// Deprecated: Please use types in: cloud.google.com/go/datastore/apiv1/datastorepb
type QueryResultBatch = src.QueryResultBatch

// The possible values for the `more_results` field.
//
// Deprecated: Please use types in: cloud.google.com/go/datastore/apiv1/datastorepb
type QueryResultBatch_MoreResultsType = src.QueryResultBatch_MoreResultsType

// The options shared by read requests.
//
// Deprecated: Please use types in: cloud.google.com/go/datastore/apiv1/datastorepb
type ReadOptions = src.ReadOptions
type ReadOptions_NewTransaction = src.ReadOptions_NewTransaction

// The possible values for read consistencies.
//
// Deprecated: Please use types in: cloud.google.com/go/datastore/apiv1/datastorepb
type ReadOptions_ReadConsistency = src.ReadOptions_ReadConsistency
type ReadOptions_ReadConsistency_ = src.ReadOptions_ReadConsistency_
type ReadOptions_ReadTime = src.ReadOptions_ReadTime
type ReadOptions_Transaction = src.ReadOptions_Transaction

// The request for
// [Datastore.ReserveIds][google.datastore.v1.Datastore.ReserveIds].
//
// Deprecated: Please use types in: cloud.google.com/go/datastore/apiv1/datastorepb
type ReserveIdsRequest = src.ReserveIdsRequest

// The response for
// [Datastore.ReserveIds][google.datastore.v1.Datastore.ReserveIds].
//
// Deprecated: Please use types in: cloud.google.com/go/datastore/apiv1/datastorepb
type ReserveIdsResponse = src.ReserveIdsResponse

// The request for
// [Datastore.Rollback][google.datastore.v1.Datastore.Rollback].
//
// Deprecated: Please use types in: cloud.google.com/go/datastore/apiv1/datastorepb
type RollbackRequest = src.RollbackRequest

// The response for
// [Datastore.Rollback][google.datastore.v1.Datastore.Rollback]. (an empty
// message).
//
// Deprecated: Please use types in: cloud.google.com/go/datastore/apiv1/datastorepb
type RollbackResponse = src.RollbackResponse

// The request for
// [Datastore.RunAggregationQuery][google.datastore.v1.Datastore.RunAggregationQuery].
//
// Deprecated: Please use types in: cloud.google.com/go/datastore/apiv1/datastorepb
type RunAggregationQueryRequest = src.RunAggregationQueryRequest
type RunAggregationQueryRequest_AggregationQuery = src.RunAggregationQueryRequest_AggregationQuery
type RunAggregationQueryRequest_GqlQuery = src.RunAggregationQueryRequest_GqlQuery

// The response for
// [Datastore.RunAggregationQuery][google.datastore.v1.Datastore.RunAggregationQuery].
//
// Deprecated: Please use types in: cloud.google.com/go/datastore/apiv1/datastorepb
type RunAggregationQueryResponse = src.RunAggregationQueryResponse

// The request for
// [Datastore.RunQuery][google.datastore.v1.Datastore.RunQuery].
//
// Deprecated: Please use types in: cloud.google.com/go/datastore/apiv1/datastorepb
type RunQueryRequest = src.RunQueryRequest
type RunQueryRequest_GqlQuery = src.RunQueryRequest_GqlQuery
type RunQueryRequest_Query = src.RunQueryRequest_Query

// The response for
// [Datastore.RunQuery][google.datastore.v1.Datastore.RunQuery].
//
// Deprecated: Please use types in: cloud.google.com/go/datastore/apiv1/datastorepb
type RunQueryResponse = src.RunQueryResponse

// Options for beginning a new transaction. Transactions can be created
// explicitly with calls to
// [Datastore.BeginTransaction][google.datastore.v1.Datastore.BeginTransaction]
// or implicitly by setting
// [ReadOptions.new_transaction][google.datastore.v1.ReadOptions.new_transaction]
// in read requests.
//
// Deprecated: Please use types in: cloud.google.com/go/datastore/apiv1/datastorepb
type TransactionOptions = src.TransactionOptions

// Options specific to read-only transactions.
//
// Deprecated: Please use types in: cloud.google.com/go/datastore/apiv1/datastorepb
type TransactionOptions_ReadOnly = src.TransactionOptions_ReadOnly
type TransactionOptions_ReadOnly_ = src.TransactionOptions_ReadOnly_

// Options specific to read / write transactions.
//
// Deprecated: Please use types in: cloud.google.com/go/datastore/apiv1/datastorepb
type TransactionOptions_ReadWrite = src.TransactionOptions_ReadWrite
type TransactionOptions_ReadWrite_ = src.TransactionOptions_ReadWrite_

// UnimplementedDatastoreServer can be embedded to have forward compatible
// implementations.
//
// Deprecated: Please use types in: cloud.google.com/go/datastore/apiv1/datastorepb
type UnimplementedDatastoreServer = src.UnimplementedDatastoreServer

// A message that can hold any of the supported value types and associated
// metadata.
//
// Deprecated: Please use types in: cloud.google.com/go/datastore/apiv1/datastorepb
type Value = src.Value
type Value_ArrayValue = src.Value_ArrayValue
type Value_BlobValue = src.Value_BlobValue
type Value_BooleanValue = src.Value_BooleanValue
type Value_DoubleValue = src.Value_DoubleValue
type Value_EntityValue = src.Value_EntityValue
type Value_GeoPointValue = src.Value_GeoPointValue
type Value_IntegerValue = src.Value_IntegerValue
type Value_KeyValue = src.Value_KeyValue
type Value_NullValue = src.Value_NullValue
type Value_StringValue = src.Value_StringValue
type Value_TimestampValue = src.Value_TimestampValue

// Deprecated: Please use funcs in: cloud.google.com/go/datastore/apiv1/datastorepb
func NewDatastoreClient(cc grpc.ClientConnInterface) DatastoreClient {
	return src.NewDatastoreClient(cc)
}

// Deprecated: Please use funcs in: cloud.google.com/go/datastore/apiv1/datastorepb
func RegisterDatastoreServer(s *grpc.Server, srv DatastoreServer) {
	src.RegisterDatastoreServer(s, srv)
}
