/*
  File: menu.c

  Copyright (C) 2007
  Marcin 'Morgoth' Kurek <morgoth6@box43.pl>

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include "bootcreator.h"

#include "menu.h"

/*
 * Menu - Version 0
 */

const struct MenuDescriptorNode Menu0[] = {
	{"\\ FORTH - Script generated by %s\n", ID_ID},

	{"\\\n", ID_ORDINARY},
	{"\\ boot menu stuff\n", ID_ORDINARY},
	{"\\\n", ID_ORDINARY},

	{"  .\"  \" cr\n", ID_ORDINARY},
	{"  .\" %s\" cr\n", ID_TITLE},
	{"  .\"  \" cr\n", ID_ORDINARY},
	{"  .\" %d: %s\" cr\n", ID_LABELS},
	{"  .\"  \" cr\n", ID_ORDINARY},
	{"  .\" > \"\n", ID_ORDINARY},

	{"key case\n", ID_ORDINARY},
	{"  %d of %s endof\n", ID_COMMANDS},
	{"endcase\n", ID_ORDINARY},

	/* End */
	{"", ID_END}
};

/*
 * Menu - Version 1 / 2
 */

const struct MenuDescriptorNode Menu1[] = {
	{"\\ FORTH - Script generated by %s\n", ID_ID},

	{"\\\n", ID_REM_V2},
	{"\\ terminal control stuff\n", ID_REM_V2},
	{"\\\n", ID_REM_V2},
	{": TTY.CSI d# 27 EMIT ASCII [ EMIT ;\n", ID_REM_V2},
	{": TTY.HOME    TTY.CSI ASCII H EMIT ;\n", ID_REM_V2},
	{": TTY.CLR_EOS TTY.CSI ASCII J EMIT ;\n", ID_REM_V2},
	{": TTY.HOME_CLR TTY.HOME TTY.CLR_EOS ;\n", ID_REM_V2},

	{"\\\n", ID_ORDINARY},
	{"\\ boot menu stuff\n", ID_ORDINARY},
	{"\\\n", ID_ORDINARY},
	{": my-max-boot-num %d ;\n", ID_BOOTNUM},
	{": my-boot-default %d ;\n", ID_BOOTDEF},
	{": my-boot-delay d# %d ; \\ unit = 100 ms\n", ID_BOOTDELAY},
	{": my-print-menu ( -- )\n", ID_ORDINARY},
	{"  TTY.HOME_CLR\n", ID_REM_V2},
	{"  .\"  \" cr\n", ID_TITLEP},
	{"  .\" %s\" cr\n", ID_TITLE},
	{"  .\"  \" cr\n", ID_TITLEP},
	{"  .\" %d: %s\" cr\n", ID_LABELS},
	{"  .\"  \" cr\n", ID_ORDINARY},
	{";\n", ID_ORDINARY},
	{": my-boot-case ( num -- )\n", ID_ORDINARY},
	{"  .\"  \" cr\n", ID_ORDINARY},
	{"  case\n", ID_ORDINARY},
	{"    %d of %s endof\n", ID_COMMANDS},
	{"  endcase\n", ID_ORDINARY},
	{"  $boot\n", ID_REM_V2},
	{";\n", ID_ORDINARY},

	{": my-input-num ( wait-period max-boot-num default-num -- boot-num )\n", ID_ORDINARY},
	{"  1 \\ loop-inc = 1\n", ID_ORDINARY},
	{"  3 pick 0 do\n", ID_ORDINARY},
	{"    0d emit\n", ID_ORDINARY},
	{"    .\" press 1-\"\n", ID_ORDINARY},
	{"    ( wait-period max-boot-num default-num loop-inc )\n", ID_ORDINARY},
	{"    2 pick ascii 0 + emit\n", ID_ORDINARY},
	{"    dup 1 = if\n", ID_ORDINARY},
	{"      .\"  within \"\n", ID_ORDINARY},
	{"      3 pick i - d# 10 / .d\n", ID_ORDINARY},
	{"      .\"  seconds\"\n", ID_ORDINARY},
	{"    then\n", ID_ORDINARY},
	{"    .\"  (default: \"\n", ID_ORDINARY},
	{"    over ascii 0 + emit\n", ID_ORDINARY},
	{"    .\" ) :                   \"\n", ID_ORDINARY},
	{"    d# 100 ms\n", ID_ORDINARY},
	{"    key? if\n", ID_ORDINARY},
	{"       key\n", ID_ORDINARY},
	{"       ( wait-period max-boot-num default-num loop-inc key )\n", ID_ORDINARY},
	{"       dup 0d = if \\ return pressed\n", ID_ORDINARY},
	{"         drop leave\n", ID_ORDINARY},
	{"       then\n", ID_ORDINARY},
	{"       ascii 0 -\n", ID_ORDINARY},
	{"       ( wait-period max-boot-num default-num loop-inc num )\n", ID_ORDINARY},
	{"       dup 1 5 pick\n", ID_ORDINARY},
	{"       ( wait-period max-boot-num default-num loop-inc num num 1 max-boot-num )\n", ID_ORDINARY},
	{"       between if\n", ID_ORDINARY},
	{"         rot drop swap leave\n", ID_ORDINARY},
	{"       then\n", ID_ORDINARY},
	{"       ( wait-period max-boot-num default-num loop-inc num )\n", ID_ORDINARY},
	{"       %s\n", ID_ABORT},
	{"    then\n", ID_ORDINARY},
	{"  dup +loop\n", ID_ORDINARY},
	{"  drop\n", ID_ORDINARY},
	{"  ( wait-period max-boot-num boot-num )\n", ID_ORDINARY},
	{"  nip nip\n", ID_ORDINARY},
	{";\n", ID_ORDINARY},

	{"my-print-menu\n", ID_ORDINARY},
	{"my-boot-delay my-max-boot-num my-boot-default my-input-num\n", ID_ORDINARY},
	{"my-boot-case\n", ID_ORDINARY},

	/* End */
	{"", ID_END},
};
