/*
   Copyright (C) 2004 by James Gregory
   Part of the GalaxyHack project
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License.
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY.
 
   See the COPYING file for more details.
*/

#ifndef GUARD_GenWindow
#define GUARD_GenWindow

#include "GenWindow_Base.h"
#include "GenericHandle.h"

#include <string>

using std::string;

void UpdateWindows();
bool WinMouseD(Uint8 button, Uint16 x, Uint16 y);
void WinMouseM(Uint8 state, Uint16 x, Uint16 y);
bool WinKeyboard(SDL_keysym& keysym);

void MessageWindows(WindowChoice theMessage, int paremOne, int paremTwo, int targetID, int sourceID);
void CreateInfoString(const string& iTheString, bool force = 0);
void DrawAllWindows();
void KillAllWindows();
GenWindow_Base* LocateWindow(int findID);

class GenWindow {
public:
	GenWindow(int ix, int iy, WindowChoice iType, int paremOne, int paremTwo, int flags);
	GenWindow(int ix, int iy, WindowChoice iType, int paremOne, int paremTwo, int paremThree, int paremFour, int flags);
	GenWindow(int ix, int iy, WindowChoice iType, const string& iString, int paremOne, int paremTwo);
	GenWindow(int ix, int iy, WindowChoice iType, const string& iString, UnitType iUnitType, int paremOne, int paremTwo, int paremThree);
	GenWindow(int ix, int iy, WindowChoice iType, int iSliderVar, int iVarMin, int iVarMax, const string& iVarName, const string& iVarUnits, int iParentID, int flags);
	GenWindow(int ix, int iy, WindowChoice iType, int* iVarPointer, int iVarMin, int iVarMax, const string& iVarName, const string& iVarUnits, int iParentID, int flags);
	GenWindow(WindowChoice iType, UnitType iUnitType, int paremOne);
	GenWindow(WindowChoice iType, int iMySide, int iMyGroup, WindowChoice iChoiceType);
	GenWindow(WindowChoice iType, int iMySide, int iMyGroup, WindowChoice iChoiceType, int iWhichSaveGroup);
	GenWindow(WindowChoice iType, const string& stringOne, const string& stringTwo, int iParentID);
	GenWindow(const string& iTheString);

	bool MouseD(Uint8 button, Uint16 x, Uint16 y) {return hWindow->MouseD(button, x, y);}
	bool MouseM(Uint8 state, Uint16 x, Uint16 y) {return hWindow->MouseM(state, x, y);}
	bool Keyboard(SDL_keysym& keysym) {return hWindow->Keyboard(keysym);}
	
	void Update() {hWindow->Update();}
	
	bool TakeActivate();
	int GetClosed() const {return hWindow->closed;}
	void DrawSelf() {hWindow->DrawSelf();}

	GenWindow_Base* GetPointer() {return hWindow.GetPointer();}

	void WinMessage(WindowChoice theMessage, int paremOne, int paremTwo, int targetID, int sourceID);

protected:
	GenericHandle<GenWindow_Base> hWindow;
};

#endif

