/*
   Copyright (C) 2004 by James Gregory
   Part of the GalaxyHack project
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License.
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY.
 
   See the COPYING file for more details.
*/

#ifndef GUARD_GenWindow_Base
#define GUARD_GenWindow_Base

#include "JSDL.h"
#include "Enums.h"

//forward declaration
class GenWindow;

class GenWindow_Base {
public:
	GenWindow_Base(int ix, int iy, int iParentID, int flags);
	//tell everyone we're closing
	virtual ~GenWindow_Base();

	virtual void Update() {}

	virtual bool MouseD(Uint8 button, Uint16 x, Uint16 y);
	virtual bool MouseM(Uint8 state, Uint16 x, Uint16 y) {return false;}
	virtual bool Keyboard(SDL_keysym& keysym) {return false;}

	virtual void DrawSelf() = 0;

	virtual void WinMessage(WindowChoice theMessage, int paremOne, int paremTwo, int targetID, int sourceID);

	void GroupNumChange(int paremOne, int ParemTwo, int& myGroup);
	
	//for dragwindows you must centre before initing rects, for menus it is the other way round. This is seriously error prone, I should FIXME it one day, maybe
	void CentreWindow();

	SDL_Rect rect;
	SDL_Rect borderRect;

	int myID;
	//set to none in constructor, derived classes
	//can set it to a proper value if they have a parent
	int parentID;
	bool activate;
	//you can send messages to windows to tell them to close
	bool closed;

	bool visible;

protected:
	void InitBorder();

	virtual void ExpensiveUpdate() {}
	virtual void Move(int distx, int disty);

	//defaults to gold
	int borderColor;
	bool bStatic;
	bool cantClose;
	bool transparent;
};

#endif


