#! /usr/bin/env expect -f

source [file join [file dirname $argv0] common.tcl]

spawn /bin/bash
send "PS1=':''/# '\r"
eexpect ":/# "

# Perform command-line checking for logging flags. We cannot use a
# regular unit test for this, because the logging flags are declared
# for the global `CommandLine` object of package `flag`, and any
# errors when parsing flags in that context cause the (test) process
# to exit entirely (it has errorHandling set to ExitOnError).

start_test "Check that log files are created by default in the store directory."
send "$argv start --insecure --store=path=logs/mystore\r"
eexpect "node starting"
interrupt
eexpect ":/# "
send "ls logs/mystore/logs\r"
eexpect "cockroach.log"
eexpect ":/# "
end_test

start_test "Check that an empty -log-dir disables file logging."
send "$argv start --insecure --store=path=logs/mystore2 --log-dir=\r"
eexpect "node starting"
interrupt
eexpect ":/# "
send "ls logs/mystore2/logs 2>/dev/null | wc -l\r"
eexpect "0"
eexpect ":/# "
end_test

start_test "Check that leading tildes are properly rejected."
send "$argv start --insecure -s=path=logs/db --log-dir=\~/blah\r"
eexpect "log directory cannot start with '~'"
eexpect ":/# "
end_test

start_test "Check that the user can override."
send "$argv start --insecure -s=path=logs/db --log-dir=logs/blah/\~/blah\r"
eexpect "logs: *blah/~/blah"
interrupt
eexpect ":/# "
end_test

start_test "Check that TRUE and FALSE are valid values for the severity flags."
send "$argv start --insecure -s=path=logs/db --logtostderr=false\r"
eexpect "node starting"
interrupt
eexpect ":/# "
send "$argv start --insecure -s=path=logs/db --logtostderr=true\r"
eexpect "node starting"
interrupt
eexpect ":/# "
send "$argv start --insecure -s=path=logs/db --logtostderr=2\r"
eexpect "node starting"
interrupt
eexpect ":/# "
send "$argv start --insecure -s=path=logs/db --logtostderr=cantparse\r"
eexpect "parsing \"cantparse\": invalid syntax"
eexpect ":/# "
end_test

send "exit 0\r"
eexpect eof
