// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: sql/distsqlrun/processors.proto

package distsqlrun

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"
import cockroach_sql_jobs_jobspb "github.com/cockroachdb/cockroach/pkg/jobs/jobspb"
import cockroach_roachpb1 "github.com/cockroachdb/cockroach/pkg/roachpb"
import cockroach_roachpb4 "github.com/cockroachdb/cockroach/pkg/roachpb"
import cockroach_sql_sqlbase1 "github.com/cockroachdb/cockroach/pkg/sql/sqlbase"
import cockroach_sql_sqlbase3 "github.com/cockroachdb/cockroach/pkg/sql/sqlbase"
import cockroach_util_hlc "github.com/cockroachdb/cockroach/pkg/util/hlc"

import time "time"
import github_com_cockroachdb_cockroach_pkg_roachpb "github.com/cockroachdb/cockroach/pkg/roachpb"
import github_com_cockroachdb_cockroach_pkg_sql_sqlbase "github.com/cockroachdb/cockroach/pkg/sql/sqlbase"

import sortkeys "github.com/gogo/protobuf/sortkeys"
import binary "encoding/binary"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf
var _ = time.Kitchen

// ScanVisibility controls which columns are seen by scans - just normal
// columns, or normal columns and also in-progress schema change columns.
type ScanVisibility int32

const (
	ScanVisibility_PUBLIC                ScanVisibility = 0
	ScanVisibility_PUBLIC_AND_NOT_PUBLIC ScanVisibility = 1
)

var ScanVisibility_name = map[int32]string{
	0: "PUBLIC",
	1: "PUBLIC_AND_NOT_PUBLIC",
}
var ScanVisibility_value = map[string]int32{
	"PUBLIC":                0,
	"PUBLIC_AND_NOT_PUBLIC": 1,
}

func (x ScanVisibility) Enum() *ScanVisibility {
	p := new(ScanVisibility)
	*p = x
	return p
}
func (x ScanVisibility) String() string {
	return proto.EnumName(ScanVisibility_name, int32(x))
}
func (x *ScanVisibility) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(ScanVisibility_value, data, "ScanVisibility")
	if err != nil {
		return err
	}
	*x = ScanVisibility(value)
	return nil
}
func (ScanVisibility) EnumDescriptor() ([]byte, []int) { return fileDescriptorProcessors, []int{0} }

type SketchType int32

const (
	// This is the github.com/axiomhq/hyperloglog binary format
	// (as of commit 730eea1) for a sketch with precision 14.
	SketchType_HLL_PLUS_PLUS_V1 SketchType = 0
)

var SketchType_name = map[int32]string{
	0: "HLL_PLUS_PLUS_V1",
}
var SketchType_value = map[string]int32{
	"HLL_PLUS_PLUS_V1": 0,
}

func (x SketchType) Enum() *SketchType {
	p := new(SketchType)
	*p = x
	return p
}
func (x SketchType) String() string {
	return proto.EnumName(SketchType_name, int32(x))
}
func (x *SketchType) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(SketchType_value, data, "SketchType")
	if err != nil {
		return err
	}
	*x = SketchType(value)
	return nil
}
func (SketchType) EnumDescriptor() ([]byte, []int) { return fileDescriptorProcessors, []int{1} }

// These mirror the aggregate functions supported by sql/parser. See
// sql/parser/aggregate_builtins.go.
type AggregatorSpec_Func int32

const (
	AggregatorSpec_ANY_NOT_NULL   AggregatorSpec_Func = 0
	AggregatorSpec_AVG            AggregatorSpec_Func = 1
	AggregatorSpec_BOOL_AND       AggregatorSpec_Func = 2
	AggregatorSpec_BOOL_OR        AggregatorSpec_Func = 3
	AggregatorSpec_CONCAT_AGG     AggregatorSpec_Func = 4
	AggregatorSpec_COUNT          AggregatorSpec_Func = 5
	AggregatorSpec_MAX            AggregatorSpec_Func = 7
	AggregatorSpec_MIN            AggregatorSpec_Func = 8
	AggregatorSpec_STDDEV         AggregatorSpec_Func = 9
	AggregatorSpec_SUM            AggregatorSpec_Func = 10
	AggregatorSpec_SUM_INT        AggregatorSpec_Func = 11
	AggregatorSpec_VARIANCE       AggregatorSpec_Func = 12
	AggregatorSpec_XOR_AGG        AggregatorSpec_Func = 13
	AggregatorSpec_COUNT_ROWS     AggregatorSpec_Func = 14
	AggregatorSpec_SQRDIFF        AggregatorSpec_Func = 15
	AggregatorSpec_FINAL_VARIANCE AggregatorSpec_Func = 16
	AggregatorSpec_FINAL_STDDEV   AggregatorSpec_Func = 17
	AggregatorSpec_ARRAY_AGG      AggregatorSpec_Func = 18
	AggregatorSpec_JSON_AGG       AggregatorSpec_Func = 19
	// JSONB_AGG is an alias for JSON_AGG, they do the same thing.
	AggregatorSpec_JSONB_AGG  AggregatorSpec_Func = 20
	AggregatorSpec_STRING_AGG AggregatorSpec_Func = 21
)

var AggregatorSpec_Func_name = map[int32]string{
	0:  "ANY_NOT_NULL",
	1:  "AVG",
	2:  "BOOL_AND",
	3:  "BOOL_OR",
	4:  "CONCAT_AGG",
	5:  "COUNT",
	7:  "MAX",
	8:  "MIN",
	9:  "STDDEV",
	10: "SUM",
	11: "SUM_INT",
	12: "VARIANCE",
	13: "XOR_AGG",
	14: "COUNT_ROWS",
	15: "SQRDIFF",
	16: "FINAL_VARIANCE",
	17: "FINAL_STDDEV",
	18: "ARRAY_AGG",
	19: "JSON_AGG",
	20: "JSONB_AGG",
	21: "STRING_AGG",
}
var AggregatorSpec_Func_value = map[string]int32{
	"ANY_NOT_NULL":   0,
	"AVG":            1,
	"BOOL_AND":       2,
	"BOOL_OR":        3,
	"CONCAT_AGG":     4,
	"COUNT":          5,
	"MAX":            7,
	"MIN":            8,
	"STDDEV":         9,
	"SUM":            10,
	"SUM_INT":        11,
	"VARIANCE":       12,
	"XOR_AGG":        13,
	"COUNT_ROWS":     14,
	"SQRDIFF":        15,
	"FINAL_VARIANCE": 16,
	"FINAL_STDDEV":   17,
	"ARRAY_AGG":      18,
	"JSON_AGG":       19,
	"JSONB_AGG":      20,
	"STRING_AGG":     21,
}

func (x AggregatorSpec_Func) Enum() *AggregatorSpec_Func {
	p := new(AggregatorSpec_Func)
	*p = x
	return p
}
func (x AggregatorSpec_Func) String() string {
	return proto.EnumName(AggregatorSpec_Func_name, int32(x))
}
func (x *AggregatorSpec_Func) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(AggregatorSpec_Func_value, data, "AggregatorSpec_Func")
	if err != nil {
		return err
	}
	*x = AggregatorSpec_Func(value)
	return nil
}
func (AggregatorSpec_Func) EnumDescriptor() ([]byte, []int) {
	return fileDescriptorProcessors, []int{17, 0}
}

type AggregatorSpec_Type int32

const (
	// This setting exists just for backwards compatibility; it's equivalent to
	// SCALAR when there are no grouping columns, and to NON_SCALAR when there
	// are grouping columns.
	AggregatorSpec_AUTO AggregatorSpec_Type = 0
	// A scalar aggregation has no grouping columns and always returns one
	// result row.
	AggregatorSpec_SCALAR AggregatorSpec_Type = 1
	// A non-scalar aggregation returns no rows if there are no input rows; it
	// may or may not have grouping columns.
	AggregatorSpec_NON_SCALAR AggregatorSpec_Type = 2
)

var AggregatorSpec_Type_name = map[int32]string{
	0: "AUTO",
	1: "SCALAR",
	2: "NON_SCALAR",
}
var AggregatorSpec_Type_value = map[string]int32{
	"AUTO":       0,
	"SCALAR":     1,
	"NON_SCALAR": 2,
}

func (x AggregatorSpec_Type) Enum() *AggregatorSpec_Type {
	p := new(AggregatorSpec_Type)
	*p = x
	return p
}
func (x AggregatorSpec_Type) String() string {
	return proto.EnumName(AggregatorSpec_Type_name, int32(x))
}
func (x *AggregatorSpec_Type) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(AggregatorSpec_Type_value, data, "AggregatorSpec_Type")
	if err != nil {
		return err
	}
	*x = AggregatorSpec_Type(value)
	return nil
}
func (AggregatorSpec_Type) EnumDescriptor() ([]byte, []int) {
	return fileDescriptorProcessors, []int{17, 1}
}

type BackfillerSpec_Type int32

const (
	BackfillerSpec_Invalid BackfillerSpec_Type = 0
	BackfillerSpec_Column  BackfillerSpec_Type = 1
	BackfillerSpec_Index   BackfillerSpec_Type = 2
)

var BackfillerSpec_Type_name = map[int32]string{
	0: "Invalid",
	1: "Column",
	2: "Index",
}
var BackfillerSpec_Type_value = map[string]int32{
	"Invalid": 0,
	"Column":  1,
	"Index":   2,
}

func (x BackfillerSpec_Type) Enum() *BackfillerSpec_Type {
	p := new(BackfillerSpec_Type)
	*p = x
	return p
}
func (x BackfillerSpec_Type) String() string {
	return proto.EnumName(BackfillerSpec_Type_name, int32(x))
}
func (x *BackfillerSpec_Type) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(BackfillerSpec_Type_value, data, "BackfillerSpec_Type")
	if err != nil {
		return err
	}
	*x = BackfillerSpec_Type(value)
	return nil
}
func (BackfillerSpec_Type) EnumDescriptor() ([]byte, []int) {
	return fileDescriptorProcessors, []int{18, 0}
}

type WindowerSpec_WindowFunc int32

const (
	// These mirror window functions from window_builtins.go.
	WindowerSpec_ROW_NUMBER   WindowerSpec_WindowFunc = 0
	WindowerSpec_RANK         WindowerSpec_WindowFunc = 1
	WindowerSpec_DENSE_RANK   WindowerSpec_WindowFunc = 2
	WindowerSpec_PERCENT_RANK WindowerSpec_WindowFunc = 3
	WindowerSpec_CUME_DIST    WindowerSpec_WindowFunc = 4
	WindowerSpec_NTILE        WindowerSpec_WindowFunc = 5
	WindowerSpec_LAG          WindowerSpec_WindowFunc = 6
	WindowerSpec_LEAD         WindowerSpec_WindowFunc = 7
	WindowerSpec_FIRST_VALUE  WindowerSpec_WindowFunc = 8
	WindowerSpec_LAST_VALUE   WindowerSpec_WindowFunc = 9
	WindowerSpec_NTH_VALUE    WindowerSpec_WindowFunc = 10
)

var WindowerSpec_WindowFunc_name = map[int32]string{
	0:  "ROW_NUMBER",
	1:  "RANK",
	2:  "DENSE_RANK",
	3:  "PERCENT_RANK",
	4:  "CUME_DIST",
	5:  "NTILE",
	6:  "LAG",
	7:  "LEAD",
	8:  "FIRST_VALUE",
	9:  "LAST_VALUE",
	10: "NTH_VALUE",
}
var WindowerSpec_WindowFunc_value = map[string]int32{
	"ROW_NUMBER":   0,
	"RANK":         1,
	"DENSE_RANK":   2,
	"PERCENT_RANK": 3,
	"CUME_DIST":    4,
	"NTILE":        5,
	"LAG":          6,
	"LEAD":         7,
	"FIRST_VALUE":  8,
	"LAST_VALUE":   9,
	"NTH_VALUE":    10,
}

func (x WindowerSpec_WindowFunc) Enum() *WindowerSpec_WindowFunc {
	p := new(WindowerSpec_WindowFunc)
	*p = x
	return p
}
func (x WindowerSpec_WindowFunc) String() string {
	return proto.EnumName(WindowerSpec_WindowFunc_name, int32(x))
}
func (x *WindowerSpec_WindowFunc) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(WindowerSpec_WindowFunc_value, data, "WindowerSpec_WindowFunc")
	if err != nil {
		return err
	}
	*x = WindowerSpec_WindowFunc(value)
	return nil
}
func (WindowerSpec_WindowFunc) EnumDescriptor() ([]byte, []int) {
	return fileDescriptorProcessors, []int{29, 0}
}

// Mode indicates which mode of framing is used.
type WindowerSpec_Frame_Mode int32

const (
	// RANGE specifies frame in terms of logical range (e.g. 1 unit cheaper).
	WindowerSpec_Frame_RANGE WindowerSpec_Frame_Mode = 0
	// ROWS specifies frame in terms of physical offsets (e.g. 1 row before).
	WindowerSpec_Frame_ROWS WindowerSpec_Frame_Mode = 1
	// GROUPS specifies frame in terms of peer groups (where "peers" mean
	// rows not distinct in the ordering columns).
	WindowerSpec_Frame_GROUPS WindowerSpec_Frame_Mode = 2
)

var WindowerSpec_Frame_Mode_name = map[int32]string{
	0: "RANGE",
	1: "ROWS",
	2: "GROUPS",
}
var WindowerSpec_Frame_Mode_value = map[string]int32{
	"RANGE":  0,
	"ROWS":   1,
	"GROUPS": 2,
}

func (x WindowerSpec_Frame_Mode) Enum() *WindowerSpec_Frame_Mode {
	p := new(WindowerSpec_Frame_Mode)
	*p = x
	return p
}
func (x WindowerSpec_Frame_Mode) String() string {
	return proto.EnumName(WindowerSpec_Frame_Mode_name, int32(x))
}
func (x *WindowerSpec_Frame_Mode) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(WindowerSpec_Frame_Mode_value, data, "WindowerSpec_Frame_Mode")
	if err != nil {
		return err
	}
	*x = WindowerSpec_Frame_Mode(value)
	return nil
}
func (WindowerSpec_Frame_Mode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptorProcessors, []int{29, 1, 0}
}

// BoundType indicates which type of boundary is used.
type WindowerSpec_Frame_BoundType int32

const (
	WindowerSpec_Frame_UNBOUNDED_PRECEDING WindowerSpec_Frame_BoundType = 0
	WindowerSpec_Frame_UNBOUNDED_FOLLOWING WindowerSpec_Frame_BoundType = 1
	// Offsets are stored within Bound.
	WindowerSpec_Frame_OFFSET_PRECEDING WindowerSpec_Frame_BoundType = 2
	WindowerSpec_Frame_OFFSET_FOLLOWING WindowerSpec_Frame_BoundType = 3
	WindowerSpec_Frame_CURRENT_ROW      WindowerSpec_Frame_BoundType = 4
)

var WindowerSpec_Frame_BoundType_name = map[int32]string{
	0: "UNBOUNDED_PRECEDING",
	1: "UNBOUNDED_FOLLOWING",
	2: "OFFSET_PRECEDING",
	3: "OFFSET_FOLLOWING",
	4: "CURRENT_ROW",
}
var WindowerSpec_Frame_BoundType_value = map[string]int32{
	"UNBOUNDED_PRECEDING": 0,
	"UNBOUNDED_FOLLOWING": 1,
	"OFFSET_PRECEDING":    2,
	"OFFSET_FOLLOWING":    3,
	"CURRENT_ROW":         4,
}

func (x WindowerSpec_Frame_BoundType) Enum() *WindowerSpec_Frame_BoundType {
	p := new(WindowerSpec_Frame_BoundType)
	*p = x
	return p
}
func (x WindowerSpec_Frame_BoundType) String() string {
	return proto.EnumName(WindowerSpec_Frame_BoundType_name, int32(x))
}
func (x *WindowerSpec_Frame_BoundType) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(WindowerSpec_Frame_BoundType_value, data, "WindowerSpec_Frame_BoundType")
	if err != nil {
		return err
	}
	*x = WindowerSpec_Frame_BoundType(value)
	return nil
}
func (WindowerSpec_Frame_BoundType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptorProcessors, []int{29, 1, 1}
}

// Each processor has the following components:
//  - one or more input synchronizers; each one merges rows between one or more
//    input streams;
//
//  - a processor "core" which encapsulates the inner logic of each processor;
//
//  - a post-processing stage which allows "inline" post-processing on results
//    (like projection or filtering);
//
//  - one or more output synchronizers; each one directs rows to one or more
//  output streams.
//
//
// == Internal columns ==
//
// The core outputs rows of a certain schema to the post-processing stage. We
// call this the "internal schema" (or "internal columns") and it differs for
// each type of core. Column indices in a PostProcessSpec refers to these
// internal columns. Some columns may be unused by the post-processing stage;
// processor implementations are internally optimized to not produce values for
// such unneeded columns.
type ProcessorSpec struct {
	// In most cases, there is one input.
	Input []InputSyncSpec    `protobuf:"bytes,1,rep,name=input" json:"input"`
	Core  ProcessorCoreUnion `protobuf:"bytes,2,opt,name=core" json:"core"`
	Post  PostProcessSpec    `protobuf:"bytes,4,opt,name=post" json:"post"`
	// In most cases, there is one output.
	Output []OutputRouterSpec `protobuf:"bytes,3,rep,name=output" json:"output"`
	// An optional identifier that can be used to correlate processors that are
	// part of the same stage (e.g. multiple joiners that are part of a
	// distributed join). This has no consequence on the running of flows, but is
	// useful for plan diagrams.
	StageID int32 `protobuf:"varint,5,opt,name=stage_id,json=stageId" json:"stage_id"`
	// processor_id uniquely identifies a processor within a physical plan. This
	// has no consequence on the running of flows, but is useful for plan
	// diagrams and linking information like tracing spans and log messages to
	// processors.
	ProcessorID int32 `protobuf:"varint,6,opt,name=processor_id,json=processorId" json:"processor_id"`
}

func (m *ProcessorSpec) Reset()                    { *m = ProcessorSpec{} }
func (m *ProcessorSpec) String() string            { return proto.CompactTextString(m) }
func (*ProcessorSpec) ProtoMessage()               {}
func (*ProcessorSpec) Descriptor() ([]byte, []int) { return fileDescriptorProcessors, []int{0} }

// PostProcessSpec describes the processing required to obtain the output
// (filtering, projection). It operates on the internal schema of the processor
// (see ProcessorSpec).
type PostProcessSpec struct {
	// A filtering expression which references the internal columns of the
	// processor via ordinal references (@1, @2, etc).
	Filter Expression `protobuf:"bytes,1,opt,name=filter" json:"filter"`
	// If true, output_columns describes a projection. Used to differentiate
	// between an empty projection and no projection.
	//
	// Cannot be set at the same time with render expressions.
	Projection bool `protobuf:"varint,2,opt,name=projection" json:"projection"`
	// The output columns describe a projection on the internal set of columns;
	// only the columns in this list will be emitted.
	//
	// Can only be set if projection is true. Cannot be set at the same time with
	// render expressions.
	OutputColumns []uint32 `protobuf:"varint,3,rep,packed,name=output_columns,json=outputColumns" json:"output_columns,omitempty"`
	// If set, the output is the result of rendering these expressions. The
	// expressions reference the internal columns of the processor.
	//
	// Cannot be set at the same time with output columns.
	RenderExprs []Expression `protobuf:"bytes,4,rep,name=render_exprs,json=renderExprs" json:"render_exprs"`
	// If nonzero, the first <offset> rows will be suppressed.
	Offset uint64 `protobuf:"varint,5,opt,name=offset" json:"offset"`
	// If nonzero, the processor will stop after emitting this many rows. The rows
	// suppressed by <offset>, if any, do not count towards this limit.
	Limit uint64 `protobuf:"varint,6,opt,name=limit" json:"limit"`
}

func (m *PostProcessSpec) Reset()                    { *m = PostProcessSpec{} }
func (m *PostProcessSpec) String() string            { return proto.CompactTextString(m) }
func (*PostProcessSpec) ProtoMessage()               {}
func (*PostProcessSpec) Descriptor() ([]byte, []int) { return fileDescriptorProcessors, []int{1} }

type ProcessorCoreUnion struct {
	Noop                    *NoopCoreSpec                `protobuf:"bytes,1,opt,name=noop" json:"noop,omitempty"`
	TableReader             *TableReaderSpec             `protobuf:"bytes,2,opt,name=tableReader" json:"tableReader,omitempty"`
	JoinReader              *JoinReaderSpec              `protobuf:"bytes,3,opt,name=joinReader" json:"joinReader,omitempty"`
	Sorter                  *SorterSpec                  `protobuf:"bytes,4,opt,name=sorter" json:"sorter,omitempty"`
	Aggregator              *AggregatorSpec              `protobuf:"bytes,5,opt,name=aggregator" json:"aggregator,omitempty"`
	Distinct                *DistinctSpec                `protobuf:"bytes,7,opt,name=distinct" json:"distinct,omitempty"`
	MergeJoiner             *MergeJoinerSpec             `protobuf:"bytes,8,opt,name=mergeJoiner" json:"mergeJoiner,omitempty"`
	HashJoiner              *HashJoinerSpec              `protobuf:"bytes,9,opt,name=hashJoiner" json:"hashJoiner,omitempty"`
	Values                  *ValuesCoreSpec              `protobuf:"bytes,10,opt,name=values" json:"values,omitempty"`
	Backfiller              *BackfillerSpec              `protobuf:"bytes,11,opt,name=backfiller" json:"backfiller,omitempty"`
	ReadImport              *ReadImportDataSpec          `protobuf:"bytes,13,opt,name=readImport" json:"readImport,omitempty"`
	SSTWriter               *SSTWriterSpec               `protobuf:"bytes,14,opt,name=SSTWriter" json:"SSTWriter,omitempty"`
	CSVWriter               *CSVWriterSpec               `protobuf:"bytes,20,opt,name=CSVWriter" json:"CSVWriter,omitempty"`
	Sampler                 *SamplerSpec                 `protobuf:"bytes,15,opt,name=Sampler" json:"Sampler,omitempty"`
	SampleAggregator        *SampleAggregatorSpec        `protobuf:"bytes,16,opt,name=SampleAggregator" json:"SampleAggregator,omitempty"`
	InterleavedReaderJoiner *InterleavedReaderJoinerSpec `protobuf:"bytes,17,opt,name=interleavedReaderJoiner" json:"interleavedReaderJoiner,omitempty"`
	MetadataTestSender      *MetadataTestSenderSpec      `protobuf:"bytes,18,opt,name=metadataTestSender" json:"metadataTestSender,omitempty"`
	MetadataTestReceiver    *MetadataTestReceiverSpec    `protobuf:"bytes,19,opt,name=metadataTestReceiver" json:"metadataTestReceiver,omitempty"`
	ZigzagJoiner            *ZigzagJoinerSpec            `protobuf:"bytes,21,opt,name=zigzagJoiner" json:"zigzagJoiner,omitempty"`
	ProjectSet              *ProjectSetSpec              `protobuf:"bytes,22,opt,name=projectSet" json:"projectSet,omitempty"`
	Windower                *WindowerSpec                `protobuf:"bytes,23,opt,name=windower" json:"windower,omitempty"`
	LocalPlanNode           *LocalPlanNodeSpec           `protobuf:"bytes,24,opt,name=localPlanNode" json:"localPlanNode,omitempty"`
	ChangeAggregator        *ChangeAggregatorSpec        `protobuf:"bytes,25,opt,name=changeAggregator" json:"changeAggregator,omitempty"`
	ChangeFrontier          *ChangeFrontierSpec          `protobuf:"bytes,26,opt,name=changeFrontier" json:"changeFrontier,omitempty"`
}

func (m *ProcessorCoreUnion) Reset()                    { *m = ProcessorCoreUnion{} }
func (m *ProcessorCoreUnion) String() string            { return proto.CompactTextString(m) }
func (*ProcessorCoreUnion) ProtoMessage()               {}
func (*ProcessorCoreUnion) Descriptor() ([]byte, []int) { return fileDescriptorProcessors, []int{2} }

// NoopCoreSpec indicates a "no-op" processor core. This is used when we just
// need post-processing or when only a synchronizer is required (e.g. at the
// final endpoint).
type NoopCoreSpec struct {
}

func (m *NoopCoreSpec) Reset()                    { *m = NoopCoreSpec{} }
func (m *NoopCoreSpec) String() string            { return proto.CompactTextString(m) }
func (*NoopCoreSpec) ProtoMessage()               {}
func (*NoopCoreSpec) Descriptor() ([]byte, []int) { return fileDescriptorProcessors, []int{3} }

type MetadataTestSenderSpec struct {
	ID string `protobuf:"bytes,1,opt,name=id" json:"id"`
}

func (m *MetadataTestSenderSpec) Reset()                    { *m = MetadataTestSenderSpec{} }
func (m *MetadataTestSenderSpec) String() string            { return proto.CompactTextString(m) }
func (*MetadataTestSenderSpec) ProtoMessage()               {}
func (*MetadataTestSenderSpec) Descriptor() ([]byte, []int) { return fileDescriptorProcessors, []int{4} }

type MetadataTestReceiverSpec struct {
	SenderIDs []string `protobuf:"bytes,1,rep,name=sender_ids,json=senderIds" json:"sender_ids,omitempty"`
}

func (m *MetadataTestReceiverSpec) Reset()         { *m = MetadataTestReceiverSpec{} }
func (m *MetadataTestReceiverSpec) String() string { return proto.CompactTextString(m) }
func (*MetadataTestReceiverSpec) ProtoMessage()    {}
func (*MetadataTestReceiverSpec) Descriptor() ([]byte, []int) {
	return fileDescriptorProcessors, []int{5}
}

// ValuesCoreSpec is the core of a processor that has no inputs and generates
// "pre-canned" rows. This is not intended to be used for very large datasets.
type ValuesCoreSpec struct {
	// There is one DatumInfo for each element in a row. Can be empty, in which
	// case raw_bytes must be empty.
	Columns []DatumInfo `protobuf:"bytes,1,rep,name=columns" json:"columns"`
	// The number of rows is especially useful when we have zero columns.
	NumRows uint64 `protobuf:"varint,3,opt,name=num_rows,json=numRows" json:"num_rows"`
	// Each raw block encodes one or more data rows; each datum is encoded
	// according to the corresponding DatumInfo.
	RawBytes [][]byte `protobuf:"bytes,2,rep,name=raw_bytes,json=rawBytes" json:"raw_bytes,omitempty"`
}

func (m *ValuesCoreSpec) Reset()                    { *m = ValuesCoreSpec{} }
func (m *ValuesCoreSpec) String() string            { return proto.CompactTextString(m) }
func (*ValuesCoreSpec) ProtoMessage()               {}
func (*ValuesCoreSpec) Descriptor() ([]byte, []int) { return fileDescriptorProcessors, []int{6} }

type TableReaderSpan struct {
	// TODO(radu): the dist_sql APIs should be agnostic to how we map tables to
	// KVs. The span should be described as starting and ending lists of values
	// for a prefix of the index columns, along with inclusive/exclusive flags.
	Span cockroach_roachpb1.Span `protobuf:"bytes,1,opt,name=span" json:"span"`
}

func (m *TableReaderSpan) Reset()                    { *m = TableReaderSpan{} }
func (m *TableReaderSpan) String() string            { return proto.CompactTextString(m) }
func (*TableReaderSpan) ProtoMessage()               {}
func (*TableReaderSpan) Descriptor() ([]byte, []int) { return fileDescriptorProcessors, []int{7} }

// TableReaderSpec is the specification for a "table reader". A table reader
// performs KV operations to retrieve rows for a table and outputs the desired
// columns of the rows that pass a filter expression.
//
// The "internal columns" of a TableReader (see ProcessorSpec) are all the
// columns of the table. Internally, only the values for the columns needed by
// the post-processing stage are to be populated. If is_check is set, the
// TableReader will run additional data checking procedures and the
// "internal columns" are:
//  - Error type (string).
//  - Primary key as a string, if it was obtainable.
//  - JSON of all decoded column values.
type TableReaderSpec struct {
	Table cockroach_sql_sqlbase1.TableDescriptor `protobuf:"bytes,1,opt,name=table" json:"table"`
	// If 0, we use the primary index. If non-zero, we use the index_idx-th index,
	// i.e. table.indexes[index_idx-1]
	IndexIdx uint32            `protobuf:"varint,2,opt,name=index_idx,json=indexIdx" json:"index_idx"`
	Reverse  bool              `protobuf:"varint,3,opt,name=reverse" json:"reverse"`
	Spans    []TableReaderSpan `protobuf:"bytes,4,rep,name=spans" json:"spans"`
	// A hint for how many rows the consumer of the table reader output might
	// need. This is used to size the initial KV batches to try to avoid reading
	// many more rows than needed by the processor receiving the output.
	//
	// Not used if there is a limit set in the PostProcessSpec of this processor
	// (that value will be used for sizing batches instead).
	LimitHint int64 `protobuf:"varint,5,opt,name=limit_hint,json=limitHint" json:"limit_hint"`
	// Indicates whether the TableReader is being run as an exhaustive
	// check. This is only true during SCRUB commands.
	IsCheck bool `protobuf:"varint,6,opt,name=is_check,json=isCheck" json:"is_check"`
	// Indicates the visibility level of the columns that should be returned.
	// Normally, will be set to public. Will be set to publicAndNotPublic if the
	// consumer of this TableReader expects to be able to see in-progress schema
	// changes.
	Visibility ScanVisibility `protobuf:"varint,7,opt,name=visibility,enum=cockroach.sql.distsqlrun.ScanVisibility" json:"visibility"`
}

func (m *TableReaderSpec) Reset()                    { *m = TableReaderSpec{} }
func (m *TableReaderSpec) String() string            { return proto.CompactTextString(m) }
func (*TableReaderSpec) ProtoMessage()               {}
func (*TableReaderSpec) Descriptor() ([]byte, []int) { return fileDescriptorProcessors, []int{8} }

// JoinReaderSpec is the specification for a "join reader". A join reader
// performs KV operations to retrieve specific rows that correspond to the
// values in the input stream (join by lookup). The output always preserves the
// order of the input rows.
//
// The "internal columns" of a JoinReader (see ProcessorSpec) are either the
// columns of the table or the concatenation of the columns of the input stream
// with the table columns, depending on the lookup columns specified.
// Internally, only the values for the columns needed by the post-processing
// stage are be populated.
//
// Example:
// Input stream columns: | a | b |              Table columns: | c | d | e |
//
// If performing a lookup join on a = c (lookup columns is [0]):
//        Internal columns: | a | b | c | d | e |
//
// If performing an index join (where a = c and b = d) (lookup columns is []):
//        Internal columns: | c | d | e |
type JoinReaderSpec struct {
	Table cockroach_sql_sqlbase1.TableDescriptor `protobuf:"bytes,1,opt,name=table" json:"table"`
	// If 0, we use the primary index; each row in the input stream has a value
	// for each primary key.
	// TODO(radu): figure out the correct semantics when joining with an index.
	IndexIdx uint32 `protobuf:"varint,2,opt,name=index_idx,json=indexIdx" json:"index_idx"`
	// Column indexes in the input stream specifying the columns which match with
	// the index columns. These are the equality columns of the join.
	// If empty (index join), the start of the input stream schema is assumed to
	// match the index columns. The joinReader will perform an index join and the
	// "internal columns" will be the columns of the table.
	// If populated (lookup join), the `joinReader` will perform a lookup join
	// and the "internal columns" will be the concatenation of the input stream
	// columns followed by the table columns.
	LookupColumns []uint32 `protobuf:"varint,3,rep,packed,name=lookup_columns,json=lookupColumns" json:"lookup_columns,omitempty"`
	// "ON" expression (in addition to the equality constraints captured by the
	// orderings). Assuming that the left stream has N columns and the right
	// stream has M columns, in this expression variables @1 to @N refer to
	// columns of the left stream and variables @N to @(N+M) refer to columns in
	// the right stream.
	// Having "ON" expression implies no merged columns.
	OnExpr Expression `protobuf:"bytes,4,opt,name=on_expr,json=onExpr" json:"on_expr"`
	// For lookup joins. Filter expression to be applied to index rows before
	// joining to the input.
	IndexFilterExpr Expression `protobuf:"bytes,5,opt,name=index_filter_expr,json=indexFilterExpr" json:"index_filter_expr"`
	// For lookup joins. Only JoinType_INNER and JoinType_LEFT_OUTER are
	// supported.
	Type cockroach_sql_sqlbase3.JoinType `protobuf:"varint,6,opt,name=type,enum=cockroach.sql.sqlbase.JoinType" json:"type"`
	// For index joins that are sources to mutation statements - what visibility
	// of columns should we return? Mutations sometimes need to see in-progress
	// schema change columns, in which case this field will be changed from its
	// default PUBLIC state. Causes the index join to return these schema change
	// columns.
	Visibility ScanVisibility `protobuf:"varint,7,opt,name=visibility,enum=cockroach.sql.distsqlrun.ScanVisibility" json:"visibility"`
}

func (m *JoinReaderSpec) Reset()                    { *m = JoinReaderSpec{} }
func (m *JoinReaderSpec) String() string            { return proto.CompactTextString(m) }
func (*JoinReaderSpec) ProtoMessage()               {}
func (*JoinReaderSpec) Descriptor() ([]byte, []int) { return fileDescriptorProcessors, []int{9} }

// SorterSpec is the specification for a "sorting aggregator". A sorting
// processor sorts elements in the input stream providing a certain output
// order guarantee regardless of the input ordering. The output ordering is
// according to a configurable set of columns.
//
// The "internal columns" of a Sorter (see ProcessorSpec) are the same as the
// input columns.
type SorterSpec struct {
	OutputOrdering Ordering `protobuf:"bytes,1,opt,name=output_ordering,json=outputOrdering" json:"output_ordering"`
	// Ordering match length, specifying that the input is already sorted by the
	// first 'n' output ordering columns, can be optionally specified for
	// possible speed-ups taking advantage of the partial orderings.
	OrderingMatchLen uint32 `protobuf:"varint,2,opt,name=ordering_match_len,json=orderingMatchLen" json:"ordering_match_len"`
}

func (m *SorterSpec) Reset()                    { *m = SorterSpec{} }
func (m *SorterSpec) String() string            { return proto.CompactTextString(m) }
func (*SorterSpec) ProtoMessage()               {}
func (*SorterSpec) Descriptor() ([]byte, []int) { return fileDescriptorProcessors, []int{10} }

type DistinctSpec struct {
	// The ordered columns in the input stream can be optionally specified for
	// possible optimizations. The specific ordering (ascending/descending) of
	// the column itself is not important nor is the order in which the columns
	// are specified. The ordered columns must be a subset of the distinct
	// columns.
	OrderedColumns []uint32 `protobuf:"varint,1,rep,name=ordered_columns,json=orderedColumns" json:"ordered_columns,omitempty"`
	// The distinct columns in the input stream are those columns on which we
	// check for distinct rows. If A,B,C are in distinct_columns and there is a
	// 4th column D which is not included in distinct_columns, its values are not
	// considered, so rows A1,B1,C1,D1 and A1,B1,C1,D2 are considered equal and
	// only one of them (the first) is output.
	DistinctColumns []uint32 `protobuf:"varint,2,rep,name=distinct_columns,json=distinctColumns" json:"distinct_columns,omitempty"`
}

func (m *DistinctSpec) Reset()                    { *m = DistinctSpec{} }
func (m *DistinctSpec) String() string            { return proto.CompactTextString(m) }
func (*DistinctSpec) ProtoMessage()               {}
func (*DistinctSpec) Descriptor() ([]byte, []int) { return fileDescriptorProcessors, []int{11} }

// ZigzagJoinerSpec is the specification for a zigzag join processor. The
// processor's current implementation fetches the rows using internal
// rowFetchers.
//
// The "internal columns" of a ZigzagJoiner (see ProcessorSpec) are the
// concatenation of all of the columns of the tables specified. The columns
// are populated if they are contained in the index specified for that table.
type ZigzagJoinerSpec struct {
	// TODO(pbardea): Replace these with inputs that conform to a RowSource-like
	// interface.
	Tables []cockroach_sql_sqlbase1.TableDescriptor `protobuf:"bytes,1,rep,name=tables" json:"tables"`
	// An array of arrays. The array at eq_columns[side_idx] contains the
	// equality columns for that side. All arrays in eq_columns should have
	// equal length.
	EqColumns []Columns `protobuf:"bytes,2,rep,name=eq_columns,json=eqColumns" json:"eq_columns"`
	IndexIds  []uint32  `protobuf:"varint,3,rep,packed,name=index_ids,json=indexIds" json:"index_ids,omitempty"`
	// "ON" expression (in addition to the equality constraints captured by the
	// orderings). Assuming that the left stream has N columns and the right
	// stream has M columns, in this expression ordinal references @1 to @N refer
	// to columns of the left stream and variables @(N+1) to @(N+M) refer to
	// columns in the right stream.
	OnExpr Expression                      `protobuf:"bytes,4,opt,name=on_expr,json=onExpr" json:"on_expr"`
	Type   cockroach_sql_sqlbase3.JoinType `protobuf:"varint,5,opt,name=type,enum=cockroach.sql.sqlbase.JoinType" json:"type"`
}

func (m *ZigzagJoinerSpec) Reset()                    { *m = ZigzagJoinerSpec{} }
func (m *ZigzagJoinerSpec) String() string            { return proto.CompactTextString(m) }
func (*ZigzagJoinerSpec) ProtoMessage()               {}
func (*ZigzagJoinerSpec) Descriptor() ([]byte, []int) { return fileDescriptorProcessors, []int{12} }

// LocalPlanNodeSpec is the specification for a local planNode wrapping
// processor. It's created for situations where a planNode has no DistSQL
// processor equivalent, and constrains the plan to live on the gateway node.
// This spec contains just an index, which is used by the execution engine to
// find the planNode instance this processor is executing in an array of local
// planNodes. See LocalProcessors and LocalProcessorIndexes on
// distsqlplan.PhysicalPlan.
type LocalPlanNodeSpec struct {
	RowSourceIdx *uint32 `protobuf:"varint,1,opt,name=RowSourceIdx" json:"RowSourceIdx,omitempty"`
	NumInputs    *uint32 `protobuf:"varint,2,opt,name=NumInputs" json:"NumInputs,omitempty"`
	Name         *string `protobuf:"bytes,3,opt,name=Name" json:"Name,omitempty"`
}

func (m *LocalPlanNodeSpec) Reset()                    { *m = LocalPlanNodeSpec{} }
func (m *LocalPlanNodeSpec) String() string            { return proto.CompactTextString(m) }
func (*LocalPlanNodeSpec) ProtoMessage()               {}
func (*LocalPlanNodeSpec) Descriptor() ([]byte, []int) { return fileDescriptorProcessors, []int{13} }

type Columns struct {
	Columns []uint32 `protobuf:"varint,1,rep,packed,name=columns" json:"columns,omitempty"`
}

func (m *Columns) Reset()                    { *m = Columns{} }
func (m *Columns) String() string            { return proto.CompactTextString(m) }
func (*Columns) ProtoMessage()               {}
func (*Columns) Descriptor() ([]byte, []int) { return fileDescriptorProcessors, []int{14} }

// MergeJoinerSpec is the specification for a merge join processor. The processor
// has two inputs and one output. The inputs must have the same ordering on the
// columns that have equality constraints. For example:
//   SELECT * FROM T1 INNER JOIN T2 ON T1.C1 = T2.C5 AND T1.C2 = T2.C4
//
// To perform a merge join, the streams corresponding to T1 and T2 must have the
// same ordering on columns C1, C2 and C5, C4 respectively. For example: C1+,C2-
// and C5+,C4-.
//
// The "internal columns" of a MergeJoiner (see ProcessorSpec) are the
// concatenation of left input columns and right input columns. If the left
// input has N columns and the right input has M columns, the first N columns
// contain values from the left side and the following M columns contain values
// from the right side.
//
// In the case of semi-join and anti-join, the processor core outputs only the
// left columns.
type MergeJoinerSpec struct {
	// The streams must be ordered according to the columns that have equality
	// constraints. The first column of the left ordering is constrained to be
	// equal to the first column in the right ordering and so on. The ordering
	// lengths and directions must match.
	// In the example above, left ordering describes C1+,C2- and right ordering
	// describes C5+,C4-.
	LeftOrdering  Ordering `protobuf:"bytes,1,opt,name=left_ordering,json=leftOrdering" json:"left_ordering"`
	RightOrdering Ordering `protobuf:"bytes,2,opt,name=right_ordering,json=rightOrdering" json:"right_ordering"`
	// "ON" expression (in addition to the equality constraints captured by the
	// orderings). Assuming that the left stream has N columns and the right
	// stream has M columns, in this expression ordinal references @1 to @N refer
	// to columns of the left stream and variables @(N+1) to @(N+M) refer to
	// columns in the right stream.
	OnExpr Expression                      `protobuf:"bytes,5,opt,name=on_expr,json=onExpr" json:"on_expr"`
	Type   cockroach_sql_sqlbase3.JoinType `protobuf:"varint,6,opt,name=type,enum=cockroach.sql.sqlbase.JoinType" json:"type"`
	// NullEquality indicates that NULL = NULL should be considered true.
	// This allows OUTER JOINs to consider NULL values meaningfully. An
	// example of this is during SCRUB checks on secondary indexes.
	NullEquality bool `protobuf:"varint,7,opt,name=null_equality,json=nullEquality" json:"null_equality"`
}

func (m *MergeJoinerSpec) Reset()                    { *m = MergeJoinerSpec{} }
func (m *MergeJoinerSpec) String() string            { return proto.CompactTextString(m) }
func (*MergeJoinerSpec) ProtoMessage()               {}
func (*MergeJoinerSpec) Descriptor() ([]byte, []int) { return fileDescriptorProcessors, []int{15} }

// HashJoinerSpec is the specification for a hash join processor. The processor
// has two inputs and one output.
//
// The processor works by reading the entire right input and putting it in a hash
// table. Thus, there is no guarantee on the ordering of results that stem only
// from the right input (in the case of RIGHT_OUTER, FULL_OUTER). However, it is
// guaranteed that results that involve the left stream preserve the ordering;
// i.e. all results that stem from left row (i) precede results that stem from
// left row (i+1).
//
// The "internal columns" of a HashJoiner (see ProcessorSpec) are the
// concatenation of merged columns (if present), left input columns and right
// input columns. Each merged column corresponds to a left and a right equality
// column; its value is the value on the left if it is not NULL, otherwise it is
// the value on the right. There are either zero or
// E=len(left_eq_columns)=len(right_eq_columns) merged columns.
//
// If the left input has N columns and the right input has M columns, the
// first N columns contain values from the left side and the following M columns
// contain values from the right side. If merged columns are present, they
// occupy first E positions followed by N values from the left side and M values
// from the right side.
//
// In the case of semi-join and anti-join, the processor core outputs only the
// left columns.
type HashJoinerSpec struct {
	// The join constraints certain columns from the left stream to equal
	// corresponding columns on the right stream. These must have the same length.
	LeftEqColumns  []uint32 `protobuf:"varint,1,rep,packed,name=left_eq_columns,json=leftEqColumns" json:"left_eq_columns,omitempty"`
	RightEqColumns []uint32 `protobuf:"varint,2,rep,packed,name=right_eq_columns,json=rightEqColumns" json:"right_eq_columns,omitempty"`
	// "ON" expression (in addition to the equality constraints captured by the
	// orderings). Assuming that the left stream has N columns and the right
	// stream has M columns, in this expression variables @1 to @N refer to
	// columns of the left stream and variables @N to @(N+M) refer to columns in
	// the right stream.
	// Having "ON" expression implies no merged columns.
	OnExpr Expression                      `protobuf:"bytes,5,opt,name=on_expr,json=onExpr" json:"on_expr"`
	Type   cockroach_sql_sqlbase3.JoinType `protobuf:"varint,6,opt,name=type,enum=cockroach.sql.sqlbase.JoinType" json:"type"`
	// DEPRECATED
	//
	// Extra merged columns that are added in case of OUTER JOINS. These
	// columns occupy first positions in a row amd it's the left value if it's not
	// NULL, otherwise it's the right value. In INNER JOIN case no merged columns are
	// needed since left stream values are guaranteed to be not NULL.
	//
	// This has been deprecated; the distsqlrun layer still supports it for
	// backward compatibility during upgrade.
	MergedColumns bool `protobuf:"varint,7,opt,name=merged_columns,json=mergedColumns" json:"merged_columns"`
}

func (m *HashJoinerSpec) Reset()                    { *m = HashJoinerSpec{} }
func (m *HashJoinerSpec) String() string            { return proto.CompactTextString(m) }
func (*HashJoinerSpec) ProtoMessage()               {}
func (*HashJoinerSpec) Descriptor() ([]byte, []int) { return fileDescriptorProcessors, []int{16} }

// AggregatorSpec is the specification for an "aggregator" (processor core
// type, not the logical plan computation stage). An aggregator performs
// 'aggregation' in the SQL sense in that it groups rows and computes an aggregate
// for each group. The group is configured using the group key. The aggregator
// can be configured with one or more aggregation functions.
//
// The "internal columns" of an Aggregator map 1-1 to the aggregations.
type AggregatorSpec struct {
	Type AggregatorSpec_Type `protobuf:"varint,5,opt,name=type,enum=cockroach.sql.distsqlrun.AggregatorSpec_Type" json:"type"`
	// The group key is a subset of the columns in the input stream schema on the
	// basis of which we define our groups.
	GroupCols    []uint32                     `protobuf:"varint,2,rep,packed,name=group_cols,json=groupCols" json:"group_cols,omitempty"`
	Aggregations []AggregatorSpec_Aggregation `protobuf:"bytes,3,rep,name=aggregations" json:"aggregations"`
	// A subset of the GROUP BY columns which are ordered in the input.
	OrderedGroupCols []uint32 `protobuf:"varint,4,rep,packed,name=ordered_group_cols,json=orderedGroupCols" json:"ordered_group_cols,omitempty"`
}

func (m *AggregatorSpec) Reset()                    { *m = AggregatorSpec{} }
func (m *AggregatorSpec) String() string            { return proto.CompactTextString(m) }
func (*AggregatorSpec) ProtoMessage()               {}
func (*AggregatorSpec) Descriptor() ([]byte, []int) { return fileDescriptorProcessors, []int{17} }

type AggregatorSpec_Aggregation struct {
	Func AggregatorSpec_Func `protobuf:"varint,1,opt,name=func,enum=cockroach.sql.distsqlrun.AggregatorSpec_Func" json:"func"`
	// Aggregation functions with distinct = true functions like you would
	// expect '<FUNC> DISTINCT' to operate, the default behavior would be
	// the '<FUNC> ALL' operation.
	Distinct bool `protobuf:"varint,2,opt,name=distinct" json:"distinct"`
	// The column index specifies the argument(s) to the aggregator function.
	//
	// Most aggregations take one argument
	// COUNT_ROWS takes no arguments.
	// FINAL_STDDEV and FINAL_VARIANCE take three arguments (SQRDIFF, SUM,
	// COUNT).
	ColIdx []uint32 `protobuf:"varint,5,rep,name=col_idx,json=colIdx" json:"col_idx,omitempty"`
	// If set, this column index specifies a boolean argument; rows for which
	// this value is not true don't contribute to this aggregation. This enables
	// the filter clause, e.g.:
	//   SELECT SUM(x) FILTER (WHERE y > 1), SUM(x) FILTER (WHERE y < 1) FROM t
	FilterColIdx *uint32 `protobuf:"varint,4,opt,name=filter_col_idx,json=filterColIdx" json:"filter_col_idx,omitempty"`
	// Arguments are const expressions passed to aggregation functions.
	Arguments []Expression `protobuf:"bytes,6,rep,name=arguments" json:"arguments"`
}

func (m *AggregatorSpec_Aggregation) Reset()         { *m = AggregatorSpec_Aggregation{} }
func (m *AggregatorSpec_Aggregation) String() string { return proto.CompactTextString(m) }
func (*AggregatorSpec_Aggregation) ProtoMessage()    {}
func (*AggregatorSpec_Aggregation) Descriptor() ([]byte, []int) {
	return fileDescriptorProcessors, []int{17, 0}
}

// BackfillerSpec is the specification for a "schema change backfiller".
// The created backfill processor runs a backfill for the first mutations in
// the table descriptor mutation list with the same mutation id and type.
// A backfiller processor performs KV operations to retrieve rows for a
// table and backfills the new indexes/columns contained in the table
// descriptor. It checkpoints its progress by updating the table
// descriptor in the database, and doesn't emit any rows nor support
// any post-processing.
type BackfillerSpec struct {
	Type  BackfillerSpec_Type                    `protobuf:"varint,1,opt,name=type,enum=cockroach.sql.distsqlrun.BackfillerSpec_Type" json:"type"`
	Table cockroach_sql_sqlbase1.TableDescriptor `protobuf:"bytes,2,opt,name=table" json:"table"`
	// Sections of the table to be backfilled.
	Spans []TableReaderSpan `protobuf:"bytes,3,rep,name=spans" json:"spans"`
	// Run the backfill for approximately this duration.
	// The backfill will always process at least one backfill chunk.
	Duration time.Duration `protobuf:"varint,4,opt,name=duration,casttype=time.Duration" json:"duration"`
	// The backfill involves a complete table scan in chunks,
	// where each chunk is a transactional read of a set of rows
	// along with a backfill for the rows. This is the maximum number
	// of entries backfilled per chunk.
	ChunkSize int64 `protobuf:"varint,5,opt,name=chunk_size,json=chunkSize" json:"chunk_size"`
	// Any other (leased) table descriptors necessary for the
	// backfiller to do its job, such as the descriptors for tables with fk
	// relationships to the table being modified.
	OtherTables []cockroach_sql_sqlbase1.TableDescriptor `protobuf:"bytes,6,rep,name=other_tables,json=otherTables" json:"other_tables"`
	// The timestamp to perform index backfill historical scans at.
	ReadAsOf cockroach_util_hlc.Timestamp `protobuf:"bytes,7,opt,name=readAsOf" json:"readAsOf"`
}

func (m *BackfillerSpec) Reset()                    { *m = BackfillerSpec{} }
func (m *BackfillerSpec) String() string            { return proto.CompactTextString(m) }
func (*BackfillerSpec) ProtoMessage()               {}
func (*BackfillerSpec) Descriptor() ([]byte, []int) { return fileDescriptorProcessors, []int{18} }

// FlowSpec describes a "flow" which is a subgraph of a distributed SQL
// computation consisting of processors and streams.
type FlowSpec struct {
	FlowID FlowID `protobuf:"bytes,1,opt,name=flow_id,json=flowId,customtype=FlowID" json:"flow_id"`
	// The NodeID of the gateway that planned this Flow. Used for debugging.
	Gateway    github_com_cockroachdb_cockroach_pkg_roachpb.NodeID `protobuf:"varint,3,opt,name=gateway,casttype=github.com/cockroachdb/cockroach/pkg/roachpb.NodeID" json:"gateway"`
	Processors []ProcessorSpec                                     `protobuf:"bytes,2,rep,name=processors" json:"processors"`
}

func (m *FlowSpec) Reset()                    { *m = FlowSpec{} }
func (m *FlowSpec) String() string            { return proto.CompactTextString(m) }
func (*FlowSpec) ProtoMessage()               {}
func (*FlowSpec) Descriptor() ([]byte, []int) { return fileDescriptorProcessors, []int{19} }

// JobProgress identifies the job to report progress on. This reporting
// happens outside this package.
type JobProgress struct {
	JobID int64 `protobuf:"varint,1,opt,name=job_id,json=jobId" json:"job_id"`
	// contribution is the percent of work of the total this processor will
	// process.
	Contribution float32 `protobuf:"fixed32,2,opt,name=contribution" json:"contribution"`
	// slot is the index into the job details for this processor's completion.
	Slot int32 `protobuf:"varint,3,opt,name=slot" json:"slot"`
}

func (m *JobProgress) Reset()                    { *m = JobProgress{} }
func (m *JobProgress) String() string            { return proto.CompactTextString(m) }
func (*JobProgress) ProtoMessage()               {}
func (*JobProgress) Descriptor() ([]byte, []int) { return fileDescriptorProcessors, []int{20} }

type ReadImportDataSpec struct {
	Format cockroach_roachpb4.IOFileFormat `protobuf:"bytes,8,opt,name=format" json:"format"`
	// sample_size is the rate at which to output rows, based on an input row's size.
	SampleSize int32 `protobuf:"varint,2,opt,name=sample_size,json=sampleSize" json:"sample_size"`
	// tables is an alternative to table_desc for input formats that can read
	// multiple tables. If it is non-empty, the keys specify the names of tables
	// for which the processor should read and emit data (ignoring data for any
	// other tables that is present in the input).
	//
	// TODO(dt): If a key has a nil value, the schema for that table should be
	// determined from the input on-the-fly (e.g. by parsing a CREATE TABLE in a
	// dump file) and the processor should emit a key/value for the generated
	// TableDescriptor with the corresponding descriptor ID key. If tables is
	// empty (and table_desc above is not specified), the processor should read
	// all tables in the input, determining their schemas on the fly.
	Tables map[string]*cockroach_sql_sqlbase1.TableDescriptor `protobuf:"bytes,9,rep,name=tables" json:"tables,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// uri is a storageccl.ExportStorage URI pointing to the CSV files to be
	// read. The map key must be unique across the entire IMPORT job.
	Uri                    map[int32]string `protobuf:"bytes,7,rep,name=uri" json:"uri,omitempty" protobuf_key:"varint,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	Progress               JobProgress      `protobuf:"bytes,6,opt,name=progress" json:"progress"`
	SkipMissingForeignKeys bool             `protobuf:"varint,10,opt,name=skip_missing_foreign_keys,json=skipMissingForeignKeys" json:"skip_missing_foreign_keys"`
}

func (m *ReadImportDataSpec) Reset()                    { *m = ReadImportDataSpec{} }
func (m *ReadImportDataSpec) String() string            { return proto.CompactTextString(m) }
func (*ReadImportDataSpec) ProtoMessage()               {}
func (*ReadImportDataSpec) Descriptor() ([]byte, []int) { return fileDescriptorProcessors, []int{21} }

// SSTWriterSpec is the specification for a processor that consumes rows, uses
// tempStorage to sort them, then writes them to SST files at uri. walltime is
// used as the MVCC timestamp. It outputs one row per span containing the file
// name, size, checksum, observed start and end keys. See ccs/sqlccl/csv.go
// for implementation.
type SSTWriterSpec struct {
	// destination as a storageccl.ExportStorage URI pointing to an export store
	// location (directory).
	Destination string `protobuf:"bytes,1,opt,name=destination" json:"destination"`
	// walltimeNanos is the MVCC time at which the created KVs will be written.
	WalltimeNanos int64 `protobuf:"varint,3,opt,name=walltimeNanos" json:"walltimeNanos"`
	// spans is an array of span boundaries and corresponding filenames.
	Spans    []SSTWriterSpec_SpanName `protobuf:"bytes,4,rep,name=spans" json:"spans"`
	Progress JobProgress              `protobuf:"bytes,5,opt,name=progress" json:"progress"`
}

func (m *SSTWriterSpec) Reset()                    { *m = SSTWriterSpec{} }
func (m *SSTWriterSpec) String() string            { return proto.CompactTextString(m) }
func (*SSTWriterSpec) ProtoMessage()               {}
func (*SSTWriterSpec) Descriptor() ([]byte, []int) { return fileDescriptorProcessors, []int{22} }

type SSTWriterSpec_SpanName struct {
	// name is the file name that will be written by the export store.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name"`
	// end is the end key of a span.
	End []byte `protobuf:"bytes,2,opt,name=end" json:"end,omitempty"`
}

func (m *SSTWriterSpec_SpanName) Reset()         { *m = SSTWriterSpec_SpanName{} }
func (m *SSTWriterSpec_SpanName) String() string { return proto.CompactTextString(m) }
func (*SSTWriterSpec_SpanName) ProtoMessage()    {}
func (*SSTWriterSpec_SpanName) Descriptor() ([]byte, []int) {
	return fileDescriptorProcessors, []int{22, 0}
}

// CSVWriterSpec is the specification for a processor that consumes rows and
// writes them to CSV files at uri. It outputs a row per file written with
// the file name, row count and byte size.
type CSVWriterSpec struct {
	// destination as a storageccl.ExportStorage URI pointing to an export store
	// location (directory).
	Destination string                        `protobuf:"bytes,1,opt,name=destination" json:"destination"`
	NamePattern string                        `protobuf:"bytes,2,opt,name=name_pattern,json=namePattern" json:"name_pattern"`
	Options     cockroach_roachpb4.CSVOptions `protobuf:"bytes,3,opt,name=options" json:"options"`
	// chunk_rows is num rows to write per file. 0 = no limit.
	ChunkRows int64 `protobuf:"varint,4,opt,name=chunk_rows,json=chunkRows" json:"chunk_rows"`
}

func (m *CSVWriterSpec) Reset()                    { *m = CSVWriterSpec{} }
func (m *CSVWriterSpec) String() string            { return proto.CompactTextString(m) }
func (*CSVWriterSpec) ProtoMessage()               {}
func (*CSVWriterSpec) Descriptor() ([]byte, []int) { return fileDescriptorProcessors, []int{23} }

// SketchSpec contains the specification for a generated statistic.
type SketchSpec struct {
	SketchType SketchType `protobuf:"varint,1,opt,name=sketch_type,json=sketchType,enum=cockroach.sql.distsqlrun.SketchType" json:"sketch_type"`
	// Each value is an index identifying a column in the input stream.
	// TODO(radu): currently only one column is supported.
	Columns []uint32 `protobuf:"varint,2,rep,name=columns" json:"columns,omitempty"`
	// If set, we generate a histogram for the first column in the sketch.
	// Only used by the SampleAggregator.
	GenerateHistogram bool `protobuf:"varint,3,opt,name=generate_histogram,json=generateHistogram" json:"generate_histogram"`
	// Controls the maximum number of buckets in the histogram.
	// Only used by the SampleAggregator.
	HistogramMaxBuckets uint32 `protobuf:"varint,4,opt,name=histogram_max_buckets,json=histogramMaxBuckets" json:"histogram_max_buckets"`
	// Only used by the SampleAggregator.
	StatName string `protobuf:"bytes,5,opt,name=stat_name,json=statName" json:"stat_name"`
}

func (m *SketchSpec) Reset()                    { *m = SketchSpec{} }
func (m *SketchSpec) String() string            { return proto.CompactTextString(m) }
func (*SketchSpec) ProtoMessage()               {}
func (*SketchSpec) Descriptor() ([]byte, []int) { return fileDescriptorProcessors, []int{24} }

// SamplerSpec is the specification of a "sampler" processor which
// returns a sample (random subset) of the input columns and computes
// cardinality estimation sketches on sets of columns.
//
// The sampler is configured with a sample size and sets of columns
// for the sketches. It produces one row with global statistics, one
// row with sketch information for each sketch plus at most
// sample_size sampled rows.
//
// The following method is used to do reservoir sampling: we generate a
// "rank" for each row, which is just a random, uniformly distributed
// 64-bit value. The rows with the smallest <sample_size> ranks are selected.
// This method is chosen because it allows to combine sample sets very easily.
//
// The internal schema of the processor is formed of two column
// groups:
//   1. sampled row columns:
//       - columns that map 1-1 to the columns in the input (same
//         schema as the input).
//       - an INT column with the "rank" of the row; this is a random value
//         associated with the row (necessary for combining sample sets).
//   2. sketch columns:
//       - an INT column indicating the sketch index
//         (0 to len(sketches) - 1).
//       - an INT column indicating the number of rows processed
//       - an INT column indicating the number of NULL values
//         on the first column of the sketch.
//       - a BYTES column with the binary sketch data (format
//         dependent on the sketch type).
// Rows have NULLs on either all the sampled row columns or on all the
// sketch columns.
type SamplerSpec struct {
	Sketches   []SketchSpec `protobuf:"bytes,1,rep,name=sketches" json:"sketches"`
	SampleSize uint32       `protobuf:"varint,2,opt,name=sample_size,json=sampleSize" json:"sample_size"`
}

func (m *SamplerSpec) Reset()                    { *m = SamplerSpec{} }
func (m *SamplerSpec) String() string            { return proto.CompactTextString(m) }
func (*SamplerSpec) ProtoMessage()               {}
func (*SamplerSpec) Descriptor() ([]byte, []int) { return fileDescriptorProcessors, []int{25} }

// SampleAggregatorSpec is the specification of a processor that aggregates the
// results from multiple sampler processors and writes out the statistics to
// system.table_statistics.
//
// The input schema it expects matches the output schema of a sampler spec (see
// the comment for SamplerSpec for all the details):
//  1. sampled row columns:
//    - sampled columns
//    - row rank
//  2. sketch columns:
//    - sketch index
//    - number of rows processed
//    - number of NULL values encountered on the first column of the sketch
//    - binary sketch data
type SampleAggregatorSpec struct {
	Sketches []SketchSpec `protobuf:"bytes,1,rep,name=sketches" json:"sketches"`
	// The processor merges reservoir sample sets into a single
	// sample set of this size. This must match the sample size
	// used for each Sampler.
	SampleSize uint32 `protobuf:"varint,2,opt,name=sample_size,json=sampleSize" json:"sample_size"`
	// The i-th value indicates the ColumnID of the i-th sampled row column.
	// These are necessary for writing out the statistic data.
	SampledColumnIDs []github_com_cockroachdb_cockroach_pkg_sql_sqlbase.ColumnID `protobuf:"varint,3,rep,name=sampled_column_ids,json=sampledColumnIds,casttype=github.com/cockroachdb/cockroach/pkg/sql/sqlbase.ColumnID" json:"sampled_column_ids,omitempty"`
	TableID          github_com_cockroachdb_cockroach_pkg_sql_sqlbase.ID         `protobuf:"varint,4,opt,name=table_id,json=tableId,casttype=github.com/cockroachdb/cockroach/pkg/sql/sqlbase.ID" json:"table_id"`
}

func (m *SampleAggregatorSpec) Reset()                    { *m = SampleAggregatorSpec{} }
func (m *SampleAggregatorSpec) String() string            { return proto.CompactTextString(m) }
func (*SampleAggregatorSpec) ProtoMessage()               {}
func (*SampleAggregatorSpec) Descriptor() ([]byte, []int) { return fileDescriptorProcessors, []int{26} }

// InterleavedReaderJoinerSpec is the specification for a processor that performs
// KV operations to retrieve rows from 2+ tables from an interleaved hierarchy,
// performs intermediate filtering on rows from each table, and performs a
// join on the rows from the 2+ tables.
//
// Limitations: the InterleavedReaderJoiner currently supports only equality INNER joins
// on the full interleave prefix.
// See https://github.com/cockroachdb/cockroach/blob/master/docs/RFCS/20171025_interleaved_table_joins.md.
//
// The "internal columns" of an InterleavedReaderJoiner are the
// concatenation of left input columns and right input columns. If the left
// table has N columns and the right table has M columns, the first N columns
// contain values from the left table and the following M columns contain values
// from the right table.
type InterleavedReaderJoinerSpec struct {
	// For the common case of two tables, table at index 0 is the left/parent
	// table and table at index 1 is the right/child table.
	Tables  []InterleavedReaderJoinerSpec_Table `protobuf:"bytes,1,rep,name=tables" json:"tables"`
	Reverse bool                                `protobuf:"varint,2,opt,name=reverse" json:"reverse"`
	// A hint for how many joined rows from the tables the consumer of the
	// interleavedReaderJoiner might need. This is used to size the initial KV
	// batches to try to avoid reading many more rows than needed by the
	// processor receiving the output.
	// // Not used if there is a limit set in the PostProcessSpec of this processor // (that value will be used for sizing batches instead).
	LimitHint int64 `protobuf:"varint,3,opt,name=limit_hint,json=limitHint" json:"limit_hint"`
	// "ON" expression (in addition to the equality constraints captured by the
	// orderings). Assuming that the left table has N columns and the second
	// table stream has M columns, in this expression ordinal references @1 to @N
	// refer to columns of the left table and variables @(N+1) to @(N+M) refer to
	// columns in the right table.
	OnExpr Expression                      `protobuf:"bytes,4,opt,name=on_expr,json=onExpr" json:"on_expr"`
	Type   cockroach_sql_sqlbase3.JoinType `protobuf:"varint,5,opt,name=type,enum=cockroach.sql.sqlbase.JoinType" json:"type"`
}

func (m *InterleavedReaderJoinerSpec) Reset()         { *m = InterleavedReaderJoinerSpec{} }
func (m *InterleavedReaderJoinerSpec) String() string { return proto.CompactTextString(m) }
func (*InterleavedReaderJoinerSpec) ProtoMessage()    {}
func (*InterleavedReaderJoinerSpec) Descriptor() ([]byte, []int) {
	return fileDescriptorProcessors, []int{27}
}

type InterleavedReaderJoinerSpec_Table struct {
	Desc cockroach_sql_sqlbase1.TableDescriptor `protobuf:"bytes,1,opt,name=desc" json:"desc"`
	// If 0, we use the primary index. If non-zero, we use the index_idx-th index,
	// i.e. desc.indexes[index_idx-1]
	IndexIdx uint32 `protobuf:"varint,2,opt,name=index_idx,json=indexIdx" json:"index_idx"`
	// The PostProcessSpecs of the corresponding TableReaderSpecs of each table
	// are fed as arguments to InterleavedReaderJoiner.
	//
	// This is required to properly post-process the rows (i.e. filtering and
	// projections) after reading from the table but before joining.
	// It may be necessary to modify/introduce additional intermediate filters
	// for correctness (see comment above 'spans' under
	// InterleavedReaderJoinerSpec).
	Post PostProcessSpec `protobuf:"bytes,3,opt,name=post" json:"post"`
	// The tables must be ordered according to the columns that have equality
	// constraints. The first column of the first table's ordering is constrained
	// to be equal to the first column in the second table's ordering and so on
	// for the other tables and their corresponding columns.
	Ordering Ordering `protobuf:"bytes,4,opt,name=ordering" json:"ordering"`
	// The span covering the rows from this table to join. Note the
	// InterleavedReaderJoiner processor will taking the union of all spans across
	// all tables to do a single pass-through scan. InterleavedReaderJoiner will
	// then check if a given row for a table is within any of its spans.
	// There must exist at least one non-empty set of spans for some table.
	Spans []TableReaderSpan `protobuf:"bytes,5,rep,name=spans" json:"spans"`
}

func (m *InterleavedReaderJoinerSpec_Table) Reset()         { *m = InterleavedReaderJoinerSpec_Table{} }
func (m *InterleavedReaderJoinerSpec_Table) String() string { return proto.CompactTextString(m) }
func (*InterleavedReaderJoinerSpec_Table) ProtoMessage()    {}
func (*InterleavedReaderJoinerSpec_Table) Descriptor() ([]byte, []int) {
	return fileDescriptorProcessors, []int{27, 0}
}

// ProjectSetSpec is the specification of a processor which applies a set of
// expressions, which may be set-returning functions, to its input.
type ProjectSetSpec struct {
	// Expressions to be applied
	Exprs []Expression `protobuf:"bytes,1,rep,name=exprs" json:"exprs"`
	// Column types for the generated values
	GeneratedColumns []cockroach_sql_sqlbase1.ColumnType `protobuf:"bytes,2,rep,name=generated_columns,json=generatedColumns" json:"generated_columns"`
	// The number of columns each expression returns. Same length as exprs.
	NumColsPerGen []uint32 `protobuf:"varint,3,rep,name=num_cols_per_gen,json=numColsPerGen" json:"num_cols_per_gen,omitempty"`
}

func (m *ProjectSetSpec) Reset()                    { *m = ProjectSetSpec{} }
func (m *ProjectSetSpec) String() string            { return proto.CompactTextString(m) }
func (*ProjectSetSpec) ProtoMessage()               {}
func (*ProjectSetSpec) Descriptor() ([]byte, []int) { return fileDescriptorProcessors, []int{28} }

// WindowerSpec is the specification of a processor that performs computations
// of window functions that have the same PARTITION BY clause. For a particular
// windowFn, the processor puts result at windowFn.ArgIdxStart and "consumes"
// all arguments to windowFn (windowFn.ArgCount of them). So if windowFn takes
// no arguments, an extra column is added; if windowFn takes more than one
// argument, (windowFn.ArgCount - 1) columns are removed.
type WindowerSpec struct {
	// PartitionBy specifies how to partition rows for all window functions.
	PartitionBy []uint32 `protobuf:"varint,1,rep,name=partitionBy" json:"partitionBy,omitempty"`
	// WindowFns is the specification of all window functions to be computed.
	WindowFns []WindowerSpec_WindowFn `protobuf:"bytes,2,rep,name=windowFns" json:"windowFns"`
}

func (m *WindowerSpec) Reset()                    { *m = WindowerSpec{} }
func (m *WindowerSpec) String() string            { return proto.CompactTextString(m) }
func (*WindowerSpec) ProtoMessage()               {}
func (*WindowerSpec) Descriptor() ([]byte, []int) { return fileDescriptorProcessors, []int{29} }

// Func specifies which function to compute. It can either be built-in
// aggregate or built-in window function.
type WindowerSpec_Func struct {
	AggregateFunc *AggregatorSpec_Func     `protobuf:"varint,1,opt,name=aggregateFunc,enum=cockroach.sql.distsqlrun.AggregatorSpec_Func" json:"aggregateFunc,omitempty"`
	WindowFunc    *WindowerSpec_WindowFunc `protobuf:"varint,2,opt,name=windowFunc,enum=cockroach.sql.distsqlrun.WindowerSpec_WindowFunc" json:"windowFunc,omitempty"`
}

func (m *WindowerSpec_Func) Reset()                    { *m = WindowerSpec_Func{} }
func (m *WindowerSpec_Func) String() string            { return proto.CompactTextString(m) }
func (*WindowerSpec_Func) ProtoMessage()               {}
func (*WindowerSpec_Func) Descriptor() ([]byte, []int) { return fileDescriptorProcessors, []int{29, 0} }

// Frame is the specification of a single window frame for a window function.
type WindowerSpec_Frame struct {
	Mode   WindowerSpec_Frame_Mode   `protobuf:"varint,1,opt,name=mode,enum=cockroach.sql.distsqlrun.WindowerSpec_Frame_Mode" json:"mode"`
	Bounds WindowerSpec_Frame_Bounds `protobuf:"bytes,2,opt,name=bounds" json:"bounds"`
}

func (m *WindowerSpec_Frame) Reset()                    { *m = WindowerSpec_Frame{} }
func (m *WindowerSpec_Frame) String() string            { return proto.CompactTextString(m) }
func (*WindowerSpec_Frame) ProtoMessage()               {}
func (*WindowerSpec_Frame) Descriptor() ([]byte, []int) { return fileDescriptorProcessors, []int{29, 1} }

// Bound specifies the type of boundary and the offset (if present).
type WindowerSpec_Frame_Bound struct {
	BoundType WindowerSpec_Frame_BoundType `protobuf:"varint,1,opt,name=boundType,enum=cockroach.sql.distsqlrun.WindowerSpec_Frame_BoundType" json:"boundType"`
	// For UNBOUNDED_PRECEDING, UNBOUNDED_FOLLOWING, and CURRENT_ROW offset
	// is ignored. Integer offset for ROWS mode is stored in int_offset while
	// an encoded datum and the type information are stored for RANGE mode.
	IntOffset   uint32    `protobuf:"varint,2,opt,name=int_offset,json=intOffset" json:"int_offset"`
	TypedOffset []byte    `protobuf:"bytes,3,opt,name=typed_offset,json=typedOffset" json:"typed_offset,omitempty"`
	OffsetType  DatumInfo `protobuf:"bytes,4,opt,name=offset_type,json=offsetType" json:"offset_type"`
}

func (m *WindowerSpec_Frame_Bound) Reset()         { *m = WindowerSpec_Frame_Bound{} }
func (m *WindowerSpec_Frame_Bound) String() string { return proto.CompactTextString(m) }
func (*WindowerSpec_Frame_Bound) ProtoMessage()    {}
func (*WindowerSpec_Frame_Bound) Descriptor() ([]byte, []int) {
	return fileDescriptorProcessors, []int{29, 1, 0}
}

// Bounds specifies boundaries of the window frame.
type WindowerSpec_Frame_Bounds struct {
	// Start bound must always be present whereas end bound might be omitted.
	Start WindowerSpec_Frame_Bound  `protobuf:"bytes,1,opt,name=start" json:"start"`
	End   *WindowerSpec_Frame_Bound `protobuf:"bytes,2,opt,name=end" json:"end,omitempty"`
}

func (m *WindowerSpec_Frame_Bounds) Reset()         { *m = WindowerSpec_Frame_Bounds{} }
func (m *WindowerSpec_Frame_Bounds) String() string { return proto.CompactTextString(m) }
func (*WindowerSpec_Frame_Bounds) ProtoMessage()    {}
func (*WindowerSpec_Frame_Bounds) Descriptor() ([]byte, []int) {
	return fileDescriptorProcessors, []int{29, 1, 1}
}

// WindowFn is the specification of a single window function.
type WindowerSpec_WindowFn struct {
	// Func is which function to compute.
	Func WindowerSpec_Func `protobuf:"bytes,1,opt,name=func" json:"func"`
	// ArgIdxStart is which index arguments to this window function start at.
	ArgIdxStart uint32 `protobuf:"varint,2,opt,name=argIdxStart" json:"argIdxStart"`
	// ArgCount indicates how many arguments this window function takes in.
	ArgCount uint32 `protobuf:"varint,3,opt,name=argCount" json:"argCount"`
	// Ordering specifies in which order rows should be considered by this
	// window function. Its contents come from ORDER BY clause of the window
	// function.
	Ordering Ordering `protobuf:"bytes,4,opt,name=ordering" json:"ordering"`
	// Frame specifies over which frame this window function is computed.
	Frame *WindowerSpec_Frame `protobuf:"bytes,5,opt,name=frame" json:"frame,omitempty"`
	// Optional index of a column over which filtering of rows will be done.
	// Special value -1 indicates that filter is not present.
	FilterColIdx int32 `protobuf:"varint,6,opt,name=filterColIdx" json:"filterColIdx"`
}

func (m *WindowerSpec_WindowFn) Reset()         { *m = WindowerSpec_WindowFn{} }
func (m *WindowerSpec_WindowFn) String() string { return proto.CompactTextString(m) }
func (*WindowerSpec_WindowFn) ProtoMessage()    {}
func (*WindowerSpec_WindowFn) Descriptor() ([]byte, []int) {
	return fileDescriptorProcessors, []int{29, 2}
}

// ChangeAggregatorSpec is the specification for a processor that watches for
// changes in a set of spans. Each span may cross multiple ranges.
type ChangeAggregatorSpec struct {
	Watches []ChangeAggregatorSpec_Watch `protobuf:"bytes,1,rep,name=watches" json:"watches"`
	// Feed is the specification for this changefeed.
	Feed cockroach_sql_jobs_jobspb.ChangefeedDetails `protobuf:"bytes,2,opt,name=feed" json:"feed"`
}

func (m *ChangeAggregatorSpec) Reset()                    { *m = ChangeAggregatorSpec{} }
func (m *ChangeAggregatorSpec) String() string            { return proto.CompactTextString(m) }
func (*ChangeAggregatorSpec) ProtoMessage()               {}
func (*ChangeAggregatorSpec) Descriptor() ([]byte, []int) { return fileDescriptorProcessors, []int{30} }

type ChangeAggregatorSpec_Watch struct {
	InitialResolved cockroach_util_hlc.Timestamp `protobuf:"bytes,1,opt,name=initial_resolved,json=initialResolved" json:"initial_resolved"`
	Span            cockroach_roachpb1.Span      `protobuf:"bytes,2,opt,name=span" json:"span"`
}

func (m *ChangeAggregatorSpec_Watch) Reset()         { *m = ChangeAggregatorSpec_Watch{} }
func (m *ChangeAggregatorSpec_Watch) String() string { return proto.CompactTextString(m) }
func (*ChangeAggregatorSpec_Watch) ProtoMessage()    {}
func (*ChangeAggregatorSpec_Watch) Descriptor() ([]byte, []int) {
	return fileDescriptorProcessors, []int{30, 0}
}

// ChangeFrontierSpec is the specification for a processor that receives
// span-level resolved timestamps, track them, and emits the changefeed-level
// resolved timestamp whenever it changes.
type ChangeFrontierSpec struct {
	// TrackedSpans is the entire span set being watched. Once all these spans
	// have been resolved at a certain timestamp, then it's safe to resolve the
	// changefeed at that timestamp.
	TrackedSpans []cockroach_roachpb1.Span `protobuf:"bytes,1,rep,name=tracked_spans,json=trackedSpans" json:"tracked_spans"`
	// Feed is the specification for this changefeed.
	Feed cockroach_sql_jobs_jobspb.ChangefeedDetails `protobuf:"bytes,2,opt,name=feed" json:"feed"`
	// JobID is the id of this changefeed in the system jobs.
	JobID int64 `protobuf:"varint,3,opt,name=job_id,json=jobId" json:"job_id"`
}

func (m *ChangeFrontierSpec) Reset()                    { *m = ChangeFrontierSpec{} }
func (m *ChangeFrontierSpec) String() string            { return proto.CompactTextString(m) }
func (*ChangeFrontierSpec) ProtoMessage()               {}
func (*ChangeFrontierSpec) Descriptor() ([]byte, []int) { return fileDescriptorProcessors, []int{31} }

func init() {
	proto.RegisterType((*ProcessorSpec)(nil), "cockroach.sql.distsqlrun.ProcessorSpec")
	proto.RegisterType((*PostProcessSpec)(nil), "cockroach.sql.distsqlrun.PostProcessSpec")
	proto.RegisterType((*ProcessorCoreUnion)(nil), "cockroach.sql.distsqlrun.ProcessorCoreUnion")
	proto.RegisterType((*NoopCoreSpec)(nil), "cockroach.sql.distsqlrun.NoopCoreSpec")
	proto.RegisterType((*MetadataTestSenderSpec)(nil), "cockroach.sql.distsqlrun.MetadataTestSenderSpec")
	proto.RegisterType((*MetadataTestReceiverSpec)(nil), "cockroach.sql.distsqlrun.MetadataTestReceiverSpec")
	proto.RegisterType((*ValuesCoreSpec)(nil), "cockroach.sql.distsqlrun.ValuesCoreSpec")
	proto.RegisterType((*TableReaderSpan)(nil), "cockroach.sql.distsqlrun.TableReaderSpan")
	proto.RegisterType((*TableReaderSpec)(nil), "cockroach.sql.distsqlrun.TableReaderSpec")
	proto.RegisterType((*JoinReaderSpec)(nil), "cockroach.sql.distsqlrun.JoinReaderSpec")
	proto.RegisterType((*SorterSpec)(nil), "cockroach.sql.distsqlrun.SorterSpec")
	proto.RegisterType((*DistinctSpec)(nil), "cockroach.sql.distsqlrun.DistinctSpec")
	proto.RegisterType((*ZigzagJoinerSpec)(nil), "cockroach.sql.distsqlrun.ZigzagJoinerSpec")
	proto.RegisterType((*LocalPlanNodeSpec)(nil), "cockroach.sql.distsqlrun.LocalPlanNodeSpec")
	proto.RegisterType((*Columns)(nil), "cockroach.sql.distsqlrun.Columns")
	proto.RegisterType((*MergeJoinerSpec)(nil), "cockroach.sql.distsqlrun.MergeJoinerSpec")
	proto.RegisterType((*HashJoinerSpec)(nil), "cockroach.sql.distsqlrun.HashJoinerSpec")
	proto.RegisterType((*AggregatorSpec)(nil), "cockroach.sql.distsqlrun.AggregatorSpec")
	proto.RegisterType((*AggregatorSpec_Aggregation)(nil), "cockroach.sql.distsqlrun.AggregatorSpec.Aggregation")
	proto.RegisterType((*BackfillerSpec)(nil), "cockroach.sql.distsqlrun.BackfillerSpec")
	proto.RegisterType((*FlowSpec)(nil), "cockroach.sql.distsqlrun.FlowSpec")
	proto.RegisterType((*JobProgress)(nil), "cockroach.sql.distsqlrun.JobProgress")
	proto.RegisterType((*ReadImportDataSpec)(nil), "cockroach.sql.distsqlrun.ReadImportDataSpec")
	proto.RegisterType((*SSTWriterSpec)(nil), "cockroach.sql.distsqlrun.SSTWriterSpec")
	proto.RegisterType((*SSTWriterSpec_SpanName)(nil), "cockroach.sql.distsqlrun.SSTWriterSpec.SpanName")
	proto.RegisterType((*CSVWriterSpec)(nil), "cockroach.sql.distsqlrun.CSVWriterSpec")
	proto.RegisterType((*SketchSpec)(nil), "cockroach.sql.distsqlrun.SketchSpec")
	proto.RegisterType((*SamplerSpec)(nil), "cockroach.sql.distsqlrun.SamplerSpec")
	proto.RegisterType((*SampleAggregatorSpec)(nil), "cockroach.sql.distsqlrun.SampleAggregatorSpec")
	proto.RegisterType((*InterleavedReaderJoinerSpec)(nil), "cockroach.sql.distsqlrun.InterleavedReaderJoinerSpec")
	proto.RegisterType((*InterleavedReaderJoinerSpec_Table)(nil), "cockroach.sql.distsqlrun.InterleavedReaderJoinerSpec.Table")
	proto.RegisterType((*ProjectSetSpec)(nil), "cockroach.sql.distsqlrun.ProjectSetSpec")
	proto.RegisterType((*WindowerSpec)(nil), "cockroach.sql.distsqlrun.WindowerSpec")
	proto.RegisterType((*WindowerSpec_Func)(nil), "cockroach.sql.distsqlrun.WindowerSpec.Func")
	proto.RegisterType((*WindowerSpec_Frame)(nil), "cockroach.sql.distsqlrun.WindowerSpec.Frame")
	proto.RegisterType((*WindowerSpec_Frame_Bound)(nil), "cockroach.sql.distsqlrun.WindowerSpec.Frame.Bound")
	proto.RegisterType((*WindowerSpec_Frame_Bounds)(nil), "cockroach.sql.distsqlrun.WindowerSpec.Frame.Bounds")
	proto.RegisterType((*WindowerSpec_WindowFn)(nil), "cockroach.sql.distsqlrun.WindowerSpec.WindowFn")
	proto.RegisterType((*ChangeAggregatorSpec)(nil), "cockroach.sql.distsqlrun.ChangeAggregatorSpec")
	proto.RegisterType((*ChangeAggregatorSpec_Watch)(nil), "cockroach.sql.distsqlrun.ChangeAggregatorSpec.Watch")
	proto.RegisterType((*ChangeFrontierSpec)(nil), "cockroach.sql.distsqlrun.ChangeFrontierSpec")
	proto.RegisterEnum("cockroach.sql.distsqlrun.ScanVisibility", ScanVisibility_name, ScanVisibility_value)
	proto.RegisterEnum("cockroach.sql.distsqlrun.SketchType", SketchType_name, SketchType_value)
	proto.RegisterEnum("cockroach.sql.distsqlrun.AggregatorSpec_Func", AggregatorSpec_Func_name, AggregatorSpec_Func_value)
	proto.RegisterEnum("cockroach.sql.distsqlrun.AggregatorSpec_Type", AggregatorSpec_Type_name, AggregatorSpec_Type_value)
	proto.RegisterEnum("cockroach.sql.distsqlrun.BackfillerSpec_Type", BackfillerSpec_Type_name, BackfillerSpec_Type_value)
	proto.RegisterEnum("cockroach.sql.distsqlrun.WindowerSpec_WindowFunc", WindowerSpec_WindowFunc_name, WindowerSpec_WindowFunc_value)
	proto.RegisterEnum("cockroach.sql.distsqlrun.WindowerSpec_Frame_Mode", WindowerSpec_Frame_Mode_name, WindowerSpec_Frame_Mode_value)
	proto.RegisterEnum("cockroach.sql.distsqlrun.WindowerSpec_Frame_BoundType", WindowerSpec_Frame_BoundType_name, WindowerSpec_Frame_BoundType_value)
}
func (m *ProcessorSpec) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ProcessorSpec) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Input) > 0 {
		for _, msg := range m.Input {
			dAtA[i] = 0xa
			i++
			i = encodeVarintProcessors(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	dAtA[i] = 0x12
	i++
	i = encodeVarintProcessors(dAtA, i, uint64(m.Core.Size()))
	n1, err := m.Core.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n1
	if len(m.Output) > 0 {
		for _, msg := range m.Output {
			dAtA[i] = 0x1a
			i++
			i = encodeVarintProcessors(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	dAtA[i] = 0x22
	i++
	i = encodeVarintProcessors(dAtA, i, uint64(m.Post.Size()))
	n2, err := m.Post.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n2
	dAtA[i] = 0x28
	i++
	i = encodeVarintProcessors(dAtA, i, uint64(m.StageID))
	dAtA[i] = 0x30
	i++
	i = encodeVarintProcessors(dAtA, i, uint64(m.ProcessorID))
	return i, nil
}

func (m *PostProcessSpec) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PostProcessSpec) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintProcessors(dAtA, i, uint64(m.Filter.Size()))
	n3, err := m.Filter.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n3
	dAtA[i] = 0x10
	i++
	if m.Projection {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i++
	if len(m.OutputColumns) > 0 {
		dAtA5 := make([]byte, len(m.OutputColumns)*10)
		var j4 int
		for _, num := range m.OutputColumns {
			for num >= 1<<7 {
				dAtA5[j4] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j4++
			}
			dAtA5[j4] = uint8(num)
			j4++
		}
		dAtA[i] = 0x1a
		i++
		i = encodeVarintProcessors(dAtA, i, uint64(j4))
		i += copy(dAtA[i:], dAtA5[:j4])
	}
	if len(m.RenderExprs) > 0 {
		for _, msg := range m.RenderExprs {
			dAtA[i] = 0x22
			i++
			i = encodeVarintProcessors(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	dAtA[i] = 0x28
	i++
	i = encodeVarintProcessors(dAtA, i, uint64(m.Offset))
	dAtA[i] = 0x30
	i++
	i = encodeVarintProcessors(dAtA, i, uint64(m.Limit))
	return i, nil
}

func (m *ProcessorCoreUnion) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ProcessorCoreUnion) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Noop != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintProcessors(dAtA, i, uint64(m.Noop.Size()))
		n6, err := m.Noop.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n6
	}
	if m.TableReader != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintProcessors(dAtA, i, uint64(m.TableReader.Size()))
		n7, err := m.TableReader.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n7
	}
	if m.JoinReader != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintProcessors(dAtA, i, uint64(m.JoinReader.Size()))
		n8, err := m.JoinReader.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n8
	}
	if m.Sorter != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintProcessors(dAtA, i, uint64(m.Sorter.Size()))
		n9, err := m.Sorter.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n9
	}
	if m.Aggregator != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintProcessors(dAtA, i, uint64(m.Aggregator.Size()))
		n10, err := m.Aggregator.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n10
	}
	if m.Distinct != nil {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintProcessors(dAtA, i, uint64(m.Distinct.Size()))
		n11, err := m.Distinct.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n11
	}
	if m.MergeJoiner != nil {
		dAtA[i] = 0x42
		i++
		i = encodeVarintProcessors(dAtA, i, uint64(m.MergeJoiner.Size()))
		n12, err := m.MergeJoiner.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n12
	}
	if m.HashJoiner != nil {
		dAtA[i] = 0x4a
		i++
		i = encodeVarintProcessors(dAtA, i, uint64(m.HashJoiner.Size()))
		n13, err := m.HashJoiner.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n13
	}
	if m.Values != nil {
		dAtA[i] = 0x52
		i++
		i = encodeVarintProcessors(dAtA, i, uint64(m.Values.Size()))
		n14, err := m.Values.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n14
	}
	if m.Backfiller != nil {
		dAtA[i] = 0x5a
		i++
		i = encodeVarintProcessors(dAtA, i, uint64(m.Backfiller.Size()))
		n15, err := m.Backfiller.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n15
	}
	if m.ReadImport != nil {
		dAtA[i] = 0x6a
		i++
		i = encodeVarintProcessors(dAtA, i, uint64(m.ReadImport.Size()))
		n16, err := m.ReadImport.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n16
	}
	if m.SSTWriter != nil {
		dAtA[i] = 0x72
		i++
		i = encodeVarintProcessors(dAtA, i, uint64(m.SSTWriter.Size()))
		n17, err := m.SSTWriter.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n17
	}
	if m.Sampler != nil {
		dAtA[i] = 0x7a
		i++
		i = encodeVarintProcessors(dAtA, i, uint64(m.Sampler.Size()))
		n18, err := m.Sampler.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n18
	}
	if m.SampleAggregator != nil {
		dAtA[i] = 0x82
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintProcessors(dAtA, i, uint64(m.SampleAggregator.Size()))
		n19, err := m.SampleAggregator.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n19
	}
	if m.InterleavedReaderJoiner != nil {
		dAtA[i] = 0x8a
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintProcessors(dAtA, i, uint64(m.InterleavedReaderJoiner.Size()))
		n20, err := m.InterleavedReaderJoiner.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n20
	}
	if m.MetadataTestSender != nil {
		dAtA[i] = 0x92
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintProcessors(dAtA, i, uint64(m.MetadataTestSender.Size()))
		n21, err := m.MetadataTestSender.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n21
	}
	if m.MetadataTestReceiver != nil {
		dAtA[i] = 0x9a
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintProcessors(dAtA, i, uint64(m.MetadataTestReceiver.Size()))
		n22, err := m.MetadataTestReceiver.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n22
	}
	if m.CSVWriter != nil {
		dAtA[i] = 0xa2
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintProcessors(dAtA, i, uint64(m.CSVWriter.Size()))
		n23, err := m.CSVWriter.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n23
	}
	if m.ZigzagJoiner != nil {
		dAtA[i] = 0xaa
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintProcessors(dAtA, i, uint64(m.ZigzagJoiner.Size()))
		n24, err := m.ZigzagJoiner.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n24
	}
	if m.ProjectSet != nil {
		dAtA[i] = 0xb2
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintProcessors(dAtA, i, uint64(m.ProjectSet.Size()))
		n25, err := m.ProjectSet.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n25
	}
	if m.Windower != nil {
		dAtA[i] = 0xba
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintProcessors(dAtA, i, uint64(m.Windower.Size()))
		n26, err := m.Windower.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n26
	}
	if m.LocalPlanNode != nil {
		dAtA[i] = 0xc2
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintProcessors(dAtA, i, uint64(m.LocalPlanNode.Size()))
		n27, err := m.LocalPlanNode.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n27
	}
	if m.ChangeAggregator != nil {
		dAtA[i] = 0xca
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintProcessors(dAtA, i, uint64(m.ChangeAggregator.Size()))
		n28, err := m.ChangeAggregator.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n28
	}
	if m.ChangeFrontier != nil {
		dAtA[i] = 0xd2
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintProcessors(dAtA, i, uint64(m.ChangeFrontier.Size()))
		n29, err := m.ChangeFrontier.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n29
	}
	return i, nil
}

func (m *NoopCoreSpec) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NoopCoreSpec) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	return i, nil
}

func (m *MetadataTestSenderSpec) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MetadataTestSenderSpec) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintProcessors(dAtA, i, uint64(len(m.ID)))
	i += copy(dAtA[i:], m.ID)
	return i, nil
}

func (m *MetadataTestReceiverSpec) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MetadataTestReceiverSpec) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.SenderIDs) > 0 {
		for _, s := range m.SenderIDs {
			dAtA[i] = 0xa
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	return i, nil
}

func (m *ValuesCoreSpec) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ValuesCoreSpec) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Columns) > 0 {
		for _, msg := range m.Columns {
			dAtA[i] = 0xa
			i++
			i = encodeVarintProcessors(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.RawBytes) > 0 {
		for _, b := range m.RawBytes {
			dAtA[i] = 0x12
			i++
			i = encodeVarintProcessors(dAtA, i, uint64(len(b)))
			i += copy(dAtA[i:], b)
		}
	}
	dAtA[i] = 0x18
	i++
	i = encodeVarintProcessors(dAtA, i, uint64(m.NumRows))
	return i, nil
}

func (m *TableReaderSpan) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TableReaderSpan) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintProcessors(dAtA, i, uint64(m.Span.Size()))
	n30, err := m.Span.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n30
	return i, nil
}

func (m *TableReaderSpec) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TableReaderSpec) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintProcessors(dAtA, i, uint64(m.Table.Size()))
	n31, err := m.Table.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n31
	dAtA[i] = 0x10
	i++
	i = encodeVarintProcessors(dAtA, i, uint64(m.IndexIdx))
	dAtA[i] = 0x18
	i++
	if m.Reverse {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i++
	if len(m.Spans) > 0 {
		for _, msg := range m.Spans {
			dAtA[i] = 0x22
			i++
			i = encodeVarintProcessors(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	dAtA[i] = 0x28
	i++
	i = encodeVarintProcessors(dAtA, i, uint64(m.LimitHint))
	dAtA[i] = 0x30
	i++
	if m.IsCheck {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i++
	dAtA[i] = 0x38
	i++
	i = encodeVarintProcessors(dAtA, i, uint64(m.Visibility))
	return i, nil
}

func (m *JoinReaderSpec) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *JoinReaderSpec) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintProcessors(dAtA, i, uint64(m.Table.Size()))
	n32, err := m.Table.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n32
	dAtA[i] = 0x10
	i++
	i = encodeVarintProcessors(dAtA, i, uint64(m.IndexIdx))
	if len(m.LookupColumns) > 0 {
		dAtA34 := make([]byte, len(m.LookupColumns)*10)
		var j33 int
		for _, num := range m.LookupColumns {
			for num >= 1<<7 {
				dAtA34[j33] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j33++
			}
			dAtA34[j33] = uint8(num)
			j33++
		}
		dAtA[i] = 0x1a
		i++
		i = encodeVarintProcessors(dAtA, i, uint64(j33))
		i += copy(dAtA[i:], dAtA34[:j33])
	}
	dAtA[i] = 0x22
	i++
	i = encodeVarintProcessors(dAtA, i, uint64(m.OnExpr.Size()))
	n35, err := m.OnExpr.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n35
	dAtA[i] = 0x2a
	i++
	i = encodeVarintProcessors(dAtA, i, uint64(m.IndexFilterExpr.Size()))
	n36, err := m.IndexFilterExpr.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n36
	dAtA[i] = 0x30
	i++
	i = encodeVarintProcessors(dAtA, i, uint64(m.Type))
	dAtA[i] = 0x38
	i++
	i = encodeVarintProcessors(dAtA, i, uint64(m.Visibility))
	return i, nil
}

func (m *SorterSpec) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SorterSpec) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintProcessors(dAtA, i, uint64(m.OutputOrdering.Size()))
	n37, err := m.OutputOrdering.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n37
	dAtA[i] = 0x10
	i++
	i = encodeVarintProcessors(dAtA, i, uint64(m.OrderingMatchLen))
	return i, nil
}

func (m *DistinctSpec) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DistinctSpec) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.OrderedColumns) > 0 {
		for _, num := range m.OrderedColumns {
			dAtA[i] = 0x8
			i++
			i = encodeVarintProcessors(dAtA, i, uint64(num))
		}
	}
	if len(m.DistinctColumns) > 0 {
		for _, num := range m.DistinctColumns {
			dAtA[i] = 0x10
			i++
			i = encodeVarintProcessors(dAtA, i, uint64(num))
		}
	}
	return i, nil
}

func (m *ZigzagJoinerSpec) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ZigzagJoinerSpec) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Tables) > 0 {
		for _, msg := range m.Tables {
			dAtA[i] = 0xa
			i++
			i = encodeVarintProcessors(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.EqColumns) > 0 {
		for _, msg := range m.EqColumns {
			dAtA[i] = 0x12
			i++
			i = encodeVarintProcessors(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.IndexIds) > 0 {
		dAtA39 := make([]byte, len(m.IndexIds)*10)
		var j38 int
		for _, num := range m.IndexIds {
			for num >= 1<<7 {
				dAtA39[j38] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j38++
			}
			dAtA39[j38] = uint8(num)
			j38++
		}
		dAtA[i] = 0x1a
		i++
		i = encodeVarintProcessors(dAtA, i, uint64(j38))
		i += copy(dAtA[i:], dAtA39[:j38])
	}
	dAtA[i] = 0x22
	i++
	i = encodeVarintProcessors(dAtA, i, uint64(m.OnExpr.Size()))
	n40, err := m.OnExpr.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n40
	dAtA[i] = 0x28
	i++
	i = encodeVarintProcessors(dAtA, i, uint64(m.Type))
	return i, nil
}

func (m *LocalPlanNodeSpec) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LocalPlanNodeSpec) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.RowSourceIdx != nil {
		dAtA[i] = 0x8
		i++
		i = encodeVarintProcessors(dAtA, i, uint64(*m.RowSourceIdx))
	}
	if m.NumInputs != nil {
		dAtA[i] = 0x10
		i++
		i = encodeVarintProcessors(dAtA, i, uint64(*m.NumInputs))
	}
	if m.Name != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintProcessors(dAtA, i, uint64(len(*m.Name)))
		i += copy(dAtA[i:], *m.Name)
	}
	return i, nil
}

func (m *Columns) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Columns) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Columns) > 0 {
		dAtA42 := make([]byte, len(m.Columns)*10)
		var j41 int
		for _, num := range m.Columns {
			for num >= 1<<7 {
				dAtA42[j41] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j41++
			}
			dAtA42[j41] = uint8(num)
			j41++
		}
		dAtA[i] = 0xa
		i++
		i = encodeVarintProcessors(dAtA, i, uint64(j41))
		i += copy(dAtA[i:], dAtA42[:j41])
	}
	return i, nil
}

func (m *MergeJoinerSpec) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MergeJoinerSpec) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintProcessors(dAtA, i, uint64(m.LeftOrdering.Size()))
	n43, err := m.LeftOrdering.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n43
	dAtA[i] = 0x12
	i++
	i = encodeVarintProcessors(dAtA, i, uint64(m.RightOrdering.Size()))
	n44, err := m.RightOrdering.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n44
	dAtA[i] = 0x2a
	i++
	i = encodeVarintProcessors(dAtA, i, uint64(m.OnExpr.Size()))
	n45, err := m.OnExpr.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n45
	dAtA[i] = 0x30
	i++
	i = encodeVarintProcessors(dAtA, i, uint64(m.Type))
	dAtA[i] = 0x38
	i++
	if m.NullEquality {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i++
	return i, nil
}

func (m *HashJoinerSpec) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HashJoinerSpec) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.LeftEqColumns) > 0 {
		dAtA47 := make([]byte, len(m.LeftEqColumns)*10)
		var j46 int
		for _, num := range m.LeftEqColumns {
			for num >= 1<<7 {
				dAtA47[j46] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j46++
			}
			dAtA47[j46] = uint8(num)
			j46++
		}
		dAtA[i] = 0xa
		i++
		i = encodeVarintProcessors(dAtA, i, uint64(j46))
		i += copy(dAtA[i:], dAtA47[:j46])
	}
	if len(m.RightEqColumns) > 0 {
		dAtA49 := make([]byte, len(m.RightEqColumns)*10)
		var j48 int
		for _, num := range m.RightEqColumns {
			for num >= 1<<7 {
				dAtA49[j48] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j48++
			}
			dAtA49[j48] = uint8(num)
			j48++
		}
		dAtA[i] = 0x12
		i++
		i = encodeVarintProcessors(dAtA, i, uint64(j48))
		i += copy(dAtA[i:], dAtA49[:j48])
	}
	dAtA[i] = 0x2a
	i++
	i = encodeVarintProcessors(dAtA, i, uint64(m.OnExpr.Size()))
	n50, err := m.OnExpr.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n50
	dAtA[i] = 0x30
	i++
	i = encodeVarintProcessors(dAtA, i, uint64(m.Type))
	dAtA[i] = 0x38
	i++
	if m.MergedColumns {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i++
	return i, nil
}

func (m *AggregatorSpec) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AggregatorSpec) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.GroupCols) > 0 {
		dAtA52 := make([]byte, len(m.GroupCols)*10)
		var j51 int
		for _, num := range m.GroupCols {
			for num >= 1<<7 {
				dAtA52[j51] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j51++
			}
			dAtA52[j51] = uint8(num)
			j51++
		}
		dAtA[i] = 0x12
		i++
		i = encodeVarintProcessors(dAtA, i, uint64(j51))
		i += copy(dAtA[i:], dAtA52[:j51])
	}
	if len(m.Aggregations) > 0 {
		for _, msg := range m.Aggregations {
			dAtA[i] = 0x1a
			i++
			i = encodeVarintProcessors(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.OrderedGroupCols) > 0 {
		dAtA54 := make([]byte, len(m.OrderedGroupCols)*10)
		var j53 int
		for _, num := range m.OrderedGroupCols {
			for num >= 1<<7 {
				dAtA54[j53] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j53++
			}
			dAtA54[j53] = uint8(num)
			j53++
		}
		dAtA[i] = 0x22
		i++
		i = encodeVarintProcessors(dAtA, i, uint64(j53))
		i += copy(dAtA[i:], dAtA54[:j53])
	}
	dAtA[i] = 0x28
	i++
	i = encodeVarintProcessors(dAtA, i, uint64(m.Type))
	return i, nil
}

func (m *AggregatorSpec_Aggregation) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AggregatorSpec_Aggregation) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintProcessors(dAtA, i, uint64(m.Func))
	dAtA[i] = 0x10
	i++
	if m.Distinct {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i++
	if m.FilterColIdx != nil {
		dAtA[i] = 0x20
		i++
		i = encodeVarintProcessors(dAtA, i, uint64(*m.FilterColIdx))
	}
	if len(m.ColIdx) > 0 {
		for _, num := range m.ColIdx {
			dAtA[i] = 0x28
			i++
			i = encodeVarintProcessors(dAtA, i, uint64(num))
		}
	}
	if len(m.Arguments) > 0 {
		for _, msg := range m.Arguments {
			dAtA[i] = 0x32
			i++
			i = encodeVarintProcessors(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *BackfillerSpec) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *BackfillerSpec) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintProcessors(dAtA, i, uint64(m.Type))
	dAtA[i] = 0x12
	i++
	i = encodeVarintProcessors(dAtA, i, uint64(m.Table.Size()))
	n55, err := m.Table.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n55
	if len(m.Spans) > 0 {
		for _, msg := range m.Spans {
			dAtA[i] = 0x1a
			i++
			i = encodeVarintProcessors(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	dAtA[i] = 0x20
	i++
	i = encodeVarintProcessors(dAtA, i, uint64(m.Duration))
	dAtA[i] = 0x28
	i++
	i = encodeVarintProcessors(dAtA, i, uint64(m.ChunkSize))
	if len(m.OtherTables) > 0 {
		for _, msg := range m.OtherTables {
			dAtA[i] = 0x32
			i++
			i = encodeVarintProcessors(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	dAtA[i] = 0x3a
	i++
	i = encodeVarintProcessors(dAtA, i, uint64(m.ReadAsOf.Size()))
	n56, err := m.ReadAsOf.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n56
	return i, nil
}

func (m *FlowSpec) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *FlowSpec) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintProcessors(dAtA, i, uint64(m.FlowID.Size()))
	n57, err := m.FlowID.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n57
	if len(m.Processors) > 0 {
		for _, msg := range m.Processors {
			dAtA[i] = 0x12
			i++
			i = encodeVarintProcessors(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	dAtA[i] = 0x18
	i++
	i = encodeVarintProcessors(dAtA, i, uint64(m.Gateway))
	return i, nil
}

func (m *JobProgress) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *JobProgress) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintProcessors(dAtA, i, uint64(m.JobID))
	dAtA[i] = 0x15
	i++
	binary.LittleEndian.PutUint32(dAtA[i:], uint32(math.Float32bits(float32(m.Contribution))))
	i += 4
	dAtA[i] = 0x18
	i++
	i = encodeVarintProcessors(dAtA, i, uint64(m.Slot))
	return i, nil
}

func (m *ReadImportDataSpec) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ReadImportDataSpec) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x10
	i++
	i = encodeVarintProcessors(dAtA, i, uint64(m.SampleSize))
	dAtA[i] = 0x32
	i++
	i = encodeVarintProcessors(dAtA, i, uint64(m.Progress.Size()))
	n58, err := m.Progress.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n58
	if len(m.Uri) > 0 {
		keysForUri := make([]int32, 0, len(m.Uri))
		for k := range m.Uri {
			keysForUri = append(keysForUri, int32(k))
		}
		sortkeys.Int32s(keysForUri)
		for _, k := range keysForUri {
			dAtA[i] = 0x3a
			i++
			v := m.Uri[int32(k)]
			mapSize := 1 + sovProcessors(uint64(k)) + 1 + len(v) + sovProcessors(uint64(len(v)))
			i = encodeVarintProcessors(dAtA, i, uint64(mapSize))
			dAtA[i] = 0x8
			i++
			i = encodeVarintProcessors(dAtA, i, uint64(k))
			dAtA[i] = 0x12
			i++
			i = encodeVarintProcessors(dAtA, i, uint64(len(v)))
			i += copy(dAtA[i:], v)
		}
	}
	dAtA[i] = 0x42
	i++
	i = encodeVarintProcessors(dAtA, i, uint64(m.Format.Size()))
	n59, err := m.Format.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n59
	if len(m.Tables) > 0 {
		keysForTables := make([]string, 0, len(m.Tables))
		for k := range m.Tables {
			keysForTables = append(keysForTables, string(k))
		}
		sortkeys.Strings(keysForTables)
		for _, k := range keysForTables {
			dAtA[i] = 0x4a
			i++
			v := m.Tables[string(k)]
			msgSize := 0
			if v != nil {
				msgSize = v.Size()
				msgSize += 1 + sovProcessors(uint64(msgSize))
			}
			mapSize := 1 + len(k) + sovProcessors(uint64(len(k))) + msgSize
			i = encodeVarintProcessors(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintProcessors(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			if v != nil {
				dAtA[i] = 0x12
				i++
				i = encodeVarintProcessors(dAtA, i, uint64(v.Size()))
				n60, err := v.MarshalTo(dAtA[i:])
				if err != nil {
					return 0, err
				}
				i += n60
			}
		}
	}
	dAtA[i] = 0x50
	i++
	if m.SkipMissingForeignKeys {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i++
	return i, nil
}

func (m *SSTWriterSpec) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SSTWriterSpec) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintProcessors(dAtA, i, uint64(len(m.Destination)))
	i += copy(dAtA[i:], m.Destination)
	dAtA[i] = 0x18
	i++
	i = encodeVarintProcessors(dAtA, i, uint64(m.WalltimeNanos))
	if len(m.Spans) > 0 {
		for _, msg := range m.Spans {
			dAtA[i] = 0x22
			i++
			i = encodeVarintProcessors(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	dAtA[i] = 0x2a
	i++
	i = encodeVarintProcessors(dAtA, i, uint64(m.Progress.Size()))
	n61, err := m.Progress.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n61
	return i, nil
}

func (m *SSTWriterSpec_SpanName) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SSTWriterSpec_SpanName) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintProcessors(dAtA, i, uint64(len(m.Name)))
	i += copy(dAtA[i:], m.Name)
	if m.End != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintProcessors(dAtA, i, uint64(len(m.End)))
		i += copy(dAtA[i:], m.End)
	}
	return i, nil
}

func (m *CSVWriterSpec) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CSVWriterSpec) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintProcessors(dAtA, i, uint64(len(m.Destination)))
	i += copy(dAtA[i:], m.Destination)
	dAtA[i] = 0x12
	i++
	i = encodeVarintProcessors(dAtA, i, uint64(len(m.NamePattern)))
	i += copy(dAtA[i:], m.NamePattern)
	dAtA[i] = 0x1a
	i++
	i = encodeVarintProcessors(dAtA, i, uint64(m.Options.Size()))
	n62, err := m.Options.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n62
	dAtA[i] = 0x20
	i++
	i = encodeVarintProcessors(dAtA, i, uint64(m.ChunkRows))
	return i, nil
}

func (m *SketchSpec) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SketchSpec) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintProcessors(dAtA, i, uint64(m.SketchType))
	if len(m.Columns) > 0 {
		for _, num := range m.Columns {
			dAtA[i] = 0x10
			i++
			i = encodeVarintProcessors(dAtA, i, uint64(num))
		}
	}
	dAtA[i] = 0x18
	i++
	if m.GenerateHistogram {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i++
	dAtA[i] = 0x20
	i++
	i = encodeVarintProcessors(dAtA, i, uint64(m.HistogramMaxBuckets))
	dAtA[i] = 0x2a
	i++
	i = encodeVarintProcessors(dAtA, i, uint64(len(m.StatName)))
	i += copy(dAtA[i:], m.StatName)
	return i, nil
}

func (m *SamplerSpec) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SamplerSpec) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Sketches) > 0 {
		for _, msg := range m.Sketches {
			dAtA[i] = 0xa
			i++
			i = encodeVarintProcessors(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	dAtA[i] = 0x10
	i++
	i = encodeVarintProcessors(dAtA, i, uint64(m.SampleSize))
	return i, nil
}

func (m *SampleAggregatorSpec) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SampleAggregatorSpec) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Sketches) > 0 {
		for _, msg := range m.Sketches {
			dAtA[i] = 0xa
			i++
			i = encodeVarintProcessors(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	dAtA[i] = 0x10
	i++
	i = encodeVarintProcessors(dAtA, i, uint64(m.SampleSize))
	if len(m.SampledColumnIDs) > 0 {
		for _, num := range m.SampledColumnIDs {
			dAtA[i] = 0x18
			i++
			i = encodeVarintProcessors(dAtA, i, uint64(num))
		}
	}
	dAtA[i] = 0x20
	i++
	i = encodeVarintProcessors(dAtA, i, uint64(m.TableID))
	return i, nil
}

func (m *InterleavedReaderJoinerSpec) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *InterleavedReaderJoinerSpec) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Tables) > 0 {
		for _, msg := range m.Tables {
			dAtA[i] = 0xa
			i++
			i = encodeVarintProcessors(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	dAtA[i] = 0x10
	i++
	if m.Reverse {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i++
	dAtA[i] = 0x18
	i++
	i = encodeVarintProcessors(dAtA, i, uint64(m.LimitHint))
	dAtA[i] = 0x22
	i++
	i = encodeVarintProcessors(dAtA, i, uint64(m.OnExpr.Size()))
	n63, err := m.OnExpr.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n63
	dAtA[i] = 0x28
	i++
	i = encodeVarintProcessors(dAtA, i, uint64(m.Type))
	return i, nil
}

func (m *InterleavedReaderJoinerSpec_Table) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *InterleavedReaderJoinerSpec_Table) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintProcessors(dAtA, i, uint64(m.Desc.Size()))
	n64, err := m.Desc.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n64
	dAtA[i] = 0x10
	i++
	i = encodeVarintProcessors(dAtA, i, uint64(m.IndexIdx))
	dAtA[i] = 0x1a
	i++
	i = encodeVarintProcessors(dAtA, i, uint64(m.Post.Size()))
	n65, err := m.Post.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n65
	dAtA[i] = 0x22
	i++
	i = encodeVarintProcessors(dAtA, i, uint64(m.Ordering.Size()))
	n66, err := m.Ordering.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n66
	if len(m.Spans) > 0 {
		for _, msg := range m.Spans {
			dAtA[i] = 0x2a
			i++
			i = encodeVarintProcessors(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *ProjectSetSpec) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ProjectSetSpec) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Exprs) > 0 {
		for _, msg := range m.Exprs {
			dAtA[i] = 0xa
			i++
			i = encodeVarintProcessors(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.GeneratedColumns) > 0 {
		for _, msg := range m.GeneratedColumns {
			dAtA[i] = 0x12
			i++
			i = encodeVarintProcessors(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.NumColsPerGen) > 0 {
		for _, num := range m.NumColsPerGen {
			dAtA[i] = 0x18
			i++
			i = encodeVarintProcessors(dAtA, i, uint64(num))
		}
	}
	return i, nil
}

func (m *WindowerSpec) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *WindowerSpec) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.PartitionBy) > 0 {
		for _, num := range m.PartitionBy {
			dAtA[i] = 0x8
			i++
			i = encodeVarintProcessors(dAtA, i, uint64(num))
		}
	}
	if len(m.WindowFns) > 0 {
		for _, msg := range m.WindowFns {
			dAtA[i] = 0x12
			i++
			i = encodeVarintProcessors(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *WindowerSpec_Func) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *WindowerSpec_Func) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.AggregateFunc != nil {
		dAtA[i] = 0x8
		i++
		i = encodeVarintProcessors(dAtA, i, uint64(*m.AggregateFunc))
	}
	if m.WindowFunc != nil {
		dAtA[i] = 0x10
		i++
		i = encodeVarintProcessors(dAtA, i, uint64(*m.WindowFunc))
	}
	return i, nil
}

func (m *WindowerSpec_Frame) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *WindowerSpec_Frame) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintProcessors(dAtA, i, uint64(m.Mode))
	dAtA[i] = 0x12
	i++
	i = encodeVarintProcessors(dAtA, i, uint64(m.Bounds.Size()))
	n67, err := m.Bounds.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n67
	return i, nil
}

func (m *WindowerSpec_Frame_Bound) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *WindowerSpec_Frame_Bound) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintProcessors(dAtA, i, uint64(m.BoundType))
	dAtA[i] = 0x10
	i++
	i = encodeVarintProcessors(dAtA, i, uint64(m.IntOffset))
	if m.TypedOffset != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintProcessors(dAtA, i, uint64(len(m.TypedOffset)))
		i += copy(dAtA[i:], m.TypedOffset)
	}
	dAtA[i] = 0x22
	i++
	i = encodeVarintProcessors(dAtA, i, uint64(m.OffsetType.Size()))
	n68, err := m.OffsetType.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n68
	return i, nil
}

func (m *WindowerSpec_Frame_Bounds) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *WindowerSpec_Frame_Bounds) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintProcessors(dAtA, i, uint64(m.Start.Size()))
	n69, err := m.Start.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n69
	if m.End != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintProcessors(dAtA, i, uint64(m.End.Size()))
		n70, err := m.End.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n70
	}
	return i, nil
}

func (m *WindowerSpec_WindowFn) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *WindowerSpec_WindowFn) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintProcessors(dAtA, i, uint64(m.Func.Size()))
	n71, err := m.Func.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n71
	dAtA[i] = 0x10
	i++
	i = encodeVarintProcessors(dAtA, i, uint64(m.ArgIdxStart))
	dAtA[i] = 0x18
	i++
	i = encodeVarintProcessors(dAtA, i, uint64(m.ArgCount))
	dAtA[i] = 0x22
	i++
	i = encodeVarintProcessors(dAtA, i, uint64(m.Ordering.Size()))
	n72, err := m.Ordering.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n72
	if m.Frame != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintProcessors(dAtA, i, uint64(m.Frame.Size()))
		n73, err := m.Frame.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n73
	}
	dAtA[i] = 0x30
	i++
	i = encodeVarintProcessors(dAtA, i, uint64(m.FilterColIdx))
	return i, nil
}

func (m *ChangeAggregatorSpec) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ChangeAggregatorSpec) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Watches) > 0 {
		for _, msg := range m.Watches {
			dAtA[i] = 0xa
			i++
			i = encodeVarintProcessors(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	dAtA[i] = 0x12
	i++
	i = encodeVarintProcessors(dAtA, i, uint64(m.Feed.Size()))
	n74, err := m.Feed.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n74
	return i, nil
}

func (m *ChangeAggregatorSpec_Watch) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ChangeAggregatorSpec_Watch) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintProcessors(dAtA, i, uint64(m.InitialResolved.Size()))
	n75, err := m.InitialResolved.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n75
	dAtA[i] = 0x12
	i++
	i = encodeVarintProcessors(dAtA, i, uint64(m.Span.Size()))
	n76, err := m.Span.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n76
	return i, nil
}

func (m *ChangeFrontierSpec) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ChangeFrontierSpec) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.TrackedSpans) > 0 {
		for _, msg := range m.TrackedSpans {
			dAtA[i] = 0xa
			i++
			i = encodeVarintProcessors(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	dAtA[i] = 0x12
	i++
	i = encodeVarintProcessors(dAtA, i, uint64(m.Feed.Size()))
	n77, err := m.Feed.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n77
	dAtA[i] = 0x18
	i++
	i = encodeVarintProcessors(dAtA, i, uint64(m.JobID))
	return i, nil
}

func encodeVarintProcessors(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *ProcessorSpec) Size() (n int) {
	var l int
	_ = l
	if len(m.Input) > 0 {
		for _, e := range m.Input {
			l = e.Size()
			n += 1 + l + sovProcessors(uint64(l))
		}
	}
	l = m.Core.Size()
	n += 1 + l + sovProcessors(uint64(l))
	if len(m.Output) > 0 {
		for _, e := range m.Output {
			l = e.Size()
			n += 1 + l + sovProcessors(uint64(l))
		}
	}
	l = m.Post.Size()
	n += 1 + l + sovProcessors(uint64(l))
	n += 1 + sovProcessors(uint64(m.StageID))
	n += 1 + sovProcessors(uint64(m.ProcessorID))
	return n
}

func (m *PostProcessSpec) Size() (n int) {
	var l int
	_ = l
	l = m.Filter.Size()
	n += 1 + l + sovProcessors(uint64(l))
	n += 2
	if len(m.OutputColumns) > 0 {
		l = 0
		for _, e := range m.OutputColumns {
			l += sovProcessors(uint64(e))
		}
		n += 1 + sovProcessors(uint64(l)) + l
	}
	if len(m.RenderExprs) > 0 {
		for _, e := range m.RenderExprs {
			l = e.Size()
			n += 1 + l + sovProcessors(uint64(l))
		}
	}
	n += 1 + sovProcessors(uint64(m.Offset))
	n += 1 + sovProcessors(uint64(m.Limit))
	return n
}

func (m *ProcessorCoreUnion) Size() (n int) {
	var l int
	_ = l
	if m.Noop != nil {
		l = m.Noop.Size()
		n += 1 + l + sovProcessors(uint64(l))
	}
	if m.TableReader != nil {
		l = m.TableReader.Size()
		n += 1 + l + sovProcessors(uint64(l))
	}
	if m.JoinReader != nil {
		l = m.JoinReader.Size()
		n += 1 + l + sovProcessors(uint64(l))
	}
	if m.Sorter != nil {
		l = m.Sorter.Size()
		n += 1 + l + sovProcessors(uint64(l))
	}
	if m.Aggregator != nil {
		l = m.Aggregator.Size()
		n += 1 + l + sovProcessors(uint64(l))
	}
	if m.Distinct != nil {
		l = m.Distinct.Size()
		n += 1 + l + sovProcessors(uint64(l))
	}
	if m.MergeJoiner != nil {
		l = m.MergeJoiner.Size()
		n += 1 + l + sovProcessors(uint64(l))
	}
	if m.HashJoiner != nil {
		l = m.HashJoiner.Size()
		n += 1 + l + sovProcessors(uint64(l))
	}
	if m.Values != nil {
		l = m.Values.Size()
		n += 1 + l + sovProcessors(uint64(l))
	}
	if m.Backfiller != nil {
		l = m.Backfiller.Size()
		n += 1 + l + sovProcessors(uint64(l))
	}
	if m.ReadImport != nil {
		l = m.ReadImport.Size()
		n += 1 + l + sovProcessors(uint64(l))
	}
	if m.SSTWriter != nil {
		l = m.SSTWriter.Size()
		n += 1 + l + sovProcessors(uint64(l))
	}
	if m.Sampler != nil {
		l = m.Sampler.Size()
		n += 1 + l + sovProcessors(uint64(l))
	}
	if m.SampleAggregator != nil {
		l = m.SampleAggregator.Size()
		n += 2 + l + sovProcessors(uint64(l))
	}
	if m.InterleavedReaderJoiner != nil {
		l = m.InterleavedReaderJoiner.Size()
		n += 2 + l + sovProcessors(uint64(l))
	}
	if m.MetadataTestSender != nil {
		l = m.MetadataTestSender.Size()
		n += 2 + l + sovProcessors(uint64(l))
	}
	if m.MetadataTestReceiver != nil {
		l = m.MetadataTestReceiver.Size()
		n += 2 + l + sovProcessors(uint64(l))
	}
	if m.CSVWriter != nil {
		l = m.CSVWriter.Size()
		n += 2 + l + sovProcessors(uint64(l))
	}
	if m.ZigzagJoiner != nil {
		l = m.ZigzagJoiner.Size()
		n += 2 + l + sovProcessors(uint64(l))
	}
	if m.ProjectSet != nil {
		l = m.ProjectSet.Size()
		n += 2 + l + sovProcessors(uint64(l))
	}
	if m.Windower != nil {
		l = m.Windower.Size()
		n += 2 + l + sovProcessors(uint64(l))
	}
	if m.LocalPlanNode != nil {
		l = m.LocalPlanNode.Size()
		n += 2 + l + sovProcessors(uint64(l))
	}
	if m.ChangeAggregator != nil {
		l = m.ChangeAggregator.Size()
		n += 2 + l + sovProcessors(uint64(l))
	}
	if m.ChangeFrontier != nil {
		l = m.ChangeFrontier.Size()
		n += 2 + l + sovProcessors(uint64(l))
	}
	return n
}

func (m *NoopCoreSpec) Size() (n int) {
	var l int
	_ = l
	return n
}

func (m *MetadataTestSenderSpec) Size() (n int) {
	var l int
	_ = l
	l = len(m.ID)
	n += 1 + l + sovProcessors(uint64(l))
	return n
}

func (m *MetadataTestReceiverSpec) Size() (n int) {
	var l int
	_ = l
	if len(m.SenderIDs) > 0 {
		for _, s := range m.SenderIDs {
			l = len(s)
			n += 1 + l + sovProcessors(uint64(l))
		}
	}
	return n
}

func (m *ValuesCoreSpec) Size() (n int) {
	var l int
	_ = l
	if len(m.Columns) > 0 {
		for _, e := range m.Columns {
			l = e.Size()
			n += 1 + l + sovProcessors(uint64(l))
		}
	}
	if len(m.RawBytes) > 0 {
		for _, b := range m.RawBytes {
			l = len(b)
			n += 1 + l + sovProcessors(uint64(l))
		}
	}
	n += 1 + sovProcessors(uint64(m.NumRows))
	return n
}

func (m *TableReaderSpan) Size() (n int) {
	var l int
	_ = l
	l = m.Span.Size()
	n += 1 + l + sovProcessors(uint64(l))
	return n
}

func (m *TableReaderSpec) Size() (n int) {
	var l int
	_ = l
	l = m.Table.Size()
	n += 1 + l + sovProcessors(uint64(l))
	n += 1 + sovProcessors(uint64(m.IndexIdx))
	n += 2
	if len(m.Spans) > 0 {
		for _, e := range m.Spans {
			l = e.Size()
			n += 1 + l + sovProcessors(uint64(l))
		}
	}
	n += 1 + sovProcessors(uint64(m.LimitHint))
	n += 2
	n += 1 + sovProcessors(uint64(m.Visibility))
	return n
}

func (m *JoinReaderSpec) Size() (n int) {
	var l int
	_ = l
	l = m.Table.Size()
	n += 1 + l + sovProcessors(uint64(l))
	n += 1 + sovProcessors(uint64(m.IndexIdx))
	if len(m.LookupColumns) > 0 {
		l = 0
		for _, e := range m.LookupColumns {
			l += sovProcessors(uint64(e))
		}
		n += 1 + sovProcessors(uint64(l)) + l
	}
	l = m.OnExpr.Size()
	n += 1 + l + sovProcessors(uint64(l))
	l = m.IndexFilterExpr.Size()
	n += 1 + l + sovProcessors(uint64(l))
	n += 1 + sovProcessors(uint64(m.Type))
	n += 1 + sovProcessors(uint64(m.Visibility))
	return n
}

func (m *SorterSpec) Size() (n int) {
	var l int
	_ = l
	l = m.OutputOrdering.Size()
	n += 1 + l + sovProcessors(uint64(l))
	n += 1 + sovProcessors(uint64(m.OrderingMatchLen))
	return n
}

func (m *DistinctSpec) Size() (n int) {
	var l int
	_ = l
	if len(m.OrderedColumns) > 0 {
		for _, e := range m.OrderedColumns {
			n += 1 + sovProcessors(uint64(e))
		}
	}
	if len(m.DistinctColumns) > 0 {
		for _, e := range m.DistinctColumns {
			n += 1 + sovProcessors(uint64(e))
		}
	}
	return n
}

func (m *ZigzagJoinerSpec) Size() (n int) {
	var l int
	_ = l
	if len(m.Tables) > 0 {
		for _, e := range m.Tables {
			l = e.Size()
			n += 1 + l + sovProcessors(uint64(l))
		}
	}
	if len(m.EqColumns) > 0 {
		for _, e := range m.EqColumns {
			l = e.Size()
			n += 1 + l + sovProcessors(uint64(l))
		}
	}
	if len(m.IndexIds) > 0 {
		l = 0
		for _, e := range m.IndexIds {
			l += sovProcessors(uint64(e))
		}
		n += 1 + sovProcessors(uint64(l)) + l
	}
	l = m.OnExpr.Size()
	n += 1 + l + sovProcessors(uint64(l))
	n += 1 + sovProcessors(uint64(m.Type))
	return n
}

func (m *LocalPlanNodeSpec) Size() (n int) {
	var l int
	_ = l
	if m.RowSourceIdx != nil {
		n += 1 + sovProcessors(uint64(*m.RowSourceIdx))
	}
	if m.NumInputs != nil {
		n += 1 + sovProcessors(uint64(*m.NumInputs))
	}
	if m.Name != nil {
		l = len(*m.Name)
		n += 1 + l + sovProcessors(uint64(l))
	}
	return n
}

func (m *Columns) Size() (n int) {
	var l int
	_ = l
	if len(m.Columns) > 0 {
		l = 0
		for _, e := range m.Columns {
			l += sovProcessors(uint64(e))
		}
		n += 1 + sovProcessors(uint64(l)) + l
	}
	return n
}

func (m *MergeJoinerSpec) Size() (n int) {
	var l int
	_ = l
	l = m.LeftOrdering.Size()
	n += 1 + l + sovProcessors(uint64(l))
	l = m.RightOrdering.Size()
	n += 1 + l + sovProcessors(uint64(l))
	l = m.OnExpr.Size()
	n += 1 + l + sovProcessors(uint64(l))
	n += 1 + sovProcessors(uint64(m.Type))
	n += 2
	return n
}

func (m *HashJoinerSpec) Size() (n int) {
	var l int
	_ = l
	if len(m.LeftEqColumns) > 0 {
		l = 0
		for _, e := range m.LeftEqColumns {
			l += sovProcessors(uint64(e))
		}
		n += 1 + sovProcessors(uint64(l)) + l
	}
	if len(m.RightEqColumns) > 0 {
		l = 0
		for _, e := range m.RightEqColumns {
			l += sovProcessors(uint64(e))
		}
		n += 1 + sovProcessors(uint64(l)) + l
	}
	l = m.OnExpr.Size()
	n += 1 + l + sovProcessors(uint64(l))
	n += 1 + sovProcessors(uint64(m.Type))
	n += 2
	return n
}

func (m *AggregatorSpec) Size() (n int) {
	var l int
	_ = l
	if len(m.GroupCols) > 0 {
		l = 0
		for _, e := range m.GroupCols {
			l += sovProcessors(uint64(e))
		}
		n += 1 + sovProcessors(uint64(l)) + l
	}
	if len(m.Aggregations) > 0 {
		for _, e := range m.Aggregations {
			l = e.Size()
			n += 1 + l + sovProcessors(uint64(l))
		}
	}
	if len(m.OrderedGroupCols) > 0 {
		l = 0
		for _, e := range m.OrderedGroupCols {
			l += sovProcessors(uint64(e))
		}
		n += 1 + sovProcessors(uint64(l)) + l
	}
	n += 1 + sovProcessors(uint64(m.Type))
	return n
}

func (m *AggregatorSpec_Aggregation) Size() (n int) {
	var l int
	_ = l
	n += 1 + sovProcessors(uint64(m.Func))
	n += 2
	if m.FilterColIdx != nil {
		n += 1 + sovProcessors(uint64(*m.FilterColIdx))
	}
	if len(m.ColIdx) > 0 {
		for _, e := range m.ColIdx {
			n += 1 + sovProcessors(uint64(e))
		}
	}
	if len(m.Arguments) > 0 {
		for _, e := range m.Arguments {
			l = e.Size()
			n += 1 + l + sovProcessors(uint64(l))
		}
	}
	return n
}

func (m *BackfillerSpec) Size() (n int) {
	var l int
	_ = l
	n += 1 + sovProcessors(uint64(m.Type))
	l = m.Table.Size()
	n += 1 + l + sovProcessors(uint64(l))
	if len(m.Spans) > 0 {
		for _, e := range m.Spans {
			l = e.Size()
			n += 1 + l + sovProcessors(uint64(l))
		}
	}
	n += 1 + sovProcessors(uint64(m.Duration))
	n += 1 + sovProcessors(uint64(m.ChunkSize))
	if len(m.OtherTables) > 0 {
		for _, e := range m.OtherTables {
			l = e.Size()
			n += 1 + l + sovProcessors(uint64(l))
		}
	}
	l = m.ReadAsOf.Size()
	n += 1 + l + sovProcessors(uint64(l))
	return n
}

func (m *FlowSpec) Size() (n int) {
	var l int
	_ = l
	l = m.FlowID.Size()
	n += 1 + l + sovProcessors(uint64(l))
	if len(m.Processors) > 0 {
		for _, e := range m.Processors {
			l = e.Size()
			n += 1 + l + sovProcessors(uint64(l))
		}
	}
	n += 1 + sovProcessors(uint64(m.Gateway))
	return n
}

func (m *JobProgress) Size() (n int) {
	var l int
	_ = l
	n += 1 + sovProcessors(uint64(m.JobID))
	n += 5
	n += 1 + sovProcessors(uint64(m.Slot))
	return n
}

func (m *ReadImportDataSpec) Size() (n int) {
	var l int
	_ = l
	n += 1 + sovProcessors(uint64(m.SampleSize))
	l = m.Progress.Size()
	n += 1 + l + sovProcessors(uint64(l))
	if len(m.Uri) > 0 {
		for k, v := range m.Uri {
			_ = k
			_ = v
			mapEntrySize := 1 + sovProcessors(uint64(k)) + 1 + len(v) + sovProcessors(uint64(len(v)))
			n += mapEntrySize + 1 + sovProcessors(uint64(mapEntrySize))
		}
	}
	l = m.Format.Size()
	n += 1 + l + sovProcessors(uint64(l))
	if len(m.Tables) > 0 {
		for k, v := range m.Tables {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovProcessors(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovProcessors(uint64(len(k))) + l
			n += mapEntrySize + 1 + sovProcessors(uint64(mapEntrySize))
		}
	}
	n += 2
	return n
}

func (m *SSTWriterSpec) Size() (n int) {
	var l int
	_ = l
	l = len(m.Destination)
	n += 1 + l + sovProcessors(uint64(l))
	n += 1 + sovProcessors(uint64(m.WalltimeNanos))
	if len(m.Spans) > 0 {
		for _, e := range m.Spans {
			l = e.Size()
			n += 1 + l + sovProcessors(uint64(l))
		}
	}
	l = m.Progress.Size()
	n += 1 + l + sovProcessors(uint64(l))
	return n
}

func (m *SSTWriterSpec_SpanName) Size() (n int) {
	var l int
	_ = l
	l = len(m.Name)
	n += 1 + l + sovProcessors(uint64(l))
	if m.End != nil {
		l = len(m.End)
		n += 1 + l + sovProcessors(uint64(l))
	}
	return n
}

func (m *CSVWriterSpec) Size() (n int) {
	var l int
	_ = l
	l = len(m.Destination)
	n += 1 + l + sovProcessors(uint64(l))
	l = len(m.NamePattern)
	n += 1 + l + sovProcessors(uint64(l))
	l = m.Options.Size()
	n += 1 + l + sovProcessors(uint64(l))
	n += 1 + sovProcessors(uint64(m.ChunkRows))
	return n
}

func (m *SketchSpec) Size() (n int) {
	var l int
	_ = l
	n += 1 + sovProcessors(uint64(m.SketchType))
	if len(m.Columns) > 0 {
		for _, e := range m.Columns {
			n += 1 + sovProcessors(uint64(e))
		}
	}
	n += 2
	n += 1 + sovProcessors(uint64(m.HistogramMaxBuckets))
	l = len(m.StatName)
	n += 1 + l + sovProcessors(uint64(l))
	return n
}

func (m *SamplerSpec) Size() (n int) {
	var l int
	_ = l
	if len(m.Sketches) > 0 {
		for _, e := range m.Sketches {
			l = e.Size()
			n += 1 + l + sovProcessors(uint64(l))
		}
	}
	n += 1 + sovProcessors(uint64(m.SampleSize))
	return n
}

func (m *SampleAggregatorSpec) Size() (n int) {
	var l int
	_ = l
	if len(m.Sketches) > 0 {
		for _, e := range m.Sketches {
			l = e.Size()
			n += 1 + l + sovProcessors(uint64(l))
		}
	}
	n += 1 + sovProcessors(uint64(m.SampleSize))
	if len(m.SampledColumnIDs) > 0 {
		for _, e := range m.SampledColumnIDs {
			n += 1 + sovProcessors(uint64(e))
		}
	}
	n += 1 + sovProcessors(uint64(m.TableID))
	return n
}

func (m *InterleavedReaderJoinerSpec) Size() (n int) {
	var l int
	_ = l
	if len(m.Tables) > 0 {
		for _, e := range m.Tables {
			l = e.Size()
			n += 1 + l + sovProcessors(uint64(l))
		}
	}
	n += 2
	n += 1 + sovProcessors(uint64(m.LimitHint))
	l = m.OnExpr.Size()
	n += 1 + l + sovProcessors(uint64(l))
	n += 1 + sovProcessors(uint64(m.Type))
	return n
}

func (m *InterleavedReaderJoinerSpec_Table) Size() (n int) {
	var l int
	_ = l
	l = m.Desc.Size()
	n += 1 + l + sovProcessors(uint64(l))
	n += 1 + sovProcessors(uint64(m.IndexIdx))
	l = m.Post.Size()
	n += 1 + l + sovProcessors(uint64(l))
	l = m.Ordering.Size()
	n += 1 + l + sovProcessors(uint64(l))
	if len(m.Spans) > 0 {
		for _, e := range m.Spans {
			l = e.Size()
			n += 1 + l + sovProcessors(uint64(l))
		}
	}
	return n
}

func (m *ProjectSetSpec) Size() (n int) {
	var l int
	_ = l
	if len(m.Exprs) > 0 {
		for _, e := range m.Exprs {
			l = e.Size()
			n += 1 + l + sovProcessors(uint64(l))
		}
	}
	if len(m.GeneratedColumns) > 0 {
		for _, e := range m.GeneratedColumns {
			l = e.Size()
			n += 1 + l + sovProcessors(uint64(l))
		}
	}
	if len(m.NumColsPerGen) > 0 {
		for _, e := range m.NumColsPerGen {
			n += 1 + sovProcessors(uint64(e))
		}
	}
	return n
}

func (m *WindowerSpec) Size() (n int) {
	var l int
	_ = l
	if len(m.PartitionBy) > 0 {
		for _, e := range m.PartitionBy {
			n += 1 + sovProcessors(uint64(e))
		}
	}
	if len(m.WindowFns) > 0 {
		for _, e := range m.WindowFns {
			l = e.Size()
			n += 1 + l + sovProcessors(uint64(l))
		}
	}
	return n
}

func (m *WindowerSpec_Func) Size() (n int) {
	var l int
	_ = l
	if m.AggregateFunc != nil {
		n += 1 + sovProcessors(uint64(*m.AggregateFunc))
	}
	if m.WindowFunc != nil {
		n += 1 + sovProcessors(uint64(*m.WindowFunc))
	}
	return n
}

func (m *WindowerSpec_Frame) Size() (n int) {
	var l int
	_ = l
	n += 1 + sovProcessors(uint64(m.Mode))
	l = m.Bounds.Size()
	n += 1 + l + sovProcessors(uint64(l))
	return n
}

func (m *WindowerSpec_Frame_Bound) Size() (n int) {
	var l int
	_ = l
	n += 1 + sovProcessors(uint64(m.BoundType))
	n += 1 + sovProcessors(uint64(m.IntOffset))
	if m.TypedOffset != nil {
		l = len(m.TypedOffset)
		n += 1 + l + sovProcessors(uint64(l))
	}
	l = m.OffsetType.Size()
	n += 1 + l + sovProcessors(uint64(l))
	return n
}

func (m *WindowerSpec_Frame_Bounds) Size() (n int) {
	var l int
	_ = l
	l = m.Start.Size()
	n += 1 + l + sovProcessors(uint64(l))
	if m.End != nil {
		l = m.End.Size()
		n += 1 + l + sovProcessors(uint64(l))
	}
	return n
}

func (m *WindowerSpec_WindowFn) Size() (n int) {
	var l int
	_ = l
	l = m.Func.Size()
	n += 1 + l + sovProcessors(uint64(l))
	n += 1 + sovProcessors(uint64(m.ArgIdxStart))
	n += 1 + sovProcessors(uint64(m.ArgCount))
	l = m.Ordering.Size()
	n += 1 + l + sovProcessors(uint64(l))
	if m.Frame != nil {
		l = m.Frame.Size()
		n += 1 + l + sovProcessors(uint64(l))
	}
	n += 1 + sovProcessors(uint64(m.FilterColIdx))
	return n
}

func (m *ChangeAggregatorSpec) Size() (n int) {
	var l int
	_ = l
	if len(m.Watches) > 0 {
		for _, e := range m.Watches {
			l = e.Size()
			n += 1 + l + sovProcessors(uint64(l))
		}
	}
	l = m.Feed.Size()
	n += 1 + l + sovProcessors(uint64(l))
	return n
}

func (m *ChangeAggregatorSpec_Watch) Size() (n int) {
	var l int
	_ = l
	l = m.InitialResolved.Size()
	n += 1 + l + sovProcessors(uint64(l))
	l = m.Span.Size()
	n += 1 + l + sovProcessors(uint64(l))
	return n
}

func (m *ChangeFrontierSpec) Size() (n int) {
	var l int
	_ = l
	if len(m.TrackedSpans) > 0 {
		for _, e := range m.TrackedSpans {
			l = e.Size()
			n += 1 + l + sovProcessors(uint64(l))
		}
	}
	l = m.Feed.Size()
	n += 1 + l + sovProcessors(uint64(l))
	n += 1 + sovProcessors(uint64(m.JobID))
	return n
}

func sovProcessors(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozProcessors(x uint64) (n int) {
	return sovProcessors(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *ProcessorCoreUnion) GetValue() interface{} {
	if this.Noop != nil {
		return this.Noop
	}
	if this.TableReader != nil {
		return this.TableReader
	}
	if this.JoinReader != nil {
		return this.JoinReader
	}
	if this.Sorter != nil {
		return this.Sorter
	}
	if this.Aggregator != nil {
		return this.Aggregator
	}
	if this.Distinct != nil {
		return this.Distinct
	}
	if this.MergeJoiner != nil {
		return this.MergeJoiner
	}
	if this.HashJoiner != nil {
		return this.HashJoiner
	}
	if this.Values != nil {
		return this.Values
	}
	if this.Backfiller != nil {
		return this.Backfiller
	}
	if this.ReadImport != nil {
		return this.ReadImport
	}
	if this.SSTWriter != nil {
		return this.SSTWriter
	}
	if this.Sampler != nil {
		return this.Sampler
	}
	if this.SampleAggregator != nil {
		return this.SampleAggregator
	}
	if this.InterleavedReaderJoiner != nil {
		return this.InterleavedReaderJoiner
	}
	if this.MetadataTestSender != nil {
		return this.MetadataTestSender
	}
	if this.MetadataTestReceiver != nil {
		return this.MetadataTestReceiver
	}
	if this.CSVWriter != nil {
		return this.CSVWriter
	}
	if this.ZigzagJoiner != nil {
		return this.ZigzagJoiner
	}
	if this.ProjectSet != nil {
		return this.ProjectSet
	}
	if this.Windower != nil {
		return this.Windower
	}
	if this.LocalPlanNode != nil {
		return this.LocalPlanNode
	}
	if this.ChangeAggregator != nil {
		return this.ChangeAggregator
	}
	if this.ChangeFrontier != nil {
		return this.ChangeFrontier
	}
	return nil
}

func (this *ProcessorCoreUnion) SetValue(value interface{}) bool {
	switch vt := value.(type) {
	case *NoopCoreSpec:
		this.Noop = vt
	case *TableReaderSpec:
		this.TableReader = vt
	case *JoinReaderSpec:
		this.JoinReader = vt
	case *SorterSpec:
		this.Sorter = vt
	case *AggregatorSpec:
		this.Aggregator = vt
	case *DistinctSpec:
		this.Distinct = vt
	case *MergeJoinerSpec:
		this.MergeJoiner = vt
	case *HashJoinerSpec:
		this.HashJoiner = vt
	case *ValuesCoreSpec:
		this.Values = vt
	case *BackfillerSpec:
		this.Backfiller = vt
	case *ReadImportDataSpec:
		this.ReadImport = vt
	case *SSTWriterSpec:
		this.SSTWriter = vt
	case *SamplerSpec:
		this.Sampler = vt
	case *SampleAggregatorSpec:
		this.SampleAggregator = vt
	case *InterleavedReaderJoinerSpec:
		this.InterleavedReaderJoiner = vt
	case *MetadataTestSenderSpec:
		this.MetadataTestSender = vt
	case *MetadataTestReceiverSpec:
		this.MetadataTestReceiver = vt
	case *CSVWriterSpec:
		this.CSVWriter = vt
	case *ZigzagJoinerSpec:
		this.ZigzagJoiner = vt
	case *ProjectSetSpec:
		this.ProjectSet = vt
	case *WindowerSpec:
		this.Windower = vt
	case *LocalPlanNodeSpec:
		this.LocalPlanNode = vt
	case *ChangeAggregatorSpec:
		this.ChangeAggregator = vt
	case *ChangeFrontierSpec:
		this.ChangeFrontier = vt
	default:
		return false
	}
	return true
}
func (this *WindowerSpec_Func) GetValue() interface{} {
	if this.AggregateFunc != nil {
		return this.AggregateFunc
	}
	if this.WindowFunc != nil {
		return this.WindowFunc
	}
	return nil
}

func (this *WindowerSpec_Func) SetValue(value interface{}) bool {
	switch vt := value.(type) {
	case *AggregatorSpec_Func:
		this.AggregateFunc = vt
	case *WindowerSpec_WindowFunc:
		this.WindowFunc = vt
	default:
		return false
	}
	return true
}
func (m *ProcessorSpec) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProcessors
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ProcessorSpec: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ProcessorSpec: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Input", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Input = append(m.Input, InputSyncSpec{})
			if err := m.Input[len(m.Input)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Core", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Core.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Output", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Output = append(m.Output, OutputRouterSpec{})
			if err := m.Output[len(m.Output)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Post", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Post.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StageID", wireType)
			}
			m.StageID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StageID |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProcessorID", wireType)
			}
			m.ProcessorID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ProcessorID |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipProcessors(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthProcessors
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PostProcessSpec) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProcessors
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PostProcessSpec: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PostProcessSpec: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Filter", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Filter.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Projection", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Projection = bool(v != 0)
		case 3:
			if wireType == 0 {
				var v uint32
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowProcessors
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= (uint32(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.OutputColumns = append(m.OutputColumns, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowProcessors
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthProcessors
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v uint32
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowProcessors
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= (uint32(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.OutputColumns = append(m.OutputColumns, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field OutputColumns", wireType)
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RenderExprs", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RenderExprs = append(m.RenderExprs, Expression{})
			if err := m.RenderExprs[len(m.RenderExprs)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Offset", wireType)
			}
			m.Offset = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Offset |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Limit", wireType)
			}
			m.Limit = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Limit |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipProcessors(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthProcessors
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ProcessorCoreUnion) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProcessors
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ProcessorCoreUnion: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ProcessorCoreUnion: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Noop", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Noop == nil {
				m.Noop = &NoopCoreSpec{}
			}
			if err := m.Noop.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TableReader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TableReader == nil {
				m.TableReader = &TableReaderSpec{}
			}
			if err := m.TableReader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field JoinReader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.JoinReader == nil {
				m.JoinReader = &JoinReaderSpec{}
			}
			if err := m.JoinReader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Sorter", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Sorter == nil {
				m.Sorter = &SorterSpec{}
			}
			if err := m.Sorter.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Aggregator", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Aggregator == nil {
				m.Aggregator = &AggregatorSpec{}
			}
			if err := m.Aggregator.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Distinct", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Distinct == nil {
				m.Distinct = &DistinctSpec{}
			}
			if err := m.Distinct.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MergeJoiner", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.MergeJoiner == nil {
				m.MergeJoiner = &MergeJoinerSpec{}
			}
			if err := m.MergeJoiner.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HashJoiner", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.HashJoiner == nil {
				m.HashJoiner = &HashJoinerSpec{}
			}
			if err := m.HashJoiner.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Values", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Values == nil {
				m.Values = &ValuesCoreSpec{}
			}
			if err := m.Values.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Backfiller", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Backfiller == nil {
				m.Backfiller = &BackfillerSpec{}
			}
			if err := m.Backfiller.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReadImport", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ReadImport == nil {
				m.ReadImport = &ReadImportDataSpec{}
			}
			if err := m.ReadImport.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 14:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SSTWriter", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SSTWriter == nil {
				m.SSTWriter = &SSTWriterSpec{}
			}
			if err := m.SSTWriter.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 15:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Sampler", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Sampler == nil {
				m.Sampler = &SamplerSpec{}
			}
			if err := m.Sampler.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 16:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SampleAggregator", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SampleAggregator == nil {
				m.SampleAggregator = &SampleAggregatorSpec{}
			}
			if err := m.SampleAggregator.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 17:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field InterleavedReaderJoiner", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.InterleavedReaderJoiner == nil {
				m.InterleavedReaderJoiner = &InterleavedReaderJoinerSpec{}
			}
			if err := m.InterleavedReaderJoiner.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 18:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MetadataTestSender", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.MetadataTestSender == nil {
				m.MetadataTestSender = &MetadataTestSenderSpec{}
			}
			if err := m.MetadataTestSender.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 19:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MetadataTestReceiver", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.MetadataTestReceiver == nil {
				m.MetadataTestReceiver = &MetadataTestReceiverSpec{}
			}
			if err := m.MetadataTestReceiver.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 20:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CSVWriter", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CSVWriter == nil {
				m.CSVWriter = &CSVWriterSpec{}
			}
			if err := m.CSVWriter.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 21:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ZigzagJoiner", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ZigzagJoiner == nil {
				m.ZigzagJoiner = &ZigzagJoinerSpec{}
			}
			if err := m.ZigzagJoiner.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 22:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProjectSet", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ProjectSet == nil {
				m.ProjectSet = &ProjectSetSpec{}
			}
			if err := m.ProjectSet.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 23:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Windower", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Windower == nil {
				m.Windower = &WindowerSpec{}
			}
			if err := m.Windower.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 24:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LocalPlanNode", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.LocalPlanNode == nil {
				m.LocalPlanNode = &LocalPlanNodeSpec{}
			}
			if err := m.LocalPlanNode.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 25:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ChangeAggregator", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ChangeAggregator == nil {
				m.ChangeAggregator = &ChangeAggregatorSpec{}
			}
			if err := m.ChangeAggregator.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 26:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ChangeFrontier", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ChangeFrontier == nil {
				m.ChangeFrontier = &ChangeFrontierSpec{}
			}
			if err := m.ChangeFrontier.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProcessors(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthProcessors
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *NoopCoreSpec) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProcessors
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NoopCoreSpec: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NoopCoreSpec: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipProcessors(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthProcessors
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MetadataTestSenderSpec) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProcessors
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MetadataTestSenderSpec: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MetadataTestSenderSpec: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ID = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProcessors(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthProcessors
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MetadataTestReceiverSpec) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProcessors
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MetadataTestReceiverSpec: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MetadataTestReceiverSpec: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SenderIDs", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SenderIDs = append(m.SenderIDs, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProcessors(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthProcessors
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ValuesCoreSpec) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProcessors
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ValuesCoreSpec: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ValuesCoreSpec: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Columns", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Columns = append(m.Columns, DatumInfo{})
			if err := m.Columns[len(m.Columns)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RawBytes", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RawBytes = append(m.RawBytes, make([]byte, postIndex-iNdEx))
			copy(m.RawBytes[len(m.RawBytes)-1], dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NumRows", wireType)
			}
			m.NumRows = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NumRows |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipProcessors(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthProcessors
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TableReaderSpan) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProcessors
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TableReaderSpan: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TableReaderSpan: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Span", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Span.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProcessors(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthProcessors
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TableReaderSpec) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProcessors
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TableReaderSpec: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TableReaderSpec: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Table", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Table.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IndexIdx", wireType)
			}
			m.IndexIdx = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.IndexIdx |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Reverse", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Reverse = bool(v != 0)
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Spans", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Spans = append(m.Spans, TableReaderSpan{})
			if err := m.Spans[len(m.Spans)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LimitHint", wireType)
			}
			m.LimitHint = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LimitHint |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsCheck", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IsCheck = bool(v != 0)
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Visibility", wireType)
			}
			m.Visibility = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Visibility |= (ScanVisibility(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipProcessors(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthProcessors
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *JoinReaderSpec) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProcessors
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: JoinReaderSpec: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: JoinReaderSpec: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Table", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Table.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IndexIdx", wireType)
			}
			m.IndexIdx = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.IndexIdx |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType == 0 {
				var v uint32
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowProcessors
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= (uint32(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.LookupColumns = append(m.LookupColumns, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowProcessors
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthProcessors
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v uint32
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowProcessors
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= (uint32(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.LookupColumns = append(m.LookupColumns, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field LookupColumns", wireType)
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OnExpr", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.OnExpr.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field IndexFilterExpr", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.IndexFilterExpr.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			m.Type = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Type |= (cockroach_sql_sqlbase3.JoinType(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Visibility", wireType)
			}
			m.Visibility = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Visibility |= (ScanVisibility(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipProcessors(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthProcessors
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SorterSpec) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProcessors
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SorterSpec: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SorterSpec: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OutputOrdering", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.OutputOrdering.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field OrderingMatchLen", wireType)
			}
			m.OrderingMatchLen = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.OrderingMatchLen |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipProcessors(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthProcessors
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DistinctSpec) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProcessors
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DistinctSpec: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DistinctSpec: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType == 0 {
				var v uint32
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowProcessors
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= (uint32(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.OrderedColumns = append(m.OrderedColumns, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowProcessors
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthProcessors
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v uint32
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowProcessors
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= (uint32(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.OrderedColumns = append(m.OrderedColumns, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field OrderedColumns", wireType)
			}
		case 2:
			if wireType == 0 {
				var v uint32
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowProcessors
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= (uint32(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.DistinctColumns = append(m.DistinctColumns, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowProcessors
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthProcessors
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v uint32
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowProcessors
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= (uint32(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.DistinctColumns = append(m.DistinctColumns, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field DistinctColumns", wireType)
			}
		default:
			iNdEx = preIndex
			skippy, err := skipProcessors(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthProcessors
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ZigzagJoinerSpec) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProcessors
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ZigzagJoinerSpec: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ZigzagJoinerSpec: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Tables", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Tables = append(m.Tables, cockroach_sql_sqlbase1.TableDescriptor{})
			if err := m.Tables[len(m.Tables)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EqColumns", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.EqColumns = append(m.EqColumns, Columns{})
			if err := m.EqColumns[len(m.EqColumns)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType == 0 {
				var v uint32
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowProcessors
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= (uint32(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.IndexIds = append(m.IndexIds, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowProcessors
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthProcessors
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v uint32
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowProcessors
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= (uint32(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.IndexIds = append(m.IndexIds, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field IndexIds", wireType)
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OnExpr", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.OnExpr.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			m.Type = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Type |= (cockroach_sql_sqlbase3.JoinType(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipProcessors(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthProcessors
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LocalPlanNodeSpec) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProcessors
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LocalPlanNodeSpec: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LocalPlanNodeSpec: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RowSourceIdx", wireType)
			}
			var v uint32
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.RowSourceIdx = &v
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NumInputs", wireType)
			}
			var v uint32
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.NumInputs = &v
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Name = &s
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProcessors(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthProcessors
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Columns) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProcessors
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Columns: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Columns: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType == 0 {
				var v uint32
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowProcessors
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= (uint32(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.Columns = append(m.Columns, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowProcessors
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthProcessors
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v uint32
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowProcessors
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= (uint32(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.Columns = append(m.Columns, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field Columns", wireType)
			}
		default:
			iNdEx = preIndex
			skippy, err := skipProcessors(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthProcessors
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MergeJoinerSpec) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProcessors
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MergeJoinerSpec: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MergeJoinerSpec: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LeftOrdering", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.LeftOrdering.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RightOrdering", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.RightOrdering.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OnExpr", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.OnExpr.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			m.Type = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Type |= (cockroach_sql_sqlbase3.JoinType(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NullEquality", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.NullEquality = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipProcessors(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthProcessors
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *HashJoinerSpec) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProcessors
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HashJoinerSpec: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HashJoinerSpec: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType == 0 {
				var v uint32
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowProcessors
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= (uint32(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.LeftEqColumns = append(m.LeftEqColumns, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowProcessors
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthProcessors
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v uint32
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowProcessors
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= (uint32(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.LeftEqColumns = append(m.LeftEqColumns, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field LeftEqColumns", wireType)
			}
		case 2:
			if wireType == 0 {
				var v uint32
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowProcessors
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= (uint32(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.RightEqColumns = append(m.RightEqColumns, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowProcessors
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthProcessors
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v uint32
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowProcessors
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= (uint32(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.RightEqColumns = append(m.RightEqColumns, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field RightEqColumns", wireType)
			}
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OnExpr", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.OnExpr.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			m.Type = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Type |= (cockroach_sql_sqlbase3.JoinType(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MergedColumns", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.MergedColumns = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipProcessors(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthProcessors
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AggregatorSpec) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProcessors
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AggregatorSpec: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AggregatorSpec: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 2:
			if wireType == 0 {
				var v uint32
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowProcessors
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= (uint32(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.GroupCols = append(m.GroupCols, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowProcessors
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthProcessors
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v uint32
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowProcessors
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= (uint32(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.GroupCols = append(m.GroupCols, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field GroupCols", wireType)
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Aggregations", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Aggregations = append(m.Aggregations, AggregatorSpec_Aggregation{})
			if err := m.Aggregations[len(m.Aggregations)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType == 0 {
				var v uint32
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowProcessors
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= (uint32(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.OrderedGroupCols = append(m.OrderedGroupCols, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowProcessors
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthProcessors
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v uint32
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowProcessors
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= (uint32(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.OrderedGroupCols = append(m.OrderedGroupCols, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field OrderedGroupCols", wireType)
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			m.Type = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Type |= (AggregatorSpec_Type(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipProcessors(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthProcessors
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AggregatorSpec_Aggregation) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProcessors
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Aggregation: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Aggregation: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Func", wireType)
			}
			m.Func = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Func |= (AggregatorSpec_Func(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Distinct", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Distinct = bool(v != 0)
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field FilterColIdx", wireType)
			}
			var v uint32
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.FilterColIdx = &v
		case 5:
			if wireType == 0 {
				var v uint32
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowProcessors
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= (uint32(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.ColIdx = append(m.ColIdx, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowProcessors
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthProcessors
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v uint32
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowProcessors
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= (uint32(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.ColIdx = append(m.ColIdx, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field ColIdx", wireType)
			}
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Arguments", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Arguments = append(m.Arguments, Expression{})
			if err := m.Arguments[len(m.Arguments)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProcessors(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthProcessors
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *BackfillerSpec) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProcessors
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: BackfillerSpec: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: BackfillerSpec: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			m.Type = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Type |= (BackfillerSpec_Type(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Table", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Table.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Spans", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Spans = append(m.Spans, TableReaderSpan{})
			if err := m.Spans[len(m.Spans)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Duration", wireType)
			}
			m.Duration = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Duration |= (time.Duration(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ChunkSize", wireType)
			}
			m.ChunkSize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ChunkSize |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OtherTables", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.OtherTables = append(m.OtherTables, cockroach_sql_sqlbase1.TableDescriptor{})
			if err := m.OtherTables[len(m.OtherTables)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReadAsOf", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ReadAsOf.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProcessors(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthProcessors
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *FlowSpec) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProcessors
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: FlowSpec: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: FlowSpec: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FlowID", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.FlowID.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Processors", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Processors = append(m.Processors, ProcessorSpec{})
			if err := m.Processors[len(m.Processors)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Gateway", wireType)
			}
			m.Gateway = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Gateway |= (github_com_cockroachdb_cockroach_pkg_roachpb.NodeID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipProcessors(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthProcessors
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *JobProgress) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProcessors
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: JobProgress: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: JobProgress: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field JobID", wireType)
			}
			m.JobID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.JobID |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 5 {
				return fmt.Errorf("proto: wrong wireType = %d for field Contribution", wireType)
			}
			var v uint32
			if (iNdEx + 4) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint32(binary.LittleEndian.Uint32(dAtA[iNdEx:]))
			iNdEx += 4
			m.Contribution = float32(math.Float32frombits(v))
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Slot", wireType)
			}
			m.Slot = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Slot |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipProcessors(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthProcessors
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ReadImportDataSpec) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProcessors
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ReadImportDataSpec: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ReadImportDataSpec: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SampleSize", wireType)
			}
			m.SampleSize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.SampleSize |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Progress", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Progress.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Uri", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Uri == nil {
				m.Uri = make(map[int32]string)
			}
			var mapkey int32
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowProcessors
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowProcessors
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapkey |= (int32(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowProcessors
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthProcessors
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipProcessors(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthProcessors
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Uri[mapkey] = mapvalue
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Format", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Format.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Tables", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Tables == nil {
				m.Tables = make(map[string]*cockroach_sql_sqlbase1.TableDescriptor)
			}
			var mapkey string
			var mapvalue *cockroach_sql_sqlbase1.TableDescriptor
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowProcessors
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowProcessors
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthProcessors
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowProcessors
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= (int(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthProcessors
					}
					postmsgIndex := iNdEx + mapmsglen
					if mapmsglen < 0 {
						return ErrInvalidLengthProcessors
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &cockroach_sql_sqlbase1.TableDescriptor{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipProcessors(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthProcessors
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Tables[mapkey] = mapvalue
			iNdEx = postIndex
		case 10:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SkipMissingForeignKeys", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.SkipMissingForeignKeys = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipProcessors(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthProcessors
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SSTWriterSpec) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProcessors
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SSTWriterSpec: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SSTWriterSpec: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Destination", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Destination = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field WalltimeNanos", wireType)
			}
			m.WalltimeNanos = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.WalltimeNanos |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Spans", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Spans = append(m.Spans, SSTWriterSpec_SpanName{})
			if err := m.Spans[len(m.Spans)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Progress", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Progress.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProcessors(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthProcessors
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SSTWriterSpec_SpanName) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProcessors
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SpanName: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SpanName: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field End", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.End = append(m.End[:0], dAtA[iNdEx:postIndex]...)
			if m.End == nil {
				m.End = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProcessors(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthProcessors
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CSVWriterSpec) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProcessors
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CSVWriterSpec: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CSVWriterSpec: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Destination", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Destination = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NamePattern", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NamePattern = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Options", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Options.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ChunkRows", wireType)
			}
			m.ChunkRows = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ChunkRows |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipProcessors(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthProcessors
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SketchSpec) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProcessors
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SketchSpec: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SketchSpec: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SketchType", wireType)
			}
			m.SketchType = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.SketchType |= (SketchType(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType == 0 {
				var v uint32
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowProcessors
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= (uint32(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.Columns = append(m.Columns, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowProcessors
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthProcessors
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v uint32
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowProcessors
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= (uint32(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.Columns = append(m.Columns, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field Columns", wireType)
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field GenerateHistogram", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.GenerateHistogram = bool(v != 0)
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field HistogramMaxBuckets", wireType)
			}
			m.HistogramMaxBuckets = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.HistogramMaxBuckets |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StatName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.StatName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProcessors(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthProcessors
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SamplerSpec) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProcessors
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SamplerSpec: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SamplerSpec: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Sketches", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Sketches = append(m.Sketches, SketchSpec{})
			if err := m.Sketches[len(m.Sketches)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SampleSize", wireType)
			}
			m.SampleSize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.SampleSize |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipProcessors(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthProcessors
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SampleAggregatorSpec) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProcessors
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SampleAggregatorSpec: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SampleAggregatorSpec: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Sketches", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Sketches = append(m.Sketches, SketchSpec{})
			if err := m.Sketches[len(m.Sketches)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SampleSize", wireType)
			}
			m.SampleSize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.SampleSize |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType == 0 {
				var v github_com_cockroachdb_cockroach_pkg_sql_sqlbase.ColumnID
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowProcessors
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= (github_com_cockroachdb_cockroach_pkg_sql_sqlbase.ColumnID(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.SampledColumnIDs = append(m.SampledColumnIDs, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowProcessors
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthProcessors
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v github_com_cockroachdb_cockroach_pkg_sql_sqlbase.ColumnID
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowProcessors
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= (github_com_cockroachdb_cockroach_pkg_sql_sqlbase.ColumnID(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.SampledColumnIDs = append(m.SampledColumnIDs, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field SampledColumnIDs", wireType)
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TableID", wireType)
			}
			m.TableID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TableID |= (github_com_cockroachdb_cockroach_pkg_sql_sqlbase.ID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipProcessors(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthProcessors
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *InterleavedReaderJoinerSpec) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProcessors
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: InterleavedReaderJoinerSpec: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: InterleavedReaderJoinerSpec: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Tables", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Tables = append(m.Tables, InterleavedReaderJoinerSpec_Table{})
			if err := m.Tables[len(m.Tables)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Reverse", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Reverse = bool(v != 0)
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LimitHint", wireType)
			}
			m.LimitHint = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LimitHint |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OnExpr", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.OnExpr.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			m.Type = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Type |= (cockroach_sql_sqlbase3.JoinType(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipProcessors(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthProcessors
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *InterleavedReaderJoinerSpec_Table) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProcessors
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Table: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Table: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Desc", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Desc.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IndexIdx", wireType)
			}
			m.IndexIdx = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.IndexIdx |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Post", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Post.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Ordering", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Ordering.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Spans", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Spans = append(m.Spans, TableReaderSpan{})
			if err := m.Spans[len(m.Spans)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProcessors(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthProcessors
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ProjectSetSpec) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProcessors
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ProjectSetSpec: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ProjectSetSpec: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Exprs", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Exprs = append(m.Exprs, Expression{})
			if err := m.Exprs[len(m.Exprs)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field GeneratedColumns", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.GeneratedColumns = append(m.GeneratedColumns, cockroach_sql_sqlbase1.ColumnType{})
			if err := m.GeneratedColumns[len(m.GeneratedColumns)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType == 0 {
				var v uint32
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowProcessors
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= (uint32(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.NumColsPerGen = append(m.NumColsPerGen, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowProcessors
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthProcessors
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v uint32
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowProcessors
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= (uint32(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.NumColsPerGen = append(m.NumColsPerGen, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field NumColsPerGen", wireType)
			}
		default:
			iNdEx = preIndex
			skippy, err := skipProcessors(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthProcessors
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *WindowerSpec) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProcessors
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: WindowerSpec: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: WindowerSpec: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType == 0 {
				var v uint32
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowProcessors
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= (uint32(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.PartitionBy = append(m.PartitionBy, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowProcessors
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthProcessors
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v uint32
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowProcessors
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= (uint32(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.PartitionBy = append(m.PartitionBy, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field PartitionBy", wireType)
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WindowFns", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.WindowFns = append(m.WindowFns, WindowerSpec_WindowFn{})
			if err := m.WindowFns[len(m.WindowFns)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProcessors(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthProcessors
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *WindowerSpec_Func) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProcessors
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Func: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Func: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field AggregateFunc", wireType)
			}
			var v AggregatorSpec_Func
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (AggregatorSpec_Func(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.AggregateFunc = &v
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field WindowFunc", wireType)
			}
			var v WindowerSpec_WindowFunc
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (WindowerSpec_WindowFunc(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.WindowFunc = &v
		default:
			iNdEx = preIndex
			skippy, err := skipProcessors(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthProcessors
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *WindowerSpec_Frame) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProcessors
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Frame: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Frame: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Mode", wireType)
			}
			m.Mode = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Mode |= (WindowerSpec_Frame_Mode(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Bounds", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Bounds.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProcessors(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthProcessors
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *WindowerSpec_Frame_Bound) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProcessors
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Bound: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Bound: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field BoundType", wireType)
			}
			m.BoundType = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.BoundType |= (WindowerSpec_Frame_BoundType(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IntOffset", wireType)
			}
			m.IntOffset = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.IntOffset |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TypedOffset", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TypedOffset = append(m.TypedOffset[:0], dAtA[iNdEx:postIndex]...)
			if m.TypedOffset == nil {
				m.TypedOffset = []byte{}
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OffsetType", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.OffsetType.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProcessors(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthProcessors
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *WindowerSpec_Frame_Bounds) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProcessors
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Bounds: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Bounds: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Start", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Start.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field End", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.End == nil {
				m.End = &WindowerSpec_Frame_Bound{}
			}
			if err := m.End.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProcessors(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthProcessors
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *WindowerSpec_WindowFn) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProcessors
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: WindowFn: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: WindowFn: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Func", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Func.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ArgIdxStart", wireType)
			}
			m.ArgIdxStart = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ArgIdxStart |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ArgCount", wireType)
			}
			m.ArgCount = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ArgCount |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Ordering", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Ordering.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Frame", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Frame == nil {
				m.Frame = &WindowerSpec_Frame{}
			}
			if err := m.Frame.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field FilterColIdx", wireType)
			}
			m.FilterColIdx = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.FilterColIdx |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipProcessors(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthProcessors
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ChangeAggregatorSpec) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProcessors
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ChangeAggregatorSpec: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ChangeAggregatorSpec: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Watches", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Watches = append(m.Watches, ChangeAggregatorSpec_Watch{})
			if err := m.Watches[len(m.Watches)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Feed", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Feed.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProcessors(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthProcessors
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ChangeAggregatorSpec_Watch) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProcessors
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Watch: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Watch: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field InitialResolved", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.InitialResolved.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Span", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Span.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProcessors(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthProcessors
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ChangeFrontierSpec) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProcessors
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ChangeFrontierSpec: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ChangeFrontierSpec: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TrackedSpans", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TrackedSpans = append(m.TrackedSpans, cockroach_roachpb1.Span{})
			if err := m.TrackedSpans[len(m.TrackedSpans)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Feed", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Feed.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field JobID", wireType)
			}
			m.JobID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.JobID |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipProcessors(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthProcessors
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipProcessors(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowProcessors
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthProcessors
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowProcessors
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipProcessors(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthProcessors = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowProcessors   = fmt.Errorf("proto: integer overflow")
)

func init() { proto.RegisterFile("sql/distsqlrun/processors.proto", fileDescriptorProcessors) }

var fileDescriptorProcessors = []byte{
	// 3990 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xc4, 0x5a, 0x4d, 0x6c, 0x1b, 0x49,
	0x76, 0x36, 0x9b, 0xcd, 0xbf, 0xc7, 0x1f, 0xb5, 0x6b, 0xe4, 0x31, 0x47, 0x33, 0xb1, 0xec, 0x5e,
	0xef, 0xf8, 0x67, 0x67, 0xa5, 0xb1, 0x67, 0x76, 0x32, 0x3b, 0xbb, 0x8b, 0x19, 0xfe, 0x4a, 0x94,
	0x29, 0x52, 0x6e, 0x92, 0xf2, 0xce, 0x1c, 0xd2, 0x69, 0xb2, 0x4b, 0x54, 0x5b, 0xcd, 0x2e, 0xba,
	0xbb, 0x69, 0x49, 0x46, 0x80, 0x9c, 0x82, 0x00, 0xb9, 0x24, 0xc0, 0x1e, 0x72, 0x0b, 0xf6, 0xb2,
	0xe7, 0x5c, 0x72, 0xc8, 0x29, 0xc0, 0x02, 0x41, 0x30, 0xc8, 0x25, 0xc9, 0x6d, 0x11, 0x04, 0x46,
	0xe2, 0x3d, 0x04, 0xb9, 0xe4, 0x16, 0x04, 0x98, 0x43, 0xb2, 0xa8, 0x9f, 0x6e, 0x36, 0xf5, 0x47,
	0xd1, 0x1e, 0xec, 0x5e, 0x24, 0xf6, 0xfb, 0xf9, 0xba, 0xea, 0xd5, 0xab, 0x57, 0xef, 0xbd, 0x6a,
	0x58, 0xf5, 0x9e, 0xd9, 0xeb, 0xa6, 0xe5, 0xf9, 0xde, 0x33, 0xdb, 0x9d, 0x38, 0xeb, 0x63, 0x97,
	0x0c, 0xb0, 0xe7, 0x11, 0xd7, 0x5b, 0x1b, 0xbb, 0xc4, 0x27, 0xa8, 0x38, 0x20, 0x83, 0x03, 0x97,
	0x18, 0x83, 0xfd, 0x35, 0xef, 0x99, 0xbd, 0x36, 0x15, 0x5d, 0x79, 0xfb, 0x29, 0xe9, 0x7b, 0xeb,
	0xf4, 0xcf, 0xb8, 0xcf, 0xfe, 0x71, 0x8d, 0x95, 0xab, 0x4c, 0x7a, 0xdc, 0x5f, 0x37, 0xc6, 0x96,
	0x20, 0xa1, 0x80, 0x64, 0x1a, 0xbe, 0x21, 0x68, 0xcb, 0x01, 0x0d, 0xbb, 0x6e, 0xf8, 0xba, 0x95,
	0x62, 0x40, 0xb5, 0xc8, 0xf7, 0xf7, 0x88, 0x3b, 0x32, 0xfc, 0x80, 0xf3, 0x1e, 0x1d, 0xa9, 0xf7,
	0xcc, 0xee, 0x1b, 0x1e, 0x5e, 0xf7, 0x7c, 0x77, 0x32, 0xf0, 0x27, 0x2e, 0x36, 0x05, 0x77, 0x35,
	0xca, 0xc5, 0xce, 0x80, 0x98, 0xd8, 0xd4, 0x4d, 0xc3, 0x9f, 0x8c, 0x84, 0xc0, 0xbb, 0x51, 0x81,
	0xa7, 0xc4, 0x72, 0x74, 0xff, 0x78, 0x8c, 0x05, 0xf3, 0x9d, 0x13, 0x56, 0x88, 0x0c, 0xb3, 0x38,
	0xf1, 0x2d, 0x7b, 0x7d, 0xdf, 0x1e, 0xac, 0xfb, 0xd6, 0x08, 0x7b, 0xbe, 0x31, 0x1a, 0x07, 0x13,
	0x18, 0x92, 0x21, 0x61, 0x3f, 0xd7, 0xe9, 0x2f, 0x4e, 0x55, 0xff, 0x3c, 0x0e, 0xf9, 0x9d, 0xc0,
	0x88, 0x9d, 0x31, 0x1e, 0xa0, 0x0a, 0x24, 0x2c, 0x67, 0x3c, 0xf1, 0x8b, 0xb1, 0x9b, 0xf1, 0xbb,
	0xd9, 0x87, 0x77, 0xd6, 0xce, 0xb3, 0xe8, 0x5a, 0x83, 0x8a, 0x75, 0x8e, 0x9d, 0x01, 0xd5, 0x2b,
	0xcb, 0x5f, 0xbf, 0x5c, 0xbd, 0xa2, 0x71, 0x5d, 0x54, 0x07, 0x79, 0x40, 0x5c, 0x5c, 0x94, 0x6e,
	0xc6, 0xee, 0x66, 0x1f, 0x7e, 0x70, 0x3e, 0x46, 0xf8, 0xee, 0x0a, 0x71, 0x71, 0xcf, 0xb1, 0x88,
	0x23, 0x80, 0x98, 0x3e, 0xda, 0x84, 0x24, 0x99, 0xf8, 0x74, 0x34, 0x71, 0x36, 0x9a, 0xfb, 0xe7,
	0x23, 0xb5, 0x99, 0x9c, 0x46, 0x26, 0x3e, 0x76, 0x23, 0x03, 0x12, 0xfa, 0xa8, 0x02, 0xf2, 0x98,
	0x78, 0x7e, 0x51, 0x66, 0x23, 0xba, 0x77, 0xc1, 0x88, 0x88, 0xe7, 0x8b, 0x51, 0x45, 0x60, 0x98,
	0x32, 0xba, 0x0f, 0x69, 0xcf, 0x37, 0x86, 0x58, 0xb7, 0xcc, 0x62, 0xe2, 0x66, 0xec, 0x6e, 0xa2,
	0xbc, 0x44, 0xb9, 0xaf, 0x5e, 0xae, 0xa6, 0x3a, 0x94, 0xde, 0xa8, 0x6a, 0x29, 0x26, 0xd0, 0x30,
	0xd1, 0x27, 0x90, 0x0b, 0xbd, 0x93, 0xca, 0x27, 0x99, 0xfc, 0x5b, 0x42, 0x3e, 0x1b, 0x4e, 0xbc,
	0x51, 0xd5, 0xb2, 0xa1, 0x60, 0xc3, 0x54, 0xff, 0x5a, 0x82, 0xa5, 0x13, 0x63, 0x40, 0x65, 0x48,
	0xee, 0x59, 0xb6, 0x8f, 0xdd, 0x62, 0x8c, 0x0d, 0xff, 0xf6, 0xf9, 0xc3, 0xaf, 0x1d, 0x8d, 0x5d,
	0xec, 0x79, 0x53, 0x43, 0x0a, 0x4d, 0x74, 0x1b, 0x60, 0xec, 0x92, 0xa7, 0x78, 0xe0, 0x5b, 0xc4,
	0x61, 0x0b, 0x93, 0x16, 0x12, 0x11, 0x3a, 0xba, 0x07, 0x05, 0x6e, 0x30, 0x7d, 0x40, 0xec, 0xc9,
	0xc8, 0xf1, 0x98, 0xe1, 0xf3, 0x65, 0x49, 0x89, 0x69, 0x79, 0xce, 0xa9, 0x70, 0x06, 0xda, 0x86,
	0x9c, 0x8b, 0x1d, 0x13, 0xbb, 0x3a, 0x3e, 0x1a, 0xbb, 0x5e, 0x51, 0x66, 0x2b, 0xb4, 0xc8, 0xd0,
	0xb2, 0x5c, 0x9f, 0xd2, 0x3d, 0xf4, 0x1e, 0x24, 0xc9, 0xde, 0x9e, 0x87, 0x7d, 0x66, 0x59, 0x39,
	0x5c, 0x3e, 0x46, 0x43, 0x2b, 0x90, 0xb0, 0xad, 0x91, 0xe5, 0x33, 0x33, 0x06, 0x4c, 0x4e, 0x52,
	0xff, 0xbf, 0x00, 0xe8, 0xb4, 0x1f, 0xa1, 0xcf, 0x40, 0x76, 0x08, 0x19, 0x0b, 0x93, 0xbd, 0x7f,
	0xfe, 0xb8, 0x5a, 0x84, 0x8c, 0xa9, 0x1a, 0x35, 0xb5, 0xc6, 0x74, 0xd0, 0x23, 0xc8, 0xfa, 0x46,
	0xdf, 0xc6, 0x1a, 0x36, 0x4c, 0xec, 0x0a, 0x37, 0xbe, 0xc0, 0x69, 0xba, 0x53, 0x61, 0x86, 0x12,
	0xd5, 0x46, 0x9b, 0x00, 0x74, 0x07, 0x0b, 0xac, 0x38, 0xc3, 0xba, 0x7b, 0x3e, 0xd6, 0x56, 0x28,
	0xcb, 0xa0, 0x22, 0xba, 0xe8, 0xc7, 0x90, 0xf4, 0x88, 0x4b, 0xfd, 0x40, 0x9e, 0xe7, 0x07, 0x1d,
	0x26, 0xc7, 0x10, 0x84, 0x0e, 0x1d, 0x87, 0x31, 0x1c, 0xba, 0x78, 0x68, 0xf8, 0xc4, 0x65, 0x56,
	0xbe, 0x70, 0x1c, 0xa5, 0x50, 0x96, 0x8f, 0x63, 0xaa, 0x8b, 0xca, 0x90, 0xa6, 0x82, 0x96, 0x33,
	0xf0, 0x8b, 0xa9, 0x79, 0xe6, 0xad, 0x0a, 0x49, 0x86, 0x12, 0xea, 0x51, 0x13, 0x8f, 0xb0, 0x3b,
	0xc4, 0x74, 0xba, 0xd8, 0x2d, 0xa6, 0xe7, 0x99, 0x78, 0x7b, 0x2a, 0xcc, 0x4d, 0x1c, 0xd1, 0xa6,
	0x53, 0xdb, 0x37, 0xbc, 0x7d, 0x81, 0x95, 0x99, 0x37, 0xb5, 0xcd, 0x50, 0x96, 0x4f, 0x6d, 0xaa,
	0x8b, 0xbe, 0x80, 0xe4, 0x73, 0xc3, 0x9e, 0x60, 0xaf, 0x08, 0xf3, 0x50, 0x76, 0x99, 0x5c, 0xe8,
	0x39, 0x42, 0x8f, 0x8e, 0xa5, 0x6f, 0x0c, 0x0e, 0xf6, 0x2c, 0xdb, 0xc6, 0x6e, 0x31, 0x3b, 0x0f,
	0xa5, 0x1c, 0xca, 0xf2, 0xb1, 0x4c, 0x75, 0x51, 0x13, 0xc0, 0xc5, 0x86, 0xd9, 0x18, 0x8d, 0x89,
	0xeb, 0x17, 0xf3, 0xf3, 0x62, 0xa9, 0x16, 0xca, 0x56, 0x0d, 0xdf, 0xe0, 0x68, 0x53, 0x7d, 0x54,
	0x83, 0x4c, 0xa7, 0xd3, 0x7d, 0xe2, 0x5a, 0xd4, 0x7f, 0x0a, 0x0c, 0xec, 0x82, 0xe0, 0x1e, 0x8a,
	0x32, 0x9c, 0xa9, 0x26, 0xfa, 0x1c, 0x52, 0x1d, 0x63, 0x34, 0xa6, 0x73, 0x5b, 0x62, 0x20, 0xdf,
	0xbd, 0x00, 0x84, 0x0b, 0x32, 0x88, 0x40, 0x0b, 0x7d, 0x05, 0x0a, 0xff, 0x39, 0x75, 0xb0, 0xa2,
	0xc2, 0x90, 0xd6, 0xe6, 0x21, 0x9d, 0x70, 0xc9, 0x53, 0x38, 0x88, 0xc0, 0x75, 0xcb, 0xf1, 0xb1,
	0x6b, 0x63, 0xe3, 0x39, 0x36, 0xf9, 0xae, 0x11, 0x4e, 0x71, 0x95, 0xbd, 0xe2, 0x07, 0x17, 0x1d,
	0x67, 0x67, 0x2a, 0xb2, 0x37, 0x9d, 0x87, 0x8a, 0xfe, 0x10, 0xd0, 0x08, 0xfb, 0x06, 0x3d, 0x81,
	0xbb, 0xd8, 0xf3, 0x3b, 0x2c, 0xa0, 0x15, 0x11, 0x7b, 0xd7, 0x87, 0x17, 0x39, 0xf3, 0x49, 0x1d,
	0xf6, 0x9a, 0x33, 0xb0, 0xd0, 0x1e, 0x2c, 0x47, 0xa9, 0x1a, 0x1e, 0x60, 0xeb, 0x39, 0x76, 0x8b,
	0x6f, 0xb1, 0x77, 0x3c, 0xbc, 0xdc, 0x3b, 0x02, 0x2d, 0xf6, 0x96, 0x33, 0xf1, 0xa8, 0x7b, 0x54,
	0x3a, 0xbb, 0xc2, 0x3d, 0x96, 0xe7, 0xb9, 0x47, 0x28, 0xca, 0xdd, 0x23, 0x7c, 0x44, 0x2d, 0xc8,
	0xbd, 0xb0, 0x86, 0x2f, 0x8c, 0xa1, 0x30, 0xfb, 0x35, 0x86, 0x74, 0xc1, 0xb9, 0xfd, 0x55, 0x44,
	0x9a, 0x81, 0xcd, 0xe8, 0xd3, 0xdd, 0x24, 0x8e, 0xa7, 0x0e, 0xf6, 0x8b, 0x6f, 0xcf, 0xdb, 0x4d,
	0x3b, 0xa1, 0x2c, 0xf7, 0xff, 0xa9, 0x2e, 0x0d, 0x5a, 0x87, 0x96, 0x63, 0x92, 0x43, 0xec, 0x16,
	0xaf, 0xcf, 0x0b, 0x5a, 0x4f, 0x84, 0x24, 0x0f, 0x5a, 0x81, 0x1e, 0x7a, 0x0c, 0x79, 0x9b, 0x0c,
	0x0c, 0x7b, 0xc7, 0x36, 0x9c, 0x16, 0x31, 0x71, 0xb1, 0xc8, 0x80, 0xbe, 0x77, 0x3e, 0x50, 0x33,
	0x2a, 0xce, 0xd0, 0x66, 0x11, 0xe8, 0x76, 0x18, 0xec, 0x1b, 0xce, 0x30, 0xba, 0x1d, 0xde, 0x99,
	0xb7, 0x1d, 0x2a, 0x27, 0x34, 0xf8, 0x76, 0x38, 0x89, 0x83, 0xba, 0x50, 0xe0, 0xb4, 0xba, 0x4b,
	0x1c, 0xdf, 0xc2, 0x6e, 0x71, 0x65, 0x5e, 0x10, 0xa9, 0xcc, 0xc8, 0x33, 0xdc, 0x13, 0x18, 0x9f,
	0xc9, 0x5f, 0xff, 0x7c, 0x35, 0xb6, 0x25, 0xa7, 0x93, 0x4a, 0x6a, 0x4b, 0x4e, 0xe7, 0x94, 0xbc,
	0x5a, 0x80, 0x5c, 0xf4, 0x10, 0x55, 0x3f, 0x86, 0xb7, 0xcf, 0xf6, 0x70, 0xb4, 0x02, 0x92, 0x65,
	0xb2, 0x23, 0x39, 0x53, 0x06, 0x91, 0x0b, 0x49, 0x8d, 0xaa, 0x26, 0x59, 0xa6, 0xba, 0x09, 0xc5,
	0xf3, 0x7c, 0x16, 0x7d, 0x00, 0xe0, 0xf1, 0x64, 0xc3, 0x32, 0x3d, 0x96, 0x9a, 0x66, 0xca, 0xf9,
	0x57, 0x2f, 0x57, 0x33, 0x1c, 0xbb, 0x51, 0xf5, 0xb4, 0x0c, 0x17, 0x68, 0x98, 0x9e, 0xfa, 0xb3,
	0x18, 0x14, 0x66, 0xa3, 0x33, 0xaa, 0x40, 0x2a, 0xc8, 0x68, 0x78, 0x62, 0xfb, 0x9d, 0x0b, 0x4e,
	0x2c, 0x9a, 0x88, 0x37, 0x9c, 0x3d, 0x22, 0xf2, 0x8c, 0x40, 0x13, 0xbd, 0x0b, 0x19, 0xd7, 0x38,
	0xd4, 0xfb, 0xc7, 0x3e, 0xf6, 0x8a, 0xd2, 0xcd, 0xf8, 0xdd, 0x9c, 0x96, 0x76, 0x8d, 0xc3, 0x32,
	0x7d, 0x46, 0xab, 0x90, 0x76, 0x26, 0x23, 0xdd, 0x25, 0x87, 0x1e, 0x3b, 0xe4, 0x83, 0x2c, 0x25,
	0xe5, 0x4c, 0x46, 0x1a, 0x39, 0xf4, 0xd4, 0x2a, 0x2c, 0xcd, 0xe4, 0x09, 0x86, 0x83, 0x1e, 0x80,
	0xec, 0x8d, 0x0d, 0x47, 0xe4, 0x28, 0xd7, 0x23, 0x43, 0x12, 0x85, 0xc5, 0x1a, 0x15, 0x0b, 0x72,
	0x50, 0x2a, 0xaa, 0xfe, 0x8f, 0x74, 0x02, 0x86, 0xe5, 0x87, 0x09, 0x96, 0x70, 0x9c, 0x93, 0xeb,
	0x88, 0x3a, 0x82, 0x67, 0x29, 0x55, 0xec, 0x0d, 0x5c, 0x6b, 0xec, 0x13, 0x37, 0xc8, 0xa2, 0x98,
	0x2a, 0xba, 0x05, 0x19, 0xcb, 0x31, 0xf1, 0x91, 0x6e, 0x99, 0x47, 0x2c, 0xe1, 0xc9, 0x0b, 0x7e,
	0x9a, 0x91, 0x1b, 0xe6, 0x11, 0xba, 0x01, 0x29, 0x17, 0x3f, 0xc7, 0xae, 0x87, 0xd9, 0x04, 0x83,
	0xfc, 0x31, 0x20, 0xa2, 0x1a, 0x24, 0xe8, 0x10, 0x83, 0x54, 0xf0, 0xb2, 0xf9, 0x52, 0x38, 0x41,
	0xae, 0x8d, 0xbe, 0x03, 0xc0, 0x12, 0x3b, 0x7d, 0xdf, 0x72, 0x78, 0x36, 0x18, 0x17, 0x02, 0x19,
	0x46, 0xdf, 0xb4, 0x1c, 0x9f, 0x5a, 0xdb, 0xf2, 0xf4, 0xc1, 0x3e, 0x1e, 0x1c, 0xb0, 0x9c, 0x30,
	0x1c, 0x8c, 0xe5, 0x55, 0x28, 0x11, 0xb5, 0x00, 0x9e, 0x5b, 0x9e, 0xd5, 0xb7, 0x6c, 0xcb, 0x3f,
	0x66, 0x59, 0x4a, 0xe1, 0xa2, 0xc0, 0xd1, 0x19, 0x18, 0xce, 0x6e, 0x28, 0x1f, 0x64, 0xc6, 0x53,
	0x04, 0xf5, 0x1f, 0xe3, 0x50, 0x98, 0x4d, 0xcd, 0x7e, 0x5b, 0x66, 0xbf, 0x07, 0x05, 0x9b, 0x90,
	0x83, 0xc9, 0xf8, 0xac, 0x9c, 0x9c, 0x73, 0x82, 0x9c, 0xbc, 0x02, 0x29, 0xe2, 0xb0, 0x7c, 0x7c,
	0x7e, 0x86, 0x78, 0xba, 0x52, 0x20, 0x0e, 0xa5, 0xa1, 0x5d, 0xb8, 0xca, 0x87, 0xc4, 0x2b, 0x07,
	0x0e, 0x97, 0x58, 0x18, 0x6e, 0x89, 0x81, 0xd4, 0x19, 0x06, 0xc3, 0xfd, 0x21, 0xc8, 0xb4, 0x88,
	0x65, 0xcb, 0x55, 0x78, 0xb8, 0x7a, 0x8e, 0xb5, 0xa8, 0x8d, 0xbb, 0xc7, 0x63, 0x1c, 0x38, 0x3d,
	0x55, 0xf9, 0xd6, 0x17, 0xf3, 0x67, 0x31, 0x80, 0x69, 0x86, 0x8c, 0x1e, 0xc3, 0x92, 0xa8, 0x7a,
	0x88, 0x6b, 0x62, 0xd7, 0x72, 0x86, 0x62, 0x49, 0xd5, 0x0b, 0xea, 0x4d, 0x21, 0x29, 0xd0, 0x45,
	0xd9, 0x14, 0x50, 0xd1, 0x43, 0x40, 0x01, 0x96, 0x3e, 0x32, 0xfc, 0xc1, 0xbe, 0x6e, 0x63, 0x67,
	0x66, 0x81, 0x95, 0x80, 0xbf, 0x4d, 0xd9, 0x4d, 0xec, 0xa8, 0x7d, 0xc8, 0x45, 0x93, 0x65, 0x74,
	0x07, 0x96, 0x98, 0x0c, 0x36, 0xf5, 0x68, 0xec, 0xca, 0x6b, 0x05, 0x41, 0x0e, 0x96, 0xfd, 0x1e,
	0x28, 0x41, 0x5e, 0x1d, 0x4a, 0x4a, 0x4c, 0x72, 0x29, 0xa0, 0x0b, 0x51, 0xf5, 0x97, 0x12, 0x28,
	0x27, 0x8f, 0x5c, 0x54, 0x85, 0x24, 0xf3, 0xc6, 0x20, 0x36, 0x2e, 0xe6, 0xc9, 0x42, 0x17, 0xd5,
	0x01, 0xf0, 0xb3, 0x99, 0xf7, 0x67, 0x1f, 0xde, 0xba, 0xe0, 0xa4, 0xe1, 0x82, 0xc1, 0xd6, 0xc6,
	0xcf, 0x82, 0xd9, 0xac, 0x4e, 0xb7, 0x44, 0xd4, 0xd5, 0x83, 0x0d, 0xf1, 0x2d, 0x79, 0x79, 0xe0,
	0x8d, 0x89, 0x85, 0xbd, 0x51, 0xb5, 0xe0, 0xea, 0xa9, 0x63, 0x1d, 0xa9, 0x90, 0xd3, 0xc8, 0x61,
	0x87, 0x4c, 0xdc, 0x01, 0x6e, 0x98, 0x47, 0xcc, 0x81, 0xf2, 0xda, 0x0c, 0x0d, 0xbd, 0x07, 0x99,
	0x16, 0x3d, 0x59, 0xc6, 0x13, 0xdf, 0xe3, 0xbe, 0xa0, 0x4d, 0x09, 0x08, 0x81, 0xdc, 0x32, 0x46,
	0x3c, 0xb6, 0x66, 0x34, 0xf6, 0x5b, 0xbd, 0x03, 0xa9, 0xc0, 0x2c, 0xef, 0xcd, 0x9e, 0x60, 0xdc,
	0x28, 0x01, 0x49, 0xfd, 0x37, 0x09, 0x96, 0x4e, 0x94, 0x48, 0x68, 0x1b, 0xf2, 0x36, 0xde, 0x7b,
	0x03, 0xa7, 0xce, 0x51, 0xf5, 0xd0, 0xa5, 0xdb, 0x50, 0x70, 0xad, 0xe1, 0x7e, 0x04, 0x4f, 0x5a,
	0x10, 0x2f, 0xcf, 0xf4, 0x43, 0xc0, 0xc8, 0x3a, 0x26, 0xde, 0x78, 0x1d, 0x5f, 0x23, 0xaa, 0xdc,
	0x83, 0xbc, 0x33, 0xb1, 0x6d, 0x1d, 0x3f, 0x9b, 0x18, 0x61, 0x60, 0x09, 0x0e, 0x92, 0x1c, 0x65,
	0xd5, 0x04, 0x47, 0xfd, 0x4b, 0x09, 0x0a, 0xb3, 0x55, 0x23, 0xba, 0x0f, 0x4b, 0xcc, 0xba, 0x11,
	0x9f, 0x8f, 0x45, 0xe2, 0x32, 0xde, 0xf3, 0x6b, 0xa1, 0x4b, 0x7f, 0x00, 0x0a, 0x37, 0xdd, 0x89,
	0x0d, 0xc2, 0x85, 0xb9, 0x59, 0xa7, 0xd2, 0xbf, 0x6b, 0xbb, 0x7c, 0x0f, 0x0a, 0xac, 0xb8, 0x9e,
	0x86, 0x9d, 0xa8, 0x61, 0xf2, 0x9c, 0x17, 0x04, 0x94, 0xff, 0x4e, 0x42, 0x61, 0x36, 0x11, 0x45,
	0xb7, 0x00, 0x86, 0x2e, 0xe1, 0xe7, 0x55, 0x74, 0x9e, 0x19, 0x46, 0xad, 0x10, 0xdb, 0x43, 0x7f,
	0x00, 0xb9, 0xa0, 0x9f, 0x60, 0x11, 0x71, 0xa2, 0x65, 0x1f, 0x7e, 0x7c, 0xd9, 0x6e, 0x44, 0xf8,
	0x38, 0x9d, 0xf7, 0x0c, 0x1e, 0xfa, 0x50, 0x84, 0x5f, 0x6c, 0xea, 0x91, 0xa1, 0xc8, 0xe1, 0x50,
	0x14, 0xc1, 0xdd, 0x08, 0x47, 0xb4, 0x31, 0x13, 0x0f, 0xbe, 0x7f, 0xe9, 0x91, 0x9c, 0xb4, 0xde,
	0xca, 0x9f, 0x4a, 0x90, 0x8d, 0x0c, 0x8f, 0x02, 0xef, 0x4d, 0x9c, 0x01, 0xdb, 0x7c, 0x8b, 0x00,
	0xd7, 0x27, 0x4e, 0xd8, 0x7d, 0xa4, 0x00, 0xe8, 0x66, 0xa4, 0xeb, 0x12, 0xed, 0xdf, 0x4d, 0x7b,
	0x2a, 0xb7, 0xa1, 0x20, 0xce, 0xec, 0x01, 0xb1, 0x59, 0x46, 0x21, 0xf3, 0x28, 0xc4, 0xa9, 0x15,
	0x62, 0xd3, 0x28, 0x74, 0x9d, 0x05, 0x12, 0xc6, 0x4e, 0xb0, 0x43, 0x22, 0x39, 0xe0, 0x8c, 0x4d,
	0xc8, 0x18, 0xee, 0x70, 0x32, 0xc2, 0x8e, 0xef, 0x15, 0x93, 0x0b, 0xb7, 0xf3, 0xa6, 0xca, 0x5b,
	0x72, 0x3a, 0xae, 0xc8, 0xea, 0x2f, 0x24, 0x90, 0xe9, 0x2c, 0x90, 0x02, 0xb9, 0x52, 0xeb, 0x4b,
	0xbd, 0xd5, 0xee, 0xea, 0xad, 0x5e, 0xb3, 0xa9, 0x5c, 0x41, 0x29, 0x88, 0x97, 0x76, 0x37, 0x94,
	0x18, 0xca, 0x41, 0xba, 0xdc, 0x6e, 0x37, 0xf5, 0x52, 0xab, 0xaa, 0x48, 0x28, 0x0b, 0x29, 0xf6,
	0xd4, 0xd6, 0x94, 0x38, 0x2a, 0x00, 0x54, 0xda, 0xad, 0x4a, 0xa9, 0xab, 0x97, 0x36, 0x36, 0x14,
	0x19, 0x65, 0x20, 0x51, 0x69, 0xf7, 0x5a, 0x5d, 0x25, 0x41, 0xd5, 0xb7, 0x4b, 0x3f, 0x55, 0x52,
	0xec, 0x47, 0xa3, 0xa5, 0xa4, 0x11, 0x40, 0xb2, 0xd3, 0xad, 0x56, 0x6b, 0xbb, 0x4a, 0x86, 0x12,
	0x3b, 0xbd, 0x6d, 0x05, 0x28, 0x5c, 0xa7, 0xb7, 0xad, 0x37, 0x5a, 0x5d, 0x25, 0x4b, 0xdf, 0xb4,
	0x5b, 0xd2, 0x1a, 0xa5, 0x56, 0xa5, 0xa6, 0xe4, 0x28, 0xeb, 0xa7, 0x6d, 0x8d, 0x21, 0xe7, 0xf9,
	0x9b, 0x7a, 0xad, 0xae, 0xae, 0xb5, 0x9f, 0x74, 0x94, 0x02, 0xd3, 0x7b, 0xac, 0x55, 0x1b, 0xf5,
	0xba, 0xb2, 0x84, 0x10, 0x14, 0xea, 0x8d, 0x56, 0xa9, 0xa9, 0x87, 0xda, 0x0a, 0x9d, 0x10, 0xa7,
	0x89, 0x77, 0x5e, 0x45, 0x79, 0xc8, 0x94, 0x34, 0xad, 0xf4, 0x25, 0x43, 0x44, 0xf4, 0x65, 0x5b,
	0x9d, 0x76, 0x8b, 0x3d, 0xbd, 0x45, 0x99, 0xf4, 0xa9, 0xcc, 0x1e, 0x97, 0xe9, 0xeb, 0x3a, 0x5d,
	0xad, 0xd1, 0xda, 0x60, 0xcf, 0xd7, 0xd4, 0x0f, 0x40, 0xa6, 0x5e, 0x84, 0xd2, 0x20, 0x97, 0x7a,
	0xdd, 0xb6, 0x72, 0x85, 0xcd, 0xa6, 0x52, 0x6a, 0x96, 0x34, 0x25, 0x46, 0xa5, 0x5b, 0xed, 0x96,
	0x2e, 0x9e, 0x25, 0xf5, 0x9b, 0x38, 0x14, 0x66, 0x9b, 0x46, 0xa1, 0xef, 0xce, 0x75, 0xb1, 0x59,
	0xbd, 0x53, 0xbe, 0x3b, 0xcd, 0x68, 0xa5, 0xd7, 0xcf, 0x68, 0xc3, 0x2a, 0x20, 0xfe, 0x46, 0x55,
	0xc0, 0x03, 0x48, 0x9b, 0x13, 0x97, 0x6d, 0x21, 0xe6, 0xc5, 0xf1, 0xf2, 0x35, 0xca, 0xfe, 0xe6,
	0xe5, 0x6a, 0xde, 0xb7, 0x46, 0x78, 0xad, 0x2a, 0x98, 0x5a, 0x28, 0x46, 0x0b, 0x87, 0xc1, 0xfe,
	0xc4, 0x39, 0xd0, 0x3d, 0xeb, 0x05, 0x9e, 0x2d, 0x1c, 0x18, 0xbd, 0x63, 0xbd, 0xc0, 0xa8, 0x0d,
	0x39, 0xe2, 0xef, 0x63, 0x57, 0x17, 0x19, 0x4f, 0xf2, 0x35, 0x32, 0x9e, 0x2c, 0x43, 0xe8, 0xf2,
	0xb4, 0xe7, 0x73, 0x48, 0xbb, 0xd8, 0x30, 0x4b, 0x5e, 0x7b, 0x4f, 0x34, 0x43, 0x7f, 0x2f, 0x02,
	0x36, 0xf1, 0x2d, 0x7b, 0x6d, 0xdf, 0x1e, 0xac, 0x75, 0x83, 0xfb, 0x98, 0x60, 0xd7, 0x06, 0x4a,
	0xea, 0x7d, 0xb1, 0xfc, 0x59, 0x48, 0x35, 0x9c, 0xe7, 0x86, 0x6d, 0x99, 0xdc, 0x03, 0x78, 0x84,
	0x55, 0x62, 0xd4, 0xf1, 0x1b, 0x34, 0xf7, 0x51, 0x24, 0xf5, 0xd7, 0x31, 0x48, 0xd7, 0x6d, 0x72,
	0xc8, 0x96, 0xfd, 0x01, 0xa4, 0xf6, 0x6c, 0x72, 0xa8, 0x8b, 0x8a, 0x3a, 0x57, 0x2e, 0x52, 0xe4,
	0x7f, 0x7d, 0xb9, 0x9a, 0xa4, 0x22, 0x8d, 0xea, 0xab, 0xf0, 0x97, 0x96, 0xa4, 0x82, 0x0d, 0x13,
	0x6d, 0xb3, 0x76, 0x8a, 0xb8, 0x33, 0x13, 0x39, 0xda, 0x9d, 0x4b, 0x5c, 0xcf, 0x44, 0xae, 0x42,
	0x22, 0x00, 0xa8, 0x07, 0xa9, 0xa1, 0xe1, 0xe3, 0x43, 0xe3, 0x98, 0x65, 0x2d, 0x89, 0xf2, 0x8f,
	0xc4, 0x1a, 0x7d, 0x34, 0xb4, 0xfc, 0xfd, 0x49, 0x7f, 0x6d, 0x40, 0x46, 0xeb, 0x21, 0xba, 0xd9,
	0x9f, 0xfe, 0x5e, 0x1f, 0x1f, 0x0c, 0xd7, 0x83, 0x22, 0x97, 0x26, 0x51, 0x8d, 0xaa, 0x16, 0x60,
	0xa9, 0x87, 0x90, 0xdd, 0x22, 0xfd, 0x1d, 0x97, 0x0c, 0x69, 0x84, 0x41, 0xb7, 0x21, 0xf9, 0x94,
	0xf4, 0x83, 0x69, 0xc6, 0xcb, 0x79, 0xd1, 0x38, 0x48, 0x6c, 0x91, 0x7e, 0xa3, 0xaa, 0x25, 0x9e,
	0x92, 0x7e, 0xc3, 0x44, 0x77, 0x21, 0x37, 0x20, 0x8e, 0xef, 0x5a, 0xfd, 0x49, 0x78, 0xc5, 0x21,
	0x05, 0x87, 0x43, 0x94, 0x83, 0x8a, 0x20, 0x7b, 0x36, 0xf1, 0xc5, 0x90, 0x83, 0xe2, 0xda, 0x26,
	0xbe, 0xfa, 0x2b, 0x19, 0xd0, 0xe9, 0x36, 0x2a, 0xfa, 0x2e, 0x64, 0x3d, 0xd6, 0x6a, 0xe4, 0x9e,
	0x25, 0x45, 0xf4, 0x80, 0x33, 0x98, 0x6b, 0x6d, 0x40, 0x7a, 0x2c, 0xc6, 0xcc, 0x8e, 0xdd, 0x0b,
	0x7b, 0xa3, 0x91, 0x09, 0x06, 0x1e, 0x11, 0x28, 0xa3, 0x0d, 0x88, 0x4f, 0x5c, 0xab, 0x98, 0x62,
	0xcb, 0xf3, 0x83, 0x45, 0x3a, 0xbe, 0x6b, 0x3d, 0xd7, 0xaa, 0x39, 0xbe, 0x7b, 0xac, 0x51, 0x04,
	0xf4, 0x13, 0x48, 0xf2, 0x6b, 0x49, 0xd1, 0x5f, 0x5f, 0x3d, 0xa3, 0xc3, 0xd0, 0x68, 0xd7, 0x2d,
	0x1b, 0xd7, 0x99, 0x58, 0x78, 0x67, 0xc4, 0x9e, 0xd0, 0x6e, 0x58, 0x17, 0x64, 0xd8, 0x50, 0x3e,
	0x5d, 0x68, 0x28, 0x7c, 0x7f, 0xb0, 0xd1, 0x30, 0xdc, 0x58, 0x58, 0x29, 0x7c, 0x0e, 0xef, 0x78,
	0x07, 0xd6, 0x58, 0x1f, 0x59, 0x9e, 0x47, 0x0b, 0xa4, 0x3d, 0xe2, 0x62, 0x6b, 0xe8, 0xe8, 0x07,
	0xf8, 0x98, 0xf7, 0xdd, 0x83, 0xa3, 0xed, 0x6d, 0x2a, 0xb6, 0xcd, 0xa5, 0xea, 0x5c, 0xe8, 0x11,
	0x3e, 0xf6, 0x56, 0x0c, 0xc8, 0x46, 0xd0, 0x91, 0x02, 0xf1, 0x03, 0x7c, 0xcc, 0xdb, 0x4a, 0x1a,
	0xfd, 0x89, 0x7e, 0x0c, 0x09, 0xd6, 0x8e, 0x5f, 0x2c, 0x90, 0x69, 0x5c, 0xe9, 0x33, 0xe9, 0xd3,
	0xd8, 0xca, 0x27, 0x90, 0x0e, 0x6c, 0x19, 0xc5, 0x4f, 0x70, 0xfc, 0xe5, 0x28, 0x7e, 0x26, 0xa2,
	0xb7, 0x25, 0xa7, 0x63, 0x8a, 0xc4, 0x0f, 0xc0, 0x2d, 0x39, 0x2d, 0x2b, 0x89, 0x2d, 0x39, 0x9d,
	0x50, 0x92, 0xea, 0xdf, 0x4a, 0x90, 0x9f, 0x69, 0xaa, 0xa3, 0xf7, 0x21, 0x6b, 0x62, 0x7a, 0x72,
	0xf3, 0x20, 0xc7, 0x9b, 0x62, 0x22, 0xc0, 0x44, 0x18, 0xe8, 0x3e, 0xe4, 0x0f, 0x0d, 0xdb, 0xa6,
	0x51, 0xaf, 0x65, 0x38, 0x84, 0x77, 0x97, 0x82, 0xc8, 0x36, 0xcb, 0x42, 0xcd, 0xd9, 0x16, 0xcc,
	0x87, 0x97, 0x6c, 0xf0, 0xb3, 0x36, 0x13, 0x2d, 0x38, 0x66, 0x63, 0x70, 0xd4, 0xa1, 0x13, 0x6f,
	0xe0, 0xd0, 0xd4, 0x98, 0xc1, 0x1b, 0xe8, 0xee, 0x73, 0x68, 0x99, 0x13, 0x9d, 0x2f, 0xa3, 0x50,
	0x33, 0x63, 0xc7, 0x64, 0x26, 0xcd, 0x69, 0xf4, 0xe7, 0x96, 0x9c, 0x96, 0x94, 0xb8, 0xfa, 0xf7,
	0x31, 0xc8, 0xcf, 0x34, 0x9c, 0x2f, 0x6d, 0xba, 0x3b, 0x90, 0xa3, 0xc8, 0xfa, 0xd8, 0xf0, 0x7d,
	0xec, 0xf2, 0x98, 0x10, 0x0a, 0x52, 0xce, 0x0e, 0x67, 0xa0, 0x9f, 0x40, 0x8a, 0x8c, 0x83, 0x54,
	0xf4, 0x64, 0x0c, 0x0f, 0x76, 0x4a, 0xa5, 0xb3, 0xdb, 0xe6, 0x42, 0x41, 0xb3, 0x49, 0xe8, 0x4c,
	0x4f, 0x1e, 0xd6, 0xfd, 0x93, 0x4f, 0x9d, 0x3c, 0xac, 0xff, 0xf7, 0x27, 0x12, 0x40, 0xe7, 0x00,
	0xfb, 0x83, 0x7d, 0x36, 0x87, 0x47, 0x90, 0xf5, 0xd8, 0x93, 0x1e, 0x39, 0xbb, 0x2f, 0xba, 0xd1,
	0x63, 0xc2, 0x91, 0x23, 0x1b, 0xbc, 0x90, 0x82, 0x8a, 0xd3, 0xe2, 0x90, 0x17, 0xfe, 0x61, 0xcf,
	0xf2, 0x23, 0x40, 0x43, 0xec, 0x60, 0xd7, 0xf0, 0xb1, 0xbe, 0x6f, 0x79, 0x3e, 0x19, 0xba, 0xc6,
	0x68, 0xa6, 0x7f, 0x77, 0x35, 0xe0, 0x6f, 0x06, 0x6c, 0xf4, 0x29, 0x5c, 0x0b, 0x65, 0xf5, 0x91,
	0x71, 0xa4, 0xf7, 0x27, 0x83, 0x03, 0xec, 0xf3, 0xa9, 0x05, 0x0d, 0x8c, 0xb7, 0x42, 0x91, 0x6d,
	0xe3, 0xa8, 0xcc, 0x05, 0xd0, 0x2d, 0xc8, 0x78, 0xbe, 0xe1, 0xeb, 0x6c, 0x89, 0x13, 0x11, 0x73,
	0xa7, 0x29, 0x99, 0xd5, 0xb4, 0x7f, 0x04, 0xd9, 0xc8, 0xc5, 0x10, 0xaa, 0x43, 0x9a, 0x4f, 0x24,
	0x6c, 0x3f, 0xcc, 0x35, 0x42, 0xe4, 0x34, 0x0a, 0x75, 0xcf, 0x0a, 0xd2, 0xf9, 0xd3, 0x41, 0x5a,
	0xfd, 0x2f, 0x09, 0x96, 0xcf, 0xba, 0x4d, 0xfa, 0x2d, 0x8f, 0x03, 0xfd, 0x31, 0x20, 0xfe, 0x14,
	0x54, 0x59, 0x91, 0x76, 0xc7, 0xe3, 0x57, 0x2f, 0x57, 0xc5, 0xe5, 0x96, 0xa8, 0xb3, 0x1a, 0x55,
	0xef, 0x9b, 0x97, 0xab, 0x3f, 0xbc, 0xd4, 0xa9, 0x1a, 0xf9, 0x74, 0x64, 0x2d, 0xd0, 0xd6, 0x14,
	0x6f, 0x06, 0xce, 0xf4, 0x90, 0x01, 0x69, 0x16, 0x8e, 0xe9, 0xb9, 0xca, 0x97, 0xb5, 0x1e, 0x7c,
	0xcc, 0xc0, 0xc2, 0x62, 0xa3, 0x7a, 0xe9, 0x73, 0x3c, 0xfa, 0x46, 0x7a, 0x8e, 0x33, 0xdc, 0x86,
	0xa9, 0xfe, 0x9f, 0x0c, 0xef, 0x5e, 0x70, 0xad, 0x86, 0xbe, 0x3c, 0xd1, 0x77, 0xfa, 0xd1, 0x6b,
	0xdd, 0xce, 0xf1, 0x28, 0x7e, 0xa2, 0x19, 0x15, 0xe9, 0x55, 0x4b, 0x67, 0xf5, 0xaa, 0x67, 0x9b,
	0xcc, 0xf1, 0xb3, 0x9b, 0xcc, 0xbf, 0xe3, 0x46, 0xd3, 0xca, 0xdf, 0x49, 0x90, 0x60, 0x93, 0x43,
	0x5f, 0x80, 0x6c, 0x62, 0x6f, 0xf0, 0x5a, 0x9d, 0x66, 0xa6, 0x79, 0x99, 0x46, 0x73, 0xf0, 0x8d,
	0x4c, 0xfc, 0x4d, 0xbe, 0x91, 0xa9, 0x42, 0x3a, 0xec, 0x0f, 0xc9, 0x0b, 0xf6, 0x87, 0x42, 0xcd,
	0x69, 0x11, 0x91, 0x78, 0x93, 0x22, 0x42, 0xfd, 0x97, 0x18, 0x14, 0x66, 0xaf, 0x04, 0xd1, 0x17,
	0x90, 0xe0, 0xdf, 0xab, 0xc4, 0x16, 0x2e, 0x70, 0xb9, 0x22, 0xea, 0x42, 0x18, 0x31, 0xcd, 0x39,
	0xed, 0xce, 0xd9, 0x6d, 0x18, 0x59, 0x5f, 0x25, 0x44, 0x08, 0x9a, 0x3e, 0x77, 0x40, 0x71, 0x26,
	0x23, 0xd6, 0xa7, 0xd0, 0xc7, 0xd8, 0xd5, 0x87, 0xd8, 0xe1, 0xd1, 0x40, 0xcb, 0x3b, 0x93, 0x51,
	0x85, 0xd8, 0xde, 0x0e, 0x76, 0x37, 0xb0, 0xa3, 0xfe, 0x3c, 0x07, 0xb9, 0xe8, 0xf5, 0x24, 0xba,
	0x09, 0xd9, 0xb1, 0xe1, 0xfa, 0x16, 0x6b, 0x86, 0x1c, 0x8b, 0x16, 0x71, 0x94, 0x84, 0x3a, 0x90,
	0xe1, 0x57, 0x98, 0xf5, 0x70, 0xa4, 0xeb, 0x97, 0xbb, 0xfb, 0x14, 0x0f, 0xf5, 0xb0, 0xc6, 0x0f,
	0x71, 0x56, 0xfe, 0x26, 0x26, 0xaa, 0xfb, 0x0e, 0xe4, 0x83, 0xde, 0x0b, 0xae, 0xbf, 0x6e, 0xa7,
	0x43, 0x9b, 0xc5, 0x40, 0x8f, 0x01, 0xc4, 0xab, 0x28, 0xa2, 0xc4, 0x10, 0x1f, 0x2c, 0x36, 0x66,
	0x8a, 0x1a, 0x01, 0xe1, 0xf7, 0x96, 0x2b, 0xff, 0x99, 0x80, 0x44, 0xdd, 0xa5, 0xe9, 0xc6, 0x23,
	0x90, 0x47, 0xc4, 0x0c, 0x4e, 0xde, 0xcb, 0x82, 0x33, 0xdd, 0xb5, 0x6d, 0x62, 0x86, 0x5b, 0x95,
	0x82, 0xa0, 0xc7, 0x90, 0xec, 0x93, 0x89, 0x63, 0x7a, 0x22, 0xe3, 0xfc, 0x68, 0x21, 0xb8, 0x32,
	0x53, 0x0d, 0x02, 0x07, 0x07, 0x5a, 0xf9, 0xdf, 0x18, 0x24, 0x18, 0x03, 0x7d, 0x05, 0x19, 0x46,
	0xeb, 0x4e, 0x13, 0x85, 0x4f, 0x16, 0xc7, 0x8f, 0xb8, 0xdf, 0x14, 0x8e, 0x06, 0x42, 0xcb, 0xf1,
	0x75, 0xf1, 0xed, 0x55, 0x34, 0x30, 0x64, 0x2c, 0xc7, 0x6f, 0xf3, 0xcf, 0xaf, 0x6e, 0x41, 0x8e,
	0x06, 0x24, 0x33, 0x10, 0x8b, 0xb3, 0x14, 0x2d, 0xcb, 0x68, 0x42, 0x64, 0x0b, 0xb2, 0x9c, 0xc9,
	0xd3, 0x19, 0xbe, 0xf5, 0x17, 0xb8, 0x64, 0x05, 0xae, 0x4d, 0xc7, 0xb4, 0xf2, 0x57, 0x31, 0x48,
	0x72, 0x93, 0xa0, 0x16, 0x24, 0x3c, 0xdf, 0x70, 0x7d, 0x11, 0xf9, 0x1e, 0x2e, 0x3e, 0xed, 0x30,
	0x22, 0x50, 0x18, 0x54, 0x9d, 0xe6, 0x98, 0xaf, 0x85, 0xc6, 0xf2, 0x52, 0xf5, 0x0e, 0xc8, 0xd4,
	0x03, 0x68, 0x65, 0xae, 0x95, 0x5a, 0x1b, 0x35, 0xe5, 0x0a, 0x4a, 0x83, 0xcc, 0xba, 0x47, 0x31,
	0x5a, 0xba, 0x6f, 0x68, 0xed, 0xde, 0x4e, 0x47, 0x91, 0xd4, 0x17, 0x90, 0x09, 0x6d, 0x8f, 0xae,
	0xc3, 0x5b, 0xbd, 0x56, 0xb9, 0xdd, 0x6b, 0x55, 0x6b, 0x55, 0x7d, 0x47, 0xab, 0x55, 0x6a, 0xd5,
	0x46, 0x6b, 0x43, 0xb9, 0x32, 0xcb, 0xa8, 0xb7, 0x9b, 0xcd, 0xf6, 0x13, 0xca, 0x88, 0xa1, 0x65,
	0x50, 0xda, 0xf5, 0x7a, 0xa7, 0xd6, 0x8d, 0x88, 0x4b, 0x11, 0xea, 0x54, 0x36, 0x8e, 0x96, 0x20,
	0x5b, 0xe9, 0x69, 0x5a, 0x8d, 0xb7, 0xb1, 0x14, 0x79, 0xe5, 0x9f, 0x24, 0x48, 0x07, 0xdb, 0x17,
	0xd5, 0x22, 0x5d, 0xc8, 0x0b, 0x3f, 0x58, 0x98, 0x9d, 0xf8, 0xc9, 0x1e, 0xe4, 0xfb, 0x90, 0x35,
	0xdc, 0x61, 0xc3, 0x3c, 0xea, 0xb0, 0x45, 0x89, 0xba, 0x4b, 0x94, 0x81, 0x6e, 0x42, 0xda, 0x70,
	0x87, 0x15, 0x32, 0x11, 0x87, 0x6b, 0x78, 0xd8, 0x04, 0xd4, 0x6f, 0xe9, 0x9c, 0x28, 0x43, 0x62,
	0xcf, 0x0d, 0x52, 0xcd, 0x0b, 0x3f, 0x6c, 0x38, 0xbd, 0xa0, 0x1a, 0x57, 0x45, 0x77, 0x61, 0xa6,
	0x3f, 0x2a, 0xbe, 0xd4, 0x14, 0x8d, 0x83, 0x28, 0x47, 0xfd, 0x45, 0x0c, 0x60, 0x1a, 0x5c, 0x50,
	0x01, 0x40, 0x6b, 0x3f, 0xd1, 0x5b, 0xbd, 0xed, 0x72, 0x4d, 0x13, 0x2e, 0x50, 0x6a, 0x3d, 0xe2,
	0x3d, 0xbb, 0x6a, 0xad, 0xd5, 0xa9, 0xe9, 0xec, 0x59, 0x42, 0x0a, 0xe4, 0x76, 0x6a, 0x5a, 0x85,
	0xad, 0x0d, 0xa5, 0xc4, 0x51, 0x1e, 0x32, 0x95, 0xde, 0x76, 0x4d, 0xaf, 0x36, 0x3a, 0x5d, 0xde,
	0xdb, 0x6c, 0x75, 0x1b, 0xcd, 0x1a, 0xef, 0x6d, 0x36, 0x4b, 0x1b, 0x4a, 0x92, 0xc2, 0x35, 0x6b,
	0xa5, 0xaa, 0x92, 0xa2, 0x4b, 0x5b, 0x6f, 0x68, 0x9d, 0xae, 0xbe, 0x5b, 0x6a, 0xf6, 0x6a, 0x4a,
	0x9a, 0xe2, 0x37, 0x4b, 0xe1, 0x73, 0x86, 0xa2, 0xb5, 0xba, 0x9b, 0xe2, 0x11, 0xd4, 0x5f, 0x4a,
	0xb0, 0x7c, 0xd6, 0x27, 0x22, 0xa8, 0x0b, 0xa9, 0x43, 0x23, 0x9a, 0xe2, 0x7e, 0xbc, 0xd8, 0x37,
	0x26, 0x6b, 0x4f, 0xa8, 0x76, 0x90, 0x4b, 0x09, 0x28, 0x54, 0x07, 0x79, 0x0f, 0x63, 0xf3, 0x9c,
	0xaf, 0x7d, 0xd9, 0xb7, 0xd6, 0xfc, 0xbb, 0x6b, 0x81, 0x49, 0x85, 0xab, 0xd8, 0x37, 0x2c, 0xdb,
	0x0b, 0x9d, 0x0b, 0x63, 0x73, 0xe5, 0xcf, 0x62, 0x90, 0x60, 0x2f, 0x40, 0x2d, 0x50, 0x2c, 0xc7,
	0xf2, 0x2d, 0xc3, 0xd6, 0x5d, 0xec, 0x11, 0xfb, 0x39, 0x36, 0x85, 0xe7, 0x5e, 0xaa, 0xb7, 0xb6,
	0x24, 0x94, 0x35, 0xa1, 0x1b, 0x7e, 0x67, 0x21, 0x5d, 0xfe, 0x3b, 0x8b, 0x7f, 0x88, 0x01, 0x3a,
	0xfd, 0x31, 0x0c, 0x2a, 0x43, 0xde, 0x77, 0x8d, 0xc1, 0x01, 0x36, 0x75, 0x9e, 0xa0, 0x70, 0x3b,
	0xce, 0x81, 0xcc, 0x09, 0x9d, 0x0e, 0x2b, 0xab, 0xbf, 0x25, 0x7b, 0x45, 0xfa, 0x62, 0xf1, 0xf3,
	0xfb, 0x62, 0xf7, 0x7f, 0x1f, 0x0a, 0xb3, 0xf7, 0xe1, 0x34, 0x40, 0xed, 0xf4, 0xca, 0xcd, 0x46,
	0x45, 0xb9, 0x82, 0xde, 0x81, 0x6b, 0xfc, 0xb7, 0x5e, 0x6a, 0x55, 0x59, 0x87, 0x5e, 0xb0, 0x62,
	0xf7, 0xd5, 0xa0, 0x5c, 0x65, 0xc1, 0x6b, 0x19, 0x94, 0xcd, 0x66, 0x53, 0xdf, 0x69, 0xf6, 0x3a,
	0xfc, 0xcf, 0xee, 0x03, 0xe5, 0x4a, 0xf9, 0xf6, 0xd7, 0xff, 0x71, 0xe3, 0xca, 0xd7, 0xaf, 0x6e,
	0xc4, 0xfe, 0xf9, 0xd5, 0x8d, 0xd8, 0xaf, 0x5e, 0xdd, 0x88, 0xfd, 0xfb, 0xab, 0x1b, 0xb1, 0xbf,
	0xf8, 0xf5, 0x8d, 0x2b, 0x5f, 0xc1, 0xd4, 0x95, 0x7e, 0x13, 0x00, 0x00, 0xff, 0xff, 0x0a, 0x3f,
	0x1a, 0xa3, 0xb7, 0x2f, 0x00, 0x00,
}
