# Copyright (C) 2004 yvind Hagen
# Permission is hereby granted to copy and/or distribute this program, 
# with or without modifications, as long as this copyright notice is preserved.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY, to the extent permitted by law; without
# even the implied warranty of MERCHANTABILITY or FITNESS FOR A
# PARTICULAR PURPOSE.

dnl Configure paths for GKrellM2
dnl
dnl GKM_PATH_GKRELLM2([MINIMUM-VERSION, [ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND ]]])
dnl check gkrellm version and compare against required version
dnl Define GKM_CFLAGS to include gkrellm headers
dnl Define GKM_LDFLAGS to ensure correct library flags
dnl Define GKM_EXTRA_SRCS to files necessary to build on some platforms.  
dnl Define "--with-gkrellm=<path/to/gkrellm>"
dnl
dnl NB! The AM_PATH_GTK_2_0 macro is required. 
dnl NB! The AC_CANONICAL_HOST macro is required. 
dnl NB! Always run after gtk_paths

AC_DEFUN([GKM_PATH_GKRELLM2],
[

AC_REQUIRE([AM_PATH_GTK_2_0])
AC_REQUIRE([AC_CANONICAL_HOST])

dnl give the directory for gkrellm (will default to ../gkrellm)
dnl this is mainly for windows.
AC_ARG_WITH([gkrellm], AS_HELP_STRING([--with-gkrellm], [path to gkrellm source [[../gkrellm]] ]), 
[if test x"$withval" -eq x
then 
  GKM_SRCDIR="../gkrellm"
else 
  GKM_SRCDIR="$withval" 
fi], 
[
  GKM_SRCDIR=""
]
)
GKM_CFLAGS=""
GKM_LDFLAGS=""
GKM_EXTRA_SRCS=""

dnl get the gkrellm version from the arg and pkg-config
dnl we already know by now that gtk and pkg-config is available
min_gkrellm_version=ifelse([$1], , 2.0.0, $1)
AC_MSG_CHECKING([for GKrellM version >= $min_gkrellm_version])
GKM_BIN_VERSION=`pkg-config --modversion gkrellm`

gkrellm_arg_major_version=`echo $1 | \
  sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\1/'`
gkrellm_arg_minor_version=`echo $1 | \
  sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\2/'`
gkrellm_arg_micro_version=`echo $1 | \
  sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\3/'`

gkrellm_bin_major_version=`echo $GKM_BIN_VERSION | \
  sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\1/'`
gkrellm_bin_minor_version=`echo $GKM_BIN_VERSION | \
  sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\2/'`
gkrellm_bin_micro_version=`echo $GKM_BIN_VERSION | \
  sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\3/'`

dnl check if the gkrellm version is too old

GKM_BIN_OLD="no"

if test $gkrellm_bin_major_version -lt $gkrellm_arg_major_version || \
   test $gkrellm_bin_minor_version -lt $gkrellm_arg_minor_version || \
   test $gkrellm_bin_micro_version -lt $gkrellm_arg_micro_version
then
  AC_MSG_RESULT([no (version $gkrellm_bin_major_version.$gkrellm_bin_minor_version.$gkrellm_bin_micro_version)])
  AC_MSG_WARN([The GKrellM binary is to old. Download the appropriate package for your distribution, or get the source tarball at http://web.wt.net/~billw/gkrellm/gkrellm.html])
  GKM_BIN_OLD="yes"
  ifelse([$3], , :, [$3])
fi

dnl define CFLAGS, LDFLAGS and EXTRA_SRCS
if test x"$GKM_BIN_OLD"=x"no"
then
  ac_save_CFLAGS="$CFLAGS"
  CFLAGS="$CFLAGS $GTK_CFLAGS"
  ac_save_LIBS="$LIBS"
  LIBS="$LIBS $GTK_LIBS"

  case $host in
  *-*-cygwin* | *-*-mingw32*) dnl windows
    if test x"$GKM_SRCDIR"=x""
    then
      AC_MSG_WARN([The path to the gkrellm source directory has to be supplied under windows.])
      ifelse([$3], , :, [$3])         
    else
      cp $GKM_SRCDIR/src/sysdeps/win32-plugin.c $(top_srcdir)/src 
      GKM_EXTRA_SRCS="win32-plugin.$(OBJEXT)"
    fi  
    GKM_LDFLAGS=-no-undefined
    GKM_CFLAGS="-L$GKM_SRCDIR"
    ;;
  *) dnl assume unix
    if test x"$GKM_SRCDIR"=x""
    then
      GKM_CFLAGS=""         
    else
      GKM_CFLAGS="-L$GKM_SRCDIR"
    fi  
    GKM_LDFLAGS=""
    GKM_EXTRA_SRCS=""
    ;;
  esac

  rm -f gkm_header.test
  AC_RUN_IFELSE([AC_LANG_SOURCE([[

#include <stdio.h>
#include <stdlib.h>

#if defined(WIN32)
#include <src/gkrellm.h>
#include <src/win32-plugin.h>
#else
#include <gkrellm2/gkrellm.h>
#endif

int main(void)
{
  int retval = 1;
  FILE *tmpfile;
  if ((GKRELLM_VERSION_MAJOR == $gkrellm_bin_major_version) &&
      (GKRELLM_VERSION_MINOR == $gkrellm_bin_minor_version) &&
      (GKRELLM_VERSION_REV == $gkrellm_bin_micro_version))
  {
    retval = 0;
  } else {	
    retval = 1;
  }
  tmpfile = fopen("gkm_header.test", "w");
  fprintf(tmpfile, "%d.%d.%d", GKRELLM_VERSION_MAJOR, GKRELLM_VERSION_MINOR, GKRELLM_VERSION_REV);
  fclose(tmpfile);
  exit(retval);
}

]])], GKM_HEADER=1 , GKM_HEADER=0)

  gkrellm_header_major_version=`cat gkm_header.test | \
    sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\1/'`
  gkrellm_header_minor_version=`cat gkm_header.test | \
    sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\2/'`
  gkrellm_header_micro_version=`cat gkm_header.test | \
    sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\3/'`


  if test $GKM_HEADER -eq 0
  then
    AC_MSG_RESULT([no (version $GKM_BIN_VERSION)])
    AC_MSG_WARN([The GKrellM header version (gkrellm_header_major_version.gkrellm_header_minor_version.gkrellm_header_micro_version) does not match the binary version ($GKM_BIN_VERSION)])
    ifelse([$3], , :, [$3])
  else
    AC_MSG_RESULT([yes (version $GKM_BIN_VERSION)])
    ifelse([$2], , :, [$2])
  fi
  CFLAGS="$ac_save_CFLAGS"
  LIBS="$ac_save_LIBS"
fi dnl if GKM_BIN_OLD==no

rm -f gkm_header.test

AC_SUBST(GKM_CFLAGS)
AC_SUBST(GKM_LDFLAGS)
AC_SUBST(GKM_EXTRA_SRCS)

])


