/*
 *   mwave.h
 *
 *  Written By: Paul Schroeder IBM Corporation
 *
 *  Copyright (C) 1999 IBM Corporation
 *
 * This program is free software; you can redistribute it and/or modify      
 * it under the terms of the GNU General Public License as published by      
 * the Free Software Foundation; either version 2 of the License, or         
 * (at your option) any later version.                                       
 *                                                                           
 * This program is distributed in the hope that it will be useful,           
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             
 * GNU General Public License for more details.                              
 *                                                                           
 * NO WARRANTY                                                               
 * THE PROGRAM IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OR        
 * CONDITIONS OF ANY KIND, EITHER EXPRESS OR IMPLIED INCLUDING, WITHOUT      
 * LIMITATION, ANY WARRANTIES OR CONDITIONS OF TITLE, NON-INFRINGEMENT,      
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. Each Recipient is    
 * solely responsible for determining the appropriateness of using and       
 * distributing the Program and assumes all risks associated with its        
 * exercise of rights under this Agreement, including but not limited to     
 * the risks and costs of program errors, damage to or loss of data,         
 * programs or equipment, and unavailability or interruption of operations.  
 *                                                                           
 * DISCLAIMER OF LIABILITY                                                   
 * NEITHER RECIPIENT NOR ANY CONTRIBUTORS SHALL HAVE ANY LIABILITY FOR ANY   
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL        
 * DAMAGES (INCLUDING WITHOUT LIMITATION LOST PROFITS), HOWEVER CAUSED AND   
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR     
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE    
 * USE OR DISTRIBUTION OF THE PROGRAM OR THE EXERCISE OF ANY RIGHTS GRANTED  
 * HEREUNDER, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES             
 *                                                                           
 * You should have received a copy of the GNU General Public License         
 * along with this program; if not, write to the Free Software               
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
 *                                                                           
 * 
 *  10/23/2000 - Alpha Release 0.1.0
 *            First release to the public
 *
 */

#include <port_types.h>
#include <port_functions.h>

/****************************************************************************/
/* Section 1 - Common Interface.                                            */
/****************************************************************************/

/* XLATOFF */
#ifndef  MWAVE_INCLUDED                /* CH06 MTS #2020                    */
/* XLATON */
#define  MWAVE_INCLUDED                /* indicate MWAVE.H has been included*/

#include "mww32.h"

/****************************************************************************/
/*  Declarations of internal Mwave structures (not to be used by drivers)   */
/****************************************************************************/

typedef struct rdsp     FAR *PRDSP;    /* Ptr DSP structure                 */
typedef struct rfm      FAR *PRFM;     /* Ptr Frame Mgr structure           */
typedef struct rgpc     FAR *PRGPC;    /* Ptr GPC structure                 */
typedef struct ripcte   FAR *PRIPCTE;  /* Ptr IPCTE structure               */
typedef struct ritcb    FAR *PRITCB;   /* Ptr ITCB structure                */
typedef struct rldma    FAR *PRLDMA;   /* Ptr LDMA structure                */
typedef struct rmod     FAR *PRMOD;    /* Ptr Module Structure              */
typedef struct rseg     FAR *PRSEG;    /* Ptr SEG structure (perm part)     */
typedef struct rtsk     FAR *PRTSK;    /* Ptr TASK structure (perm part)    */
typedef struct rlockh   FAR *PHLOCK;   /* Ptr LOCKH structure               */

/****************************************************************************/
/* LOCKH STRUCTURE -  Lock Mem handle                                       */
/****************************************************************************/

typedef struct rlockh {                /* Used by dspLockMem                */
      BYTE       lockb[12];
} RLOCKH;

/****************************************************************************/
/* dspCreatePFT for WIN32.                                                  */
/****************************************************************************/
   typedef struct _pft {
         ULONG  ulPhysAddress;
         USHORT usNumWords;
   } PFT, *PPFT;

   typedef ULONG  HPFT;
   typedef HPFT  *PHPFT;

   #define MW_PC_TO_DSP   0
   #define MW_DSP_TO_PC   1

/****************************************************************************/
/* dspCommon Packet, Used for IDC below                                     */
/****************************************************************************/

typedef struct rparm_common {          /*                                   */
      ULONG      ulFunction;
} RPARM_COMMON;

/****************************************************************************/
/* Mwave handle declarations:  two sections, conditionally compiled if      */
/* DSPM_IDC_H, bring in the IDC code.                                       */
/****************************************************************************/

/* XLATOFF */
#ifndef  DSPM_IDC_H                    /* Regular Ring-3 driver code        */
/* XLATON  */

typedef PRLDMA  HDMA;                  /* DMA handle                        */
typedef PRDSP   HDSP;                  /* DSP handle                        */
typedef PRFM    HFM;                   /* Frame Manager handle              */
typedef PRGPC   HGPC;                  /* GPC handle                        */
typedef PRIPCTE HIPC;                  /* IPC handle                        */
typedef PRITCB  HITCB;                 /* ITCB handle                       */
typedef PVOID   HMISC;                 /* Miscellaneous handle              */
typedef PRMOD   HMOD;                  /* Module handle                     */
typedef PRSEG   HSEG;                  /* Segment handle                    */
typedef PRTSK   HMTASK;                /* Task handle                       */
typedef PRTSK   HTASK;                 /* Task handle (synonym for HMTASK)  */
typedef HIPC    FAR *PHIPC;            /* Ptr to IPC handle                 */
typedef HMOD    FAR *PHMOD;            /* Ptr to Module handle              */
typedef HSEG    FAR *PHSEG;            /* Ptr to Segment handle             */
typedef HTASK   FAR *PHTASK;           /* Ptr to Task handle                */
typedef HDSP    FAR *PHDSP;            /* Ptr to DSP handle                 */
typedef HGPC    FAR *PHGPC;            /* Ptr to GPC handle                 */
typedef HITCB   FAR *PHITCB;           /* Ptr to ITCB handle                */
typedef HFM     FAR *PHFM;             /* Ptr to Frame manager handle       */
typedef HDMA    FAR *PHDMA;            /* Ptr to DMA handle                 */

#include "mwaveapi.h"                  /* Automatically include MWAVEAPI.H  */
/* XLATOFF */

/****************************************************************************/
/* The following code is included when compiliing for IDC entry             */
/****************************************************************************/

#else                                  /* Else IDC compile                  */
typedef PVOID HDMA;                    /* DMA handle                        */
typedef PVOID HDSP;                    /* DSP handle                        */
typedef PVOID HFM;                     /* Frame manager handle              */
typedef PVOID HGPC;                    /* GPC handle                        */
typedef PVOID HIPC;                    /* IPC handle                        */
typedef PVOID HITCB;                   /* ITCB handle                       */
typedef PVOID HMISC;                   /* Miscellaneous handle              */
typedef PVOID HMOD;                    /* Module handle                     */
typedef PVOID HSEG;                    /* Segment handle                    */
typedef PVOID HTASK;                   /* Task handle                       */
typedef PVOID PHDMA;                   /* Ptr to DMA handle                 */
typedef PVOID PHDSP;                   /* Ptr to DSP Handle                 */
typedef PVOID PHFM;                    /* Ptr to FM handle                  */
typedef PVOID PHGPC;                   /* Ptr to GPC Handle                 */
typedef PVOID PHIPC;                   /* Ptr to IPC Handle                 */
typedef PVOID PHITCB;                  /* Ptr to ITCB Handle                */
typedef PVOID PHMOD;                   /* Ptr to Module Handle              */
typedef PVOID PHSEG;                   /* Ptr to Segment Handle             */
typedef PVOID PHTASK;                  /* Ptr to Task Handle                */


/****************************************************************************/
/* IDC Entry Point, Used for 16:16 PDDs                                     */
/****************************************************************************/

typedef RPARM_COMMON FAR *PRPARM_COMMON;
typedef RC(FAR *DSPCMDFN)(PRPARM_COMMON pCOMMON);/* IDC Entry point         */
typedef RC(FAR *PDSPI)(VOID);          /* INT Callback                      */
#endif

/* XLATON */
/****************************************************************************/
/*  Global Type Declarations                                                */
/****************************************************************************/

typedef BYTE BFLG;                     /* 8 Bit - bit flag                  */
typedef USHORT USFLG;                  /* 16 Bit - bit flag                 */
typedef ULONG ULFLG;                   /* 32 Bit - bit flag                 */
typedef USFLG FAR *PUSFLG;             /* Ptr to Flag                       */
typedef USHORT HWID;
typedef USHORT FLAGS;

/****************************************************************************/
/* Version/Release Packet                                                   */
/****************************************************************************/

typedef struct rver {                  /*                                   */
      BYTE       bVersion;
      BYTE       bRelease;
} RVER;

/****************************************************************************/
/* Constants for dspAllocateSegment                                         */
/****************************************************************************/

#define  SEG_INST      0x0020          /* Code Segment                      */
#define  SEG_DATA      0x0000          /* Default: data seg                 */
#define  ALLOC_SEG_ALIGN1 0x0001       /* Align on 1 Word                   */
#define  ALLOC_SEG_ALIGN2 0x0002       /* Align on Word 2                   */
#define  ALLOC_SEG_ALIGN4 0x0004       /* Align on Word 4                   */
#define  ALLOC_SEG_ALIGN8 0x0008       /* Align on Word 8                   */
#define  ALLOC_SEG_ALIGN16 0x0010      /* Align on Word 16                  */
#define  ALLOC_SEG_ALIGN32 0x0020      /* Align on Word 32                  */
#define  ALLOC_SEG_ALIGN64 0x0040      /* Align on Word 64                  */
#define  ALLOC_SEG_ALIGN128 0x0080     /* Align on Word 128                 */

/****************************************************************************/
/* Constants for usLoadFlags for dspLoadModule(), dspChangeModuleState(),   */
/* dspChangeTaskState().                                                    */
/****************************************************************************/

#define  DSP_ACTIVATE_INACTIVE 0x0000  /* module or task to inactive mode   */
#define  DSP_ACTIVATE_STANDBY 0x0001   /* module or task to standby mode    */
#define  DSP_ACTIVATE_ACTIVE 0x0002    /* module or task to active mode     */

/****************************************************************************/
/* Constants for dspMemTransfer                                             */
/****************************************************************************/

#define  DSP_MEMXFER_DATA_READ 0x0000
#define  DSP_MEMXFER_DATA_WRITE 0x0001
#define  DSP_MEMXFER_PROG_READ 0x0002
#define  DSP_MEMXFER_PROG_WRITE 0x0004
#define  DSP_MEMXFER_READCLEAR 0x0008

/****************************************************************************/
/* Mwave Error Return Codes                                                 */
/****************************************************************************/

#define  DSP_NOERROR          0x0000   /* Operation successful              */
#define  DSP_ERROR            0x0001
#define  DSP_INV_FLAG         0x0002   /* Invalid action flag               */
#define  DSP_FILE_NOT_FOUND   0x0003   /* DSP file not found                */
#define  DSP_MOD_NOT_FOUND    0x0004   /* Module name not found in DSP file */
#define  DSP_LABEL_NOT_FOUND  0x0005   /* Label not found                   */
#define  DSP_INV_LABEL_OFFSET 0x0006   /* Invalid label offset              */
#define  DSP_BUFFER_OVERFLOW  0x0007   /* Query buffer size is too small    */
#define  DSP_DUPLICATE_NAME   0x0008   /* Instance name is a duplicate of   */
                                       /* existing name                     */
#define  DSP_INSUFF_DATA_MEM  0x0009   /* Insufficient data memory to       */
                                       /* allocate                          */
#define  DSP_INSUFF_INST_MEM  0x000a   /* Insufficient instruction memory to*/
                                       /* allocate                          */
#define  DSP_INV_XFER_SIZE    0x000b   /* Invalid MemTransfer buffer size   */
#define  DSP_INSUFF_CPS       0x000c   /* Insufficient Cycles/second to     */
                                       /* allocate                          */
#define  DSP_INV_PRIORITY     0x000d   /* Invalid priority requested        */
#define  DSP_INV_PARAMETER    0x000e   /* Invalid parameter                 */
#define  DSP_INV_HANDLE       0x000f   /* Invalid handle                    */
#define  DSP_IPC_COMMITTED    0x0010   /* IPC Channel already commited      */
#define  DSP_NAME_NOT_FOUND   0x0011   /* The object name is not found      */
#define  DSP_INV_TASK_STATE   0x0012   /* One of the tasks is inactive      */
#define  DSP_INS_RESOURCE     0x0013   /* Insufficient DSP CPF resource     */

/* Return codes 14-1F are reserved                                          */

#define  DSP_INV_DSP_HANDLE   0x0020   /* Invalid DSP handle                */
#define  DSP_INV_MOD_HANDLE   0x0021   /* Invalid MODule handle             */
#define  DSP_INV_TSK_HANDLE   0x0022   /* Invalid TaSK handle               */
#define  DSP_INV_SEG_HANDLE   0x0023   /* Invalid SEGment handle            */
#define  DSP_INV_DMA_HANDLE   0x0024   /* Invalid DMA handle                */
#define  DSP_INV_IPC_HANDLE   0x0025   /* Invalid IPC handle                */
#define  DSP_INV_GPC_HANDLE   0x0026   /* Invalid GPC handle                */
#define  DSP_INS_HW_RES       0x0027   /* Insufficient HW resources         */
#define  DSP_INS_BUFFER       0x002B   /* Insufficient buffer size          */
#define  DSP_BUFFER_UNCOMMITED 0x002C  /* Buffer Not Commited               */
#define  DSP_INV_DDS_FREE     0x002D   /* Default Data Segment              */
#define  DSP_MGR_NOT_FOUND    0xf02E   /* Unable to contact DSP Manager     */
#define  DSP_NO_BIOS_TASKS    0xf02F   /* No BIOS tasks were found in file  */
#define  DSP_RESET_FAULT      0x0030   /* DSP reset failure                 */
#define  DSP_HALT_FAULT       0x0031   /* DSP halt failure                  */
#define  DSP_WRITE_FAULT      0x0032   /* DSP write failure                 */
#define  DSP_READ_FAULT       0x0033   /* DSP read failure                  */
#define  DSP_ISPOS_ERROR      0x0034   /* To be removed (name changed)      */
#define  DSP_MWAVEOS_ERROR    0x0034   /* Mwave/OS error                    */
#define  DSP_HWDEVICE_NOT_AVAILABLE 0X0035 /* HW not available              */
#define  DSP_INV_IPC          0x0036   /* No IPC claimed by task            */
#define  DSP_INS_STRIDE_HOLD_ENTRIES 0x0037 /* No stride/hold tbl room      */
#define  DSP_INS_DMA_PKT_ENTRIES 0x0038 /* No DMA pkt entry room            */
#define  DSP_INS_IPC_CHANNELS 0x0039   /* No more IPC Channels              */
#define  DSP_INV_FM           0x003A   /* Invalid Frame size, Sample Rate,  */
                                       /* or Frame size too big             */
#define  DSP_DUPLICATE_SEGMENT_NAME 0x003b /* Duplicate seg names during    */
                                       /* loadmodule                        */
#define  DSP_INS_BUS_CAPACITY 0x003C   /* Insufficient bus capacity         */
#define  DSP_INV_ADDRESS      0x003D   /* Invalid DSP address         CH02  */
#define DSP_SERVER_NOT_READY  0x003e   /* Mwave Server not ready to process
                                            API commands yet. */
#define DSP_INTERNAL_IPC_ERROR 0x003f  /* Could not send/recv internal data*/
#define DSP_INS_HANDLE         0x0040  /* pointer to return handle was NULL*/

#define  DSP_NO_INST          0xf000   /* No inst segments found            */
#define  DSP_NO_DATA          0xf001   /* No data segments found            */
#define  DSP_INV_OS_LOAD      0xf002   /* OS load error                     */
#define  DSP_INV_APERIODIC_FM 0xf003   /* Invalid aperiodic frame mgr       */
#define  DSP_EMPTY_MODULE     0xf004   /* No tasks found in module          */
#define  DSP_GPCSYNC_ERROR    0xf005   /* Error during GPC synchronization  */
#define  DSP_INVALID_TCB_ADDR 0xf006   /* TCB doesn't exist within FixupTCB */
#define  DSP_CHNG_STATE_ERROR 0xf007   /* Error during Change State function*/
#define  DSP_FIX_ADDR_ERR     0xf008   /* Calculated address out of bounds  */
#define  DSP_READFILE_EOF     0xf009   /* Attempt to read past EOF          */
#define  DSP_WRITEFILE_NS     0xf00a   /* Disk full error condition         */
#define  DSP_INV_TASK_TYPE    0xf00b   /* Invalid task type                 */
#define  DSP_IO_ERROR         0xf040   /* DSP I/O error.                    */
#define  DSP_IO_INV_HANDLE    0xf041   /* Invalid file handle               */
#define  DSP_IO_INV_DSPFILE   0xf042   /* Invalid DSP file                  */
#define  DSP_INV_GPC_BUF_SIZE 0xf080   /* Invalid GPC buffer size           */
#define  DSP_INSUFF_MEM       0xf081   /* Insufficient PC memory            */
#define  DSP_INV_GPC_MODE     0xf082   /* GPC User/Owner modes do not match */
#define  DSP_INV_GPC_TYPE     0xf083   /* Wrong type of GPC                 */
#define  DSP_GPC_CONNECTED    0xf084   /* GPC still connected.              */
#define  DSP_GPC_NOTCONNECTED 0xf085   /* GPCs not connected.               */
#define  DSP_INV_ITCB_CONNECT 0xf086   /* ITCBs are on different DSP        */
#define  DSP_INV_ITCB_TYPE    0xf087   /* Wrong type of ITCB                */
#define  DSP_ITCB_CONNECTED   0xf088   /* ITCB still connected.             */
#define  DSP_ITCB_NOTCONNECTED 0xf089  /* ITCB not connected.               */
#define  DSP_NO_CONNECTIONS   0xf08A   /* Task is not connected             */
#define  DSP_NO_DSP_FOUND     0xf090   /* No DSPs found in machine          */
#define  DSP_INIT_ERROR       0xf091   /* Error locating DSP's              */
#define  DSP_GPC_SAMPLE_RATES 0xf092   /* Sample rates do not match         */
#define  DSP_INV_GPC_SIZE     0xf093   /* GPC User and Owner size not equal */
#define  DSP_INV_GPC_CONNECT  0xf094   /* GPC User/Owner on different DSPs  */
#define  DSP_INV_GPC_PROTOCOL 0xf095   /* Wrong protocols for user/owner    */
#define  DSP_INTERNAL_ERROR   0xf096   /* Internal data integrity error     */
#define  DSP_NOT_SUPPORTED    0xf097   /* Function not supported            */
#define  DSP_INTERNAL_CORRUPT 0xf098   /* Internal data integrity error     */
#define  DSP_INV_GPC_STRIDE   0xf099   /* Sync strides do not match    CH01 */
#define  DSP_OWNER_TASK_FREE  0xf0A1   /* Owner Task Freeed                 */
#define  DSP_USER_TASK_FREE   0xf0A2   /* User Task Freeed                  */
#define  DSP_OW_US_TASK_FREE  0xf0A3   /* Owner and User Task Free          */
#define  DSP_NOT_AVAILABLE    0xf0A4   /* DSP not available (suspend?) CH12 */
#define  DSP_NO_MWAVEDM       0xff03   /* Mwave daemon not responding  CH07 */

/****************************************************************************/
/* Section 2 - IDC Interface.                                               */
/****************************************************************************/

/****************************************************************************/
/* Category Code and Function Codes used in IDC (ring-0) calls.             */
/****************************************************************************/

#define  CATEGORY2                     0x81L  /* Function category          */
#define  DSPMDDCAT                     0x81L
#define  DSPMDD_DspAbilities           0x40L
#define  DSPMDD_DspAllocateSegment     0x41L
#define  DSPMDD_DspChangeCPF           0x42L
#define  DSPMDD_DspChangeDMA           0x43L
#define  DSPMDD_DspChangeModuleState   0x44L
#define  DSPMDD_DspChangeTaskState     0x45L
#define  DSPMDD_DspConnectGPC          0x46L
#define  DSPMDD_DspConnectIPC          0x47L
#define  DSPMDD_DspConnectITCB         0x48L
#define  DSPMDD_DspDisconnectIPC       0x49L
#define  DSPMDD_DspDisconnectGPC       0x4AL
#define  DSPMDD_DspDisconnectITCB      0x4BL
#define  DSPMDD_DspFreeModule          0x4CL
#define  DSPMDD_DspFreeSegment         0x4DL
#define  DSPMDD_DspFreeTask            0x4EL
#define  DSPMDD_DspInit                0x4FL
#define  DSPMDD_DspLabelToAddr         0x50L
#define  DSPMDD_DspLoadModule          0x51L
#define  DSPMDD_DspLoadSegment         0x52L
#define  DSPMDD_DspLoadTask            0x53L
#define  DSPMDD_DspLockMem             0x54L
#define  DSPMDD_DspMemTransfer         0x55L
#define  DSPMDD_DspNameToModuleHandle  0x56L
#define  DSPMDD_DspNameToSegmentHandle 0x57L
#define  DSPMDD_DspNameToTaskHandle    0x58L
#define  DSPMDD_DspQueryDSPInfo        0x59L
#define  DSPMDD_DspQueryManagerInfo    0x5AL
#define  DSPMDD_DspQueryMiscInfo       0x5BL
#define  DSPMDD_DspQueryModuleInfo     0x5CL
#define  DSPMDD_DspQueryTaskInfo       0x5DL
#define  DSPMDD_DspReset               0x5EL
#define  DSPMDD_DspRun                 0x5FL
#define  DSPMDD_DspUnLockMem           0x60L

#pragma  pack(1)                            /* Make query buffers packed */

/****************************************************************************/
/* dspAbilites  packet                                                      */
/****************************************************************************/

typedef struct rparm_abilities {       /*                                   */
      ULONG      ABILITIES_ulFunc;     /* DSPMDD_DspAbilitesDsp             */
      HDSP       ABILITIES_hDsp;       /* Dsp Handle                        */
      PUSHORT    ABILITIES_pusSize;    /* Pointer to size of buffer         */
      PVOID      ABILITIES_pDSPQueryBuf; /* Pointer to buffer               */
      ULONG      ABILITIES_ulRC;       /* Return Code                       */
} RPARM_ABILITIES;

/****************************************************************************/
/* dspAllocateSegment packet                                                */
/****************************************************************************/

typedef struct rparm_allocseg {        /*                                   */
      ULONG      ALLOCSEG_ulFunc;      /* DSPMDD_DspAllocateSegment         */
      HTASK      ALLOCSEG_hTask;       /* Task handle                       */
      PSZ        ALLOCSEG_pszInstanceName; /* Segment instance name         */
      ULONG      ALLOCSEG_ulSize;      /* Size of new segment               */
      ULONG      ALLOCSEG_ulAlign;     /* alignment of segment              */
      USHORT     ALLOCSEG_usFlags;     /* Type of segment                   */
      ULONG      ALLOCSEG_ulDSPAddr;   /* DSP address to store segment ptr  */
      PHSEG      ALLOCSEG_phSeg;       /* Segment handle returned           */
      ULONG      ALLOCSEG_ulRC;        /* Return Code                       */
} RPARM_ALLOCSEG;

/****************************************************************************/
/* dspChangeCPF packet                                                      */
/****************************************************************************/

typedef struct rparm_chcpf {           /*                                   */
      ULONG      CHCPF_ulFunc;         /* DSPMDD_DspChangeCPF               */
      HTASK      CHCPF_hTask;          /* Task handle                       */
      LONG       CHCPF_lCPF;           /* Delta cycles/frame to apply       */
      ULONG      CHCPF_ulRC;           /* Return Code                       */
} RPARM_CHCPF;

/****************************************************************************/
/* dspChangeDMA packet                                                      */
/****************************************************************************/

typedef struct rparm_chdma {           /*                                   */
      ULONG      CHDMA_ulFunc;         /* DSPMDD_DspChangeDMA               */
      HTASK      CHDMA_hTask;          /* Task handle                       */
      PSZ        CHDMA_pszDMAName;     /* Name of DMA to change             */
      LONG       CHDMA_lPacket;        /* Change to number of packets       */
      LONG       CHDMA_lMaxPacketSize; /* Max packet size                   */
      LONG       CHDMA_lMaxPacketPF;   /* Max packets per frame             */
      USHORT     CHDMA_usStride;       /* New stride value                  */
      USHORT     CHDMA_usHold;         /* New hold value                    */
      ULONG      CHDMA_ulRC;           /* Return Code                       */
} RPARM_CHDMA;

/****************************************************************************/
/* dspChangeModuleState packet                                              */
/****************************************************************************/

typedef struct rparm_chmodstate {      /*                                   */
      ULONG      CHMODSTATE_ulFunc;    /* DSPMDD_DspChangeModuleState       */
      HMOD       CHMODSTATE_hMOD;      /* Module handle                     */
      USHORT     CHMODSTATE_usFlags;   /* State of module                   */
      ULONG      CHMODSTATE_ulRC;      /* Return Code                       */
} RPARM_CHMODSTATE;

/****************************************************************************/
/* dspChangeTaskState packet                                                */
/****************************************************************************/

typedef struct rparm_chtaskstate {     /*                                   */
      ULONG      CHTASKSTATE_ulFunc;   /* DSPMDD_DspChangeTaskState         */
      HTASK      CHTASKSTATE_hTask;    /* Task handle                       */
      USHORT     CHTASKSTATE_usFlags;  /* State of task                     */
      ULONG      CHTASKSTATE_ulRC;     /* Return Code                       */
} RPARM_CHTASKSTATE;

/****************************************************************************/
/* dspConnectGPC packet                                                     */
/****************************************************************************/

typedef struct rparm_conngpc {         /*                                   */
      ULONG      CONNGPC_ulFunc;       /* DSPMDD_DspConnnectGPC             */
      HTASK      CONNGPC_hOwnerTask;   /* Owner Task handle                 */
      PSZ        CONNGPC_pszOwner;     /* GPC owner name                    */
      HTASK      CONNGPC_hUserTask;    /* User Task handle                  */
      PSZ        CONNGPC_pszUser;      /* GPC user name                     */
      USHORT     CONNGPC_usProtocol;   /* NULL - unsupported                */
      PULONG     CONNGPC_pulDSPAddr;   /* Ptr to Address of User Data       */
      ULONG      CONNGPC_ulRC;         /* Return Code                       */
} RPARM_CONNGPC;

/****************************************************************************/
/* dspConnectIPC packet                                                     */
/****************************************************************************/

typedef struct rparm_connipc {         /*                                   */
      ULONG      CONNIPC_ulFunc;       /* DSPMDD_DspConnnectIPC             */
      HTASK      CONNIPC_hTask;        /* Task handle                       */
      PFN        CONNIPC_pfnIPCNotice; /* Pointer to Interrupt handler fn   */
      PHIPC      CONNIPC_phIPC;        /* Address of HIPC                   */
      USHORT     CONNIPC_usType;       /* RESERVED                          */
      ULONG      CONNIPC_ulRC;         /* Return Code                       */
} RPARM_CONNIPC;

/****************************************************************************/
/* dspConnectITCB packet                                                    */
/****************************************************************************/

typedef struct rparm_connitcb {        /*                                   */
      ULONG      CONNITCB_ulFunc;      /* DSPMDD_DspConnnectITCB            */
      HTASK      CONNITCB_hPTask;      /* Primary Task handle               */
      PSZ        CONNITCB_pszPName;    /* Primary ITCB name                 */
      HTASK      CONNITCB_hSTask;      /* Secondary Task handle             */
      PSZ        CONNITCB_pszSName;    /* Secondary ITCB name               */
      ULONG      CONNITCB_ulRC;        /* Return Code                       */
} RPARM_CONNITCB;

/****************************************************************************/
/* dspDiconnectIPC packet                                                   */
/****************************************************************************/

typedef struct rparm_discipc {         /*                                   */
      ULONG      DISCIPC_ulFunc;       /* DSPMDD_DspDisconnectIPC           */
      HIPC       DISCIPC_hIPC;         /* IPC handle                        */
      ULONG      DISCIPC_ulRC;         /* Return Code                       */
} RPARM_DISCIPC;

/****************************************************************************/
/* dspDisconnectGPC packet                                                  */
/****************************************************************************/

typedef struct rparm_discgpc {         /*                                   */
      ULONG      DISCGPC_ulFunc;       /* DSPMDD_DspDisconnectGPC           */
      HTASK      DISCGPC_hOwnerTask;   /* Owner Task handle                 */
      PSZ        DISCGPC_pszOwner;     /* Owner name                        */
      HTASK      DISCGPC_hUserTask;    /* User Task handle                  */
      PSZ        DISCGPC_pszUser;      /* User name                         */
      ULONG      DISCGPC_ulRC;         /* Return Code                       */
} RPARM_DISCGPC;

/****************************************************************************/
/* dspDisconnectITCB packet                                                 */
/****************************************************************************/

typedef struct rparm_discitcb {        /*                                   */
      ULONG      DISCITCB_ulFunc;      /* DSPMDD_DspDisconnectGPC           */
      HTASK      DISCITCB_hPTask;      /* Primary Task handle               */
      PSZ        DISCITCB_pszPName;    /* Primary ITCB name                 */
      HTASK      DISCITCB_hSTask;      /* Secondary Task handle             */
      PSZ        DISCITCB_pszSName;    /* Secondary ITCB name               */
      ULONG      DISCITCB_ulRC;        /* Return Code                       */
} RPARM_DISCITCB;

/****************************************************************************/
/* dspFreeModule packet                                                     */
/****************************************************************************/

typedef struct rparm_freemod {         /*                                   */
      ULONG      FREEMOD_ulFunc;       /* DSPMDD_DspFreeModule              */
      HMOD       FREEMOD_hMOD;         /* Module handle                     */
      USHORT     FREEMOD_usFlags;      /* RESERVED                          */
      ULONG      FREEMOD_ulRC;         /* Return Code                       */
} RPARM_FREEMOD;

/****************************************************************************/
/* dspFreeSegment packet                                                    */
/****************************************************************************/

typedef struct rparm_freeseg {         /*                                   */
      ULONG      FREESEG_ulFunc;       /* DSPMDD_DspFreeSegment             */
      HSEG       FREESEG_hSeg;         /* Segment handle                    */
      ULONG      FREESEG_ulRC;         /* Return Code                       */
} RPARM_FREESEG;

/****************************************************************************/
/* dspFreeTask packet                                                       */
/****************************************************************************/

typedef struct rparm_freetask {        /*                                   */
      ULONG      FREETASK_ulFunc;      /* DSPMDD_DspFreeTask                */
      HTASK      FREETASK_hTask;       /* Task handle                       */
      ULONG      FREETASK_ulRC;        /* Return Code                       */
} RPARM_FREETASK;

/****************************************************************************/
/* dspInit packet                                                           */
/****************************************************************************/

typedef struct rparm_init {            /*                                   */
      ULONG      INIT_ulFunc;          /* DSPMDD_DspInit                    */
      HDSP       INIT_hDSP;            /* DSP handle                        */
      PSZ        INIT_pszFileName;     /* "MWAVEOSx.DSP"                    */
      USHORT     INIT_usState;         /* RESERVED                          */
      ULONG      INIT_ulRC;            /* Return Code                       */
} RPARM_INIT;

/****************************************************************************/
/* dspLabelToAddress packet                                                 */
/****************************************************************************/

typedef struct rparm_labtoadd {        /*                                   */
      ULONG      LABTOADD_ulFunc;      /* DSPMDD_DspLabelToAddr             */
      HTASK      LABTOADD_hTask;       /* Task handle                       */
      PSZ        LABTOADD_pszName;     /* Label name                        */
      PULONG     LABTOADD_pulDSPAddr;  /* Pointer to loc to hold address    */
      ULONG      LABTOADD_ulRC;        /* Return Code                       */
} RPARM_LABTOADD;

/****************************************************************************/
/* dspLoadModule packet                                                     */
/****************************************************************************/

typedef struct rparm_loadmod {         /*                                   */
      ULONG      LOADMOD_ulFunc;       /* DSPMDD_DspLoadModule              */
      HDSP       LOADMOD_hDSP;         /* Handle of DSP                     */
      PSZ        LOADMOD_pszFileName;  /* DSP file name                     */
      PSZ        LOADMOD_pszInstanceName; /* Module instance name           */
      USHORT     LOADMOD_usFlags;      /* State to load module in           */
      PHMOD      LOADMOD_phMOD;        /* Module handle returned            */
      ULONG      LOADMOD_ulRC;         /* Return Code                       */
} RPARM_LOADMOD;

/****************************************************************************/
/* dspLoadSegment packet                                                    */
/****************************************************************************/

typedef struct rparm_loadseg {         /*                                   */
      ULONG      LOADSEG_ulFunc;       /* DSPMDD_DspLoadSegment             */
      HTASK      LOADSEG_hTask;        /* Task handle                       */
      PSZ        LOADSEG_pszFileName;  /* Name of DSP file                  */
      PSZ        LOADSEG_pszSegmentName; /* Name of segment in file         */
      PSZ        LOADSEG_pszInstanceName; /* Instance name for segment      */
      ULONG      LOADSEG_ulDSPAddr;    /* Location to write segment addr    */
      PHSEG      LOADSEG_phSeg;        /* Module handle returned            */
      ULONG      LOADSEG_ulRC;         /* Return Code                       */
} RPARM_LOADSEG;

/****************************************************************************/
/* dspLoadTask packet                                                       */
/****************************************************************************/

typedef struct rparm_loadtask {        /*                                   */
      ULONG      LOADTASK_ulFunc;      /* DSPMDD_DspLoadTask                */
      HMOD       LOADTASK_hMod;        /* Module handle                     */
      HDSP       LOADTASK_hDSP;        /* DSP handle for task               */
      PSZ        LOADTASK_pszFileName; /* Name of DSP file                  */
      PSZ        LOADTASK_pszTaskName; /* Name of task in DSP file          */
      PSZ        LOADTASK_pszInstanceName; /* Instance name for task        */
      USHORT     LOADTASK_usFlags;     /* State to place task in after load */
      PVOID      LOADTASK_pRQHWBuf;    /* HW Info Buffer                    */
      PHTASK     LOADTASK_phTask;      /* Task handle returned              */
      ULONG      LOADTASK_ulRC;        /* Return Code                       */
} RPARM_LOADTASK;

/****************************************************************************/
/* dspLockMem packet                                                        */
/****************************************************************************/

typedef struct rparm_lockm {           /*                                   */
      ULONG      LOCKM_ulFunc;         /* DSPMDD_DspLockMem                 */
      PVOID      LOCKM_pBuffer;        /* Pointer to memory to lock         */
      ULONG      LOCKM_ulBufSize;      /* Size of memory to lock            */
      PHLOCK     LOCKM_phLock;         /* Pointer to HLOCK structure        */
      PUSHORT    LOCKM_pusPhysCount;   /* Size of PhysTable                 */
      PVOID      LOCKM_pPhysTable;     /* Pointer to PhysTable              */
      ULONG      LOCKM_ulRC;           /* Return Code                       */
} RPARM_LOCKM;

#define  DSP_LOCKMEM   0x00L           /* Equate for vmlock flags           */
#define  DSP_UNLOCKMEM 0x01L           /* Equate for vmlock flags           */
#define  VMLOCK_LONG   0x10L           /* 00010000B Long duration lock      */
#define  VMLOCK_VERIFY 0x20L           /* 00100000B Verify memory only      */
#define  VMLOCK_RW     0x8L            /* 00001000B Memory is read/write    */

/****************************************************************************/
/* dspMemTransfer packet                                                    */
/****************************************************************************/

typedef struct rparm_memxfer {         /*                                   */
      ULONG      MXFER_ulFunc;         /* DSPMDD_DspMemTransfer             */
      HDSP       MXFER_hDSP;           /* DSP handle for transfer op        */
      ULONG      MXFER_ulDSPAddr;      /* DSP address                       */
      PVOID      MXFER_pPCAddress;     /* PC address                        */
      USHORT     MXFER_usNumWords;     /* Number of 16-bit words to move    */
      USHORT     MXFER_usFlags;        /* Type of MemXfer operation         */
      ULONG      MXFER_ulRC;           /* Return Code                       */
} RPARM_MEMXFER;

/****************************************************************************/
/* dspNameToModuleHandle packet                                             */
/****************************************************************************/

typedef struct rparm_namemoduleh {     /*                                   */
      ULONG      NAMEMODULEH_ulFunc;   /* DSPMDD_DspNameToModuleHandle      */
      PSZ        NAMEMODULEH_pszInstanceName; /* Instance name of module    */
      PHMOD      NAMEMODULEH_phModule; /* Pointer to module handle          */
      ULONG      NAMEMODULEH_ulRC;     /* Return Code                       */
} RPARM_NAMEMODULEH;

/****************************************************************************/
/* dspNameToSegmentHandle packet                                            */
/****************************************************************************/

typedef struct rparm_namesegh {        /*                                   */
      ULONG      NAMESEGH_ulFunc;      /* DSPMDD_DspNameToSegmentHandle     */
      HTASK      NAMESEGH_hTask;       /* Task handle                       */
      PSZ        NAMESEGH_pszInstanceName; /* Segment instance name         */
      PHSEG      NAMESEGH_phSeg;       /* Pointer to segment handle         */
      ULONG      NAMESEGH_ulRC;        /* Return Code                       */
} RPARM_NAMESEGH;

/****************************************************************************/
/* dspNameToTaskHandle packet                                               */
/****************************************************************************/

typedef struct rparm_nametaskh {       /*                                   */
      ULONG      NAMETASKH_ulFunc;     /* DSPMDD_DspNameToTaskHandle        */
      HMOD       NAMETASKH_hMod;       /* Module handle                     */
      PSZ        NAMETASKH_pszInstanceName; /* Instance name of task        */
      PHTASK     NAMETASKH_phTask;     /* Pointer to task handle            */
      ULONG      NAMETASKH_ulRC;       /* Return Code                       */
} RPARM_NAMETASKH;

/****************************************************************************/
/* dspQueryDSPInfo packet                                                   */
/****************************************************************************/

typedef struct rparm_qdspinfo {        /*                                   */
      ULONG      QDSPINFO_ulFunc;      /* DSPMDD_DspQueryDSPInfo            */
      HDSP       QDSPINFO_hDsp;        /* DSP handle                        */
      PUSHORT    QDSPINFO_pusSize;     /* Size of buffer                    */
      PVOID      QDSPINFO_pDspInfoBuf; /* buffer                            */
      ULONG      QDSPINFO_ulRC;
} RPARM_QDSPINFO;

/****************************************************************************/
/* dspQueryManagerInfo packet                                               */
/****************************************************************************/

typedef struct rparm_qmaninfo {        /*                                   */
      ULONG      QMANINFO_ulFunc;      /* DSPMDD_DspQueryManagerInfo        */
      PUSHORT    QMANINFO_pusSize;     /* Size of buffer                    */
      PVOID      QMANINFO_pMgrInfoBuf; /* buffer                            */
      ULONG      QMANINFO_ulRC;        /* Return Code                       */
} RPARM_QMANINFO;

/****************************************************************************/
/* dspQueryMiscInfo packet                                                  */
/****************************************************************************/

typedef struct rparm_qmiscinfo {       /*                                   */
      ULONG      QMISCINFO_ulFunc;     /* DSPMDD_DspQueryMiscInfo           */
      USHORT     QMISCINFO_usType;     /* Type of misc call                 */
      HMISC      QMISCINFO_hMisc;      /* Handle to misc object             */
      PUSHORT    QMISCINFO_pusSize;    /* Size of buffer                    */
      PVOID      QMISCINFO_pMiscInfoBuf; /* Buffer used to return info      */
      ULONG      QMISCINFO_ulRC;       /* Return Code                       */
} RPARM_QMISCINFO;

/****************************************************************************/
/* dspQueryModuleInfo packet                                                */
/****************************************************************************/

typedef struct rparm_qmodinfo {        /*                                   */
      ULONG      QMODINFO_ulFunc;      /* DSPMDD_DspQueryModuleInfo         */
      HMOD       QMODINFO_hMod;        /* Module handle                     */
      PUSHORT    QMODINFO_pusSize;     /* Size of buffer                    */
      PVOID      QMODINFO_pModInfoBuf; /* buffer                            */
      ULONG      QMODINFO_ulRC;        /* Return Code                       */
} RPARM_QMODINFO;

/****************************************************************************/
/* dspQueryTaskInfo packet                                                  */
/****************************************************************************/

typedef struct rparm_qtaskinfo {       /*                                   */
      ULONG      QTASKINFO_ulFunc;     /* DSPMDD_DspQueryTaskInfo           */
      HTASK      QTASKINFO_hTask;      /* Task handle                       */
      PUSHORT    QTASKINFO_pusSize;    /* Pointer to size of buffer         */
      PVOID      QTASKINFO_pTaskInfoBuf; /* Pointer to buffer               */
      ULONG      QTASKINFO_ulRC;       /* Return Code                       */
} RPARM_QTASKINFO;

/****************************************************************************/
/* dspReset packet                                                          */
/****************************************************************************/

typedef struct rparm_resetdsp {        /*                                   */
      ULONG      RESETDSP_ulFunc;      /* DSPMDD_DspReset                   */
      HDSP       RESETDSP_hDsp;        /* DSP handle                        */
      ULONG      RESETDSP_ulRC;        /* Return Code                       */
} RPARM_RESETDSP;

/****************************************************************************/
/* dspRun packet                                                            */
/****************************************************************************/

typedef struct rparm_rundsp {          /*                                   */
      ULONG      RUNDSP_ulFunc;        /* DSPMDD_DspRun                     */
      HDSP       RUNDSP_hDsp;          /* DSP handle                        */
      ULONG      RUNDSP_ulRC;          /* Return Code                       */
} RPARM_RUNDSP;

/****************************************************************************/
/* dspUnLockMem packet                                                      */
/****************************************************************************/

typedef struct rparm_unlockm {         /*                                   */
      ULONG      UNLOCKM_ulFunc;       /* DSPMDD_DspUnlockMem               */
      PHLOCK     UNLOCKM_phLock;       /* Pointer HLOCK structure           */
      ULONG      UNLOCKM_ulRC;         /* Return Code                       */
} RPARM_UNLOCKM;

/****************************************************************************/
/* dspCreatePFT packet  CH05 Begin                                          */
/****************************************************************************/

/****************************************************************************/
/* DspAbilities                                                             */
/****************************************************************************/

typedef struct rdsp_abilities_info {   /* DSP's Abilities Info              */
      USHORT DSPABILITIES_usResv1;     /* Reserved - do not use             */
      USHORT DSPABILITIES_usResv2;     /* Reserved - do not use             */
      USHORT DSPABILITIES_usResv3;     /* Reserved - do not use             */
      ULONG  DSPABILITIES_ulResv4;     /* Reserved - do not use             */
      ULONG  DSPABILITIES_ulIPS;       /* Number of DSP IPS                 */
      ULONG  DSPABILITIES_ulDataStore; /* Data Store size in words          */
      ULONG  DSPABILITIES_ulInstStore; /* Instruction Store size            */
      ULONG  DSPABILITIES_ulSys_Bus_Capacity;/* Bus Transfers/Second        */
      USHORT DSPABILITIES_usSlot_Number;/* slot number of the adapter       */
      USHORT DSPABILITIES_usAdapter_ID;/* adapter ID                        */
      USHORT DSPABILITIES_usCOM;       /* COM port bitmap: 1=COM1,4=COM3... */
      USHORT DSPABILITIES_usResv5;     /* Reserved - do not use -           */
      ULONG  DSPABILITIES_ulResv6[8];  /* Reserved - do not use -           */
} RDSP_ABILITIES_INFO;                 /* CH09 End */

/****************************************************************************/
/* QueryDspInfo                                                             */
/****************************************************************************/

typedef struct rdspinfo {              /* DSP info                          */
      ULONG  DSPINFO_ulIPSLeft;        /* available IPS                     */
      ULONG  DSPINFO_ulRemainingBusCap;/* available bus                 */
      HMOD   DSPINFO_hMod_MwaveOS;     /* hMod to Mwave O/S                 */
      USHORT DSPINFO_usNumTasks;       /* Number of Tasks in DSP            */
      PHTASK DSPINFO_phTask;           /* Pointer to task handles           */
      USHORT DSPINFO_usNumFM;          /* Number of frame managers          */
      PHFM   DSPINFO_phFM;             /* Pointer to frame manager handles  */
} RDSPINFO;

/****************************************************************************/
/* QueryManagerInfo                                                         */
/****************************************************************************/

typedef struct rmgrinfo {              /* Manager Info                      */
      USHORT MGRINFO_usMajorVersion;   /* Release number 2                 */
      USHORT MGRINFO_usMinorVersion;   /* Version 99.                      */
      USHORT MGRINFO_usNumMod;         /* Number of Modules                 */
      PHMOD  MGRINFO_phMod;            /* Pointer to Module handles         */
      USHORT MGRINFO_usNumDSP;         /* Number of DSPs                    */
      PHDSP  MGRINFO_phDSP;            /* Pointer to DSP handles            */
} RMGRINFO;

/****************************************************************************/
/* QueryMiscInfo: DMAINFO                                                   */
/****************************************************************************/

typedef struct rdmainfo {              /* Misc DMA Info                     */
      PSZ    DMAINFO_pszDMAName;       /* Poiner to DMA name                */
      ULONG  DMAINFO_ulPackets;        /* Number of DMA packets             */
      ULONG  DMAINFO_ulMaxPkSize;      /* Maximum packet size               */
      ULONG  DMAINFO_ulMaxPerDMA;      /* Max DMA packets per frame         */
      ULONG  DMAINFO_ulStride;         /* Stride distance                   */
      ULONG  DMAINFO_ulHold;           /* Hold value                        */
      USFLG  DMAINFO_usFlag;           /* DMA flags; 0=share, 1=nonshare    */
} RDMAINFO;

/****************************************************************************/
/* QueryMiscInfo: GPCINFO                                                   */
/****************************************************************************/

typedef struct rgpcinfo {              /* Misc GPC Info                     */
      PSZ    GPCINFO_pszName;          /* GPC name                          */
      USFLG  GPCINFO_usflgKind;        /* Indicate if OWNER or USER GPC     */
      LONG   GPCINFO_lBufferSize;      /* GPC Buffer Size.                  */
      ULONG  GPCINFO_ulDSPAddr;        /* Address of CB in DSP data mem     */
      USHORT GPCINFO_usAddrMode;       /* GPC Address mode                  */
      USHORT GPCINFO_usMode;           /* GPC mode                          */
      ULONG  GPCINFO_ulSamplerate;     /* Lower 32 bits of GPC type         */
      USHORT GPCINFO_usMinPtrSep;      /* Min pointer separation            */
      USHORT GPCINFO_usMaxWPF;         /* Words per frame                   */
      USHORT GPCINFO_usIntegerStride;  /* Data words per sample period      */
      USHORT GPCINFO_usFractStride;    /* Fractional portion of stride      */
      LONG   GPCINFO_lMaxdelay;        /* Maximum Delay                     */
      USHORT GPCINFO_usProtocol;       /* Connection Protocol               */
      HGPC   GPCINFO_hgpcOwner;        /* Owner GPC. User GPC only          */
      HGPC   GPCINFO_hgpcUserListNext; /* User List                         */
      USHORT GPCINFO_usUseCount;       /* # of users Owner GPC only         */
      ULONG  GPCINFO_ulBufferAddr;     /* DSP address of GPC buffer         */
} RGPCINFO;

/****************************************************************************/
/* QueryMiscInfo: IPCINFO                                                   */
/****************************************************************************/

typedef struct ripcinfo {              /* Misc IPC Info                     */
      USHORT IPCINFO_usType;           /* 0 = address; 1 = semaphore        */
      ULONG  IPCINFO_ulCallBack;       /* Device driver call back, see type */
      USHORT IPCINFO_usMask;           /* IPC mask used by task             */
} RIPCINFO;

/****************************************************************************/
/* QueryMiscInfo:  FMINFO                                                   */
/****************************************************************************/

typedef struct rfminfo {               /* Frame manager info                */
      PSZ    FMINFO_pszName;           /* Name: for aperiodic grouping      */
      ULONG  FMINFO_ulFMCB;            /* DSP address of DSP FMCB           */
      PSZ    FMINFO_pszHWintsource;    /* hardware interrupt source         */
      ULONG  FMINFO_ulSampleRate;      /* sample rate                       */
      USHORT FMINFO_usSamplesPerFrame; /* Samples per frame                 */
      USHORT FMINFO_usUseCount;        /* count of tasks on thie frame mgr  */
      USFLG  FMINFO_usflgType;         /* Frame Manager type                */
} RFMINFO;

/****************************************************************************/
/* QueryMiscInfo: ITCBINFO                                                  */
/****************************************************************************/

typedef struct ritcbinfo {             /* ITCB info                         */
      PSZ    ITCBINFO_pszName;         /* ITCB name                         */
      USFLG  ITCBINFO_usflgKind;       /* Primary or Secondary              */
      ULONG  ITCBINFO_ulSize;          /* ITCB Size                         */
      ULONG  ITCBINFO_ulDSPAddr;       /* Address of CB in DSP data mem     */
      HITCB  ITCBINFO_hITCBPrimary;    /* HITCB of Primary ITCB             */
      HITCB  ITCBINFO_hITCBSecList;    /* HITCB of Secondary list           */
      USHORT ITCBINFO_usUseCount;      /* Num of Secondaries for Owner      */
} RITCBINFO;

/****************************************************************************/
/* QueryMiscInfo: SEGINFO                                                   */
/****************************************************************************/

typedef struct rseginfo {              /* Segment info                      */
      PSZ    SEGINFO_pszInstanceName;  /* Name of this segment              */
      PSZ    SEGINFO_pszRealName;      /* Original name of segment          */
      RVER   SEGINFO_rver;             /* Revision level of code            */
      RVER   SEGINFO_rverDSP;          /* Version of DSP                    */
      USFLG  SEGINFO_usflg;            /* Segment flags                     */
      ULONG  SEGINFO_ulDSPAddr;        /* Segment DSP address               */
      ULONG  SEGINFO_ulSize;           /* Size of Segment in words          */
} RSEGINFO;

/****************************************************************************/
/* QueryMiscInfo: LABELINFO                                                 */
/****************************************************************************/

typedef struct rlabelinfo {            /* Task Label info                   */
      USHORT LABELINFO_usNumDSLabels;  /* Number of task public data labels */
      PSZ    *LABELINFO_ppszDSLabels;  /* pointer to array of psz pointers  */
      USHORT LABELINFO_usNumISLabels;  /* Number of task public code labels */
      PSZ    *LABELINFO_ppszISLabels;  /* pointer to array of psz pointers  */
} RLABELINFO;

/****************************************************************************/
/* usType for QueryMiscInfo                                                 */
/****************************************************************************/

#define  MISC_GPC      0x0001          /* misc. type = GPC                  */
#define  MISC_DMA      0x0002          /* misc. type = DMA                  */
#define  MISC_IPC      0x0003          /* misc. type = IPC                  */
#define  MISC_ITCB     0x0004          /* misc. type = ITCB                 */
#define  MISC_FM       0x0005          /* misc. type = FM                   */
#define  MISC_SEG      0x0006          /* misc. type = SEG                  */
#define  MISC_LABELS   0x0007          /* misc. type = LABELS               */
#define  MISC_SEGLABELS 0x0008         /* misc. type = SEGMENT LABELS       */

/****************************************************************************/
/* QueryModuleInfo                                                          */
/****************************************************************************/

typedef struct rmodinfo {              /* Module info                       */
      PSZ    MODINFO_pszModName;       /* ACSIIZ Name of the module         */
      USHORT MODINFO_usNumTask;        /* Number of tasks in module         */
      PHTASK MODINFO_phTask;           /* Pointer to task handles           */
      RVER   MODINFO_rver;             /* Module version                    */
} RMODINFO;

/****************************************************************************/
/* QueryTaskInfo                                                            */
/****************************************************************************/

typedef struct rtaskinfo {             /* Task Info                         */
      PSZ    TSKINFO_pszInstanceName;  /* Task Instance Name                */
      HDSP   TSKINFO_hDSP;             /* DSP handle                        */
      RVER   TSKINFO_rver;             /* Revision level                    */
      ULONG  TSKINFO_ulCPF;            /* Cycles per frame                  */
      USHORT TSKINFO_usFlgType;        /* timer or Sample Rate              */
      USHORT TSKINFO_usFlgState;       /* Current activation state of task  */
      HFM    TSKINFO_hFM;              /* frame manager handle              */
      HIPC   TSKINFO_hIPC;             /* IPC handle                        */
      USHORT TSKINFO_usNumSeg;         /* Number of segments                */
      PHSEG  TSKINFO_phSeg;            /* Pointer to segment handles        */
      USHORT TSKINFO_usNumDMA;         /* Number of DMA handles             */
      PHDMA  TSKINFO_phDMA;            /* Pointer to DMA handles            */
      USHORT TSKINFO_usNumGPC;         /* Number of GPC handles             */
      PHGPC  TSKINFO_phGPC;            /* Pointer to GPC handles            */
      USHORT TSKINFO_usNumITCB;        /* Number of ITCB handles            */
      PHITCB TSKINFO_phITCB;           /* Pointer to ITCB handles           */
} RTASKINFO;

#pragma  pack()                            /* Make query buffers packed */

/* XLATOFF */
#endif                                 /* CH06 End #ifndef MWAVE_INCLUDED   */
/* XLATON */
