/*
 *   mwmfax.c -- Mwave Modem AT Command Parser
 *
 *  Written By: Paul Schroeder IBM Corporatio
 *
 *  Copyright (C) 1999 IBM Corporation
 *
 * This program is free software; you can redistribute it and/or modify      
 * it under the terms of the GNU General Public License as published by      
 * the Free Software Foundation; either version 2 of the License, or         
 * (at your option) any later version.                                       
 *                                                                           
 * This program is distributed in the hope that it will be useful,           
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             
 * GNU General Public License for more details.                              
 *                                                                           
 * NO WARRANTY                                                               
 * THE PROGRAM IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OR        
 * CONDITIONS OF ANY KIND, EITHER EXPRESS OR IMPLIED INCLUDING, WITHOUT      
 * LIMITATION, ANY WARRANTIES OR CONDITIONS OF TITLE, NON-INFRINGEMENT,      
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. Each Recipient is    
 * solely responsible for determining the appropriateness of using and       
 * distributing the Program and assumes all risks associated with its        
 * exercise of rights under this Agreement, including but not limited to     
 * the risks and costs of program errors, damage to or loss of data,         
 * programs or equipment, and unavailability or interruption of operations.  
 *                                                                           
 * DISCLAIMER OF LIABILITY                                                   
 * NEITHER RECIPIENT NOR ANY CONTRIBUTORS SHALL HAVE ANY LIABILITY FOR ANY   
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL        
 * DAMAGES (INCLUDING WITHOUT LIMITATION LOST PROFITS), HOWEVER CAUSED AND   
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR     
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE    
 * USE OR DISTRIBUTION OF THE PROGRAM OR THE EXERCISE OF ANY RIGHTS GRANTED  
 * HEREUNDER, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES             
 *                                                                           
 * You should have received a copy of the GNU General Public License         
 * along with this program; if not, write to the Free Software               
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
 *                                                                           
 * 
 *  10/23/2000 - Alpha Release 0.1.0
 *            First release to the public
 *
 */
/*****************************************************************************/
/* The routines in this module handle the switch between the Modem and       */
/* the Fax machine.                                                          */
/*                                                                           */
/* Each of these routines is called by mwmspcfcIPC() in mwmspcfc.c in        */
/* response to a message.                                             */
/*****************************************************************************/
#include <mwmspcfc.h>
#include <mwmcntnd.h>
#include <mwmcapi.h>


ULONG mwmFaxClass1ToDial(PMWM_DSPINFO pmwmDspInfo);


static char szThisFile[] = "MWMFAX.C";


ULONG mwmFaxDialToClass2(PMWM_DSPINFO pmwmDspInfo)
{
  ULONG  ulRC;
  ULONG  ulAddress = 0;
  USHORT usTempValue = 0;
//  HMTASK hmtFAXPMP,  hmtHDLC;  //Don't need hmtHDLC after class 2 restructure.
  HMTASK hmtFAXPMP;
  HMTASK hmtSILDET;


  { MW_SYSLOG_1(TRACE_MWMLW32,"mwmfax::mwmFaxDialToClass2 entry\n");  }


  /***************************************************************************/
  /* Load the other 2 Fax DSP Modules.                                       */
  /***************************************************************************/
//  ulRC = mwmCntndLoadModule(pmwmDspInfo,"FAX01","FAX000",&pmwmDspInfo->hmodFAX01,szThisFile,__LINE__);
//  if (ulRC)
//    return(ulRC);

  ulRC = mwmCntndLoadModule(pmwmDspInfo,"FAXPMP","FAXPMP0",&pmwmDspInfo->hmodFAXPMP,szThisFile,__LINE__);
  if (ulRC)
    return(ulRC);



  /***************************************************************************/
  /* Load MHINT, CL1_HDLC,  and T.30 tasks...                                */
  /***************************************************************************/
  ulRC = mwmCntndLoadModule(pmwmDspInfo,"MHINT","MHINT",&pmwmDspInfo->hmodMHINT,szThisFile,__LINE__);
  if (ulRC)
    return(ulRC);


   ulRC = mwmCntndLoadModule(pmwmDspInfo,"T30","T30",&pmwmDspInfo->hmodT30,szThisFile,__LINE__);
   if (ulRC)
     return(ulRC);

  ulRC = mwmCntndLoadModule(pmwmDspInfo,"CL1_HDLC","CL1_HDLC",&pmwmDspInfo->hmodCL1_HDLC,szThisFile,__LINE__);
  if (ulRC)
    return(ulRC);

  /* 01/15/97 DR - Load Silence Detection module */
  ulRC = mwmCntndLoadModule(pmwmDspInfo,"SILENCEDET","SILDET",&pmwmDspInfo->hmodSILDET,szThisFile,__LINE__);
  if (ulRC)
    return(ulRC);


  /***************************************************************************/
  /* Get Task handles of the tasks.                                          */
  /***************************************************************************/
  ulRC = dspNameToTaskHandle(pmwmDspInfo->hmodMHINT, "MHINT", &pmwmDspInfo->hmtMHINT);
  if (ulRC)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR,
                   ulRC );
    return (ulRC);
  }

//  ulRC = dspNameToTaskHandle(pmwmDspInfo->hmodFAX01, "HDLC", &hmtHDLC);
//  if (ulRC)
//  {
//    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
//                   MWM_DSP_ERROR,
//                   ulRC );
//    return (ulRC);
//  }



//  ulRC = dspNameToTaskHandle(pmwmDspInfo->hmodFAX01, "FAXMAN", &pmwmDspInfo->hmtFAXMAN);
//  if (ulRC)
//  {
//    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
//                   MWM_DSP_ERROR,
//                   ulRC );
//    return (ulRC);
//  }

  ulRC = dspNameToTaskHandle(pmwmDspInfo->hmodT30, "T30", &pmwmDspInfo->hmtT30);
  if (ulRC)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR,
                   ulRC );
    return (ulRC);
  }

  ulRC = dspNameToTaskHandle(pmwmDspInfo->hmodCL1_HDLC, "CL1_HDLC", &pmwmDspInfo->hmtCL1_HDLC);
  if (ulRC)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR,
                   ulRC );
    return (ulRC);
  }


  ulRC = dspNameToTaskHandle(pmwmDspInfo->hmodFAXPMP, "FAXPMP", &hmtFAXPMP);
  if (ulRC)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR,
                   ulRC );
    return (ulRC);
  }

  /* 01/15/97 DR - Silence Detection task */
  ulRC = dspNameToTaskHandle(pmwmDspInfo->hmodSILDET, "SILDET", &hmtSILDET);
  if (ulRC)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR,
                   ulRC );
    return (ulRC);
  }

  /***************************************************************************/
  /* This used to refer to "DCS" in FAXMAN.                                  */
  /* Now, we will refer to "DAT_BUFF" in the T30 task.                       */
  /* DCS is 4 words away from "DAT_BUFF".  We can use an offset to refer to  */
  /* it.                                                                     */
  /* For simplicity, I will leave the parser function name the same,         */
  /* It will still be SetDCSAddress...                                       */
  /***************************************************************************/
  ulRC = dspLabelToAddress(pmwmDspInfo->hmtT30, "DAT_BUFF", &ulAddress);
  if (ulRC!=DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR, ulRC);
    return(ulRC);
  }


  /***************************************************************************/
  /* MTS 4285 Allow FDCS? to work at interrupt time.  We need to save address*/
  /* of DCS so that FDCS? does not have to query it.                         */
  /***************************************************************************/
  ulRC =  mwmParseSetDCSAddress(ulAddress+8);

  ulRC = dspLabelToAddress(pmwmDspInfo->hmtT30, "CAP_BUFF", &ulAddress);
  if (ulRC!=DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR, ulRC);
    return(ulRC);
  }

  /***************************************************************************/
  /* Allow FDCC to work at interrupt time.  We need to save address          */
  /* of CAP_BUFF so that FDCC does not have to query it.                     */
  /***************************************************************************/
  ulRC =  mwmParseSetCAPBUFFAddress(ulAddress);

  ulRC = dspLabelToAddress(pmwmDspInfo->hmtT30, "MY_ID", &ulAddress);
  if (ulRC!=DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR, ulRC);
    return(ulRC);
  }

  /***************************************************************************/
  /* Allow FLID to work at interrupt time.  We need to save address          */
  /* of MY_ID so that FLID does not have to query it.                        */
  /***************************************************************************/
  ulRC =  mwmParseSetMYIDAddress(ulAddress);

  ulRC = dspLabelToAddress(pmwmDspInfo->hmtT30, "MY_CIG", &ulAddress);
  if (ulRC!=DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR, ulRC);
    return(ulRC);
  }

  /***************************************************************************/
  /* Allow FLID to work at interrupt time.  We need to save address          */
  /* of MY_ID so that FLID does not have to query it.                        */
  /***************************************************************************/
  ulRC =  mwmParseSetMYCIGAddress(ulAddress);

  /***************************************************************************/
  /* Connect GPCs for the FAX Datapump.                                      */
  /***************************************************************************/
  /*   BIOS.TAIO000..TAIO_OUTPUT CONNECT   FAXPMP..ADBUF                     */
  /***************************************************************************/
//  ulRC=mwmCntndConnectGPC(NULL,"TAIO_OUTPUT",hmtFAXPMP,"ADBUF",0,NULL,
//                          pmwmDspInfo, __FILE__,__LINE__ );
//  if (ulRC)
//    return(ulRC);


  ulRC=mwmCntndConnectGPC(NULL,"TAIO_OUTPUT",hmtFAXPMP,"SIGINV21",0,NULL,
                          pmwmDspInfo, szThisFile,__LINE__ );
  if (ulRC)
    return(ulRC);



 ulRC=mwmCntndConnectGPC(hmtFAXPMP,"RXDV21",pmwmDspInfo->hmtCL1_HDLC,"RV21GPC",0,NULL,
                         pmwmDspInfo, szThisFile,__LINE__ );
 if (ulRC)
   return(ulRC);





  /***************************************************************************/
  /*  BIOS.TAIO000..TAIO_OUTPUT CONNECT   FAXPMP..SIGIN                      */
  /***************************************************************************/
  ulRC=mwmCntndConnectGPC(NULL,"TAIO_OUTPUT",hmtFAXPMP,"SIGIN",0,NULL,
                          pmwmDspInfo, szThisFile,__LINE__ );
  if (ulRC)
    return(ulRC);


  /***************************************************************************/
  /*  FAXMAN..FRAMEGPC          CONNECT   HDLC..ERRGPC                       */
  /***************************************************************************/
  // 11/20/96 Remove for class 2 restructure
//  ulRC=mwmCntndConnectGPC(pmwmDspInfo->hmtFAXMAN,"FRAMEGPC",hmtHDLC,"ERRGPC",0,NULL,
//                          pmwmDspInfo, szThisFile,__LINE__ );
//  if (ulRC)
//    return(ulRC);


  /***************************************************************************/
  /*  HDLC..RXDLCGPC            CONNECT   MHINT..RHDLCGPC                    */
  /***************************************************************************/
  // 11/20/96 Remove for class 2 restructure
//  ulRC=mwmCntndConnectGPC(hmtHDLC,"RXDLCGPC",pmwmDspInfo->hmtMHINT,"RHDLCGPC",0,NULL,
//                          pmwmDspInfo, szThisFile,__LINE__ );
//  if (ulRC)
//    return(ulRC);
  ulRC=mwmCntndConnectGPC(pmwmDspInfo->hmtT30,"RIMGPC",pmwmDspInfo->hmtMHINT,"RHDLCGPC",0,NULL,
                          pmwmDspInfo, szThisFile,__LINE__ );
  if (ulRC)
    return(ulRC);


  /***************************************************************************/
  /*   HDLC..XDPGPC              CONNECT   FAXPMP..XMITDATA                  */
  /***************************************************************************/
  // 11/20/96 Remove for class 2 restructure
//  ulRC=mwmCntndConnectGPC(hmtHDLC,"XDPGPC",hmtFAXPMP,"XMITDATA",0,NULL,
//                          pmwmDspInfo, szThisFile,__LINE__ );
//  if (ulRC)
//    return(ulRC);
  ulRC=mwmCntndConnectGPC(pmwmDspInfo->hmtT30,"XDPGPC",pmwmDspInfo->hmtCL1_HDLC,"XIMGPC",0,NULL,
                          pmwmDspInfo, szThisFile,__LINE__ );
  if (ulRC)
    return(ulRC);


  /***************************************************************************/
  /*  MHINT..THDLCGPC           CONNECT   HDLC..XHDLCGPC                     */
  /***************************************************************************/
  // 11/20/96 Remove for class 2 restructure
//  ulRC=mwmCntndConnectGPC(pmwmDspInfo->hmtMHINT,"THDLCGPC",hmtHDLC,"XHDLCGPC",0,NULL,
//                          pmwmDspInfo, szThisFile,__LINE__ );
//  if (ulRC)
//    return(ulRC);
  ulRC=mwmCntndConnectGPC(pmwmDspInfo->hmtMHINT,"THDLCGPC",pmwmDspInfo->hmtT30,"XIMGPC",0,NULL,
                          pmwmDspInfo, szThisFile,__LINE__ );
  if (ulRC)
    return(ulRC);


  // 11/20/96 Tim Add for Class 2 Restruture
  ulRC=mwmCntndConnectGPC(pmwmDspInfo->hmtCL1_HDLC,"RIMGPC",pmwmDspInfo->hmtT30,"RDPGPC",0,NULL,
                          pmwmDspInfo, szThisFile,__LINE__ );
  if (ulRC)
    return(ulRC);




  /***************************************************************************/
  /*  MHINT..RIMGPC             CONNECT   CLASS2..RIMGPC                     */
  /***************************************************************************/
  ulRC=mwmCntndConnectGPC(pmwmDspInfo->hmtMHINT,"RIMGPC",pmwmDspInfo->hmtCLASSx,"RIMGPC",0,NULL,
                          pmwmDspInfo, szThisFile,__LINE__ );
  if (ulRC)
    return(ulRC);


  /***************************************************************************/
  /*  FAXPMP..SIGOUT            CONNECT   BIOS.TAIO000..TAIO_INPUT           */
  /***************************************************************************/
  ulRC=mwmCntndConnectGPC(hmtFAXPMP,"SIGOUT",NULL,"TAIO_INPUT",0,NULL,
                          pmwmDspInfo, szThisFile,__LINE__ );
  if (ulRC)
    return(ulRC);


  /***************************************************************************/
  /*  FAXPMP..RECVDAT           CONNECT   HDLC..RDPGPC                       */
  /***************************************************************************/
  // 11/20/96 Remove for class 2 restructure
  //ulRC=mwmCntndConnectGPC(hmtFAXPMP,"RECVDAT",hmtHDLC,"RDPGPC",0,NULL,
  //                        pmwmDspInfo, szThisFile,__LINE__ );
  //if (ulRC)
  //  return(ulRC);


  /***************************************************************************/
  /*  CLASS2..XIMGPC            CONNECT   MHINT..XIMGPC                      */
  /***************************************************************************/
  ulRC=mwmCntndConnectGPC(pmwmDspInfo->hmtCLASSx,"XIMGPC",pmwmDspInfo->hmtMHINT,"XIMGPC",0,NULL,
                          pmwmDspInfo, szThisFile,__LINE__ );
  if (ulRC)
    return(ulRC);


  /***************************************************************************/
  /*  HDLC..RXCMDGPC            CONNECT   FAXMAN..RCMDGPC                    */
  /***************************************************************************/
  // 11/20/96 Remove for class 2 restructure
  //ulRC=mwmCntndConnectGPC(hmtHDLC,"RXCMDGPC",pmwmDspInfo->hmtFAXMAN,"RCMDGPC",0,NULL,
  //                        pmwmDspInfo, szThisFile,__LINE__ );
  //if (ulRC)
  //  return(ulRC);


  /***************************************************************************/
  /*  FAXMAN..XCMDGPC           CONNECT   HDLC..TCMDGPC                      */
  /***************************************************************************/
  // 11/20/96 Remove for class 2 restructure
  //ulRC=mwmCntndConnectGPC(pmwmDspInfo->hmtFAXMAN,"XCMDGPC",hmtHDLC,"TCMDGPC",0,NULL,
  //                        pmwmDspInfo, szThisFile,__LINE__ );
  //if (ulRC)
  //  return(ulRC);


  /***************************************************************************/
  /*  FAXPMP..RECVDAT           CONNECT   HDLC..RDPGPC                       */
  /***************************************************************************/
  ulRC=mwmCntndConnectGPC(hmtFAXPMP,"RECVDAT",pmwmDspInfo->hmtCL1_HDLC,"RDPGPC",0,NULL,
                          pmwmDspInfo, szThisFile,__LINE__ );
  if (ulRC)
    return(ulRC);


  /***************************************************************************/
  /*  FAXPMP..RECVDAT           CONNECT   HDLC..RDPGPC                       */
  /***************************************************************************/
  ulRC=mwmCntndConnectGPC(pmwmDspInfo->hmtCL1_HDLC,"XDPGPC",hmtFAXPMP,"XMITDATA",0,NULL,
                          pmwmDspInfo, szThisFile,__LINE__ );
  if (ulRC)
    return(ulRC);

  /***************************************************************************/
  /* 01/15/97 DR                                                             */
  /*  BIOS.TAIO000..TAIO_OUTPUT CONNECT   SILDET..SD_INPUT                   */
  /***************************************************************************/
  ulRC=mwmCntndConnectGPC(NULL,"TAIO_OUTPUT",hmtSILDET,"SD_INPUT",0,NULL,
                          pmwmDspInfo, szThisFile,__LINE__ );
  if (ulRC)
    return(ulRC);


  /***************************************************************************/
  /***************************************************************************/
  /* Connect FAX Datapump ITCBs                                              */
  /***************************************************************************/
  /***************************************************************************/
  /*  BIOS.TAIO000..TAIOITCB    CONNECT  FAXMAN..SECTAIO                     */
  /***************************************************************************/
  // 11/20/96 Remove for class 2 restructure
//  ulRC=dspConnectITCB(NULL,"TAIOITCB",pmwmDspInfo->hmtFAXMAN,"SECTAIO");
//  if (ulRC != DSP_NOERROR)
//  {
//    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
//                   MWM_DSP_ERROR, ulRC);
//    return(ulRC);
//  }


  /***************************************************************************/
  /*  BIOS.TAIO000..WTITCB      CONNECT  FAXMAN..SECWT  ;FAXMAN WT INTFC     */
  /***************************************************************************/
  // 11/20/96 Remove for class 2 restructure
//  ulRC=dspConnectITCB(NULL,"WTITCB",pmwmDspInfo->hmtFAXMAN,"SECWT");
//  if (ulRC != DSP_NOERROR)
//  {
//    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
//                   MWM_DSP_ERROR, ulRC);
//    return(ulRC);
//  }


  /***************************************************************************/
  /*  BIOS.TAIO000..WTITCB      CONNECT  FAXPMP..WTITCB ;FAXPMP WT INTFC     */
  /***************************************************************************/
  ulRC=dspConnectITCB(NULL,"WTITCB",hmtFAXPMP,"WTITCB");
  if (ulRC != DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR, ulRC);
    return(ulRC);
  }



  /***************************************************************************/
  /* ;   FAXMAN..CTLFITCB          CONNECT  MCTL..CTLFITCB                   */
  /***************************************************************************/
  // 11/20/96 Remove for class 2 restructure
//  ulRC=dspConnectITCB(pmwmDspInfo->hmtFAXMAN,"CTLFITCB",pmwmDspInfo->hmctlTask,"CTLFITCB");
//  if (ulRC != DSP_NOERROR)
//  {
//    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
//                   MWM_DSP_ERROR, ulRC);
//    return(ulRC);
//  }


  ulRC=dspConnectITCB(pmwmDspInfo->hmtT30,"FAXITCB",pmwmDspInfo->hmtMHINT,"SECXCMP");
  if (ulRC != DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR, ulRC);
    return(ulRC);
  }

  ulRC=dspConnectITCB(pmwmDspInfo->hmtT30,"C1HITCB",pmwmDspInfo->hmtCL1_HDLC,"C1HITCB");
  if (ulRC != DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR, ulRC);
    return(ulRC);
  }

  ulRC=dspConnectITCB(pmwmDspInfo->hmtCL1_HDLC,"CL1_MCTL",pmwmDspInfo->hmtT30,"CL1_MCTL");
  if (ulRC != DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR, ulRC);
    return(ulRC);
  }

  ulRC=dspConnectITCB(pmwmDspInfo->hmtT30,"T30_MCTL",pmwmDspInfo->hmctlTask,"CL1_MCTL");
  if (ulRC != DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR, ulRC);
    return(ulRC);
  }

  ulRC=dspConnectITCB(hmtFAXPMP,"FCTLITCB",pmwmDspInfo->hmtCL1_HDLC,"SECFCTL");
  if (ulRC != DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR, ulRC);
    return(ulRC);
  }

//  02/11/97 - DR - Call Progress ITCB no longer needed with the Silence
//                  Detect task.
//  ulRC=dspConnectITCB(pmwmDspInfo->hmtCallProg,"CPITCB",pmwmDspInfo->hmtCL1_HDLC,"CPITCB");
//  if (ulRC != DSP_NOERROR)
//  {
//    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
//                   MWM_DSP_ERROR, ulRC);
//    return(ulRC);
//  }

  /* 01/15/97 DR - Connect Silence Detect Task ITCB */
  ulRC=dspConnectITCB( hmtSILDET,"SDFAX", pmwmDspInfo->hmtCL1_HDLC,"SDITCB" );
  if (ulRC != DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR, ulRC);
    return(ulRC);
  }

  /* 10/22/97 DR - If no DSP IRQ, connect CAPITCB */
  if (GetPrivateProfileInt("OPTIONS", "NODSPIRQ", 0, INIFile )) {
    ulRC=dspConnectITCB(pmwmDspInfo->hmtT30,"CAPITCB",pmwmDspInfo->hmctlTask,"CAPITCB");
    if (ulRC != DSP_NOERROR)
    {
      mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                     MWM_DSP_ERROR, ulRC);
      return(ulRC);
    }
  } /* endif */


  /***************************************************************************/
  /*  9/12/94 Add the following connection...                                */
  /*  MHINT..SECDPITCB          CONNECT   FAXPMP..FCTLITCB                   */
  /***************************************************************************/
  ulRC=dspConnectITCB(hmtFAXPMP,"FCTLITCB",pmwmDspInfo->hmtMHINT,"SECDPITCB");
  if (ulRC != DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR, ulRC);
    return(ulRC);
  }

  /***************************************************************************/
  /*  9/27/94 Add the following connection...                                */
  /*  MHINT..MHC2ITCB          CONNECT   FAXPMP..MHC2ITCB                    */
  /***************************************************************************/
  ulRC=dspConnectITCB(pmwmDspInfo->hmtMHINT,"MHC2ITCB",pmwmDspInfo->hmtCLASSx,"MHC2ITCB");
  if (ulRC != DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR, ulRC);
    return(ulRC);
  }


  /***************************************************************************/
  /*  FAXPMP..FCTLITCB          CONNECT  FAXMAN..SECFCTL                     */
  /***************************************************************************/
  // 11/20/96 Remove for class 2 restructure
//  ulRC=dspConnectITCB(hmtFAXPMP,"FCTLITCB",pmwmDspInfo->hmtFAXMAN,"SECFCTL");
//  if (ulRC != DSP_NOERROR)
//  {
//    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
//                   MWM_DSP_ERROR, ulRC);
//    return(ulRC);
//  }


  /***************************************************************************/
  /*  FAXPMP..CPITCB            CONNECT  FAXMAN..SECCP                       */
  /***************************************************************************/
//  ulRC=dspConnectITCB(hmtFAXPMP,"CPITCB",pmwmDspInfo->hmtFAXMAN,"SECCP");
//  ulRC=dspConnectITCB(pmwmDspInfo->hmtCallProg,"CPITCB",pmwmDspInfo->hmtFAXMAN,"SECCP");
//  if (ulRC != DSP_NOERROR)
//  {
//    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
//                   MWM_DSP_ERROR, ulRC);
//    return(ulRC);
//  }


  /***************************************************************************/
  /*  FAXPMP..CPITCB            CONNECT  MCTL..CPITCB                        */
  /***************************************************************************/
//  ulRC=dspConnectITCB(hmtFAXPMP,"CPITCB",pmwmDspInfo->hmctlTask,"CPITCB");
//  if (ulRC != DSP_NOERROR)
//  {
//    mwmHandleError(pmwmDspInfo->pInstanceInfo,__FILE__,__LINE__,
//                   MWM_DSP_ERROR, ulRC);
//    return(ulRC);
//  }


  ulRC=dspConnectITCB(hmtFAXPMP,"FCTLITCB",pmwmDspInfo->hmctlTask,"FCTLITCB");
  if (ulRC != DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR, ulRC);
    return(ulRC);
  }



  /***************************************************************************/
  /* Activate the Fax Modules                                                */
  /***************************************************************************/
   ulRC = dspChangeModuleState(pmwmDspInfo->hmodMHINT, DSP_ACTIVATE_ACTIVE );
   if (ulRC != DSP_NOERROR)
   {
     mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                    MWM_DSP_ERROR, ulRC);
     return(ulRC);
   }


   ulRC = dspChangeModuleState(pmwmDspInfo->hmodT30, DSP_ACTIVATE_ACTIVE );
   if (ulRC != DSP_NOERROR)
   {
     mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                    MWM_DSP_ERROR, ulRC);
     return(ulRC);
   }

   ulRC = dspChangeModuleState(pmwmDspInfo->hmodCL1_HDLC, DSP_ACTIVATE_ACTIVE );
   if (ulRC != DSP_NOERROR)
   {
     mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                    MWM_DSP_ERROR, ulRC);
     return(ulRC);
   }



   ulRC = dspChangeModuleState(pmwmDspInfo->hmodFAXPMP, DSP_ACTIVATE_ACTIVE );
   if (ulRC != DSP_NOERROR)
   {
     mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                    MWM_DSP_ERROR, ulRC);
     return(ulRC);
   }

   /* 01/15/97 DR - Activate Silence Detection */
   ulRC = dspChangeModuleState(pmwmDspInfo->hmodSILDET, DSP_ACTIVATE_ACTIVE );
   if (ulRC != DSP_NOERROR)
   {
     mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                    MWM_DSP_ERROR, ulRC);
     return(ulRC);
   }


  /*****************************************************************************/
  /* Set the UART up to 3 no matter what type of connection.                   */
  /*****************************************************************************/
  if (pmwmDspInfo->usUARTMode & USE_UART)
  {
    USHORT usFailed;
    ulRC = mwmCntndSetUART(pmwmDspInfo, 3L*11000L/8L, MWM_MUSTHAVE,
                           &usFailed,szThisFile,__LINE__);
    if (usFailed)
      return ulRC;
  }


  /*********************************************************************/
  /* Write LOADDONE So that the Modem can continue negotiating.        */
  /*********************************************************************/
  ulRC = dspLabelToAddress(pmwmDspInfo->hmctlTask, "LOADDONE", &ulAddress);
  if (ulRC!=DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR, ulRC);
    return(ulRC);
  }

  usTempValue = 1;

  ulRC = dspMemTransfer(pmwmDspInfo->hDSP, ulAddress,
                        &usTempValue, 1,
                        DSP_MEMXFER_DATA_WRITE);
  if (ulRC!=DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR, ulRC);
    return(ulRC);
  }

  if (pmwmDspInfo->ulFeaturesToLoad & FEATURE_GETSIZE)
  {
    (*pfnWriteDSPSnapshot)(pmwmDspInfo->hDSP,"class2.snp");
  }


  { MW_SYSLOG_1(TRACE_MWMLW32,"mwmfax::mwmFaxDialToClass2 exit\n");  }


  return 0;
}











ULONG mwmFaxClass2ToDial(PMWM_DSPINFO pmwmDspInfo)
{
  ULONG   ulRC;

  { MW_SYSLOG_1(TRACE_MWMLW32,"mwmfax::mwmFaxClass2ToDial entry\n");  }


  DPF ("mwmFax Class 2 to Dial");

  /*****************************************************************************/
  /* Set the UART back down to 1                                               */
  /*****************************************************************************/
  if (pmwmDspInfo->usUARTMode & USE_UART)
  {
    USHORT usFailed;
    ulRC = mwmCntndSetUART(pmwmDspInfo, 1L*11000L/8L, MWM_MUSTHAVE,
                           &usFailed,szThisFile,__LINE__);
    if (usFailed)
      return ulRC;
  }



  /***************************************************************************/
  /* Unload the first Class 2 fax modules                                    */
  /***************************************************************************/
  ulRC = dspFreeModule(pmwmDspInfo->hmodMHINT);
  if (ulRC!=DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR,
                   ulRC );
    return ulRC;
  }
  pmwmDspInfo->hmodMHINT = 0;

  ulRC = dspFreeModule(pmwmDspInfo->hmodT30);
  if (ulRC!=DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR,
                   ulRC );
    return ulRC;
  }
  pmwmDspInfo->hmodT30 = 0;
  mwmParseSetCAPBUFFAddress(0);
  mwmParseSetMYIDAddress(0);
  mwmParseSetMYCIGAddress(0);

  ulRC = dspFreeModule(pmwmDspInfo->hmodCL1_HDLC);
  if (ulRC!=DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR,
                   ulRC );
    return ulRC;
  }
  pmwmDspInfo->hmodCL1_HDLC = 0;

  /***************************************************************************/
  /* MTS 4285 Allow FDCS? to work at interrupt time.  We need to save address*/
  /* of DCS so that FDCS? does not have to query it.                         */
  /*                                                                         */
  /* Here, we are clearing it so that if fdcs? is called when faxman is not  */
  /***************************************************************************/
  ulRC =  mwmParseSetDCSAddress(0);



  ulRC = dspFreeModule(pmwmDspInfo->hmodFAXPMP);
  if (ulRC!=DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR,
                   ulRC );
    return ulRC;
  }
  pmwmDspInfo->hmodFAXPMP = 0;

  /* 01/15/97 DR - Unload Silence Detection */
  ulRC = dspFreeModule(pmwmDspInfo->hmodSILDET);
  if (ulRC!=DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR,
                   ulRC );
    return ulRC;
  }
  pmwmDspInfo->hmodSILDET = 0;

  { MW_SYSLOG_1(TRACE_MWMLW32,"mwmfax::mwmFaxClass2ToDial exit\n");  }


  return 0;
}




ULONG MWM_ENTRY mwmFaxQueryProtocol(PMWM_DSPINFO pmwmDspInfo, char *achFaxProtocol)
{
  ULONG ulRC = 0;
  ULONG ulAddress = 0;
  USHORT ausDISFrame[2];

  { MW_SYSLOG_1(TRACE_MWMLW32,"mwmfax::mwmFaxQueryProtocol entry\n");  }


  /***************************************************************************/
  /* Query DCS Label...                                                      */
  /***************************************************************************/
  ulRC = dspLabelToAddress(pmwmDspInfo->hmtT30, "DAT_BUFF", &ulAddress);
  if (ulRC!=DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR, ulRC);
    return(ulRC);
  }

  /***************************************************************************/
  /* Read DIS Frame from FAXMAN                                              */
  /***************************************************************************/
  ulRC = dspMemTransfer(pmwmDspInfo->hDSP, ulAddress+8,
                        ausDISFrame, 2,
                        DSP_MEMXFER_DATA_READ);
  if (ulRC!=DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR,
                   ulRC);
    return(ulRC);
  }


  /***************************************************************************/
  /* Get the Bit Rate from the DIS Frame, and put it in the string           */
  /* Mask to get the 3 proper bits, then shift them to the right to get the  */
  /* right speed                                                             */
  /***************************************************************************/
  switch ( ( ausDISFrame[0] & 0x003c) >> 2)
  {

    case 0:
      /***********************************************************************/
      /* 2400                                                                */
      /***********************************************************************/
      strcpy(achFaxProtocol,"2400 ");
      break;
    case 4:
      /***********************************************************************/
      /* 4800                                                                */
      /***********************************************************************/
      strcpy(achFaxProtocol,"4800 ");
      break;
    case 0xC:
    case 0xD:
      /***********************************************************************/
      /* 7200                                                                */
      /***********************************************************************/
      strcpy(achFaxProtocol,"7200 ");
      break;
    case 8:
    case 9:
      /***********************************************************************/
      /* 9600                                                                */
      /***********************************************************************/
      strcpy(achFaxProtocol,"9600 ");
      break;
    case 5:
    case 6:
      /***********************************************************************/
      /* 12000                                                               */
      /***********************************************************************/
      strcpy(achFaxProtocol,"12000 ");
      break;
    case 1:
    case 2:
      /***********************************************************************/
      /* 14400                                                               */
      /***********************************************************************/
      strcpy(achFaxProtocol,"14400 ");
      break;
    default:
      /***********************************************************************/
      /* 14400                                                               */
      /***********************************************************************/
      strcpy(achFaxProtocol,"Unknown ");
      break;
  }


  /***************************************************************************/
  /* Look at the same bits again to get the protocol used...                 */
  /***************************************************************************/
  switch ( ( ausDISFrame[0] & 0x003c) >> 2)
  {
    case 0:
    case 4:
      /***********************************************************************/
      /* V.27ter                                                             */
      /***********************************************************************/
      strcat(achFaxProtocol,"V.27ter");
      break;
    case 8:
    case 0xC:
      /***********************************************************************/
      /* V.29                                                                */
      /***********************************************************************/
      strcat(achFaxProtocol,"V.29");
      break;
    case 1:
    case 5:
    case 9:
    case 0xD:
      /***********************************************************************/
      /* V.17                                                                */
      /***********************************************************************/
      strcat(achFaxProtocol,"V.17");
      break;
    case 2:
    case 0xA:
      /***********************************************************************/
      /* V.33                                                                */
      /***********************************************************************/
      strcat(achFaxProtocol,"V.33");
      break;
    default:
      /***********************************************************************/
      /***********************************************************************/
      strcat(achFaxProtocol,"Unknown");
      break;
  }

  { MW_SYSLOG_1(TRACE_MWMLW32,"mwmfax::mwmFaxQueryProtocol exit\n");  }

  return 0;
}

/*****************************************************************************/
/* Get and Set FCLASS                                                        */
/*                                                                           */
/* Always do LabelToAddress on a Get.  Set is called after Get, so just use  */
/* the current address.                                                      */
/*                                                                           */
/*****************************************************************************/
ULONG mwmFaxGetFCLASS(PMWM_DSPINFO pmwmDspInfo, USHORT *pusFCLASS, USHORT *pusSubMode)
{
  ULONG   ulRC;
  ULONG   ulAddressFCLASS = 0;

  { MW_SYSLOG_1(TRACE_MWMLW32,"mwmfax::mwmFaxGetFCLASS entry\n");  }


  ulRC = dspLabelToAddress(pmwmDspInfo->hmctlTask, "FCLASS", &ulAddressFCLASS);
  if (ulRC!=DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR, ulRC);
    return(ulRC);
  }


  ulRC = dspMemTransfer(pmwmDspInfo->hDSP, ulAddressFCLASS,
                        pusFCLASS, 1,
                        DSP_MEMXFER_DATA_READ);
  if (ulRC!=DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR, ulRC);
    return(ulRC);
  }

  { MW_SYSLOG_2(TRACE_MWMLW32,"mwmfax::mwmFaxGetFCLASS usFCLASS %x\n",*pusFCLASS);  }
  switch(*pusFCLASS)
  {
    case 0:
      /***********************************************************************/
      /* Since FCLASS is 0, we will use the SUBCLASS label to identify       */
      /* V.80 mode or not...                                                 */
      /***********************************************************************/
      ulRC = mwmV80LGetSUBCLASS(pmwmDspInfo,pusSubMode);           //$E
      if (ulRC)
        return (ulRC);
      break;
    default:
      *pusSubMode = 0;
  }

  { MW_SYSLOG_1(TRACE_MWMLW32,"mwmfax::mwmFaxGetFCLASS exit\n");  }


  return 0;
}


ULONG mwmFaxSetFCLASS(PMWM_DSPINFO pmwmDspInfo, USHORT usFCLASS)
{
  ULONG   ulRC;
  ULONG   ulAddressFCLASS = 0;

  { MW_SYSLOG_1(TRACE_MWMLW32,"mwmfax::mwmFaxSetFCLASS entry\n");  }


  ulRC = dspLabelToAddress(pmwmDspInfo->hmctlTask, "FCLASS", &ulAddressFCLASS);
  if (ulRC!=DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR, ulRC);
    return(ulRC);
  }

  ulRC = dspMemTransfer(pmwmDspInfo->hDSP, ulAddressFCLASS,
                        &usFCLASS, 1,
                        DSP_MEMXFER_DATA_WRITE);
  if (ulRC!=DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR, ulRC);
    return(ulRC);
  }

  { MW_SYSLOG_1(TRACE_MWMLW32,"mwmfax::mwmFaxSetFCLASS exit\n");  }


  return 0;
}


/*****************************************************************************/
/*                                                                           */
/* ClassX To Discrim                                                         */
/*                                                                           */
/* Switch from current class to the discrim state (or the dial state if we   */
/* got an ATD...;).                                                          */
/*                                                                           */
/*****************************************************************************/
ULONG mwmFaxClassXToDiscrim(PMWM_DSPINFO pmwmDspInfo, USHORT usCurClass)
{
  ULONG ulRC;
  USHORT usSubclass = 0;                                     //$3 begin

  { MW_SYSLOG_1(TRACE_MWMLW32,"mwmfax::mwmFaxClassXToDiscrim entry\n");  }


  DPF("mwmFaxClassXtoDiscrim: usCurClass=%d ulDiscrimState=%d\n",usCurClass,pmwmDspInfo->ulDiscrimState);

  if (pmwmDspInfo->ulFeaturesToLoad & FEATURE_V80)
  {
    ulRC = mwmV80LGetSUBCLASS(pmwmDspInfo, &usSubclass);     //$E
    if (ulRC!=DSP_NOERROR)
    {
      return(ulRC);
    }
  }                                                          //$3 end

  switch (usCurClass)
  {
     case 0:

        /*********************************************************************/
        /*  Data mode                                                        */
        /*    if in discrim state                                            */
        /*      if !slimbase                                                 */
        /*        Call AnywhereToDiscrim                                     */
        /*    else                                                           */
        /*      if not v.80 mode                                           $3*/
        /*        Call ModemToDial                                           */
        /*      else                                                       $3*/
        /*        Call V80ToDial                                           $3*/
        /*********************************************************************/
        if(pmwmDspInfo->ulDiscrimState)
        {
           if (!(pmwmDspInfo->ulFeaturesToLoad & FEATURE_SLIMBASE))
           {
             ulRC = mwmAnywhereToDiscrim(pmwmDspInfo);
             if (ulRC)
               return ulRC;

             if (usSubclass == 1) //$B if v.80 mode
             {
               ulRC = mwmLoadDialToDiscrim(pmwmDspInfo);
               if (ulRC != DSP_NOERROR)
               {
                 return ulRC;
               }
             }

           }
        }
        else       /* This is that funky change mode after ATD; */
        {
          /****************************************************
          ** Call mwmLoadModemToDial even if in V.80 mode
          ** so that the data pumps get unloaded.   03/14/97 DR
          *****************************************************/
          ulRC = mwmLoadModemToDial(pmwmDspInfo);
          if (ulRC != DSP_NOERROR) {
            return ulRC;
          } /* endif */

          /****************************************************
          ** No call the V.80-specific routine for unloading
          ** the V.80 stuff.                    03/14/97 DR
          *****************************************************/
          if (usSubclass == 1) {
            ulRC = mwmV80LAnywhereV80ToDial(pmwmDspInfo);     //$E
            if (ulRC != DSP_NOERROR) {
              return ulRC;
            }
          } /* endif */
        }

        if (usSubclass == 1) {                          //$B if v.80 mode
          ulRC = mwmFaxClassxDiscrimToDiscrim(pmwmDspInfo, 0);
          if (ulRC != DSP_NOERROR)
          {
            return ulRC;
          }
        }

        break;
     case 1:
        /*********************************************************************/
        /*  Class 1 fax                                                      */
        /*    if  in discrim state                                           */
        /*      if !slimbase                                                 */
        /*        Call Class1ToDial                                          */
        /*        Call DialToDiscrim                                         */
        /*    else                                                           */
        /*       Call Class1ToDial                                           */
        /*    Call ClassxDiscrimToDiscrim                                    */
        /*********************************************************************/
        if(pmwmDspInfo->ulDiscrimState)
        {
           if (!(pmwmDspInfo->ulFeaturesToLoad & FEATURE_SLIMBASE))
           {
             ulRC = mwmFaxClass1ToDial(pmwmDspInfo);
             if (ulRC != DSP_NOERROR)
             {
               return ulRC;
             }

             ulRC = mwmLoadDialToDiscrim(pmwmDspInfo);
             if (ulRC != DSP_NOERROR)
             {
               return ulRC;
             }
           }

        }
        else    /* change mode after ATD; */
        {
           ulRC = mwmFaxClass1ToDial(pmwmDspInfo);
           if (ulRC != DSP_NOERROR)
           {
             return ulRC;
           }

        }

        ulRC = mwmFaxClassxDiscrimToDiscrim(pmwmDspInfo, 1);
        if (ulRC != DSP_NOERROR)
        {
          return ulRC;
        }
        break;
     case 2:
        /*********************************************************************/
        /*  Class 2 fax                                                      */
        /*    if  in discrim state                                           */
        /*      if !slimbase                                                 */
        /*        Call Class2ToDial                                          */
        /*        Call DialToDiscrim                                         */
        /*    else                                                           */
        /*       Call Class2ToDial                                           */
        /*    Call ClassxDiscrimToDiscrim                                    */
        /*********************************************************************/
        if(pmwmDspInfo->ulDiscrimState)
        {
           if (!(pmwmDspInfo->ulFeaturesToLoad & FEATURE_SLIMBASE))
           {
             ulRC = mwmFaxClass2ToDial(pmwmDspInfo);
             if (ulRC != DSP_NOERROR)
             {
               return ulRC;
             }

             ulRC = mwmLoadDialToDiscrim(pmwmDspInfo);
             if (ulRC != DSP_NOERROR)
             {
               return ulRC;
             }
           }

        }
        else    /* change mode after ATD; */
        {
           ulRC = mwmFaxClass2ToDial(pmwmDspInfo);
           if (ulRC != DSP_NOERROR)
           {
             return ulRC;
           }
        }

        ulRC = mwmFaxClassxDiscrimToDiscrim(pmwmDspInfo, 2);
        if (ulRC != DSP_NOERROR)
        {
          return ulRC;
        }
        break;
    /***************************************************************/
    /*  ?                                                          */
    /***************************************************************/
     default:
        DPF("Error - Current FCLASS = %hd", usCurClass );
        mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                       MWM_DEBUG_MESSAGE, (ULONG) "FCLASS=?");
        return 1;
  }

  { MW_SYSLOG_1(TRACE_MWMLW32,"mwmfax::mwmFaxClassXToDiscrim exit\n");  }


  return 0;
}


ULONG mwmFaxReceivedFCLASS0(PMWM_DSPINFO pmwmDspInfo)
{
  ULONG   ulRC;
  USHORT  usFCLASS;
  USHORT  usSubMode;
  BOOL    bCallerIDLoaded = FALSE;


  { MW_SYSLOG_1(TRACE_MWMLW32,"mwmfax::mwmFaxReceivedFCLASS0 entry\n");  }


  /***************************************************************************/
  /* 10/14/95 Redesign Fax/Data Mode switching to allow for class 1          */
  /* Put modem in class 0 mode.                                              */
  /*                                                                         */
  /* - Find out which mode we are currently in (0,1,2) by getting FCLASS     */
  /*                                                                         */
  /* if Class0, do nothing....return...                                      */
  /* call ClassXToDiscrim                                                    */
  /*                                                                         */
  /* Modem should now be in discrim state, or if an ATD ...; was issued,     */
  /* it will be in Dial State.  If in Dial state, then we will load the      */
  /* Async or Class1 with Class2 with no problem.                            */
  /* We must allow the dial state to remain intact so that                   */
  /* AT+FCLASS=2                                                             */
  /* ATD...;                                                                 */
  /* AT+FCLASS=0                                                             */
  /* will work properly.                                                     */
  /*                                                                         */
  /* Now we might need to load the rest of the data mode code...             */
  /*                                                                         */
  /* if !slimbase or we have received ATD....;(ulDiscrimState==0)            */
  /*   Call DialToClass2                                                     */
  /***************************************************************************/
  ulRC = mwmFaxGetFCLASS(pmwmDspInfo, &usFCLASS, &usSubMode);
  if (ulRC!=DSP_NOERROR)
  {
    return(ulRC);
  }

  /***************************************************************************/
  /* Figure out where we are, then move to the discrim state or in the odd   */
  /* case of changing modes AFTER an ATD;, we will only try to go back to    */
  /* the dial state.                                                         */
  /***************************************************************************/
  if (usFCLASS != 0 || usSubMode == 1) //$D or v.80 mode
  {

    /***********************************************************
    ** Before swapping the Async tasks, in order to clean up
    ** the memory map a little, let's unload Call Progess,
    ** the Interpolators and the MDMDIALT segment temporarily.
    ************************************************************/
    if ( (!(pmwmDspInfo->ulFeaturesToLoad & FEATURE_SLIMBASE)) ||
         (!pmwmDspInfo->ulDiscrimState))
    {
      /***********************************
      ** Remove The Interpolator
      ************************************/
      if (pmwmDspInfo->hmodInterpolator !=0) //$E
      {
        ulRC = dspFreeModule(pmwmDspInfo->hmodInterpolator);
        if (ulRC!=DSP_NOERROR)
        {
          mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                         MWM_DSP_ERROR,
                         ulRC );
          return ulRC;
        }
        pmwmDspInfo->hinterpTask      = 0;
        pmwmDspInfo->hmodInterpolator = 0;
      }

      /***********************************
      ** Remove Call Progress.
      ************************************/
      if (pmwmDspInfo->hmodCallProg != 0) //$E
      {
        ulRC = dspFreeModule(pmwmDspInfo->hmodCallProg);
        if (ulRC!=DSP_NOERROR)
        {
          mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                         MWM_DSP_ERROR,
                         ulRC );
          return ulRC;
        }
        pmwmDspInfo->hmtCallProgMove = 0;
        pmwmDspInfo->hmtCallProg     = 0;
        pmwmDspInfo->hmodCallProg    = 0;
      }


      if (pmwmDspInfo->hsegMCTLDIALT != 0) //$E
      {
        ulRC = dspFreeSegment(pmwmDspInfo->hsegMCTLDIALT);
        if (ulRC)
        {
          mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                         MWM_DSP_ERROR,
                         ulRC);
          return(ulRC);
        }
        pmwmDspInfo->hsegMCTLDIALT = 0;
      }
    } /* endif */

    /*********************************************************************
    ** If Caller ID is loaded, unload it temporarily so that the memory
    ** map is cleaned up a bit before we load the Async module.
    **********************************************************************/
    if (pmwmDspInfo->hmodCALLERID) {
      mwmCidlLoad( pmwmDspInfo, 0 );
      bCallerIDLoaded = TRUE;
    } /* endif */

    ulRC = mwmFaxClassXToDiscrim(pmwmDspInfo, usFCLASS);
    if (ulRC != DSP_NOERROR)
    {
      return ulRC;
    }

    /*********************************************************************
    ** Now reload Caller ID if it was loaded.
    **********************************************************************/
    if (bCallerIDLoaded) {
      mwmCidlLoad( pmwmDspInfo, 1 );
    } /* endif */

    /*************************************************************************/
    /* Now the modem is either in data discrim, or data dial state.          */
    /* We may need to move to the modem state...if so, we will do that here. */
    /*************************************************************************/
    /* if !slimbase or we have received ATD....;(ulDiscrimState==0)          */
    /*   Call DialToModem                                                    */
    /*************************************************************************/
    if ( (!(pmwmDspInfo->ulFeaturesToLoad & FEATURE_SLIMBASE)) ||
       (!pmwmDspInfo->ulDiscrimState))
    {
      //if (pmwmDspInfo->ulDiscrimState)
      //{
        ulRC = mwmLoadDiscrimToDial(pmwmDspInfo);
        if (ulRC != DSP_NOERROR)
        {
          return ulRC;
        }
      //} else {

      ulRC = mwmLoadDialToModem(pmwmDspInfo);
      if (ulRC != DSP_NOERROR)
      {
        return ulRC;
      }
    }

    /*************************************************************************/
    /* Tell the parser and modem control that we are now in class 0 mode.    */
    /*************************************************************************/
    mwmParseSetParserMode(MWM_MODE_REGULAR_MODEM);

    ulRC = mwmFaxSetFCLASS(pmwmDspInfo, 0);
    if (ulRC!=DSP_NOERROR)
    {
      return(ulRC);
    }

  } /* if Not already in Class 0 mode */

  { MW_SYSLOG_1(TRACE_MWMLW32,"mwmfax::mwmFaxReceivedFCLASS0 exit\n");  }

  return 0;
}








ULONG mwmFaxReceivedFCLASS2(PMWM_DSPINFO pmwmDspInfo)
{
  ULONG   ulRC;
  USHORT  usFCLASS;
  USHORT  usSubMode;

  { MW_SYSLOG_1(TRACE_MWMLW32,"mwmfax::mwmFaxReceivedFCLASS2 entry\n");  }


  /***************************************************************************/
  /* 10/14/95 Redesign Fax/Data Mode switching to allow for class 1          */
  /* Put modem in class 2 mode.                                              */
  /*                                                                         */
  /* - Find out which mode we are currently in (0,1,2) by getting FCLASS     */
  /*                                                                         */
  /* if Class2, do nothing....return...                                      */
  /* Call ClassXToDiscrim                                                    */
  /*                                                                         */
  /* Modem should now be in discrim state, or if an ATD ...; was issued,     */
  /* it will be in Dial State.  In either case, we should be able to replace */
  /* Async or Class1 with Class2 with no problem.                            */
  /* We must allow the dial state to remain intact so that                   */
  /* AT+FCLASS=0                                                             */
  /* ATD...;                                                                 */
  /* AT+FCLASS=2                                                             */
  /* will work properly.                                                     */
  /*                                                                         */
  /* Now we must move to the appropriate class2 state.                       */
  /*                                                                         */
  /* Call DiscrimToClassxDiscrim                                             */
  /* if !slimbase or we have received ATD....;(ulDiscrimState==0)            */
  /*   Call DialToClass2                                                     */
  /***************************************************************************/
  ulRC = mwmFaxGetFCLASS(pmwmDspInfo, &usFCLASS, &usSubMode);
  if (ulRC!=DSP_NOERROR)
  {
    return(ulRC);
  }

  /***************************************************************************/
  /* Figure out where we are, then move to the discrim state or in the odd   */
  /* case of changing modes AFTER an ATD;, we will only try to go back to    */
  /* the dial state.                                                         */
  /***************************************************************************/
  if (usFCLASS != 2)
  {
    ulRC = mwmFaxClassXToDiscrim(pmwmDspInfo, usFCLASS);
    if (ulRC != DSP_NOERROR)
    {
      return ulRC;
    }

    /*************************************************************************/
    /* Now the modem is either in data discrim, or data dial state.          */
    /* From either of these states, the transition to class2 is possible.    */
    /*************************************************************************/
    /* Call DiscrimToClassxDiscrim                                           */
    /* if !slimbase or we have received ATD....;(ulDiscrimState==0)          */
    /*   Call DialToClass2                                                   */
    /*************************************************************************/
    ulRC = mwmFaxDiscrimToClassxDiscrim(pmwmDspInfo, 2);
    if (ulRC != DSP_NOERROR)
    {
      return ulRC;
    }

    if ( (!(pmwmDspInfo->ulFeaturesToLoad & FEATURE_SLIMBASE)) ||
       (!pmwmDspInfo->ulDiscrimState))
    {
      if (pmwmDspInfo->ulDiscrimState)
      {
        ulRC = mwmLoadDiscrimToDial(pmwmDspInfo);
        if (ulRC != DSP_NOERROR)
        {
          return ulRC;
        }
      }

      ulRC = mwmFaxDialToClass2(pmwmDspInfo);
      if (ulRC != DSP_NOERROR)
      {
        return ulRC;
      }
    }

    /*************************************************************************/
    /* Tell the parser and modem control that we are now in class 2 mode.    */
    /*************************************************************************/
    mwmParseSetParserMode(MWM_MODE_CLASS2_FAX);

    ulRC = mwmFaxSetFCLASS(pmwmDspInfo, 2);
    if (ulRC!=DSP_NOERROR)
    {
      return(ulRC);
    }

  } /* if Not already in Class 2 mode */

  { MW_SYSLOG_1(TRACE_MWMLW32,"mwmfax::mwmFaxReceivedFCLASS2 exit\n");  }

  return 0;
}



ULONG mwmFaxReceivedFCLASS1(PMWM_DSPINFO pmwmDspInfo)
{
  ULONG   ulRC;
  USHORT  usFCLASS;
  USHORT  usSubMode;

  { MW_SYSLOG_1(TRACE_MWMLW32,"mwmfax::mwmFaxReceivedFCLASS1 entry\n");  }

  /***************************************************************************/
  /* 11/17/95 Redesign Fax/Data Mode switching to allow for class 1          */
  /* Put modem in class 1 mode.                                              */
  /*                                                                         */
  /* - Find out which mode we are currently in (0,1,2) by getting FCLASS     */
  /*                                                                         */
  /* if Class1, do nothing....return...                                      */
  /* Call ClassXToDiscrim                                                    */
  /*                                                                         */
  /* Modem should now be in discrim state, or if an ATD ...; was issued,     */
  /* it will be in Dial State.  In either case, we should be able to replace */
  /* Async or Class1 with Class2 with no problem.                            */
  /* We must allow the dial state to remain intact so that                   */
  /* AT+FCLASS=0                                                             */
  /* ATD...;                                                                 */
  /* AT+FCLASS=1                                                             */
  /* will work properly.                                                     */
  /*                                                                         */
  /* Now we must move to the appropriate class1 state.                       */
  /*                                                                         */
  /* Call DiscrimToClassxDiscrim                                             */
  /* if !slimbase or we have received ATD....;(ulDiscrimState==0)            */
  /*   Call DialToClass1                                                     */
  /*   Call DialToClass1                                                     */
  /***************************************************************************/
  ulRC = mwmFaxGetFCLASS(pmwmDspInfo, &usFCLASS, &usSubMode);
  if (ulRC!=DSP_NOERROR)
  {
    return(ulRC);
  }
  /***************************************************************************/
  /* Figure out where we are, then move to the discrim state or in the odd   */
  /* case of changing modes AFTER an ATD;, we will only try to go back to    */
  /* the dial state.                                                         */
  /***************************************************************************/
  if (usFCLASS != 1)
  {
    ulRC = mwmFaxClassXToDiscrim(pmwmDspInfo, usFCLASS);
    if (ulRC != DSP_NOERROR)
    {
      return ulRC;
    }

    /*************************************************************************/
    /* Now the modem is either in data discrim, or data dial state.          */
    /* From either of these states, the transition to class1 is possible.    */
    /*************************************************************************/
    /* Call DiscrimToClassxDiscrim                                           */
    /* if !slimbase or we have received ATD....;(ulDiscrimState==0)          */
    /*   Call DiscrimToDial                                                  */
    /*   Call DialToClass1                                                   */
    /*************************************************************************/
    ulRC = mwmFaxDiscrimToClassxDiscrim(pmwmDspInfo, 1);
    if (ulRC != DSP_NOERROR)
    {
      return ulRC;
    }

    if ( (!(pmwmDspInfo->ulFeaturesToLoad & FEATURE_SLIMBASE)) ||
       (!pmwmDspInfo->ulDiscrimState))
    {
      if (pmwmDspInfo->ulDiscrimState)
      {
        ulRC = mwmLoadDiscrimToDial(pmwmDspInfo);
        if (ulRC != DSP_NOERROR)
        {
          return ulRC;
        }
      }

      ulRC = mwmFaxDialToClass1(pmwmDspInfo);
      if (ulRC != DSP_NOERROR)
      {
        return ulRC;
      }
    }

    /*************************************************************************/
    /* Tell the parser and modem control that we are now in class 1 mode.    */
    /* As far as the parser is concerned, we treat this "mode" as data.      */
    /* We want to avoid an extra jump table for class 1                      */
    /* Eventually, we would like to remove this in class 2 mode as well      */
    /*************************************************************************/
    mwmParseSetParserMode(MWM_MODE_REGULAR_MODEM);

    ulRC = mwmFaxSetFCLASS(pmwmDspInfo, 1);
    if (ulRC!=DSP_NOERROR)
    {
      return(ulRC);
    }

  } /* if Not already in Class 1 mode */

  { MW_SYSLOG_1(TRACE_MWMLW32,"mwmfax::mwmFaxReceivedFCLASS1 exit\n");  }


  return 0;
}





ULONG mwmFaxClass1ToDial(PMWM_DSPINFO pmwmDspInfo)
{

  ULONG   ulRC;
  USHORT  ausBuffer[128];
  char    achFaxDebugFile[_MAX_PATH];
  int     iSuccess;
  ULONG   ulAddress = 0;
  USHORT  usTraceBufAddress =0;
  FILE    *hTraceFile;
  int     i;
  USHORT  usOffsetPtr;

  { MW_SYSLOG_1(TRACE_MWMLW32,"mwmfax::mwmFaxClass1ToDial entry\n");  }


  DPF ("mwmFax Class 1 to Dial");

  /*****************************************************************************/
  /* Set the UART back down to 1                                               */
  /*****************************************************************************/
  if (pmwmDspInfo->usUARTMode & USE_UART)
  {
    USHORT usFailed;
    ulRC = mwmCntndSetUART(pmwmDspInfo, 1L*11000L/8L, MWM_MUSTHAVE,
                           &usFailed,szThisFile,__LINE__);
    if (usFailed)
      return ulRC;
  }




  /****************************************************************************/
  /*  MTS 5819 FAX01 DEBUG for traceput and statput                           */
  /****************************************************************************/

  iSuccess= GetPrivateProfileString("DEBUG","FAXTRACE", "NONE",achFaxDebugFile,
                                    sizeof(achFaxDebugFile), INIFile);
  if ((iSuccess == 0)||(!(strcmp("NONE",achFaxDebugFile))==0)) // file is specified in inifile
  {
    //  There IS a file in DEBUG section under TRACEPUT in mwmwin.ini

    ulRC = dspLabelToAddress(pmwmDspInfo->hmtCL1_HDLC,
                             "putorder",                // read ptr to address label
                             &ulAddress);

    if (ulRC)                                           // error in getting ptr to address
    {
      mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                     MWM_DSP_ERROR, ulRC);              // handle error
      return ulRC;
    }

    ulRC = dspMemTransfer(pmwmDspInfo->hDSP,ulAddress,
                          &usTraceBufAddress,1,
                          DSP_MEMXFER_DATA_READ);       // get pointer to address


    if (ulRC == DSP_NOERROR)                            // no error in address
    {

      hTraceFile = fopen(achFaxDebugFile, "w");         // open and overwrite fax trace file

      if (!hTraceFile)                                  // bad file
      {
        mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                       MWM_DSP_ERROR, ulRC);            // handle error
        return ulRC;
      }

      usOffsetPtr = ((usTraceBufAddress & 0x007F)/2);   // Get original offset ptr

      usTraceBufAddress &= 0xFF80;                      // Bitwise AND for
                                                        // start address
      ulRC = dspMemTransfer(pmwmDspInfo->hDSP,usTraceBufAddress,
                            ausBuffer,64,
                            DSP_MEMXFER_DATA_READ);     // get 64 words -> ausbuffer

      if (ulRC)                                         // if memtransfer failed
      {
        mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                       MWM_DSP_ERROR, ulRC);            // handle error
        return ulRC;
      }
                                                        // memtransfer passed

      fprintf(hTraceFile,"ordergpc");                   // print heading
      fprintf(hTraceFile,"\n");                         // put a return
      for (i=0; i<=127; i++)                            // do 128 times
      {
        fprintf(hTraceFile,"%04x",ausBuffer[i]);        // put hex value in ausbuffer
        if (i == usOffsetPtr)
          fprintf(hTraceFile,"|");                      // put | after offset
        else
          fprintf(hTraceFile," ");                      // put space everywhere else
        if ((i+1) % 8 == 0)                             // every 8 words
          fprintf(hTraceFile,"\n");                     // put a return
      }
      fprintf(hTraceFile,"\n");                         // space b/t each time executed
      fclose(hTraceFile);                               // close fax trace file
    }
    else                                                // else if error in
    {                                                   // label address
      mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                     MWM_DSP_ERROR, ulRC);              // handle error
      return ulRC;
    }

  }

  /***************************************************************************/
  /* Unload the first 2 Class 1 fax modules                                  */
  /***************************************************************************/
  ulRC = dspFreeModule(pmwmDspInfo->hmodCL1_HDLC);
  if (ulRC!=DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR,
                   ulRC );
    return ulRC;
  }
  pmwmDspInfo->hmodCL1_HDLC = 0;


  ulRC = dspFreeModule(pmwmDspInfo->hmodFAXPMP);
  if (ulRC!=DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR,
                   ulRC );
    return ulRC;
  }
  pmwmDspInfo->hmodFAXPMP = 0;

  /* 01/15/97 DR - Unload Silence Detection */
  ulRC = dspFreeModule(pmwmDspInfo->hmodSILDET);
  if (ulRC!=DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR,
                   ulRC );
    return ulRC;
  }
  pmwmDspInfo->hmodSILDET = 0;


  { MW_SYSLOG_1(TRACE_MWMLW32,"mwmfax::mwmFaxClass1ToDial exit\n");  }


  return 0;
}


ULONG mwmFaxDialToClass1(PMWM_DSPINFO pmwmDspInfo)
{

  ULONG  ulRC;
  ULONG  ulAddress = 0;
  USHORT usTempValue = 0;
  HMTASK hmtFAXPMP;
  HMTASK hmtSILDET;
  ULONG  ulDoLoadCL1_HDLC = 0;

  { MW_SYSLOG_1(TRACE_MWMLW32,"mwmfax::mwmFaxDialToClass1 entry\n");  }



  /***************************************************************************/
  /* Load the other 2 Class 1 DSP Modules.                                   */
  /***************************************************************************/
  if (!pmwmDspInfo->hmodCL1_HDLC)
  {
    ulDoLoadCL1_HDLC = 1;
    ulRC = mwmCntndLoadModule(pmwmDspInfo,"CL1_HDLC","CL1_HDLC",&pmwmDspInfo->hmodCL1_HDLC,szThisFile,__LINE__);
    if (ulRC)
      return(ulRC);


    /*************************************************************************/
    /* Get Task handles of the tasks.                                        */
    /*************************************************************************/
    ulRC = dspNameToTaskHandle(pmwmDspInfo->hmodCL1_HDLC, "CL1_HDLC", &pmwmDspInfo->hmtCL1_HDLC);
    if (ulRC)
    {
      mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                     MWM_DSP_ERROR,
                     ulRC );
      return (ulRC);
    }
  }

  ulRC = mwmCntndLoadModule(pmwmDspInfo,"FAXPMP","FAXPMP0",&pmwmDspInfo->hmodFAXPMP,szThisFile,__LINE__);
  if (ulRC)
    return(ulRC);

  ulRC = dspNameToTaskHandle(pmwmDspInfo->hmodFAXPMP, "FAXPMP", &hmtFAXPMP);
  if (ulRC)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR,
                   ulRC );
    return (ulRC);
  }

  /* 01/15/97 DR - Load Silence Detection module */
  ulRC = mwmCntndLoadModule(pmwmDspInfo,"SILENCEDET","SILDET",&pmwmDspInfo->hmodSILDET,szThisFile,__LINE__);
  if (ulRC)
    return(ulRC);

  /* 01/15/97 DR - Silence Detection task */
  ulRC = dspNameToTaskHandle(pmwmDspInfo->hmodSILDET, "SILDET", &hmtSILDET);
  if (ulRC)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR,
                   ulRC );
    return (ulRC);
  }


  /***************************************************************************/
  /*  BIOS.TAIO000..TAIO_OUTPUT CONNECT   FAXPMP..SIGINV21                   */
  /***************************************************************************/
  ulRC=mwmCntndConnectGPC(NULL,"TAIO_OUTPUT",hmtFAXPMP,"SIGINV21",0,NULL,
                          pmwmDspInfo, szThisFile,__LINE__ );
  if (ulRC)
    return(ulRC);



 /***************************************************************************/
 /*  BIOS.TAIO000..TAIO_OUTPUT CONNECT   FAXPMP..SIGINV21                   */
 /***************************************************************************/
 ulRC=mwmCntndConnectGPC(hmtFAXPMP,"RXDV21",pmwmDspInfo->hmtCL1_HDLC,"RV21GPC",0,NULL,
                         pmwmDspInfo, szThisFile,__LINE__ );
 if (ulRC)
   return(ulRC);

  /***************************************************************************/
  /* 01/15/97 DR                                                             */
  /*  BIOS.TAIO000..TAIO_OUTPUT CONNECT   SILDET..SD_INPUT                   */
  /***************************************************************************/
  ulRC=mwmCntndConnectGPC(NULL,"TAIO_OUTPUT",hmtSILDET,"SD_INPUT",0,NULL,
                          pmwmDspInfo, szThisFile,__LINE__ );
  if (ulRC)
    return(ulRC);




  /***************************************************************************/
  /*  BIOS.TAIO000..TAIO_OUTPUT CONNECT   FAXPMP..SIGIN                      */
  /***************************************************************************/
  ulRC=mwmCntndConnectGPC(NULL,"TAIO_OUTPUT",hmtFAXPMP,"SIGIN",0,NULL,
                          pmwmDspInfo, szThisFile,__LINE__ );
  if (ulRC)
    return(ulRC);



  /***************************************************************************/
  /*  FAXPMP..SIGOUT            CONNECT   BIOS.TAIO000..TAIO_INPUT           */
  /***************************************************************************/
  ulRC=mwmCntndConnectGPC(hmtFAXPMP,"SIGOUT",NULL,"TAIO_INPUT",0,NULL,
                          pmwmDspInfo, szThisFile,__LINE__ );
  if (ulRC)
    return(ulRC);


  /***************************************************************************/
  /*  FAXPMP..RECVDAT           CONNECT   HDLC..RDPGPC                       */
  /***************************************************************************/
  ulRC=mwmCntndConnectGPC(hmtFAXPMP,"RECVDAT",pmwmDspInfo->hmtCL1_HDLC,"RDPGPC",0,NULL,
                          pmwmDspInfo, szThisFile,__LINE__ );
  if (ulRC)
    return(ulRC);


  /***************************************************************************/
  /*  FAXPMP..RECVDAT           CONNECT   HDLC..RDPGPC                       */
  /***************************************************************************/
  ulRC=mwmCntndConnectGPC(pmwmDspInfo->hmtCL1_HDLC,"XDPGPC",hmtFAXPMP,"XMITDATA",0,NULL,
                          pmwmDspInfo, szThisFile,__LINE__ );
  if (ulRC)
    return(ulRC);


  if (ulDoLoadCL1_HDLC)
  {
    /*************************************************************************/
    /*  CLASS1..XIMGPC            CONNECT   MHINT..XIMGPC                    */
    /* Changed for class 1.../                                               */
    /*************************************************************************/
    ulRC=mwmCntndConnectGPC(pmwmDspInfo->hmtCLASSx,"XIMGPC",pmwmDspInfo->hmtCL1_HDLC,"XIMGPC",0,NULL,
                            pmwmDspInfo, szThisFile,__LINE__ );
    if (ulRC)
      return(ulRC);
    /*************************************************************************/
    /*  CL1_HDLC..RIMGPC             CONNECT   CLASS1..RIMGPC                */
    /*************************************************************************/
    ulRC=mwmCntndConnectGPC(pmwmDspInfo->hmtCL1_HDLC,"RIMGPC",pmwmDspInfo->hmtCLASSx,"RIMGPC",0,NULL,
                            pmwmDspInfo, szThisFile,__LINE__ );
    if (ulRC)
      return(ulRC);
  }




  /***************************************************************************/
  /***************************************************************************/
  /* Connect FAX Datapump ITCBs                                              */
  /***************************************************************************/
  /***************************************************************************/
  /*  BIOS.TAIO000..TAIOITCB    CONNECT  FAXMAN..SECTAIO                     */
  /***************************************************************************/



  /***************************************************************************/
  /*  BIOS.TAIO000..WTITCB      CONNECT  FAXPMP..WTITCB ;FAXPMP WT INTFC     */
  /***************************************************************************/
  ulRC=dspConnectITCB(NULL,"WTITCB",hmtFAXPMP,"WTITCB");
  if (ulRC != DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR, ulRC);
    return(ulRC);
  }

  ulRC=dspConnectITCB(hmtFAXPMP,"FCTLITCB",pmwmDspInfo->hmctlTask,"FCTLITCB");
  if (ulRC != DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR, ulRC);
    return(ulRC);
  }




  if (ulDoLoadCL1_HDLC)
  {
    ulRC=dspConnectITCB(pmwmDspInfo->hmtCLASSx,"C1HITCB",pmwmDspInfo->hmtCL1_HDLC,"C1HITCB");
    if (ulRC != DSP_NOERROR)
    {
      mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                     MWM_DSP_ERROR, ulRC);
      return(ulRC);
    }

    ulRC=dspConnectITCB(pmwmDspInfo->hmtCL1_HDLC,"CL1_MCTL",pmwmDspInfo->hmctlTask,"CL1_MCTL");
    if (ulRC != DSP_NOERROR)
    {
      mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                     MWM_DSP_ERROR, ulRC);
      return(ulRC);
    }

    /* 01/15/97 DR - Connect Silence Detect Task ITCB */
    ulRC=dspConnectITCB( hmtSILDET,"SDFAX",
                         pmwmDspInfo->hmtCL1_HDLC,"SDITCB" );
    if (ulRC != DSP_NOERROR)
    {
      mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                     MWM_DSP_ERROR, ulRC);
      return(ulRC);
    }
  }


  /***************************************************************************/
  /*  FAXPMP..FCTLITCB          CONNECT  CL1_HDLC..SECFCTL                   */
  /***************************************************************************/
  ulRC=dspConnectITCB(hmtFAXPMP,"FCTLITCB",pmwmDspInfo->hmtCL1_HDLC,"SECFCTL");
  if (ulRC != DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR, ulRC);
    return(ulRC);
  }


  /***************************************************************************/
  /*  FAXPMP..CPITCB            CONNECT  FAXMAN..SECCP                       */
  /***************************************************************************/
//  02/11/97 - DR - Call Progress ITCB no longer needed with the Silence
//                  Detect task.
//  ulRC=dspConnectITCB(pmwmDspInfo->hmtCallProg,"CPITCB",pmwmDspInfo->hmtCL1_HDLC,"CPITCB");
//  if (ulRC != DSP_NOERROR)
//  {
//    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
//                   MWM_DSP_ERROR, ulRC);
//    return(ulRC);
//  }




  /***************************************************************************/
  /* Activate the Fax Modules                                                */
  /***************************************************************************/
  if (ulDoLoadCL1_HDLC)
  {
     ulRC = dspChangeModuleState(pmwmDspInfo->hmodCL1_HDLC, DSP_ACTIVATE_ACTIVE );
     if (ulRC != DSP_NOERROR)
     {
       mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                      MWM_DSP_ERROR, ulRC);
       return(ulRC);
     }
   }

   ulRC = dspChangeModuleState(pmwmDspInfo->hmodFAXPMP, DSP_ACTIVATE_ACTIVE );
   if (ulRC != DSP_NOERROR)
   {
     mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                    MWM_DSP_ERROR, ulRC);
     return(ulRC);
   }

  /* 01/15/97 DR - Activate Silence Detection */
   ulRC = dspChangeModuleState(pmwmDspInfo->hmodSILDET, DSP_ACTIVATE_ACTIVE );
   if (ulRC != DSP_NOERROR)
   {
     mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                    MWM_DSP_ERROR, ulRC);
     return(ulRC);
   }


  /*****************************************************************************/
  /* Set the UART up to 3 no matter what type of connection.                   */
  /*****************************************************************************/
  if (pmwmDspInfo->usUARTMode & USE_UART)
  {
    USHORT usFailed;
    ulRC = mwmCntndSetUART(pmwmDspInfo, 3L*11000L/8L, MWM_MUSTHAVE,
                           &usFailed,szThisFile,__LINE__);
    if (usFailed)
      return ulRC;
  }


  /*********************************************************************/
  /* Write LOADDONE So that the Modem can continue negotiating.        */
  /*********************************************************************/
  ulRC = dspLabelToAddress(pmwmDspInfo->hmctlTask, "LOADDONE", &ulAddress);
  if (ulRC!=DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR, ulRC);
    return(ulRC);
  }

  usTempValue = 1;

  ulRC = dspMemTransfer(pmwmDspInfo->hDSP, ulAddress,
                        &usTempValue, 1,
                        DSP_MEMXFER_DATA_WRITE);
  if (ulRC!=DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR, ulRC);
    return(ulRC);
  }

  if (pmwmDspInfo->ulFeaturesToLoad & FEATURE_GETSIZE)
  {
    (*pfnWriteDSPSnapshot)(pmwmDspInfo->hDSP,"class1.snp");
  }

  { MW_SYSLOG_1(TRACE_MWMLW32,"mwmfax::mwmFaxDialToClass1 exit\n");  }


  return 0;
}










ULONG mwmFaxClassxDiscrimToDiscrim(PMWM_DSPINFO pmwmDspInfo, USHORT usClass)
{
  ULONG ulRC;
  USHORT usFCLASS = 1;    //$B
  USHORT usSubMode = 0;   //$B

  { MW_SYSLOG_1(TRACE_MWMLW32,"mwmfax::mwmFaxClassxDiscrimToDiscrim entry\n");  }


  DPF("mwmFaxClassxDiscrimToDiscrim:  Class %hd Discrim to Discrim", usClass);

  /***************************************************************************/
  /* Put the UART Task in standby                                            */
  /***************************************************************************/
  ulRC = dspChangeTaskState(pmwmDspInfo->hmtUART, DSP_ACTIVATE_STANDBY);
  if (ulRC)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR,
                   ulRC );
    return (ulRC);
  }


  /***************************************************************************/
  /* Put Class x in Standby...                                               */
  /***************************************************************************/
  ulRC = dspChangeModuleState(pmwmDspInfo->hmodCLASSx, DSP_ACTIVATE_STANDBY);
  if (ulRC)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR,
                   ulRC );
    return (ulRC);
  }

  /***************************************************************************/
  /* Swap to the dummy Async ITCB                                            */
  /***************************************************************************/
  ulRC = mwmLoadSwapToDummyAsync(pmwmDspInfo);
  if (ulRC)
    return ulRC;


  ulRC = dspFreeModule(pmwmDspInfo->hmodCLASSx);
  if (ulRC!=DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR,
                   ulRC );
    return ulRC;
  }
  pmwmDspInfo->hmodCLASSx = 0;
  pmwmDspInfo->hmtCLASSx  = 0;


  if (pmwmDspInfo->ulFeaturesToLoad & FEATURE_V80)      //$B
  {
    ulRC = mwmFaxGetFCLASS(pmwmDspInfo, &usFCLASS, &usSubMode);
    if (ulRC!=DSP_NOERROR)
    {
      return(ulRC);
    }
  }

  if (usFCLASS == 0 && usSubMode == 1)                  //$B
  {
    /***************************************************************************/
    /* Reset the V80 mode indicator (SUBCLASS = 0)                             */
    /***************************************************************************/
    ulRC = mwmV80LSetSUBCLASS(pmwmDspInfo, 0);  // we're out of v.80 mode now  $E
    if (ulRC!=DSP_NOERROR)
    {
      return(ulRC);
    }
    /***************************************************************************/
    /* Reset CISEND for v.8 to tell it not to send CI (and not to init v.21)   */
    /***************************************************************************/
    ulRC = mwmV80LSetCISEND(pmwmDspInfo, 0);            //$E
    if (ulRC!=DSP_NOERROR)
    {
      return ulRC;
    }

    /***************************************************************************/
    /* Re-enable FEATURE_V42 if it was enabled before we entry v.80 mode   $F*/
    /***************************************************************************/
    if (pmwmDspInfo->ulLongTermFeatures & FEATURE_V42)
      pmwmDspInfo->ulFeaturesToLoad |= FEATURE_V42;
    /***************************************************************************/
    /* Re-enable FEATURE_MNP if it was enabled before we entry v.80 mode   $F*/
    /***************************************************************************/
    if (pmwmDspInfo->ulLongTermFeatures & FEATURE_MNP)
      pmwmDspInfo->ulFeaturesToLoad |= FEATURE_MNP;

    ulRC = mwmSpcfcSetFeatures(pmwmDspInfo, 1);
    if (ulRC)
    {
      return (ulRC);
    }

  }

  /***************************************************************************/
  /* Load the Async Module.                                                  */
  /***************************************************************************/
  ulRC = mwmCntndLoadModule(pmwmDspInfo,"ASYNC","ASYNC",&pmwmDspInfo->hmodAsync,szThisFile,__LINE__);
  if (ulRC)
    return(ulRC);

  /***************************************************************************/
  /* Get the Async Task Handle                                               */
  /***************************************************************************/
  ulRC = dspNameToTaskHandle(pmwmDspInfo->hmodAsync, "ASYNC", &pmwmDspInfo->hasyTask);
  if (ulRC)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR,
                   ulRC );
    return (ulRC);
  }


  /***************************************************************************/
  /* MTS 5143                                                                */
  /* Free the Async Extra Segments before loading anything else              */
  /***************************************************************************/
  ulRC = dspNameToSegmentHandle(pmwmDspInfo->hasyTask,
                                "ECMPROC",
                                &pmwmDspInfo->hsegAsyncECMPROC);
  if (ulRC)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR,
                   ulRC);
    return(ulRC);
  }


  ulRC = dspFreeSegment(pmwmDspInfo->hsegAsyncECMPROC);
  if (ulRC)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR,
                   ulRC);
    return(ulRC);
  }
  pmwmDspInfo->hsegAsyncECMPROC = 0;


  /***************************************************************************/
  /* Free the Async Extra Segments before loading anything else              */
  /***************************************************************************/
  ulRC = dspNameToSegmentHandle(pmwmDspInfo->hasyTask,
                                "ACMPROC",
                                &pmwmDspInfo->hsegAsyncACMPROC);
  if (ulRC)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR,
                   ulRC);
    return(ulRC);
  }


  ulRC = dspFreeSegment(pmwmDspInfo->hsegAsyncACMPROC);
  if (ulRC)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR,
                   ulRC);
    return(ulRC);
  }
  pmwmDspInfo->hsegAsyncACMPROC = 0;




  /***************************************************************************/
  /* ITCB Connections                                                        */
  /***************************************************************************/
  /***************************************************************************/
  ulRC=dspConnectITCB(pmwmDspInfo->hasyTask,"ASYNITCB",pmwmDspInfo->hmctlTask,"ASYNITCB");
  if (ulRC != DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR, ulRC);
    return(ulRC);
  }


  /***************************************************************************/
  /*    ASYNC..ATCMD              CONNECT   MCTL..ATCMD                      */
  /***************************************************************************/
  ulRC=mwmCntndConnectGPC(pmwmDspInfo->hasyTask,"ATCMD",pmwmDspInfo->hmctlTask,"ATCMD",0,NULL,
                          pmwmDspInfo, szThisFile,__LINE__ );
  if (ulRC)
    return(ulRC);


  /***************************************************************************/
  /*    MCTL..ATRESP              CONNECT   ASYNC..ATRESP                    */
  /***************************************************************************/
  ulRC=mwmCntndConnectGPC(pmwmDspInfo->hmctlTask,"ATRESP",pmwmDspInfo->hasyTask,"ATRESP",0,NULL,
                          pmwmDspInfo, szThisFile,__LINE__ );
  if (ulRC)
    return(ulRC);






  /***************************************************************************/
  /* Swap from the Dummy Async to the ASYNC ITCB                             */
  /***************************************************************************/
  ulRC = mwmLoadSwapToRealAsync(pmwmDspInfo);
  if (ulRC)
    return ulRC;



  /***************************************************************************/
  /* Activate the ASYNC Module                                               */
  /***************************************************************************/
   ulRC = dspChangeModuleState(pmwmDspInfo->hmodAsync, DSP_ACTIVATE_ACTIVE );
   if (ulRC != DSP_NOERROR)
   {
     mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                    MWM_DSP_ERROR, ulRC);
     return(ulRC);
   }

  /***************************************************************************/
  /* Activate the UART Task                                                  */
  /***************************************************************************/
  ulRC = dspChangeTaskState(pmwmDspInfo->hmtUART, DSP_ACTIVATE_ACTIVE);
  if (ulRC)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR,
                   ulRC );
    return (ulRC);
  }


//  if (usClass == 2 )
//  {
//     /***************************************************************************/
//     /* 01/25/96                                                                */
//     /* Unload the Class 2 segment before continuing.                           */
//     /***************************************************************************/
//     ulRC = dspFreeSegment(pmwmDspInfo->hsegMCTLFAX00);
//     if (ulRC)
//     {
//       mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
//                      MWM_DSP_ERROR,
//                      ulRC);
//       return(ulRC);
//     }
//     pmwmDspInfo->hsegMCTLFAX00 = 0;
//  }


  /***************************************************************************/
  /* 11/20/96  Class 2 Restructure.                                          */
  /*    Class 2 will now use the same segment as class 1                     */
  /***************************************************************************/
  if ((usClass == 1) || (usClass == 2))
  {
     /***************************************************************************/
     /* 01/16/96                                                                */
     /* Unload the Class 1 segment before continuing.                           */
     /***************************************************************************/
     ulRC = dspFreeSegment(pmwmDspInfo->hsegMCTLSUBS1);
     if (ulRC)
     {
       mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                      MWM_DSP_ERROR,
                      ulRC);
       return(ulRC);
     }
     pmwmDspInfo->hsegMCTLSUBS1 = 0;
  }

  { MW_SYSLOG_1(TRACE_MWMLW32,"mwmfax::mwmFaxClassxDiscrimToDiscrim exit\n");  }


  return 0;
}

ULONG mwmFaxDiscrimToClassxDiscrim(PMWM_DSPINFO pmwmDspInfo, USHORT usClass)
{
  ULONG ulRC;
  ULONG ulAddress;
  char  *pszCLASSx;

  { MW_SYSLOG_1(TRACE_MWMLW32,"mwmfax::mwmFaxDiscrimToClassxDiscrim entry\n");  }


  DPF("mwmFaxDiscrimToClassxDiscrim:  Discrim to Class %hd Discrim", usClass);

  if (usClass == 1)
     pszCLASSx = "CLASS1";
  else if (usClass == 2)
     pszCLASSx = "CLASS2";
  else
  {
     mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                    MWM_DEBUG_MESSAGE, (ULONG)"FCLASS=?");
     return 1;
  }

  /***************************************************************************/
  /* Put the UART Task in standby                                            */
  /***************************************************************************/
  ulRC = dspChangeTaskState(pmwmDspInfo->hmtUART, DSP_ACTIVATE_STANDBY);
  if (ulRC)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR,
                   ulRC );
    return (ulRC);
  }

    /***************************************************************************/
    /* Put Async in Standby...                                                 */
    /***************************************************************************/
    ulRC = dspChangeModuleState(pmwmDspInfo->hmodAsync, DSP_ACTIVATE_STANDBY);
    if (ulRC)
    {
      mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                     MWM_DSP_ERROR,
                     ulRC );
      return (ulRC);
    }

    /***************************************************************************/
    /* Swap to the dummy Async ITCB                                            */
    /***************************************************************************/
    ulRC = mwmLoadSwapToDummyAsync(pmwmDspInfo);
    if (ulRC)
      return ulRC;


    ulRC = dspFreeModule(pmwmDspInfo->hmodAsync);
    if (ulRC!=DSP_NOERROR)
    {
      mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                     MWM_DSP_ERROR,
                     ulRC );
      return ulRC;
    }
    pmwmDspInfo->hmodAsync = 0;
    pmwmDspInfo->hasyTask = 0;


  /***************************************************************************/
  /* Load the Class x Async Replacement.                                     */
  /***************************************************************************/
  ulRC = mwmCntndLoadModule(pmwmDspInfo,pszCLASSx,pszCLASSx,&pmwmDspInfo->hmodCLASSx,szThisFile,__LINE__);
  if (ulRC)
    return(ulRC);

  /***************************************************************************/
  /* Get the CLASSx Task Handle                                              */
  /***************************************************************************/
  ulRC = dspNameToTaskHandle(pmwmDspInfo->hmodCLASSx, pszCLASSx, &pmwmDspInfo->hmtCLASSx);
  if (ulRC)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR,
                   ulRC );
    return (ulRC);
  }




  /***************************************************************************/
  /*    CLASSx..ATCMD             CONNECT   MCTL..ATCMD                      */
  /***************************************************************************/
  ulRC=mwmCntndConnectGPC(pmwmDspInfo->hmtCLASSx,"ATCMD",pmwmDspInfo->hmctlTask,"ATCMD",0,NULL,
                          pmwmDspInfo, szThisFile,__LINE__ );
  if (ulRC)
    return(ulRC);


  /***************************************************************************/
  /*    MCTL..ATRESP              CONNECT   CLASSx..ATRESP                   */
  /***************************************************************************/
  ulRC=mwmCntndConnectGPC(pmwmDspInfo->hmctlTask,"ATRESP",pmwmDspInfo->hmtCLASSx,"ATRESP",0,NULL,
                          pmwmDspInfo, szThisFile,__LINE__ );
  if (ulRC)
    return(ulRC);


  /***************************************************************************/
  /*  CLASSx..ASYNITCB          CONNECT  MCTL..ASYNITCB                      */
  /***************************************************************************/
  ulRC=dspConnectITCB(pmwmDspInfo->hmtCLASSx,"ASYNITCB",pmwmDspInfo->hmctlTask,"ASYNITCB");
  if (ulRC != DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR, ulRC);
    return(ulRC);
  }

  if (usClass == 2)
  {
     /************************************************************************/
     /*  CLASSx..C2ITCB            CONNECT  MCTL..C2ITCB                     */
     /************************************************************************/
     ulRC=dspConnectITCB(pmwmDspInfo->hmtCLASSx,"C2ITCB",pmwmDspInfo->hmctlTask,"C2ITCB");
     if (ulRC != DSP_NOERROR)
     {
       mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                      MWM_DSP_ERROR, ulRC);
       return(ulRC);
     }
  }
  if (usClass == 1)
  {
     /************************************************************************/
     /*  CLASSx..C1ITCB            CONNECT  MCTL..C1ITCB                     */
     /************************************************************************/
     ulRC=dspConnectITCB(pmwmDspInfo->hmtCLASSx,"C1ITCB",pmwmDspInfo->hmctlTask,"C1ITCB");
     if (ulRC != DSP_NOERROR)
     {
       mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                      MWM_DSP_ERROR, ulRC);
       return(ulRC);
     }
  }
  if (usClass == 1)
  {
     /***************************************************************************/
     /*  CLASSx..OEITCB            CONNECT  UART..OEITCB                        */
     /***************************************************************************/
     ulRC=dspConnectITCB(pmwmDspInfo->hmtCLASSx,"OEITCB",NULL,"OEITCB");
     if (ulRC != DSP_NOERROR)
     {
       mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                      MWM_DSP_ERROR, ulRC);
       return(ulRC);
     }
  }


  /***************************************************************************/
  /*  BIOS.UART000..UART_OUTPUT CONNECT   CLASSx..UART_OUTPUT                */
  /***************************************************************************/
  ulRC=mwmCntndConnectGPC(NULL,"UART_OUTPUT",pmwmDspInfo->hmtCLASSx,"UART_OUTPUT",0,NULL,
                          pmwmDspInfo, szThisFile,__LINE__ );
  if (ulRC)
    return(ulRC);


  /***************************************************************************/
  /*  CLASSx..UART_INPUT        CONNECT   BIOS.UART000..UART_INPUT           */
  /***************************************************************************/
  ulRC=mwmCntndConnectGPC(pmwmDspInfo->hmtCLASSx,"UART_INPUT",NULL,"UART_INPUT",0,NULL,
                          pmwmDspInfo, szThisFile,__LINE__ );
  if (ulRC)
    return(ulRC);


  /***************************************************************************/
  /* Activate the ASYNC Replacement.                                         */
  /***************************************************************************/
  ulRC = dspChangeModuleState(pmwmDspInfo->hmodCLASSx, DSP_ACTIVATE_ACTIVE );
  if (ulRC != DSP_NOERROR)
  {
     mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                    MWM_DSP_ERROR, ulRC);
     return(ulRC);
  }

  /***************************************************************************/
  /* Swap from the Dummy Async to the Class x ITCB                           */
  /***************************************************************************/
  ulRC = mwmLoadSwapToRealAsync(pmwmDspInfo);
  if (ulRC)
    return ulRC;



  /***************************************************************************/
  /* Activate the UART Task                                                  */
  /***************************************************************************/
  ulRC = dspChangeTaskState(pmwmDspInfo->hmtUART, DSP_ACTIVATE_ACTIVE);
  if (ulRC)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR,
                   ulRC );
    return (ulRC);
  }

  if (usClass == 2 )
  {
     /************************************************************************/
     /* Get the Address of the Class 2 Segment Pointer.                      */
     /************************************************************************/
     ulRC = dspLabelToAddress(pmwmDspInfo->hmctlTask, "PTR_CLASS2_SEG", &ulAddress);
     if (ulRC!=DSP_NOERROR)
     {
       mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                      MWM_DSP_ERROR, ulRC);
       return(ulRC);
     }

     /************************************************************************/
     /* 01/25/96                                                             */
     /* Dynamically load MCTLs FAX00 (Class 2) Segment                       */
     /************************************************************************/
     ulRC = mwmCntndLoadSegment(pmwmDspInfo,
                                "MAINFILE",
                                "MDMSUBS1",
                                "MDMSUBS1",
                                pmwmDspInfo->hmctlTask,
                                &pmwmDspInfo->hsegMCTLSUBS1,
                                ulAddress,
                                szThisFile , __LINE__, MWM_MUSTHAVE );
     if (ulRC)
       return (ulRC);
  }

  if (usClass == 1)
  {
     /************************************************************************/
     /* Get the Address of the Class 1 Segment Pointer.                      */
     /************************************************************************/
     ulRC = dspLabelToAddress(pmwmDspInfo->hmctlTask, "CLASS1_CSPTR", &ulAddress);
     if (ulRC!=DSP_NOERROR)
     {
       mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                      MWM_DSP_ERROR, ulRC);
       return(ulRC);
     }

     /************************************************************************/
     /* 01/16/96                                                             */
     /* Dynamically load MCTLs SUBS1 (Class 1) Segment                       */
     /************************************************************************/
     ulRC = mwmCntndLoadSegment(pmwmDspInfo,
                                "MAINFILE",
                                "MDMSUBS1",
                                "MDMSUBS1",
                                pmwmDspInfo->hmctlTask,
                                &pmwmDspInfo->hsegMCTLSUBS1,
                                ulAddress,
                                szThisFile , __LINE__, MWM_MUSTHAVE );
     if (ulRC)
       return (ulRC);
  }


  { MW_SYSLOG_1(TRACE_MWMLW32,"mwmfax::mwmFaxDiscrimToClassxDiscrim exit\n");  }


  return 0;
}

