// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package cluster

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// PostClusterOKCode is the HTTP code returned for type PostClusterOK
const PostClusterOKCode int = 200

/*
PostClusterOK Cluster settings changed

swagger:response postClusterOK
*/
type PostClusterOK struct {

	/*
	  In: Body
	*/
	Payload *models.ClusterSettings `json:"body,omitempty"`
}

// NewPostClusterOK creates PostClusterOK with default headers values
func NewPostClusterOK() *PostClusterOK {

	return &PostClusterOK{}
}

// WithPayload adds the payload to the post cluster o k response
func (o *PostClusterOK) WithPayload(payload *models.ClusterSettings) *PostClusterOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the post cluster o k response
func (o *PostClusterOK) SetPayload(payload *models.ClusterSettings) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *PostClusterOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// PostClusterBadRequestCode is the HTTP code returned for type PostClusterBadRequest
const PostClusterBadRequestCode int = 400

/*
PostClusterBadRequest Bad request

swagger:response postClusterBadRequest
*/
type PostClusterBadRequest struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewPostClusterBadRequest creates PostClusterBadRequest with default headers values
func NewPostClusterBadRequest() *PostClusterBadRequest {

	return &PostClusterBadRequest{}
}

// WithConfigurationVersion adds the configurationVersion to the post cluster bad request response
func (o *PostClusterBadRequest) WithConfigurationVersion(configurationVersion string) *PostClusterBadRequest {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the post cluster bad request response
func (o *PostClusterBadRequest) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the post cluster bad request response
func (o *PostClusterBadRequest) WithPayload(payload *models.Error) *PostClusterBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the post cluster bad request response
func (o *PostClusterBadRequest) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *PostClusterBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
PostClusterDefault General Error

swagger:response postClusterDefault
*/
type PostClusterDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewPostClusterDefault creates PostClusterDefault with default headers values
func NewPostClusterDefault(code int) *PostClusterDefault {
	if code <= 0 {
		code = 500
	}

	return &PostClusterDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the post cluster default response
func (o *PostClusterDefault) WithStatusCode(code int) *PostClusterDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the post cluster default response
func (o *PostClusterDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the post cluster default response
func (o *PostClusterDefault) WithConfigurationVersion(configurationVersion string) *PostClusterDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the post cluster default response
func (o *PostClusterDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the post cluster default response
func (o *PostClusterDefault) WithPayload(payload *models.Error) *PostClusterDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the post cluster default response
func (o *PostClusterDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *PostClusterDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
