// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package crt_load

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// DeleteCrtLoadAcceptedCode is the HTTP code returned for type DeleteCrtLoadAccepted
const DeleteCrtLoadAcceptedCode int = 202

/*
DeleteCrtLoadAccepted Configuration change accepted and reload requested

swagger:response deleteCrtLoadAccepted
*/
type DeleteCrtLoadAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`
}

// NewDeleteCrtLoadAccepted creates DeleteCrtLoadAccepted with default headers values
func NewDeleteCrtLoadAccepted() *DeleteCrtLoadAccepted {

	return &DeleteCrtLoadAccepted{}
}

// WithReloadID adds the reloadId to the delete crt load accepted response
func (o *DeleteCrtLoadAccepted) WithReloadID(reloadID string) *DeleteCrtLoadAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the delete crt load accepted response
func (o *DeleteCrtLoadAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WriteResponse to the client
func (o *DeleteCrtLoadAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(202)
}

// DeleteCrtLoadNoContentCode is the HTTP code returned for type DeleteCrtLoadNoContent
const DeleteCrtLoadNoContentCode int = 204

/*
DeleteCrtLoadNoContent Certificate load entry deleted

swagger:response deleteCrtLoadNoContent
*/
type DeleteCrtLoadNoContent struct {
}

// NewDeleteCrtLoadNoContent creates DeleteCrtLoadNoContent with default headers values
func NewDeleteCrtLoadNoContent() *DeleteCrtLoadNoContent {

	return &DeleteCrtLoadNoContent{}
}

// WriteResponse to the client
func (o *DeleteCrtLoadNoContent) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(204)
}

// DeleteCrtLoadNotFoundCode is the HTTP code returned for type DeleteCrtLoadNotFound
const DeleteCrtLoadNotFoundCode int = 404

/*
DeleteCrtLoadNotFound The specified resource was not found

swagger:response deleteCrtLoadNotFound
*/
type DeleteCrtLoadNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewDeleteCrtLoadNotFound creates DeleteCrtLoadNotFound with default headers values
func NewDeleteCrtLoadNotFound() *DeleteCrtLoadNotFound {

	return &DeleteCrtLoadNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the delete crt load not found response
func (o *DeleteCrtLoadNotFound) WithConfigurationVersion(configurationVersion string) *DeleteCrtLoadNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the delete crt load not found response
func (o *DeleteCrtLoadNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the delete crt load not found response
func (o *DeleteCrtLoadNotFound) WithPayload(payload *models.Error) *DeleteCrtLoadNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the delete crt load not found response
func (o *DeleteCrtLoadNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DeleteCrtLoadNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
DeleteCrtLoadDefault General Error

swagger:response deleteCrtLoadDefault
*/
type DeleteCrtLoadDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewDeleteCrtLoadDefault creates DeleteCrtLoadDefault with default headers values
func NewDeleteCrtLoadDefault(code int) *DeleteCrtLoadDefault {
	if code <= 0 {
		code = 500
	}

	return &DeleteCrtLoadDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the delete crt load default response
func (o *DeleteCrtLoadDefault) WithStatusCode(code int) *DeleteCrtLoadDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the delete crt load default response
func (o *DeleteCrtLoadDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the delete crt load default response
func (o *DeleteCrtLoadDefault) WithConfigurationVersion(configurationVersion string) *DeleteCrtLoadDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the delete crt load default response
func (o *DeleteCrtLoadDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the delete crt load default response
func (o *DeleteCrtLoadDefault) WithPayload(payload *models.Error) *DeleteCrtLoadDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the delete crt load default response
func (o *DeleteCrtLoadDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DeleteCrtLoadDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
