// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package dgram_bind

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// CreateDgramBindCreatedCode is the HTTP code returned for type CreateDgramBindCreated
const CreateDgramBindCreatedCode int = 201

/*
CreateDgramBindCreated Bind created

swagger:response createDgramBindCreated
*/
type CreateDgramBindCreated struct {

	/*
	  In: Body
	*/
	Payload *models.DgramBind `json:"body,omitempty"`
}

// NewCreateDgramBindCreated creates CreateDgramBindCreated with default headers values
func NewCreateDgramBindCreated() *CreateDgramBindCreated {

	return &CreateDgramBindCreated{}
}

// WithPayload adds the payload to the create dgram bind created response
func (o *CreateDgramBindCreated) WithPayload(payload *models.DgramBind) *CreateDgramBindCreated {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create dgram bind created response
func (o *CreateDgramBindCreated) SetPayload(payload *models.DgramBind) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateDgramBindCreated) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(201)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateDgramBindAcceptedCode is the HTTP code returned for type CreateDgramBindAccepted
const CreateDgramBindAcceptedCode int = 202

/*
CreateDgramBindAccepted Configuration change accepted and reload requested

swagger:response createDgramBindAccepted
*/
type CreateDgramBindAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`

	/*
	  In: Body
	*/
	Payload *models.DgramBind `json:"body,omitempty"`
}

// NewCreateDgramBindAccepted creates CreateDgramBindAccepted with default headers values
func NewCreateDgramBindAccepted() *CreateDgramBindAccepted {

	return &CreateDgramBindAccepted{}
}

// WithReloadID adds the reloadId to the create dgram bind accepted response
func (o *CreateDgramBindAccepted) WithReloadID(reloadID string) *CreateDgramBindAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the create dgram bind accepted response
func (o *CreateDgramBindAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WithPayload adds the payload to the create dgram bind accepted response
func (o *CreateDgramBindAccepted) WithPayload(payload *models.DgramBind) *CreateDgramBindAccepted {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create dgram bind accepted response
func (o *CreateDgramBindAccepted) SetPayload(payload *models.DgramBind) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateDgramBindAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.WriteHeader(202)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateDgramBindBadRequestCode is the HTTP code returned for type CreateDgramBindBadRequest
const CreateDgramBindBadRequestCode int = 400

/*
CreateDgramBindBadRequest Bad request

swagger:response createDgramBindBadRequest
*/
type CreateDgramBindBadRequest struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateDgramBindBadRequest creates CreateDgramBindBadRequest with default headers values
func NewCreateDgramBindBadRequest() *CreateDgramBindBadRequest {

	return &CreateDgramBindBadRequest{}
}

// WithConfigurationVersion adds the configurationVersion to the create dgram bind bad request response
func (o *CreateDgramBindBadRequest) WithConfigurationVersion(configurationVersion string) *CreateDgramBindBadRequest {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the create dgram bind bad request response
func (o *CreateDgramBindBadRequest) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the create dgram bind bad request response
func (o *CreateDgramBindBadRequest) WithPayload(payload *models.Error) *CreateDgramBindBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create dgram bind bad request response
func (o *CreateDgramBindBadRequest) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateDgramBindBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateDgramBindConflictCode is the HTTP code returned for type CreateDgramBindConflict
const CreateDgramBindConflictCode int = 409

/*
CreateDgramBindConflict The specified resource already exists

swagger:response createDgramBindConflict
*/
type CreateDgramBindConflict struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateDgramBindConflict creates CreateDgramBindConflict with default headers values
func NewCreateDgramBindConflict() *CreateDgramBindConflict {

	return &CreateDgramBindConflict{}
}

// WithConfigurationVersion adds the configurationVersion to the create dgram bind conflict response
func (o *CreateDgramBindConflict) WithConfigurationVersion(configurationVersion string) *CreateDgramBindConflict {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the create dgram bind conflict response
func (o *CreateDgramBindConflict) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the create dgram bind conflict response
func (o *CreateDgramBindConflict) WithPayload(payload *models.Error) *CreateDgramBindConflict {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create dgram bind conflict response
func (o *CreateDgramBindConflict) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateDgramBindConflict) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(409)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
CreateDgramBindDefault General Error

swagger:response createDgramBindDefault
*/
type CreateDgramBindDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateDgramBindDefault creates CreateDgramBindDefault with default headers values
func NewCreateDgramBindDefault(code int) *CreateDgramBindDefault {
	if code <= 0 {
		code = 500
	}

	return &CreateDgramBindDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the create dgram bind default response
func (o *CreateDgramBindDefault) WithStatusCode(code int) *CreateDgramBindDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the create dgram bind default response
func (o *CreateDgramBindDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the create dgram bind default response
func (o *CreateDgramBindDefault) WithConfigurationVersion(configurationVersion string) *CreateDgramBindDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the create dgram bind default response
func (o *CreateDgramBindDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the create dgram bind default response
func (o *CreateDgramBindDefault) WithPayload(payload *models.Error) *CreateDgramBindDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create dgram bind default response
func (o *CreateDgramBindDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateDgramBindDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
