// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package filter

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// GetFilterFrontendOKCode is the HTTP code returned for type GetFilterFrontendOK
const GetFilterFrontendOKCode int = 200

/*
GetFilterFrontendOK Successful operation

swagger:response getFilterFrontendOK
*/
type GetFilterFrontendOK struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Filter `json:"body,omitempty"`
}

// NewGetFilterFrontendOK creates GetFilterFrontendOK with default headers values
func NewGetFilterFrontendOK() *GetFilterFrontendOK {

	return &GetFilterFrontendOK{}
}

// WithConfigurationVersion adds the configurationVersion to the get filter frontend o k response
func (o *GetFilterFrontendOK) WithConfigurationVersion(configurationVersion string) *GetFilterFrontendOK {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get filter frontend o k response
func (o *GetFilterFrontendOK) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get filter frontend o k response
func (o *GetFilterFrontendOK) WithPayload(payload *models.Filter) *GetFilterFrontendOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get filter frontend o k response
func (o *GetFilterFrontendOK) SetPayload(payload *models.Filter) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetFilterFrontendOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(200)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// GetFilterFrontendNotFoundCode is the HTTP code returned for type GetFilterFrontendNotFound
const GetFilterFrontendNotFoundCode int = 404

/*
GetFilterFrontendNotFound The specified resource was not found

swagger:response getFilterFrontendNotFound
*/
type GetFilterFrontendNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetFilterFrontendNotFound creates GetFilterFrontendNotFound with default headers values
func NewGetFilterFrontendNotFound() *GetFilterFrontendNotFound {

	return &GetFilterFrontendNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the get filter frontend not found response
func (o *GetFilterFrontendNotFound) WithConfigurationVersion(configurationVersion string) *GetFilterFrontendNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get filter frontend not found response
func (o *GetFilterFrontendNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get filter frontend not found response
func (o *GetFilterFrontendNotFound) WithPayload(payload *models.Error) *GetFilterFrontendNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get filter frontend not found response
func (o *GetFilterFrontendNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetFilterFrontendNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
GetFilterFrontendDefault General Error

swagger:response getFilterFrontendDefault
*/
type GetFilterFrontendDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetFilterFrontendDefault creates GetFilterFrontendDefault with default headers values
func NewGetFilterFrontendDefault(code int) *GetFilterFrontendDefault {
	if code <= 0 {
		code = 500
	}

	return &GetFilterFrontendDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the get filter frontend default response
func (o *GetFilterFrontendDefault) WithStatusCode(code int) *GetFilterFrontendDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the get filter frontend default response
func (o *GetFilterFrontendDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the get filter frontend default response
func (o *GetFilterFrontendDefault) WithConfigurationVersion(configurationVersion string) *GetFilterFrontendDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get filter frontend default response
func (o *GetFilterFrontendDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get filter frontend default response
func (o *GetFilterFrontendDefault) WithPayload(payload *models.Error) *GetFilterFrontendDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get filter frontend default response
func (o *GetFilterFrontendDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetFilterFrontendDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
