// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package log_target

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// GetAllLogTargetDefaultsOKCode is the HTTP code returned for type GetAllLogTargetDefaultsOK
const GetAllLogTargetDefaultsOKCode int = 200

/*
GetAllLogTargetDefaultsOK Successful operation

swagger:response getAllLogTargetDefaultsOK
*/
type GetAllLogTargetDefaultsOK struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload models.LogTargets `json:"body,omitempty"`
}

// NewGetAllLogTargetDefaultsOK creates GetAllLogTargetDefaultsOK with default headers values
func NewGetAllLogTargetDefaultsOK() *GetAllLogTargetDefaultsOK {

	return &GetAllLogTargetDefaultsOK{}
}

// WithConfigurationVersion adds the configurationVersion to the get all log target defaults o k response
func (o *GetAllLogTargetDefaultsOK) WithConfigurationVersion(configurationVersion string) *GetAllLogTargetDefaultsOK {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get all log target defaults o k response
func (o *GetAllLogTargetDefaultsOK) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get all log target defaults o k response
func (o *GetAllLogTargetDefaultsOK) WithPayload(payload models.LogTargets) *GetAllLogTargetDefaultsOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get all log target defaults o k response
func (o *GetAllLogTargetDefaultsOK) SetPayload(payload models.LogTargets) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetAllLogTargetDefaultsOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(200)
	payload := o.Payload
	if payload == nil {
		// return empty array
		payload = models.LogTargets{}
	}

	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}
}

/*
GetAllLogTargetDefaultsDefault General Error

swagger:response getAllLogTargetDefaultsDefault
*/
type GetAllLogTargetDefaultsDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetAllLogTargetDefaultsDefault creates GetAllLogTargetDefaultsDefault with default headers values
func NewGetAllLogTargetDefaultsDefault(code int) *GetAllLogTargetDefaultsDefault {
	if code <= 0 {
		code = 500
	}

	return &GetAllLogTargetDefaultsDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the get all log target defaults default response
func (o *GetAllLogTargetDefaultsDefault) WithStatusCode(code int) *GetAllLogTargetDefaultsDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the get all log target defaults default response
func (o *GetAllLogTargetDefaultsDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the get all log target defaults default response
func (o *GetAllLogTargetDefaultsDefault) WithConfigurationVersion(configurationVersion string) *GetAllLogTargetDefaultsDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get all log target defaults default response
func (o *GetAllLogTargetDefaultsDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get all log target defaults default response
func (o *GetAllLogTargetDefaultsDefault) WithPayload(payload *models.Error) *GetAllLogTargetDefaultsDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get all log target defaults default response
func (o *GetAllLogTargetDefaultsDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetAllLogTargetDefaultsDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
